/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.properties;

import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicHierarchicalObject;
import com.intellij.database.model.meta.BasicMetaReference;
import com.intellij.database.model.meta.BasicMetaReferenceDesc;
import com.intellij.database.model.meta.BasicMetaReferenceId;
import com.intellij.database.model.meta.BasicMetaReferenceList;
import com.intellij.database.model.meta.BasicMetaReferenceListId;
import com.intellij.database.model.meta.BasicResolveAssistant;
import com.intellij.database.model.properties.BasicReference;
import com.intellij.database.model.properties.references.BasicReferenceInfoImpl;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface BasicReferenceInfo<T extends BasicElement> {
    @NotNull
    public BasicElement getSource();

    @NotNull
    public JBIterable<T> getTargets();

    @Nullable
    public T getTarget();

    @Nullable
    public T getInlineData();

    @Nullable
    public T getTargetOrInlineData();

    public T resolve();

    @NotNull
    public BasicMetaReferenceDesc<?, T> getReferenceDesc();

    @NotNull
    public BasicReference getReference();

    @Nullable
    public String getName();

    @Nullable
    public String getNameLighter();

    @Nullable
    public String getParentName(int var1);

    public boolean isEquivalent(@Nullable BasicReferenceInfo<?> var1);

    public boolean matches(@NotNull BasicElement var1);

    @NotNull
    public BasicReferenceInfo<T> with(@NotNull BasicReference var1);

    @NotNull
    public BasicReferenceInfo<T> withAssistant(@NotNull BasicResolveAssistant var1);

    @NotNull
    public <T2 extends BasicElement> BasicReferenceInfo<T2> dummyJoin(@NotNull BasicMetaReferenceDesc<T, T2> var1, @NotNull BasicReference var2);

    public <T2 extends BasicElement> BasicReferenceInfo<T2> tryCast(@NotNull Class<T2> var1);

    @NotNull
    public static <S extends BasicElement, T extends BasicElement> List<BasicReferenceInfo<T>> create(@NotNull S source, @NotNull BasicMetaReferenceListId<T> metaRefId, @NotNull List<BasicReference> ref2) {
        if (source == null) {
            BasicReferenceInfo.$$$reportNull$$$0(0);
        }
        if (metaRefId == null) {
            BasicReferenceInfo.$$$reportNull$$$0(1);
        }
        if (ref2 == null) {
            BasicReferenceInfo.$$$reportNull$$$0(2);
        }
        if (ref2.isEmpty()) {
            List<BasicReferenceInfo<T>> list = Collections.emptyList();
            if (list == null) {
                BasicReferenceInfo.$$$reportNull$$$0(3);
            }
            return list;
        }
        BasicMetaReferenceList metaRef = metaRefId.find(source);
        List list = metaRef == null ? Collections.emptyList() : ContainerUtil.map(ref2, r -> BasicReferenceInfo.create(source, metaRef.getReferenceDesc(), r));
        if (list == null) {
            BasicReferenceInfo.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Nullable
    public static <S extends BasicElement, T extends BasicElement> BasicReferenceInfo<T> create(@NotNull S source, @NotNull BasicMetaReferenceId<T> metaRefId, @Nullable BasicReference ref2) {
        if (source == null) {
            BasicReferenceInfo.$$$reportNull$$$0(5);
        }
        if (metaRefId == null) {
            BasicReferenceInfo.$$$reportNull$$$0(6);
        }
        if (ref2 == null) {
            return null;
        }
        return BasicReferenceInfo.create(source, metaRefId.find(source), ref2);
    }

    @Nullable
    public static <S extends BasicElement, T extends BasicElement> BasicReferenceInfo<T> create(@NotNull S source, @NotNull BasicMetaReferenceId<T> metaRefId) {
        BasicMetaReference<S, T> metaRef;
        if (source == null) {
            BasicReferenceInfo.$$$reportNull$$$0(7);
        }
        if (metaRefId == null) {
            BasicReferenceInfo.$$$reportNull$$$0(8);
        }
        return (metaRef = metaRefId.find(source)) == null ? null : BasicReferenceInfo.create(source, metaRef);
    }

    @Nullable
    public static <S extends BasicElement, T extends BasicElement> BasicReferenceInfo<T> create(@NotNull S source, @NotNull BasicMetaReference<S, T> metaRef) {
        if (source == null) {
            BasicReferenceInfo.$$$reportNull$$$0(9);
        }
        if (metaRef == null) {
            BasicReferenceInfo.$$$reportNull$$$0(10);
        }
        BasicReference ref2 = (BasicReference)metaRef.get(source);
        return BasicReferenceInfo.create(source, metaRef, ref2);
    }

    @Nullable
    public static <S extends BasicElement, T extends BasicElement> BasicReferenceInfo<T> create(@NotNull S source, @Nullable BasicMetaReference<S, T> metaRef, BasicReference ref2) {
        if (source == null) {
            BasicReferenceInfo.$$$reportNull$$$0(11);
        }
        return BasicReferenceInfo.create(source, metaRef == null ? null : metaRef.getReferenceDesc(), ref2);
    }

    @NotNull
    public static <S extends BasicElement, T extends BasicElement> List<BasicReferenceInfo<T>> create(@NotNull S source, @NotNull BasicMetaReferenceList<S, T> metaRefList) {
        List refs;
        if (source == null) {
            BasicReferenceInfo.$$$reportNull$$$0(12);
        }
        if (metaRefList == null) {
            BasicReferenceInfo.$$$reportNull$$$0(13);
        }
        List list = (refs = (List)metaRefList.get(source)).isEmpty() ? Collections.emptyList() : ContainerUtil.map((Collection)refs, r -> BasicReferenceInfo.create(source, metaRefList.getReferenceDesc(), r));
        if (list == null) {
            BasicReferenceInfo.$$$reportNull$$$0(14);
        }
        return list;
    }

    @Nullable
    private static <S extends BasicElement, T extends BasicElement> BasicReferenceInfo<T> create(@NotNull S source, BasicMetaReferenceDesc<S, T> desc, BasicReference ref2) {
        if (source == null) {
            BasicReferenceInfo.$$$reportNull$$$0(15);
        }
        return ref2 == null || desc == null ? null : BasicReferenceInfo.createImpl(source, desc, ref2);
    }

    @NotNull
    private static <S extends BasicElement, T extends BasicElement> BasicReferenceInfoImpl<S, T> createImpl(@NotNull S source, @NotNull BasicMetaReferenceDesc<S, T> desc, @NotNull BasicReference ref2) {
        if (source == null) {
            BasicReferenceInfo.$$$reportNull$$$0(16);
        }
        if (desc == null) {
            BasicReferenceInfo.$$$reportNull$$$0(17);
        }
        if (ref2 == null) {
            BasicReferenceInfo.$$$reportNull$$$0(18);
        }
        BasicResolveAssistant assistant = BasicResolveAssistant.DEFAULT;
        if (source instanceof BasicHierarchicalObject) {
            BasicHierarchicalObject h2 = (BasicHierarchicalObject)source;
            assistant = h2.getModel().getResolveAssistant();
        }
        return new BasicReferenceInfoImpl<S, T>(source, desc, ref2, assistant);
    }

    public static boolean isEquivalent(@Nullable BasicReferenceInfo<?> r1, @Nullable BasicReferenceInfo<?> r2) {
        return r1 == null || r2 == null ? r1 == r2 : r1.isEquivalent(r2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metaRefId";
                break;
            }
            case 2: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 3: 
            case 4: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/properties/BasicReferenceInfo";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metaRef";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metaRefList";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "desc";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/properties/BasicReferenceInfo";
                break;
            }
            case 3: 
            case 4: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 3: 
            case 4: 
            case 14: {
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createImpl";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 14 -> new IllegalStateException(string);
        };
    }
}

