/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.migration;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.model.migration.DbMigrationDialogKt;
import com.intellij.database.model.migration.DbMigrationTreeModel;
import com.intellij.icons.AllIcons;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001\u001aB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u000e\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u0014R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001b"}, d2={"Lcom/intellij/database/model/migration/SdForallCheckbox;", "", "()V", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "state", "Lcom/intellij/database/model/migration/SdForallCheckbox$State;", "getState", "()Lcom/intellij/database/model/migration/SdForallCheckbox$State;", "setState", "(Lcom/intellij/database/model/migration/SdForallCheckbox$State;)V", "tooltip", "", "getTooltip", "()Ljava/lang/String;", "changeAllCheckboxes", "", "model", "Lcom/intellij/database/model/migration/DbMigrationTreeModel;", "selected", "", "click", "update", "migrationTree", "State", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nSdForallCheckbox.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SdForallCheckbox.kt\ncom/intellij/database/model/migration/SdForallCheckbox\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,55:1\n1855#2,2:56\n*S KotlinDebug\n*F\n+ 1 SdForallCheckbox.kt\ncom/intellij/database/model/migration/SdForallCheckbox\n*L\n40#1:56,2\n*E\n"})
public final class SdForallCheckbox {
    @NotNull
    private State state = State.SELECTED;

    @NotNull
    public final State getState() {
        return this.state;
    }

    public final void setState(@NotNull State state) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"<set-?>");
        this.state = state;
    }

    @NotNull
    public final Icon getIcon() {
        Icon icon;
        switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
            case 1: {
                Icon icon2 = AllIcons.Diff.GutterCheckBox;
                icon = icon2;
                Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"GutterCheckBox");
                break;
            }
            case 2: {
                Icon icon3 = AllIcons.Diff.GutterCheckBoxSelected;
                icon = icon3;
                Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"GutterCheckBoxSelected");
                break;
            }
            case 3: {
                Icon icon4 = AllIcons.Diff.GutterCheckBoxIndeterminate;
                icon = icon4;
                Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"GutterCheckBoxIndeterminate");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return icon;
    }

    @NotNull
    public final String getTooltip() {
        String string;
        switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
            case 1: {
                String string2 = DatabaseBundle.message("migration.window.include.all.action", new Object[0]);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                break;
            }
            case 2: {
                String string3 = DatabaseBundle.message("migration.window.exclude.all.action", new Object[0]);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
                break;
            }
            case 3: {
                String string4 = DatabaseBundle.message("migration.window.include.all.action", new Object[0]);
                string = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    public final void click(@NotNull DbMigrationTreeModel model2) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        this.state = switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
            case 1 -> State.SELECTED;
            case 2 -> State.UNSELECTED;
            case 3 -> State.SELECTED;
            default -> throw new NoWhenBranchMatchedException();
        };
        this.changeAllCheckboxes(model2, this.state == State.SELECTED);
    }

    private final void changeAllCheckboxes(DbMigrationTreeModel model2, boolean selected) {
        List<DbMigrationTreeModel.MappingItem> mapping = model2.getDividerMapping();
        Iterable $this$forEach$iv = mapping;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DbMigrationTreeModel.MappingItem it2 = (DbMigrationTreeModel.MappingItem)element$iv;
            boolean bl = false;
            DbMigrationTreeModel.Node node2 = DbMigrationDialogKt.last(it2.getPath());
            node2.setIncluded(selected);
        }
    }

    public final void update(@NotNull DbMigrationTreeModel migrationTree) {
        Intrinsics.checkNotNullParameter((Object)migrationTree, (String)"migrationTree");
        DbMigrationTreeModel.Node root2 = migrationTree.getRootNode();
        int n = root2.getIncludedChildrenMappingCount();
        this.state = n == 0 ? State.UNSELECTED : (n == root2.getChildrenMappingCount() ? State.SELECTED : State.UNDEFINED);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/database/model/migration/SdForallCheckbox$State;", "", "(Ljava/lang/String;I)V", "UNSELECTED", "SELECTED", "UNDEFINED", "intellij.database.impl"})
    public static final class State
    extends Enum<State> {
        public static final /* enum */ State UNSELECTED = new State();
        public static final /* enum */ State SELECTED = new State();
        public static final /* enum */ State UNDEFINED = new State();
        private static final /* synthetic */ State[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String value2) {
            return Enum.valueOf(State.class, value2);
        }

        @NotNull
        public static EnumEntries<State> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = stateArray = new State[]{State.UNSELECTED, State.SELECTED, State.UNDEFINED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[State.values().length];
            try {
                nArray[State.UNSELECTED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.SELECTED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.UNDEFINED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

