/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.migration;

import com.intellij.database.model.BaseModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ElementAlteration;
import com.intellij.database.model.ElementCreation;
import com.intellij.database.model.ElementDelta;
import com.intellij.database.model.ElementRemotion;
import com.intellij.database.model.ModelModifier;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicExtension;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModRoot;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.diff.DbDiffElement;
import com.intellij.database.model.diff.DbDiffRoot;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.migration.DbMigrationElement;
import com.intellij.database.model.migration.DbMigrationRequest;
import com.intellij.database.model.migration.DbMigrationTreeModel;
import com.intellij.database.model.migration.DbMigrationTreeModelKt;
import com.intellij.database.model.migration.DiffStatus;
import com.intellij.database.model.properties.BasicReferenceInfo;
import com.intellij.database.model.properties.CompositeText;
import com.intellij.database.script.generator.ScriptCategory;
import com.intellij.database.script.generator.ScriptGenerator;
import com.intellij.database.script.generator.ScriptGenerators;
import com.intellij.database.script.generator.ScriptingOptionStatic;
import com.intellij.database.script.generator.ScriptingSingleModelTaskBuilder;
import com.intellij.database.util.Case;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.view.structure.DvDisplayNodesComparator;
import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.sql.SqlFileType;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.ui.tree.AbstractTreeModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.tree.TreePath;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\f\b\u0016\u0018\u00002\u00020\u0001:\u0005RSTUVB\u0019\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B'\b\u0002\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\nJ\u001e\u0010$\u001a\f\u0012\b\u0012\u00060\u0019R\u00020\u00000\f2\n\u0010%\u001a\u00060\u0019R\u00020\u0000H\u0014J\u0010\u0010&\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030(0'J\u000e\u0010)\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002J\u0010\u0010*\u001a\u00020\u00052\u0006\u0010+\u001a\u00020,H\u0014J\u0010\u0010-\u001a\u00020\u00052\u0006\u0010+\u001a\u00020,H\u0002J\u0014\u0010.\u001a\u00020\u00052\n\u0010/\u001a\u0006\u0012\u0002\b\u00030(H\u0002J\u0010\u00100\u001a\u00020\u00052\u0006\u00101\u001a\u00020,H\u0002J\u001e\u00102\u001a\u00020\u00052\n\u0010%\u001a\u00060\u0019R\u00020\u00002\b\b\u0002\u00103\u001a\u00020\u0005H\u0007J\b\u00104\u001a\u000205H\u0002J\u0014\u00106\u001a\u00060\u0013R\u00020\u00002\u0006\u00107\u001a\u000208H\u0002J\u0006\u00109\u001a\u00020:J\u0014\u0010;\u001a\u00020\u00052\n\u0010%\u001a\u00060\u0019R\u00020\u0000H\u0002J\b\u0010<\u001a\u00020=H\u0002J\u0010\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u000205H\u0002J\u0012\u0010A\u001a\u00020\u00052\b\u0010+\u001a\u0004\u0018\u00010,H\u0002JT\u0010B\u001a\f\u0012\b\u0012\u00060\u0019R\u00020\u00000'\"\u0004\b\u0000\u0010C2\n\u0010D\u001a\u00060\u0019R\u00020\u00002\f\u0010E\u001a\b\u0012\u0004\u0012\u00020\b0\f2\f\u0010F\u001a\b\u0012\u0004\u0012\u00020\b0\f2\u0012\u0010G\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u0002HC0HH\u0002J\u001a\u0010I\u001a\u000e\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020K0J2\u0006\u0010L\u001a\u00020\u0005J\u0006\u0010M\u001a\u00020?J\b\u0010N\u001a\u00020?H\u0002J\b\u0010O\u001a\u00020\u0005H\u0002J\u001a\u0010P\u001a\u00020?2\u0010\u0010Q\u001a\f\u0012\b\u0012\u00060\u0019R\u00020\u00000'H\u0002R \u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001f\u0010\u0012\u001a\u00060\u0013R\u00020\u00008FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0018\u001a\u00060\u0019R\u00020\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR$\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u0005@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001f\u0010!\u001a\u00060\u0013R\u00020\u00008FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b#\u0010\u0017\u001a\u0004\b\"\u0010\u0015\u00a8\u0006W"}, d2={"Lcom/intellij/database/model/migration/DbMigrationTreeModel;", "", "request", "Lcom/intellij/database/model/migration/DbMigrationRequest;", "showIdentical", "", "(Lcom/intellij/database/model/migration/DbMigrationRequest;Z)V", "origin", "Lcom/intellij/database/model/migration/DbMigrationElement;", "target", "(Lcom/intellij/database/model/migration/DbMigrationElement;Lcom/intellij/database/model/migration/DbMigrationElement;Lcom/intellij/database/model/migration/DbMigrationRequest;Z)V", "dividerMapping", "", "Lcom/intellij/database/model/migration/DbMigrationTreeModel$MappingItem;", "getDividerMapping", "()Ljava/util/List;", "setDividerMapping", "(Ljava/util/List;)V", "originTreeModel", "Lcom/intellij/database/model/migration/DbMigrationTreeModel$PresentableTreeModel;", "getOriginTreeModel", "()Lcom/intellij/database/model/migration/DbMigrationTreeModel$PresentableTreeModel;", "originTreeModel$delegate", "Lkotlin/Lazy;", "rootNode", "Lcom/intellij/database/model/migration/DbMigrationTreeModel$Node;", "getRootNode", "()Lcom/intellij/database/model/migration/DbMigrationTreeModel$Node;", "value", "getShowIdentical", "()Z", "setShowIdentical", "(Z)V", "targetTreeModel", "getTargetTreeModel", "targetTreeModel$delegate", "computeChildren", "node", "computeCorrespondence", "", "Lcom/intellij/database/model/ElementDelta;", "computeDividerMappingAndCounters", "customFilter", "element", "Lcom/intellij/database/model/basic/BasicElement;", "filterBasicElement", "filterElementDelta", "delta", "filterImplicitObjects", "base", "filterNode", "showExtensions", "getScriptGenerator", "Lcom/intellij/database/script/generator/ScriptGenerator;", "getTreeModel", "side", "Lcom/intellij/database/model/migration/DbMigrationTreeModel$Side;", "getUnifiedTreeModel", "Lcom/intellij/util/ui/tree/AbstractTreeModel;", "hasExtensionObject", "identifierCasing", "Lcom/intellij/database/util/Case;", "initialize", "", "generator", "isExtensionObject", "matchChildren", "Key", "parent", "originChildren", "targetChildren", "keyExtractor", "Lkotlin/Function1;", "prepare", "", "Lcom/intellij/database/model/basic/BasicModElement;", "withSources", "recomputeDividerMappingAndCounters", "setCountersToZero", "shouldShowExtensionMembers", "sortChildren", "children", "MappingItem", "MappingState", "Node", "PresentableTreeModel", "Side", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nDbMigrationTreeModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbMigrationTreeModel.kt\ncom/intellij/database/model/migration/DbMigrationTreeModel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,702:1\n9#2:703\n11#2:708\n1855#3,2:704\n1855#3,2:706\n1855#3,2:709\n*S KotlinDebug\n*F\n+ 1 DbMigrationTreeModel.kt\ncom/intellij/database/model/migration/DbMigrationTreeModel\n*L\n239#1:703\n639#1:708\n265#1:704,2\n300#1:706,2\n283#1:709,2\n*E\n"})
public class DbMigrationTreeModel {
    @NotNull
    private final DbMigrationRequest request;
    @NotNull
    private final Node rootNode;
    @NotNull
    private final Lazy originTreeModel$delegate;
    @NotNull
    private final Lazy targetTreeModel$delegate;
    @NotNull
    private List<MappingItem> dividerMapping;
    private boolean showIdentical;

    private DbMigrationTreeModel(DbMigrationElement origin, DbMigrationElement target2, DbMigrationRequest request, boolean showIdentical) {
        BasicModModel altModel;
        this.request = request;
        this.rootNode = new Node(null, origin, target2);
        this.originTreeModel$delegate = LazyKt.lazy((Function0)((Function0)new Function0<PresentableTreeModel>(this){
            final /* synthetic */ DbMigrationTreeModel this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final PresentableTreeModel invoke() {
                return DbMigrationTreeModel.access$getTreeModel(this.this$0, Side.ORIGIN);
            }
        }));
        this.targetTreeModel$delegate = LazyKt.lazy((Function0)((Function0)new Function0<PresentableTreeModel>(this){
            final /* synthetic */ DbMigrationTreeModel this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final PresentableTreeModel invoke() {
                return DbMigrationTreeModel.access$getTreeModel(this.this$0, Side.TARGET);
            }
        }));
        this.showIdentical = showIdentical;
        Object object = this.rootNode.getOrigin();
        BasicModModel basicModModel = object != null && (object = ((DbMigrationElement)object).getAltElement()) != null ? (BasicModModel)object.getModel() : (altModel = null);
        if (altModel != null) {
            BaseModel.modifyFast(altModel, new ModelModifier(){

                public final void perform(@NotNull BasicModRoot it2) {
                    Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                    Map<BasicElement, BasicModElement> index2 = this.prepare(!request.getOptions().getIgnoreSourceCode());
                    this.getRootNode().pullDeps(index2);
                }
            });
        } else {
            DbMigrationTreeModel $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger2 = Logger.getInstance(DbMigrationTreeModel.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
            logger2.error("Root alt model not initialized");
        }
        this.initialize(this.getScriptGenerator());
        this.dividerMapping = this.computeDividerMappingAndCounters();
    }

    @JvmOverloads
    public DbMigrationTreeModel(@NotNull DbMigrationRequest request, boolean showIdentical) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        this(DbMigrationTreeModelKt.access$initializeRootElement(request, Side.ORIGIN), DbMigrationTreeModelKt.access$initializeRootElement(request, Side.TARGET), request, showIdentical);
    }

    public /* synthetic */ DbMigrationTreeModel(DbMigrationRequest dbMigrationRequest, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(dbMigrationRequest, bl);
    }

    @NotNull
    public final Node getRootNode() {
        return this.rootNode;
    }

    @NotNull
    public final PresentableTreeModel getOriginTreeModel() {
        Lazy lazy = this.originTreeModel$delegate;
        return (PresentableTreeModel)((Object)lazy.getValue());
    }

    @NotNull
    public final PresentableTreeModel getTargetTreeModel() {
        Lazy lazy = this.targetTreeModel$delegate;
        return (PresentableTreeModel)((Object)lazy.getValue());
    }

    @NotNull
    public final List<MappingItem> getDividerMapping() {
        return this.dividerMapping;
    }

    public final void setDividerMapping(@NotNull List<MappingItem> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.dividerMapping = list;
    }

    public final boolean getShowIdentical() {
        return this.showIdentical;
    }

    public final void setShowIdentical(boolean value2) {
        this.showIdentical = value2;
        this.getOriginTreeModel().treeStructureChanged();
        this.getTargetTreeModel().treeStructureChanged();
    }

    private final ScriptGenerator getScriptGenerator() {
        BasicModel model2;
        BasicModel basicModel = model2 = this.request.getElement(Side.ORIGIN).getModel();
        Intrinsics.checkNotNull((Object)basicModel);
        return ScriptGenerators.INSTANCE.byModel(basicModel);
    }

    @NotNull
    public final Map<BasicElement, BasicModElement> prepare(boolean withSources) {
        Map index2 = new LinkedHashMap();
        this.rootNode.prepare(index2, withSources);
        return index2;
    }

    private final PresentableTreeModel getTreeModel(Side side) {
        return new PresentableTreeModel(side);
    }

    @NotNull
    public final AbstractTreeModel getUnifiedTreeModel() {
        return new PresentableTreeModel(null);
    }

    private final void initialize(ScriptGenerator generator) {
        JBIterable jBIterable = ((JBTreeTraverser)JBTreeTraverser.from(arg_0 -> DbMigrationTreeModel.initialize$lambda$0((Function1)initialize.1.INSTANCE, arg_0)).withRoot((Object)this.rootNode)).traverse();
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"traverse(...)");
        Iterable $this$forEach$iv = (Iterable)jBIterable;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Node it2 = (Node)element$iv;
            boolean bl = false;
            it2.initDeltaAndDiffStatus(generator);
            it2.initExtensionFlag();
        }
    }

    @NotNull
    public final List<ElementDelta<?>> computeCorrespondence() {
        List result2 = new ArrayList();
        DbMigrationTreeModel.computeCorrespondence$computeCorrespondenceImpl(this, result2, this.rootNode);
        return result2;
    }

    public final void recomputeDividerMappingAndCounters() {
        this.setCountersToZero();
        this.dividerMapping = this.computeDividerMappingAndCounters();
    }

    private final void setCountersToZero() {
        JBIterable jBIterable = ((JBTreeTraverser)JBTreeTraverser.from(arg_0 -> DbMigrationTreeModel.setCountersToZero$lambda$2((Function1)setCountersToZero.1.INSTANCE, arg_0)).withRoot((Object)this.rootNode)).traverse();
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"traverse(...)");
        Iterable $this$forEach$iv = (Iterable)jBIterable;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Node it2 = (Node)element$iv;
            boolean bl = false;
            it2.setIncludedChildrenMappingCount(0);
            it2.setChildrenMappingCount(0);
        }
    }

    private final List<MappingItem> computeDividerMappingAndCounters() {
        List result2 = new ArrayList();
        DbMigrationTreeModel.computeDividerMappingAndCounters$computeDividerMappingImpl(this, result2, this.rootNode, new TreePath(this.rootNode));
        return result2;
    }

    private final Case identifierCasing() {
        return this.request.getOptions().getScriptingOptions().get(ScriptingOptionStatic.IGNORE_CASE_CHANGES) != false ? Case.LOWER : Case.MIXED;
    }

    private final boolean shouldShowExtensionMembers() {
        return this.request.getOptions().getScriptingOptions().get(ScriptingOptionStatic.IGNORE_EXTENSION_MEMBERS) == false;
    }

    @JvmOverloads
    public final boolean filterNode(@NotNull Node node2, boolean showExtensions) {
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        ElementDelta<BasicElement> delta = node2.getElementDelta();
        return !(delta != null && !this.filterElementDelta(delta) || !showExtensions && node2.getHasExtensionObject());
    }

    public static /* synthetic */ boolean filterNode$default(DbMigrationTreeModel dbMigrationTreeModel, Node node2, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: filterNode");
        }
        if ((n & 2) != 0) {
            bl = dbMigrationTreeModel.shouldShowExtensionMembers();
        }
        return dbMigrationTreeModel.filterNode(node2, bl);
    }

    private final boolean filterElementDelta(ElementDelta<?> delta) {
        Object source = delta.getSourceElement();
        Object target2 = delta.getTargetElement();
        if (source != null && !this.filterBasicElement((BasicElement)source)) {
            return false;
        }
        return target2 == null || this.filterBasicElement((BasicElement)target2);
    }

    private final boolean filterBasicElement(BasicElement element2) {
        return this.filterImplicitObjects(element2) && this.customFilter(element2);
    }

    private final boolean filterImplicitObjects(BasicElement base) {
        return !this.request.getOptions().getIgnoreImplicitObjects() || !DbDiffElement.isImplicitObject(base);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasExtensionObject(Node node2) {
        DbMigrationElement dbMigrationElement = node2.getOrigin();
        BasicNode basicNode = dbMigrationElement != null ? dbMigrationElement.getBase() : null;
        if (this.isExtensionObject(basicNode instanceof BasicElement ? (BasicElement)basicNode : null)) return true;
        DbMigrationElement dbMigrationElement2 = node2.getTarget();
        basicNode = dbMigrationElement2 != null ? dbMigrationElement2.getBase() : null;
        if (!this.isExtensionObject(basicNode instanceof BasicElement ? (BasicElement)basicNode : null)) return false;
        return true;
    }

    private final boolean isExtensionObject(BasicElement element2) {
        Family<? extends BasicElement> extensions;
        if (element2 == null) {
            return false;
        }
        BasicDatabase basicDatabase = element2.getDatabase();
        Family<? extends BasicElement> family = extensions = basicDatabase != null ? basicDatabase.familyOf(ObjectKind.EXTENSION) : null;
        if (extensions != null) {
            for (BasicElement basicElement : extensions) {
                if ((basicElement instanceof BasicExtension ? (BasicExtension)basicElement : null) == null) continue;
                for (BasicReferenceInfo<? extends BasicElement> basicReferenceInfo : ((BasicExtension)basicElement).getMemberRefInfos()) {
                    if (!basicReferenceInfo.matches(element2)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected boolean customFilter(@NotNull BasicElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        return this.request.getElementFilter() == null || this.request.getElementFilter().filter(element2);
    }

    @NotNull
    protected List<Node> computeChildren(@NotNull Node node2) {
        Object targetChildren;
        Object object;
        Object originChildren;
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        Object object2 = node2.getOrigin();
        if (object2 == null || (object2 = ((DbMigrationElement)object2).getChildren()) == null) {
            object2 = originChildren = CollectionsKt.emptyList();
        }
        if ((object = node2.getTarget()) == null || (object = ((DbMigrationElement)object).getChildren()) == null) {
            object = targetChildren = CollectionsKt.emptyList();
        }
        if (originChildren.isEmpty() && targetChildren.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        if (Intrinsics.areEqual((Object)node2, (Object)this.rootNode) && this.request.isComparingLeaves()) {
            if (originChildren.size() != 1 || targetChildren.size() != 1) {
                boolean $i$f$logger = false;
                Logger logger2 = Logger.getInstance(DbMigrationTreeModel.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
                logger2.warn("Wrong manipulation with real root elements?");
                return CollectionsKt.emptyList();
            }
            Node child = new Node(node2, (DbMigrationElement)CollectionsKt.first((List)originChildren), (DbMigrationElement)CollectionsKt.first((List)targetChildren));
            return CollectionsKt.listOf((Object)child);
        }
        Function1 keyExtractor2 = (Function1)new Function1<DbMigrationElement, Triple<? extends ObjectKind, ? extends String, ? extends String>>(this){
            final /* synthetic */ DbMigrationTreeModel this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final Triple<ObjectKind, String, String> invoke(@NotNull DbMigrationElement it2) {
                Triple triple;
                Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                BasicNode base = it2.getBase();
                if (base instanceof BasicElement) {
                    Case casing = DbMigrationTreeModel.access$identifierCasing(this.this$0);
                    String identity = casing.apply(ObjectPaths.getIdentity((DasObject)((Object)base), true, false));
                    String name2 = casing.apply(((BasicElement)base).getNaturalName());
                    triple = new Triple((Object)((BasicElement)base).getKind(), (Object)name2, (Object)identity);
                } else if (base instanceof Family) {
                    triple = new Triple((Object)((Family)base).getMetaObject().kind, null, null);
                } else {
                    DbMigrationTreeModel $this$thisLogger$iv = this.this$0;
                    boolean $i$f$thisLogger = false;
                    Logger logger2 = Logger.getInstance(DbMigrationTreeModel.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
                    logger2.error("Extra nodes must be skipped: " + base);
                    triple = null;
                }
                return triple;
            }
        };
        List<Node> children2 = this.matchChildren(node2, (List<DbMigrationElement>)originChildren, (List<DbMigrationElement>)targetChildren, keyExtractor2);
        boolean areChildrenFamilies = node2.isBasicElementNode();
        if (areChildrenFamilies) {
            this.sortChildren(children2);
        }
        return children2;
    }

    private final void sortChildren(List<Node> children2) {
        Comparator comparator2 = DvDisplayNodesComparator.INSTANCE;
        Comparator cmp = new Comparator(comparator2){
            final /* synthetic */ Comparator $comparator;
            {
                this.$comparator = $comparator;
            }

            public final int compare(T a, T b2) {
                Node n;
                Node node2 = (Node)a;
                Comparator comparator2 = this.$comparator;
                boolean bl = false;
                DbMigrationElement dbMigrationElement = n.getOrigin();
                if (dbMigrationElement == null) {
                    dbMigrationElement = n.getTarget();
                }
                Intrinsics.checkNotNull((Object)dbMigrationElement);
                DbMigrationElement someElement = dbMigrationElement;
                n = (Node)b2;
                BasicNode basicNode = someElement.getBase();
                bl = false;
                DbMigrationElement dbMigrationElement2 = n.getOrigin();
                if (dbMigrationElement2 == null) {
                    dbMigrationElement2 = n.getTarget();
                }
                Intrinsics.checkNotNull((Object)dbMigrationElement2);
                someElement = dbMigrationElement2;
                BasicNode basicNode2 = someElement.getBase();
                return comparator2.compare(basicNode, basicNode2);
            }
        };
        CollectionsKt.sortWith(children2, (Comparator)cmp);
    }

    private final <Key> List<Node> matchChildren(Node parent2, List<DbMigrationElement> originChildren, List<DbMigrationElement> targetChildren, Function1<? super DbMigrationElement, ? extends Key> keyExtractor2) {
        Map originChildrenByKey = new LinkedHashMap();
        for (DbMigrationElement originElement : originChildren) {
            Object key2;
            if (keyExtractor2.invoke((Object)originElement) == null) continue;
            originChildrenByKey.put(key2, originElement);
        }
        List children2 = new ArrayList();
        for (DbMigrationElement targetElement : targetChildren) {
            Object key3;
            if (keyExtractor2.invoke((Object)targetElement) == null) continue;
            DbMigrationElement originElement = (DbMigrationElement)originChildrenByKey.remove(key3);
            children2.add(new Node(parent2, originElement, targetElement));
        }
        for (DbMigrationElement originElement : originChildrenByKey.values()) {
            children2.add(new Node(parent2, originElement, null));
        }
        return children2;
    }

    @JvmOverloads
    public DbMigrationTreeModel(@NotNull DbMigrationRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        this(request, false, 2, null);
    }

    @JvmOverloads
    public final boolean filterNode(@NotNull Node node2) {
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        return DbMigrationTreeModel.filterNode$default(this, node2, false, 2, null);
    }

    private static final Iterable initialize$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Iterable)$tmp0.invoke(p0);
    }

    private static final void computeCorrespondence$computeCorrespondenceImpl(DbMigrationTreeModel this$0, List<ElementDelta<?>> result2, Node node2) {
        boolean addedOrDeleted;
        ElementDelta<BasicElement> delta;
        if (!DbMigrationTreeModel.filterNode$default(this$0, node2, false, 2, null)) {
            return;
        }
        if (node2.isBasicElementNode() && (!node2.getContainsMapping() || node2.getIncluded()) && (delta = node2.getElementDelta()) != null) {
            ((Collection)result2).add(delta);
        }
        boolean bl = addedOrDeleted = node2.getStatus() == DiffStatus.ADDED || node2.getStatus() == DiffStatus.DELETED;
        if (node2.getContainsMapping() && !node2.getIncluded() && addedOrDeleted) {
            return;
        }
        Iterable $this$forEach$iv = node2.getChildren();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Node p0 = (Node)element$iv;
            boolean bl2 = false;
            DbMigrationTreeModel.computeCorrespondence$computeCorrespondenceImpl(this$0, result2, p0);
        }
    }

    private static final Iterable setCountersToZero$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Iterable)$tmp0.invoke(p0);
    }

    private static final int computeDividerMappingAndCounters$computeDividerMappingImpl(DbMigrationTreeModel this$0, List<MappingItem> result2, Node node2, TreePath path) {
        boolean addedOrDeletedMapping;
        if (node2.getStatus() == null) {
            return 0;
        }
        if (!DbMigrationTreeModel.filterNode$default(this$0, node2, false, 2, null)) {
            return 0;
        }
        boolean bl = addedOrDeletedMapping = node2.isBasicElementNode() && (node2.getStatus() == DiffStatus.ADDED || node2.getStatus() == DiffStatus.DELETED);
        if (!addedOrDeletedMapping) {
            node2.setChildrenMappingCount(SequencesKt.sumOfInt((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)node2.getChildren()), (Function1)((Function1)new Function1<Node, Integer>(path, this$0, result2){
                final /* synthetic */ TreePath $path;
                final /* synthetic */ DbMigrationTreeModel this$0;
                final /* synthetic */ List<MappingItem> $result;
                {
                    this.$path = $path;
                    this.this$0 = $receiver;
                    this.$result = $result;
                    super(1);
                }

                @NotNull
                public final Integer invoke(@NotNull Node it2) {
                    Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                    TreePath treePath = this.$path.pathByAddingChild(it2);
                    Intrinsics.checkNotNullExpressionValue((Object)treePath, (String)"pathByAddingChild(...)");
                    return DbMigrationTreeModel.access$computeDividerMappingAndCounters$computeDividerMappingImpl(this.this$0, this.$result, it2, treePath);
                }
            }))));
            node2.setIncludedChildrenMappingCount(node2.getChildrenMappingCount());
        }
        int count = node2.getChildrenMappingCount();
        if (!Intrinsics.areEqual((Object)node2, (Object)this$0.rootNode) && node2.isBasicElementNode() && node2.getStatus() != DiffStatus.SAME) {
            node2.setMappingState(new MappingState(false, 1, null));
            Collection collection2 = result2;
            DiffStatus diffStatus = node2.getStatus();
            Intrinsics.checkNotNull((Object)((Object)diffStatus));
            collection2.add(new MappingItem(diffStatus, path));
            ++count;
        }
        return count;
    }

    public static final /* synthetic */ Case access$identifierCasing(DbMigrationTreeModel $this) {
        return $this.identifierCasing();
    }

    public static final /* synthetic */ int access$computeDividerMappingAndCounters$computeDividerMappingImpl(DbMigrationTreeModel this$0, List result2, Node node2, TreePath path) {
        return DbMigrationTreeModel.computeDividerMappingAndCounters$computeDividerMappingImpl(this$0, result2, node2, path);
    }

    public static final /* synthetic */ PresentableTreeModel access$getTreeModel(DbMigrationTreeModel $this, Side side) {
        return $this.getTreeModel(side);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/database/model/migration/DbMigrationTreeModel$MappingItem;", "", "status", "Lcom/intellij/database/model/migration/DiffStatus;", "path", "Ljavax/swing/tree/TreePath;", "(Lcom/intellij/database/model/migration/DiffStatus;Ljavax/swing/tree/TreePath;)V", "getPath", "()Ljavax/swing/tree/TreePath;", "getStatus", "()Lcom/intellij/database/model/migration/DiffStatus;", "intellij.database.impl"})
    public static final class MappingItem {
        @NotNull
        private final DiffStatus status;
        @NotNull
        private final TreePath path;

        public MappingItem(@NotNull DiffStatus status, @NotNull TreePath path) {
            Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            this.status = status;
            this.path = path;
        }

        @NotNull
        public final DiffStatus getStatus() {
            return this.status;
        }

        @NotNull
        public final TreePath getPath() {
            return this.path;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\u0004\u00a8\u0006\b"}, d2={"Lcom/intellij/database/model/migration/DbMigrationTreeModel$MappingState;", "", "included", "", "(Z)V", "getIncluded", "()Z", "setIncluded", "intellij.database.impl"})
    public static final class MappingState {
        private boolean included;

        public MappingState(boolean included) {
            this.included = included;
        }

        public /* synthetic */ MappingState(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = true;
            }
            this(bl);
        }

        public final boolean getIncluded() {
            return this.included;
        }

        public final void setIncluded(boolean bl) {
            this.included = bl;
        }

        public MappingState() {
            this(false, 1, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B'\u0012\f\u0010\u0002\u001a\b\u0018\u00010\u0000R\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0007J(\u0010>\u001a\n @*\u0004\u0018\u00010?0?2\u0006\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020FH\u0002J\b\u0010G\u001a\u0004\u0018\u00010.J\f\u0010H\u001a\b\u0018\u00010\u0000R\u00020\u0003J\u0013\u0010I\u001a\u0004\u0018\u00010\u00052\u0006\u0010J\u001a\u00020KH\u0086\u0002J\u0016\u0010L\u001a\u00020M2\u0006\u0010A\u001a\u00020B2\u0006\u0010J\u001a\u00020KJ \u0010N\u001a\u00020F2\u0006\u0010A\u001a\u00020B2\u0006\u0010O\u001a\u00020P2\u0006\u0010Q\u001a\u00020\u001aH\u0002J\u000e\u0010R\u001a\u00020S2\u0006\u0010T\u001a\u00020UJ\u0006\u0010V\u001a\u00020SJ\"\u0010W\u001a\u00020S2\u0012\u0010X\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020Z0Y2\u0006\u0010[\u001a\u00020\u0015J\u001a\u0010\\\u001a\u00020S2\u0012\u0010X\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020Z0]J\b\u0010^\u001a\u00020_H\u0016J\u0010\u0010`\u001a\u00020S2\u0006\u0010a\u001a\u00020\u0015H\u0002R%\u0010\b\u001a\f\u0012\b\u0012\u00060\u0000R\u00020\u00030\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\"\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u0017\"\u0004\b!\u0010\"R\u0011\u0010#\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u0017R$\u0010&\u001a\u00020\u00152\u0006\u0010%\u001a\u00020\u00158F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b'\u0010\u0017\"\u0004\b(\u0010\"R\u001a\u0010)\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010\u0011\"\u0004\b+\u0010\u0013R\u0011\u0010,\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b,\u0010\u0017R\u001c\u0010-\u001a\u0004\u0018\u00010.X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u00100\"\u0004\b1\u00102R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104R\u0017\u0010\u0002\u001a\b\u0018\u00010\u0000R\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00106R\u001c\u00107\u001a\u0004\u0018\u000108X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010:\"\u0004\b;\u0010<R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u00104\u00a8\u0006b"}, d2={"Lcom/intellij/database/model/migration/DbMigrationTreeModel$Node;", "", "parent", "Lcom/intellij/database/model/migration/DbMigrationTreeModel;", "origin", "Lcom/intellij/database/model/migration/DbMigrationElement;", "target", "(Lcom/intellij/database/model/migration/DbMigrationTreeModel;Lcom/intellij/database/model/migration/DbMigrationTreeModel$Node;Lcom/intellij/database/model/migration/DbMigrationElement;Lcom/intellij/database/model/migration/DbMigrationElement;)V", "children", "", "getChildren", "()Ljava/util/List;", "children$delegate", "Lkotlin/Lazy;", "childrenMappingCount", "", "getChildrenMappingCount", "()I", "setChildrenMappingCount", "(I)V", "containsMapping", "", "getContainsMapping", "()Z", "elementDelta", "Lcom/intellij/database/model/ElementDelta;", "Lcom/intellij/database/model/basic/BasicElement;", "getElementDelta", "()Lcom/intellij/database/model/ElementDelta;", "setElementDelta", "(Lcom/intellij/database/model/ElementDelta;)V", "hasExtensionObject", "getHasExtensionObject", "setHasExtensionObject", "(Z)V", "identical", "getIdentical", "value", "included", "getIncluded", "setIncluded", "includedChildrenMappingCount", "getIncludedChildrenMappingCount", "setIncludedChildrenMappingCount", "isBasicElementNode", "mappingState", "Lcom/intellij/database/model/migration/DbMigrationTreeModel$MappingState;", "getMappingState", "()Lcom/intellij/database/model/migration/DbMigrationTreeModel$MappingState;", "setMappingState", "(Lcom/intellij/database/model/migration/DbMigrationTreeModel$MappingState;)V", "getOrigin", "()Lcom/intellij/database/model/migration/DbMigrationElement;", "getParent", "()Lcom/intellij/database/model/migration/DbMigrationTreeModel$Node;", "status", "Lcom/intellij/database/model/migration/DiffStatus;", "getStatus", "()Lcom/intellij/database/model/migration/DiffStatus;", "setStatus", "(Lcom/intellij/database/model/migration/DiffStatus;)V", "getTarget", "createDocument", "Lcom/intellij/openapi/editor/Document;", "kotlin.jvm.PlatformType", "project", "Lcom/intellij/openapi/project/Project;", "language", "Lcom/intellij/lang/Language;", "script", "Lcom/intellij/database/model/properties/CompositeText;", "enclosingMapping", "enclosingMappingNode", "get", "side", "Lcom/intellij/database/model/migration/DbMigrationTreeModel$Side;", "getContent", "Lcom/intellij/diff/contents/DiffContent;", "getCreationScript", "model", "Lcom/intellij/database/model/basic/BasicModel;", "element", "initDeltaAndDiffStatus", "", "generator", "Lcom/intellij/database/script/generator/ScriptGenerator;", "initExtensionFlag", "prepare", "index", "", "Lcom/intellij/database/model/basic/BasicModElement;", "withSources", "pullDeps", "", "toString", "", "updateMappingCountUpward", "increase", "intellij.database.impl"})
    @SourceDebugExtension(value={"SMAP\nDbMigrationTreeModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbMigrationTreeModel.kt\ncom/intellij/database/model/migration/DbMigrationTreeModel$Node\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,702:1\n11#2:703\n11#2:704\n1855#3,2:705\n1855#3,2:707\n*S KotlinDebug\n*F\n+ 1 DbMigrationTreeModel.kt\ncom/intellij/database/model/migration/DbMigrationTreeModel$Node\n*L\n500#1:703\n519#1:704\n569#1:705,2\n574#1:707,2\n*E\n"})
    public final class Node {
        @Nullable
        private final Node parent;
        @Nullable
        private final DbMigrationElement origin;
        @Nullable
        private final DbMigrationElement target;
        @NotNull
        private final Lazy children$delegate;
        @Nullable
        private DiffStatus status;
        @Nullable
        private ElementDelta<? extends BasicElement> elementDelta;
        @Nullable
        private MappingState mappingState;
        private int childrenMappingCount;
        private int includedChildrenMappingCount;
        private boolean hasExtensionObject;

        public Node(@Nullable Node parent2, @Nullable DbMigrationElement origin, DbMigrationElement target2) {
            this.parent = parent2;
            this.origin = origin;
            this.target = target2;
            this.children$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<? extends Node>>(DbMigrationTreeModel.this, this){
                final /* synthetic */ DbMigrationTreeModel this$0;
                final /* synthetic */ Node this$1;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    super(0);
                }

                @NotNull
                public final List<Node> invoke() {
                    return this.this$0.computeChildren(this.this$1);
                }
            }));
        }

        @Nullable
        public final Node getParent() {
            return this.parent;
        }

        @Nullable
        public final DbMigrationElement getOrigin() {
            return this.origin;
        }

        @Nullable
        public final DbMigrationElement getTarget() {
            return this.target;
        }

        @Nullable
        public final DbMigrationElement get(@NotNull Side side) {
            Intrinsics.checkNotNullParameter((Object)((Object)side), (String)"side");
            return switch (WhenMappings.$EnumSwitchMapping$0[side.ordinal()]) {
                case 1 -> this.origin;
                case 2 -> this.target;
                default -> throw new NoWhenBranchMatchedException();
            };
        }

        @NotNull
        public final List<Node> getChildren() {
            Lazy lazy = this.children$delegate;
            return (List)lazy.getValue();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isBasicElementNode() {
            DbMigrationElement dbMigrationElement = this.origin;
            if ((dbMigrationElement != null ? dbMigrationElement.getBase() : null) instanceof BasicElement) return true;
            DbMigrationElement dbMigrationElement2 = this.target;
            if (!((dbMigrationElement2 != null ? dbMigrationElement2.getBase() : null) instanceof BasicElement)) return false;
            return true;
        }

        @Nullable
        public final DiffStatus getStatus() {
            return this.status;
        }

        public final void setStatus(@Nullable DiffStatus diffStatus) {
            this.status = diffStatus;
        }

        @Nullable
        public final ElementDelta<BasicElement> getElementDelta() {
            return this.elementDelta;
        }

        public final void setElementDelta(@Nullable ElementDelta<? extends BasicElement> elementDelta) {
            this.elementDelta = elementDelta;
        }

        public final void initDeltaAndDiffStatus(@NotNull ScriptGenerator generator) {
            Intrinsics.checkNotNullParameter((Object)generator, (String)"generator");
            if (this.isBasicElementNode()) {
                DiffStatus diffStatus;
                BasicModElement t;
                DbMigrationElement dbMigrationElement = this.target;
                BasicNode basicNode = dbMigrationElement != null ? dbMigrationElement.getBase() : null;
                BasicElement s2 = basicNode instanceof BasicElement ? (BasicElement)basicNode : null;
                DbMigrationElement dbMigrationElement2 = this.origin;
                BasicModElement basicModElement = t = dbMigrationElement2 != null ? dbMigrationElement2.getAltElement() : null;
                if (s2 == null && t == null) {
                    boolean $i$f$logger = false;
                    Logger logger2 = Logger.getInstance(DbMigrationTreeModel.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
                    logger2.warn("Both source and target are null for " + this);
                    return;
                }
                ElementDelta<? extends BasicElement> elementDelta = this.elementDelta = ElementDelta.Companion.create(s2, (BasicElement)t);
                Intrinsics.checkNotNull(elementDelta);
                ElementDelta<? extends BasicElement> elementDelta2 = elementDelta;
                if (elementDelta2 instanceof ElementAlteration) {
                    BasicElement basicElement = s2;
                    Intrinsics.checkNotNull((Object)basicElement);
                    BasicModElement basicModElement2 = t;
                    Intrinsics.checkNotNull((Object)basicModElement2);
                    diffStatus = generator.isEqual(basicElement, basicModElement2, DbMigrationTreeModel.this.request.getOptions().getScriptingOptions()) ? DiffStatus.SAME : DiffStatus.MODIFIED;
                } else if (elementDelta2 instanceof ElementCreation) {
                    diffStatus = DiffStatus.ADDED;
                } else if (elementDelta2 instanceof ElementRemotion) {
                    diffStatus = DiffStatus.DELETED;
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                this.status = diffStatus;
            } else {
                DiffStatus diffStatus;
                if (this.origin != null && this.target != null) {
                    diffStatus = DiffStatus.SAME;
                } else if (this.origin != null) {
                    diffStatus = DiffStatus.ADDED;
                } else if (this.target != null) {
                    diffStatus = DiffStatus.DELETED;
                } else {
                    boolean $i$f$logger = false;
                    Logger logger3 = Logger.getInstance(DbMigrationTreeModel.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger3, (String)"getInstance(...)");
                    logger3.error("A node with null origin and target, parent=" + this.parent);
                    diffStatus = null;
                }
                this.status = diffStatus;
            }
        }

        @Nullable
        public final MappingState getMappingState() {
            return this.mappingState;
        }

        public final void setMappingState(@Nullable MappingState mappingState) {
            this.mappingState = mappingState;
        }

        public final boolean getContainsMapping() {
            return this.mappingState != null;
        }

        public final boolean getIncluded() {
            MappingState mappingState = this.mappingState;
            Intrinsics.checkNotNull((Object)mappingState);
            return mappingState.getIncluded();
        }

        public final void setIncluded(boolean value2) {
            MappingState mappingState = this.mappingState;
            Intrinsics.checkNotNull((Object)mappingState);
            if (mappingState.getIncluded() != value2) {
                MappingState mappingState2 = this.mappingState;
                Intrinsics.checkNotNull((Object)mappingState2);
                mappingState2.setIncluded(value2);
                this.updateMappingCountUpward(value2);
            }
        }

        @Nullable
        public final Node enclosingMappingNode() {
            Node current = this;
            while (current != null) {
                if (current.getContainsMapping()) {
                    return current;
                }
                current = current.parent;
            }
            return null;
        }

        @Nullable
        public final MappingState enclosingMapping() {
            Node node2 = this.enclosingMappingNode();
            return node2 != null ? node2.mappingState : null;
        }

        public final int getChildrenMappingCount() {
            return this.childrenMappingCount;
        }

        public final void setChildrenMappingCount(int n) {
            this.childrenMappingCount = n;
        }

        public final int getIncludedChildrenMappingCount() {
            return this.includedChildrenMappingCount;
        }

        public final void setIncludedChildrenMappingCount(int n) {
            this.includedChildrenMappingCount = n;
        }

        private final void updateMappingCountUpward(boolean increase) {
            Node current = this.parent;
            while (current != null) {
                Node node2 = current;
                node2.includedChildrenMappingCount = node2.includedChildrenMappingCount + (increase ? 1 : -1);
                current = current.parent;
            }
        }

        public final boolean getIdentical() {
            return this.status == DiffStatus.SAME && this.childrenMappingCount == 0;
        }

        public final void pullDeps(@NotNull Map<BasicElement, ? extends BasicModElement> index2) {
            Intrinsics.checkNotNullParameter(index2, (String)"index");
            DbMigrationElement dbMigrationElement = this.origin;
            if (dbMigrationElement != null) {
                dbMigrationElement.pullDeps(index2);
            }
            Iterable $this$forEach$iv = this.getChildren();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Node it2 = (Node)element$iv;
                boolean bl = false;
                it2.pullDeps(index2);
            }
        }

        public final void prepare(@NotNull Map<BasicElement, BasicModElement> index2, boolean withSources) {
            Intrinsics.checkNotNullParameter(index2, (String)"index");
            DbMigrationElement dbMigrationElement = this.origin;
            if (dbMigrationElement != null) {
                dbMigrationElement.prepare(index2, this.target, withSources);
            }
            Iterable $this$forEach$iv = this.getChildren();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Node it2 = (Node)element$iv;
                boolean bl = false;
                it2.prepare(index2, withSources);
            }
        }

        @NotNull
        public final DiffContent getContent(@NotNull Project project, @NotNull Side side) {
            DocumentContent documentContent;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)((Object)side), (String)"side");
            DbDiffRoot dbDiffRoot = DbMigrationTreeModel.this.request.getRoot(side).getRoot();
            Intrinsics.checkNotNullExpressionValue((Object)dbDiffRoot, (String)"getRoot(...)");
            DbDiffRoot root2 = dbDiffRoot;
            DbMigrationElement migrationElement = switch (WhenMappings.$EnumSwitchMapping$0[side.ordinal()]) {
                case 1 -> this.origin;
                case 2 -> this.target;
                default -> throw new NoWhenBranchMatchedException();
            };
            if (migrationElement == null) {
                EmptyContent emptyContent = DiffContentFactory.getInstance().createEmpty();
                Intrinsics.checkNotNullExpressionValue((Object)emptyContent, (String)"createEmpty(...)");
                return (DiffContent)emptyContent;
            }
            if (!this.isBasicElementNode()) {
                throw new AssertionError();
            }
            BasicNode basicNode = migrationElement.getBase();
            Intrinsics.checkNotNull((Object)basicNode, (String)"null cannot be cast to non-null type com.intellij.database.model.basic.BasicElement");
            BasicElement element2 = (BasicElement)basicNode;
            BasicModel basicModel = root2.getModel();
            Intrinsics.checkNotNullExpressionValue((Object)basicModel, (String)"getModel(...)");
            CompositeText script2 = this.getCreationScript(project, basicModel, element2);
            Language language = root2.getLanguage();
            Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
            Document document = this.createDocument(project, language, script2);
            DocumentContent $this$getContent_u24lambda_u242 = documentContent = DiffContentFactory.getInstance().create(project, document);
            boolean bl = false;
            $this$getContent_u24lambda_u242.putUserData(DiffUserDataKeys.LANGUAGE, (Object)root2.getLanguage());
            DocumentContent documentContent2 = documentContent;
            Intrinsics.checkNotNullExpressionValue((Object)documentContent2, (String)"apply(...)");
            return (DiffContent)documentContent2;
        }

        private final CompositeText getCreationScript(Project project, BasicModel model2, BasicElement element2) {
            ScriptingSingleModelTaskBuilder scriptingSingleModelTaskBuilder = new ScriptingSingleModelTaskBuilder(model2, ScriptCategory.CREATE_COMPLETE);
            DbMigrationTreeModel dbMigrationTreeModel = DbMigrationTreeModel.this;
            ScriptingSingleModelTaskBuilder $this$getCreationScript_u24lambda_u243 = scriptingSingleModelTaskBuilder;
            boolean bl = false;
            $this$getCreationScript_u24lambda_u243.getElements().add(element2);
            $this$getCreationScript_u24lambda_u243.setOptions(dbMigrationTreeModel.request.getOptions().getScriptingOptions());
            $this$getCreationScript_u24lambda_u243.setCurrentNamespace(DasUtil.getParentOfClass(element2, BasicNamespace.class, false));
            ScriptingSingleModelTaskBuilder taskBuilder = scriptingSingleModelTaskBuilder;
            return ScriptGenerators.INSTANCE.makeScript(project, taskBuilder.build()).getScript();
        }

        private final Document createDocument(Project project, Language language, CompositeText script2) {
            return (Document)ReadAction.compute(() -> Node.createDocument$lambda$4(project, language, script2));
        }

        public final boolean getHasExtensionObject() {
            return this.hasExtensionObject;
        }

        public final void setHasExtensionObject(boolean bl) {
            this.hasExtensionObject = bl;
        }

        public final void initExtensionFlag() {
            this.hasExtensionObject = DbMigrationTreeModel.this.hasExtensionObject(this);
        }

        @NotNull
        public String toString() {
            return "Node(origin=" + this.origin + ", target=" + this.target + ")";
        }

        private static final Document createDocument$lambda$4(Project $project, Language $language, CompositeText $script) {
            Document document;
            Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
            Intrinsics.checkNotNullParameter((Object)$language, (String)"$language");
            Intrinsics.checkNotNullParameter((Object)$script, (String)"$script");
            try {
                PsiFileFactory psiFileFactory = PsiFileFactory.getInstance((Project)$project);
                PsiFile psiFile = psiFileFactory.createFileFromText("a." + SqlFileType.INSTANCE.getDefaultExtension(), $language, (CharSequence)StringUtil.convertLineSeparators((String)((Object)$script.getText()).toString()), false, true);
                VirtualFile virtualFile = psiFile.getViewProvider().getVirtualFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
                VirtualFile virtualFile2 = virtualFile;
                if (virtualFile2 instanceof LightVirtualFile) {
                    ((LightVirtualFile)virtualFile2).setWritable(false);
                }
                Document document2 = FileDocumentManager.getInstance().getDocument(virtualFile2);
                Intrinsics.checkNotNull((Object)document2);
                document = document2;
            }
            catch (IOException e2) {
                throw new DiffRequestProducerException((Throwable)e2);
            }
            return document;
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Side.values().length];
                try {
                    nArray[Side.ORIGIN.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Side.TARGET.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u00060\bR\u00020\t2\u0006\u0010\n\u001a\u00020\u0006J\u0014\u0010\u000b\u001a\u00020\u00062\n\u0010\f\u001a\u00060\bR\u00020\tH\u0002J\u0014\u0010\r\u001a\u00020\u00062\n\u0010\f\u001a\u00060\bR\u00020\tH\u0002J\u0014\u0010\u000e\u001a\u00020\u00062\n\u0010\f\u001a\u00060\bR\u00020\tH\u0002J\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0012\u0010\u0014\u001a\u00020\u00132\b\u0010\u0011\u001a\u0004\u0018\u00010\u0010H\u0016J\u001e\u0010\u0015\u001a\f\u0012\b\u0012\u00060\bR\u00020\t0\u00162\n\u0010\f\u001a\u00060\bR\u00020\tH\u0007J\u001c\u0010\u0017\u001a\u00020\u00132\b\u0010\u0011\u001a\u0004\u0018\u00010\u00102\b\u0010\u0018\u001a\u0004\u0018\u00010\u0010H\u0016J\f\u0010\u0019\u001a\u00060\bR\u00020\tH\u0016J\u0012\u0010\u001a\u001a\u00020\u00062\b\u0010\f\u001a\u0004\u0018\u00010\u0010H\u0016J\u0006\u0010\u001b\u001a\u00020\u001cR\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/database/model/migration/DbMigrationTreeModel$PresentableTreeModel;", "Lcom/intellij/util/ui/tree/AbstractTreeModel;", "side", "Lcom/intellij/database/model/migration/DbMigrationTreeModel$Side;", "(Lcom/intellij/database/model/migration/DbMigrationTreeModel;Lcom/intellij/database/model/migration/DbMigrationTreeModel$Side;)V", "filter", "", "it", "Lcom/intellij/database/model/migration/DbMigrationTreeModel$Node;", "Lcom/intellij/database/model/migration/DbMigrationTreeModel;", "showExtensions", "filterBySide", "node", "filterEmptyFamilies", "filterIdentical", "getChild", "", "parent", "index", "", "getChildCount", "getChildren", "", "getIndexOfChild", "child", "getRoot", "isLeaf", "treeStructureChanged", "", "intellij.database.impl"})
    public final class PresentableTreeModel
    extends AbstractTreeModel {
        @Nullable
        private final Side side;

        public PresentableTreeModel(Side side) {
            this.side = side;
        }

        @NotNull
        public Node getRoot() {
            return DbMigrationTreeModel.this.getRootNode();
        }

        @Nullable
        public Object getChild(@Nullable Object parent2, int index2) {
            boolean showExtensions = DbMigrationTreeModel.this.shouldShowExtensionMembers();
            Intrinsics.checkNotNull((Object)parent2, (String)"null cannot be cast to non-null type com.intellij.database.model.migration.DbMigrationTreeModel.Node");
            Node cfr_ignored_0 = (Node)parent2;
            int current = -1;
            for (Node n : ((Node)parent2).getChildren()) {
                if (!this.filter(n, showExtensions) || ++current != index2) continue;
                return n;
            }
            return null;
        }

        public int getChildCount(@Nullable Object parent2) {
            boolean showExtensions = DbMigrationTreeModel.this.shouldShowExtensionMembers();
            Intrinsics.checkNotNull((Object)parent2, (String)"null cannot be cast to non-null type com.intellij.database.model.migration.DbMigrationTreeModel.Node");
            Node cfr_ignored_0 = (Node)parent2;
            int count = 0;
            for (Node n : ((Node)parent2).getChildren()) {
                if (!this.filter(n, showExtensions)) continue;
                ++count;
            }
            return count;
        }

        public boolean isLeaf(@Nullable Object node2) {
            return this.getChildCount(node2) == 0;
        }

        public int getIndexOfChild(@Nullable Object parent2, @Nullable Object child) {
            boolean showExtensions = DbMigrationTreeModel.this.shouldShowExtensionMembers();
            Intrinsics.checkNotNull((Object)parent2, (String)"null cannot be cast to non-null type com.intellij.database.model.migration.DbMigrationTreeModel.Node");
            Node cfr_ignored_0 = (Node)parent2;
            int current = -1;
            for (Node n : ((Node)parent2).getChildren()) {
                if (!this.filter(n, showExtensions)) continue;
                ++current;
                if (!Intrinsics.areEqual((Object)n, (Object)child)) continue;
                return current;
            }
            return -1;
        }

        public final boolean filter(@NotNull Node it2, boolean showExtensions) {
            Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
            return it2.getStatus() != null && this.filterBySide(it2) && this.filterIdentical(it2) && DbMigrationTreeModel.this.filterNode(it2, showExtensions) && this.filterEmptyFamilies(it2);
        }

        private final boolean filterBySide(Node node2) {
            return this.side != Side.ORIGIN || node2.getStatus() != DiffStatus.DELETED;
        }

        private final boolean filterIdentical(Node node2) {
            return DbMigrationTreeModel.this.getShowIdentical() || !node2.getIdentical();
        }

        private final boolean filterEmptyFamilies(Node node2) {
            return node2.isBasicElementNode() || !this.isLeaf(node2);
        }

        @TestOnly
        @NotNull
        public final List<Node> getChildren(@NotNull Node node2) {
            Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
            List children2 = new ArrayList();
            boolean showExtensions = DbMigrationTreeModel.this.shouldShowExtensionMembers();
            for (Node n : node2.getChildren()) {
                if (!this.filter(n, showExtensions)) continue;
                ((Collection)children2).add(n);
            }
            return children2;
        }

        public final void treeStructureChanged() {
            this.treeStructureChanged(null, null, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/database/model/migration/DbMigrationTreeModel$Side;", "", "(Ljava/lang/String;I)V", "opposite", "getOpposite", "()Lcom/intellij/database/model/migration/DbMigrationTreeModel$Side;", "ORIGIN", "TARGET", "intellij.database.impl"})
    public static final class Side
    extends Enum<Side> {
        public static final /* enum */ Side ORIGIN = new Side();
        public static final /* enum */ Side TARGET = new Side();
        private static final /* synthetic */ Side[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        @NotNull
        public final Side getOpposite() {
            return switch (WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
                case 1 -> TARGET;
                case 2 -> ORIGIN;
                default -> throw new NoWhenBranchMatchedException();
            };
        }

        public static Side[] values() {
            return (Side[])$VALUES.clone();
        }

        public static Side valueOf(String value2) {
            return Enum.valueOf(Side.class, value2);
        }

        @NotNull
        public static EnumEntries<Side> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = sideArray = new Side[]{Side.ORIGIN, Side.TARGET};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Side.values().length];
                try {
                    nArray[Side.ORIGIN.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Side.TARGET.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

