/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.migration;

import com.intellij.database.model.migration.DbMigrationDialog;
import com.intellij.database.model.migration.DbMigrationDialogKt;
import com.intellij.database.model.migration.DbMigrationElement;
import com.intellij.database.model.migration.DbMigrationTreeModel;
import com.intellij.database.model.migration.DiffStatus;
import com.intellij.database.model.migration.SdColorsKt;
import com.intellij.database.view.DbNodeDescriptor;
import com.intellij.database.view.structure.DvTreeStructureService;
import com.intellij.database.view.structure.DvViewOptions;
import com.intellij.database.view.structure.DvViewOptionsFun;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.PresentableNodeDescriptor;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.components.JBViewport;
import com.intellij.ui.render.RenderingHelper;
import com.intellij.ui.treeStructure.Tree;
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001\u001eB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0014\u0010\u000e\u001a\u0004\u0018\u00010\n2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0012\u0010\u0017\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0014J\u0018\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/database/model/migration/DbMigrationSideTree;", "Lcom/intellij/ui/treeStructure/Tree;", "project", "Lcom/intellij/openapi/project/Project;", "model", "Ljavax/swing/tree/TreeModel;", "side", "Lcom/intellij/database/model/migration/DbMigrationTreeModel$Side;", "(Lcom/intellij/openapi/project/Project;Ljavax/swing/tree/TreeModel;Lcom/intellij/database/model/migration/DbMigrationTreeModel$Side;)V", "getColorImpl", "Ljava/awt/Color;", "color", "enclosingMapping", "Lcom/intellij/database/model/migration/DbMigrationTreeModel$MappingState;", "getFileColorFor", "obj", "", "isFileColorsEnabled", "", "paintChangesBorders", "", "g", "Ljava/awt/Graphics;", "paintComponent", "paintLeftBorder", "bounds", "Ljava/awt/Rectangle;", "paintLowerBorder", "paintRightBorder", "paintUpperBorder", "CellRenderer", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nDbMigrationSideTree.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbMigrationSideTree.kt\ncom/intellij/database/model/migration/DbMigrationSideTree\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,207:1\n11#2:208\n*S KotlinDebug\n*F\n+ 1 DbMigrationSideTree.kt\ncom/intellij/database/model/migration/DbMigrationSideTree\n*L\n53#1:208\n*E\n"})
public final class DbMigrationSideTree
extends Tree {
    @NotNull
    private final DbMigrationTreeModel.Side side;

    public DbMigrationSideTree(@NotNull Project project, @NotNull TreeModel model2, @NotNull DbMigrationTreeModel.Side side) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Intrinsics.checkNotNullParameter((Object)((Object)side), (String)"side");
        super(model2);
        this.side = side;
        CellRenderer renderer2 = new CellRenderer(project, this.side, false);
        this.setCellRenderer(renderer2);
        Function1 treeSearchConvertor2 = (Function1)new Function1<TreePath, String>(renderer2){
            final /* synthetic */ CellRenderer $renderer;
            {
                this.$renderer = $renderer;
                super(1);
            }

            @Nullable
            public final String invoke(@NotNull TreePath path) {
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                return this.$renderer.updatePresentation(DbMigrationDialogKt.last(path)).getPresentableText();
            }
        };
        this.putClientProperty(RenderingHelper.SHRINK_LONG_RENDERER, true);
        TreeSpeedSearch.installOn((JTree)((JTree)((Object)this)), (boolean)true, arg_0 -> DbMigrationSideTree._init_$lambda$0(treeSearchConvertor2, arg_0));
        this.setRootVisible(false);
        this.setBackground(EditorColorsUtil.getGlobalOrDefaultColorScheme().getDefaultBackground());
    }

    public boolean isFileColorsEnabled() {
        return true;
    }

    @Nullable
    public Color getFileColorFor(@Nullable Object obj2) {
        Color color;
        Intrinsics.checkNotNull((Object)obj2, (String)"null cannot be cast to non-null type com.intellij.database.model.migration.DbMigrationTreeModel.Node");
        DbMigrationTreeModel.Node node2 = (DbMigrationTreeModel.Node)obj2;
        DiffStatus diffStatus = node2.getStatus();
        Color color2 = color = diffStatus != null ? SdColorsKt.getBackground(diffStatus) : null;
        if (color == null) {
            return super.getFileColorFor(obj2);
        }
        DbMigrationTreeModel.MappingState enclosingMapping = node2.enclosingMapping();
        if (!node2.isBasicElementNode() && enclosingMapping == null) {
            return super.getFileColorFor(obj2);
        }
        if (enclosingMapping == null) {
            boolean $i$f$logger = false;
            Logger logger2 = Logger.getInstance(DbMigrationDialog.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
            logger2.warn("this node does not belong to any mapping: " + node2);
            return super.getFileColorFor(obj2);
        }
        return this.getColorImpl(color, enclosingMapping);
    }

    private final Color getColorImpl(Color color, DbMigrationTreeModel.MappingState enclosingMapping) {
        Color color2;
        if (this.side == DbMigrationTreeModel.Side.ORIGIN) {
            color2 = color;
        } else if (enclosingMapping.getIncluded()) {
            color2 = color;
        } else {
            Color color3 = ColorUtil.mix((Color)color, (Color)this.getBackground(), (double)0.3);
            color2 = color3;
            Intrinsics.checkNotNullExpressionValue((Object)color3, (String)"mix(...)");
        }
        return color2;
    }

    protected void paintComponent(@Nullable Graphics g2) {
        super.paintComponent(g2);
        Graphics graphics = g2;
        Intrinsics.checkNotNull((Object)graphics);
        this.paintChangesBorders(graphics);
    }

    private final void paintChangesBorders(Graphics g2) {
        DbMigrationTreeModel.Node currentMappingNode = null;
        int n = this.getRowCount();
        for (int row = 0; row < n; ++row) {
            boolean changeContinues;
            boolean changeEnded;
            Rectangle bounds;
            TreePath path = this.getPathForRow(row);
            Intrinsics.checkNotNull((Object)path);
            DbMigrationTreeModel.Node node2 = DbMigrationDialogKt.last(path);
            if (DbMigrationDialogKt.nodeBounds(this, path) == null) continue;
            Container container = this.getParent();
            Intrinsics.checkNotNull((Object)container, (String)"null cannot be cast to non-null type com.intellij.ui.components.JBViewport");
            Rectangle viewRect = ((JBViewport)container).getViewRect();
            if (!bounds.intersects(viewRect)) continue;
            boolean newChangeStarted = node2.getContainsMapping();
            if (newChangeStarted) {
                currentMappingNode = node2;
                DiffStatus diffStatus = currentMappingNode.getStatus();
                g2.setColor(diffStatus != null ? SdColorsKt.borderColor(diffStatus) : null);
                this.paintUpperBorder(g2, bounds);
                if (row == this.getRowCount() - 1) {
                    this.paintLowerBorder(g2, bounds);
                }
                if (this.side != DbMigrationTreeModel.Side.TARGET) {
                    this.paintLeftBorder(g2, bounds);
                }
                this.paintRightBorder(g2, bounds);
                continue;
            }
            boolean bl = changeEnded = currentMappingNode != null && !Intrinsics.areEqual((Object)node2.enclosingMappingNode(), (Object)currentMappingNode);
            if (changeEnded) {
                currentMappingNode = null;
                this.paintUpperBorder(g2, bounds);
                continue;
            }
            boolean bl2 = changeContinues = currentMappingNode != null;
            if (!changeContinues) continue;
            if (row == this.getRowCount() - 1) {
                this.paintLowerBorder(g2, bounds);
            }
            this.paintLeftBorder(g2, bounds);
            this.paintRightBorder(g2, bounds);
        }
    }

    private final void paintUpperBorder(Graphics g2, Rectangle bounds) {
        g2.drawLine(0, bounds.y, this.getWidth(), bounds.y);
    }

    private final void paintLowerBorder(Graphics g2, Rectangle bounds) {
        g2.drawLine(0, bounds.y + bounds.height, this.getWidth(), bounds.y + bounds.height);
    }

    private final void paintLeftBorder(Graphics g2, Rectangle bounds) {
        g2.drawLine(0, bounds.y, 0, bounds.y + bounds.height);
    }

    private final void paintRightBorder(Graphics g2, Rectangle bounds) {
        g2.drawLine(this.getWidth(), bounds.y, this.getWidth(), bounds.y + bounds.height);
    }

    private static final String _init_$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0014\u0010\u0010\u001a\u00020\u00112\n\u0010\u0012\u001a\u00060\u0013R\u00020\u0014H\u0002JB\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\bH\u0016J$\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u001e2\n\u0010\u0012\u001a\u00060\u0013R\u00020\u0014H\u0002J\u001e\u0010 \u001a\u0004\u0018\u00010!2\n\u0010\u0012\u001a\u00060\u0013R\u00020\u00142\u0006\u0010\"\u001a\u00020!H\u0002J\u0012\u0010#\u001a\u00020\u000b2\n\u0010\u0012\u001a\u00060\u0013R\u00020\u0014R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/intellij/database/model/migration/DbMigrationSideTree$CellRenderer;", "Ljavax/swing/tree/TreeCellRenderer;", "Lcom/intellij/ui/ColoredTreeCellRenderer;", "project", "Lcom/intellij/openapi/project/Project;", "side", "Lcom/intellij/database/model/migration/DbMigrationTreeModel$Side;", "useForegroundColor", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/database/model/migration/DbMigrationTreeModel$Side;Z)V", "presentation", "Lcom/intellij/ide/projectView/PresentationData;", "getPresentation", "()Lcom/intellij/ide/projectView/PresentationData;", "setPresentation", "(Lcom/intellij/ide/projectView/PresentationData;)V", "addCounter", "", "node", "Lcom/intellij/database/model/migration/DbMigrationTreeModel$Node;", "Lcom/intellij/database/model/migration/DbMigrationTreeModel;", "customizeCellRenderer", "tree", "Ljavax/swing/JTree;", "value", "", "selected", "expanded", "leaf", "row", "", "hasFocus", "getForeground", "Ljava/awt/Color;", "bg", "updatePresentation", "intellij.database.impl"})
    @SourceDebugExtension(value={"SMAP\nDbMigrationSideTree.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbMigrationSideTree.kt\ncom/intellij/database/model/migration/DbMigrationSideTree$CellRenderer\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,207:1\n31#2,2:208\n*S KotlinDebug\n*F\n+ 1 DbMigrationSideTree.kt\ncom/intellij/database/model/migration/DbMigrationSideTree$CellRenderer\n*L\n191#1:208,2\n*E\n"})
    public static final class CellRenderer
    extends ColoredTreeCellRenderer
    implements TreeCellRenderer {
        @NotNull
        private final Project project;
        @NotNull
        private final DbMigrationTreeModel.Side side;
        private final boolean useForegroundColor;
        @NotNull
        private PresentationData presentation;

        public CellRenderer(@NotNull Project project, @NotNull DbMigrationTreeModel.Side side, boolean useForegroundColor) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)((Object)side), (String)"side");
            this.project = project;
            this.side = side;
            this.useForegroundColor = useForegroundColor;
            this.presentation = new PresentationData();
        }

        @NotNull
        public final PresentationData getPresentation() {
            return this.presentation;
        }

        public final void setPresentation(@NotNull PresentationData presentationData) {
            Intrinsics.checkNotNullParameter((Object)presentationData, (String)"<set-?>");
            this.presentation = presentationData;
        }

        public void customizeCellRenderer(@NotNull JTree tree, @Nullable Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
            Intrinsics.checkNotNull((Object)value2, (String)"null cannot be cast to non-null type com.intellij.database.model.migration.DbMigrationTreeModel.Node");
            DbMigrationTreeModel.Node node2 = (DbMigrationTreeModel.Node)value2;
            this.updatePresentation(node2);
            this.customizeCellRenderer(tree, row, node2);
        }

        private final void customizeCellRenderer(JTree tree, int row, DbMigrationTreeModel.Node node2) {
            this.setIcon(this.presentation.getIcon(false));
            boolean isMain = true;
            for (PresentableNodeDescriptor.ColoredFragment each : this.presentation.getColoredText()) {
                SimpleTextAttributes simpleTextAttributes;
                boolean grayed = Comparing.equal((Object)each.getAttributes().getFgColor(), (Object)SimpleTextAttributes.GRAYED_ATTRIBUTES.getFgColor());
                if (grayed) {
                    isMain = false;
                }
                int style = each.getAttributes().getStyle();
                if (!Registry.is((String)"database.schema.diff.table.view") && node2.getStatus() == DiffStatus.ADDED && this.side == DbMigrationTreeModel.Side.TARGET) {
                    style |= 2;
                }
                if (isMain) {
                    SimpleTextAttributes simpleTextAttributes2 = each.getAttributes();
                    Color color = tree.getBackground();
                    Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getBackground(...)");
                    simpleTextAttributes = simpleTextAttributes2.derive(style, this.getForeground(node2, color), null, null);
                } else {
                    simpleTextAttributes = each.getAttributes();
                }
                SimpleTextAttributes attributes2 = simpleTextAttributes;
                this.append(each.getText(), attributes2, isMain);
            }
            if (this.side == DbMigrationTreeModel.Side.TARGET && !tree.getModel().isLeaf(node2) && tree.isCollapsed(row) && node2.getChildrenMappingCount() > 0) {
                this.addCounter(node2);
            }
        }

        private final Color getForeground(DbMigrationTreeModel.Node node2, Color bg) {
            boolean excluded;
            if (this.side == DbMigrationTreeModel.Side.ORIGIN) {
                return null;
            }
            if (!node2.isBasicElementNode() && node2.getParent() != null && node2.getParent().getStatus() != node2.getStatus()) {
                return null;
            }
            DbMigrationTreeModel.MappingState mapping = node2.enclosingMapping();
            boolean bl = excluded = mapping != null && !mapping.getIncluded();
            if (!this.useForegroundColor) {
                return excluded ? SimpleTextAttributes.GRAYED_ATTRIBUTES.getFgColor() : null;
            }
            DiffStatus diffStatus = node2.getStatus();
            return diffStatus != null ? SdColorsKt.getForeground(diffStatus, bg, excluded) : null;
        }

        private final void addCounter(DbMigrationTreeModel.Node node2) {
            String includedCounterText = " " + node2.getIncludedChildrenMappingCount() + " / " + node2.getChildrenMappingCount() + " ";
            this.append("\u2002", SimpleTextAttributes.REGULAR_ATTRIBUTES);
            SimpleTextAttributes counterAttributes = DbNodeDescriptor.ACTIVE_LINK_ATTRS;
            this.append(includedCounterText, counterAttributes);
        }

        @NotNull
        public final PresentationData updatePresentation(@NotNull DbMigrationTreeModel.Node node2) {
            Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
            DbMigrationElement element2 = switch (WhenMappings.$EnumSwitchMapping$0[this.side.ordinal()]) {
                case 1 -> node2.getOrigin();
                case 2 -> {
                    if (node2.getStatus() == DiffStatus.ADDED) {
                        yield node2.getOrigin();
                    }
                    yield node2.getTarget();
                }
                default -> throw new NoWhenBranchMatchedException();
            };
            if (element2 == null) {
                this.presentation.clear();
            } else {
                DvViewOptions viewOptions = DvViewOptionsFun.getDatabaseViewOptions(this.project);
                ComponentManager $this$service$iv = (ComponentManager)this.project;
                boolean $i$f$service = false;
                Class<DvTreeStructureService> serviceClass$iv = DvTreeStructureService.class;
                Object object = $this$service$iv.getService(serviceClass$iv);
                if (object == null) {
                    throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                }
                DvTreeStructureService treeStructure2 = (DvTreeStructureService)object;
                DbNodeDescriptor.updatePresentation(this.presentation, element2.getBase(), this.project, viewOptions, treeStructure2, null, false, false);
            }
            return this.presentation;
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[DbMigrationTreeModel.Side.values().length];
                try {
                    nArray[DbMigrationTreeModel.Side.ORIGIN.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DbMigrationTreeModel.Side.TARGET.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

