/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.migration;

import com.intellij.database.Dbms;
import com.intellij.database.model.ModelLightCopier;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModLikeColumn;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.model.basic.BasicView;
import com.intellij.database.model.diff.DbDiffElement;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.meta.BasicMetaProperty;
import com.intellij.database.model.meta.BasicMetaReference;
import com.intellij.database.model.meta.BasicMetaUtils;
import com.intellij.database.model.migration.DbMigrationElement;
import com.intellij.database.model.migration.DbMigrationRequest;
import com.intellij.database.model.migration.DbMigrationTreeModel;
import com.intellij.database.model.properties.BasicReference;
import com.intellij.database.view.structure.DvExtraNode;
import com.intellij.database.view.structure.DvTreeLayer;
import com.intellij.database.view.structure.DvTreeStructureService;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0000\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\u0012\u0010\u0012\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0013\u001a\u00020\bH\u0002J\u0010\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\bH\u0002J\"\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0007\u001a\u00020\u00182\u0006\u0010\t\u001a\u00020\n2\b\u0010\u0019\u001a\u0004\u0018\u00010\u0000H\u0002J,\u0010\u001a\u001a\u00020\u00172\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\n0\u001c2\u0006\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0014\u0010\u001f\u001a\u0004\u0018\u00010\u00002\b\u0010 \u001a\u0004\u0018\u00010!H\u0002J\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00000#J\b\u0010$\u001a\u00020\u0017H\u0002J&\u0010%\u001a\u0004\u0018\u00010\n2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\n0&2\u0006\u0010\u0007\u001a\u00020\u0018H\u0002J\u0010\u0010'\u001a\u00020\u001e2\u0006\u0010(\u001a\u00020\u0018H\u0002J,\u0010)\u001a\u00020\u00172\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\n0\u001c2\b\u0010\u0019\u001a\u0004\u0018\u00010\u00002\u0006\u0010\u001d\u001a\u00020\u001eJ\u001a\u0010*\u001a\u00020\u00172\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\n0&J\b\u0010+\u001a\u00020,H\u0016R\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/intellij/database/model/migration/DbMigrationElement;", "", "request", "Lcom/intellij/database/model/migration/DbMigrationRequest;", "side", "Lcom/intellij/database/model/migration/DbMigrationTreeModel$Side;", "parent", "base", "Lcom/intellij/database/model/basic/BasicNode;", "altElement", "Lcom/intellij/database/model/basic/BasicModElement;", "(Lcom/intellij/database/model/migration/DbMigrationRequest;Lcom/intellij/database/model/migration/DbMigrationTreeModel$Side;Lcom/intellij/database/model/migration/DbMigrationElement;Lcom/intellij/database/model/basic/BasicNode;Lcom/intellij/database/model/basic/BasicModElement;)V", "getAltElement", "()Lcom/intellij/database/model/basic/BasicModElement;", "getBase", "()Lcom/intellij/database/model/basic/BasicNode;", "getParent", "()Lcom/intellij/database/model/migration/DbMigrationElement;", "createAltElement", "basicNode", "createChild", "node", "fillAltElement", "", "Lcom/intellij/database/model/basic/BasicElement;", "other", "fillAltElementUpward", "index", "", "withSources", "", "getAltParentOfKind", "kind", "Lcom/intellij/database/model/ObjectKind;", "getChildren", "", "hackPgDefaultValue", "instantiate", "", "isAlwaysLeaf", "e", "prepare", "pullDeps", "toString", "", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nDbMigrationTreeModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbMigrationTreeModel.kt\ncom/intellij/database/model/migration/DbMigrationElement\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,702:1\n1620#2,3:703\n31#3,2:706\n*S KotlinDebug\n*F\n+ 1 DbMigrationTreeModel.kt\ncom/intellij/database/model/migration/DbMigrationElement\n*L\n91#1:703,3\n95#1:706,2\n*E\n"})
public final class DbMigrationElement {
    @NotNull
    private final DbMigrationRequest request;
    @NotNull
    private final DbMigrationTreeModel.Side side;
    @Nullable
    private final DbMigrationElement parent;
    @NotNull
    private final BasicNode base;
    @Nullable
    private final BasicModElement altElement;

    public DbMigrationElement(@NotNull DbMigrationRequest request, @NotNull DbMigrationTreeModel.Side side, @Nullable DbMigrationElement parent2, @NotNull BasicNode base, @Nullable BasicModElement altElement) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)((Object)side), (String)"side");
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        this.request = request;
        this.side = side;
        this.parent = parent2;
        this.base = base;
        this.altElement = altElement;
    }

    @Nullable
    public final DbMigrationElement getParent() {
        return this.parent;
    }

    @NotNull
    public final BasicNode getBase() {
        return this.base;
    }

    @Nullable
    public final BasicModElement getAltElement() {
        return this.altElement;
    }

    private final BasicModElement createAltElement(BasicNode basicNode) {
        ModFamily altFamily;
        BasicModElement parentAltElement;
        DbMigrationElement realParent;
        if (this.side == DbMigrationTreeModel.Side.TARGET) {
            return null;
        }
        if (!(basicNode instanceof BasicElement)) {
            return null;
        }
        BasicElement basicElement = ((BasicElement)basicNode).getParent();
        DbMigrationElement dbMigrationElement = realParent = this.getAltParentOfKind(basicElement != null ? basicElement.getKind() : null);
        BasicModElement basicModElement = parentAltElement = dbMigrationElement != null ? dbMigrationElement.altElement : null;
        ModFamily modFamily = altFamily = basicModElement != null ? (ModFamily)basicModElement.familyOf(((BasicElement)basicNode).getKind()) : null;
        return modFamily != null ? modFamily.createNewOne() : null;
    }

    private final DbMigrationElement getAltParentOfKind(ObjectKind kind) {
        if (kind == null) {
            return null;
        }
        DbMigrationElement current = this;
        while (current != null) {
            BasicNode e2 = current.base;
            if (e2 instanceof BasicElement && Intrinsics.areEqual((Object)((BasicElement)e2).getKind(), (Object)kind)) {
                return current;
            }
            current = current.parent;
        }
        return null;
    }

    private final boolean isAlwaysLeaf(BasicElement e2) {
        return !e2.hasChildren() || e2 instanceof BasicSourceAware && !(e2 instanceof BasicView);
    }

    private final DbMigrationElement createChild(BasicNode node2) {
        return new DbMigrationElement(this.request, this.side, this, node2, this.createAltElement(node2));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<DbMigrationElement> getChildren() {
        if (this.base instanceof BasicElement) {
            if (this.isAlwaysLeaf((BasicElement)this.base)) {
                return CollectionsKt.emptyList();
            }
            List<BasicElement> list = this.request.getRoot(this.side).getRoot().getRootElements();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getRootElements(...)");
            List<BasicElement> requestedElements = list;
            if (this.parent == null && Intrinsics.areEqual((Object)((BasicElement)CollectionsKt.first(requestedElements)).getParent(), (Object)this.base)) {
                void $this$mapTo$iv;
                Iterable iterable = requestedElements;
                Collection destination$iv = new ArrayList();
                boolean $i$f$mapTo = false;
                for (Object item$iv : $this$mapTo$iv) {
                    void p0;
                    BasicNode basicNode = (BasicNode)item$iv;
                    Collection collection2 = destination$iv;
                    boolean bl = false;
                    collection2.add(this.createChild((BasicNode)p0));
                }
                return (List)destination$iv;
            }
        }
        ComponentManager $this$service$iv = (ComponentManager)this.request.getProject();
        boolean $i$f$service = false;
        Class<DvTreeStructureService> serviceClass$iv = DvTreeStructureService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        DvTreeLayer treeLayer = ((DvTreeStructureService)object).getLayoutLayer();
        List list = treeLayer.childrenOf(this.base).flatMap(arg_0 -> DbMigrationElement.getChildren$lambda$0((Function1)new Function1<BasicNode, Iterable<? extends BasicNode>>(treeLayer){
            final /* synthetic */ DvTreeLayer $treeLayer;
            {
                this.$treeLayer = $treeLayer;
                super(1);
            }

            public final Iterable<BasicNode> invoke(BasicNode it2) {
                JBIterable<? extends BasicNode> jBIterable;
                if (it2 instanceof DvExtraNode) {
                    Intrinsics.checkNotNull((Object)it2);
                    jBIterable = this.$treeLayer.childrenOf(it2);
                } else {
                    JBIterable<? extends BasicNode> jBIterable2 = JBIterable.of((Object)it2);
                    jBIterable = jBIterable2;
                    Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"of(...)");
                }
                return (Iterable)jBIterable;
            }
        }, arg_0)).filter(arg_0 -> DbMigrationElement.getChildren$lambda$1(getChildren.3.INSTANCE, arg_0)).filter(arg_0 -> DbMigrationElement.getChildren$lambda$2((Function1)new Function1<BasicNode, Boolean>(this){
            final /* synthetic */ DbMigrationElement this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(BasicNode it2) {
                return !(this.this$0.getBase() instanceof BasicView) || it2 instanceof Family && ((Family)it2).isNotEmpty() && Intrinsics.areEqual((Object)((Family)it2).first().getKind(), (Object)ObjectKind.TRIGGER);
            }
        }, arg_0)).map(arg_0 -> DbMigrationElement.getChildren$lambda$3((Function1)new Function1<BasicNode, DbMigrationElement>((Object)this){

            @NotNull
            public final DbMigrationElement invoke(@NotNull BasicNode p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return DbMigrationElement.access$createChild((DbMigrationElement)this.receiver, p0);
            }
        }, arg_0)).toList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"toList(...)");
        return list;
    }

    public final void pullDeps(@NotNull Map<BasicElement, ? extends BasicModElement> index2) {
        Intrinsics.checkNotNullParameter(index2, (String)"index");
        if (!(this.base instanceof BasicElement)) {
            return;
        }
        if (this.altElement == null) {
            return;
        }
        BasicMetaObject<BasicElement> basicMetaObject = BasicMetaUtils.getMetaObject((BasicElement)this.base);
        Intrinsics.checkNotNullExpressionValue(basicMetaObject, (String)"getMetaObject(...)");
        BasicMetaObject<BasicElement> baseMeta = basicMetaObject;
        BasicMetaObject<BasicElement> basicMetaObject2 = BasicMetaUtils.getMetaObject((BasicElement)this.altElement);
        Intrinsics.checkNotNullExpressionValue(basicMetaObject2, (String)"getMetaObject(...)");
        BasicMetaObject<BasicElement> altMeta = basicMetaObject2;
        Intrinsics.checkNotNullExpressionValue(baseMeta.references, (String)"references");
        for (BasicMetaProperty r : baseMeta.references) {
            BasicMetaReference altMetaRef;
            BasicMetaReference baseMetaRef;
            if (r.isInternal() || BasicMetaReference.asRef(r) == null || altMeta.getReference(baseMetaRef.getId()) == null) continue;
            Object baseTarget = BasicMetaUtils.resolve((BasicElement)this.base, baseMetaRef.getReferenceDesc(), (BasicReference)baseMetaRef.get((BasicElement)this.base));
            Object altTarget = BasicMetaUtils.resolve((BasicElement)this.altElement, altMetaRef.getReferenceDesc(), (BasicReference)altMetaRef.get((BasicElement)this.altElement));
            if (baseTarget == null || altTarget != null) continue;
            this.instantiate(index2, (BasicElement)baseTarget);
        }
    }

    private final BasicModElement instantiate(Map<BasicElement, ? extends BasicModElement> index2, BasicElement base) {
        BasicElement basicElement = base.getParent();
        if (basicElement == null) {
            return null;
        }
        BasicElement baseParent = basicElement;
        BasicModElement basicModElement = index2.get(baseParent);
        if (basicModElement == null && (basicModElement = this.instantiate(index2, baseParent)) == null) {
            return null;
        }
        BasicModElement altParent = basicModElement;
        ModFamily modFamily = (ModFamily)altParent.familyOf(base.getKind());
        if (modFamily == null) {
            return null;
        }
        ModFamily targetFamily = modFamily;
        Object alt = targetFamily.createNewOne();
        DbDiffElement.copyChildren(base, alt, true);
        Intrinsics.checkNotNull(alt);
        this.fillAltElement(base, (BasicModElement)alt, null);
        return alt;
    }

    public final void prepare(@NotNull Map<BasicElement, BasicModElement> index2, @Nullable DbMigrationElement other, boolean withSources) {
        Intrinsics.checkNotNullParameter(index2, (String)"index");
        if (!(this.base instanceof BasicElement)) {
            return;
        }
        if (this.altElement == null) {
            return;
        }
        index2.put((BasicElement)this.base, this.altElement);
        this.fillAltElement((BasicElement)this.base, this.altElement, other);
        if (!DbDiffElement.isContainer((BasicElement)this.base)) {
            DbDiffElement.copyChildren((BasicElement)this.base, this.altElement, withSources, DbMigrationElement::prepare$lambda$4);
        }
        if (withSources) {
            BasicMetaUtils.copySourceText((BasicElement)this.base, this.altElement, true, true);
        }
        if (other != null && this.parent == null) {
            this.fillAltElementUpward(index2, other, withSources);
        }
        this.hackPgDefaultValue();
    }

    private final void hackPgDefaultValue() {
        if (!(this.altElement instanceof BasicModLikeColumn)) {
            return;
        }
        boolean pgLike = ((BasicModModel)((BasicModLikeColumn)this.altElement).getModel()).getDbms().in(Dbms.POSTGRES_LIKE);
        if (!pgLike) {
            return;
        }
        String string = ((BasicModLikeColumn)this.altElement).getDefaultExpression();
        if (string == null) {
            return;
        }
        String def = string;
        BasicNode basicNode = this.base;
        Object object = basicNode instanceof BasicElement ? (BasicElement)basicNode : null;
        if (object == null || (object = object.getSchema()) == null || (object = object.getName()) == null) {
            return;
        }
        Object originSchemaName = object;
        String qualification = (String)originSchemaName + ".";
        int idx = StringsKt.indexOf$default((CharSequence)def, (String)qualification, (int)0, (boolean)false, (int)6, null);
        if (idx == -1) {
            return;
        }
        String string2 = def.substring(0, idx);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        String string3 = def.substring(idx + qualification.length());
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        String hackedDefault = string2 + string3;
        ((BasicModLikeColumn)this.altElement).setDefaultExpression(hackedDefault);
    }

    private final void fillAltElement(BasicElement base, BasicModElement altElement, DbMigrationElement other) {
        if (other != null && other.base instanceof BasicElement) {
            DbDiffElement.assignElement((BasicElement)other.base, altElement, false);
        }
        if (Intrinsics.areEqual(base.getMetaObject(), altElement.getMetaObject())) {
            ModelLightCopier.copyProperties(base, altElement, false, true);
        } else {
            BasicMetaUtils.copyMatchedProperties(base, altElement, other == null, false, true);
        }
    }

    private final void fillAltElementUpward(Map<BasicElement, BasicModElement> index2, DbMigrationElement other, boolean withSources) {
        if (!(other.base instanceof BasicElement)) {
            return;
        }
        BasicNode basicNode = this.base;
        BasicElement b2 = basicNode instanceof BasicElement ? (BasicElement)basicNode : null;
        BasicModElement alt = this.altElement;
        for (BasicElement o2 = (BasicElement)other.base; alt != null && o2 != null; alt = (BasicModElement)alt.getParent(), o2 = o2.getParent()) {
            if (b2 != null) {
                index2.put(b2, alt);
            }
            DbDiffElement.assignElement(o2, alt, withSources);
            BasicElement basicElement = b2;
            b2 = basicElement != null ? basicElement.getParent() : null;
        }
    }

    @NotNull
    public String toString() {
        return "DbMigrationElement(base=" + this.base + ")";
    }

    private static final Iterable getChildren$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Iterable)$tmp0.invoke(p0);
    }

    private static final boolean getChildren$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean getChildren$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final DbMigrationElement getChildren$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (DbMigrationElement)$tmp0.invoke(p0);
    }

    private static final boolean prepare$lambda$4(ObjectKind kind) {
        return !Intrinsics.areEqual((Object)kind, (Object)ObjectKind.TRIGGER);
    }

    public static final /* synthetic */ DbMigrationElement access$createChild(DbMigrationElement $this, BasicNode node2) {
        return $this.createChild(node2);
    }
}

