/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.migration;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.actions.DumpToDdlDataSourceActionKt;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.diff.SchemaDiffCustomization;
import com.intellij.database.model.migration.DbDdlDiffPanel;
import com.intellij.database.model.migration.DbMigrationDialog;
import com.intellij.database.model.migration.DbMigrationDiffPanel;
import com.intellij.database.model.migration.DbMigrationDiffPanelBase;
import com.intellij.database.model.migration.DbMigrationElement;
import com.intellij.database.model.migration.DbMigrationOptionsPanelKt;
import com.intellij.database.model.migration.DbMigrationRequest;
import com.intellij.database.model.migration.DbMigrationTableDiffPanel;
import com.intellij.database.model.migration.DbMigrationTreeModel;
import com.intellij.database.model.migration.DbPropsDiffTableModel;
import com.intellij.database.model.migration.DiffStatus;
import com.intellij.database.model.migration.EmptyMigrationModel;
import com.intellij.database.model.migration.SdColorsKt;
import com.intellij.database.model.migration.SdUtilsKt;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.script.generator.DelegateScriptingOptions;
import com.intellij.database.script.generator.ScriptGenerators;
import com.intellij.database.script.generator.ScriptingAlterTaskBuilder;
import com.intellij.database.script.generator.ScriptingOptionStatic;
import com.intellij.database.script.generator.ScriptingOptions;
import com.intellij.database.script.generator.ScriptingResult;
import com.intellij.database.script.generator.ScriptingSingleModelTaskBuilder;
import com.intellij.database.script.generator.ScriptingTask;
import com.intellij.database.script.generator.ScriptingTaskBuilderKt;
import com.intellij.database.util.AsyncTask;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbUIUtil;
import com.intellij.database.view.AbstractDatabaseModifier;
import com.intellij.database.view.DatabaseRefactoringHandler;
import com.intellij.database.view.ui.DatabaseScriptDialog;
import com.intellij.database.view.ui.SqlPreviewComponent;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.ui.table.JBTable;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.FilteredTraverserBase;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00f5\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000*\u0001C\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u00101\u001a\u0002022\u0006\u00103\u001a\u00020/H\u0002J\u0010\u00104\u001a\u0002052\u0006\u00106\u001a\u000205H\u0002J\u0013\u00107\u001a\b\u0012\u0004\u0012\u00020908H\u0014\u00a2\u0006\u0002\u0010:J\b\u0010;\u001a\u00020<H\u0014J\b\u0010=\u001a\u00020>H\u0002J\b\u0010?\u001a\u00020>H\u0002J\b\u0010@\u001a\u00020>H\u0002J\b\u0010A\u001a\u00020/H\u0002J\r\u0010B\u001a\u00020CH\u0002\u00a2\u0006\u0002\u0010DJ\b\u0010E\u001a\u00020\u001cH\u0002J\b\u0010F\u001a\u00020+H\u0002J\b\u0010G\u001a\u00020<H\u0014J\b\u0010H\u001a\u00020IH\u0002J\b\u0010J\u001a\u00020KH\u0002J\b\u0010L\u001a\u00020/H\u0002J\b\u0010M\u001a\u000202H\u0014J\u0010\u0010N\u001a\u0002022\u0006\u0010O\u001a\u00020PH\u0002J\b\u0010Q\u001a\u00020RH\u0003J\b\u0010S\u001a\u00020TH\u0014J\b\u0010U\u001a\u00020TH\u0003J\b\u0010V\u001a\u000202H\u0002J\b\u0010W\u001a\u000202H\u0003J\b\u0010X\u001a\u000202H\u0002J\u0010\u0010Y\u001a\u0002022\u0006\u00106\u001a\u000205H\u0002J\b\u0010Z\u001a\u000202H\u0002J\u0006\u0010[\u001a\u000202J\b\u0010\\\u001a\u000202H\u0007J\u000e\u0010]\u001a\b\u0012\u0004\u0012\u0002020^H\u0007J\b\u0010_\u001a\u000202H\u0002J\u0014\u0010`\u001a\u0006\u0012\u0002\b\u00030a2\u0006\u0010b\u001a\u00020cH\u0002J\u0014\u0010d\u001a\u0002022\f\u0010e\u001a\b\u0018\u00010fR\u00020\u0016J\u0016\u0010g\u001a\u0002022\f\u0010e\u001a\b\u0018\u00010fR\u00020\u0016H\u0002J\u0016\u0010h\u001a\u0002022\f\u0010e\u001a\b\u0018\u00010fR\u00020\u0016H\u0002J\u0010\u0010i\u001a\u0002022\u0006\u0010j\u001a\u00020kH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\u00020\u001e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u000e\u0010!\u001a\u00020\"X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0010\u0010'\u001a\u0004\u0018\u00010(X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020+X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020/X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00100\u001a\u0004\u0018\u00010(X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006l"}, d2={"Lcom/intellij/database/model/migration/DbMigrationDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "request", "Lcom/intellij/database/model/migration/DbMigrationRequest;", "(Lcom/intellij/database/model/migration/DbMigrationRequest;)V", "PREVIEW_DDL_DIFF_INDEX", "", "PREVIEW_PROP_DIFF_INDEX", "ddlDiffPanel", "Lcom/intellij/database/model/migration/DbDdlDiffPanel;", "diffPanel", "Lcom/intellij/database/model/migration/DbMigrationDiffPanelBase;", "dividerMapping", "", "Lcom/intellij/database/model/migration/DbMigrationTreeModel$MappingItem;", "getDividerMapping", "()Ljava/util/List;", "generatedWithErrors", "", "mainLoadingPanel", "Lcom/intellij/ui/components/JBLoadingPanel;", "migrationTree", "Lcom/intellij/database/model/migration/DbMigrationTreeModel;", "getMigrationTree", "()Lcom/intellij/database/model/migration/DbMigrationTreeModel;", "setMigrationTree", "(Lcom/intellij/database/model/migration/DbMigrationTreeModel;)V", "previewPane", "Lcom/intellij/ui/components/JBTabbedPane;", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "propsDiffTable", "Ljavax/swing/JTable;", "propsDiffTableModel", "Lcom/intellij/database/model/migration/DbPropsDiffTableModel;", "getRequest", "()Lcom/intellij/database/model/migration/DbMigrationRequest;", "scriptGenerationProgress", "Lcom/intellij/openapi/progress/ProgressIndicator;", "scriptLoadingPanel", "scriptPreview", "Lcom/intellij/database/view/ui/SqlPreviewComponent;", "showIdenticalCheckBox", "Ljavax/swing/JCheckBox;", "southPanelWrapper", "Ljavax/swing/JPanel;", "treesInitializationProgress", "addShowIdenticalCheckBox", "", "panel", "appendCodeStyle", "Lcom/intellij/database/script/generator/ScriptingOptions;", "options", "createActions", "", "Ljavax/swing/Action;", "()[Ljavax/swing/Action;", "createCenterPanel", "Ljavax/swing/JComponent;", "createDiffPanel", "Ljava/awt/Component;", "createDiffPanelTreeTable", "createDiffPanelTwoTrees", "createMainPanel", "createOptionsPopup", "com/intellij/database/model/migration/DbMigrationDialog$createOptionsPopup$1", "()Lcom/intellij/database/model/migration/DbMigrationDialog$createOptionsPopup$1;", "createPreviewPane", "createScriptPreview", "createSouthPanel", "createTask", "Lcom/intellij/database/script/generator/ScriptingTask;", "createToolbar", "Lcom/intellij/openapi/actionSystem/ActionToolbar;", "createToolbarPanel", "doOKAction", "fillLoaderContext", "modifier", "Lcom/intellij/database/view/AbstractDatabaseModifier;", "generate", "Lcom/intellij/database/script/generator/ScriptingResult;", "getHelpId", "", "getOKButtonText", "initializeMetaPropertiesDiffTable", "initializeTreeModel", "onIgnoreImplicitChange", "onScriptingOptionsChange", "perform", "refresh", "refreshScript", "refreshTrees", "Lorg/jetbrains/concurrency/Promise;", "reinitializeButtons", "runScript", "Lcom/intellij/database/util/AsyncTask;", "localDataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "updateCurrentPreviewPage", "node", "Lcom/intellij/database/model/migration/DbMigrationTreeModel$Node;", "updateDdlDiff", "updatePropsDiffTable", "updateSqlDataSource", "ds", "Lcom/intellij/sql/database/SqlDataSource;", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nDbMigrationDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbMigrationDialog.kt\ncom/intellij/database/model/migration/DbMigrationDialog\n+ 2 promise.kt\norg/jetbrains/concurrency/Promises__PromiseKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,497:1\n211#2,12:498\n211#2,12:511\n1#3:510\n1313#4,2:523\n1789#5,3:525\n*S KotlinDebug\n*F\n+ 1 DbMigrationDialog.kt\ncom/intellij/database/model/migration/DbMigrationDialog\n*L\n131#1:498,12\n362#1:511,12\n481#1:523,2\n489#1:525,3\n*E\n"})
public final class DbMigrationDialog
extends DialogWrapper {
    @NotNull
    private final DbMigrationRequest request;
    @NotNull
    private DbMigrationTreeModel migrationTree;
    @NotNull
    private final JBLoadingPanel mainLoadingPanel;
    @NotNull
    private final JCheckBox showIdenticalCheckBox;
    private DbMigrationDiffPanelBase diffPanel;
    @NotNull
    private final JBLoadingPanel scriptLoadingPanel;
    @NotNull
    private SqlPreviewComponent scriptPreview;
    @NotNull
    private final DbDdlDiffPanel ddlDiffPanel;
    @NotNull
    private JPanel southPanelWrapper;
    private final int PREVIEW_PROP_DIFF_INDEX;
    private final int PREVIEW_DDL_DIFF_INDEX;
    private JBTabbedPane previewPane;
    private DbPropsDiffTableModel propsDiffTableModel;
    private JTable propsDiffTable;
    @Nullable
    private ProgressIndicator scriptGenerationProgress;
    @Nullable
    private ProgressIndicator treesInitializationProgress;
    private volatile boolean generatedWithErrors;

    public DbMigrationDialog(@NotNull DbMigrationRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        super(request.getProject());
        this.request = request;
        this.migrationTree = new EmptyMigrationModel(this.request);
        LayoutManager layoutManager = new BorderLayout();
        Disposable disposable = this.getDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"getDisposable(...)");
        this.mainLoadingPanel = new JBLoadingPanel(layoutManager, disposable, 100);
        this.showIdenticalCheckBox = new JCheckBox(DatabaseBundle.message("checkbox.show.identical", new Object[0]), false);
        LayoutManager layoutManager2 = new BorderLayout();
        Disposable disposable2 = this.getDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable2, (String)"getDisposable(...)");
        this.scriptLoadingPanel = new JBLoadingPanel(layoutManager2, disposable2, 100);
        this.scriptPreview = this.createScriptPreview();
        this.ddlDiffPanel = new DbDdlDiffPanel(this.getProject(), this);
        this.southPanelWrapper = new JPanel(new BorderLayout(0, 0), false);
        this.PREVIEW_PROP_DIFF_INDEX = 1;
        this.PREVIEW_DDL_DIFF_INDEX = 2;
        this.initializeMetaPropertiesDiffTable();
        this.setTitle(DatabaseBundle.message("dialog.title.migration", new Object[0]));
        this.setOKButtonText(this.getOKButtonText());
        this.init();
        this.refresh();
    }

    @NotNull
    public final DbMigrationRequest getRequest() {
        return this.request;
    }

    private final Project getProject() {
        return this.request.getProject();
    }

    @NotNull
    public final DbMigrationTreeModel getMigrationTree() {
        return this.migrationTree;
    }

    public final void setMigrationTree(@NotNull DbMigrationTreeModel dbMigrationTreeModel) {
        Intrinsics.checkNotNullParameter((Object)dbMigrationTreeModel, (String)"<set-?>");
        this.migrationTree = dbMigrationTreeModel;
    }

    @NotNull
    public final List<DbMigrationTreeModel.MappingItem> getDividerMapping() {
        return this.migrationTree.getDividerMapping();
    }

    private final SqlPreviewComponent createScriptPreview() {
        return new SqlPreviewComponent(this.getProject(), this.request.getDataSource(DbMigrationTreeModel.Side.TARGET), this.request.getTargetSearchPath(), "", false, () -> DbMigrationDialog.createScriptPreview$lambda$0(this));
    }

    public final void refresh() {
        this.request.reinitializeAltModels();
        this.refreshTrees().onSuccess(arg_0 -> DbMigrationDialog.refresh$lambda$1((Function1)new Function1<Unit, Unit>(this){
            final /* synthetic */ DbMigrationDialog this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(Unit it2) {
                UIUtil.invokeLaterIfNeeded(() -> refresh.1.invoke$lambda$0(this.this$0));
            }

            private static final void invoke$lambda$0(DbMigrationDialog this$0) {
                Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                this$0.refreshScript();
                DbMigrationDiffPanelBase dbMigrationDiffPanelBase = DbMigrationDialog.access$getDiffPanel$p(this$0);
                if (dbMigrationDiffPanelBase == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"diffPanel");
                    dbMigrationDiffPanelBase = null;
                }
                dbMigrationDiffPanelBase.refreshTreesUI();
            }
        }, arg_0));
    }

    @RequiresEdt
    @NotNull
    public final Promise<Unit> refreshTrees() {
        this.mainLoadingPanel.startLoading();
        if (this.treesInitializationProgress != null) {
            ProgressIndicator progressIndicator = this.treesInitializationProgress;
            Intrinsics.checkNotNull((Object)progressIndicator);
            progressIndicator.cancel();
        }
        this.treesInitializationProgress = (ProgressIndicator)new EmptyProgressIndicator();
        boolean $i$f$runAsync = false;
        AsyncPromise promise$iv = new AsyncPromise();
        AppExecutorUtil.getAppExecutorService().execute(new Runnable(promise$iv, this){
            final /* synthetic */ AsyncPromise $promise;
            final /* synthetic */ DbMigrationDialog this$0;
            {
                this.$promise = $promise;
                this.this$0 = dbMigrationDialog;
            }

            public final void run() {
                Unit unit;
                try {
                    boolean bl = false;
                    ProgressManager.getInstance().runProcess(() -> DbMigrationDialog.access$initializeTreeModel(this.this$0), DbMigrationDialog.access$getTreesInitializationProgress$p(this.this$0));
                    unit = Unit.INSTANCE;
                }
                catch (Throwable e2) {
                    this.$promise.setError(e2);
                    return;
                }
                Unit result2 = unit;
                this.$promise.setResult((Object)result2);
            }
        });
        Promise promise = ((Promise)promise$iv).onProcessed(arg_0 -> DbMigrationDialog.refreshTrees$lambda$3((Function1)new Function1<Unit, Unit>(this){
            final /* synthetic */ DbMigrationDialog this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(Unit it2) {
                UIUtil.invokeLaterIfNeeded(() -> refreshTrees.p.2.invoke$lambda$0(this.this$0));
            }

            private static final void invoke$lambda$0(DbMigrationDialog this$0) {
                Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                DbMigrationDialog.access$getMainLoadingPanel$p(this$0).stopLoading();
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)promise, (String)"onProcessed(...)");
        Promise p2 = promise;
        return p2;
    }

    @RequiresBackgroundThread
    private final void initializeTreeModel() {
        this.migrationTree = new DbMigrationTreeModel(this.request, this.showIdenticalCheckBox.isSelected());
    }

    @RequiresEdt
    public final void refreshScript() {
        this.scriptLoadingPanel.startLoading();
        if (this.scriptGenerationProgress != null) {
            ProgressIndicator progressIndicator = this.scriptGenerationProgress;
            Intrinsics.checkNotNull((Object)progressIndicator);
            progressIndicator.cancel();
        }
        this.scriptGenerationProgress = (ProgressIndicator)new EmptyProgressIndicator();
        ApplicationManager.getApplication().executeOnPooledThread(() -> DbMigrationDialog.refreshScript$lambda$5(this));
    }

    @RequiresBackgroundThread
    private final ScriptingResult generate() {
        return ScriptGenerators.INSTANCE.makeScript(this.request.getProject(), this.createTask());
    }

    private final ScriptingTask createTask() {
        ScriptingAlterTaskBuilder builder;
        ScriptingAlterTaskBuilder scriptingAlterTaskBuilder;
        BasicModel basicModel = this.request.getElement(DbMigrationTreeModel.Side.TARGET).getModel();
        Intrinsics.checkNotNull((Object)basicModel);
        BasicModElement basicModElement = this.request.getAltElement(DbMigrationTreeModel.Side.ORIGIN);
        Intrinsics.checkNotNull((Object)basicModElement);
        BasicModel basicModel2 = basicModElement.getModel();
        Intrinsics.checkNotNullExpressionValue((Object)basicModel2, (String)"getModel(...)");
        ScriptingAlterTaskBuilder $this$createTask_u24lambda_u246 = scriptingAlterTaskBuilder = (builder = new ScriptingAlterTaskBuilder(basicModel, basicModel2));
        boolean bl = false;
        $this$createTask_u24lambda_u246.setCorrespondence((Collection)this.migrationTree.computeCorrespondence());
        $this$createTask_u24lambda_u246.setOptions(this.appendCodeStyle(this.request.getOptions().getScriptingOptions()));
        $this$createTask_u24lambda_u246.setCurrentNamespace(this.request.getTargetNamespace());
        return scriptingAlterTaskBuilder.build();
    }

    private final void initializeMetaPropertiesDiffTable() {
        JTable jTable;
        this.propsDiffTableModel = new DbPropsDiffTableModel();
        DbPropsDiffTableModel dbPropsDiffTableModel = this.propsDiffTableModel;
        if (dbPropsDiffTableModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"propsDiffTableModel");
            dbPropsDiffTableModel = null;
        }
        if ((jTable = (this.propsDiffTable = (JTable)new JBTable((TableModel)dbPropsDiffTableModel))) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"propsDiffTable");
            jTable = null;
        }
        SdUtilsKt.setTableColors(jTable);
        JTable jTable2 = this.propsDiffTable;
        if (jTable2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"propsDiffTable");
            jTable2 = null;
        }
        jTable2.getTableHeader().setReorderingAllowed(false);
        DefaultTableCellRenderer renderer2 = new DefaultTableCellRenderer(this){
            final /* synthetic */ DbMigrationDialog this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public Component getTableCellRendererComponent(@Nullable JTable table, @Nullable Object value2, boolean isSelected, boolean hasFocus, int row, int column2) {
                Component component2 = super.getTableCellRendererComponent(table, value2, isSelected, hasFocus, row, column2);
                JTable jTable = DbMigrationDialog.access$getPropsDiffTable$p(this.this$0);
                if (jTable == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"propsDiffTable");
                    jTable = null;
                }
                if (!jTable.isRowSelected(row)) {
                    DiffStatus status;
                    DbPropsDiffTableModel dbPropsDiffTableModel = DbMigrationDialog.access$getPropsDiffTableModel$p(this.this$0);
                    if (dbPropsDiffTableModel == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"propsDiffTableModel");
                        dbPropsDiffTableModel = null;
                    }
                    component2.setBackground((status = dbPropsDiffTableModel.getRowStatus(row)) == DiffStatus.MODIFIED ? SdColorsKt.getBackground(status) : null);
                }
                Intrinsics.checkNotNull((Object)component2);
                return component2;
            }
        };
        JTable jTable3 = this.propsDiffTable;
        if (jTable3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"propsDiffTable");
            jTable3 = null;
        }
        jTable3.setDefaultRenderer(Object.class, renderer2);
    }

    @NotNull
    protected JComponent createCenterPanel() {
        JBSplitter jBSplitter;
        JBSplitter $this$createCenterPanel_u24lambda_u247 = jBSplitter = new JBSplitter(true);
        boolean bl = false;
        $this$createCenterPanel_u24lambda_u247.setFirstComponent((JComponent)this.createMainPanel());
        this.previewPane = this.createPreviewPane();
        JBTabbedPane jBTabbedPane = this.previewPane;
        if (jBTabbedPane == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"previewPane");
            jBTabbedPane = null;
        }
        $this$createCenterPanel_u24lambda_u247.setSecondComponent((JComponent)jBTabbedPane);
        JBSplitter splitter = jBSplitter;
        this.mainLoadingPanel.add((Component)splitter);
        return (JComponent)this.mainLoadingPanel;
    }

    private final JPanel createMainPanel() {
        JPanel jPanel;
        JPanel $this$createMainPanel_u24lambda_u248 = jPanel = new JPanel(new BorderLayout());
        boolean bl = false;
        $this$createMainPanel_u24lambda_u248.add((Component)this.createToolbarPanel(), "North");
        $this$createMainPanel_u24lambda_u248.add(this.createDiffPanel(), "Center");
        return jPanel;
    }

    private final Component createDiffPanel() {
        boolean useTreeTable = Registry.is((String)"database.schema.diff.table.view");
        return useTreeTable ? this.createDiffPanelTreeTable() : this.createDiffPanelTwoTrees();
    }

    private final Component createDiffPanelTwoTrees() {
        DbMigrationDiffPanel panel2 = new DbMigrationDiffPanel(this);
        this.diffPanel = panel2;
        return panel2;
    }

    private final Component createDiffPanelTreeTable() {
        JBScrollPane jBScrollPane;
        DbMigrationTableDiffPanel panel2 = new DbMigrationTableDiffPanel(this);
        this.diffPanel = panel2;
        JBScrollPane $this$createDiffPanelTreeTable_u24lambda_u249 = jBScrollPane = new JBScrollPane((Component)((Object)panel2));
        boolean bl = false;
        $this$createDiffPanelTreeTable_u24lambda_u249.setPreferredSize((Dimension)new JBDimension(1000, 480));
        return (Component)jBScrollPane;
    }

    private final JPanel createToolbarPanel() {
        JPanel jPanel;
        JPanel $this$createToolbarPanel_u24lambda_u2410 = jPanel = new JPanel(new BorderLayout());
        boolean bl = false;
        ActionToolbar toolbar2 = this.createToolbar();
        toolbar2.setTargetComponent((JComponent)$this$createToolbarPanel_u24lambda_u2410);
        $this$createToolbarPanel_u24lambda_u2410.add((Component)toolbar2.getComponent(), "West");
        this.addShowIdenticalCheckBox($this$createToolbarPanel_u24lambda_u2410);
        return jPanel;
    }

    private final void addShowIdenticalCheckBox(JPanel panel2) {
        this.showIdenticalCheckBox.addActionListener(arg_0 -> DbMigrationDialog.addShowIdenticalCheckBox$lambda$11(this, arg_0));
        panel2.add((Component)this.showIdenticalCheckBox, "East");
    }

    private final ActionToolbar createToolbar() {
        String string = DatabaseBundle.message("migration.toolbar.action.expand.all.text", new Object[0]);
        Object object = AllIcons.Actions.Expandall;
        DumbAwareAction expandAll2 = new DumbAwareAction(this, string, (Icon)object){
            final /* synthetic */ DbMigrationDialog this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, null, $super_call_param$2);
            }

            public void actionPerformed(@NotNull AnActionEvent e2) {
                Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
                DbMigrationDiffPanelBase dbMigrationDiffPanelBase = DbMigrationDialog.access$getDiffPanel$p(this.this$0);
                if (dbMigrationDiffPanelBase == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"diffPanel");
                    dbMigrationDiffPanelBase = null;
                }
                dbMigrationDiffPanelBase.expandAll();
            }
        };
        object = DatabaseBundle.message("migration.toolbar.action.collapse.all.text", new Object[0]);
        Object object2 = AllIcons.Actions.Collapseall;
        DumbAwareAction collapseAll2 = new DumbAwareAction(this, (String)object, (Icon)object2){
            final /* synthetic */ DbMigrationDialog this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, null, $super_call_param$2);
            }

            public void actionPerformed(@NotNull AnActionEvent e2) {
                Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
                DbMigrationDiffPanelBase dbMigrationDiffPanelBase = DbMigrationDialog.access$getDiffPanel$p(this.this$0);
                if (dbMigrationDiffPanelBase == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"diffPanel");
                    dbMigrationDiffPanelBase = null;
                }
                dbMigrationDiffPanelBase.collapseAll();
            }
        };
        object2 = DatabaseBundle.message("migration.toolbar.action.swap", new Object[0]);
        ActionToolbar actionToolbar = AllIcons.Actions.SwapPanels;
        DumbAwareAction swap2 = new DumbAwareAction(this, (String)object2, (Icon)actionToolbar){
            final /* synthetic */ DbMigrationDialog this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, null, $super_call_param$2);
            }

            public void actionPerformed(@NotNull AnActionEvent e2) {
                Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
                this.this$0.getRequest().swap();
                DbMigrationDiffPanelBase dbMigrationDiffPanelBase = DbMigrationDialog.access$getDiffPanel$p(this.this$0);
                if (dbMigrationDiffPanelBase == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"diffPanel");
                    dbMigrationDiffPanelBase = null;
                }
                dbMigrationDiffPanelBase.swapSourceLabels();
                DbMigrationDialog.access$reinitializeButtons(this.this$0);
                this.this$0.refreshTrees().onSuccess(arg_0 -> createToolbar.swap.1.actionPerformed$lambda$0((Function1)new Function1<Unit, Unit>(this, this.this$0){
                    final /* synthetic */ createToolbar.swap.1 this$0;
                    final /* synthetic */ DbMigrationDialog this$1;
                    {
                        this.this$0 = $receiver;
                        this.this$1 = $receiver2;
                        super(1);
                    }

                    public final void invoke(Unit it2) {
                        UIUtil.invokeLaterIfNeeded(() -> createToolbar.swap.actionPerformed.1.invoke$lambda$0(this.this$0, this.this$1));
                    }

                    private static final void invoke$lambda$0(createToolbar.swap.1 this$0, DbMigrationDialog this$1) {
                        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                        Intrinsics.checkNotNullParameter((Object)((Object)this$1), (String)"this$1");
                        createToolbar.swap.1.access$reinitializeScriptPreview(this$0);
                        this$1.refreshScript();
                        DbMigrationDiffPanelBase dbMigrationDiffPanelBase = DbMigrationDialog.access$getDiffPanel$p(this$1);
                        if (dbMigrationDiffPanelBase == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"diffPanel");
                            dbMigrationDiffPanelBase = null;
                        }
                        dbMigrationDiffPanelBase.refreshTreesUI();
                    }
                }, arg_0));
            }

            private final void reinitializeScriptPreview() {
                DbMigrationDialog.access$getScriptLoadingPanel$p(this.this$0).getContentPanel().remove((Component)DbMigrationDialog.access$getScriptPreview$p(this.this$0).getEditor());
                DbMigrationDialog.access$setScriptPreview$p(this.this$0, DbMigrationDialog.access$createScriptPreview(this.this$0));
                JBLoadingPanel jBLoadingPanel = DbMigrationDialog.access$getScriptLoadingPanel$p(this.this$0);
                EditorTextField editorTextField2 = DbMigrationDialog.access$getScriptPreview$p(this.this$0).getEditor();
                Intrinsics.checkNotNullExpressionValue((Object)editorTextField2, (String)"getEditor(...)");
                jBLoadingPanel.add((Component)editorTextField2);
                DbMigrationDialog.access$getScriptLoadingPanel$p(this.this$0).revalidate();
            }

            private static final void actionPerformed$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                $tmp0.invoke(p0);
            }

            public static final /* synthetic */ void access$reinitializeScriptPreview(createToolbar.swap.1 $this) {
                $this.reinitializeScriptPreview();
            }
        };
        actionToolbar = new Object[6];
        actionToolbar[0] = expandAll2;
        actionToolbar[1] = collapseAll2;
        Intrinsics.checkNotNullExpressionValue((Object)Separator.getInstance(), (String)"getInstance(...)");
        actionToolbar[3] = swap2;
        Intrinsics.checkNotNullExpressionValue((Object)Separator.getInstance(), (String)"getInstance(...)");
        actionToolbar[5] = this.createOptionsPopup();
        List actions = CollectionsKt.listOf((Object[])actionToolbar);
        actionToolbar = ActionManager.getInstance().createActionToolbar("database.migration.window", (ActionGroup)new DefaultActionGroup(actions), true);
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar, (String)"createActionToolbar(...)");
        return actionToolbar;
    }

    private final createOptionsPopup.1 createOptionsPopup() {
        Supplier<String> supplier2 = DatabaseBundle.messagePointer("action.options.text", new Object[0]);
        Supplier supplier3 = Presentation.NULL_STRING;
        Icon icon = AllIcons.General.GearPlain;
        return new DumbAware(this, supplier2, supplier3, icon){
            final /* synthetic */ DbMigrationDialog this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, $super_call_param$2, $super_call_param$3);
                this.setPopup(true);
                this.getTemplatePresentation().setPerformGroup(true);
                this.getTemplatePresentation().setDisableGroupIfEmpty(false);
            }

            public AnAction[] getChildren(@Nullable AnActionEvent e2) {
                return ActionGroup.EMPTY_ARRAY;
            }

            public void actionPerformed(@NotNull AnActionEvent e2) {
                Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
                JBPopup popup2 = DbMigrationOptionsPanelKt.createOptionsPopup(this.this$0.getRequest(), DbMigrationDialog.access$createTask(this.this$0), (Function1<? super ScriptingOptions, Unit>)((Function1)new Function1<ScriptingOptions, Unit>((Object)((Object)this.this$0)){

                    public final void invoke(@NotNull ScriptingOptions p0) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        DbMigrationDialog.access$onScriptingOptionsChange((DbMigrationDialog)((Object)this.receiver), p0);
                    }
                }), (Function0<Unit>)((Function0)new Function0<Unit>((Object)((Object)this.this$0)){

                    public final void invoke() {
                        DbMigrationDialog.access$onIgnoreImplicitChange((DbMigrationDialog)((Object)this.receiver));
                    }
                }), (Function0<Unit>)((Function0)new Function0<Unit>((Object)((Object)this.this$0)){

                    public final void invoke() {
                        ((DbMigrationDialog)((Object)this.receiver)).refresh();
                    }
                }));
                DbUIUtil.showPopup(popup2, null, e2);
            }
        };
    }

    private final void onScriptingOptionsChange(ScriptingOptions options2) {
        this.request.saveScriptingOptions(options2);
        this.refresh();
    }

    private final void onIgnoreImplicitChange() {
        boolean $i$f$runAsync = false;
        AsyncPromise promise$iv = new AsyncPromise();
        AppExecutorUtil.getAppExecutorService().execute(new Runnable(promise$iv, this){
            final /* synthetic */ AsyncPromise $promise;
            final /* synthetic */ DbMigrationDialog this$0;
            {
                this.$promise = $promise;
                this.this$0 = dbMigrationDialog;
            }

            public final void run() {
                Unit unit;
                try {
                    boolean bl = false;
                    this.this$0.getMigrationTree().recomputeDividerMappingAndCounters();
                    unit = Unit.INSTANCE;
                }
                catch (Throwable e2) {
                    this.$promise.setError(e2);
                    return;
                }
                Unit result2 = unit;
                this.$promise.setResult((Object)result2);
            }
        });
        ((Promise)promise$iv).onProcessed(arg_0 -> DbMigrationDialog.onIgnoreImplicitChange$lambda$13((Function1)new Function1<Unit, Unit>(this){
            final /* synthetic */ DbMigrationDialog this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(Unit it2) {
                UIUtil.invokeLaterIfNeeded(() -> onIgnoreImplicitChange.2.invoke$lambda$0(this.this$0));
                this.this$0.refreshScript();
            }

            private static final void invoke$lambda$0(DbMigrationDialog this$0) {
                Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                this$0.getMigrationTree().getOriginTreeModel().treeStructureChanged();
                this$0.getMigrationTree().getTargetTreeModel().treeStructureChanged();
                DbMigrationDiffPanelBase dbMigrationDiffPanelBase = DbMigrationDialog.access$getDiffPanel$p(this$0);
                if (dbMigrationDiffPanelBase == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"diffPanel");
                    dbMigrationDiffPanelBase = null;
                }
                dbMigrationDiffPanelBase.expandMappingNodes();
                DbMigrationDiffPanelBase dbMigrationDiffPanelBase2 = DbMigrationDialog.access$getDiffPanel$p(this$0);
                if (dbMigrationDiffPanelBase2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"diffPanel");
                    dbMigrationDiffPanelBase2 = null;
                }
                dbMigrationDiffPanelBase2.doRepaint();
            }
        }, arg_0));
    }

    private final ScriptingOptions appendCodeStyle(ScriptingOptions options2) {
        DelegateScriptingOptions result2 = new DelegateScriptingOptions(options2);
        result2.set(ScriptingOptionStatic.CODE_STYLE, ScriptingTaskBuilderKt.getCodeStyle(this.request.getDataSource(DbMigrationTreeModel.Side.TARGET)));
        return result2;
    }

    private final JBTabbedPane createPreviewPane() {
        JBTabbedPane tabbedPane = new JBTabbedPane(1);
        tabbedPane.setTabComponentInsets(null);
        EditorTextField editorTextField2 = this.scriptPreview.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editorTextField2, (String)"getEditor(...)");
        this.scriptLoadingPanel.add((Component)editorTextField2);
        tabbedPane.add(DatabaseBundle.message("tab.title.migration.script.preview", new Object[0]), (Component)this.scriptLoadingPanel);
        String string = DatabaseBundle.message("tab.title.migration.object.properties.diff", new Object[0]);
        JTable jTable = this.propsDiffTable;
        if (jTable == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"propsDiffTable");
            jTable = null;
        }
        tabbedPane.add(string, (Component)new JBScrollPane((Component)jTable));
        tabbedPane.add(DatabaseBundle.message("tab.title.migration.ddl.diff", new Object[0]), (Component)this.ddlDiffPanel.getComponent());
        tabbedPane.addChangeListener(arg_0 -> DbMigrationDialog.createPreviewPane$lambda$14(this, arg_0));
        return tabbedPane;
    }

    public final void updateCurrentPreviewPage(@Nullable DbMigrationTreeModel.Node node2) {
        int n;
        JBTabbedPane jBTabbedPane = this.previewPane;
        if (jBTabbedPane == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"previewPane");
            jBTabbedPane = null;
        }
        if ((n = jBTabbedPane.getSelectedIndex()) == this.PREVIEW_PROP_DIFF_INDEX) {
            this.updatePropsDiffTable(node2);
        } else if (n == this.PREVIEW_DDL_DIFF_INDEX) {
            this.updateDdlDiff(node2);
        }
    }

    private final void updatePropsDiffTable(DbMigrationTreeModel.Node node2) {
        if (node2 == null) {
            DbPropsDiffTableModel dbPropsDiffTableModel = this.propsDiffTableModel;
            if (dbPropsDiffTableModel == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"propsDiffTableModel");
                dbPropsDiffTableModel = null;
            }
            dbPropsDiffTableModel.clear();
            return;
        }
        DbMigrationElement dbMigrationElement = node2.getOrigin();
        BasicNode basicNode = dbMigrationElement != null ? dbMigrationElement.getBase() : null;
        BasicElement originElement = basicNode instanceof BasicElement ? (BasicElement)basicNode : null;
        DbMigrationElement dbMigrationElement2 = node2.getTarget();
        BasicNode basicNode2 = dbMigrationElement2 != null ? dbMigrationElement2.getBase() : null;
        BasicElement targetElement = basicNode2 instanceof BasicElement ? (BasicElement)basicNode2 : null;
        DbPropsDiffTableModel dbPropsDiffTableModel = this.propsDiffTableModel;
        if (dbPropsDiffTableModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"propsDiffTableModel");
            dbPropsDiffTableModel = null;
        }
        dbPropsDiffTableModel.setElements(originElement, targetElement, node2.getStatus());
    }

    private final void updateDdlDiff(DbMigrationTreeModel.Node node2) {
        this.ddlDiffPanel.updateRequest(node2);
    }

    @NlsContexts.Button
    private final String getOKButtonText() {
        String string;
        if (this.request.isToDdl()) {
            String string2 = DatabaseBundle.message("dialog.button.migration.script.dump", new Object[0]);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        } else {
            String string3 = DatabaseBundle.message("dialog.button.migration.script.execute", new Object[0]);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        }
        return string;
    }

    private final void reinitializeButtons() {
        this.setOKButtonText(this.getOKButtonText());
        this.southPanelWrapper.remove(0);
        this.createSouthPanel();
        this.southPanelWrapper.revalidate();
    }

    @NotNull
    protected JComponent createSouthPanel() {
        this.southPanelWrapper.add((Component)super.createSouthPanel(), "Center");
        return this.southPanelWrapper;
    }

    @NotNull
    protected Action[] createActions() {
        Object[] objectArray = super.createActions();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"createActions(...)");
        Object[] actions = objectArray;
        if (this.request.isToDdl()) {
            return actions;
        }
        String string = DatabaseBundle.message("dialog.button.migration.open.in.console", new Object[0]);
        DialogWrapper.DialogWrapperAction openInConsole2 = new DialogWrapper.DialogWrapperAction(this, string){
            final /* synthetic */ DbMigrationDialog this$0;
            {
                this.this$0 = $receiver;
                super((DialogWrapper)$receiver, $super_call_param$1);
            }

            protected void doAction(@Nullable ActionEvent e2) {
                RawDataSource rawDataSource = this.this$0.getRequest().getDataSource(DbMigrationTreeModel.Side.TARGET).getDelegate();
                LocalDataSource localDataSource = rawDataSource instanceof LocalDataSource ? (LocalDataSource)rawDataSource : null;
                if (localDataSource == null) {
                    return;
                }
                LocalDataSource dataSource2 = localDataSource;
                DbUIUtil.openInConsole(DbMigrationDialog.access$getProject(this.this$0), dataSource2, this.this$0.getRequest().getTargetNamespace(), DbMigrationDialog.access$getScriptPreview$p(this.this$0).getQuery(), false);
                this.this$0.close(0);
            }
        };
        openInConsole2.putValue("DefaultAction", (Object)true);
        return (Action[])ArraysKt.plus((Object[])actions, (Object)openInConsole2);
    }

    protected void doOKAction() {
        if (this.generatedWithErrors) {
            String string = DatabaseBundle.message("dialog.title.run.script.anyway", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String string2 = DatabaseBundle.message("dialog.message.generated.script.contains.errors", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            boolean runAnyway = ((MessageDialogBuilder.YesNo)MessageDialogBuilder.Companion.yesNo(string, string2).asWarning()).ask(this.getProject());
            if (!runAnyway) {
                return;
            }
        }
        this.perform();
        super.doOKAction();
    }

    private final void perform() {
        block1: {
            SqlDataSource sqlDs2;
            DbDataSource dataSource2 = this.request.getDataSource(DbMigrationTreeModel.Side.TARGET);
            LocalDataSource lds = DbImplUtil.getMaybeLocalDataSource(dataSource2);
            if (lds != null) {
                this.runScript(lds);
                return;
            }
            RawDataSource rawDataSource = dataSource2.getDelegate();
            SqlDataSource sqlDataSource = sqlDs2 = rawDataSource instanceof SqlDataSource ? (SqlDataSource)rawDataSource : null;
            if (sqlDataSource == null) break block1;
            SqlDataSource it2 = sqlDataSource;
            boolean bl = false;
            this.updateSqlDataSource(it2);
        }
    }

    private final AsyncTask<?> runScript(LocalDataSource localDataSource) {
        DatabaseRefactoringHandler handler2 = new DatabaseRefactoringHandler(this.getProject(), localDataSource, this.request.getTargetSearchPath());
        this.fillLoaderContext(handler2);
        AsyncTask<Boolean> asyncTask = handler2.setStatement(this.scriptPreview.getQuery()).runStatements(false);
        Intrinsics.checkNotNullExpressionValue(asyncTask, (String)"runStatements(...)");
        return asyncTask;
    }

    private final void fillLoaderContext(AbstractDatabaseModifier modifier) {
        Sequence $this$forEach$iv = SequencesKt.filterNotNull((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)this.migrationTree.computeCorrespondence()), (Function1)((Function1)fillLoaderContext.1.INSTANCE)));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BasicElement p0 = (BasicElement)element$iv;
            boolean bl = false;
            modifier.include(p0);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void updateSqlDataSource(SqlDataSource ds) {
        void $this$fold$iv;
        ScriptingSingleModelTaskBuilder scriptingSingleModelTaskBuilder = DatabaseScriptDialog.prepareCreationTask(this.createTask());
        Intrinsics.checkNotNullExpressionValue((Object)scriptingSingleModelTaskBuilder, (String)"prepareCreationTask(...)");
        ScriptingSingleModelTaskBuilder builder = scriptingSingleModelTaskBuilder;
        List customizations = SchemaDiffCustomization.Companion.getEP().getExtensionList();
        FilteredTraverserBase filteredTraverserBase = ((JBTreeTraverser)builder.getModel().basicTraverser().withRoots((Iterable)builder.getElements())).filter(arg_0 -> DbMigrationDialog.updateSqlDataSource$lambda$16(updateSqlDataSource.originalElements.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)filteredTraverserBase, (String)"filter(...)");
        JBTreeTraverser<BasicElement> originalElements2 = (JBTreeTraverser<BasicElement>)filteredTraverserBase;
        Iterable iterable = customizations;
        boolean $i$f$fold = false;
        JBTreeTraverser<BasicElement> accumulator$iv = originalElements2;
        for (Object element$iv : $this$fold$iv) {
            void customization;
            SchemaDiffCustomization schemaDiffCustomization = (SchemaDiffCustomization)element$iv;
            JBTreeTraverser<BasicElement> e2 = accumulator$iv;
            boolean bl = false;
            accumulator$iv = customization.filterElementsBeforeGeneration(this.getProject(), ds, e2);
        }
        JBIterable jBIterable = accumulator$iv.bfsTraversal();
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"bfsTraversal(...)");
        JBIterable elements2 = jBIterable;
        Set<VirtualFile> files2 = DumpToDdlDataSourceActionKt.dump(this.getProject(), ds, builder.getModel(), (Iterable)elements2, false);
        DumpToDdlDataSourceActionKt.selectFile(this.getProject(), files2);
    }

    @NotNull
    protected String getHelpId() {
        return "Differences_viewer_for_database_objects";
    }

    private static final void createScriptPreview$lambda$0(DbMigrationDialog this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.close(1);
    }

    private static final void refresh$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void refreshTrees$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void refreshScript$lambda$5$lambda$4(Function0 $tmp0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke();
    }

    private static final void refreshScript$lambda$5(DbMigrationDialog this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Function0 process2 = (Function0)new Function0<Unit>(this$0){
            final /* synthetic */ DbMigrationDialog this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                ScriptingResult script2 = DbMigrationDialog.access$generate(this.this$0);
                DbMigrationDialog.access$setGeneratedWithErrors$p(this.this$0, SequencesKt.count((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)script2.getScript().getFragments()), (Function1)refreshScript.1.process.1.INSTANCE)) > 0);
                String text2 = script2.getScriptText();
                if (!this.this$0.isDisposed()) {
                    UIUtil.invokeLaterIfNeeded(() -> refreshScript.1.process.1.invoke$lambda$0(this.this$0, text2));
                }
            }

            private static final void invoke$lambda$0(DbMigrationDialog this$0, String $text) {
                Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$text, (String)"$text");
                DbMigrationDialog.access$getScriptPreview$p(this$0).setQuery($text);
                DbMigrationDialog.access$getScriptLoadingPanel$p(this$0).stopLoading();
            }
        };
        ProgressManager.getInstance().runProcess(() -> DbMigrationDialog.refreshScript$lambda$5$lambda$4(process2), this$0.scriptGenerationProgress);
    }

    private static final void addShowIdenticalCheckBox$lambda$11(DbMigrationDialog this$0, ActionEvent it2) {
        DbMigrationDiffPanelBase p2;
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.migrationTree.setShowIdentical(this$0.showIdenticalCheckBox.isSelected());
        DbMigrationDiffPanelBase dbMigrationDiffPanelBase = this$0.diffPanel;
        if (dbMigrationDiffPanelBase == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"diffPanel");
            dbMigrationDiffPanelBase = null;
        }
        if ((p2 = dbMigrationDiffPanelBase) instanceof DbMigrationTableDiffPanel) {
            ((DbMigrationTableDiffPanel)p2).treeStructureChanged();
        }
        p2.expandMappingNodes();
        p2.repaintDivider();
    }

    private static final void onIgnoreImplicitChange$lambda$13(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void createPreviewPane$lambda$14(DbMigrationDialog this$0, ChangeEvent it2) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        DbMigrationDiffPanelBase dbMigrationDiffPanelBase = this$0.diffPanel;
        if (dbMigrationDiffPanelBase == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"diffPanel");
            dbMigrationDiffPanelBase = null;
        }
        this$0.updateCurrentPreviewPage(dbMigrationDiffPanelBase.getSelectedNode());
    }

    private static final boolean updateSqlDataSource$lambda$16(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ DbMigrationDiffPanelBase access$getDiffPanel$p(DbMigrationDialog $this) {
        return $this.diffPanel;
    }

    public static final /* synthetic */ JBLoadingPanel access$getMainLoadingPanel$p(DbMigrationDialog $this) {
        return $this.mainLoadingPanel;
    }

    public static final /* synthetic */ JTable access$getPropsDiffTable$p(DbMigrationDialog $this) {
        return $this.propsDiffTable;
    }

    public static final /* synthetic */ DbPropsDiffTableModel access$getPropsDiffTableModel$p(DbMigrationDialog $this) {
        return $this.propsDiffTableModel;
    }

    public static final /* synthetic */ void access$reinitializeButtons(DbMigrationDialog $this) {
        $this.reinitializeButtons();
    }

    public static final /* synthetic */ JBLoadingPanel access$getScriptLoadingPanel$p(DbMigrationDialog $this) {
        return $this.scriptLoadingPanel;
    }

    public static final /* synthetic */ SqlPreviewComponent access$getScriptPreview$p(DbMigrationDialog $this) {
        return $this.scriptPreview;
    }

    public static final /* synthetic */ void access$setScriptPreview$p(DbMigrationDialog $this, SqlPreviewComponent sqlPreviewComponent) {
        $this.scriptPreview = sqlPreviewComponent;
    }

    public static final /* synthetic */ SqlPreviewComponent access$createScriptPreview(DbMigrationDialog $this) {
        return $this.createScriptPreview();
    }

    public static final /* synthetic */ ScriptingTask access$createTask(DbMigrationDialog $this) {
        return $this.createTask();
    }

    public static final /* synthetic */ void access$onScriptingOptionsChange(DbMigrationDialog $this, ScriptingOptions options2) {
        $this.onScriptingOptionsChange(options2);
    }

    public static final /* synthetic */ void access$onIgnoreImplicitChange(DbMigrationDialog $this) {
        $this.onIgnoreImplicitChange();
    }

    public static final /* synthetic */ Project access$getProject(DbMigrationDialog $this) {
        return $this.getProject();
    }

    public static final /* synthetic */ void access$initializeTreeModel(DbMigrationDialog $this) {
        $this.initializeTreeModel();
    }

    public static final /* synthetic */ ProgressIndicator access$getTreesInitializationProgress$p(DbMigrationDialog $this) {
        return $this.treesInitializationProgress;
    }

    public static final /* synthetic */ ScriptingResult access$generate(DbMigrationDialog $this) {
        return $this.generate();
    }

    public static final /* synthetic */ void access$setGeneratedWithErrors$p(DbMigrationDialog $this, boolean bl) {
        $this.generatedWithErrors = bl;
    }
}

