/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.meta;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicDataObject;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModRoot;
import com.intellij.database.model.basic.BasicModSourceAware;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.meta.BasicMetaField;
import com.intellij.database.model.meta.BasicMetaId;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.meta.BasicMetaProperty;
import com.intellij.database.model.meta.BasicMetaPropertyId;
import com.intellij.database.model.meta.BasicMetaReference;
import com.intellij.database.model.meta.BasicMetaReferenceDesc;
import com.intellij.database.model.meta.BasicMetaReferenceId;
import com.intellij.database.model.meta.BasicMetaReferenceList;
import com.intellij.database.model.meta.BasicMetaReferenceListId;
import com.intellij.database.model.meta.BasicMetaType;
import com.intellij.database.model.meta.BasicResolveAssistant;
import com.intellij.database.model.properties.BasicReference;
import com.intellij.database.model.properties.BasicReferenceInfo;
import com.intellij.database.model.properties.references.BasicInlineObjectReference;
import com.intellij.database.model.properties.references.BasicNameReference;
import com.intellij.database.model.properties.references.BasicParentReference;
import com.intellij.database.model.properties.references.BasicResolvedReference;
import com.intellij.database.psi.DbPresentationCore;
import com.intellij.database.remote.jdba.util.Function;
import com.intellij.database.util.BasicPaths;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBTreeTraverser;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BasicMetaUtils {
    public static final Comparator<BasicMetaObject<?>> PRESENTATION_COMPARATOR = Comparator.comparing(m -> DbPresentationCore.getWeight(m.kind, 0));

    @Nullable
    public static <T extends BasicElement> BasicMetaObject<T> findChild(@Nullable BasicMetaObject<?> obj2, @NotNull ObjectKind kind) {
        if (kind == null) {
            BasicMetaUtils.$$$reportNull$$$0(0);
        }
        if (obj2 == null) {
            return null;
        }
        for (BasicMetaObject<?> child : obj2.children) {
            if (child.kind != kind) continue;
            return child;
        }
        return null;
    }

    @Nullable
    public static BasicMetaObject<?> findChild(@Nullable BasicMetaObject<?> obj2, @NotNull Predicate<BasicMetaObject<?>> p2) {
        if (p2 == null) {
            BasicMetaUtils.$$$reportNull$$$0(1);
        }
        if (obj2 == null) {
            return null;
        }
        for (BasicMetaObject<?> child : obj2.children) {
            if (!p2.test(child)) continue;
            return child;
        }
        return null;
    }

    public static boolean isAncestor(@Nullable BasicMetaObject<?> ancestor, @Nullable BasicMetaObject<?> child, boolean strict) {
        if (ancestor == null || child == null) {
            return false;
        }
        if (strict && child == ancestor) {
            return false;
        }
        for (BasicMetaObject<?> tmp = child; tmp != null; tmp = tmp.getParent()) {
            if (tmp != ancestor) continue;
            return true;
        }
        return false;
    }

    public static boolean copyProperties(@NotNull BasicElement from, @NotNull BasicModElement to, boolean withSources, boolean makePortable) {
        if (from == null) {
            BasicMetaUtils.$$$reportNull$$$0(2);
        }
        if (to == null) {
            BasicMetaUtils.$$$reportNull$$$0(3);
        }
        return BasicMetaUtils.copyPropertiesImpl((BasicModElement)from, to, withSources, makePortable);
    }

    private static <E extends BasicModElement> boolean copyPropertiesImpl(@NotNull E from, @NotNull E to, boolean withSources, boolean makePortable) {
        if (from == null) {
            BasicMetaUtils.$$$reportNull$$$0(4);
        }
        if (to == null) {
            BasicMetaUtils.$$$reportNull$$$0(5);
        }
        BasicMetaObject<E> meta = BasicMetaUtils.getMetaObject(to);
        BasicMetaObject<E> meta2 = BasicMetaUtils.getMetaObject(from);
        assert (meta == meta2) : "Trying to copy " + from.getClass().getName() + " to " + to.getClass().getName();
        boolean changed = false;
        for (BasicMetaProperty p2 : meta.getAllProperties()) {
            if (p2.isAbstract()) continue;
            changed |= BasicMetaUtils.copyProperty(from, to, p2, makePortable);
        }
        return changed |= BasicMetaUtils.copySources(from, to, withSources);
    }

    private static <E extends BasicModElement> void copyStoredReference(@NotNull E from, @NotNull E to, BasicMetaReference<E, ?> r, boolean makePortable) {
        if (from == null) {
            BasicMetaUtils.$$$reportNull$$$0(6);
        }
        if (to == null) {
            BasicMetaUtils.$$$reportNull$$$0(7);
        }
        BasicMetaUtils.copyStoredReference(from, r, to, r, makePortable);
    }

    private static <E extends BasicModElement, E2 extends BasicModElement> boolean copyStoredReference(@NotNull E from, @NotNull BasicMetaReference<E, ?> r1, @NotNull E2 to, @NotNull BasicMetaReference<E2, ?> r2, boolean makePortable) {
        BasicReference ref2;
        if (from == null) {
            BasicMetaUtils.$$$reportNull$$$0(8);
        }
        if (r1 == null) {
            BasicMetaUtils.$$$reportNull$$$0(9);
        }
        if (to == null) {
            BasicMetaUtils.$$$reportNull$$$0(10);
        }
        if (r2 == null) {
            BasicMetaUtils.$$$reportNull$$$0(11);
        }
        BasicReference ref22 = (ref2 = (BasicReference)r1.get(from)) == null || !makePortable ? ref2 : BasicMetaUtils.createPortableReference(from, r1.getReferenceDesc(), ref2);
        BasicReference prev = (BasicReference)r2.get(to);
        r2.set(to, ref22);
        return !r2.id.type.hStrategy.equals((Object)prev, (Object)((BasicReference)r2.get(to)));
    }

    public static boolean copySources(@NotNull BasicElement from, @NotNull BasicModElement to, boolean withSources) {
        if (from == null) {
            BasicMetaUtils.$$$reportNull$$$0(12);
        }
        if (to == null) {
            BasicMetaUtils.$$$reportNull$$$0(13);
        }
        if (to instanceof BasicModSourceAware) {
            BasicSourceAware o2 = withSources ? (BasicSourceAware)ObjectUtils.tryCast((Object)from, BasicSourceAware.class) : null;
            BasicModel model2 = to.getModel();
            if (model2 != null) {
                model2.writeSources(() -> ((BasicModSourceAware)to).setSourceText(o2 == null ? null : o2.getSourceText()));
                return true;
            }
        }
        return false;
    }

    public static void copyMatchedProperties(@NotNull BasicElement from, @NotNull BasicModElement to, boolean resetOther, boolean withSources, boolean makePortable) {
        if (from == null) {
            BasicMetaUtils.$$$reportNull$$$0(14);
        }
        if (to == null) {
            BasicMetaUtils.$$$reportNull$$$0(15);
        }
        BasicMetaUtils.copyMatchedPropertiesImpl((BasicModElement)from, to, resetOther, withSources, makePortable, null);
    }

    public static <E extends BasicModElement, E2 extends BasicModElement> void copyMatchedPropertiesImpl(@NotNull E from, @NotNull E2 to, boolean resetOther, boolean withSources, boolean makePortable, @Nullable Condition<BasicMetaId> filter2) {
        if (from == null) {
            BasicMetaUtils.$$$reportNull$$$0(16);
        }
        if (to == null) {
            BasicMetaUtils.$$$reportNull$$$0(17);
        }
        BasicMetaUtils.copyMatchedPropertiesImpl2(from, to, resetOther, makePortable, f -> f.isAbstract() && f.getId() != BasicModSourceAware.SOURCE_TEXT && (filter2 == null || filter2.value((Object)f.getId())));
        BasicMetaUtils.copyMatchedPropertiesImpl2(from, to, resetOther, makePortable, f -> !f.isAbstract() && (filter2 == null || filter2.value((Object)f.getId())));
        BasicMetaUtils.copySourceText(from, to, withSources, resetOther);
    }

    private static <E extends BasicModElement, E2 extends BasicModElement> void copyMatchedPropertiesImpl2(@NotNull E from, @NotNull E2 to, boolean resetOther, boolean makePortable, @Nullable Condition<BasicMetaField<E2>> filter2) {
        if (from == null) {
            BasicMetaUtils.$$$reportNull$$$0(18);
        }
        if (to == null) {
            BasicMetaUtils.$$$reportNull$$$0(19);
        }
        BasicMetaObject<E2> toMeta = BasicMetaUtils.getMetaObject(to);
        for (BasicMetaProperty property : toMeta.getAllProperties()) {
            if (property.id == BasicModRoot.DBMS || filter2 != null && !filter2.value((Object)property)) continue;
            BasicMetaUtils.copyMatchedProperty(from, to, property, resetOther, makePortable);
        }
    }

    public static void copySourceText(@NotNull BasicElement from, @NotNull BasicModElement to, boolean withSources, boolean resetOther) {
        if (from == null) {
            BasicMetaUtils.$$$reportNull$$$0(20);
        }
        if (to == null) {
            BasicMetaUtils.$$$reportNull$$$0(21);
        }
        BasicSourceAware fromSourceAware = (BasicSourceAware)ObjectUtils.tryCast((Object)from, BasicSourceAware.class);
        BasicModSourceAware toSourceAware = (BasicModSourceAware)ObjectUtils.tryCast((Object)to, BasicModSourceAware.class);
        if (toSourceAware == null) {
            return;
        }
        if (withSources && fromSourceAware != null) {
            toSourceAware.setSourceText(fromSourceAware.getSourceText());
        } else if (resetOther) {
            toSourceAware.setSourceText(null);
        }
    }

    private static <E extends BasicModElement, E2 extends BasicModElement, T> void copyMatchedProperty(@NotNull E from, @NotNull E2 to, @NotNull BasicMetaProperty<E2, T> p2, boolean resetOther, boolean makePortable) {
        if (from == null) {
            BasicMetaUtils.$$$reportNull$$$0(22);
        }
        if (to == null) {
            BasicMetaUtils.$$$reportNull$$$0(23);
        }
        if (p2 == null) {
            BasicMetaUtils.$$$reportNull$$$0(24);
        }
        BasicMetaProperty<E, ?> p1 = BasicMetaUtils.findMatchingProperty(BasicMetaUtils.getMetaObject(from).getAllProperties(), p2);
        boolean copied = false;
        if (p1 != null) {
            boolean bl = copied = BasicMetaUtils.copyProperty(from, p1, to, p2, makePortable) != ThreeState.UNSURE;
        }
        if (!copied && resetOther) {
            p2.set(to, p2.getDefaultValue());
        }
    }

    @Nullable
    public static <E extends BasicElement> BasicMetaProperty<E, ?> findProperty(Iterable<BasicMetaProperty<E, ?>> properties2, String name2) {
        for (BasicMetaProperty<E, ?> property : properties2) {
            if (!property.id.name.equals(name2)) continue;
            return property;
        }
        return null;
    }

    private static <E extends BasicModElement, T> BasicMetaProperty<E, ?> findMatchingProperty(Iterable<BasicMetaProperty<E, ?>> properties2, BasicMetaProperty<?, T> p2) {
        BasicMetaReferenceDesc desc2;
        BasicMetaProperty<E, ?> res2 = BasicMetaUtils.findProperty(properties2, p2.id.name);
        if (res2 != null && !res2.id.getValueClass().equals(p2.id.getValueClass())) {
            return null;
        }
        BasicMetaReferenceDesc desc1 = p2 instanceof BasicMetaReference ? ((BasicMetaReference)p2).getReferenceDesc() : null;
        if (desc1 == null != ((desc2 = res2 instanceof BasicMetaReference ? ((BasicMetaReference)res2).getReferenceDesc() : null) == null)) {
            return null;
        }
        if (desc1 != null && desc2 != null) {
            boolean differentTargets = desc2.targets.length > 0 && desc1.targets.length > 0 && desc2.targets[0].kind != desc1.targets[0].kind;
            return differentTargets ? null : res2;
        }
        return res2;
    }

    private static <E extends BasicModElement, T> boolean copyProperty(@NotNull E from, @NotNull E to, @NotNull BasicMetaProperty<E, T> prop, boolean makePortable) {
        if (from == null) {
            BasicMetaUtils.$$$reportNull$$$0(25);
        }
        if (to == null) {
            BasicMetaUtils.$$$reportNull$$$0(26);
        }
        if (prop == null) {
            BasicMetaUtils.$$$reportNull$$$0(27);
        }
        return BasicMetaUtils.copyPropertyInner(from, prop, to, prop, null, makePortable) == ThreeState.YES;
    }

    private static <E extends BasicModElement, E2 extends BasicModElement, T, U> ThreeState copyPropertyInner(@NotNull E from, @NotNull BasicMetaProperty<E, T> p1, @NotNull E2 to, @NotNull BasicMetaProperty<E2, U> p2, @Nullable Function<T, U> converter, boolean makePortable) {
        BasicMetaReference r2;
        BasicMetaReference r1;
        if (from == null) {
            BasicMetaUtils.$$$reportNull$$$0(28);
        }
        if (p1 == null) {
            BasicMetaUtils.$$$reportNull$$$0(29);
        }
        if (to == null) {
            BasicMetaUtils.$$$reportNull$$$0(30);
        }
        if (p2 == null) {
            BasicMetaUtils.$$$reportNull$$$0(31);
        }
        if ((r1 = p1 instanceof BasicMetaReference ? (BasicMetaReference)p1 : null) == null != ((r2 = p2 instanceof BasicMetaReference ? (BasicMetaReference)p2 : null) == null)) {
            return ThreeState.UNSURE;
        }
        if (r1 != null && r2 != null) {
            return ThreeState.fromBoolean((boolean)BasicMetaUtils.copyStoredReference(from, r1, to, r2, makePortable));
        }
        T val = p1.get(from);
        T newVal = converter == null ? val : converter.apply(val);
        U prev = p2.get(to);
        p2.set(to, newVal);
        return ThreeState.fromBoolean((!p2.id.type.hStrategy.equals(prev, p2.get(to)) ? 1 : 0) != 0);
    }

    private static <E extends BasicModElement, E2 extends BasicModElement, T, U> ThreeState copyProperty(@NotNull E from, @NotNull BasicMetaProperty<E, T> p1, @NotNull E2 to, @NotNull BasicMetaProperty<E2, U> p2, boolean makePortable) {
        if (from == null) {
            BasicMetaUtils.$$$reportNull$$$0(32);
        }
        if (p1 == null) {
            BasicMetaUtils.$$$reportNull$$$0(33);
        }
        if (to == null) {
            BasicMetaUtils.$$$reportNull$$$0(34);
        }
        if (p2 == null) {
            BasicMetaUtils.$$$reportNull$$$0(35);
        }
        Function cvt = null;
        if (p1.id.type != p2.id.type && (cvt = BasicMetaUtils.getConverter(p1.id.type, p2.id.type)) == null) {
            return ThreeState.UNSURE;
        }
        return BasicMetaUtils.copyPropertyInner(from, p1, to, p2, cvt, makePortable);
    }

    private static <U, T> Function<T, U> getConverter(BasicMetaType<T> from, BasicMetaType<U> to) {
        if (from == to) {
            return x -> x;
        }
        if (String.class.isAssignableFrom(to.valueClass)) {
            return x -> x.toString();
        }
        if (Number.class.isAssignableFrom(to.getBoxedValueClass()) && Number.class.isAssignableFrom(from.getBoxedValueClass())) {
            return x -> {
                try {
                    return to.importer.fun((Object)x.toString());
                }
                catch (Throwable e2) {
                    return null;
                }
            };
        }
        return null;
    }

    public static int hashCode(@Nullable BasicElement e2) {
        if (e2 == null) {
            return 0;
        }
        return BasicMetaUtils.hashCodeImpl(e2);
    }

    private static <E extends BasicElement> int hashCodeImpl(@NotNull E e2) {
        if (e2 == null) {
            BasicMetaUtils.$$$reportNull$$$0(36);
        }
        BasicMetaObject<E> meta = BasicMetaUtils.getMetaObject(e2);
        int hash = meta.hashCode();
        for (BasicMetaProperty property : meta.getAllProperties()) {
            if (property.isAbstract()) continue;
            hash = 31 * hash + BasicMetaUtils.hashCode(property, e2);
        }
        return hash == 0 ? 1 : hash;
    }

    public static <E extends BasicElement, V> int hashCode(BasicMetaProperty<E, V> property, @NotNull E e2) {
        if (e2 == null) {
            BasicMetaUtils.$$$reportNull$$$0(37);
        }
        V v2 = property.get(e2);
        return property.id.type.hStrategy.hashCode(v2);
    }

    public static boolean equals(@NotNull BasicElement e1, @NotNull BasicElement e2) {
        BasicMetaObject<?> meta2;
        if (e1 == null) {
            BasicMetaUtils.$$$reportNull$$$0(38);
        }
        if (e2 == null) {
            BasicMetaUtils.$$$reportNull$$$0(39);
        }
        if (e1 == e2) {
            return true;
        }
        BasicMetaObject<?> meta1 = e1.getMetaObject();
        if (meta1 != (meta2 = e2.getMetaObject())) {
            return false;
        }
        return BasicMetaUtils.equalsImpl(e1, e2);
    }

    private static <E extends BasicElement> boolean equalsImpl(@NotNull E e1, @NotNull E e2) {
        if (e1 == null) {
            BasicMetaUtils.$$$reportNull$$$0(40);
        }
        if (e2 == null) {
            BasicMetaUtils.$$$reportNull$$$0(41);
        }
        BasicMetaObject<E> meta = BasicMetaUtils.getMetaObject(e1);
        for (BasicMetaProperty property : meta.getAllProperties()) {
            if (property.isAbstract() || BasicMetaUtils.equals(property, e1, e2)) continue;
            return false;
        }
        return true;
    }

    public static <E extends BasicElement, V> boolean equals(@NotNull BasicMetaProperty<E, V> property, @NotNull E e1, @NotNull E e2) {
        if (property == null) {
            BasicMetaUtils.$$$reportNull$$$0(42);
        }
        if (e1 == null) {
            BasicMetaUtils.$$$reportNull$$$0(43);
        }
        if (e2 == null) {
            BasicMetaUtils.$$$reportNull$$$0(44);
        }
        V v1 = property.get(e1);
        V v2 = property.get(e2);
        return property.id.type.hStrategy.equals(v1, v2);
    }

    @Nullable
    public static <F extends Family<T>, T extends BasicElement> F getFamily(@Nullable BasicElement e2, BasicMetaObject<T> meta) {
        Family<? extends BasicElement> res2;
        Family<? extends BasicElement> family = res2 = e2 == null ? null : e2.familyOf(meta.kind);
        if (res2 == null || res2.getMetaObject() != meta) {
            return null;
        }
        return (F)res2;
    }

    @NotNull
    public static <T extends BasicElement> BasicMetaObject<T> getMetaObject(@NotNull T to) {
        if (to == null) {
            BasicMetaUtils.$$$reportNull$$$0(45);
        }
        BasicMetaObject<?> basicMetaObject = to.getMetaObject();
        if (basicMetaObject == null) {
            BasicMetaUtils.$$$reportNull$$$0(46);
        }
        return basicMetaObject;
    }

    @NotNull
    public static <T extends BasicElement> BasicMetaObject<T> getMetaObject(@NotNull Family<T> to) {
        if (to == null) {
            BasicMetaUtils.$$$reportNull$$$0(47);
        }
        BasicMetaObject<?> basicMetaObject = to.getMetaObject();
        if (basicMetaObject == null) {
            BasicMetaUtils.$$$reportNull$$$0(48);
        }
        return basicMetaObject;
    }

    public static void makePortable(@NotNull BasicElement e2) {
        if (e2 == null) {
            BasicMetaUtils.$$$reportNull$$$0(49);
        }
        for (BasicMetaReference ref2 : BasicMetaUtils.getMetaObject(e2).getAllProperties().filterMap(BasicMetaReference::asRef)) {
            if (ref2.isAbstract()) continue;
            BasicMetaUtils.makeReferencePortable(e2, ref2);
        }
    }

    public static void makeReferencePortable(@NotNull BasicElement e2, @NotNull BasicMetaReferenceId<?> refId) {
        if (e2 == null) {
            BasicMetaUtils.$$$reportNull$$$0(50);
        }
        if (refId == null) {
            BasicMetaUtils.$$$reportNull$$$0(51);
        }
        BasicMetaUtils.makeReferencePortable(e2, BasicMetaUtils.getMetaObject(e2).getReference(refId));
    }

    public static <S extends BasicElement> void makeReferencePortable(@NotNull S e2, @NotNull BasicMetaReference<S, ?> metaRef) {
        BasicReference ref2;
        if (e2 == null) {
            BasicMetaUtils.$$$reportNull$$$0(52);
        }
        if (metaRef == null) {
            BasicMetaUtils.$$$reportNull$$$0(53);
        }
        if ((ref2 = (BasicReference)metaRef.get(e2)) == null) {
            return;
        }
        BasicReference portable = BasicMetaUtils.createPortableReference(e2, metaRef.getReferenceDesc(), ref2);
        if (ref2 != portable) {
            metaRef.set(e2, portable);
        }
    }

    public static void makeResolved(@NotNull BasicElement e2) {
        if (e2 == null) {
            BasicMetaUtils.$$$reportNull$$$0(54);
        }
        for (BasicMetaReference ref2 : BasicMetaUtils.getMetaObject(e2).getAllProperties().filterMap(BasicMetaReference::asRef)) {
            if (ref2.isAbstract()) continue;
            BasicMetaUtils.makeReferenceResolved(e2, ref2);
        }
    }

    public static <S extends BasicElement> void makeReferenceResolved(@NotNull S e2, @NotNull BasicMetaReference<S, ?> metaRef) {
        Object resolved;
        if (e2 == null) {
            BasicMetaUtils.$$$reportNull$$$0(55);
        }
        if (metaRef == null) {
            BasicMetaUtils.$$$reportNull$$$0(56);
        }
        if ((resolved = BasicMetaUtils.resolve(e2, metaRef)) != null) {
            metaRef.set(e2, new BasicResolvedReference((BasicElement)resolved));
        }
    }

    public static void makeInlinesMutable(@NotNull BasicElement e2) {
        if (e2 == null) {
            BasicMetaUtils.$$$reportNull$$$0(57);
        }
        for (BasicMetaReference ref2 : BasicMetaUtils.getMetaObject(e2).getAllProperties().filterMap(BasicMetaReference::asRef)) {
            if (ref2.isAbstract()) continue;
            BasicMetaUtils.makeInlineReferenceMutable(e2, ref2);
        }
    }

    public static <S extends BasicElement, T extends BasicElement> void makeInlineReferenceMutable(@NotNull S e2, @NotNull BasicMetaReference<S, T> metaRef) {
        Object data;
        BasicReference ref2;
        if (e2 == null) {
            BasicMetaUtils.$$$reportNull$$$0(58);
        }
        if (metaRef == null) {
            BasicMetaUtils.$$$reportNull$$$0(59);
        }
        if ((ref2 = (BasicReference)metaRef.get(e2)) instanceof BasicInlineObjectReference && ((BasicDataObject)(data = ref2.getInlineData(metaRef.getReferenceDesc()))).isFrozen()) {
            metaRef.set(e2, BasicInlineObjectReference.createMutable(data));
        }
    }

    @Nullable
    public static <S extends BasicElement, T extends BasicElement> T resolve(@Nullable S e2, @NotNull BasicMetaReferenceId<T> refId, @NotNull BasicResolveAssistant assistant) {
        if (refId == null) {
            BasicMetaUtils.$$$reportNull$$$0(60);
        }
        if (assistant == null) {
            BasicMetaUtils.$$$reportNull$$$0(61);
        }
        if (e2 == null) {
            return null;
        }
        BasicMetaReference<S, T> metaRef = refId.find(e2);
        if (metaRef == null) {
            return null;
        }
        return BasicMetaUtils.resolve(e2, metaRef.getReferenceDesc(), metaRef == null ? null : (BasicReference)metaRef.get(e2), assistant);
    }

    @Nullable
    public static <S extends BasicElement, T extends BasicElement> T resolve(@Nullable S e2, @NotNull BasicMetaReferenceId<T> refId, @Nullable BasicReference ref2) {
        if (refId == null) {
            BasicMetaUtils.$$$reportNull$$$0(62);
        }
        if (ref2 == null || e2 == null) {
            return null;
        }
        return BasicMetaUtils.resolve(e2, refId.find(e2), ref2);
    }

    public static <S extends BasicElement, T extends BasicElement> @NotNull List<@Nullable T> resolve(@Nullable S e2, @NotNull BasicMetaReferenceListId<T> refId, @NotNull List<BasicReference> ref2) {
        if (refId == null) {
            BasicMetaUtils.$$$reportNull$$$0(63);
        }
        if (ref2 == null) {
            BasicMetaUtils.$$$reportNull$$$0(64);
        }
        if (ref2 == null || e2 == null) {
            if (null == null) {
                BasicMetaUtils.$$$reportNull$$$0(65);
            }
            return null;
        }
        return BasicMetaUtils.resolve(e2, refId.find(e2), ref2);
    }

    @Nullable
    public static <S extends BasicElement, T extends BasicElement> T resolve(@Nullable S e2, @Nullable BasicMetaReference<S, T> metaRef, @Nullable BasicReference ref2) {
        return e2 == null || ref2 == null || metaRef == null ? null : (T)BasicMetaUtils.resolve(e2, metaRef.getReferenceDesc(), ref2);
    }

    @Nullable
    public static <S extends BasicElement, T extends BasicElement> T resolve(@Nullable S e2, @NotNull BasicMetaReferenceDesc<S, T> desc, @Nullable BasicReference ref2) {
        if (desc == null) {
            BasicMetaUtils.$$$reportNull$$$0(66);
        }
        return BasicMetaUtils.resolve(e2, desc, ref2, BasicResolveAssistant.DEFAULT);
    }

    @Nullable
    public static <S extends BasicElement, T extends BasicElement> T resolve(@Nullable S e2, @NotNull BasicMetaReferenceDesc<S, T> desc, @Nullable BasicReference ref2, @NotNull BasicResolveAssistant assistant) {
        if (desc == null) {
            BasicMetaUtils.$$$reportNull$$$0(67);
        }
        if (assistant == null) {
            BasicMetaUtils.$$$reportNull$$$0(68);
        }
        return e2 == null || ref2 == null ? null : (T)ref2.resolve(e2, desc, assistant);
    }

    @Nullable
    public static <S extends BasicElement> BasicElement getResolveBase(@NotNull S source, @NotNull BasicMetaReferenceDesc<S, ?> meta, @NotNull BasicResolveAssistant assistant) {
        BasicMetaReference<S, ?> ref2;
        if (source == null) {
            BasicMetaUtils.$$$reportNull$$$0(69);
        }
        if (meta == null) {
            BasicMetaUtils.$$$reportNull$$$0(70);
        }
        if (assistant == null) {
            BasicMetaUtils.$$$reportNull$$$0(71);
        }
        return (ref2 = meta.getBaseRef()) == null ? source : BasicMetaUtils.resolve(source, ref2.getReferenceDesc(), (BasicReference)ref2.get(source), assistant);
    }

    public static <S extends BasicElement, T extends BasicElement> @NotNull List<@Nullable T> resolve(@Nullable S e2, @Nullable BasicMetaReferenceList<S, T> metaRef, @NotNull List<BasicReference> ref2) {
        if (ref2 == null) {
            BasicMetaUtils.$$$reportNull$$$0(72);
        }
        List list = e2 == null || metaRef == null ? Collections.emptyList() : ContainerUtil.map(ref2, r -> BasicMetaUtils.resolve(e2, metaRef.getReferenceDesc(), r));
        if (list == null) {
            BasicMetaUtils.$$$reportNull$$$0(73);
        }
        return list;
    }

    @Nullable
    public static <S extends BasicElement, T extends BasicElement> T resolve(@Nullable S e2, @Nullable BasicMetaReference<S, T> metaRef) {
        return e2 == null || metaRef == null ? null : (T)BasicMetaUtils.resolve(e2, metaRef, (BasicReference)metaRef.get(e2));
    }

    @Nullable
    public static <S extends BasicElement> BasicMetaReferenceDesc<S, ?> getReferenceDesc(@Nullable BasicMetaField<S> field) {
        if (field instanceof BasicMetaReference) {
            return ((BasicMetaReference)field).getReferenceDesc();
        }
        if (field instanceof BasicMetaReferenceList) {
            return ((BasicMetaReferenceList)field).getReferenceDesc();
        }
        return null;
    }

    @Nullable
    public static <S extends BasicElement, T extends BasicElement> BasicReference simplify(@Nullable S e2, @Nullable BasicMetaReferenceId<T> refId, @Nullable BasicReference ref2) {
        if (ref2 == null) {
            return null;
        }
        BasicMetaReference<S, T> metaRef = refId.find(e2);
        return metaRef == null ? ref2 : ref2.simplify(e2, metaRef.getReferenceDesc(), BasicResolveAssistant.DEFAULT);
    }

    @NotNull
    public static <S extends BasicElement, T extends BasicElement> List<BasicReference> simplify(@Nullable S e2, @Nullable BasicMetaReferenceListId<T> refId, @NotNull List<BasicReference> ref2) {
        if (ref2 == null) {
            BasicMetaUtils.$$$reportNull$$$0(74);
        }
        if (ref2 == null) {
            if (null == null) {
                BasicMetaUtils.$$$reportNull$$$0(75);
            }
            return null;
        }
        BasicMetaReferenceList metaRef = refId.find(e2);
        if (metaRef == null) {
            List<BasicReference> list = ref2;
            if (list == null) {
                BasicMetaUtils.$$$reportNull$$$0(76);
            }
            return list;
        }
        List res2 = ContainerUtil.map(ref2, r -> r == null ? null : r.simplify(e2, metaRef.getReferenceDesc(), BasicResolveAssistant.DEFAULT));
        List<BasicReference> list = BasicMetaUtils.trimNulls(res2);
        if (list == null) {
            BasicMetaUtils.$$$reportNull$$$0(77);
        }
        return list;
    }

    public static List<BasicReference> trimNulls(List<BasicReference> res2) {
        while (res2.size() > 0 && res2.get(res2.size() - 1) == null) {
            res2.remove(res2.size() - 1);
        }
        return res2;
    }

    @Contract(value="_,_,null,_->null;_,_,!null,_->!null")
    public static BasicReference createPortableReference(@NotNull BasicElement e2, @NotNull BasicMetaReferenceId<?> refId, @Nullable BasicReference ref2, @NotNull BasicResolveAssistant assistant) {
        if (e2 == null) {
            BasicMetaUtils.$$$reportNull$$$0(78);
        }
        if (refId == null) {
            BasicMetaUtils.$$$reportNull$$$0(79);
        }
        if (assistant == null) {
            BasicMetaUtils.$$$reportNull$$$0(80);
        }
        return BasicMetaUtils.createPortableReference(e2, BasicMetaUtils.getMetaObject(e2).getReference(refId).getReferenceDesc(), ref2, assistant);
    }

    @Contract(value="_,_,null->null;_,_,!null->!null")
    public static BasicReference createPortableReference(@NotNull BasicElement e2, @NotNull BasicMetaReferenceId<?> refId, @Nullable BasicReference ref2) {
        if (e2 == null) {
            BasicMetaUtils.$$$reportNull$$$0(81);
        }
        if (refId == null) {
            BasicMetaUtils.$$$reportNull$$$0(82);
        }
        return BasicMetaUtils.createPortableReference(e2, refId, ref2, BasicResolveAssistant.DEFAULT);
    }

    @Contract(value="_,_,null->null;_,_,!null->!null")
    public static <S extends BasicElement> BasicReference createPortableReference(@NotNull S e2, @NotNull BasicMetaReferenceDesc<S, ?> refDesc, @Nullable BasicReference ref2) {
        if (e2 == null) {
            BasicMetaUtils.$$$reportNull$$$0(83);
        }
        if (refDesc == null) {
            BasicMetaUtils.$$$reportNull$$$0(84);
        }
        return BasicMetaUtils.createPortableReference(e2, refDesc, ref2, BasicResolveAssistant.DEFAULT);
    }

    @Contract(value="_,_,null,_->null;_,_,!null,_->!null")
    public static <S extends BasicElement> BasicReference createPortableReference(@NotNull S e2, @NotNull BasicMetaReferenceDesc<S, ?> refDesc, @Nullable BasicReference ref2, @NotNull BasicResolveAssistant assistant) {
        if (e2 == null) {
            BasicMetaUtils.$$$reportNull$$$0(85);
        }
        if (refDesc == null) {
            BasicMetaUtils.$$$reportNull$$$0(86);
        }
        if (assistant == null) {
            BasicMetaUtils.$$$reportNull$$$0(87);
        }
        if (ref2 == null || ref2.isCrossPortable()) {
            return ref2;
        }
        Object resolved = ref2.resolve(e2, refDesc, assistant);
        if (resolved == null) {
            return ref2;
        }
        return BasicMetaUtils.createPortableReference(e2, resolved, refDesc, BasicResolveAssistant.DEFAULT);
    }

    @NotNull
    public static <T extends BasicElement> BasicReference createPortableReference(@NotNull BasicElement source, @NotNull T target2, @NotNull BasicMetaReferenceId<T> refId) {
        if (source == null) {
            BasicMetaUtils.$$$reportNull$$$0(88);
        }
        if (target2 == null) {
            BasicMetaUtils.$$$reportNull$$$0(89);
        }
        if (refId == null) {
            BasicMetaUtils.$$$reportNull$$$0(90);
        }
        return BasicMetaUtils.createPortableReference(source, target2, refId, BasicResolveAssistant.DEFAULT);
    }

    @NotNull
    public static <T extends BasicElement> BasicReference createPortableReference(@NotNull BasicElement source, @NotNull T target2, @NotNull BasicMetaReferenceId<T> refId, @NotNull BasicResolveAssistant assistant) {
        if (source == null) {
            BasicMetaUtils.$$$reportNull$$$0(91);
        }
        if (target2 == null) {
            BasicMetaUtils.$$$reportNull$$$0(92);
        }
        if (refId == null) {
            BasicMetaUtils.$$$reportNull$$$0(93);
        }
        if (assistant == null) {
            BasicMetaUtils.$$$reportNull$$$0(94);
        }
        return BasicMetaUtils.createPortableReference(source, target2, BasicMetaUtils.getMetaObject(source).getReference(refId).getReferenceDesc(), assistant);
    }

    @NotNull
    public static <S extends BasicElement> BasicReference createPortableReference(@NotNull S source, @NotNull BasicElement target2, @NotNull BasicMetaReferenceDesc<S, ?> refDesc, @NotNull BasicResolveAssistant assistant) {
        BasicMetaObject scope;
        if (source == null) {
            BasicMetaUtils.$$$reportNull$$$0(95);
        }
        if (target2 == null) {
            BasicMetaUtils.$$$reportNull$$$0(96);
        }
        if (refDesc == null) {
            BasicMetaUtils.$$$reportNull$$$0(97);
        }
        if (assistant == null) {
            BasicMetaUtils.$$$reportNull$$$0(98);
        }
        String identity = BasicPaths.getIdentity(target2);
        Set kinds = ContainerUtil.map2Set((Object[])refDesc.targets, m -> m.kind);
        ObjectKind forcedKind = kinds.size() < 2 ? ObjectKind.NONE : target2.getKind();
        BasicNameReference nameReference = BasicNameReference.create(target2.getName(), target2.getName().isEmpty() || !DbSqlUtilCore.isQuoted(target2), false, forcedKind, identity);
        BasicMetaReference<S, ?> baseRef = refDesc.getBaseRef();
        if (baseRef == null) {
            scope = refDesc.getScope();
        } else {
            BasicMetaObject<?> tgtMeta = target2.getMetaObject();
            scope = (BasicMetaObject)ContainerUtil.find((Object[])baseRef.getReferenceDesc().targets, t -> assistant.isAncestor((BasicMetaObject<?>)t, tgtMeta, false));
        }
        BasicReference basicReference = BasicMetaUtils.qualifyReference(nameReference, target2.getParent(), scope).simplify(source, refDesc, BasicResolveAssistant.DEFAULT);
        if (basicReference == null) {
            BasicMetaUtils.$$$reportNull$$$0(99);
        }
        return basicReference;
    }

    @NotNull
    private static <S extends BasicElement> BasicReference qualifyReference(@NotNull BasicReference ref2, @Nullable BasicElement parent2, @NotNull BasicMetaObject<?> scope) {
        if (ref2 == null) {
            BasicMetaUtils.$$$reportNull$$$0(100);
        }
        if (scope == null) {
            BasicMetaUtils.$$$reportNull$$$0(101);
        }
        if (parent2 == null || parent2.getMetaObject() == scope) {
            BasicReference basicReference = ref2;
            if (basicReference == null) {
                BasicMetaUtils.$$$reportNull$$$0(102);
            }
            return basicReference;
        }
        BasicReference pRef = BasicParentReference.create(DasUtil.getName(parent2), ref2);
        return BasicMetaUtils.qualifyReference(pRef, parent2.getParent(), scope);
    }

    public static <S extends BasicElement> boolean isEquivalent(@NotNull S s1, @NotNull S s2, @NotNull BasicMetaReferenceDesc<S, ?> refDesc, @Nullable BasicReference ref1, @Nullable BasicReference ref2) {
        if (s1 == null) {
            BasicMetaUtils.$$$reportNull$$$0(103);
        }
        if (s2 == null) {
            BasicMetaUtils.$$$reportNull$$$0(104);
        }
        if (refDesc == null) {
            BasicMetaUtils.$$$reportNull$$$0(105);
        }
        if (ref1 == null || ref2 == null) {
            return ref1 == ref2;
        }
        if (BasicMetaUtils.isEquivalent(ref1, ref2)) {
            return true;
        }
        if (ref1.isCrossPortable() && ref2.isCrossPortable()) {
            return false;
        }
        BasicReference pPef1 = BasicMetaUtils.createPortableReference(s1, refDesc, ref1);
        BasicReference pPef2 = BasicMetaUtils.createPortableReference(s2, refDesc, ref2);
        return BasicMetaUtils.isEquivalent(pPef1, pPef2);
    }

    public static boolean isEquivalent(@Nullable BasicReference ref1, @Nullable BasicReference ref2) {
        if (ref1 == null || ref2 == null) {
            return ref1 == ref2;
        }
        return ref1.isEquivalent(ref2) || ref2.isEquivalent(ref1);
    }

    public static boolean isEquivalent(@Nullable BasicElement s1, @NotNull BasicMetaReferenceId<?> m1, @Nullable BasicReference ref1, @Nullable BasicElement s2, @NotNull BasicMetaReferenceId<?> m2, @Nullable BasicReference ref2) {
        if (m1 == null) {
            BasicMetaUtils.$$$reportNull$$$0(106);
        }
        if (m2 == null) {
            BasicMetaUtils.$$$reportNull$$$0(107);
        }
        return BasicMetaUtils.isEquivalent(s1, BasicMetaUtils.getMetaObject(s1).getReference(m1).getReferenceDesc(), ref1, s2, BasicMetaUtils.getMetaObject(s2).getReference(m2).getReferenceDesc(), ref2);
    }

    public static <S1 extends BasicElement, S2 extends BasicElement> boolean isEquivalent(@Nullable S1 s1, @NotNull BasicMetaReferenceDesc<S1, ?> refDesc1, @Nullable BasicReference ref1, @Nullable S2 s2, @NotNull BasicMetaReferenceDesc<S2, ?> refDesc2, @Nullable BasicReference ref2) {
        if (refDesc1 == null) {
            BasicMetaUtils.$$$reportNull$$$0(108);
        }
        if (refDesc2 == null) {
            BasicMetaUtils.$$$reportNull$$$0(109);
        }
        if (ref1 == null || ref2 == null) {
            return ref1 == ref2;
        }
        if (BasicMetaUtils.isEquivalent(ref1, ref2)) {
            return true;
        }
        if (ref1.isCrossPortable() && ref2.isCrossPortable() || s1 == null || s2 == null) {
            return false;
        }
        BasicReference pPef1 = BasicMetaUtils.createPortableReference(s1, refDesc1, ref1).simplify(s1, refDesc1, BasicResolveAssistant.DEFAULT);
        BasicReference pPef2 = BasicMetaUtils.createPortableReference(s2, refDesc2, ref2).simplify(s1, refDesc1, BasicResolveAssistant.DEFAULT);
        return BasicMetaUtils.isEquivalent(pPef1, pPef2);
    }

    public static JBTreeTraverser<BasicMetaObject<?>> metaTraverser() {
        return JBTreeTraverser.of(m -> m.children);
    }

    public static BasicMetaObject<?> commonAncestor(BasicMetaObject<?> n12, BasicMetaObject<?> n22) {
        int d2;
        if (n12 == null || n22 == null) {
            return null;
        }
        int d1 = BasicMetaUtils.getDepth(n12);
        if (d1 < (d2 = BasicMetaUtils.getDepth(n22))) {
            n22 = n22.getParent(d2 - d1);
        } else if (d2 < d1) {
            n12 = n12.getParent(d1 - d2);
        }
        while (n12 != null && n22 != null) {
            if (n12 == n22) {
                return n12;
            }
            n12 = n12.getParent();
            n22 = n22.getParent();
        }
        return null;
    }

    public static int getDepth(@Nullable BasicMetaObject<?> n12) {
        int depth = -1;
        while (n12 != null) {
            ++depth;
            n12 = n12.getParent();
        }
        return depth;
    }

    public static <E extends BasicElement, T> Object getPropertySimpleValue(@NotNull E element2, @NotNull BasicMetaProperty<E, T> prop) {
        BasicMetaType type;
        if (element2 == null) {
            BasicMetaUtils.$$$reportNull$$$0(110);
        }
        if (prop == null) {
            BasicMetaUtils.$$$reportNull$$$0(111);
        }
        if (BasicMetaUtils.isSimpleType(type = ((BasicMetaPropertyId)prop.getId()).type)) {
            return prop.get(element2);
        }
        return BasicMetaUtils.getPropertyStringValue(element2, prop);
    }

    public static <T> boolean isSimpleType(@NotNull BasicMetaType<T> type) {
        if (type == null) {
            BasicMetaUtils.$$$reportNull$$$0(112);
        }
        return type.valueClass.isPrimitive() || type.isKindOf(Number.class);
    }

    public static <T> String getPropertyStringValue(@NotNull BasicMetaProperty<?, T> prop, T val) {
        if (prop == null) {
            BasicMetaUtils.$$$reportNull$$$0(113);
        }
        if (prop instanceof BasicMetaReference) {
            return BasicMetaUtils.renderRefInfo((BasicReference)val);
        }
        if (prop instanceof BasicMetaReferenceList) {
            return "[" + StringUtil.join((Collection)((List)val), BasicMetaUtils::renderRefInfo, (String)", ") + "]";
        }
        return val == null ? null : (String)prop.id.type.renderer.fun(val);
    }

    public static <E extends BasicElement, T> String getPropertyStringValue(@NotNull E element2, @NotNull BasicMetaProperty<E, T> prop) {
        if (element2 == null) {
            BasicMetaUtils.$$$reportNull$$$0(114);
        }
        if (prop == null) {
            BasicMetaUtils.$$$reportNull$$$0(115);
        }
        if (prop instanceof BasicMetaReference) {
            return BasicMetaUtils.renderRefInfo(BasicReferenceInfo.create(element2, (BasicMetaReference)prop));
        }
        if (prop instanceof BasicMetaReferenceList) {
            return "[" + StringUtil.join(BasicReferenceInfo.create(element2, (BasicMetaReferenceList)prop), BasicMetaUtils::renderRefInfo, (String)", ") + "]";
        }
        T val = prop.get(element2);
        return val == null ? null : (String)prop.id.type.renderer.fun(val);
    }

    @Nullable
    private static String renderRefInfo(BasicReferenceInfo<?> info2) {
        if (info2 == null) {
            return null;
        }
        String name2 = info2.getName();
        return name2 == null ? "" : name2;
    }

    @Nullable
    public static String renderRefInfo(BasicReference ref2) {
        if (ref2 == null) {
            return null;
        }
        String name2 = ref2.getName();
        return name2 == null ? "" : name2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 46, 48, 65, 73, 75, 76, 77, 99, 102 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 25: 
            case 28: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 10: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 26: 
            case 30: 
            case 34: 
            case 45: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r1";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r2";
                break;
            }
            case 24: 
            case 31: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p2";
                break;
            }
            case 27: 
            case 111: 
            case 113: 
            case 115: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prop";
                break;
            }
            case 29: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p1";
                break;
            }
            case 36: 
            case 37: 
            case 49: 
            case 50: 
            case 52: 
            case 54: 
            case 55: 
            case 57: 
            case 58: 
            case 78: 
            case 81: 
            case 83: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 38: 
            case 40: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e1";
                break;
            }
            case 39: 
            case 41: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e2";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 46: 
            case 48: 
            case 65: 
            case 73: 
            case 75: 
            case 76: 
            case 77: 
            case 99: 
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/meta/BasicMetaUtils";
                break;
            }
            case 51: 
            case 60: 
            case 62: 
            case 63: 
            case 79: 
            case 82: 
            case 90: 
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refId";
                break;
            }
            case 53: 
            case 56: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metaRef";
                break;
            }
            case 61: 
            case 68: 
            case 71: 
            case 80: 
            case 87: 
            case 94: 
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assistant";
                break;
            }
            case 64: 
            case 72: 
            case 74: 
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 66: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "desc";
                break;
            }
            case 69: 
            case 88: 
            case 91: 
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "meta";
                break;
            }
            case 84: 
            case 86: 
            case 97: 
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refDesc";
                break;
            }
            case 89: 
            case 92: 
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s1";
                break;
            }
            case 104: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s2";
                break;
            }
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "m1";
                break;
            }
            case 107: {
                objectArray2 = objectArray3;
                objectArray3[0] = "m2";
                break;
            }
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refDesc1";
                break;
            }
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refDesc2";
                break;
            }
            case 110: 
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 112: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/meta/BasicMetaUtils";
                break;
            }
            case 46: 
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetaObject";
                break;
            }
            case 65: 
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "resolve";
                break;
            }
            case 75: 
            case 76: 
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "simplify";
                break;
            }
            case 99: {
                objectArray = objectArray2;
                objectArray2[1] = "createPortableReference";
                break;
            }
            case 102: {
                objectArray = objectArray2;
                objectArray2[1] = "qualifyReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findChild";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "copyProperties";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "copyPropertiesImpl";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "copyStoredReference";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "copySources";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "copyMatchedProperties";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "copyMatchedPropertiesImpl";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "copyMatchedPropertiesImpl2";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "copySourceText";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "copyMatchedProperty";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "copyProperty";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "copyPropertyInner";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "hashCodeImpl";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "hashCode";
                break;
            }
            case 38: 
            case 39: 
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "equals";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "equalsImpl";
                break;
            }
            case 45: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getMetaObject";
                break;
            }
            case 46: 
            case 48: 
            case 65: 
            case 73: 
            case 75: 
            case 76: 
            case 77: 
            case 99: 
            case 102: {
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "makePortable";
                break;
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "makeReferencePortable";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "makeResolved";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "makeReferenceResolved";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "makeInlinesMutable";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "makeInlineReferenceMutable";
                break;
            }
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 66: 
            case 67: 
            case 68: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 69: 
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "getResolveBase";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "simplify";
                break;
            }
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "createPortableReference";
                break;
            }
            case 100: 
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "qualifyReference";
                break;
            }
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalent";
                break;
            }
            case 110: 
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "getPropertySimpleValue";
                break;
            }
            case 112: {
                objectArray = objectArray;
                objectArray[2] = "isSimpleType";
                break;
            }
            case 113: 
            case 114: 
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyStringValue";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 46, 48, 65, 73, 75, 76, 77, 99, 102 -> new IllegalStateException(string);
        };
    }
}

