/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.meta;

import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.properties.BasicReference;
import com.intellij.database.model.properties.Grants;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.HashingStrategy;
import com.intellij.util.containers.WeakInterner;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BasicMetaType<T> {
    public final Class<T> valueClass;
    public final Function<@NotNull String, @Nullable T> importer;
    public final Function<@NotNull T, @Nullable String> exporter;
    public final Function<@Nullable T, @NotNull String> renderer;
    public final HashingStrategy<T> hStrategy;
    private static final WeakInterner<BasicMetaType<?>> ourTypes = new WeakInterner(HashingStrategy.canonical());

    protected BasicMetaType(@NotNull Class<T> valueClass, @NotNull @NotNull Function<@NotNull String, @Nullable T> importer, @NotNull @NotNull Function<@NotNull T, @Nullable String> exporter, @NotNull @NotNull Function<@Nullable T, @NotNull String> renderer2, @NotNull HashingStrategy<T> hStrategy) {
        if (valueClass == null) {
            BasicMetaType.$$$reportNull$$$0(0);
        }
        if (importer == null) {
            BasicMetaType.$$$reportNull$$$0(1);
        }
        if (exporter == null) {
            BasicMetaType.$$$reportNull$$$0(2);
        }
        if (renderer2 == null) {
            BasicMetaType.$$$reportNull$$$0(3);
        }
        if (hStrategy == null) {
            BasicMetaType.$$$reportNull$$$0(4);
        }
        this.valueClass = valueClass;
        this.importer = importer;
        this.exporter = exporter;
        this.renderer = renderer2;
        this.hStrategy = hStrategy;
    }

    public boolean isKindOf(@NotNull Class<?> c2) {
        if (c2 == null) {
            BasicMetaType.$$$reportNull$$$0(5);
        }
        return c2.isAssignableFrom(this.getBoxedValueClass());
    }

    public Class<T> getBoxedValueClass() {
        return ReflectionUtil.boxType(this.valueClass);
    }

    public String toString() {
        return this.valueClass.getSimpleName();
    }

    private static <T extends BasicMetaType<?>> T intern(T t) {
        return (T)((BasicMetaType)ourTypes.intern(t));
    }

    public static <T extends Grants.Grant> BasicMetaType<Grants<T>> createGrantsType(@NotNull @NotNull Function<@NotNull String, @NotNull Grants<T>> importer, @NotNull @NotNull Function<@NotNull Grants<T>, @Nullable String> exporter) {
        if (importer == null) {
            BasicMetaType.$$$reportNull$$$0(6);
        }
        if (exporter == null) {
            BasicMetaType.$$$reportNull$$$0(7);
        }
        Class<Grants> gClass = Grants.class;
        return BasicMetaType.createType(gClass, importer, exporter);
    }

    @NotNull
    public static <T> BasicMetaType<T> createType(@NotNull Class<T> valueClass, @NotNull @NotNull Function<@NotNull String, @Nullable T> importer, @NotNull @NotNull Function<@NotNull T, @Nullable String> exporter) {
        if (valueClass == null) {
            BasicMetaType.$$$reportNull$$$0(8);
        }
        if (importer == null) {
            BasicMetaType.$$$reportNull$$$0(9);
        }
        if (exporter == null) {
            BasicMetaType.$$$reportNull$$$0(10);
        }
        BasicMetaType<T> basicMetaType = BasicMetaType.createType(valueClass, importer, exporter, String::valueOf, HashingStrategy.canonical());
        if (basicMetaType == null) {
            BasicMetaType.$$$reportNull$$$0(11);
        }
        return basicMetaType;
    }

    public static <T> BasicMetaType<T> createType(@NotNull Class<T> valueClass, @NotNull @NotNull Function<@NotNull String, @Nullable T> importer, @NotNull @NotNull Function<@NotNull T, @Nullable String> exporter, @NotNull @NotNull Function<@Nullable T, @NotNull String> renderer2, @NotNull HashingStrategy<T> hStrategy) {
        if (valueClass == null) {
            BasicMetaType.$$$reportNull$$$0(12);
        }
        if (importer == null) {
            BasicMetaType.$$$reportNull$$$0(13);
        }
        if (exporter == null) {
            BasicMetaType.$$$reportNull$$$0(14);
        }
        if (renderer2 == null) {
            BasicMetaType.$$$reportNull$$$0(15);
        }
        if (hStrategy == null) {
            BasicMetaType.$$$reportNull$$$0(16);
        }
        return new BasicMetaType<T>(valueClass, importer, exporter, renderer2, hStrategy);
    }

    public static <T extends Enum<?>> EnumMetaType<T> createEnumType(@NotNull Class<T> valueClass, @NotNull @NotNull Function<@NotNull String, @Nullable T> importer, @NotNull @NotNull Function<@NotNull T, @Nullable String> exporter) {
        if (valueClass == null) {
            BasicMetaType.$$$reportNull$$$0(17);
        }
        if (importer == null) {
            BasicMetaType.$$$reportNull$$$0(18);
        }
        if (exporter == null) {
            BasicMetaType.$$$reportNull$$$0(19);
        }
        return new EnumMetaType<T>(valueClass, importer, exporter, String::valueOf, HashingStrategy.canonical());
    }

    public static <T extends BasicElement> RefMetaType<T> createRefType(@NotNull Class<T> targetClass) {
        if (targetClass == null) {
            BasicMetaType.$$$reportNull$$$0(20);
        }
        return BasicMetaType.intern(new RefMetaType<T>(targetClass));
    }

    public static <T extends BasicElement> RefListMetaType<T> createRefListType(@NotNull Class<T> targetClass) {
        if (targetClass == null) {
            BasicMetaType.$$$reportNull$$$0(21);
        }
        return BasicMetaType.intern(new RefListMetaType<T>(BasicMetaType.createRefType(targetClass)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueClass";
                break;
            }
            case 1: 
            case 6: 
            case 9: 
            case 13: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importer";
                break;
            }
            case 2: 
            case 7: 
            case 10: 
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exporter";
                break;
            }
            case 3: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 4: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hStrategy";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/meta/BasicMetaType";
                break;
            }
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/meta/BasicMetaType";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isKindOf";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createGrantsType";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createType";
                break;
            }
            case 11: {
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createEnumType";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createRefType";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createRefListType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11 -> new IllegalStateException(string);
        };
    }

    public static class EnumMetaType<T extends Enum<?>>
    extends BasicMetaType<T> {
        public final T[] values;

        public EnumMetaType(@NotNull Class<T> valueClass, @NotNull @NotNull Function<@NotNull String, @Nullable T> importer, @NotNull @NotNull Function<@NotNull T, @Nullable String> exporter, @NotNull @NotNull Function<@Nullable T, @NotNull String> renderer2, @NotNull HashingStrategy<T> hStrategy) {
            if (valueClass == null) {
                EnumMetaType.$$$reportNull$$$0(0);
            }
            if (importer == null) {
                EnumMetaType.$$$reportNull$$$0(1);
            }
            if (exporter == null) {
                EnumMetaType.$$$reportNull$$$0(2);
            }
            if (renderer2 == null) {
                EnumMetaType.$$$reportNull$$$0(3);
            }
            if (hStrategy == null) {
                EnumMetaType.$$$reportNull$$$0(4);
            }
            super(valueClass, importer, exporter, renderer2, hStrategy);
            this.values = (Enum[])valueClass.getEnumConstants();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "valueClass";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "importer";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "exporter";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "renderer";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[0] = "hStrategy";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/model/meta/BasicMetaType$EnumMetaType";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class RefMetaType<T extends BasicElement>
    extends BasicMetaType<BasicReference> {
        public final Class<T> targetClass;

        public RefMetaType(@NotNull Class<T> targetClass) {
            if (targetClass == null) {
                RefMetaType.$$$reportNull$$$0(0);
            }
            super(BasicReference.class, s2 -> null, r -> null, String::valueOf, HashingStrategy.canonical());
            this.targetClass = targetClass;
        }

        @Override
        public String toString() {
            return "reference to " + this.targetClass.getSimpleName();
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (!(o2 instanceof RefMetaType)) {
                return false;
            }
            RefMetaType type = (RefMetaType)o2;
            return Objects.equals(this.targetClass, type.targetClass);
        }

        public int hashCode() {
            return Objects.hash(this.targetClass);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetClass", "com/intellij/database/model/meta/BasicMetaType$RefMetaType", "<init>"));
        }
    }

    public static class RefListMetaType<E extends BasicElement>
    extends CollectionMetaType<BasicReference, List<BasicReference>> {
        public RefListMetaType(@NotNull RefMetaType<E> elementType) {
            if (elementType == null) {
                RefListMetaType.$$$reportNull$$$0(0);
            }
            super(List.class, elementType, s2 -> null, r -> null);
        }

        public RefMetaType<E> getElementType() {
            return (RefMetaType)this.elementType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "com/intellij/database/model/meta/BasicMetaType$RefListMetaType", "<init>"));
        }
    }

    private static class ListHashingStrategy<E, T extends Collection<E>>
    implements HashingStrategy<T> {
        private final HashingStrategy<E> elementStrategy;

        private ListHashingStrategy(@NotNull HashingStrategy<E> elementStrategy) {
            if (elementStrategy == null) {
                ListHashingStrategy.$$$reportNull$$$0(0);
            }
            this.elementStrategy = elementStrategy;
        }

        public int hashCode(T object) {
            int res2 = 0;
            for (Object e2 : object) {
                res2 = res2 * 31 + this.elementStrategy.hashCode(e2);
            }
            return res2;
        }

        public boolean equals(T o1, T o2) {
            if (o1.size() != o2.size()) {
                return false;
            }
            Iterator it1 = o1.iterator();
            Iterator it2 = o2.iterator();
            while (it1.hasNext() && it2.hasNext()) {
                Object e2;
                Object e1 = it1.next();
                if (this.elementStrategy.equals(e1, e2 = it2.next())) continue;
                return false;
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementStrategy", "com/intellij/database/model/meta/BasicMetaType$ListHashingStrategy", "<init>"));
        }
    }

    public static class MapMetaType<K, V>
    extends BasicMetaType<Map<K, V>> {
        public final BasicMetaType<K> keyType;
        public final BasicMetaType<V> valType;

        public MapMetaType(@NotNull BasicMetaType<K> keyType, @NotNull BasicMetaType<V> valueType, @NotNull @NotNull Function<@NotNull String, @Nullable Map<K, V>> importer, @NotNull @NotNull Function<@NotNull Map<K, V>, @Nullable String> exporter) {
            if (keyType == null) {
                MapMetaType.$$$reportNull$$$0(0);
            }
            if (valueType == null) {
                MapMetaType.$$$reportNull$$$0(1);
            }
            if (importer == null) {
                MapMetaType.$$$reportNull$$$0(2);
            }
            if (exporter == null) {
                MapMetaType.$$$reportNull$$$0(3);
            }
            super(Map.class, importer, exporter, m -> m == null ? "null" : "{" + StringUtil.join(m.entrySet(), e2 -> (String)keyType.renderer.fun(e2.getKey()) + ": " + (String)valueType.renderer.fun(e2.getValue()), (String)", ") + "}", HashingStrategy.canonical());
            this.keyType = keyType;
            this.valType = valueType;
        }

        @Override
        public String toString() {
            return this.valueClass.getSimpleName() + "<" + this.keyType + ", " + this.valType + ">";
        }

        public Class<K> getKeyClass() {
            return this.keyType.valueClass;
        }

        public Class<V> getValClass() {
            return this.valType.valueClass;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "keyType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "valueType";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "importer";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "exporter";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/model/meta/BasicMetaType$MapMetaType";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class CollectionMetaType<E, T extends Collection<E>>
    extends BasicMetaType<T> {
        public final BasicMetaType<E> elementType;

        public CollectionMetaType(@NotNull Class valueClass, @NotNull BasicMetaType<E> elementType, @NotNull @NotNull Function<@NotNull String, @Nullable T> importer, @NotNull @NotNull Function<@NotNull T, @Nullable String> exporter) {
            if (valueClass == null) {
                CollectionMetaType.$$$reportNull$$$0(0);
            }
            if (elementType == null) {
                CollectionMetaType.$$$reportNull$$$0(1);
            }
            if (importer == null) {
                CollectionMetaType.$$$reportNull$$$0(2);
            }
            if (exporter == null) {
                CollectionMetaType.$$$reportNull$$$0(3);
            }
            super(valueClass, importer, exporter, c2 -> c2 == null ? "null" : "[" + StringUtil.join((Collection)c2, elementType.renderer, (String)", ") + "]", List.class.isAssignableFrom(valueClass) ? new ListHashingStrategy(elementType.hStrategy) : HashingStrategy.canonical());
            this.elementType = elementType;
        }

        public Class<E> getElementClass() {
            return this.elementType.valueClass;
        }

        @Override
        public String toString() {
            return this.valueClass.getSimpleName() + "<" + this.elementType + ">";
        }

        @NotNull
        public static <E, T extends Collection<E>> CollectionMetaType<E, T> from(@NotNull BasicMetaType<T> type) {
            if (type == null) {
                CollectionMetaType.$$$reportNull$$$0(4);
            }
            CollectionMetaType collectionMetaType = (CollectionMetaType)type;
            if (collectionMetaType == null) {
                CollectionMetaType.$$$reportNull$$$0(5);
            }
            return collectionMetaType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "valueClass";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elementType";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "importer";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "exporter";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/model/meta/BasicMetaType$CollectionMetaType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/model/meta/BasicMetaType$CollectionMetaType";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "from";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "from";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5 -> new IllegalStateException(string);
            };
        }
    }
}

