/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.meta;

import com.intellij.database.model.meta.BasicMetaId;
import com.intellij.database.model.meta.BasicMetaType;
import com.intellij.util.containers.HashingStrategy;
import com.intellij.util.containers.Interner;
import com.intellij.util.containers.WeakInterner;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public class BasicMetaPropertyId<T>
extends BasicMetaId {
    private static final Interner<BasicMetaPropertyId<?>> ourInterner = new WeakInterner(new HashingStrategy<BasicMetaPropertyId<?>>(){

        public int hashCode(BasicMetaPropertyId<?> o2) {
            return Objects.hash(o2.name, o2.type);
        }

        public boolean equals(BasicMetaPropertyId<?> o1, BasicMetaPropertyId<?> o2) {
            if (o1 == o2) {
                return true;
            }
            if (o2 == null) {
                return false;
            }
            return Objects.equals(o1.name, o2.name) && Objects.equals(o1.type, o2.type);
        }
    });
    public final BasicMetaType<T> type;

    protected BasicMetaPropertyId(String name2, BasicMetaType<T> type) {
        super(name2);
        this.type = type;
    }

    @NotNull
    public Class<T> getValueClass() {
        Class<T> clazz = this.type.getBoxedValueClass();
        if (clazz == null) {
            BasicMetaPropertyId.$$$reportNull$$$0(0);
        }
        return clazz;
    }

    @Nullable
    public <U> BasicMetaPropertyId<U> tryCast(@NotNull Class<U> clazz) {
        if (clazz == null) {
            BasicMetaPropertyId.$$$reportNull$$$0(1);
        }
        if (clazz.isAssignableFrom(this.getValueClass())) {
            return this;
        }
        return null;
    }

    @Override
    public String toString() {
        return this.name + ": " + this.type.toString();
    }

    @NotNull
    public static <T> BasicMetaPropertyId<T> create(@NonNls String name2, BasicMetaType<T> type, @PropertyKey(resourceBundle="messages.DatabaseBundle") @PropertyKey(resourceBundle="messages.DatabaseBundle") String localisationKey) {
        BasicMetaPropertyId<T> res2 = BasicMetaPropertyId.intern(new BasicMetaPropertyId<T>(name2, type));
        BasicMetaPropertyId.validateKey(res2, localisationKey);
        BasicMetaPropertyId<T> basicMetaPropertyId = res2;
        if (basicMetaPropertyId == null) {
            BasicMetaPropertyId.$$$reportNull$$$0(2);
        }
        return basicMetaPropertyId;
    }

    protected static <T> void validateKey(BasicMetaPropertyId<T> propertyId, String localisationKey) {
        if (!localisationKey.equals(propertyId.getLocalisationKey())) {
            throw new AssertionError((Object)("Unexpected key " + localisationKey + " for " + propertyId.name));
        }
    }

    @NotNull
    protected static <T extends BasicMetaPropertyId<?>> T intern(T id) {
        BasicMetaPropertyId basicMetaPropertyId = (BasicMetaPropertyId)ourInterner.intern(id);
        if (basicMetaPropertyId == null) {
            BasicMetaPropertyId.$$$reportNull$$$0(3);
        }
        return (T)basicMetaPropertyId;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/meta/BasicMetaPropertyId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueClass";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/meta/BasicMetaPropertyId";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "intern";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "tryCast";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

