/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.basic;

import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.ModelExternalData;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.basic.ContextMetaObjectFactory;
import com.intellij.database.model.basic.VmColumn;
import com.intellij.database.model.basic.VmDatabaseView;
import com.intellij.database.model.basic.VmForeignKey;
import com.intellij.database.model.basic.VmImplModel;
import com.intellij.database.model.basic.VmRootView;
import com.intellij.database.model.basic.VmSchemaView;
import com.intellij.database.model.basic.VmView;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.properties.BasicReference;
import com.intellij.database.model.properties.BasicReferenceInfo;
import com.intellij.database.model.properties.references.BasicNameReference;
import com.intellij.database.model.properties.references.BasicParentReference;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VmModelContextFactory {
    private static final VmExtractor<?, ?>[] ourExtractorExamples = new VmExtractor[]{new VmForeignKeyExtractor(VmImplModel.LightForeignKey.META), new VmColumnExtractor(VmImplModel.LightColumn.META), new VmViewExtractor<VmRootView>(VmImplModel.LightRootView.META), new VmViewExtractor<VmDatabaseView>(VmImplModel.LightDatabaseView.META), new VmViewExtractor<VmSchemaView>(VmImplModel.LightSchemaView.META)};

    public static List<BasicMetaObject<?>> createContextVmMetaObjects(@NotNull BasicMetaObject<?> context) {
        if (context == null) {
            VmModelContextFactory.$$$reportNull$$$0(0);
        }
        ArrayList res2 = new ArrayList();
        for (BasicMetaObject<?> root2 : VmImplModel.ROOTS) {
            if (!context.kindOf(root2.getParentClass())) continue;
            res2.add(ContextMetaObjectFactory.getMetaObjectInContext(context, root2));
        }
        return res2;
    }

    public static <E extends BasicElement> JBIterable<BasicMetaObject<?>> getChildren(BasicMetaObject<E> meta) {
        return JBIterable.of((Object[])meta.children).append(VmModelContextFactory.createContextVmMetaObjects(meta));
    }

    @Nullable
    public static <E extends BasicElement> VmExtractor<E, ?> createVirtualObjectsExtractor(@NotNull BasicMetaObject<E> meta) {
        if (meta == null) {
            VmModelContextFactory.$$$reportNull$$$0(1);
        }
        for (VmExtractor<?, ?> example : ourExtractorExamples) {
            Object res2 = example.create(meta);
            if (res2 == null) continue;
            return res2;
        }
        return null;
    }

    @NotNull
    public static <E extends BasicElement> JBIterable<E> createVirtualObjects(@NotNull LocalDataSource dataSource2, @NotNull BasicElement e2, @NotNull BasicMetaObject<E> meta) {
        VmExtractor<E, ?> extractor;
        if (dataSource2 == null) {
            VmModelContextFactory.$$$reportNull$$$0(2);
        }
        if (e2 == null) {
            VmModelContextFactory.$$$reportNull$$$0(3);
        }
        if (meta == null) {
            VmModelContextFactory.$$$reportNull$$$0(4);
        }
        JBIterable<E> jBIterable = (extractor = VmModelContextFactory.createVirtualObjectsExtractor(meta)) == null ? JBIterable.empty() : extractor.createObjects(dataSource2, e2);
        if (jBIterable == null) {
            VmModelContextFactory.$$$reportNull$$$0(5);
        }
        return jBIterable;
    }

    @Nullable
    private static BasicReference asBasicReference(@Nullable ObjectPath path) {
        if (path == null) {
            return null;
        }
        BasicReference res2 = BasicNameReference.create(path.name, !path.isQuoted());
        ObjectPath tmp = path.parent;
        while (tmp != null) {
            res2 = BasicParentReference.create(tmp.name, res2);
            tmp = tmp.parent;
        }
        return res2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "meta";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/basic/VmModelContextFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/basic/VmModelContextFactory";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createVirtualObjects";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createContextVmMetaObjects";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createVirtualObjectsExtractor";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createVirtualObjects";
                break;
            }
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }

    public static abstract class VmExtractor<E extends BasicElement, D extends ModelExternalData.ObjDesc> {
        public final BasicMetaObject<E> meta;

        public VmExtractor(@NotNull BasicMetaObject<E> meta) {
            if (meta == null) {
                VmExtractor.$$$reportNull$$$0(0);
            }
            this.meta = meta;
        }

        @Nullable
        public <E2 extends BasicElement> VmExtractor<E2, D> create(@NotNull BasicMetaObject<E2> meta) {
            BasicMetaObject<E> m2;
            if (meta == null) {
                VmExtractor.$$$reportNull$$$0(1);
            }
            VmExtractor<E, D> res2 = (m2 = meta.tryCast(this.meta)) == null ? null : this.createImpl(m2);
            return res2;
        }

        @NotNull
        protected abstract VmExtractor<E, D> createImpl(@NotNull BasicMetaObject<E> var1);

        public final JBIterable<D> extractData(@NotNull LocalDataSource dataSource2, @NotNull BasicElement e2) {
            if (dataSource2 == null) {
                VmExtractor.$$$reportNull$$$0(2);
            }
            if (e2 == null) {
                VmExtractor.$$$reportNull$$$0(3);
            }
            ModelExternalData instance = ModelExternalData.getInstance();
            ObjectPath path = ObjectPaths.of(e2);
            JBIterable<ModelExternalData.Data> data = instance.getDataSourceData(dataSource2, !this.meta.kindOf(VmView.class));
            return data.flatten(d2 -> ModelExternalData.extract(d2, path, this.descClass()));
        }

        public abstract boolean fill(@NotNull E var1, @NotNull D var2);

        @Nullable
        public abstract D desc(@NotNull E var1, @Nullable ObjectPath var2);

        public abstract boolean matches(@NotNull E var1, @NotNull D var2);

        public abstract Class<D> descClass();

        @Nullable
        public E create(@NotNull D data) {
            E res2;
            if (data == null) {
                VmExtractor.$$$reportNull$$$0(4);
            }
            return (E)(this.fill(res2 = this.meta.newDataObject(), data) ? res2 : null);
        }

        @NotNull
        public JBIterable<E> createObjects(@NotNull LocalDataSource dataSource2, @NotNull BasicElement e2) {
            if (dataSource2 == null) {
                VmExtractor.$$$reportNull$$$0(5);
            }
            if (e2 == null) {
                VmExtractor.$$$reportNull$$$0(6);
            }
            JBIterable jBIterable = this.extractData(dataSource2, e2).filterMap(this::create);
            if (jBIterable == null) {
                VmExtractor.$$$reportNull$$$0(7);
            }
            return jBIterable;
        }

        public void remove(@NotNull ModelExternalData.Data data, @NotNull E e2, @Nullable ObjectPath p2) {
            if (data == null) {
                VmExtractor.$$$reportNull$$$0(8);
            }
            if (e2 == null) {
                VmExtractor.$$$reportNull$$$0(9);
            }
            if (p2 == null) {
                return;
            }
            data.objSet.get((Object)p2).removeIf(d2 -> {
                ModelExternalData.ObjDesc dd = (ModelExternalData.ObjDesc)ObjectUtils.tryCast((Object)d2, this.descClass());
                return dd != null && this.matches(e2, dd);
            });
        }

        public void add(@NotNull ModelExternalData.Data data, @NotNull E e2, @NotNull ObjectPath p2) {
            D desc;
            if (data == null) {
                VmExtractor.$$$reportNull$$$0(10);
            }
            if (e2 == null) {
                VmExtractor.$$$reportNull$$$0(11);
            }
            if (p2 == null) {
                VmExtractor.$$$reportNull$$$0(12);
            }
            if ((desc = this.desc(e2, p2)) != null) {
                data.objSet.getModifiable((Object)p2).add(desc);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "meta";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSource";
                    break;
                }
                case 3: 
                case 6: 
                case 9: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 4: 
                case 8: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/model/basic/VmModelContextFactory$VmExtractor";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "p";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/model/basic/VmModelContextFactory$VmExtractor";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createObjects";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "extractData";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "createObjects";
                    break;
                }
                case 7: {
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "remove";
                    break;
                }
                case 10: 
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "add";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 7 -> new IllegalStateException(string);
            };
        }
    }

    public static class VmForeignKeyExtractor
    extends VmExtractor<VmForeignKey, ModelExternalData.FkDesc> {
        public VmForeignKeyExtractor(@NotNull BasicMetaObject<VmForeignKey> meta) {
            if (meta == null) {
                VmForeignKeyExtractor.$$$reportNull$$$0(0);
            }
            super(meta);
        }

        @Override
        @NotNull
        protected VmExtractor<VmForeignKey, ModelExternalData.FkDesc> createImpl(@NotNull BasicMetaObject<VmForeignKey> meta) {
            if (meta == null) {
                VmForeignKeyExtractor.$$$reportNull$$$0(1);
            }
            return new VmForeignKeyExtractor(meta);
        }

        @Override
        public Class<ModelExternalData.FkDesc> descClass() {
            return ModelExternalData.FkDesc.class;
        }

        @Override
        public boolean fill(@NotNull VmForeignKey fk, @NotNull ModelExternalData.FkDesc d2) {
            if (fk == null) {
                VmForeignKeyExtractor.$$$reportNull$$$0(2);
            }
            if (d2 == null) {
                VmForeignKeyExtractor.$$$reportNull$$$0(3);
            }
            fk.setName(StringUtil.notNullize((String)d2.name));
            fk.setColNames(d2.columns);
            fk.setRefColNames(d2.refColumns);
            fk.setRefTableRef(VmModelContextFactory.asBasicReference(d2.ref));
            return true;
        }

        @Override
        public boolean matches(@NotNull VmForeignKey fk, @NotNull ModelExternalData.FkDesc d2) {
            String name2;
            if (fk == null) {
                VmForeignKeyExtractor.$$$reportNull$$$0(4);
            }
            if (d2 == null) {
                VmForeignKeyExtractor.$$$reportNull$$$0(5);
            }
            if (!fk.getName().equals(StringUtil.notNullize((String)d2.name))) {
                return false;
            }
            if (!fk.getColNames().equals(d2.columns)) {
                return false;
            }
            if (!fk.getRefColNames().equals(d2.refColumns)) {
                return false;
            }
            BasicReferenceInfo<? extends BasicTable> info2 = fk.getRefTableRefInfo();
            if (info2 == null) {
                return false;
            }
            ObjectPath ref2 = d2.ref;
            if (ref2 == null) {
                return false;
            }
            int i2 = 0;
            while (ref2 != null && (name2 = info2.getParentName(i2)) != null) {
                if (!Objects.equals(ref2.name, name2)) {
                    return false;
                }
                ++i2;
                ref2 = ref2.parent;
            }
            return true;
        }

        @Override
        public ModelExternalData.FkDesc desc(@NotNull VmForeignKey fk, @Nullable ObjectPath p2) {
            if (fk == null) {
                VmForeignKeyExtractor.$$$reportNull$$$0(6);
            }
            BasicReference ref2 = fk.getRefTableRef();
            return new ModelExternalData.FkDesc(fk.getName(), fk.getColNames(), VmForeignKeyExtractor.complete(ref2, p2), fk.getRefColNames());
        }

        private static ObjectPath complete(BasicReference ref2, ObjectPath context) {
            return VmForeignKeyExtractor.complete(ref2, 0, context);
        }

        @Nullable
        private static ObjectPath complete(BasicReference ref2, int idx, @Nullable ObjectPath context) {
            if (context == null || ref2 == null) {
                return null;
            }
            String name2 = ref2.getParentName(idx);
            if (name2 == null) {
                return context;
            }
            return ObjectPath.create(name2, context.kind, true, null, VmForeignKeyExtractor.complete(ref2, idx + 1, context.parent));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "meta";
                    break;
                }
                case 2: 
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fk";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "d";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/model/basic/VmModelContextFactory$VmForeignKeyExtractor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createImpl";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fill";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "matches";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "desc";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class VmColumnExtractor
    extends VmExtractor<VmColumn, ModelExternalData.ColDesc> {
        public VmColumnExtractor(@NotNull BasicMetaObject<VmColumn> meta) {
            if (meta == null) {
                VmColumnExtractor.$$$reportNull$$$0(0);
            }
            super(meta);
        }

        @Override
        @NotNull
        protected VmExtractor<VmColumn, ModelExternalData.ColDesc> createImpl(@NotNull BasicMetaObject<VmColumn> meta) {
            if (meta == null) {
                VmColumnExtractor.$$$reportNull$$$0(1);
            }
            return new VmColumnExtractor(meta);
        }

        @Override
        public Class<ModelExternalData.ColDesc> descClass() {
            return ModelExternalData.ColDesc.class;
        }

        @Override
        public boolean fill(@NotNull VmColumn col, @NotNull ModelExternalData.ColDesc d2) {
            if (col == null) {
                VmColumnExtractor.$$$reportNull$$$0(2);
            }
            if (d2 == null) {
                VmColumnExtractor.$$$reportNull$$$0(3);
            }
            col.setName(StringUtil.notNullize((String)d2.name));
            col.setExpression(d2.expr);
            return true;
        }

        @Override
        @Nullable
        public ModelExternalData.ColDesc desc(@NotNull VmColumn column2, @Nullable ObjectPath p2) {
            if (column2 == null) {
                VmColumnExtractor.$$$reportNull$$$0(4);
            }
            return new ModelExternalData.ColDesc(column2.getNaturalName(), StringUtil.notNullize((String)column2.getExpression()));
        }

        @Override
        public boolean matches(@NotNull VmColumn column2, @NotNull ModelExternalData.ColDesc data) {
            if (column2 == null) {
                VmColumnExtractor.$$$reportNull$$$0(5);
            }
            if (data == null) {
                VmColumnExtractor.$$$reportNull$$$0(6);
            }
            return Objects.equals(column2.getRealName(), data.name) && Objects.equals(StringUtil.notNullize((String)column2.getExpression()), data.expr);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "meta";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "col";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "d";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "column";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/model/basic/VmModelContextFactory$VmColumnExtractor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createImpl";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fill";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "desc";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "matches";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class VmViewExtractor<V extends VmView>
    extends VmExtractor<V, ModelExternalData.ViewDesc> {
        public VmViewExtractor(@NotNull BasicMetaObject<V> meta) {
            if (meta == null) {
                VmViewExtractor.$$$reportNull$$$0(0);
            }
            super(meta);
        }

        @Override
        @NotNull
        protected VmExtractor<V, ModelExternalData.ViewDesc> createImpl(@NotNull BasicMetaObject<V> meta) {
            if (meta == null) {
                VmViewExtractor.$$$reportNull$$$0(1);
            }
            return new VmViewExtractor<V>(meta);
        }

        @Override
        public Class<ModelExternalData.ViewDesc> descClass() {
            return ModelExternalData.ViewDesc.class;
        }

        @Override
        public boolean fill(@NotNull V col, @NotNull ModelExternalData.ViewDesc d2) {
            if (col == null) {
                VmViewExtractor.$$$reportNull$$$0(2);
            }
            if (d2 == null) {
                VmViewExtractor.$$$reportNull$$$0(3);
            }
            col.setName(d2.name);
            col.setQuery(d2.query);
            return true;
        }

        @Override
        @Nullable
        public ModelExternalData.ViewDesc desc(@NotNull V column2, @Nullable ObjectPath p2) {
            if (column2 == null) {
                VmViewExtractor.$$$reportNull$$$0(4);
            }
            return new ModelExternalData.ViewDesc(column2.getName(), StringUtil.notNullize((String)column2.getQuery()));
        }

        @Override
        public boolean matches(@NotNull V column2, @NotNull ModelExternalData.ViewDesc data) {
            if (column2 == null) {
                VmViewExtractor.$$$reportNull$$$0(5);
            }
            if (data == null) {
                VmViewExtractor.$$$reportNull$$$0(6);
            }
            return Objects.equals(column2.getName(), data.name) && Objects.equals(StringUtil.notNullize((String)column2.getQuery()), data.query);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "meta";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "col";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "d";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "column";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/model/basic/VmModelContextFactory$VmViewExtractor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createImpl";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fill";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "desc";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "matches";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

