/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model;

import com.intellij.openapi.Disposable;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0006\u0010\r\u001a\u00020\fJ\b\u0010\u000e\u001a\u00020\fH\u0002J\u0006\u0010\u000f\u001a\u00020\fR\u0014\u0010\u0005\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0010"}, d2={"Lcom/intellij/database/model/ThrottledTask;", "Lcom/intellij/openapi/Disposable;", "task", "Ljava/lang/Runnable;", "(Ljava/lang/Runnable;)V", "future", "Ljava/util/concurrent/Future;", "scheduled", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getTask", "()Ljava/lang/Runnable;", "dispose", "", "flush", "perform", "schedule", "intellij.database.core.impl"})
final class ThrottledTask
implements Disposable {
    @NotNull
    private final Runnable task;
    @NotNull
    private final AtomicBoolean scheduled;
    @Nullable
    private volatile Future<?> future;

    public ThrottledTask(@NotNull Runnable task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        this.task = task;
        this.scheduled = new AtomicBoolean();
    }

    @NotNull
    public final Runnable getTask() {
        return this.task;
    }

    public final void schedule() {
        boolean prev = this.scheduled.getAndSet(true);
        if (!prev) {
            this.future = AppExecutorUtil.getAppScheduledExecutorService().schedule(this::perform, 5L, TimeUnit.SECONDS);
        }
    }

    public final void flush() {
        Future<?> future2 = this.future;
        if (future2 != null) {
            future2.cancel(false);
        }
        this.perform();
    }

    public void dispose() {
        this.flush();
        this.scheduled.set(true);
    }

    private final void perform() {
        this.scheduled.set(false);
        this.task.run();
    }
}

