/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model;

import com.intellij.DynamicBundle;
import com.intellij.database.DatabaseDynamicBundle;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ObjectKind
implements Comparable<ObjectKind> {
    private static final AtomicInteger ourOrderNumCounter = new AtomicInteger(0);
    private static final Map<String, ObjectKind> ourKinds = new ConcurrentHashMap<String, ObjectKind>();
    private static final String ourPresentableNamesCodePrefix = "ObjectKind.";
    public static final ObjectKind NONE = new ObjectKind("NONE");
    public static final ObjectKind ROOT = new ObjectKind("ROOT");
    public static final ObjectKind DATABASE = new ObjectKind("DATABASE");
    public static final ObjectKind SCHEMA = new ObjectKind("SCHEMA");
    public static final ObjectKind SEQUENCE = new ObjectKind("SEQUENCE");
    public static final ObjectKind CLUSTER = new ObjectKind("CLUSTER");
    public static final ObjectKind OBJECT_TYPE = new ObjectKind("OBJECT TYPE");
    public static final ObjectKind COLLECTION_TYPE = new ObjectKind("COLLECTION TYPE");
    public static final ObjectKind TABLE_TYPE = new ObjectKind("TABLE TYPE");
    public static final ObjectKind ALIAS_TYPE = new ObjectKind("ALIAS TYPE");
    public static final ObjectKind TABLE = new ObjectKind("TABLE");
    public static final ObjectKind MAT_LOG = new ObjectKind("MATERIALIZED LOG");
    public static final ObjectKind MAT_VIEW = new ObjectKind("MATERIALIZED VIEW");
    public static final ObjectKind VIEW = new ObjectKind("VIEW");
    public static final ObjectKind PACKAGE = new ObjectKind("PACKAGE");
    public static final ObjectKind BODY = new ObjectKind("BODY");
    public static final ObjectKind ROUTINE = new ObjectKind("ROUTINE");
    public static final ObjectKind METHOD = new ObjectKind("METHOD");
    public static final ObjectKind OPERATOR = new ObjectKind("OPERATOR");
    public static final ObjectKind OBJECT_ATTRIBUTE = new ObjectKind("OBJECT ATTRIBUTE");
    public static final ObjectKind COLUMN = new ObjectKind("COLUMN");
    public static final ObjectKind INDEX = new ObjectKind("INDEX");
    public static final ObjectKind KEY = new ObjectKind("KEY");
    public static final ObjectKind FOREIGN_KEY = new ObjectKind("FOREIGN KEY");
    public static final ObjectKind CHECK = new ObjectKind("CHECK");
    public static final ObjectKind DEFAULT = new ObjectKind("DEFAULT");
    public static final ObjectKind RULE = new ObjectKind("RULE");
    public static final ObjectKind TRIGGER = new ObjectKind("TRIGGER");
    public static final ObjectKind ARGUMENT = new ObjectKind("ARGUMENT");
    public static final ObjectKind VARIABLE = new ObjectKind("VARIABLE");
    public static final ObjectKind SYNONYM = new ObjectKind("SYNONYM");
    public static final ObjectKind DB_LINK = new ObjectKind("DBLINK");
    public static final ObjectKind VIRTUAL_TABLE = new ObjectKind("VIRTUAL TABLE");
    public static final ObjectKind COLLATION = new ObjectKind("COLLATION");
    public static final ObjectKind SCRIPT = new ObjectKind("SCRIPT");
    public static final ObjectKind TABLESPACE = new ObjectKind("TABLESPACE");
    public static final ObjectKind DATA_FILE = new ObjectKind("DATA FILE");
    public static final ObjectKind ROLE = new ObjectKind("ROLE");
    public static final ObjectKind USER = new ObjectKind("USER");
    public static final ObjectKind CONNECTION = new ObjectKind("CONNECTION");
    public static final ObjectKind FOREIGN_DATA_WRAPPER = new ObjectKind("FOREIGN DATA WRAPPER");
    public static final ObjectKind SERVER = new ObjectKind("SERVER");
    public static final ObjectKind USER_MAPPING = new ObjectKind("USER MAPPING");
    public static final ObjectKind FOREIGN_FUNCTION = new ObjectKind("FOREIGN FUNCTION");
    public static final ObjectKind FOREIGN_TABLE = new ObjectKind("FOREIGN TABLE");
    public static final ObjectKind EXTERNAL_SCHEMA = new ObjectKind("EXTERNAL SCHEMA");
    public static final ObjectKind EXTERNAL_DATABASE = new ObjectKind("EXTERNAL DATABASE");
    public static final ObjectKind SCHEDULED_EVENT = new ObjectKind("SCHEDULED EVENT");
    public static final ObjectKind ACCESS_METHOD = new ObjectKind("ACCESS METHOD");
    public static final ObjectKind AGGREGATE = new ObjectKind("AGGREGATE");
    public static final ObjectKind EXCEPTION = new ObjectKind("EXCEPTION");
    public static final ObjectKind EXTENSION = new ObjectKind("EXTENSION");
    public static final ObjectKind PROJECTION = new ObjectKind("PROJECTION");
    public static final ObjectKind MACRO = new ObjectKind("MACRO");
    public static final ObjectKind PARTITION = new ObjectKind("PARTITION");
    public static final ObjectKind WAREHOUSE = new ObjectKind("WAREHOUSE");
    public static final ObjectKind FORMAT = new ObjectKind("FORMAT");
    public static final ObjectKind INDEX_EXTENSION = new ObjectKind("INDEX EXTENSION");
    public static final ObjectKind INDEX_SEARCH_METHOD = new ObjectKind("SEARCH METHOD");
    public static final ObjectKind CONSTANT = new ObjectKind("CONSTANT");
    public static final ObjectKind PERIOD = new ObjectKind("PERIOD");
    public static final ObjectKind LANGUAGE = new ObjectKind("LANGUAGE");
    public static final ObjectKind LOGIN = new ObjectKind("LOGIN");
    public static final ObjectKind OPERATOR_CLASS = new ObjectKind("OPERATOR CLASS");
    public static final ObjectKind OPERATOR_FAMILY = new ObjectKind("OPERATOR FAMILY");
    public static final ObjectKind GROUP = new ObjectKind("GROUP");
    public static final ObjectKind SECURITY_POLICY = new ObjectKind("SECURITY POLICY");
    public static final ObjectKind SECURITY_PREDICATE = new ObjectKind("SECURITY PREDICATE");
    public static final ObjectKind LINKED_SERVER = new ObjectKind("LINKED SERVER");
    public static final ObjectKind CAST = new ObjectKind("CAST");
    public static final ObjectKind STRING = new ObjectKind("STRING");
    public static final ObjectKind LIST = new ObjectKind("LIST");
    public static final ObjectKind SET = new ObjectKind("SET");
    public static final ObjectKind SORTED_SET = new ObjectKind("SORTED SET");
    public static final ObjectKind HASH_TABLE = new ObjectKind("HASH TABLE");
    public static final ObjectKind STREAM = new ObjectKind("STREAM");
    public static final ObjectKind JSON_DOCUMENT = new ObjectKind("JSON_DOCUMENT");
    public static final ObjectKind DATA_STRUCTURE = new ObjectKind("DATA_STRUCTURE");
    public static final ObjectKind COLLECTION = new ObjectKind("COLLECTION");
    public static final ObjectKind COLUMN_MASTER_KEY = new ObjectKind("COLUMN_MASTER_KEY");
    public static final ObjectKind COLUMN_ENCRYPTION_KEY = new ObjectKind("COLUMN_ENCRYPTION_KEY");
    public static final ObjectKind COLUMN_ENCRYPTION_KEY_VALUE = new ObjectKind("COLUMN_ENCRYPTION_KEY_VALUE");
    public static final ObjectKind ASSEMBLY = new ObjectKind("ASSEMBLY");
    public static final ObjectKind DATASHARE = new ObjectKind("DATASHARE");
    public static final ObjectKind FILEGROUP = new ObjectKind("FILEGROUP");
    public static final ObjectKind PARTITION_FUNCTION = new ObjectKind("PARTITION FUNCTION");
    public static final ObjectKind PARTITION_SCHEME = new ObjectKind("PARTITION SCHEME");
    public static final ObjectKind DYNAMIC_TABLE = new ObjectKind("DYNAMIC TABLE");
    public static final ObjectKind UNKNOWN_OBJECT = new ObjectKind("UNKNOWN OBJECT", Integer.MAX_VALUE, null, null);
    private static final int ourLastDatabaseKind = ourOrderNumCounter.get();
    private final String myName;
    private final int myOrderNum;
    private final String myCode;
    @NotNull
    public final String mySingularPresentableKey;
    @NotNull
    public final String myPluralPresentableKey;

    public ObjectKind(@NotNull String name2) {
        if (name2 == null) {
            ObjectKind.$$$reportNull$$$0(0);
        }
        this(name2, -1, null, null);
    }

    protected ObjectKind(@NotNull String name2, int orderNum, @Nullable String singularPresentableKey, @Nullable String pluralPresentableKey) {
        if (name2 == null) {
            ObjectKind.$$$reportNull$$$0(1);
        }
        assert (name2.length() > 0);
        assert (orderNum >= -1);
        this.myName = name2;
        this.myOrderNum = orderNum == -1 ? ourOrderNumCounter.getAndIncrement() : orderNum;
        this.myCode = StringUtil.toLowerCase((String)this.myName).replace(' ', '-');
        if (singularPresentableKey == null || pluralPresentableKey == null) {
            String thePresentableCode = this.myCode.replace('-', '_');
            if (singularPresentableKey == null) {
                singularPresentableKey = ourPresentableNamesCodePrefix + thePresentableCode;
            }
            if (pluralPresentableKey == null) {
                pluralPresentableKey = ourPresentableNamesCodePrefix + StringUtil.pluralize((String)thePresentableCode);
            }
        }
        this.mySingularPresentableKey = singularPresentableKey;
        this.myPluralPresentableKey = pluralPresentableKey;
        ourKinds.putIfAbsent(this.myCode, this);
    }

    public String name() {
        return this.myName;
    }

    public String code() {
        return this.myCode;
    }

    @Nls
    public String getPresentableName() {
        String s2 = this.getBundle().messageOrNull(this.mySingularPresentableKey, new Object[0]);
        if (s2 == null) {
            s2 = this.myName.toLowerCase(Locale.ENGLISH);
        }
        return s2;
    }

    public DynamicBundle getBundle() {
        return DatabaseDynamicBundle.INSTANCE;
    }

    @Nls
    public String getPluralPresentableName() {
        String s2 = this.getBundle().messageOrNull(this.myPluralPresentableKey, new Object[0]);
        if (s2 == null) {
            s2 = StringUtil.pluralize((String)this.myName.toLowerCase(Locale.ENGLISH));
        }
        return s2;
    }

    public int getOrder() {
        return this.myOrderNum;
    }

    public String toString() {
        return this.code();
    }

    @Override
    public int compareTo(@NotNull ObjectKind that) {
        if (that == null) {
            ObjectKind.$$$reportNull$$$0(2);
        }
        if (this == that) {
            return 0;
        }
        if (this.myOrderNum < that.myOrderNum) {
            return -1;
        }
        if (this.myOrderNum > that.myOrderNum) {
            return 1;
        }
        throw new IllegalStateException(String.format("Incomparable object kinds: %s and %s", this.code(), that.code()));
    }

    @NotNull
    public static JBIterable<ObjectKind> getDatabaseKinds() {
        JBIterable jBIterable = JBIterable.from(ourKinds.values()).filter(ObjectKind::isDatabaseKind);
        if (jBIterable == null) {
            ObjectKind.$$$reportNull$$$0(3);
        }
        return jBIterable;
    }

    public static boolean isDatabaseKind(@NotNull ObjectKind k) {
        if (k == null) {
            ObjectKind.$$$reportNull$$$0(4);
        }
        return k.myOrderNum < ourLastDatabaseKind;
    }

    @Nullable
    public static ObjectKind getKind(@Nullable String code) {
        return code == null ? null : ourKinds.get(code);
    }

    public static Collection<ObjectKind> getRegisteredKinds() {
        return ourKinds.values();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "that";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/ObjectKind";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "k";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/ObjectKind";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDatabaseKinds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isDatabaseKind";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

