/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model;

import com.intellij.database.model.ElementChecker;
import com.intellij.database.model.FamilyOptimizer;
import com.intellij.database.model.IndexCache;
import com.intellij.database.model.ValueIndexCache;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.families.Family;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\u0004\b\u0001\u0010\u0003*\u0004\b\u0002\u0010\u00042\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0005Bz\u0012\u0017\u0010\u0006\u001a\u0013\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0007\u00a2\u0006\u0002\b\b\u0012\u0017\u0010\t\u001a\u0013\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00020\u0007\u00a2\u0006\u0002\b\b\u0012\u001d\u0010\n\u001a\u0019\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0002\b\b\u0012\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000e\u0012\u000e\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u0010\u00a2\u0006\u0002\u0010\u0011J\u001d\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00028\u00002\u0006\u0010\u0018\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u0019J\b\u0010\u001a\u001a\u00020\fH\u0002J$\u0010\u001a\u001a\u0010\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00132\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00000\u0010H\u0002J\u0017\u0010\u001c\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0018\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u001dJ\u0015\u0010\u001e\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001fR\u001c\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001f\u0010\t\u001a\u0013\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00020\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R%\u0010\n\u001a\u0019\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001f\u0010\u0006\u001a\u0013\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/database/model/FamiliesIndexedValueOptimizer;", "T", "Lcom/intellij/database/model/basic/BasicElement;", "D", "V", "Lcom/intellij/database/model/FamilyOptimizer;", "valueGetter", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "objectValueGetter", "objectValueSetter", "Lkotlin/Function2;", "", "checker", "Lcom/intellij/database/model/ElementChecker;", "family", "Lcom/intellij/database/model/families/Family;", "(Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function2;Lcom/intellij/database/model/ElementChecker;Lcom/intellij/database/model/families/Family;)V", "indexed", "Lcom/intellij/database/model/ValueIndexCache;", "updateIndex", "", "fill", "e", "data", "(Lcom/intellij/database/model/basic/BasicElement;Ljava/lang/Object;)V", "fillIndex", "f", "findOptimized", "(Ljava/lang/Object;)Lcom/intellij/database/model/basic/BasicElement;", "onCreated", "(Lcom/intellij/database/model/basic/BasicElement;)V", "intellij.database.core.impl"})
@SourceDebugExtension(value={"SMAP\nElementCacheOptimizers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ElementCacheOptimizers.kt\ncom/intellij/database/model/FamiliesIndexedValueOptimizer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,177:1\n1#2:178\n*E\n"})
final class FamiliesIndexedValueOptimizer<T extends BasicElement, D, V>
extends FamilyOptimizer<T, D> {
    @NotNull
    private final Function1<D, V> valueGetter;
    @NotNull
    private final Function1<T, V> objectValueGetter;
    @NotNull
    private final Function2<T, V, Unit> objectValueSetter;
    @Nullable
    private ValueIndexCache<V, T> indexed;
    private boolean updateIndex;

    public FamiliesIndexedValueOptimizer(@NotNull Function1<? super D, ? extends V> valueGetter, @NotNull Function1<? super T, ? extends V> objectValueGetter, @NotNull Function2<? super T, ? super V, Unit> objectValueSetter, @NotNull ElementChecker<T, D> checker, @NotNull Family<? extends T> family) {
        Intrinsics.checkNotNullParameter(valueGetter, (String)"valueGetter");
        Intrinsics.checkNotNullParameter(objectValueGetter, (String)"objectValueGetter");
        Intrinsics.checkNotNullParameter(objectValueSetter, (String)"objectValueSetter");
        Intrinsics.checkNotNullParameter(checker, (String)"checker");
        Intrinsics.checkNotNullParameter(family, (String)"family");
        super(checker, family);
        this.valueGetter = valueGetter;
        this.objectValueGetter = objectValueGetter;
        this.objectValueSetter = objectValueSetter;
        this.updateIndex = true;
    }

    @Override
    public void fill(@NotNull T e2, D data) {
        Intrinsics.checkNotNullParameter(e2, (String)"e");
        super.fill(e2, data);
        this.objectValueSetter.invoke(e2, this.valueGetter.invoke(data));
    }

    @Override
    @Nullable
    public T findOptimized(D data) {
        ValueIndexCache<Object, T> valueIndexCache;
        if (this.indexed == null && this.updateIndex) {
            this.fillIndex();
        }
        if ((valueIndexCache = this.indexed) != null) {
            ValueIndexCache<Object, T> it2 = valueIndexCache;
            boolean bl = false;
            return this.findIn(it2.get(this.valueGetter.invoke(data)), data);
        }
        return this.findUnoptimized(data);
    }

    private final void fillIndex() {
        Family family = this.getFamily();
        Intrinsics.checkNotNull(family, (String)"null cannot be cast to non-null type com.intellij.database.model.families.Family<T of com.intellij.database.model.FamiliesIndexedValueOptimizer>");
        this.indexed = this.fillIndex(family);
        this.updateIndex = false;
    }

    @Override
    public void onCreated(@NotNull T e2) {
        block0: {
            Intrinsics.checkNotNullParameter(e2, (String)"e");
            ValueIndexCache<Object, T> valueIndexCache = this.indexed;
            if (valueIndexCache == null) break block0;
            valueIndexCache.add(e2, this.objectValueGetter.invoke(e2));
        }
    }

    private final ValueIndexCache<V, T> fillIndex(Family<T> f) {
        ValueIndexCache idx;
        IndexCache indexCache = this.getChecker().getCacheHolder().get(this.key(), f);
        ValueIndexCache valueIndexCache = idx = indexCache instanceof ValueIndexCache ? (ValueIndexCache)indexCache : null;
        if (idx != null) {
            idx.validate();
            if (idx.size() != this.getFamily().size()) {
                this.getChecker().getCacheHolder().put(this.key(), f, null);
            } else {
                return idx;
            }
        }
        if (f.size() < this.getOptimizeAt()) {
            return null;
        }
        ValueIndexCache<V, T> newIdx = new ValueIndexCache<V, T>(f, this.objectValueGetter);
        this.getChecker().getCacheHolder().put(this.key(), f, newIdx);
        return newIdx;
    }
}

