/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DataSourceSchemaMapping;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.BaseModel;
import com.intellij.database.model.BlackHoleTextStorage;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DataSourceSnapshotManager;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.ModelModifier;
import com.intellij.database.model.ModelTextStorage;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicDataObject;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicHierarchicalObject;
import com.intellij.database.model.basic.BasicMateNamespace;
import com.intellij.database.model.basic.BasicModMateNamespace;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModRoot;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.serialization.ModelImporter;
import com.intellij.database.psi.ModelNameIndex;
import com.intellij.database.script.SqlModelBuilderUtils;
import com.intellij.database.util.BasicPaths;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.QNameUtil;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.Version;
import com.intellij.ide.PlatformIdeService;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.ui.EDT;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.xml.XppReader;
import io.github.xstream.mxparser.MXParser;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.sync.Mutex;
import kotlinx.coroutines.sync.MutexKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.xmlpull.v1.XmlPullParser;

@Service(value={Service.Level.APP})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0007\u0018\u0000 :2\u00020\u0001:\u00039:;B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u001e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u0016J\u0016\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0016\u0010 \u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0018\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u0016J \u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020\r2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u001a\u001a\u00020\u0016J\u001a\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010(\u001a\u00020)2\u0006\u0010\u001a\u001a\u00020\u0016H\u0002J\u0018\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010%\u001a\u00020\r2\u0006\u0010&\u001a\u00020'J\u0018\u0010,\u001a\u00020\u00162\u0006\u0010(\u001a\u00020)2\u0006\u0010-\u001a\u00020.H\u0002J*\u0010/\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020'01\u0012\u0004\u0012\u00020$\u0018\u0001002\u0006\u0010%\u001a\u00020\r2\u0006\u0010&\u001a\u00020'J(\u00102\u001a\u0004\u0018\u00010\u00012\u0006\u00103\u001a\u00020\u000e2\u0006\u0010&\u001a\u00020'2\u0006\u0010%\u001a\u00020\rH\u0082@\u00a2\u0006\u0002\u00104J,\u00105\u001a\u0010\u0012\u0004\u0012\u000206\u0012\u0004\u0012\u00020\"\u0018\u0001002\u0006\u0010(\u001a\u00020)2\u0006\u0010-\u001a\u00020.2\u0006\u0010\u001a\u001a\u00020\u0016J.\u00107\u001a\u0010\u0012\u0004\u0012\u000206\u0012\u0004\u0012\u00020\"\u0018\u0001002\u0006\u0010(\u001a\u00020)2\u0006\u0010-\u001a\u00020.2\u0006\u0010\u001a\u001a\u00020\u0016H\u0002J\u0018\u00108\u001a\u00020\u00102\u0006\u0010(\u001a\u00020\t2\u0006\u0010-\u001a\u00020.H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lcom/intellij/database/model/DataSourceSnapshotManager;", "", "cs", "Lkotlinx/coroutines/CoroutineScope;", "(Lkotlinx/coroutines/CoroutineScope;)V", "getCs", "()Lkotlinx/coroutines/CoroutineScope;", "myHiddenNamespacesCache", "", "Lcom/intellij/database/model/basic/BasicHierarchicalObject;", "Lcom/intellij/database/model/DataSourceSnapshotManager$BasicSnippet;", "myModels", "", "Lcom/intellij/database/Dbms;", "Lcom/intellij/database/model/DataSourceSnapshotManager$ModelsForDbms;", "apply", "", "project", "Lcom/intellij/openapi/project/Project;", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "canSubstitute", "", "nsp", "Lcom/intellij/database/model/basic/BasicNamespace;", "ignoreWildcard", "load", "clearOrReviveNamespaces", "model", "Lcom/intellij/database/model/basic/BasicModModel;", "scope", "Lcom/intellij/database/util/TreePattern;", "clearOrReviveNamespacesLater", "getBasePath", "Lcom/intellij/database/util/ObjectPath;", "getSnapshotModel", "Lcom/intellij/database/model/basic/BasicModel;", "dbms", "version", "Lcom/intellij/database/util/Version;", "e", "Lcom/intellij/database/model/basic/BasicElement;", "getSnapshotModelIndex", "Lcom/intellij/database/psi/ModelNameIndex;", "isAutoMappedWildCard", "mapping", "Lcom/intellij/database/dataSource/DataSourceSchemaMapping;", "loadModel", "Lcom/intellij/openapi/util/Pair;", "Lcom/intellij/openapi/util/Couple;", "loadModelLocked", "models", "(Lcom/intellij/database/model/DataSourceSnapshotManager$ModelsForDbms;Lcom/intellij/database/util/Version;Lcom/intellij/database/Dbms;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "map", "", "mapAuto", "merge", "BasicSnippet", "Companion", "ModelsForDbms", "intellij.database.core.impl"})
@SourceDebugExtension(value={"SMAP\nDataSourceSnapshotManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataSourceSnapshotManager.kt\ncom/intellij/database/model/DataSourceSnapshotManager\n+ 2 Mutex.kt\nkotlinx/coroutines/sync/MutexKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,448:1\n120#2,10:449\n1855#3,2:459\n*S KotlinDebug\n*F\n+ 1 DataSourceSnapshotManager.kt\ncom/intellij/database/model/DataSourceSnapshotManager\n*L\n199#1:449,10\n81#1:459,2\n*E\n"})
public final class DataSourceSnapshotManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope cs;
    @NotNull
    private final Map<Dbms, ModelsForDbms> myModels;
    @NotNull
    private final Map<BasicHierarchicalObject, BasicSnippet> myHiddenNamespacesCache;
    @JvmField
    public static final boolean IGNORE_AUTO_MINI_CAT = !Registry.is((String)"database.snapshots.auto");
    private static boolean ourEmptyMiniCat;
    @JvmField
    @NotNull
    public static final ModelTextStorage MINICAT_STORAGE;

    public DataSourceSnapshotManager(@NotNull CoroutineScope cs) {
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        this.cs = cs;
        ConcurrentMap concurrentMap = ConcurrentFactoryMap.create(arg_0 -> DataSourceSnapshotManager.myModels$lambda$0(myModels.1.INSTANCE, arg_0), DataSourceSnapshotManager::myModels$lambda$1);
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"create(...)");
        this.myModels = concurrentMap;
        ConcurrentMap concurrentMap2 = CollectionFactory.createConcurrentWeakKeySoftValueMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap2, (String)"createConcurrentWeakKeySoftValueMap(...)");
        this.myHiddenNamespacesCache = concurrentMap2;
    }

    @NotNull
    public final CoroutineScope getCs() {
        return this.cs;
    }

    public final void apply(@Nullable Project project, @NotNull LocalDataSource dataSource2) {
        Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
        DasModel dasModel = dataSource2.getModel();
        BaseModel baseModel = dasModel instanceof BaseModel ? (BaseModel)dasModel : null;
        if (baseModel == null) {
            return;
        }
        BaseModel model2 = baseModel;
        DataSourceSchemaMapping dataSourceSchemaMapping = dataSource2.getSchemaMapping();
        Intrinsics.checkNotNullExpressionValue((Object)dataSourceSchemaMapping, (String)"getSchemaMapping(...)");
        DataSourceSchemaMapping mapping = dataSourceSchemaMapping;
        DbImplUtilCore.performSrcOperation(null, model2, ModalityState.defaultModalityState(), true, () -> DataSourceSnapshotManager.apply$lambda$10(model2, dataSource2, project, this, mapping));
    }

    public final void clearOrReviveNamespacesLater(@NotNull BasicModModel model2, @NotNull TreePattern scope) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        if (ApplicationManager.getApplication().isDispatchThread()) {
            ApplicationManager.getApplication().executeOnPooledThread(() -> DataSourceSnapshotManager.clearOrReviveNamespacesLater$lambda$11(this, model2, scope));
        } else {
            this.clearOrReviveNamespaces(model2, scope);
        }
    }

    public final void clearOrReviveNamespaces(@NotNull BasicModModel model2, @NotNull TreePattern scope) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        ((BaseModel)model2).modify((BasicElement)model2.getRoot(), BasicModRoot.class, true, new ModelModifier(model2, scope, this){
            final /* synthetic */ BasicModModel $model;
            final /* synthetic */ TreePattern $scope;
            final /* synthetic */ DataSourceSnapshotManager this$0;
            {
                this.$model = $model;
                this.$scope = $scope;
                this.this$0 = $receiver;
            }

            public final void perform(BasicModRoot it2) {
                for (BasicMateNamespace nsp : ((JBTreeTraverser)this.$model.traverser().expandAndFilter(arg_0 -> clearOrReviveNamespaces.1.perform$lambda$0(clearOrReviveNamespaces.1.INSTANCE, arg_0))).bfsTraversal().filter(BasicMateNamespace.class)) {
                    if (!(nsp instanceof BasicHierarchicalObject) || nsp.isSubstituted()) continue;
                    boolean introspected = DataSourceSchemaMapping.isIntrospected(this.$scope, nsp);
                    if (introspected) {
                        BasicSnippet snippet = (BasicSnippet)DataSourceSnapshotManager.access$getMyHiddenNamespacesCache$p(this.this$0).remove(nsp);
                        if (snippet == null || nsp.hasChildren()) continue;
                        snippet.recover((BasicHierarchicalObject)((Object)nsp));
                        continue;
                    }
                    if (!nsp.hasChildren()) continue;
                    DataSourceSnapshotManager.access$getMyHiddenNamespacesCache$p(this.this$0).put(nsp, BasicSnippet.Companion.build((BasicHierarchicalObject)((Object)nsp), DataSourceSnapshotManager.access$getMyHiddenNamespacesCache$p(this.this$0)));
                    ((BaseModel)this.$model).preserveSources(() -> clearOrReviveNamespaces.1.perform$lambda$1(nsp));
                }
            }

            private static final boolean perform$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return (Boolean)$tmp0.invoke(p0);
            }

            private static final void perform$lambda$1(BasicMateNamespace $nsp) {
                for (ModFamily modFamily : ((BasicHierarchicalObject)((Object)$nsp)).getFamilies()) {
                    if (modFamily.getMetaObject().kindOf(BasicMateNamespace.class)) continue;
                    modFamily.clear();
                }
            }
        });
    }

    private final void merge(BasicHierarchicalObject e2, DataSourceSchemaMapping mapping) {
        BasicModel miniMod;
        Pair<String, ObjectPath> map2 = this.map(e2, mapping, true);
        BasicModel basicModel = miniMod = map2 == null ? null : this.getSnapshotModel(e2, true);
        if (miniMod == null) {
            if (e2 instanceof BasicModMateNamespace) {
                ((BasicModMateNamespace)((Object)e2)).setSubstituted(false);
            }
            return;
        }
        DasModel dasModel = miniMod;
        Pair<String, ObjectPath> pair = map2;
        Intrinsics.checkNotNull(pair);
        JBIterable<DasObject> jBIterable = QNameUtil.findByPath(dasModel, (ObjectPath)pair.second);
        Intrinsics.checkNotNullExpressionValue(jBIterable, (String)"findByPath(...)");
        JBIterable<DasObject> objs = jBIterable;
        for (BasicHierarchicalObject target2 : objs.filter(BasicHierarchicalObject.class)) {
            DataSourceSnapshotManager.Companion.merge(e2, target2, true);
        }
    }

    @Nullable
    public final Pair<String, ObjectPath> map(@NotNull BasicElement e2, @NotNull DataSourceSchemaMapping mapping, boolean load) {
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        Intrinsics.checkNotNullParameter((Object)mapping, (String)"mapping");
        ObjectPath path = BasicPaths.of(e2);
        if (mapping.isIntrospected(e2)) {
            return null;
        }
        Pair<String, ObjectPath> map2 = mapping.map(path);
        if (map2 != null) {
            return map2;
        }
        if (IGNORE_AUTO_MINI_CAT || !mapping.isUseMiniCat()) {
            return null;
        }
        return this.mapAuto(e2, mapping, load);
    }

    private final Pair<String, ObjectPath> mapAuto(BasicElement e2, DataSourceSchemaMapping mapping, boolean load) {
        BasicDatabase db;
        ObjectPath basePath;
        BasicNamespace nsp;
        if (e2.getKind() != ObjectKind.SCHEMA && e2.getKind() != ObjectKind.DATABASE) {
            return null;
        }
        BasicNamespace basicNamespace = nsp = e2 instanceof BasicNamespace ? (BasicNamespace)e2 : null;
        ObjectPath objectPath = basePath = basicNamespace == null ? null : this.getBasePath(basicNamespace, load);
        if (basePath == null) {
            return null;
        }
        ObjectPath dbPath = basePath.findParent(ObjectKind.DATABASE, false);
        if (dbPath != null && StringUtil.isEmpty((String)dbPath.name) && (db = e2.getDatabase()) != null && !mapping.isIntrospected(db)) {
            return null;
        }
        return Pair.create((Object)"minicat", (Object)basePath);
    }

    private final boolean isAutoMappedWildCard(BasicElement e2, DataSourceSchemaMapping mapping) {
        if (IGNORE_AUTO_MINI_CAT || !mapping.isUseMiniCat()) {
            return false;
        }
        ObjectPath path = BasicPaths.of(e2);
        if (mapping.isIntrospected(e2)) {
            return false;
        }
        Pair<String, ObjectPath> map2 = mapping.map(path);
        if (map2 != null) {
            return false;
        }
        map2 = this.mapAuto(e2, mapping, true);
        if (map2 == null) {
            return false;
        }
        ObjectPath db = ((ObjectPath)map2.second).findParent(ObjectKind.DATABASE, false);
        return db != null && StringUtil.isEmpty((String)db.name);
    }

    private final BasicModel getSnapshotModel(BasicElement e2, boolean load) {
        Dbms dbms = e2.getMetaObject().getModel().getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
        Dbms dbms2 = dbms;
        BasicModel model2 = e2.getModel();
        Object object = model2;
        if (object == null || (object = object.getRoot()) == null || (object = object.getServerVersion()) == null) {
            object = Version.INFINITY;
        }
        Object version = object;
        Intrinsics.checkNotNull((Object)version);
        return this.getSnapshotModel(dbms2, (Version)version, load);
    }

    @Nullable
    public final BasicModel getSnapshotModel(@NotNull Dbms dbms, @NotNull Version version, boolean load) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        if (ourEmptyMiniCat) {
            return null;
        }
        ModelsForDbms modelsForDbms = this.myModels.get(dbms);
        Intrinsics.checkNotNull((Object)modelsForDbms);
        ModelsForDbms models2 = modelsForDbms;
        Object res2 = DataSourceSnapshotManager.Companion.findModel(models2.getModels(), version);
        if (res2 == null) {
            if (load && !EDT.isCurrentThreadEdt()) {
                res2 = CoroutinesKt.runBlockingMaybeCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Object>, Object>(this, models2, version, dbms, null){
                    int label;
                    final /* synthetic */ DataSourceSnapshotManager this$0;
                    final /* synthetic */ ModelsForDbms $models;
                    final /* synthetic */ Version $version;
                    final /* synthetic */ Dbms $dbms;
                    {
                        this.this$0 = $receiver;
                        this.$models = $models;
                        this.$version = $version;
                        this.$dbms = $dbms;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                this.label = 1;
                                Object object3 = DataSourceSnapshotManager.access$loadModelLocked(this.this$0, this.$models, this.$version, this.$dbms, (Continuation)this);
                                if (object3 != object2) return object3;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return object3;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<Object> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }));
            } else if (!models2.getMutex().isLocked()) {
                BuildersKt.launch$default((CoroutineScope)this.cs, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, models2, version, dbms, null){
                    int label;
                    final /* synthetic */ DataSourceSnapshotManager this$0;
                    final /* synthetic */ ModelsForDbms $models;
                    final /* synthetic */ Version $version;
                    final /* synthetic */ Dbms $dbms;
                    {
                        this.this$0 = $receiver;
                        this.$models = $models;
                        this.$version = $version;
                        this.$dbms = $dbms;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                this.label = 1;
                                Object object3 = DataSourceSnapshotManager.access$loadModelLocked(this.this$0, this.$models, this.$version, this.$dbms, (Continuation)this);
                                if (object3 != object2) return Unit.INSTANCE;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
            }
        }
        return res2 == ObjectUtils.NULL ? null : (BasicModel)res2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final Object loadModelLocked(ModelsForDbms var1_1, Version var2_2, Dbms var3_3, Continuation<Object> var4_4) {
        if (!(var4_4 instanceof loadModelLocked.1)) ** GOTO lbl-1000
        var18_5 = var4_4;
        if ((var18_5.label & -2147483648) != 0) {
            var18_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var4_4){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                /* synthetic */ Object result;
                final /* synthetic */ DataSourceSnapshotManager this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return DataSourceSnapshotManager.access$loadModelLocked(this.this$0, null, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var19_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$withLock_u24default$iv = models.getMutex();
                owner$iv = null;
                $i$f$withLock = false;
                $continuation.L$0 = this;
                $continuation.L$1 = models;
                $continuation.L$2 = version;
                $continuation.L$3 = dbms;
                $continuation.L$4 = $this$withLock_u24default$iv;
                $continuation.label = 1;
                v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)$continuation);
                if (v0 == var19_7) {
                    return var19_7;
                }
                ** GOTO lbl37
            }
            case 1: {
                $i$f$withLock = false;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$4;
                dbms = (Dbms)$continuation.L$3;
                version = (Version)$continuation.L$2;
                models = (ModelsForDbms)$continuation.L$1;
                this = (DataSourceSnapshotManager)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl37:
                // 3 sources

                $i$a$-withLock$default-DataSourceSnapshotManager$loadModelLocked$2 = false;
                v1 = com.intellij.database.model.DataSourceSnapshotManager$Companion.access$findModel(DataSourceSnapshotManager.Companion, models.getModels(), version);
                if (v1 == null) ** GOTO lbl47
                it = v1;
                $i$a$-let-DataSourceSnapshotManager$loadModelLocked$2$1 = false;
                var16_21 = it;
                $this$withLock_u24default$iv.unlock(owner$iv);
                return var16_21;
lbl47:
                // 2 sources

                $continuation.L$0 = models;
                $continuation.L$1 = $this$withLock_u24default$iv;
                $continuation.L$2 = null;
                $continuation.L$3 = null;
                $continuation.L$4 = null;
                $continuation.label = 2;
                v2 = CoroutinesKt.coroutineToIndicator((Function0)((Function0)new Function0<Pair<Couple<Version>, BasicModel>>(this, dbms, version){
                    final /* synthetic */ DataSourceSnapshotManager this$0;
                    final /* synthetic */ Dbms $dbms;
                    final /* synthetic */ Version $version;
                    {
                        this.this$0 = $receiver;
                        this.$dbms = $dbms;
                        this.$version = $version;
                        super(0);
                    }

                    @Nullable
                    public final Pair<Couple<Version>, BasicModel> invoke() {
                        return this.this$0.loadModel(this.$dbms, this.$version);
                    }
                }), (Continuation)$continuation);
                ** if (v2 != var19_7) goto lbl56
lbl55:
                // 1 sources

                return var19_7;
lbl56:
                // 1 sources

                ** GOTO lbl67
            }
            case 2: {
                $i$a$-withLock$default-DataSourceSnapshotManager$loadModelLocked$2 = false;
                $i$f$withLock = false;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$1;
                models = (ModelsForDbms)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl67:
                // 2 sources

                if ((loaded = (Pair)v2) == null) {
                    var10_23 = models.getModels();
                    var11_16 = Couple.of((Object)Version.ZERO, (Object)Version.INFINITY);
                    Intrinsics.checkNotNullExpressionValue((Object)var11_16, (String)"of(...)");
                    v3 = ObjectUtils.NULL;
                    Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"NULL");
                    var12_19 = v3;
                    var10_23.put((Couple<Version>)var11_16, var12_19);
                    var15_25 = null;
                    return var15_25;
                }
                var10_24 = models.getModels();
                var11_17 = loaded.first;
                Intrinsics.checkNotNullExpressionValue((Object)var11_17, (String)"first");
                v4 = loaded.second;
                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"second");
                var12_20 = v4;
                var10_24.put((Couple<Version>)var11_17, var12_20);
                var14_26 = loaded.second;
                return var14_26;
            }
            catch (Throwable var13_27) {
                throw var13_27;
            }
            {
                finally {
                    $this$withLock_u24default$iv.unlock(owner$iv);
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    public final ModelNameIndex getSnapshotModelIndex(@NotNull Dbms dbms, @NotNull Version version) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        BasicModel model2 = this.getSnapshotModel(dbms, version, true);
        return model2 instanceof BaseModel ? ((BaseModel)model2).getNameIndex() : null;
    }

    public final boolean canSubstitute(@NotNull BasicNamespace nsp, boolean ignoreWildcard, boolean load) {
        Intrinsics.checkNotNullParameter((Object)nsp, (String)"nsp");
        BasicModel snap = this.getSnapshotModel(nsp, load);
        if (snap == null) {
            return false;
        }
        BasicHierarchicalObject basicHierarchicalObject = (BasicHierarchicalObject)((Object)nsp);
        BasicRoot basicRoot = snap.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)basicRoot, (String)"getRoot(...)");
        JBIterable targets2 = DataSourceSnapshotManager.Companion.getTargets(basicHierarchicalObject, basicRoot);
        if (ignoreWildcard) {
            JBIterable jBIterable = targets2.filter(arg_0 -> DataSourceSnapshotManager.canSubstitute$lambda$14(canSubstitute.1.INSTANCE, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
            targets2 = jBIterable;
        }
        return targets2.isNotEmpty();
    }

    @Nullable
    public final ObjectPath getBasePath(@NotNull BasicNamespace nsp, boolean load) {
        Intrinsics.checkNotNullParameter((Object)nsp, (String)"nsp");
        BasicModel snap = this.getSnapshotModel(nsp, load);
        if (snap == null) {
            return null;
        }
        BasicHierarchicalObject basicHierarchicalObject = (BasicHierarchicalObject)((Object)nsp);
        BasicRoot basicRoot = snap.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)basicRoot, (String)"getRoot(...)");
        BasicElement tgt = (BasicElement)DataSourceSnapshotManager.Companion.getTargets(basicHierarchicalObject, basicRoot).first();
        return tgt == null ? null : BasicPaths.of(tgt).reduce(null, DataSourceSnapshotManager::getBasePath$lambda$15);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Pair<Couple<Version>, BasicModel> loadModel(@NotNull Dbms dbms, @NotNull Version version) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        try {
            Pair<Couple<Version>, BasicModel> pair;
            InputStream inputStream = Companion.getMiniCatStream(dbms);
            if (inputStream != null) {
                Closeable closeable = inputStream;
                Throwable throwable = null;
                try {
                    InputStream it2 = (InputStream)closeable;
                    boolean bl = false;
                    Pair<Couple<Version>, BasicModel> pair2 = Companion.loadModel(dbms, version, it2);
                    pair = pair2;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            } else {
                pair = null;
            }
            return pair;
        }
        catch (IOException e2) {
            return null;
        }
    }

    private static final ModelsForDbms myModels$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ModelsForDbms)$tmp0.invoke(p0);
    }

    private static final ConcurrentMap myModels$lambda$1() {
        return ContainerUtil.createConcurrentSoftValueMap();
    }

    private static final Iterable apply$lambda$10$lambda$9$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Iterable)$tmp0.invoke(p0);
    }

    private static final boolean apply$lambda$10$lambda$9$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean apply$lambda$10$lambda$9$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final BasicDatabase apply$lambda$10$lambda$9$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (BasicDatabase)$tmp0.invoke(p0);
    }

    private static final Iterable apply$lambda$10$lambda$9$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Iterable)$tmp0.invoke(p0);
    }

    private static final boolean apply$lambda$10$lambda$9$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    /*
     * WARNING - void declaration
     */
    private static final void apply$lambda$10$lambda$9(LocalDataSource $dataSource, Project $project, DataSourceSnapshotManager this$0, DataSourceSchemaMapping $mapping, BasicModRoot r) {
        void $this$forEach$iv;
        Intrinsics.checkNotNullParameter((Object)$dataSource, (String)"$dataSource");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$mapping, (String)"$mapping");
        int autoMappedWildcards2 = ((JBTreeTraverser)((JBTreeTraverser)JBTreeTraverser.from(arg_0 -> DataSourceSnapshotManager.apply$lambda$10$lambda$9$lambda$2(apply.1.1.autoMappedWildcards.1.INSTANCE, arg_0)).withRoot((Object)r)).expandAndFilter(arg_0 -> DataSourceSnapshotManager.apply$lambda$10$lambda$9$lambda$3(apply.1.1.autoMappedWildcards.2.INSTANCE, arg_0))).traverse().filter(arg_0 -> DataSourceSnapshotManager.apply$lambda$10$lambda$9$lambda$4((Function1)new Function1<BasicElement, Boolean>(this$0, $mapping){
            final /* synthetic */ DataSourceSnapshotManager this$0;
            final /* synthetic */ DataSourceSchemaMapping $mapping;
            {
                this.this$0 = $receiver;
                this.$mapping = $mapping;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull BasicElement e2) {
                Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
                return DataSourceSnapshotManager.access$isAutoMappedWildCard(this.this$0, e2, this.$mapping);
            }
        }, arg_0)).filterMap(arg_0 -> DataSourceSnapshotManager.apply$lambda$10$lambda$9$lambda$5(apply.1.1.autoMappedWildcards.4.INSTANCE, arg_0)).unique().size();
        if (autoMappedWildcards2 > 10) {
            $dataSource.getSchemaMapping().setUseMiniCat(false);
            PlatformIdeService.getInstance().notification("Database view", PlatformIdeService.NotificationType.INFORMATION, DatabaseBundle.message("notification.title.too.many.pre.introspected.objects.are.used", new Object[0]), $dataSource.getName(), DatabaseBundle.message("notification.content.to.improve.performance.automatic.usage.pre.introspected.objects.disabled.you.can.select.necessary.schemas.manually", new Object[0]), $project, "DataSourceSnapshotManager.too.many.wildcards");
        }
        Object object = ((JBTreeTraverser)((JBTreeTraverser)JBTreeTraverser.from(arg_0 -> DataSourceSnapshotManager.apply$lambda$10$lambda$9$lambda$6(apply.1.1.1.INSTANCE, arg_0)).withRoot((Object)r)).expandAndFilter(arg_0 -> DataSourceSnapshotManager.apply$lambda$10$lambda$9$lambda$7(apply.1.1.2.INSTANCE, arg_0))).filter(BasicHierarchicalObject.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"filter(...)");
        object = (Iterable)object;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BasicHierarchicalObject it2 = (BasicHierarchicalObject)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it2);
            this$0.merge(it2, $mapping);
        }
    }

    private static final void apply$lambda$10(BaseModel $model, LocalDataSource $dataSource, Project $project, DataSourceSnapshotManager this$0, DataSourceSchemaMapping $mapping) {
        Intrinsics.checkNotNullParameter((Object)$model, (String)"$model");
        Intrinsics.checkNotNullParameter((Object)$dataSource, (String)"$dataSource");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$mapping, (String)"$mapping");
        $model.modify((BasicElement)$model.getRoot(), BasicModRoot.class, true, arg_0 -> DataSourceSnapshotManager.apply$lambda$10$lambda$9($dataSource, $project, this$0, $mapping, arg_0));
    }

    private static final void clearOrReviveNamespacesLater$lambda$11(DataSourceSnapshotManager this$0, BasicModModel $model, TreePattern $scope) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$model, (String)"$model");
        Intrinsics.checkNotNullParameter((Object)$scope, (String)"$scope");
        this$0.clearOrReviveNamespaces($model, $scope);
    }

    private static final boolean canSubstitute$lambda$14(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final ObjectPath getBasePath$lambda$15(ObjectPath parent2, ObjectPath cur) {
        Intrinsics.checkNotNullParameter((Object)cur, (String)"cur");
        return cur.getIdentity() == null && parent2 == cur.parent ? cur : ObjectPath.create(cur.name, cur.kind, cur.isQuoted(), null, parent2);
    }

    @JvmStatic
    @TestOnly
    public static final void setEmptyMiniCat(@NotNull Disposable p2) {
        Companion.setEmptyMiniCat(p2);
    }

    @JvmStatic
    @NotNull
    public static final DataSourceSnapshotManager getInstance() {
        return Companion.getInstance();
    }

    public static final /* synthetic */ Map access$getMyHiddenNamespacesCache$p(DataSourceSnapshotManager $this) {
        return $this.myHiddenNamespacesCache;
    }

    public static final /* synthetic */ Object access$loadModelLocked(DataSourceSnapshotManager $this, ModelsForDbms models2, Version version, Dbms dbms, Continuation $completion) {
        return $this.loadModelLocked(models2, version, dbms, (Continuation<Object>)$completion);
    }

    public static final /* synthetic */ boolean access$isAutoMappedWildCard(DataSourceSnapshotManager $this, BasicElement e2, DataSourceSchemaMapping mapping) {
        return $this.isAutoMappedWildCard(e2, mapping);
    }

    static {
        MINICAT_STORAGE = BlackHoleTextStorage.INSTANCE.unique();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0003\b\u0000\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ \u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 H\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR \u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u0006#"}, d2={"Lcom/intellij/database/model/DataSourceSnapshotManager$BasicSnippet;", "", "()V", "children", "Lit/unimi/dsi/fastutil/ints/IntList;", "getChildren", "()Lit/unimi/dsi/fastutil/ints/IntList;", "setChildren", "(Lit/unimi/dsi/fastutil/ints/IntList;)V", "nodes", "", "Lcom/intellij/database/model/basic/BasicDataObject;", "getNodes", "()Ljava/util/List;", "setNodes", "(Ljava/util/List;)V", "path", "Lcom/intellij/database/util/ObjectPath;", "getPath", "()Lcom/intellij/database/util/ObjectPath;", "setPath", "(Lcom/intellij/database/util/ObjectPath;)V", "root", "getRoot", "()Lcom/intellij/database/model/basic/BasicDataObject;", "setRoot", "(Lcom/intellij/database/model/basic/BasicDataObject;)V", "recover", "", "to", "Lcom/intellij/database/model/basic/BasicHierarchicalObject;", "ni", "", "ci", "Companion", "intellij.database.core.impl"})
    @SourceDebugExtension(value={"SMAP\nDataSourceSnapshotManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataSourceSnapshotManager.kt\ncom/intellij/database/model/DataSourceSnapshotManager$BasicSnippet\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,448:1\n1855#2,2:449\n1855#2,2:451\n*S KotlinDebug\n*F\n+ 1 DataSourceSnapshotManager.kt\ncom/intellij/database/model/DataSourceSnapshotManager$BasicSnippet\n*L\n261#1:449,2\n272#1:451,2\n*E\n"})
    public static final class BasicSnippet {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private ObjectPath path;
        @Nullable
        private BasicDataObject root;
        @NotNull
        private List<BasicDataObject> nodes = new ArrayList();
        @NotNull
        private IntList children = (IntList)new IntArrayList();

        @Nullable
        public final ObjectPath getPath() {
            return this.path;
        }

        public final void setPath(@Nullable ObjectPath objectPath) {
            this.path = objectPath;
        }

        @Nullable
        public final BasicDataObject getRoot() {
            return this.root;
        }

        public final void setRoot(@Nullable BasicDataObject basicDataObject) {
            this.root = basicDataObject;
        }

        @NotNull
        public final List<BasicDataObject> getNodes() {
            return this.nodes;
        }

        public final void setNodes(@NotNull List<BasicDataObject> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.nodes = list;
        }

        @NotNull
        public final IntList getChildren() {
            return this.children;
        }

        public final void setChildren(@NotNull IntList intList) {
            Intrinsics.checkNotNullParameter((Object)intList, (String)"<set-?>");
            this.children = intList;
        }

        public final void recover(@NotNull BasicHierarchicalObject to) {
            Intrinsics.checkNotNullParameter((Object)to, (String)"to");
            int[] nArray = new int[]{0};
            int[] nArray2 = nArray;
            nArray = new int[]{0};
            this.recover(to, nArray2, nArray);
        }

        private final void recover(BasicHierarchicalObject to, int[] ni, int[] ci) {
            List<? extends Family<? extends BasicElement>> list = to.getFamilies();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getFamilies(...)");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ModFamily obj2 = (ModFamily)element$iv;
                boolean bl = false;
                obj2.markChildrenAsSyncPending();
            }
            int b2 = ni[0];
            int c2 = this.children.getInt(ci[0]);
            ni[0] = b2 + c2;
            ci[0] = ci[0] + 1;
            int cfr_ignored_0 = ci[0];
            for (int i2 = 0; i2 < c2; ++i2) {
                BasicDataObject e2 = this.nodes.get(b2 + i2);
                Family<? extends BasicElement> family = to.familyOf(e2.getKind());
                Intrinsics.checkNotNull(family);
                ModFamily<BasicHierarchicalObject> family2 = ((ModFamily)family).asHierarchical();
                Intrinsics.checkNotNull(family2);
                BasicHierarchicalObject h2 = BasicSnippet.Companion.getOrCreate(family2, e2);
                this.recover(h2, ni, ci);
            }
            List<? extends Family<? extends BasicElement>> list2 = to.getFamilies();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getFamilies(...)");
            Iterable $this$forEach$iv2 = list2;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                ModFamily obj3 = (ModFamily)element$iv;
                boolean bl = false;
                obj3.removeSyncPendingChildren();
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00040\bJ \u0010\t\u001a\u00020\u00062\u000e\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J,\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00042\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00040\bH\u0002\u00a8\u0006\u0011"}, d2={"Lcom/intellij/database/model/DataSourceSnapshotManager$BasicSnippet$Companion;", "", "()V", "build", "Lcom/intellij/database/model/DataSourceSnapshotManager$BasicSnippet;", "r", "Lcom/intellij/database/model/basic/BasicHierarchicalObject;", "subSnippets", "", "getOrCreate", "family", "Lcom/intellij/database/model/families/ModFamily;", "e", "Lcom/intellij/database/model/basic/BasicDataObject;", "layout", "", "snippet", "intellij.database.core.impl"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final BasicSnippet build(@NotNull BasicHierarchicalObject r, @NotNull Map<BasicHierarchicalObject, BasicSnippet> subSnippets) {
                Intrinsics.checkNotNullParameter((Object)r, (String)"r");
                Intrinsics.checkNotNullParameter(subSnippets, (String)"subSnippets");
                BasicSnippet snippet = new BasicSnippet();
                snippet.setRoot(r.frozenData());
                snippet.setPath(BasicPaths.of(r));
                this.layout(r, snippet, subSnippets);
                return snippet;
            }

            private final void layout(BasicHierarchicalObject r, BasicSnippet snippet, Map<BasicHierarchicalObject, BasicSnippet> subSnippets) {
                if (!r.hasChildren()) {
                    BasicSnippet sub = subSnippets.remove(r);
                    if (sub != null) {
                        snippet.getNodes().addAll((Collection<BasicDataObject>)sub.getNodes());
                        snippet.getChildren().addAll(sub.getChildren());
                    } else {
                        snippet.getChildren().add(0);
                    }
                } else {
                    int b2 = snippet.getNodes().size();
                    JBIterable jBIterable = r.getChildren().filter(BasicHierarchicalObject.class);
                    Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
                    JBIterable children2 = jBIterable;
                    for (BasicHierarchicalObject child : children2) {
                        List<BasicDataObject> list = snippet.getNodes();
                        BasicDataObject basicDataObject = child.frozenData();
                        Intrinsics.checkNotNullExpressionValue((Object)basicDataObject, (String)"frozenData(...)");
                        list.add(basicDataObject);
                    }
                    snippet.getChildren().add(snippet.getNodes().size() - b2);
                    for (BasicHierarchicalObject e2 : children2) {
                        Intrinsics.checkNotNull((Object)e2);
                        this.layout(e2, snippet, subSnippets);
                    }
                }
            }

            private final BasicHierarchicalObject getOrCreate(ModFamily<? extends BasicHierarchicalObject> family, BasicDataObject e2) {
                BasicHierarchicalObject h2 = (BasicHierarchicalObject)family.find(arg_0 -> Companion.getOrCreate$lambda$0((Function1)new Function1<BasicHierarchicalObject, Boolean>(e2){
                    final /* synthetic */ BasicDataObject $e;
                    {
                        this.$e = $e;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull BasicHierarchicalObject o2) {
                        Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
                        return o2.hasData(this.$e);
                    }
                }, arg_0));
                if (h2 == null) {
                    h2 = family.createNewOne(e2);
                } else {
                    h2.resetSyncPending();
                }
                return h2;
            }

            private static final boolean getOrCreate$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return (Boolean)$tmp0.invoke(p0);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\b\u001a\u0004\u0018\u00010\u00012\u0016\u0010\t\u001a\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\u0002\b\u00030\n2\u0006\u0010\r\u001a\u00020\fH\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0007J\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u001e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J0\u0010\u001b\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u0011J$\u0010\u001f\u001a\u0004\u0018\u00010\u00182\u0006\u0010 \u001a\u00020\u00182\b\u0010!\u001a\u0004\u0018\u00010\u00182\u0006\u0010\"\u001a\u00020\u0004H\u0002J(\u0010#\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00180$2\u0006\u0010 \u001a\u00020\u00182\u000e\u0010%\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00180$H\u0002J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0007J \u0010*\u001a\u00020'2\u0006\u0010+\u001a\u00020\u00182\u0006\u0010,\u001a\u00020\u00182\u0006\u0010-\u001a\u00020\u0004H\u0002J\u0016\u0010.\u001a\u00020'2\u0006\u0010/\u001a\u00020\u00182\u0006\u0010,\u001a\u00020\u0018J(\u00100\u001a\u00020'2\u000e\u0010,\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00180$2\u000e\u0010/\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00180$H\u0002J \u00101\u001a\u00020'2\u0006\u0010,\u001a\u00020\u00182\u000e\u00102\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00180$H\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/intellij/database/model/DataSourceSnapshotManager$Companion;", "", "()V", "IGNORE_AUTO_MINI_CAT", "", "MINICAT_STORAGE", "Lcom/intellij/database/model/ModelTextStorage;", "ourEmptyMiniCat", "findModel", "models", "", "Lcom/intellij/openapi/util/Couple;", "Lcom/intellij/database/util/Version;", "version", "getInstance", "Lcom/intellij/database/model/DataSourceSnapshotManager;", "getMiniCatStream", "Ljava/io/InputStream;", "dbms", "Lcom/intellij/database/Dbms;", "getTargets", "Lcom/intellij/util/containers/JBIterable;", "Lcom/intellij/database/model/basic/BasicElement;", "to", "Lcom/intellij/database/model/basic/BasicHierarchicalObject;", "r", "Lcom/intellij/database/model/basic/BasicRoot;", "loadModel", "Lcom/intellij/openapi/util/Pair;", "Lcom/intellij/database/model/basic/BasicModel;", "inp", "merge", "e", "target", "apply", "sameFamily", "Lcom/intellij/database/model/families/ModFamily;", "f", "setEmptyMiniCat", "", "p", "Lcom/intellij/openapi/Disposable;", "substitute", "self", "what", "recursive", "substituteChildren", "where", "substituteFamilies", "substituteFamily", "family", "intellij.database.core.impl"})
    @SourceDebugExtension(value={"SMAP\nDataSourceSnapshotManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataSourceSnapshotManager.kt\ncom/intellij/database/model/DataSourceSnapshotManager$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,448:1\n1#2:449\n31#3,2:450\n*S KotlinDebug\n*F\n+ 1 DataSourceSnapshotManager.kt\ncom/intellij/database/model/DataSourceSnapshotManager$Companion\n*L\n445#1:450,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @TestOnly
        public final void setEmptyMiniCat(@NotNull Disposable p2) {
            Intrinsics.checkNotNullParameter((Object)p2, (String)"p");
            ourEmptyMiniCat = true;
            Disposer.register((Disposable)p2, Companion::setEmptyMiniCat$lambda$0);
        }

        private final BasicHierarchicalObject merge(BasicHierarchicalObject e2, BasicHierarchicalObject target2, boolean apply2) {
            if (target2 == null) {
                return null;
            }
            boolean exact = Intrinsics.areEqual(e2.getMetaObject(), target2.getMetaObject());
            BasicHierarchicalObject te = null;
            if (exact) {
                te = e2;
            } else {
                te = this.merge(e2, (BasicHierarchicalObject)target2.getParent(), false);
                ObjectPath tp = BasicPaths.of(target2);
                BasicHierarchicalObject basicHierarchicalObject = te = te == null ? null : (BasicHierarchicalObject)SqlModelBuilderUtils.createObject(te, tp.name, tp.isQuoted(), tp.getIdentity(), tp.kind);
                if (te == null) {
                    return null;
                }
            }
            if (apply2) {
                if (te instanceof BasicModMateNamespace) {
                    ((BasicModMateNamespace)((Object)te)).setSubstituted(true);
                }
                this.substituteChildren(te, target2);
            }
            return te;
        }

        public final void substituteChildren(@NotNull BasicHierarchicalObject where2, @NotNull BasicHierarchicalObject what) {
            Intrinsics.checkNotNullParameter((Object)where2, (String)"where");
            Intrinsics.checkNotNullParameter((Object)what, (String)"what");
            for (ModFamily modFamily : where2.getFamilies()) {
                ModFamily<BasicHierarchicalObject> modFamily2 = modFamily.asHierarchical();
                Intrinsics.checkNotNullExpressionValue(modFamily2, (String)"asHierarchical(...)");
                this.substituteFamily(what, modFamily2);
            }
        }

        private final ModFamily<? extends BasicHierarchicalObject> sameFamily(BasicHierarchicalObject e2, ModFamily<? extends BasicHierarchicalObject> f) {
            Family<? extends BasicElement> family = e2.familyOf(f.getMetaObject().kind);
            Intrinsics.checkNotNull(family);
            ModFamily<BasicHierarchicalObject> modFamily = ((ModFamily)family).asHierarchical();
            Intrinsics.checkNotNullExpressionValue(modFamily, (String)"asHierarchical(...)");
            return modFamily;
        }

        private final void substitute(BasicHierarchicalObject self, BasicHierarchicalObject what, boolean recursive) {
            boolean bl = Intrinsics.areEqual(what.getMetaObject(), self.getMetaObject());
            if (_Assertions.ENABLED && !bl) {
                boolean bl2 = false;
                String string = "Wrong object";
                throw new AssertionError((Object)string);
            }
            BasicDataObject data = what.frozenData();
            if (self.hasData(data)) {
                return;
            }
            self.applyData(data);
            if (recursive) {
                for (ModFamily modFamily : self.getFamilies()) {
                    ModFamily<BasicHierarchicalObject> modFamily2 = modFamily.asHierarchical();
                    Intrinsics.checkNotNullExpressionValue(modFamily2, (String)"asHierarchical(...)");
                    this.substituteFamily(what, modFamily2);
                }
            }
        }

        private final void substituteFamily(BasicHierarchicalObject what, ModFamily<? extends BasicHierarchicalObject> family) {
            this.substituteFamilies(this.sameFamily(what, family), family);
        }

        private final void substituteFamilies(ModFamily<? extends BasicHierarchicalObject> what, ModFamily<? extends BasicHierarchicalObject> where2) {
            boolean bl = Intrinsics.areEqual(what.getMetaObject(), where2.getMetaObject());
            if (_Assertions.ENABLED && !bl) {
                boolean bl2 = false;
                String string = "Wrong object";
                throw new AssertionError((Object)string);
            }
            if (where2.size() == what.size()) {
                Iterator fromIt = what.iterator();
                Iterator iterator = where2.iterator();
                while (fromIt.hasNext() && iterator.hasNext()) {
                    this.substitute((BasicHierarchicalObject)iterator.next(), (BasicHierarchicalObject)fromIt.next(), true);
                }
            } else {
                where2.clear();
                for (BasicHierarchicalObject basicHierarchicalObject : what) {
                    Intrinsics.checkNotNull((Object)basicHierarchicalObject);
                    this.substituteChildren(where2.createNewOne(basicHierarchicalObject.frozenData()), basicHierarchicalObject);
                }
            }
        }

        private final Object findModel(Map<Couple<Version>, ?> models2, Version version) {
            for (Map.Entry<Couple<Version>, ?> entry : models2.entrySet()) {
                Couple<Version> key2 = entry.getKey();
                Object value2 = entry.getValue();
                Object object = key2.first;
                Intrinsics.checkNotNull((Object)object);
                if (!version.isOrGreater((Version)object)) continue;
                Object object2 = key2.second;
                Intrinsics.checkNotNull((Object)object2);
                if (version.isOrGreater((Version)object2) && version != Version.INFINITY) continue;
                return value2;
            }
            return null;
        }

        private final JBIterable<BasicElement> getTargets(BasicHierarchicalObject to, BasicRoot r) {
            if (to instanceof BasicRoot) {
                JBIterable jBIterable = JBIterable.of((Object)r);
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"of(...)");
                return jBIterable;
            }
            if (to.getParent() == null) {
                JBIterable jBIterable = JBIterable.empty();
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"empty(...)");
                return jBIterable;
            }
            BasicHierarchicalObject basicHierarchicalObject = (BasicHierarchicalObject)to.getParent();
            Intrinsics.checkNotNull((Object)basicHierarchicalObject);
            JBIterable<BasicElement> targets2 = this.getTargets(basicHierarchicalObject, r);
            JBIterable jBIterable = targets2.flatten(arg_0 -> Companion.getTargets$lambda$3((Function1)new Function1<BasicElement, Iterable<? extends BasicElement>>(to){
                final /* synthetic */ BasicHierarchicalObject $to;
                {
                    this.$to = $to;
                    super(1);
                }

                public final Iterable<BasicElement> invoke(@NotNull BasicElement o2) {
                    Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
                    Object[] objectArray = new String[]{"", this.$to.getName()};
                    return (Iterable)JBIterable.of((Object[])objectArray).filterMap(arg_0 -> getTargets.1.invoke$lambda$0((Function1)new Function1<String, BasicElement>(o2, this.$to){
                        final /* synthetic */ BasicElement $o;
                        final /* synthetic */ BasicHierarchicalObject $to;
                        {
                            this.$o = $o;
                            this.$to = $to;
                            super(1);
                        }

                        @Nullable
                        public final BasicElement invoke(@NotNull String name2) {
                            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                            return (BasicElement)this.$o.getChildren().filter(arg_0 -> Companion.getTargets.1.invoke$lambda$0((Function1)new Function1<BasicElement, Boolean>(this.$to, name2){
                                final /* synthetic */ BasicHierarchicalObject $to;
                                final /* synthetic */ String $name;
                                {
                                    this.$to = $to;
                                    this.$name = $name;
                                    super(1);
                                }

                                @NotNull
                                public final Boolean invoke(@NotNull BasicElement c2) {
                                    Intrinsics.checkNotNullParameter((Object)c2, (String)"c");
                                    return c2.getKind() == this.$to.getKind() && Intrinsics.areEqual((Object)c2.getName(), (Object)this.$name);
                                }
                            }, arg_0)).first();
                        }

                        private static final boolean invoke$lambda$0(Function1 $tmp0, Object p0) {
                            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                            return (Boolean)$tmp0.invoke(p0);
                        }
                    }, arg_0));
                }

                private static final BasicElement invoke$lambda$0(Function1 $tmp0, Object p0) {
                    Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                    return (BasicElement)$tmp0.invoke(p0);
                }
            }, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"flatten(...)");
            return jBIterable;
        }

        @Nullable
        public final InputStream getMiniCatStream(@NotNull Dbms dbms) {
            InputStream res2;
            String string;
            Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
            String name2 = null;
            if (Intrinsics.areEqual((Object)dbms, (Object)Dbms.HSQL)) {
                string = "hsql";
            } else {
                String string2 = StringUtil.toLowerCase((String)dbms.getName());
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            }
            name2 = string;
            Class<?> ctx = DbImplUtilCore.getDatabaseDialect(dbms).getClass();
            String string3 = ctx.getPackage().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
            InputStream inputStream = res2 = ctx.getResourceAsStream("/" + StringsKt.replace$default((String)string3, (char)'.', (char)'/', (boolean)false, (int)4, null) + "/" + name2 + ".minicat.xml");
            if (inputStream != null) {
                return inputStream;
            }
            if (Intrinsics.areEqual((Object)dbms, (Object)Dbms.MARIA)) {
                name2 = "maria";
            }
            return ctx.getResourceAsStream("/" + name2 + ".xml");
        }

        @NotNull
        public final Pair<Couple<Version>, BasicModel> loadModel(@NotNull Dbms dbms, @NotNull Version version, @NotNull InputStream inp) {
            Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            Intrinsics.checkNotNullParameter((Object)inp, (String)"inp");
            ModelImporter importer = new ModelImporter(new ModelFactory(MINICAT_STORAGE));
            importer.expectedVersion = version;
            importer.currentFormat = true;
            BasicModModel model2 = importer.deserialize((HierarchicalStreamReader)new XppReader((Reader)new InputStreamReader(inp, StandardCharsets.UTF_8), (XmlPullParser)new MXParser()), dbms.getName() + "/minicat");
            Intrinsics.checkNotNull((Object)model2, (String)"null cannot be cast to non-null type com.intellij.database.model.BaseModel");
            ((BaseModel)model2).setFrozen(true);
            Pair pair = Pair.create((Object)Couple.of((Object)importer.versionRange[0], (Object)importer.versionRange[1]), (Object)model2);
            Intrinsics.checkNotNullExpressionValue((Object)pair, (String)"create(...)");
            return pair;
        }

        @JvmStatic
        @NotNull
        public final DataSourceSnapshotManager getInstance() {
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication(...)");
            ComponentManager $this$service$iv = (ComponentManager)application;
            boolean $i$f$service = false;
            Class<DataSourceSnapshotManager> serviceClass$iv = DataSourceSnapshotManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (DataSourceSnapshotManager)object;
        }

        private static final void setEmptyMiniCat$lambda$0() {
            ourEmptyMiniCat = false;
        }

        private static final Iterable getTargets$lambda$3(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Iterable)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R#\u0010\u0003\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0004\u0012\u00020\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/intellij/database/model/DataSourceSnapshotManager$ModelsForDbms;", "", "()V", "models", "", "Lcom/intellij/openapi/util/Couple;", "Lcom/intellij/database/util/Version;", "getModels", "()Ljava/util/Map;", "mutex", "Lkotlinx/coroutines/sync/Mutex;", "getMutex", "()Lkotlinx/coroutines/sync/Mutex;", "intellij.database.core.impl"})
    private static final class ModelsForDbms {
        @NotNull
        private final Mutex mutex = MutexKt.Mutex$default((boolean)false, (int)1, null);
        @NotNull
        private final Map<Couple<Version>, Object> models;

        public ModelsForDbms() {
            ConcurrentMap concurrentMap = ContainerUtil.createConcurrentSoftValueMap();
            Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createConcurrentSoftValueMap(...)");
            this.models = concurrentMap;
        }

        @NotNull
        public final Mutex getMutex() {
            return this.mutex;
        }

        @NotNull
        public final Map<Couple<Version>, Object> getModels() {
            return this.models;
        }
    }
}

