/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model;

import com.intellij.database.introspection.IntrospectionTasks;
import com.intellij.database.model.BaseLevelAnalyzer;
import com.intellij.database.model.LevelAnalyzer;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicAuxiliaryElement;
import com.intellij.database.model.basic.BasicDetailElement;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicMajorObject;
import com.intellij.database.model.basic.BasicMinorObject;
import com.intellij.database.model.basic.BasicMultiLevelObject;
import com.intellij.database.model.basic.BasicNamespaceOwner;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.properties.Level;
import com.intellij.database.script.generator.ScriptCategory;
import com.intellij.database.util.common.MapFun;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 02\u00020\u0001:\u00010B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0016\u0010\r\u001a\u00020\n2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\u000fH\u0016J\u001e\u0010\u0010\u001a\u00020\u00112\u0014\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u0013H\u0002J\b\u0010\u0015\u001a\u00020\u0011H\u0016J\b\u0010\u0016\u001a\u00020\u0011H\u0014J\u0010\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\b\u0010\u001d\u001a\u00020\u0011H\u0014J\b\u0010\u001e\u001a\u00020\u0011H\u0014J\b\u0010\u001f\u001a\u00020\u0011H\u0014J\b\u0010 \u001a\u00020\u0011H\u0014J\b\u0010!\u001a\u00020\u0011H\u0014J\u0018\u0010\"\u001a\u00020\n2\u0006\u0010#\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010$\u001a\u00020\n2\u0006\u0010%\u001a\u00020\bH\u0002JH\u0010&\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020\u00052\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020)2\u001e\u0010+\u001a\u001a\u0012\u0004\u0012\u00020-\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00140,0,2\u0006\u0010.\u001a\u00020\u0014H\u0014J\u0018\u0010/\u001a\u00020\n2\u0006\u0010#\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0004j\b\u0012\u0004\u0012\u00020\b`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/intellij/database/model/BaseLevelAnalyzer;", "Lcom/intellij/database/model/LevelAnalyzer;", "()V", "explicitSchemas", "Ljava/util/HashSet;", "Lcom/intellij/database/model/basic/BasicSchema;", "Lkotlin/collections/HashSet;", "levelObjects", "Lcom/intellij/database/model/basic/BasicMultiLevelObject;", "addElementToAnalysis", "", "element", "Lcom/intellij/database/model/basic/BasicElement;", "addElementsToAnalysis", "elements", "", "analyzeContent", "Lcom/intellij/database/model/LevelAnalyzer$Recommendation;", "checker", "Lkotlin/Function1;", "Lcom/intellij/database/model/properties/Level;", "analyzeForAllDetailsAccessing", "analyzeForExecuting", "analyzeForScripting", "category", "Lcom/intellij/database/script/generator/ScriptCategory;", "analyzeForScriptingDeleteAllData", "truncate", "", "analyzeForScriptingDrop", "analyzeForScriptingEnableDisable", "analyzeForScriptingNativeDefinitions", "analyzeForScriptingRecompile", "analyzeForScriptingRefresh", "appendElementToAnalysis", "requestedElement", "appendLevelObject", "levelObject", "decideWhetherToElevateWholeSchema", "schema", "schemaLevelChildrenCount", "", "poorObjectCount", "groups", "", "Lcom/intellij/database/model/ObjectKind;", "maxRequiredLevel", "handleUnexpectedElement", "Companion", "intellij.database.core.impl"})
@SourceDebugExtension(value={"SMAP\nBaseLevelAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseLevelAnalyzer.kt\ncom/intellij/database/model/BaseLevelAnalyzer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,191:1\n1#2:192\n1477#3:193\n1502#3,3:194\n1505#3,3:204\n800#3,11:207\n2661#3,7:218\n1549#3:225\n1620#3,3:226\n372#4,7:197\n*S KotlinDebug\n*F\n+ 1 BaseLevelAnalyzer.kt\ncom/intellij/database/model/BaseLevelAnalyzer\n*L\n61#1:193\n61#1:194,3\n61#1:204,3\n72#1:207,11\n97#1:218,7\n118#1:225\n118#1:226,3\n61#1:197,7\n*E\n"})
public class BaseLevelAnalyzer
implements LevelAnalyzer {
    @NotNull
    protected static final Companion Companion = new Companion(null);
    @NotNull
    private final HashSet<BasicMultiLevelObject> levelObjects = new HashSet();
    @NotNull
    private final HashSet<BasicSchema> explicitSchemas = new HashSet();

    @Override
    public void addElementsToAnalysis(@NotNull Iterable<? extends BasicElement> elements2) {
        Intrinsics.checkNotNullParameter(elements2, (String)"elements");
        for (BasicElement basicElement : elements2) {
            this.addElementToAnalysis(basicElement);
        }
    }

    @Override
    public void addElementToAnalysis(@NotNull BasicElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        this.appendElementToAnalysis(element2, element2);
    }

    public void appendElementToAnalysis(@NotNull BasicElement requestedElement, @NotNull BasicElement element2) {
        Intrinsics.checkNotNullParameter((Object)requestedElement, (String)"requestedElement");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        BasicElement basicElement = element2;
        if (basicElement instanceof BasicMultiLevelObject) {
            this.appendLevelObject((BasicMultiLevelObject)element2);
        } else if (basicElement instanceof BasicMinorObject) {
            Unit unit;
            BasicMajorObject basicMajorObject = ((BasicMinorObject)element2).getMajorObject();
            if (basicMajorObject != null) {
                BasicMajorObject it2 = basicMajorObject;
                boolean bl = false;
                this.appendElementToAnalysis(requestedElement, it2);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (unit == null) {
                this.handleUnexpectedElement(requestedElement, element2);
            }
        } else if (basicElement instanceof BasicDetailElement) {
            Unit unit;
            BasicMajorObject basicMajorObject = ((BasicDetailElement)element2).getMajorObject();
            if (basicMajorObject != null) {
                BasicMajorObject it3 = basicMajorObject;
                boolean bl = false;
                this.appendElementToAnalysis(requestedElement, it3);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (unit == null) {
                this.handleUnexpectedElement(requestedElement, element2);
            }
        } else if (basicElement instanceof BasicSchema) {
            ((Collection)this.explicitSchemas).add(element2);
        } else if (!(basicElement instanceof BasicAuxiliaryElement) && basicElement instanceof BasicNamespaceOwner) {
            this.handleUnexpectedElement(requestedElement, element2);
        }
    }

    private final void appendLevelObject(BasicMultiLevelObject levelObject) {
        boolean bl;
        boolean bl2 = bl = levelObject.getSchema() != null;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Every level object must be attached to a schema, but this one is not: " + levelObject;
            throw new AssertionError((Object)string);
        }
        ((Collection)this.levelObjects).add(levelObject);
    }

    private final void handleUnexpectedElement(BasicElement requestedElement, BasicElement element2) {
        String msg = "Analyzing of this element (" + requestedElement + ") is not supported";
        if (!Intrinsics.areEqual((Object)requestedElement, (Object)element2)) {
            msg = msg + " (checked element was " + element2 + ")";
        }
        throw new IllegalArgumentException(msg);
    }

    /*
     * WARNING - void declaration
     */
    private final LevelAnalyzer.Recommendation analyzeContent(Function1<? super BasicMultiLevelObject, ? extends Level> checker) {
        Object poorObjects;
        Iterable key$iv$iv;
        void $this$groupByTo$iv$iv;
        Iterable $this$groupBy$iv = this.levelObjects;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            BasicMultiLevelObject it2 = (BasicMultiLevelObject)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it2.getSchema());
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List list = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, list);
                object = list;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map schemaLevelObjects = destination$iv$iv;
        Set involvedSchemas = new HashSet(this.explicitSchemas);
        involvedSchemas.addAll(schemaLevelObjects.keySet());
        HashMap schemasToElevate = new HashMap();
        ArrayList fragmentTasks = new ArrayList(2);
        for (BasicSchema schema2 : involvedSchemas) {
            List exactlyRequestedObjects;
            void $this$filterIsInstanceTo$iv$iv;
            poorObjects = new HashMap();
            JBIterable<? extends BasicElement> jBIterable = schema2.getChildren();
            Intrinsics.checkNotNullExpressionValue(jBIterable, (String)"getChildren(...)");
            Iterable $this$filterIsInstance$iv = (Iterable)jBIterable;
            boolean $i$f$filterIsInstance = false;
            key$iv$iv = $this$filterIsInstance$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object t : $this$filterIsInstanceTo$iv$iv) {
                if (!(t instanceof BasicMultiLevelObject)) continue;
                destination$iv$iv2.add(t);
            }
            List children2 = (List)destination$iv$iv2;
            int childrenCount = ((Collection)children2).size();
            if (childrenCount == 0) continue;
            if (this.explicitSchemas.contains(schema2)) {
                for (Object c2 : children2) {
                    Level req2 = (Level)((Object)checker.invoke(c2));
                    if (req2 == null || req2.compareTo((Enum)Level.L2) < 0) continue;
                    ((Map)poorObjects).put(c2, req2);
                }
            }
            if ((exactlyRequestedObjects = (List)schemaLevelObjects.get(schema2)) != null) {
                Object c2;
                c2 = exactlyRequestedObjects.iterator();
                while (c2.hasNext()) {
                    BasicMultiLevelObject o2 = (BasicMultiLevelObject)c2.next();
                    Level req3 = (Level)((Object)checker.invoke((Object)o2));
                    if (req3 == null || req3.compareTo((Enum)Level.L2) < 0) continue;
                    ((HashMap)poorObjects).merge(o2, req3, (arg_0, arg_1) -> BaseLevelAnalyzer.analyzeContent$lambda$4(analyzeContent.1.INSTANCE, arg_0, arg_1));
                }
            }
            if (((HashMap)poorObjects).isEmpty()) continue;
            Map groups2 = MapFun.groupKeysBy((Map)poorObjects, analyzeContent.groups.1.INSTANCE);
            Collection collection2 = ((HashMap)poorObjects).values();
            Intrinsics.checkNotNullExpressionValue(collection2, (String)"<get-values>(...)");
            Iterable $this$reduce$iv = collection2;
            boolean $i$f$reduce = false;
            Iterator iterator = $this$reduce$iv.iterator();
            if (!iterator.hasNext()) {
                throw new UnsupportedOperationException("Empty collection can't be reduced.");
            }
            Object accumulator$iv = iterator.next();
            while (iterator.hasNext()) {
                void lvB;
                Level level = (Level)((Object)iterator.next());
                Level lvA = (Level)((Object)accumulator$iv);
                boolean bl = false;
                accumulator$iv = Companion.greater(lvA, (Level)lvB);
            }
            Level maxLevel = (Level)((Object)accumulator$iv);
            boolean whole = this.decideWhetherToElevateWholeSchema(schema2, childrenCount, ((HashMap)poorObjects).size(), groups2, maxLevel);
            if (whole) {
                ((Map)schemasToElevate).put(schema2, maxLevel);
                continue;
            }
            for (Map.Entry entry : groups2.entrySet()) {
                ObjectKind kind = (ObjectKind)entry.getKey();
                Map objects2 = entry.getValue();
                SortedSet names2 = SequencesKt.toSortedSet((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)objects2.keySet()), (Function1)analyzeContent.names.1.INSTANCE));
                Collection collection3 = fragmentTasks;
                String string = IntrospectionTasks.getDatabaseScopeName(schema2);
                String string2 = schema2.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                collection3.add(IntrospectionTasks.prepareFragmentTask(string, string2, kind, names2));
            }
        }
        ArrayList tasks = new ArrayList();
        if (!((Map)schemasToElevate).isEmpty()) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            poorObjects = MapFun.groupKeysBy(schemasToElevate, analyzeContent.elevationTasks.1.INSTANCE).entrySet();
            boolean $i$f$map = false;
            void childrenCount = $this$map$iv;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it3;
                Map.Entry $i$f$reduce = (Map.Entry)item$iv$iv;
                Collection collection4 = destination$iv$iv3;
                boolean bl = false;
                collection4.add(IntrospectionTasks.prepareElevationTask((String)it3.getKey(), (Map)it3.getValue()));
            }
            List elevationTasks2 = (List)destination$iv$iv3;
            CollectionsKt.addAll((Collection)tasks, (Iterable)elevationTasks2);
        }
        if (!((Collection)fragmentTasks).isEmpty()) {
            CollectionsKt.addAll((Collection)tasks, (Iterable)fragmentTasks);
        }
        return !((Collection)tasks).isEmpty() ? new LevelAnalyzer.Recommendation(tasks) : LevelAnalyzer.Recommendation.nothing;
    }

    protected boolean decideWhetherToElevateWholeSchema(@NotNull BasicSchema schema2, int schemaLevelChildrenCount, int poorObjectCount, @NotNull Map<ObjectKind, ? extends Map<BasicMultiLevelObject, ? extends Level>> groups2, @NotNull Level maxRequiredLevel) {
        Intrinsics.checkNotNullParameter((Object)schema2, (String)"schema");
        Intrinsics.checkNotNullParameter(groups2, (String)"groups");
        Intrinsics.checkNotNullParameter((Object)((Object)maxRequiredLevel), (String)"maxRequiredLevel");
        return switch (WhenMappings.$EnumSwitchMapping$0[maxRequiredLevel.ordinal()]) {
            case 1 -> {
                if (groups2.size() > 4 || poorObjectCount * 5 > schemaLevelChildrenCount) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                if (groups2.size() > 6 || poorObjectCount * 3 > schemaLevelChildrenCount) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    @Override
    @NotNull
    public LevelAnalyzer.Recommendation analyzeForScripting(@NotNull ScriptCategory category) {
        Intrinsics.checkNotNullParameter((Object)((Object)category), (String)"category");
        return switch (WhenMappings.$EnumSwitchMapping$1[category.ordinal()]) {
            case 1, 2, 3, 4 -> this.analyzeForAllDetailsAccessing();
            case 5 -> this.analyzeForScriptingNativeDefinitions();
            case 6 -> this.analyzeForAllDetailsAccessing();
            case 7, 8 -> this.analyzeForScriptingEnableDisable();
            case 9 -> this.analyzeForScriptingRecompile();
            case 10 -> this.analyzeForScriptingRefresh();
            case 11 -> this.analyzeForExecuting();
            case 12 -> this.analyzeForScriptingDeleteAllData(false);
            case 13 -> this.analyzeForScriptingDeleteAllData(true);
            case 14 -> this.analyzeForScriptingDrop();
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Override
    @NotNull
    public LevelAnalyzer.Recommendation analyzeForAllDetailsAccessing() {
        return this.analyzeContent((Function1<? super BasicMultiLevelObject, ? extends Level>)((Function1)analyzeForAllDetailsAccessing.1.INSTANCE));
    }

    @NotNull
    protected LevelAnalyzer.Recommendation analyzeForExecuting() {
        return this.analyzeContent((Function1<? super BasicMultiLevelObject, ? extends Level>)((Function1)analyzeForExecuting.1.INSTANCE));
    }

    @NotNull
    protected LevelAnalyzer.Recommendation analyzeForScriptingNativeDefinitions() {
        return LevelAnalyzer.Recommendation.nothing;
    }

    @NotNull
    protected LevelAnalyzer.Recommendation analyzeForScriptingEnableDisable() {
        return LevelAnalyzer.Recommendation.nothing;
    }

    @NotNull
    protected LevelAnalyzer.Recommendation analyzeForScriptingRecompile() {
        return LevelAnalyzer.Recommendation.nothing;
    }

    @NotNull
    protected LevelAnalyzer.Recommendation analyzeForScriptingRefresh() {
        return LevelAnalyzer.Recommendation.nothing;
    }

    @NotNull
    protected LevelAnalyzer.Recommendation analyzeForScriptingDeleteAllData(boolean truncate) {
        return LevelAnalyzer.Recommendation.nothing;
    }

    @NotNull
    protected LevelAnalyzer.Recommendation analyzeForScriptingDrop() {
        return LevelAnalyzer.Recommendation.nothing;
    }

    private static final Level analyzeContent$lambda$4(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Level)((Object)$tmp0.invoke(p0, p1));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0084\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0003\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0086\u0004J\u0017\u0010\u0006\u001a\u0004\u0018\u00010\u0004*\u00020\u00072\u0006\u0010\b\u001a\u00020\u0004H\u0084\u0004J\u0019\u0010\u0006\u001a\u0004\u0018\u00010\u0004*\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\u0004H\u0084\u0004\u00a8\u0006\t"}, d2={"Lcom/intellij/database/model/BaseLevelAnalyzer$Companion;", "", "()V", "greater", "Lcom/intellij/database/model/properties/Level;", "that", "require", "Lcom/intellij/database/model/basic/BasicElement;", "reqLevel", "intellij.database.core.impl"})
    protected static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Level greater(@NotNull Level $this$greater, @NotNull Level that) {
            Intrinsics.checkNotNullParameter((Object)((Object)$this$greater), (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)((Object)that), (String)"that");
            return that.level > $this$greater.level ? that : $this$greater;
        }

        @Nullable
        protected final Level require(@NotNull BasicElement $this$require, @NotNull Level reqLevel) {
            Intrinsics.checkNotNullParameter((Object)$this$require, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)((Object)reqLevel), (String)"reqLevel");
            return this.require(ModelFun.getDetailsLevel($this$require), reqLevel);
        }

        @Nullable
        protected final Level require(@Nullable Level $this$require, @NotNull Level reqLevel) {
            Intrinsics.checkNotNullParameter((Object)((Object)reqLevel), (String)"reqLevel");
            return $this$require != null && $this$require.compareTo((Enum)reqLevel) >= 0 ? null : reqLevel;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[Level.values().length];
            try {
                nArray[Level.L2.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Level.L3.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ScriptCategory.values().length];
            try {
                nArray[ScriptCategory.CREATE_COMPLETE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScriptCategory.CREATE_BEFORE_IMPORT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScriptCategory.CREATE_AFTER_IMPORT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScriptCategory.CREATE_DEFINITION.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScriptCategory.NATIVE_DEFINITION.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScriptCategory.ALTER.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScriptCategory.ENABLE_CONSTRAINTS.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScriptCategory.DISABLE_CONSTRAINTS.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScriptCategory.RECOMPILE.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScriptCategory.REFRESH.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScriptCategory.EXECUTE.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScriptCategory.DELETE_DATA.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScriptCategory.TRUNCATE.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScriptCategory.DROP_COMPLETE.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

