/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.introspection;

import com.intellij.database.introspection.DefiniteIntrospectionTask;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.common.CollectionFun;
import java.util.Collection;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0005\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\u001d\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007B\u0017\b\u0017\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0019\u001a\u00020\u0003H\u0016R\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001a"}, d2={"Lcom/intellij/database/introspection/RegularIntrospectionTask;", "Lcom/intellij/database/introspection/DefiniteIntrospectionTask;", "databaseName", "", "elementsToRefresh", "", "Lcom/intellij/database/util/ObjectPath;", "(Ljava/lang/String;Ljava/util/Collection;)V", "database", "Lcom/intellij/database/model/basic/BasicDatabase;", "elementToRefresh", "Lcom/intellij/database/model/basic/BasicElement;", "(Lcom/intellij/database/model/basic/BasicDatabase;Lcom/intellij/database/model/basic/BasicElement;)V", "containsDatabaseItself", "", "getContainsDatabaseItself", "()Z", "containsDatabaseItselfCalculated", "containsDatabaseItselfValue", "getElementsToRefresh", "()Ljava/util/Collection;", "taskTypeOrder", "", "getTaskTypeOrder", "()B", "toString", "intellij.database.core.impl"})
public class RegularIntrospectionTask
extends DefiniteIntrospectionTask {
    @NotNull
    private final Collection<ObjectPath> elementsToRefresh;
    private boolean containsDatabaseItselfValue;
    private boolean containsDatabaseItselfCalculated;

    @Override
    public byte getTaskTypeOrder() {
        return 7;
    }

    @NotNull
    public final Collection<ObjectPath> getElementsToRefresh() {
        return this.elementsToRefresh;
    }

    public RegularIntrospectionTask(@NotNull String databaseName, @NotNull Collection<? extends ObjectPath> elementsToRefresh2) {
        Intrinsics.checkNotNullParameter((Object)databaseName, (String)"databaseName");
        Intrinsics.checkNotNullParameter(elementsToRefresh2, (String)"elementsToRefresh");
        super(databaseName, null);
        this.elementsToRefresh = elementsToRefresh2;
    }

    @Deprecated(message="Use methods in IntrospectionTasks", level=DeprecationLevel.ERROR)
    @ApiStatus.ScheduledForRemoval
    public RegularIntrospectionTask(@NotNull BasicDatabase database, @NotNull BasicElement elementToRefresh) {
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        Intrinsics.checkNotNullParameter((Object)elementToRefresh, (String)"elementToRefresh");
        String string = database.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        this(string, SetsKt.setOf((Object)ModelFun.getObjectPath(elementToRefresh)));
    }

    public final boolean getContainsDatabaseItself() {
        if (!this.containsDatabaseItselfCalculated) {
            this.containsDatabaseItselfValue = CollectionFun.containsElements((Iterable)this.elementsToRefresh, (Function1)new Function1<ObjectPath, Boolean>(this){
                final /* synthetic */ RegularIntrospectionTask this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull ObjectPath it2) {
                    Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                    return Intrinsics.areEqual((Object)it2.kind, (Object)ObjectKind.DATABASE) && Intrinsics.areEqual((Object)it2.name, (Object)this.this$0.getDatabaseName());
                }
            });
            this.containsDatabaseItselfCalculated = true;
        }
        return this.containsDatabaseItselfValue;
    }

    @NotNull
    public String toString() {
        int n = this.elementsToRefresh.size();
        StringBuilder b2 = new StringBuilder(n * 32);
        b2.append("Regular introspect ").append(n).append(" element(s) ").append(this.getDatabaseDisplayName()).append(':');
        for (ObjectPath e2 : this.elementsToRefresh) {
            b2.append("\n\t\t+ ").append(e2.toString());
        }
        String string = b2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }
}

