/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.introspection;

import com.intellij.database.dataSource.DataSourceSchemaMapping;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.introspection.DBIntrospectionOptions;
import com.intellij.database.introspection.DatabaseIntrospectionSession;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.util.LoaderContext;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.TreePatternUtils;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.messages.Topic;
import org.jetbrains.annotations.NotNull;

public final class DatabaseModelLoader {
    public static final Topic<Listener> TOPIC = new Topic(Listener.class, Topic.BroadcastDirection.NONE);

    public static boolean matches(@NotNull DasObject o2, @NotNull TreePattern scope) {
        if (o2 == null) {
            DatabaseModelLoader.$$$reportNull$$$0(0);
        }
        if (scope == null) {
            DatabaseModelLoader.$$$reportNull$$$0(1);
        }
        return DataSourceSchemaMapping.matches(scope, o2);
    }

    @NotNull
    static TreePattern getSelectedScope(@NotNull LoaderContext context) {
        if (context == null) {
            DatabaseModelLoader.$$$reportNull$$$0(2);
        }
        JBIterable fromDasObjects = JBIterable.from(context.getSelection()).filter(BasicElement.class).filterMap(o2 -> {
            BasicNamespace nsp = o2.getSchema();
            if (nsp == null) {
                nsp = o2.getDatabase();
            }
            return nsp == null ? null : TreePatternUtils.create(ObjectPaths.of(nsp));
        });
        JBIterable fromStringPatterns = JBIterable.from(context.getSelection()).filter(String.class).transform(s2 -> TreePatternUtils.importPattern(context.getDbms(), s2));
        TreePattern treePattern = TreePatternUtils.union((Iterable<TreePattern>)fromStringPatterns.append((Iterable)fromDasObjects));
        if (treePattern == null) {
            DatabaseModelLoader.$$$reportNull$$$0(3);
        }
        return treePattern;
    }

    @NotNull
    static DBIntrospectionOptions getIntrospectionOptions(LocalDataSource dataSource2) {
        DBIntrospectionOptions.SourceLoading withSources = dataSource2.getSourceLoading();
        return new DBIntrospectionOptions(withSources, dataSource2.getIntrospectionScope());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/introspection/DatabaseModelLoader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/introspection/DatabaseModelLoader";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "matches";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedScope";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    public static interface Listener {
        default public void started(@NotNull DatabaseIntrospectionSession session2) {
            if (session2 == null) {
                Listener.$$$reportNull$$$0(0);
            }
        }

        default public void finished(@NotNull DatabaseIntrospectionSession session2, @NotNull FinishedState state) {
            if (session2 == null) {
                Listener.$$$reportNull$$$0(1);
            }
            if (state == null) {
                Listener.$$$reportNull$$$0(2);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "session";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/introspection/DatabaseModelLoader$Listener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "started";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "finished";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static enum FinishedState {
        OK,
        WARN,
        CANCELLED,
        CONNECTION_FAILED,
        FAILED;

    }
}

