/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.extractors;

import com.intellij.database.Dbms;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGridUtilCore;
import com.intellij.database.datagrid.DatabaseObjectNormalizer;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.extractors.BaseObjectFormatter;
import com.intellij.database.extractors.BinaryDisplayType;
import com.intellij.database.extractors.DatabaseFormatterCreator;
import com.intellij.database.extractors.DatabaseObjectFormatterConfig;
import com.intellij.database.extractors.DbObjectFormatterUtil;
import com.intellij.database.extractors.DisplayType;
import com.intellij.database.extractors.ExtractorsUtil;
import com.intellij.database.extractors.FormatterCreator;
import com.intellij.database.extractors.ImageInfo;
import com.intellij.database.extractors.JsonUtilKt;
import com.intellij.database.extractors.NumberDisplayType;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.extractors.ObjectFormatterConfig;
import com.intellij.database.extractors.ObjectFormatterMode;
import com.intellij.database.extractors.ObjectFormatterUtil;
import com.intellij.database.extractors.TextInfo;
import com.intellij.database.extractors.tz.TimeZonedTime;
import com.intellij.database.extractors.tz.TimeZonedTimestamp;
import com.intellij.database.remote.jdbc.LobInfo;
import com.intellij.database.remote.jdbc.helpers.CassJdbcHelper;
import com.intellij.database.remote.jdbc.helpers.JdbcHelper;
import com.intellij.database.remote.jdbc.helpers.MongoJdbcHelper;
import com.intellij.database.remote.jdbc.helpers.NestedObjectWrapper;
import com.intellij.database.remote.jdbc.impl.BitString;
import com.intellij.database.remote.jdbc.impl.UnparsedValue;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.run.ui.grid.editors.DataGridFormattersUtilCore;
import com.intellij.database.run.ui.grid.editors.FormatsCache;
import com.intellij.database.run.ui.grid.editors.Formatter;
import com.intellij.database.run.ui.grid.editors.NumberFormatter;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.regex.Pattern;
import kotlin.jvm.functions.Function3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbObjectFormatter
extends BaseObjectFormatter {
    private static final Pattern PG_HSTORE_REQUIRES_QUOTATION = Pattern.compile("\\s|,|=|>");
    private static final NotNullLazyKey<DbObjectFormatter, CoreGrid<GridRow, GridColumn>> FORMATTER_KEY = NotNullLazyKey.createLazyKey((String)"FORMATTER_KEY", DbObjectFormatter::new);
    private final Dbms myDbms;
    @Nullable
    private JdbcHelper myHelper;

    @NotNull
    public static DbObjectFormatter get(@NotNull CoreGrid<GridRow, GridColumn> grid) {
        if (grid == null) {
            DbObjectFormatter.$$$reportNull$$$0(0);
        }
        DbObjectFormatter dbObjectFormatter = (DbObjectFormatter)((Object)FORMATTER_KEY.getValue(grid));
        if (dbObjectFormatter == null) {
            DbObjectFormatter.$$$reportNull$$$0(1);
        }
        return dbObjectFormatter;
    }

    private DbObjectFormatter(@NotNull FormatsCache formatsCache, @NotNull Dbms dbms) {
        if (formatsCache == null) {
            DbObjectFormatter.$$$reportNull$$$0(2);
        }
        if (dbms == null) {
            DbObjectFormatter.$$$reportNull$$$0(3);
        }
        super(formatsCache, (FormatterCreator)new DatabaseFormatterCreator(dbms));
        this.myToString.register(byte[].class, (BaseObjectFormatter.Converter)new BaseObjectFormatter.Converter<byte[], String>(){

            public String convert(byte[] o2, GridColumn column2, ObjectFormatterConfig config) {
                return DbObjectFormatterUtil.isMsHierarchyid(DbObjectFormatter.this.myDbms, column2) ? DbImplUtilCore.getDatabaseDialect(DbObjectFormatter.this.myDbms).getBinaryLiteralString(o2) : (DbObjectFormatterUtil.isClickhouseUInt8Array(DbObjectFormatter.this.myDbms, column2) ? DbObjectFormatter.this.arrayToString(DbObjectFormatter.bytesToObjectArray(o2), column2, config) : (config.getMode() != ObjectFormatterMode.SQL_SCRIPT && DbObjectFormatter.isOracleGUID(o2, column2, DbObjectFormatter.this.myDbms) ? ObjectFormatterUtil.toHexString((byte[])o2) : DbObjectFormatter.this.bytesToStringImpl(o2, config)));
            }
        });
        this.myToString.register(BitString.class, (BaseObjectFormatter.Converter)new BaseObjectFormatter.Converter<BitString, String>(){

            public String convert(BitString o2, GridColumn column2, ObjectFormatterConfig config) {
                return DbObjectFormatterUtil.bitsToString(o2, column2);
            }
        });
        this.myToString.register(Clob.class, (BaseObjectFormatter.Converter)new BaseObjectFormatter.Converter<Clob, String>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public String convert(Clob o2, GridColumn column2, ObjectFormatterConfig config) {
                try {
                    long length = o2.length();
                    int trimmed = DbObjectFormatter.trimToMax(length);
                    String string = trimmed > 0 ? o2.getSubString(1L, trimmed) : "";
                    return string;
                }
                catch (Exception e2) {
                    String string = e2.toString();
                    return string;
                }
                finally {
                    LobInfo.freeLob((Clob)o2);
                }
            }
        });
        this.myToString.register(LobInfo.ClobInfo.class, (BaseObjectFormatter.Converter)new BaseObjectFormatter.Converter<LobInfo.ClobInfo, String>(){

            public String convert(LobInfo.ClobInfo o2, GridColumn column2, ObjectFormatterConfig config) {
                return o2.isTruncated() && o2.data == null ? "" : o2.data;
            }
        });
        this.myToString.register(LobInfo.FileClobInfo.class, (BaseObjectFormatter.Converter)new BaseObjectFormatter.Converter<LobInfo.FileClobInfo, String>(){

            public String convert(LobInfo.FileClobInfo o2, GridColumn column2, ObjectFormatterConfig config) {
                return ExtractorsUtil.getPresentableSize(o2.length) + " [" + o2.file.getPath() + "]";
            }
        });
        this.myToString.register(Blob.class, (BaseObjectFormatter.Converter)new BaseObjectFormatter.Converter<Blob, String>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public String convert(Blob o2, GridColumn column2, ObjectFormatterConfig config) {
                try {
                    long length = o2.length();
                    int trimmed = DbObjectFormatter.trimToMax(length);
                    String string = DbObjectFormatter.this.bytesToStringImpl(o2.getBytes(1L, trimmed), config);
                    return string;
                }
                catch (Exception e2) {
                    String string = e2.toString();
                    return string;
                }
                finally {
                    LobInfo.freeLob((Blob)o2);
                }
            }
        });
        this.myToString.register(LobInfo.BlobInfo.class, (BaseObjectFormatter.Converter)new BaseObjectFormatter.Converter<LobInfo.BlobInfo, String>(){

            public String convert(LobInfo.BlobInfo o2, GridColumn column2, ObjectFormatterConfig config) {
                return o2.isTruncated() && o2.data == null ? "" : DbObjectFormatter.this.bytesToStringImpl(o2.data, config);
            }
        });
        this.myToString.register(LobInfo.FileBlobInfo.class, (BaseObjectFormatter.Converter)new BaseObjectFormatter.Converter<LobInfo.FileBlobInfo, String>(){

            public String convert(LobInfo.FileBlobInfo o2, GridColumn column2, ObjectFormatterConfig config) {
                return ExtractorsUtil.getPresentableSize(o2.length) + " [" + o2.file.getPath() + "]";
            }
        });
        this.myToString.register(Timestamp.class, (BaseObjectFormatter.Converter)new BaseObjectFormatter.Converter<Timestamp, String>(){

            public String convert(Timestamp o2, GridColumn column2, ObjectFormatterConfig config) {
                return DbObjectFormatter.this.timestampToString(o2, column2, config);
            }
        });
        this.myToString.register(ImageInfo.class, (BaseObjectFormatter.Converter)new BaseObjectFormatter.Converter<ImageInfo, String>(){

            public String convert(ImageInfo o2, GridColumn column2, ObjectFormatterConfig config) {
                if (config.getMode() == ObjectFormatterMode.DISPLAY || o2.bytes == null) {
                    return o2.width + "x" + o2.height + " " + StringUtil.toUpperCase((String)o2.format) + " image " + ExtractorsUtil.getPresentableSize(o2.size);
                }
                return DbObjectFormatter.this.bytesToStringImpl(o2.bytes, config);
            }
        });
        this.myToString.register(TextInfo.class, (BaseObjectFormatter.Converter)new BaseObjectFormatter.Converter<TextInfo, String>(){

            public String convert(TextInfo o2, GridColumn column2, ObjectFormatterConfig config) {
                if (config instanceof DatabaseObjectFormatterConfig.DatabaseDisplayObjectFormatterConfig) {
                    DatabaseObjectFormatterConfig.DatabaseDisplayObjectFormatterConfig dbConfig = (DatabaseObjectFormatterConfig.DatabaseDisplayObjectFormatterConfig)config;
                    DisplayType displayType = dbConfig.getDisplayType();
                    return DatabaseObjectFormatterConfig.isTypeAllowed((ObjectFormatterConfig)config, (BinaryDisplayType)BinaryDisplayType.TEXT) ? o2.text : DbObjectFormatter.bytesToString(o2.bytes, (BinaryDisplayType)ObjectUtils.tryCast((Object)displayType, BinaryDisplayType.class), DbObjectFormatter.this.myDbms, config.getMode());
                }
                return config.getMode() == ObjectFormatterMode.SQL_SCRIPT && DbObjectFormatter.this.myDbms.isPostgres() && DbObjectFormatter.isPgDecodedLiteral(column2, o2) ? o2.text : (config.getMode() == ObjectFormatterMode.SQL_SCRIPT ? DbImplUtilCore.getDatabaseDialect(DbObjectFormatter.this.myDbms).getBinaryLiteralString(o2.bytes) : o2.text);
            }
        });
        this.myToString.register(Map.class, (BaseObjectFormatter.Converter)new BaseObjectFormatter.Converter<Map, String>(){

            public String convert(Map o2, GridColumn column2, ObjectFormatterConfig config) {
                ObjectFormatterMode itemsMode;
                ObjectFormatterMode objectFormatterMode = itemsMode = config.getMode() == ObjectFormatterMode.DISPLAY || config.getMode() == ObjectFormatterMode.JS_SCRIPT ? ObjectFormatterMode.JS_SCRIPT : ObjectFormatterMode.JSON;
                return DbObjectFormatter.this.myDbms.is(Dbms.CASSANDRA) ? CassJdbcHelper.toValidLiteral((Object)o2) : (DbObjectFormatterUtil.isHstore(column2) ? DbObjectFormatter.hstoreToString(o2, config.getMode()) : (DbObjectFormatter.this.myDbms.in(Dbms.DOCUMENT_ORIENTED) || DbObjectFormatter.this.myDbms.is(Dbms.CLICKHOUSE) ? JsonUtilKt.toJson((Object)o2, (ObjectFormatter)DbObjectFormatter.this, (ObjectFormatterMode)itemsMode, (boolean)false, (boolean)DbObjectFormatter.this.myDbms.in(Dbms.DOCUMENT_ORIENTED), (boolean)DbObjectFormatter.this.myDbms.is(Dbms.CLICKHOUSE)) : null));
            }
        });
        this.myToString.register(Set.class, (BaseObjectFormatter.Converter)new BaseObjectFormatter.Converter<Set, String>(){

            public String convert(Set o2, GridColumn column2, ObjectFormatterConfig config) {
                return DbObjectFormatter.this.myDbms.is(Dbms.CASSANDRA) ? CassJdbcHelper.toValidLiteral((Object)o2) : null;
            }
        });
        this.myToString.register(List.class, (BaseObjectFormatter.Converter)new BaseObjectFormatter.Converter<List, String>(){

            public String convert(List o2, GridColumn column2, ObjectFormatterConfig config) {
                ObjectFormatterMode itemsMode;
                ObjectFormatterMode objectFormatterMode = itemsMode = config.getMode() == ObjectFormatterMode.DISPLAY || config.getMode() == ObjectFormatterMode.JS_SCRIPT ? ObjectFormatterMode.JS_SCRIPT : ObjectFormatterMode.JSON;
                return DbObjectFormatter.this.myDbms.is(Dbms.CASSANDRA) ? CassJdbcHelper.toValidLiteral((Object)o2) : (DbObjectFormatter.this.myDbms.in(Dbms.DOCUMENT_ORIENTED) || DbObjectFormatter.this.myDbms.is(Dbms.CLICKHOUSE) ? JsonUtilKt.toJson((Object)o2, (ObjectFormatter)DbObjectFormatter.this, (ObjectFormatterMode)itemsMode, (boolean)false, (boolean)DbObjectFormatter.this.myDbms.in(Dbms.DOCUMENT_ORIENTED), (boolean)DbObjectFormatter.this.myDbms.is(Dbms.CLICKHOUSE)) : null);
            }
        });
        this.myToString.register(Boolean.class, (BaseObjectFormatter.Converter)new BaseObjectFormatter.Converter<Boolean, String>(){

            public String convert(Boolean o2, GridColumn column2, ObjectFormatterConfig config) {
                return config.getMode() != ObjectFormatterMode.SQL_SCRIPT ? String.valueOf(o2) : (DbObjectFormatter.this.myDbms.isTransactSql() ? (o2.booleanValue() ? "1" : "0") : String.valueOf(o2));
            }
        });
        this.myToString.register(TimeZonedTimestamp.class, (BaseObjectFormatter.Converter)new BaseObjectFormatter.Converter<TimeZonedTimestamp, String>(){

            public String convert(TimeZonedTimestamp o2, GridColumn column2, ObjectFormatterConfig config) {
                return ((Formatter)DbObjectFormatter.this.myFormatsCache.get(FormatsCache.getShortEraZonedTimestampFormatProvider((GridColumn)column2, (ObjectFormatterConfig)config), DbObjectFormatter.this.myFormatterCreator, DbObjectFormatter.this.cacheColumnFormats())).format((Object)o2);
            }
        });
        this.myToString.register(TimeZonedTime.class, (BaseObjectFormatter.Converter)new BaseObjectFormatter.Converter<TimeZonedTime, String>(){

            public String convert(TimeZonedTime o2, GridColumn column2, ObjectFormatterConfig config) {
                return ((Formatter)DbObjectFormatter.this.myFormatsCache.get(FormatsCache.getZonedTimeFormatProvider((GridColumn)column2, (ObjectFormatterConfig)config), DbObjectFormatter.this.myFormatterCreator, DbObjectFormatter.this.cacheColumnFormats())).format((Object)o2);
            }
        });
        this.myToString.register(UnparsedValue.class, (BaseObjectFormatter.Converter)new BaseObjectFormatter.Converter<UnparsedValue, String>(){

            public String convert(UnparsedValue o2, GridColumn column2, ObjectFormatterConfig config) {
                if (config.getMode() == ObjectFormatterMode.DISPLAY) {
                    Object object = DatabaseObjectNormalizer.convertUnparsedValue(o2, column2, DbObjectFormatter.this.myFormatsCache, DbObjectFormatter.this.myFormatterCreator);
                    return DbObjectFormatter.this.objectToString(object, column2, config);
                }
                return o2.getStringRepresentation();
            }
        });
        this.myToString.register(MongoJdbcHelper.MongoValue.class, (BaseObjectFormatter.Converter)new BaseObjectFormatter.Converter<MongoJdbcHelper.MongoValue, String>(){

            public String convert(MongoJdbcHelper.MongoValue o2, GridColumn column2, ObjectFormatterConfig config) {
                return DbObjectFormatter.this.mongoValueToString(o2, column2, config);
            }
        });
        this.myToString.register(MongoJdbcHelper.MongoObjectIdValue.class, (BaseObjectFormatter.Converter)new BaseObjectFormatter.Converter<MongoJdbcHelper.MongoObjectIdValue, String>(){

            public String convert(MongoJdbcHelper.MongoObjectIdValue o2, GridColumn column2, ObjectFormatterConfig config) {
                return config.getMode() == ObjectFormatterMode.JS_SCRIPT ? "new ObjectId(\"" + o2.unwrap() + "\")" : DbObjectFormatter.this.mongoValueToString((MongoJdbcHelper.MongoValue)o2, column2, config);
            }
        });
        this.myToString.register(MongoJdbcHelper.MongoRegexpValue.class, (BaseObjectFormatter.Converter)new BaseObjectFormatter.Converter<MongoJdbcHelper.MongoRegexpValue, String>(){

            public String convert(MongoJdbcHelper.MongoRegexpValue o2, GridColumn column2, ObjectFormatterConfig config) {
                return config.getMode() == ObjectFormatterMode.JSON ? DbObjectFormatter.this.mongoValueToString((MongoJdbcHelper.MongoValue)o2, column2, config) : "/" + o2.pattern + "/" + o2.options;
            }
        });
        this.myToString.register(MongoJdbcHelper.MongoTimestampValue.class, (BaseObjectFormatter.Converter)new BaseObjectFormatter.Converter<MongoJdbcHelper.MongoTimestampValue, String>(){

            public String convert(MongoJdbcHelper.MongoTimestampValue o2, GridColumn column2, ObjectFormatterConfig config) {
                return config.getMode() == ObjectFormatterMode.JSON ? DbObjectFormatter.this.mongoValueToString((MongoJdbcHelper.MongoValue)o2, column2, config) : (config.getMode() == ObjectFormatterMode.JS_SCRIPT ? "new Timestamp(" + o2.time + ", " + o2.inc + ")" : "Timestamp(" + o2.time + ", " + o2.inc + ")");
            }
        });
        this.myToString.register(MongoJdbcHelper.MongoMinKeyValue.class, (BaseObjectFormatter.Converter)new BaseObjectFormatter.Converter<MongoJdbcHelper.MongoMinKeyValue, String>(){

            public String convert(MongoJdbcHelper.MongoMinKeyValue o2, GridColumn column2, ObjectFormatterConfig config) {
                if (o2 == null) {
                    return null;
                }
                return config.getMode() == ObjectFormatterMode.JS_SCRIPT ? "new MinKey()" : (config.getMode() == ObjectFormatterMode.JSON ? String.format("{\"$%s\": \"%s\"}", o2.jsonTypeName(), o2.unwrap()) : "MinKey()");
            }
        });
        this.myToString.register(MongoJdbcHelper.MongoMaxKeyValue.class, (BaseObjectFormatter.Converter)new BaseObjectFormatter.Converter<MongoJdbcHelper.MongoMaxKeyValue, String>(){

            public String convert(MongoJdbcHelper.MongoMaxKeyValue o2, GridColumn column2, ObjectFormatterConfig config) {
                if (o2 == null) {
                    return null;
                }
                return config.getMode() == ObjectFormatterMode.JS_SCRIPT ? "new MaxKey()" : (config.getMode() == ObjectFormatterMode.JSON ? String.format("{\"$%s\": \"%s\"}", o2.jsonTypeName(), o2.unwrap()) : "MaxKey()");
            }
        });
        this.myToString.register(MongoJdbcHelper.MongoBinaryValue.class, (BaseObjectFormatter.Converter)new BaseObjectFormatter.Converter<MongoJdbcHelper.MongoBinaryValue, String>(){

            public String convert(MongoJdbcHelper.MongoBinaryValue o2, GridColumn column2, ObjectFormatterConfig config) {
                return DbObjectFormatter.this.convertMongoBinaryValue(o2.data, o2.type, column2, config.getMode());
            }
        });
        this.myToString.register(MongoJdbcHelper.MongoBlobInfo.class, (BaseObjectFormatter.Converter)new BaseObjectFormatter.Converter<MongoJdbcHelper.MongoBlobInfo, String>(){

            public String convert(MongoJdbcHelper.MongoBlobInfo o2, GridColumn column2, ObjectFormatterConfig config) {
                return DbObjectFormatter.this.convertMongoBinaryValue(o2.data, o2.type, column2, config.getMode());
            }
        });
        this.myToString.register(UUID.class, (BaseObjectFormatter.Converter)new BaseObjectFormatter.Converter<UUID, String>(){

            public String convert(UUID o2, GridColumn column2, ObjectFormatterConfig config) {
                if (DbObjectFormatter.this.myDbms.is(Dbms.MONGO)) {
                    if (config.getMode() == ObjectFormatterMode.JSON) {
                        byte[] binaryData = new byte[16];
                        DbObjectFormatter.writeLongToArrayBigEndian(binaryData, 0, o2.getMostSignificantBits());
                        DbObjectFormatter.writeLongToArrayBigEndian(binaryData, 8, o2.getLeastSignificantBits());
                        return DbObjectFormatter.this.convertMongoBinaryValue(binaryData, (byte)4, column2, config.getMode());
                    }
                    if (config.getMode() == ObjectFormatterMode.JS_SCRIPT) {
                        return "new UUID(\"" + o2.toString() + "\")";
                    }
                }
                return o2.toString();
            }
        });
        this.myToString.register(Number.class, new NumberLikeTimestampConvertor<Number>(Number::longValue, this::numberToString));
        this.myToString.register(BigInteger.class, new NumberLikeTimestampConvertor<BigInteger>(BigInteger::longValue, (o2, column2, config) -> ((NumberFormatter)this.myFormatsCache.get(FormatsCache.getLongFormatProvider((ObjectFormatterConfig)config), this.myFormatterCreator)).format(o2)));
        this.myDbms = dbms;
    }

    public DbObjectFormatter(@NotNull Dbms dbms) {
        if (dbms == null) {
            DbObjectFormatter.$$$reportNull$$$0(4);
        }
        this(new FormatsCache(), dbms);
    }

    private DbObjectFormatter(@NotNull CoreGrid<GridRow, GridColumn> grid) {
        if (grid == null) {
            DbObjectFormatter.$$$reportNull$$$0(5);
        }
        this(FormatsCache.get(grid), DataGridUtilCore.getDbms(grid));
    }

    private String timestampToString(Timestamp o2, GridColumn column2, ObjectFormatterConfig config) {
        FormatsCache.FormatProvider provider = FormatsCache.getTimestampFormatProvider((GridColumn)column2, (ObjectFormatterConfig)config);
        Formatter format2 = (Formatter)this.myFormatsCache.get(provider, this.myFormatterCreator, this.cacheColumnFormats());
        String str = format2.format((Object)o2);
        return this.myDbms.is(Dbms.ORACLE) && config.getMode() == ObjectFormatterMode.SQL_SCRIPT ? DbObjectFormatter.getOracleSqlTimestamp(str, o2, this.myFormatsCache, this.myFormatterCreator) : (this.myDbms.is(Dbms.MONGO) ? DbObjectFormatter.mongoDate(str, config.getMode()) : str);
    }

    private static Byte[] bytesToObjectArray(byte[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return new Byte[0];
        }
        Byte[] result2 = new Byte[array.length];
        for (int i2 = 0; i2 < array.length; ++i2) {
            result2[i2] = array[i2];
        }
        return result2;
    }

    @Nullable
    protected String reservedCellValueToString(@Nullable ReservedCellValue o2, ObjectFormatterConfig config) {
        return this.myDbms.is(Dbms.BIGQUERY) && o2 == ReservedCellValue.UNSET && config.getMode() == ObjectFormatterMode.DISPLAY ? "" : super.reservedCellValueToString(o2, config);
    }

    @NotNull
    protected String dateToString(java.util.Date o2, GridColumn column2, @NotNull ObjectFormatterConfig config) {
        if (config == null) {
            DbObjectFormatter.$$$reportNull$$$0(6);
        }
        if (this.myDbms.is(Dbms.MONGO)) {
            Formatter format2 = (Formatter)this.myFormatsCache.get(FormatsCache.getTimestampFormatProvider((GridColumn)column2, (ObjectFormatterConfig)config), this.myFormatterCreator, this.cacheColumnFormats());
            String str = format2.format((Object)o2);
            return DbObjectFormatter.mongoDate(str, config.getMode());
        }
        String string = super.dateToString(o2, column2, config);
        if (string == null) {
            DbObjectFormatter.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    protected String numberToString(@NotNull Number o2, GridColumn column2, @Nullable ObjectFormatterConfig config) {
        if (o2 == null) {
            DbObjectFormatter.$$$reportNull$$$0(8);
        }
        if (this.myDbms.is(Dbms.MONGO)) {
            ObjectFormatterMode mode;
            ObjectFormatterMode objectFormatterMode = mode = config != null ? config.getMode() : null;
            if (o2 instanceof Double) {
                if (Double.isInfinite((Double)o2) || Double.isNaN((Double)o2)) {
                    String v2;
                    String string = (Double)o2 == Double.POSITIVE_INFINITY ? "Infinity" : (v2 = (Double)o2 == Double.NEGATIVE_INFINITY ? "-Infinity" : "NaN");
                    Object object = mode == ObjectFormatterMode.JSON ? "{\"$numberDecimal\": \"" + v2 + "\"}" : (mode == ObjectFormatterMode.JS_SCRIPT ? "new NumberDecimal(\"" + v2 + "\")" : v2);
                    if (object == null) {
                        DbObjectFormatter.$$$reportNull$$$0(9);
                    }
                    return object;
                }
            } else if (o2 instanceof BigDecimal) {
                if (mode == ObjectFormatterMode.JSON) {
                    String string = String.format("{\"$numberDecimal\": %s}", ((BigDecimal)o2).toPlainString());
                    if (string == null) {
                        DbObjectFormatter.$$$reportNull$$$0(10);
                    }
                    return string;
                }
                if (mode == ObjectFormatterMode.JS_SCRIPT) {
                    String string = "new NumberDecimal(\"" + ((BigDecimal)o2).toPlainString() + "\")";
                    if (string == null) {
                        DbObjectFormatter.$$$reportNull$$$0(11);
                    }
                    return string;
                }
            } else if (o2 instanceof Long) {
                if (mode == ObjectFormatterMode.JS_SCRIPT) {
                    String string = "new NumberLong(\"" + o2 + "\")";
                    if (string == null) {
                        DbObjectFormatter.$$$reportNull$$$0(12);
                    }
                    return string;
                }
            } else if (o2 instanceof Integer && mode == ObjectFormatterMode.JS_SCRIPT) {
                String string = "new NumberInt(\"" + o2 + "\")";
                if (string == null) {
                    DbObjectFormatter.$$$reportNull$$$0(13);
                }
                return string;
            }
        }
        String string = super.numberToString(o2, column2, config);
        if (string == null) {
            DbObjectFormatter.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NotNull
    private static String getOracleSqlTimestamp(@NotNull String str, @NotNull Timestamp o2, @NotNull FormatsCache formatsCache, @NotNull FormatterCreator formatterCreator) {
        LocalDateTime localDateTime;
        if (str == null) {
            DbObjectFormatter.$$$reportNull$$$0(15);
        }
        if (o2 == null) {
            DbObjectFormatter.$$$reportNull$$$0(16);
        }
        if (formatsCache == null) {
            DbObjectFormatter.$$$reportNull$$$0(17);
        }
        if (formatterCreator == null) {
            DbObjectFormatter.$$$reportNull$$$0(18);
        }
        String prefix = DataGridFormattersUtilCore.isEmptyTime((TemporalAccessor)(localDateTime = DataGridFormattersUtilCore.fromDateToLocalDateTime((java.util.Date)o2, (FormatsCache)formatsCache, (FormatterCreator)formatterCreator, null))) ? "DATE" : "TIMESTAMP";
        String string = prefix + " '" + str + "'";
        if (string == null) {
            DbObjectFormatter.$$$reportNull$$$0(19);
        }
        return string;
    }

    protected boolean cacheColumnFormats() {
        return !this.myDbms.in(Dbms.DOCUMENT_ORIENTED);
    }

    @NotNull
    private static String mongoDate(String str, ObjectFormatterMode mode) {
        Object object = mode == ObjectFormatterMode.JSON ? "{\"$date\": \"" + str + "\"}" : (mode == ObjectFormatterMode.JS_SCRIPT ? "new ISODate(\"" + str + "\")" : str);
        if (object == null) {
            DbObjectFormatter.$$$reportNull$$$0(20);
        }
        return object;
    }

    @Nullable
    private String mongoValueToString(@Nullable MongoJdbcHelper.MongoValue o2, GridColumn column2, ObjectFormatterConfig config) {
        if (o2 == null) {
            return null;
        }
        Object unwrapped = o2.unwrap();
        String string = this.objectToString(unwrapped, column2, config);
        return config.getMode() == ObjectFormatterMode.JSON ? (string != null && this.isStringLiteral(column2, unwrapped, config.getMode()) ? String.format("{\"$%s\": \"%s\"}", o2.jsonTypeName(), StringUtil.escapeStringCharacters((String)string)) : String.format("{\"$%s\": %s}", o2.jsonTypeName(), string)) : string;
    }

    private static void writeLongToArrayBigEndian(byte[] bytes, int offset, long x) {
        bytes[offset + 7] = (byte)(0xFFL & x);
        bytes[offset + 6] = (byte)(0xFFL & x >> 8);
        bytes[offset + 5] = (byte)(0xFFL & x >> 16);
        bytes[offset + 4] = (byte)(0xFFL & x >> 24);
        bytes[offset + 3] = (byte)(0xFFL & x >> 32);
        bytes[offset + 2] = (byte)(0xFFL & x >> 40);
        bytes[offset + 1] = (byte)(0xFFL & x >> 48);
        bytes[offset] = (byte)(0xFFL & x >> 56);
    }

    private String convertMongoBinaryValue(byte[] data, byte type, GridColumn column2, ObjectFormatterMode mode) {
        String string = Base64.getEncoder().encodeToString(data);
        if (mode != ObjectFormatterMode.JSON) {
            String v2 = "BinData(" + type + ", \"" + string + "\")";
            return mode == ObjectFormatterMode.JS_SCRIPT ? "new " + v2 : v2;
        }
        HashMap<String, Object> map2 = new HashMap<String, Object>();
        String typeStr = Integer.toString(type, 16);
        map2.put("base64", string);
        map2.put("subType", typeStr.length() == 1 ? "0" + typeStr : typeStr);
        String str = this.objectToString(map2, column2, (ObjectFormatterConfig)new DatabaseObjectFormatterConfig(ObjectFormatterMode.JSON));
        return "{\"$binary\": " + str + "}";
    }

    private static boolean isOracleGUID(byte[] o2, GridColumn column2, Dbms dbms) {
        return dbms.isOracle() && o2 != null && o2.length == 16 && "RAW".equals(column2.getTypeName());
    }

    private static boolean isJson(@NotNull GridColumn column2) {
        if (column2 == null) {
            DbObjectFormatter.$$$reportNull$$$0(21);
        }
        return StringUtil.findIgnoreCase((String)column2.getTypeName(), (String[])new String[]{"json", "jsonb"});
    }

    private static boolean isPostgresArray(@NotNull GridColumn column2) {
        if (column2 == null) {
            DbObjectFormatter.$$$reportNull$$$0(22);
        }
        return column2.getType() == 2003;
    }

    private static boolean isBinaryTextColumn(@NotNull GridColumn column2) {
        if (column2 == null) {
            DbObjectFormatter.$$$reportNull$$$0(23);
        }
        return StringUtil.equals((CharSequence)"bytea", (CharSequence)column2.getTypeName());
    }

    private static String hstoreToString(Map<String, String> hstore, ObjectFormatterMode mode) {
        StringBuilder sb = new StringBuilder();
        boolean first2 = true;
        for (Map.Entry<String, String> entry : hstore.entrySet()) {
            if (!first2) {
                sb.append(',');
                sb.append(mode == ObjectFormatterMode.DISPLAY ? (char)'\n' : ' ');
            }
            DbObjectFormatter.appendHstoreValue(sb, entry.getKey(), mode != ObjectFormatterMode.DISPLAY, false);
            sb.append(" => ");
            DbObjectFormatter.appendHstoreValue(sb, StringUtil.notNullize((String)entry.getValue(), (String)"null"), mode != ObjectFormatterMode.DISPLAY, false);
            first2 = false;
        }
        return sb.toString();
    }

    private static void appendHstoreValue(StringBuilder sb, String value2, boolean escape, boolean forceQuotation) {
        boolean requiresQuotation;
        boolean bl = requiresQuotation = forceQuotation || PG_HSTORE_REQUIRES_QUOTATION.matcher(value2).find();
        if (requiresQuotation) {
            sb.append('\"');
        }
        sb.append(escape ? StringUtil.escapeQuotes((String)value2) : value2);
        if (requiresQuotation) {
            sb.append('\"');
        }
    }

    @NotNull
    protected String bytesToStringImpl(byte @NotNull [] o2, ObjectFormatterConfig config) {
        if (o2 == null) {
            DbObjectFormatter.$$$reportNull$$$0(24);
        }
        BinaryDisplayType displayType = BinaryDisplayType.DETECT;
        if (config instanceof DatabaseObjectFormatterConfig.DatabaseDisplayObjectFormatterConfig) {
            displayType = ((DatabaseObjectFormatterConfig.DatabaseDisplayObjectFormatterConfig)config).getDisplayType();
        }
        return DbObjectFormatter.bytesToString(o2, (BinaryDisplayType)ObjectUtils.tryCast((Object)displayType, BinaryDisplayType.class), this.myDbms, config.getMode());
    }

    @NotNull
    public String getStringLiteral(@NotNull String value2, GridColumn column2, @NotNull ObjectFormatterMode mode) {
        if (value2 == null) {
            DbObjectFormatter.$$$reportNull$$$0(25);
        }
        if (mode == null) {
            DbObjectFormatter.$$$reportNull$$$0(26);
        }
        String quoted = DbImplUtilCore.StringLiteralDecorator.PLAIN.decorate(value2, this.myDbms, true);
        Object object = mode == ObjectFormatterMode.SQL_SCRIPT && this.myDbms.in(Dbms.MYSQL_LIKE) && column2 != null && DbObjectFormatterUtil.isBitString(column2) ? "b" + quoted : quoted;
        if (object == null) {
            DbObjectFormatter.$$$reportNull$$$0(27);
        }
        return object;
    }

    @NotNull
    private JdbcHelper getHelper() {
        if (this.myHelper == null) {
            this.myHelper = DbImplUtilCore.getJdbcHelper(this.myDbms);
        }
        JdbcHelper jdbcHelper = this.myHelper;
        if (jdbcHelper == null) {
            DbObjectFormatter.$$$reportNull$$$0(28);
        }
        return jdbcHelper;
    }

    public boolean isStringLiteral(@Nullable GridColumn column2, @Nullable Object value2, @NotNull ObjectFormatterMode mode) {
        if (mode == null) {
            DbObjectFormatter.$$$reportNull$$$0(29);
        }
        if (mode == ObjectFormatterMode.JSON) {
            if (value2 instanceof Number || value2 instanceof Boolean || value2 instanceof Map || value2 instanceof List) {
                return false;
            }
            return !this.myDbms.isMongo() || !(value2 instanceof MongoJdbcHelper.MongoValue) && !(value2 instanceof java.util.Date) && !DbObjectFormatter.isSpecialDouble(value2) && !(value2 instanceof LobInfo.BlobInfo) && !(value2 instanceof UUID);
        }
        if (this.myDbms.is(Dbms.MONGO)) {
            return switch (mode) {
                case ObjectFormatterMode.JS_SCRIPT -> {
                    if (value2 instanceof String || value2 instanceof LobInfo.ClobInfo) {
                        yield true;
                    }
                    yield false;
                }
                case ObjectFormatterMode.DEFAULT, ObjectFormatterMode.SQL_SCRIPT -> {
                    if (value2 instanceof String || value2 instanceof LobInfo.ClobInfo || value2 instanceof MongoJdbcHelper.MongoValue || value2 instanceof UUID || value2 instanceof Date || value2 instanceof Map || value2 instanceof List || value2 instanceof NestedObjectWrapper || DbObjectFormatter.isSpecialDouble(value2)) {
                        yield true;
                    }
                    yield false;
                }
                default -> false;
            };
        }
        if (mode == ObjectFormatterMode.SQL_SCRIPT && this.myDbms.is(Dbms.ORACLE) && value2 instanceof Timestamp) {
            return false;
        }
        if (mode == ObjectFormatterMode.SQL_SCRIPT || mode == ObjectFormatterMode.DEFAULT || mode == ObjectFormatterMode.JS_SCRIPT) {
            return value2 instanceof LobInfo.ClobInfo || column2 != null && (DbObjectFormatter.isCommonLiteral(this.myDbms, column2, value2, this.getHelper()) || DbObjectFormatter.isJson(column2) || DbObjectFormatter.isPostgresStringLiteral(this.myDbms, column2, value2));
        }
        return false;
    }

    private static boolean isSpecialDouble(@Nullable Object value2) {
        return value2 instanceof Double && (Double.isNaN((Double)value2) || Double.isInfinite((Double)value2));
    }

    private static boolean isCommonLiteral(@NotNull Dbms dbms, @NotNull GridColumn column2, @Nullable Object value2, @Nullable JdbcHelper helper) {
        if (dbms == null) {
            DbObjectFormatter.$$$reportNull$$$0(30);
        }
        if (column2 == null) {
            DbObjectFormatter.$$$reportNull$$$0(31);
        }
        helper = helper != null ? helper : DbImplUtilCore.getJdbcHelper(dbms);
        int jdbcType = ExtractorsUtil.guessJdbcType(column2, value2, dbms);
        return jdbcType == 1 || jdbcType == 12 || jdbcType == -1 || jdbcType == -15 || jdbcType == -9 || jdbcType == -16 || jdbcType == 92 || jdbcType == 91 || jdbcType == 2002 || jdbcType == 2005 || jdbcType == -8 || helper.isTimestamp(jdbcType) || helper.isZonedColumn(column2.getTypeName(), jdbcType) || DbObjectFormatterUtil.isBitString(column2) || !dbms.isCassandra() && StringUtil.equalsIgnoreCase((CharSequence)column2.getTypeName(), (CharSequence)"uuid") || DbObjectFormatter.isSpecialNumber(value2);
    }

    private static boolean isSpecialNumber(@Nullable Object value2) {
        return value2 instanceof Float && (Float.isNaN(((Float)value2).floatValue()) || Float.isInfinite(((Float)value2).floatValue())) || value2 instanceof Double && (Double.isNaN((Double)value2) || Double.isInfinite((Double)value2));
    }

    private static boolean isPostgresStringLiteral(@NotNull Dbms dbms, @NotNull GridColumn column2, @Nullable Object value2) {
        if (dbms == null) {
            DbObjectFormatter.$$$reportNull$$$0(32);
        }
        if (column2 == null) {
            DbObjectFormatter.$$$reportNull$$$0(33);
        }
        return dbms.isPostgres() && (DbObjectFormatterUtil.isHstore(column2) || DbObjectFormatterUtil.isPostgresRangeType(column2) || DbObjectFormatter.isPostgresArray(column2) || StringUtil.findIgnoreCase((String)column2.getTypeName(), (String[])new String[]{"interval", "cird", "circle", "inet", "line", "lseg", "macaddr", "macaddr8", "money", "path", "point", "polygon", "tsquery", "tsvector", "xml"}) || DbObjectFormatter.isPgDecodedLiteral(column2, value2));
    }

    private static boolean isPgDecodedLiteral(@NotNull GridColumn column2, @Nullable Object value2) {
        if (column2 == null) {
            DbObjectFormatter.$$$reportNull$$$0(34);
        }
        return value2 instanceof TextInfo && DbObjectFormatter.isBinaryTextColumn(column2);
    }

    @NotNull
    protected <T> String arrayToString(T[] o2, GridColumn column2, ObjectFormatterConfig config) {
        if (this.myDbms.is(Dbms.CLICKHOUSE)) {
            String string = JsonUtilKt.toJson(o2, (ObjectFormatter)this, (ObjectFormatterMode)ObjectFormatterMode.JSON, (boolean)false, (boolean)false, (boolean)true);
            if (string == null) {
                DbObjectFormatter.$$$reportNull$$$0(35);
            }
            return string;
        }
        String string = super.arrayToString((Object[])o2, column2, config);
        if (string == null) {
            DbObjectFormatter.$$$reportNull$$$0(36);
        }
        return string;
    }

    @NotNull
    private static String bytesToString(byte @NotNull [] bytes, @Nullable BinaryDisplayType displayType, Dbms dbms, @NotNull ObjectFormatterMode mode) {
        if (mode == null) {
            DbObjectFormatter.$$$reportNull$$$0(37);
        }
        if (bytes == null) {
            DbObjectFormatter.$$$reportNull$$$0(38);
        }
        if (mode == ObjectFormatterMode.DISPLAY || mode == ObjectFormatterMode.DEFAULT) {
            String string = ObjectFormatterUtil.toPresentableString((byte[])bytes, (BinaryDisplayType)displayType);
            if (string == null) {
                DbObjectFormatter.$$$reportNull$$$0(39);
            }
            return string;
        }
        TextInfo value2 = TextInfo.tryDetectString((byte[])bytes);
        if (mode != ObjectFormatterMode.SQL_SCRIPT && value2 != null) {
            String string = value2.text;
            if (string == null) {
                DbObjectFormatter.$$$reportNull$$$0(40);
            }
            return string;
        }
        String string = DbImplUtilCore.getDatabaseDialect(dbms).getBinaryLiteralString(bytes);
        if (string == null) {
            DbObjectFormatter.$$$reportNull$$$0(41);
        }
        return string;
    }

    private static int trimToMax(long length) {
        int maxLobLength = DatabaseSettings.getSettings().getBytesLimitPerValue();
        return (long)maxLobLength < length ? maxLobLength : (int)length;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 7, 9, 10, 11, 12, 13, 14, 19, 20, 27, 28, 35, 36, 39, 40, 41 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 1: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 19: 
            case 20: 
            case 27: 
            case 28: 
            case 35: 
            case 36: 
            case 39: 
            case 40: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/extractors/DbObjectFormatter";
                break;
            }
            case 2: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formatsCache";
                break;
            }
            case 3: 
            case 4: 
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 8: 
            case 16: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formatterCreator";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 31: 
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 26: 
            case 29: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bytes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/extractors/DbObjectFormatter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "dateToString";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "numberToString";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getOracleSqlTimestamp";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "mongoDate";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringLiteral";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelper";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "arrayToString";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "bytesToString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 1: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 19: 
            case 20: 
            case 27: 
            case 28: 
            case 35: 
            case 36: 
            case 39: 
            case 40: 
            case 41: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "dateToString";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "numberToString";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getOracleSqlTimestamp";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isJson";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isPostgresArray";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isBinaryTextColumn";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "bytesToStringImpl";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getStringLiteral";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isStringLiteral";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isCommonLiteral";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isPostgresStringLiteral";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isPgDecodedLiteral";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "bytesToString";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 7, 9, 10, 11, 12, 13, 14, 19, 20, 27, 28, 35, 36, 39, 40, 41 -> new IllegalStateException(string);
        };
    }

    private class NumberLikeTimestampConvertor<T>
    implements BaseObjectFormatter.Converter<T, String> {
        private final Function<T, Long> toLong;
        private final Function3<T, GridColumn, ObjectFormatterConfig, String> fallback;

        private NumberLikeTimestampConvertor(@NotNull Function<T, Long> toLong, Function3<T, GridColumn, ObjectFormatterConfig, String> fallback) {
            if (toLong == null) {
                NumberLikeTimestampConvertor.$$$reportNull$$$0(0);
            }
            if (fallback == null) {
                NumberLikeTimestampConvertor.$$$reportNull$$$0(1);
            }
            this.toLong = toLong;
            this.fallback = fallback;
        }

        public String convert(T o2, GridColumn column2, ObjectFormatterConfig config) {
            if (config instanceof DatabaseObjectFormatterConfig.DatabaseDisplayObjectFormatterConfig) {
                DatabaseObjectFormatterConfig.DatabaseDisplayObjectFormatterConfig fineConfig = (DatabaseObjectFormatterConfig.DatabaseDisplayObjectFormatterConfig)config;
                NumberDisplayType displayType = (NumberDisplayType)ObjectUtils.notNull((Object)((NumberDisplayType)ObjectUtils.tryCast((Object)fineConfig.getDisplayType(), NumberDisplayType.class)), (Object)NumberDisplayType.NUMBER);
                long valueToShow = this.toLong.apply(o2);
                if (displayType != NumberDisplayType.NUMBER) {
                    try {
                        Timestamp myTimestamp = displayType == NumberDisplayType.TIMESTAMP_SECONDS ? Timestamp.from(Instant.ofEpochSecond(valueToShow)) : Timestamp.from(Instant.ofEpochMilli(valueToShow));
                        return DbObjectFormatter.this.timestampToString(myTimestamp, column2, config);
                    }
                    catch (IllegalArgumentException | DateTimeException e2) {
                        return String.format("Incorrect timestamp (%s)", this.fallback.invoke(o2, (Object)column2, (Object)config));
                    }
                }
            }
            return (String)this.fallback.invoke(o2, (Object)column2, (Object)config);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "toLong";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "fallback";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/extractors/DbObjectFormatter$NumberLikeTimestampConvertor";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

