/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.editor;

import com.google.common.collect.Iterables;
import com.intellij.database.Dbms;
import com.intellij.database.console.OffsetSavingBuilder;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dataSource.connection.Either;
import com.intellij.database.dataSource.connection.statements.ClosableResultsProducer;
import com.intellij.database.dataSource.connection.statements.ExecutionMode;
import com.intellij.database.dataSource.connection.statements.ParameterizedSmartStatement;
import com.intellij.database.dataSource.connection.statements.ParameterizedStatementData;
import com.intellij.database.dataSource.connection.statements.SmartStatements;
import com.intellij.database.dataSource.connection.statements.StagedException;
import com.intellij.database.dataSource.connection.statements.StandardExecutionMode;
import com.intellij.database.dataSource.connection.statements.StandardResultsProcessors;
import com.intellij.database.dataSource.connection.statements.StatementParameters;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.DataGridUtilCore;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.DatabaseGridDataHookUp;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridDataRequest;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridPagingModel;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.GridSortingModel;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.datagrid.RowSortOrder;
import com.intellij.database.datagrid.mutating.ColumnQueryData;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.editor.DatabaseTableFileEditor;
import com.intellij.database.editor.EditorTableResultPanel;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicTableOrView;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbTableImpl;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.script.generator.dml.DmlTaskKt;
import com.intellij.database.script.generator.dml.DmlUtilKt;
import com.intellij.database.script.generator.dml.SelectTask;
import com.intellij.database.script.generator.dml.WrapInSelectResult;
import com.intellij.database.script.generator.dml.WrapInSelectTask;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.Version;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.TriConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.awt.Component;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OpenDataFileDescriptor
extends OpenFileDescriptor {
    private static final Key<Boolean> DATA_WILL_BE_LOADED_BY_DESCRIPTOR = Key.create((String)"DATA_GRID_LOADING_ORDER_KEY");
    private final String[] myColumnNames;
    private final @NlsActions.ActionDescription String myDescription;
    private final List<Object[]> myValues;
    private final TriConsumer<DdlBuilder, List<DasColumn>, Dbms> myFilterCondition;

    public OpenDataFileDescriptor(@NotNull Project project, @NotNull VirtualFile file, String @Nullable [] columnNames, @NlsActions.ActionDescription @Nullable String description, List<Object @Nullable []> values2, @Nullable TriConsumer<DdlBuilder, List<DasColumn>, Dbms> filterCondition) {
        if (project == null) {
            OpenDataFileDescriptor.$$$reportNull$$$0(0);
        }
        if (file == null) {
            OpenDataFileDescriptor.$$$reportNull$$$0(1);
        }
        super(project, file);
        DATA_WILL_BE_LOADED_BY_DESCRIPTOR.set((UserDataHolder)file, (Object)true);
        this.myColumnNames = columnNames;
        this.myDescription = description;
        this.myValues = values2;
        this.myFilterCondition = filterCondition;
    }

    public OpenDataFileDescriptor(@NotNull Project project, @NotNull VirtualFile file, String @Nullable [] columnNames, @NlsActions.ActionDescription @Nullable String description) {
        if (project == null) {
            OpenDataFileDescriptor.$$$reportNull$$$0(2);
        }
        if (file == null) {
            OpenDataFileDescriptor.$$$reportNull$$$0(3);
        }
        this(project, file, columnNames, description, null, null);
    }

    public void setFilterAndLoadData(DatabaseTableFileEditor.LoadingManager manager, EditorTableResultPanel resultPanel) {
        DATA_WILL_BE_LOADED_BY_DESCRIPTOR.set((UserDataHolder)this.getFile(), (Object)false);
        if (this.myValues != null) {
            this.setFilterAndSortingForNavigatingToFirstRow(resultPanel);
        } else {
            this.setFilterAndSorting(resultPanel);
        }
        GridPagingModel pageModel = resultPanel.getDataHookup().getPageModel();
        if (!pageModel.pageSizeSet()) {
            pageModel.setPageSize(DbImplUtil.getPageSize(DataGridUtil.getDbms((DataGrid)resultPanel)));
        }
        manager.reload();
    }

    private void setFilterAndSorting(EditorTableResultPanel resultPanel) {
        Document document;
        if (this.myFilterCondition != null) {
            OpenDataFileDescriptor.setFilterText(resultPanel, this.myFilterCondition);
        } else if (StringUtil.isEmptyOrSpaces((String)resultPanel.getFilterText())) {
            OpenDataFileDescriptor.setFilterText(resultPanel, resultPanel.getDataHookup().getFilterEmptyText());
        }
        GridSortingModel sortingModel = resultPanel.getDataHookup().getSortingModel();
        Document document2 = document = sortingModel == null ? null : sortingModel.getDocument();
        if (document != null && (StringUtil.isEmptyOrSpaces((String)document.getText()) || resultPanel.getDataHookup().getSortingEmptyText().equals(document.getText()))) {
            DatabaseTableFileEditor.setSortingText((DataGrid)resultPanel, DatabaseSettings.getSettings().getDefaultTableOrdering());
        }
    }

    private void setFilterAndSortingForNavigatingToFirstRow(@NotNull EditorTableResultPanel resultPanel) {
        if (resultPanel == null) {
            OpenDataFileDescriptor.$$$reportNull$$$0(4);
        }
        OpenDataFileDescriptor.setFilterText(resultPanel, "");
        DasObject table = DataGridUtilCore.getDatabaseTable((CoreGrid<GridRow, GridColumn>)resultPanel);
        DasTableKey primaryKey = DasUtil.getPrimaryKey(table);
        LinkedHashSet orderBy = new LinkedHashSet();
        Collections.addAll(orderBy, this.myColumnNames);
        if (primaryKey != null) {
            Iterables.addAll(orderBy, primaryKey.getColumnsRef().names());
        }
        DatabaseTableFileEditor.setSortingText((DataGrid)resultPanel, DatabaseTableFileEditor.generateSortingText((DataGrid)resultPanel, RowSortOrder.Type.ASC, (JBIterable<String>)JBIterable.from(orderBy)));
    }

    public static boolean isDataLoadedByDescriptor(@NotNull VirtualFile file) {
        if (file == null) {
            OpenDataFileDescriptor.$$$reportNull$$$0(5);
        }
        return Boolean.TRUE.equals(DATA_WILL_BE_LOADED_BY_DESCRIPTOR.get((UserDataHolder)file));
    }

    public boolean navigateInEditor(@NotNull Project project, boolean requestFocus) {
        List editors;
        FileEditor editor2;
        JComponent component2;
        if (project == null) {
            OpenDataFileDescriptor.$$$reportNull$$$0(6);
        }
        JComponent jComponent = component2 = (editor2 = (FileEditor)ContainerUtil.getFirstItem((List)(editors = FileEditorManager.getInstance((Project)project).openEditor((OpenFileDescriptor)this, requestFocus)))) != null ? editor2.getPreferredFocusedComponent() : null;
        if (component2 != null) {
            IdeFocusManager.getInstance((Project)this.getProject()).requestFocus((Component)component2, true);
            return true;
        }
        return false;
    }

    @NlsActions.ActionDescription
    public String getDescription() {
        return this.myDescription;
    }

    public void navigateTo(@NotNull DataGrid resultPanel) {
        if (resultPanel == null) {
            OpenDataFileDescriptor.$$$reportNull$$$0(7);
        }
        if (this.myColumnNames != null && this.myColumnNames.length != 0) {
            if (this.myFilterCondition == null && this.myValues == null) {
                DasObject table = DataGridUtilCore.getDatabaseTable((CoreGrid<GridRow, GridColumn>)resultPanel);
                int[] indices = new int[this.myColumnNames.length];
                for (int i2 = 0; i2 < indices.length; ++i2) {
                    indices[i2] = table.getDasChildren(ObjectKind.COLUMN).filter(DasColumn.class).indexOf(DasUtil.byName(this.myColumnNames[i2]));
                }
                resultPanel.getSelectionModel().setColumnSelection(ModelIndexSet.forColumns((CoreGrid)resultPanel, (int[])indices), true);
            } else if (this.myValues != null) {
                this.navigateToFirstMatched(resultPanel);
            }
        }
    }

    private static void setFilterText(@NotNull EditorTableResultPanel resultPanel, @NotNull TriConsumer<DdlBuilder, List<DasColumn>, Dbms> whereCondition) {
        List<DasColumn> columns2;
        if (resultPanel == null) {
            OpenDataFileDescriptor.$$$reportNull$$$0(8);
        }
        if (whereCondition == null) {
            OpenDataFileDescriptor.$$$reportNull$$$0(9);
        }
        if ((columns2 = OpenDataFileDescriptor.getDasColumns((DataGrid)resultPanel)) == null) {
            return;
        }
        Dbms dbms = DataGridUtil.getDbms((DataGrid)resultPanel);
        DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect(dbms);
        DdlBuilder builder = DbImplUtil.createBuilderForUIExec(dialect, DataGridUtilCore.getDatabaseTable((CoreGrid<GridRow, GridColumn>)resultPanel));
        whereCondition.accept((Object)builder, columns2, (Object)dbms);
        OpenDataFileDescriptor.setFilterText(resultPanel, builder.getStatement());
    }

    private static void setFilterText(@NotNull EditorTableResultPanel resultPanel, @NotNull String text2) {
        if (resultPanel == null) {
            OpenDataFileDescriptor.$$$reportNull$$$0(10);
        }
        if (text2 == null) {
            OpenDataFileDescriptor.$$$reportNull$$$0(11);
        }
        resultPanel.setFilterText(text2, -1);
        resultPanel.setIgnoreCurrentFilterText(false);
    }

    private void navigateToFirstMatched(final @NotNull DataGrid resultPanel) {
        if (resultPanel == null) {
            OpenDataFileDescriptor.$$$reportNull$$$0(12);
        }
        final QueryWithParameters existsQuery = this.buildSelectQuery(resultPanel);
        final QueryWithParameters countQuery = this.buildCountQuery(resultPanel);
        DatabaseGridDataHookUp hookup = DataGridUtil.getDatabaseHookUp((CoreGrid<GridRow, GridColumn>)resultPanel);
        if (existsQuery == null || countQuery == null || hookup == null) {
            return;
        }
        hookup.getMessageBus().getDataProducer().processRequest((GridDataRequest)new DataRequest.RawRequest(hookup){

            @Override
            public void processRaw(DataRequest.Context context, DatabaseConnectionCore connection2) {
                int position = -1;
                SmartStatements statements2 = SmartStatements.poweredBy((DatabaseConnection)connection2);
                ParameterizedSmartStatement statement2 = statements2.parameterized();
                String sql = existsQuery.sql;
                boolean exists = statement2.execute(new StatementParameters().placeholdersOffsets(existsQuery.offsets).parameters(existsQuery.data).asData(sql), (ExecutionMode)StandardExecutionMode.QUERY, StandardResultsProcessors.throwableResultsTransformer(rs -> rs.next(), false)).rightOr(false);
                if (exists) {
                    position = 0;
                    ParameterizedStatementData data = new StatementParameters().parameters(countQuery.data).placeholdersOffsets(countQuery.offsets).asData(countQuery.sql);
                    Either<StagedException, ClosableResultsProducer> producerEither = statement2.execute(data, StandardExecutionMode.QUERY);
                    if (producerEither.isRight()) {
                        try (ClosableResultsProducer producer = Objects.requireNonNull(producerEither.getRight());){
                            while (producer.advanceSafe()) {
                                position += producer.processCurrent(StandardResultsProcessors.SUM).intValue();
                            }
                        }
                    }
                }
                resultPanel.getResultView().showFirstCell(position + 1);
            }
        });
    }

    private QueryWithParameters buildSelectQuery(@NotNull DataGrid grid) {
        if (grid == null) {
            OpenDataFileDescriptor.$$$reportNull$$$0(13);
        }
        DasObject dasTable = DataGridUtilCore.getDatabaseTable((CoreGrid<GridRow, GridColumn>)grid);
        List<GridColumn> columns2 = this.getColumns(grid);
        if (dasTable == null || columns2 == null) {
            return null;
        }
        Dbms dbms = DataGridUtil.getDbms(grid);
        OffsetSavingBuilder builder = new OffsetSavingBuilder(DbImplUtil.createBuilderForUIExec(DbImplUtil.getDatabaseDialect(dbms), dasTable));
        List<ColumnQueryData> data = IntStream.range(0, Math.min(this.myValues.get(0).length, columns2.size())).mapToObj(idx -> new ColumnQueryData((GridColumn)columns2.get(idx), this.myValues.get(0)[idx])).collect(Collectors.toList());
        DbDataSource system = DataGridUtilCore.getDatabaseSystem((CoreGrid<GridRow, GridColumn>)grid);
        List<ColumnQueryData> parameters2 = OpenDataFileDescriptor.createSelectAllQueryWithParameters(builder, dasTable, dbms, DbImplUtil.getDatabaseVersion(system), data, 1);
        return new QueryWithParameters(builder.getStatement(), parameters2, builder.getOffsets());
    }

    @NotNull
    private static List<ColumnQueryData> createSelectAllQueryWithParameters(@NotNull DdlBuilder builder, @NotNull DasObject table, @NotNull Dbms dbms, @Nullable Version version, @NotNull List<ColumnQueryData> datas, int limit) {
        if (builder == null) {
            OpenDataFileDescriptor.$$$reportNull$$$0(14);
        }
        if (table == null) {
            OpenDataFileDescriptor.$$$reportNull$$$0(15);
        }
        if (dbms == null) {
            OpenDataFileDescriptor.$$$reportNull$$$0(16);
        }
        if (datas == null) {
            OpenDataFileDescriptor.$$$reportNull$$$0(17);
        }
        ArrayList<ColumnQueryData> newData = new ArrayList<ColumnQueryData>();
        SelectTask task = DmlTaskKt.allColumns(table).version(version).limit(limit).whereClause(DmlUtilKt.whereClause(datas, newData, dbms, (Ref<Boolean>)new Ref(), (Ref<BitSet>)new Ref(), 0, table)).build(builder);
        DmlUtilKt.dmlGenerator(dbms).generate(task);
        ArrayList<ColumnQueryData> arrayList = newData;
        if (arrayList == null) {
            OpenDataFileDescriptor.$$$reportNull$$$0(18);
        }
        return arrayList;
    }

    private QueryWithParameters buildCountQuery(@NotNull DataGrid grid) {
        DasObject dasTable;
        if (grid == null) {
            OpenDataFileDescriptor.$$$reportNull$$$0(19);
        }
        if ((dasTable = DataGridUtilCore.getDatabaseTable((CoreGrid<GridRow, GridColumn>)grid)) == null) {
            return null;
        }
        Dbms dbms = DataGridUtil.getDbms(grid);
        DbDataSource dataSource2 = DataGridUtilCore.getDatabaseSystem((CoreGrid<GridRow, GridColumn>)grid);
        Version version = DbImplUtil.getDatabaseVersion(dataSource2);
        SelectTask task = DmlTaskKt.allColumns(dasTable).version(version).build(DbImplUtil.createBuilderForUIExec(dbms, dasTable));
        OffsetSavingBuilder builder = new OffsetSavingBuilder(DmlUtilKt.dmlGenerator(dbms).generate(task).getBuilder());
        builder.space().keyword("WHERE").space();
        ArrayList<Pair<GridColumn, Object>> parameters2 = new ArrayList<Pair<GridColumn, Object>>();
        GridModel model2 = grid.getDataModel(DataAccessType.DATABASE_DATA);
        for (int i3 = 0; i3 < this.myColumnNames.length; ++i3) {
            String columnName = this.myColumnNames[i3];
            Object parameterValue = this.myValues.get(0)[i3];
            GridColumn column2 = (GridColumn)model2.getColumn(GridUtil.findColumn((DataGrid)grid, (String)columnName));
            if (column2 == null) {
                return null;
            }
            if (i3 > 0) {
                builder.space().keyword("OR").space();
            }
            Pair columnValuePair = Pair.create((Object)column2, (Object)parameterValue);
            builder.columnRef(columnName).space().symbol("<").space().placeholder();
            parameters2.add((Pair<GridColumn, Object>)columnValuePair);
            DasColumn dasColumn = DataGridUtilCore.getDatabaseColumn((CoreGrid<GridRow, GridColumn>)grid, column2);
            if (dasColumn != null && !dasColumn.isNotNull()) {
                builder.space().keyword("OR").space().columnRef(columnName).space().keywords("IS", "NULL");
            }
            for (int j = 0; j < i3; ++j) {
                builder.space().keyword("AND").space();
                int placeholdersCount = DbImplUtil.composeWhereItemWithParameters(builder, column2, parameterValue == null, null, dbms, false);
                for (int k = 0; k < placeholdersCount; ++k) {
                    parameters2.add((Pair<GridColumn, Object>)columnValuePair);
                }
            }
        }
        int[] offsets = builder.getOffsets();
        DdlBuilder b2 = DbImplUtil.createBuilderForUIExec(DbImplUtil.getDatabaseDialect(dbms), (DasObject)dataSource2);
        WrapInSelectTask wrapTask = DmlTaskKt.wrapInSelect(builder.getStatement(), this.getProject()).countAll().version(version).build(b2);
        WrapInSelectResult result2 = DmlUtilKt.dmlGenerator(dbms).generate(wrapTask);
        return result2 == null || result2.getOffset() == null ? null : new QueryWithParameters(result2.getStatement(), QueryWithParameters.convert(parameters2), IntStream.of(offsets).map(i2 -> i2 + result2.getOffset()).toArray());
    }

    @Nullable
    private static List<DasColumn> getDasColumns(@NotNull DataGrid grid) {
        DbTableImpl dbTable;
        if (grid == null) {
            OpenDataFileDescriptor.$$$reportNull$$$0(20);
        }
        if ((dbTable = (DbTableImpl)ObjectUtils.tryCast((Object)DataGridUtilCore.getDatabaseTable((CoreGrid<GridRow, GridColumn>)grid), DbTableImpl.class)) == null) {
            return null;
        }
        BasicTableOrView table = (BasicTableOrView)ObjectUtils.tryCast((Object)DbImplUtil.getMaybeBasicElement(dbTable), BasicTableOrView.class);
        if (table == null) {
            return null;
        }
        return JBIterable.from(table.getColumns()).filter(DasColumn.class).toList();
    }

    @Nullable
    private List<GridColumn> getColumns(@NotNull DataGrid grid) {
        GridModel model2;
        List columns2;
        if (grid == null) {
            OpenDataFileDescriptor.$$$reportNull$$$0(21);
        }
        return (columns2 = ContainerUtil.mapNotNull((Object[])this.myColumnNames, arg_0 -> OpenDataFileDescriptor.lambda$getColumns$2(model2 = grid.getDataModel(DataAccessType.DATABASE_DATA), grid, arg_0))).size() == this.myColumnNames.length ? columns2 : null;
    }

    private static /* synthetic */ GridColumn lambda$getColumns$2(GridModel model2, DataGrid grid, String columnName) {
        return (GridColumn)model2.getColumn(GridUtil.findColumn((DataGrid)grid, (String)columnName));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultPanel";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "whereCondition";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 13: 
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "datas";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/editor/OpenDataFileDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/editor/OpenDataFileDescriptor";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createSelectAllQueryWithParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setFilterAndSortingForNavigatingToFirstRow";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isDataLoadedByDescriptor";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "navigateInEditor";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "navigateTo";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setFilterText";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "navigateToFirstMatched";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "buildSelectQuery";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createSelectAllQueryWithParameters";
                break;
            }
            case 18: {
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "buildCountQuery";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getDasColumns";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getColumns";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 18 -> new IllegalStateException(string);
        };
    }

    private static final class QueryWithParameters {
        public final String sql;
        public final List<ColumnQueryData> data;
        public final int[] offsets;

        private QueryWithParameters(@NotNull String sql, @NotNull List<ColumnQueryData> data, int[] offsets) {
            if (sql == null) {
                QueryWithParameters.$$$reportNull$$$0(0);
            }
            if (data == null) {
                QueryWithParameters.$$$reportNull$$$0(1);
            }
            this.sql = sql;
            this.data = Collections.unmodifiableList(data);
            this.offsets = offsets;
        }

        @NotNull
        private static List<ColumnQueryData> convert(@NotNull List<Pair<GridColumn, Object>> pairs2) {
            if (pairs2 == null) {
                QueryWithParameters.$$$reportNull$$$0(2);
            }
            List list = ContainerUtil.map(pairs2, pair -> {
                GridColumn first2 = (GridColumn)pair.getFirst();
                Object second = pair.getSecond();
                return new ColumnQueryData(first2, second);
            });
            if (list == null) {
                QueryWithParameters.$$$reportNull$$$0(3);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sql";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pairs";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/editor/OpenDataFileDescriptor$QueryWithParameters";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/editor/OpenDataFileDescriptor$QueryWithParameters";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "convert";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "convert";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }
}

