/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.editor;

import com.intellij.database.csv.CsvFormat;
import com.intellij.database.editor.CsvTableFileEditor;
import com.intellij.database.editor.ScriptedTableFileEditor;
import com.intellij.database.editor.SqlInsertsTableFileEditor;
import com.intellij.database.loaders.DataLoader;
import com.intellij.database.vfs.fragment.CsvTableDataFragmentFile;
import com.intellij.database.vfs.fragment.ScriptedTableDataFragmentFile;
import com.intellij.database.vfs.fragment.SqlTableDataFragmentFile;
import com.intellij.database.vfs.fragment.TableDataFragmentFile;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.WeighedFileEditorProvider;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.sql.dialects.SqlLanguageDialect;
import org.jetbrains.annotations.NotNull;

public final class FragmentTableFileEditorProvider
extends WeighedFileEditorProvider {
    private static final String TYPE_ID = "table-data-fragment-editor";

    public static void openFragmentEditor(@NotNull Project project, @NotNull VirtualFile file, @NotNull TextRange range, @NotNull DataLoader loader) {
        if (project == null) {
            FragmentTableFileEditorProvider.$$$reportNull$$$0(0);
        }
        if (file == null) {
            FragmentTableFileEditorProvider.$$$reportNull$$$0(1);
        }
        if (range == null) {
            FragmentTableFileEditorProvider.$$$reportNull$$$0(2);
        }
        if (loader == null) {
            FragmentTableFileEditorProvider.$$$reportNull$$$0(3);
        }
        FragmentTableFileEditorProvider.openFragmentEditor(project, (TableDataFragmentFile)new ScriptedTableDataFragmentFile(file, range, loader));
    }

    public static void openFragmentEditor(@NotNull Project project, @NotNull VirtualFile file, @NotNull TextRange range, @NotNull CsvFormat format2) {
        if (project == null) {
            FragmentTableFileEditorProvider.$$$reportNull$$$0(4);
        }
        if (file == null) {
            FragmentTableFileEditorProvider.$$$reportNull$$$0(5);
        }
        if (range == null) {
            FragmentTableFileEditorProvider.$$$reportNull$$$0(6);
        }
        if (format2 == null) {
            FragmentTableFileEditorProvider.$$$reportNull$$$0(7);
        }
        FragmentTableFileEditorProvider.openFragmentEditor(project, (TableDataFragmentFile)new CsvTableDataFragmentFile(file, range, format2));
    }

    public static void openFragmentEditor(@NotNull Project project, @NotNull VirtualFile file, @NotNull TextRange range, @NotNull SqlLanguageDialect dialect) {
        if (project == null) {
            FragmentTableFileEditorProvider.$$$reportNull$$$0(8);
        }
        if (file == null) {
            FragmentTableFileEditorProvider.$$$reportNull$$$0(9);
        }
        if (range == null) {
            FragmentTableFileEditorProvider.$$$reportNull$$$0(10);
        }
        if (dialect == null) {
            FragmentTableFileEditorProvider.$$$reportNull$$$0(11);
        }
        FragmentTableFileEditorProvider.openFragmentEditor(project, new SqlTableDataFragmentFile(file, range, dialect));
    }

    public boolean accept(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            FragmentTableFileEditorProvider.$$$reportNull$$$0(12);
        }
        if (file == null) {
            FragmentTableFileEditorProvider.$$$reportNull$$$0(13);
        }
        return file instanceof TableDataFragmentFile;
    }

    public boolean acceptRequiresReadAction() {
        return false;
    }

    @NotNull
    public FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            FragmentTableFileEditorProvider.$$$reportNull$$$0(14);
        }
        if (file == null) {
            FragmentTableFileEditorProvider.$$$reportNull$$$0(15);
        }
        return FragmentTableFileEditorProvider.createEditor(project, (TableDataFragmentFile)file);
    }

    @NotNull
    public String getEditorTypeId() {
        return TYPE_ID;
    }

    @NotNull
    public FileEditorPolicy getPolicy() {
        FileEditorPolicy fileEditorPolicy = FileEditorPolicy.HIDE_DEFAULT_EDITOR;
        if (fileEditorPolicy == null) {
            FragmentTableFileEditorProvider.$$$reportNull$$$0(16);
        }
        return fileEditorPolicy;
    }

    private static void openFragmentEditor(@NotNull Project project, @NotNull TableDataFragmentFile fragmentFile) {
        if (project == null) {
            FragmentTableFileEditorProvider.$$$reportNull$$$0(17);
        }
        if (fragmentFile == null) {
            FragmentTableFileEditorProvider.$$$reportNull$$$0(18);
        }
        EditorWindow window = FileEditorManagerEx.getInstanceEx((Project)project).getCurrentWindow();
        window.split(0, true, (VirtualFile)fragmentFile, true);
    }

    @NotNull
    private static FileEditor createEditor(@NotNull Project project, @NotNull TableDataFragmentFile fragmentFile) {
        if (project == null) {
            FragmentTableFileEditorProvider.$$$reportNull$$$0(19);
        }
        if (fragmentFile == null) {
            FragmentTableFileEditorProvider.$$$reportNull$$$0(20);
        }
        if (fragmentFile instanceof SqlTableDataFragmentFile) {
            SqlTableDataFragmentFile f = (SqlTableDataFragmentFile)fragmentFile;
            return new SqlInsertsTableFileEditor(project, f);
        }
        if (fragmentFile instanceof CsvTableDataFragmentFile) {
            CsvTableDataFragmentFile f = (CsvTableDataFragmentFile)fragmentFile;
            return new CsvTableFileEditor(project, f);
        }
        if (fragmentFile instanceof ScriptedTableDataFragmentFile) {
            ScriptedTableDataFragmentFile f = (ScriptedTableDataFragmentFile)fragmentFile;
            return new ScriptedTableFileEditor(project, (VirtualFile)f, f.getLoader());
        }
        throw new AssertionError(fragmentFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loader";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/editor/FragmentTableFileEditorProvider";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragmentFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/editor/FragmentTableFileEditorProvider";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getPolicy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "openFragmentEditor";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 14: 
            case 15: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createEditor";
                break;
            }
            case 16: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 16 -> new IllegalStateException(string);
        };
    }
}

