/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dump;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.console.client.DatabaseSessionClient;
import com.intellij.database.console.session.DatabaseSessionManager;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.connection.DGDepartment;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridDataRequest;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.datagrid.ObjectNormalizerProvider;
import com.intellij.database.dump.DumpHandler;
import com.intellij.database.dump.DumpRequest;
import com.intellij.database.dump.ExtractionHelper;
import com.intellij.database.extractors.DataExtractor;
import com.intellij.database.extractors.DataExtractorFactory;
import com.intellij.database.extractors.DbExtractorConfig;
import com.intellij.database.extractors.DbObjectFormatter;
import com.intellij.database.extractors.ExtractionConfig;
import com.intellij.database.extractors.ExtractorConfig;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbTable;
import com.intellij.database.run.actions.DbTablesSourceNameProvider;
import com.intellij.database.run.actions.DumpSourceNameProvider;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.Out;
import com.intellij.database.util.SearchPath;
import com.intellij.database.util.Version;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.JBIterable;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;

public class DatabaseViewHandler
extends DumpHandler<DbTable> {
    public DatabaseViewHandler(@NotNull Project project, @NotNull JBIterable<DbTable> target2, @NotNull ExtractionHelper manager, @NotNull ExtractionConfig config, @NotNull DataExtractorFactory factory) {
        if (project == null) {
            DatabaseViewHandler.$$$reportNull$$$0(0);
        }
        if (target2 == null) {
            DatabaseViewHandler.$$$reportNull$$$0(1);
        }
        if (manager == null) {
            DatabaseViewHandler.$$$reportNull$$$0(2);
        }
        if (config == null) {
            DatabaseViewHandler.$$$reportNull$$$0(3);
        }
        if (factory == null) {
            DatabaseViewHandler.$$$reportNull$$$0(4);
        }
        super(project, target2, (DumpSourceNameProvider)DbTablesSourceNameProvider.INSTANCE, manager, DatabaseViewHandler.getName(target2), factory, config);
    }

    @NotNull
    private static String getName(@NotNull JBIterable<DbTable> target2) {
        if (target2 == null) {
            DatabaseViewHandler.$$$reportNull$$$0(5);
        }
        return target2.skip(1).isEmpty() ? Objects.requireNonNull((DbTable)target2.first()).getName() : "tables";
    }

    @NotNull
    protected ExtractorConfig createExtractorConfig(@NotNull DbTable source, @Nullable Project project) {
        if (source == null) {
            DatabaseViewHandler.$$$reportNull$$$0(6);
        }
        ObjectFormatter formatter = this.getFormatter(source);
        DasDataSource system = this.getDatabaseSystem();
        Version version = system == null ? null : system.getVersion();
        Dbms dbms = source.getDataSource().getDbms();
        return new DbExtractorConfig(project, dbms, (ObjectFormatter)(formatter != null ? formatter : new DbObjectFormatter(dbms)), source, version);
    }

    protected int getSubQueryIndex(@NotNull DbTable source) {
        if (source == null) {
            DatabaseViewHandler.$$$reportNull$$$0(7);
        }
        return 1;
    }

    protected int getResultSetIndex(@NotNull DbTable source) {
        if (source == null) {
            DatabaseViewHandler.$$$reportNull$$$0(8);
        }
        return 1;
    }

    @Nullable
    protected ModelIndexSet<GridColumn> getSelectedColumns(@NotNull DbTable source) {
        if (source == null) {
            DatabaseViewHandler.$$$reportNull$$$0(9);
        }
        return null;
    }

    @Nullable
    protected AsyncPromise<Void> run(@NotNull DbTable source, @NotNull DataExtractor extractor, @NotNull Out out, @NotNull DumpHandler.DumpHandlerParameters dumpParameters) {
        if (source == null) {
            DatabaseViewHandler.$$$reportNull$$$0(10);
        }
        if (extractor == null) {
            DatabaseViewHandler.$$$reportNull$$$0(11);
        }
        if (out == null) {
            DatabaseViewHandler.$$$reportNull$$$0(12);
        }
        if (dumpParameters == null) {
            DatabaseViewHandler.$$$reportNull$$$0(13);
        }
        return ((GridDataRequest)this.newEngineRunner(source, out, dumpParameters).fun((Object)extractor)).getPromise();
    }

    @NlsSafe
    @Nullable
    protected String getDatabaseSystemName() {
        DasDataSource system = this.getDatabaseSystem();
        return system != null ? system.getName() : null;
    }

    @Nullable
    private DasDataSource getDatabaseSystem() {
        JBIterable uniqueSources = this.mySources.transform(DbElement::getDataSource).unique();
        return uniqueSources.skip(1).isEmpty() ? (DasDataSource)Objects.requireNonNull((DbDataSource)uniqueSources.first()) : null;
    }

    @Nullable
    protected String getProducerName() {
        return this.isSingleSource() ? Objects.requireNonNull((DbTable)this.mySources.first()).getName() : null;
    }

    @Nullable
    protected String getSourceName(int count) {
        return DatabaseBundle.message("export.table", count);
    }

    @NotNull
    NotNullFunction<DataExtractor, GridDataRequest> newEngineRunner(@NotNull DbTable table, @NotNull Out out, @NotNull DumpHandler.DumpHandlerParameters dumpParameters) {
        if (table == null) {
            DatabaseViewHandler.$$$reportNull$$$0(14);
        }
        if (out == null) {
            DatabaseViewHandler.$$$reportNull$$$0(15);
        }
        if (dumpParameters == null) {
            DatabaseViewHandler.$$$reportNull$$$0(16);
        }
        NotNullFunction notNullFunction = extractor -> {
            LocalDataSource dataSource2 = DbImplUtilCore.getLocalDataSource(table.getDataSource());
            DasNamespace namespace = DbImplUtilCore.getSearchPathObjectForSwitch(table);
            SearchPath searchPath = ObjectPaths.searchPathOf(namespace);
            DatabaseSessionManager.Facade facade = DatabaseSessionManager.getFacade(this.myProject, dataSource2, null, searchPath, false, null, DGDepartment.DATA_EXPORT);
            DatabaseSessionClient client = facade.client();
            GridDataRequest request = this.createDumpRequest(client, (DataExtractor)extractor, out, table.getName(), dumpParameters);
            request.getPromise().onProcessed(v2 -> Disposer.dispose((Disposable)client));
            client.getMessageBus().getDataProducer().processRequest(request);
            return request;
        };
        if (notNullFunction == null) {
            DatabaseViewHandler.$$$reportNull$$$0(17);
        }
        return notNullFunction;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NotNull
    protected GridDataRequest createDumpRequest(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull GridDataRequest.GridDataRequestOwner owner, DataExtractor extractor, @NotNull Out out, @Nullable String name2, @NotNull DumpHandler.DumpHandlerParameters dumpParameters) {
        if (out == null) {
            DatabaseViewHandler.$$$reportNull$$$0(18);
        }
        if (dumpParameters == null) {
            DatabaseViewHandler.$$$reportNull$$$0(19);
        }
        if (owner == null) {
            DatabaseViewHandler.$$$reportNull$$$0(20);
        }
        @NotNull @NotNull Function cache2 = ObjectNormalizerProvider.getCache();
        DataRequest.Constraints constraints = DataRequest.newConstraints(0, -1, 0, dumpParameters.subQueryIndex, dumpParameters.resultSetIndex, Integer.MAX_VALUE);
        return new DumpRequest((DataRequest.Owner)owner, dumpParameters.queryText, constraints, dumpParameters.selectedColumns, extractor, Objects.requireNonNull(out), name2, this.myConfig, size -> this.myRowsCount += size.intValue()){};
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extractor";
                break;
            }
            case 12: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 13: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dumpParameters";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dump/DatabaseViewHandler";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dump/DatabaseViewHandler";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "newEngineRunner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getName";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createExtractorConfig";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getSubQueryIndex";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getResultSetIndex";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedColumns";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "run";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "newEngineRunner";
                break;
            }
            case 17: {
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createDumpRequest";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 17 -> new IllegalStateException(string);
        };
    }
}

