/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.docker.cli;

import com.intellij.database.cli.CliRunTarget;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.ex.FileChooserDialogImpl;
import com.intellij.openapi.fileChooser.ex.FileLookup;
import com.intellij.openapi.fileChooser.ex.LocalFsFinder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.Component;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0011B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0014J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/database/docker/cli/DockerFileChooserDialog;", "Lcom/intellij/openapi/fileChooser/ex/FileChooserDialogImpl;", "descriptor", "Lcom/intellij/openapi/fileChooser/FileChooserDescriptor;", "parent", "Ljava/awt/Component;", "project", "Lcom/intellij/openapi/project/Project;", "runTarget", "Lcom/intellij/database/cli/CliRunTarget;", "(Lcom/intellij/openapi/fileChooser/FileChooserDescriptor;Ljava/awt/Component;Lcom/intellij/openapi/project/Project;Lcom/intellij/database/cli/CliRunTarget;)V", "createFinder", "Lcom/intellij/openapi/fileChooser/ex/FileLookup$Finder;", "getPresentableUrl", "", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "DockerFsFinder", "intellij.database.docker"})
public final class DockerFileChooserDialog
extends FileChooserDialogImpl {
    @NotNull
    private final CliRunTarget runTarget;

    public DockerFileChooserDialog(@NotNull FileChooserDescriptor descriptor2, @NotNull Component parent2, @Nullable Project project, @NotNull CliRunTarget runTarget) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)parent2, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)runTarget, (String)"runTarget");
        super(descriptor2, parent2, project);
        this.runTarget = runTarget;
    }

    @NotNull
    protected FileLookup.Finder createFinder() {
        FileLookup.Finder finder;
        List list = this.myChooserDescriptor.getRoots();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getRoots(...)");
        VirtualFile root2 = (VirtualFile)CollectionsKt.firstOrNull((List)list);
        if (root2 != null) {
            finder = new DockerFsFinder(root2);
        } else {
            FileLookup.Finder finder2 = super.createFinder();
            finder = finder2;
            Intrinsics.checkNotNullExpressionValue((Object)finder2, (String)"createFinder(...)");
        }
        return finder;
    }

    @NotNull
    protected String getPresentableUrl(@NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        return this.runTarget.getPresentableUrl(virtualFile);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016J\u0010\u0010\n\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/database/docker/cli/DockerFileChooserDialog$DockerFsFinder;", "Lcom/intellij/openapi/fileChooser/ex/FileLookup$Finder;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/vfs/VirtualFile;)V", "find", "Lcom/intellij/openapi/fileChooser/ex/FileLookup$LookupFile;", "path", "", "getSeparator", "normalize", "intellij.database.docker"})
    @SourceDebugExtension(value={"SMAP\nDockerFileChooserDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerFileChooserDialog.kt\ncom/intellij/database/docker/cli/DockerFileChooserDialog$DockerFsFinder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,36:1\n1#2:37\n*E\n"})
    public static final class DockerFsFinder
    implements FileLookup.Finder {
        @NotNull
        private final VirtualFile root;

        public DockerFsFinder(@NotNull VirtualFile root2) {
            Intrinsics.checkNotNullParameter((Object)root2, (String)"root");
            this.root = root2;
        }

        @Nullable
        public FileLookup.LookupFile find(@NotNull String path) {
            LocalFsFinder.VfsFile vfsFile;
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            VirtualFile virtualFile = this.root.findFileByRelativePath(path);
            if (virtualFile != null) {
                VirtualFile p0 = virtualFile;
                boolean bl = false;
                vfsFile = new LocalFsFinder.VfsFile(p0);
            } else {
                vfsFile = null;
            }
            return (FileLookup.LookupFile)vfsFile;
        }

        @NotNull
        public String normalize(@NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return path;
        }

        @NotNull
        public String getSeparator() {
            return "/";
        }
    }
}

