/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.sybase;

import com.intellij.database.dialects.base.SqlObjectBuilderImpl;
import com.intellij.database.dialects.sybase.model.AseProcedure;
import com.intellij.database.dialects.sybase.model.AseRoutine;
import com.intellij.database.dialects.sybase.model.AseTrigger;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PsiObject;
import com.intellij.database.model.SqlObjectBuilder;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModRoutine;
import com.intellij.database.model.basic.BasicModTrigger;
import com.intellij.database.model.basic.BasicModView;
import com.intellij.database.model.properties.CompositeText;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.openapi.util.TextRange;
import com.intellij.sql.psi.SqlCreateProcedureStatement;
import com.intellij.sql.psi.SqlCreateTriggerStatement;
import com.intellij.sql.psi.SqlCreateViewStatement;
import com.intellij.sql.psi.SqlRoutineDefinition;
import com.intellij.sql.psi.SqlTableDefinition;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J \u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J$\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016\u00a8\u0006\u001b"}, d2={"Lcom/intellij/database/dialects/sybase/AseObjectBuilder;", "Lcom/intellij/database/dialects/base/SqlObjectBuilderImpl;", "()V", "assignName", "", "obj", "Lcom/intellij/database/model/basic/BasicModNamedElement;", "source", "Lcom/intellij/database/model/DasObject;", "context", "Lcom/intellij/database/model/SqlObjectBuilder$Context;", "build", "Lcom/intellij/database/model/basic/BasicModElement;", "buildRoutine", "Lcom/intellij/database/dialects/sybase/model/AseRoutine;", "buildTrigger", "Lcom/intellij/database/dialects/sybase/model/AseTrigger;", "buildViewSource", "Lcom/intellij/database/model/basic/BasicModView;", "getCompactDefinition", "Lcom/intellij/openapi/util/TextRange;", "path", "Lcom/intellij/database/util/ObjectPath;", "text", "Lcom/intellij/database/model/properties/CompositeText;", "def", "Lcom/intellij/database/model/PsiObject;", "intellij.database.dialects.sybase"})
public final class AseObjectBuilder
extends SqlObjectBuilderImpl {
    @Override
    public void build(@NotNull BasicModElement obj2, @NotNull DasObject source, @NotNull SqlObjectBuilder.Context context) {
        Intrinsics.checkNotNullParameter((Object)obj2, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        BasicModElement basicModElement = obj2;
        if (basicModElement instanceof AseTrigger) {
            this.buildTrigger((AseTrigger)obj2, source, context);
        } else if (basicModElement instanceof AseRoutine) {
            this.buildRoutine((AseRoutine)obj2, source, context);
        } else {
            super.build(obj2, source, context);
        }
    }

    @Override
    @Nullable
    public TextRange getCompactDefinition(@NotNull ObjectPath path, @NotNull CompositeText text2, @Nullable PsiObject def) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        ObjectKind objectKind = path.kind;
        return Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.VIEW) ? this.getViewQueryRange(def) : (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.ROUTINE) ? this.getRoutineBodyRange(def) : (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.TRIGGER) ? this.getTriggerBodyRange(def) : super.getCompactDefinition(path, text2, def)));
    }

    private final void buildRoutine(AseRoutine obj2, DasObject source, SqlObjectBuilder.Context context) {
        Intrinsics.checkNotNull((Object)obj2, (String)"null cannot be cast to non-null type com.intellij.database.model.basic.BasicModRoutine");
        this.buildRoutine((BasicModRoutine)obj2, source, context);
        if (obj2 instanceof AseProcedure) {
            ((AseProcedure)obj2).setPosition(ObjectPaths.getSybaseNumber(source));
        }
        this.assignSources(obj2, context, (Function0<? extends CompositeText>)((Function0)new Function0<CompositeText>(source, this){
            final /* synthetic */ DasObject $source;
            final /* synthetic */ AseObjectBuilder this$0;
            {
                this.$source = $source;
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final CompositeText invoke() {
                Object object = this.$source;
                SqlCreateProcedureStatement sqlCreateProcedureStatement = object instanceof SqlCreateProcedureStatement ? (SqlCreateProcedureStatement)object : null;
                return sqlCreateProcedureStatement != null && (object = this.this$0.wholeStatement((SqlRoutineDefinition)sqlCreateProcedureStatement)) != null ? SqlObjectBuilderImpl.asComposite$default(this.this$0, (String)object, null, 1, null) : null;
            }
        }));
    }

    private final void buildTrigger(AseTrigger obj2, DasObject source, SqlObjectBuilder.Context context) {
        Intrinsics.checkNotNull((Object)obj2, (String)"null cannot be cast to non-null type com.intellij.database.model.basic.BasicModTrigger");
        this.buildTrigger((BasicModTrigger)obj2, source, context);
        this.assignSources(obj2, context, (Function0<? extends CompositeText>)((Function0)new Function0<CompositeText>(source, this){
            final /* synthetic */ DasObject $source;
            final /* synthetic */ AseObjectBuilder this$0;
            {
                this.$source = $source;
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final CompositeText invoke() {
                Object object = this.$source;
                SqlCreateTriggerStatement sqlCreateTriggerStatement = object instanceof SqlCreateTriggerStatement ? (SqlCreateTriggerStatement)object : null;
                return sqlCreateTriggerStatement != null && (object = sqlCreateTriggerStatement.getText()) != null ? SqlObjectBuilderImpl.asComposite$default(this.this$0, (String)object, null, 1, null) : null;
            }
        }));
    }

    @Override
    protected void buildViewSource(@NotNull BasicModView obj2, @NotNull DasObject source, @NotNull SqlObjectBuilder.Context context) {
        Intrinsics.checkNotNullParameter((Object)obj2, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.assignSources(obj2, context, (Function0<? extends CompositeText>)((Function0)new Function0<CompositeText>(source, this){
            final /* synthetic */ DasObject $source;
            final /* synthetic */ AseObjectBuilder this$0;
            {
                this.$source = $source;
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final CompositeText invoke() {
                Object object = this.$source;
                SqlCreateViewStatement sqlCreateViewStatement = object instanceof SqlCreateViewStatement ? (SqlCreateViewStatement)object : null;
                return sqlCreateViewStatement != null && (object = this.this$0.wholeStatement((SqlTableDefinition)sqlCreateViewStatement)) != null ? SqlObjectBuilderImpl.asComposite$default(this.this$0, (String)object, null, 1, null) : null;
            }
        }));
    }

    @Override
    protected void assignName(@NotNull BasicModNamedElement obj2, @NotNull DasObject source, @NotNull SqlObjectBuilder.Context context) {
        Intrinsics.checkNotNullParameter((Object)obj2, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (obj2 instanceof AseProcedure) {
            ((AseProcedure)obj2).setName("");
        } else {
            super.assignName(obj2, source, context);
        }
    }
}

