/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.sqlite.generator.producers;

import com.intellij.database.dialects.base.generator.AbstractScriptGeneratorKt;
import com.intellij.database.dialects.base.generator.ScriptingContext;
import com.intellij.database.dialects.base.generator.producers.CreateLikeColumn;
import com.intellij.database.dialects.sqlite.generator.SqliteScriptGeneratorHelperKt;
import com.intellij.database.dialects.sqlite.model.SqliteCollation;
import com.intellij.database.dialects.sqlite.model.SqliteTable;
import com.intellij.database.dialects.sqlite.model.SqliteTableColumn;
import com.intellij.database.dialects.sqlite.model.properties.SqliteOnConflictAlgorithm;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.basic.BasicKey;
import com.intellij.database.model.basic.BasicLikeColumn;
import com.intellij.database.model.basic.BasicModTableColumn;
import com.intellij.database.model.meta.BasicMetaId;
import com.intellij.database.model.properties.BasicReferenceInfo;
import com.intellij.database.model.properties.ColumnKind;
import com.intellij.database.script.generator.ScriptingCapabilities;
import com.intellij.database.types.DasType;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0014J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0014\u00a8\u0006\u0010"}, d2={"Lcom/intellij/database/dialects/sqlite/generator/producers/SqliteCreateTableColumn;", "Lcom/intellij/database/dialects/base/generator/producers/CreateLikeColumn;", "Lcom/intellij/database/dialects/sqlite/model/SqliteTableColumn;", "context", "Lcom/intellij/database/dialects/base/generator/ScriptingContext;", "element", "(Lcom/intellij/database/dialects/base/generator/ScriptingContext;Lcom/intellij/database/dialects/sqlite/model/SqliteTableColumn;)V", "canComment", "Lcom/intellij/database/script/generator/ScriptingCapabilities$VersionedCapability;", "", "canCreateWith", "prop", "Lcom/intellij/database/model/meta/BasicMetaId;", "makeColumnSpecification", "", "makeNormalColumnSpecification", "intellij.database.dialects.sqlite"})
@SourceDebugExtension(value={"SMAP\nSqliteTableColumnProducers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqliteTableColumnProducers.kt\ncom/intellij/database/dialects/sqlite/generator/producers/SqliteCreateTableColumn\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,65:1\n1#2:66\n*E\n"})
public final class SqliteCreateTableColumn
extends CreateLikeColumn<SqliteTableColumn> {
    public SqliteCreateTableColumn(@NotNull ScriptingContext context, @NotNull SqliteTableColumn element2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        super(context, (BasicLikeColumn)element2);
    }

    @Override
    @NotNull
    protected ScriptingCapabilities.VersionedCapability<Boolean> canComment() {
        return AbstractScriptGeneratorKt.getUNSUPPORTED();
    }

    @Override
    @NotNull
    public ScriptingCapabilities.VersionedCapability<Boolean> canCreateWith(@NotNull BasicMetaId prop) {
        Intrinsics.checkNotNullParameter((Object)prop, (String)"prop");
        return Intrinsics.areEqual((Object)prop, BasicModTableColumn.SEQUENCE_IDENTITY) ? AbstractScriptGeneratorKt.getSUPPORTED() : super.canCreateWith(prop);
    }

    @Override
    @NotNull
    public String makeColumnSpecification() {
        return this.makeNormalColumnSpecification();
    }

    @Override
    @NotNull
    protected String makeNormalColumnSpecification() {
        boolean isGenerated = ((SqliteTableColumn)this.getElement()).getColumnKind() != ColumnKind.NORMAL;
        Object specification = null;
        DasType dasType = ((SqliteTableColumn)this.getElement()).getDasType();
        Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"getDasType(...)");
        specification = this.script(dasType);
        if (isGenerated) {
            String string = ((SqliteTableColumn)this.getElement()).getDefaultExpression();
            if (string == null) {
                string = "";
            }
            specification = specification + " generated always as (" + string + ") " + (((SqliteTableColumn)this.getElement()).getColumnKind() == ColumnKind.GENERATED_VIRTUAL ? "virtual" : "stored");
        }
        BasicReferenceInfo<? extends SqliteCollation> basicReferenceInfo = ((SqliteTableColumn)this.getElement()).getCollationRefInfo();
        if (basicReferenceInfo != null) {
            BasicReferenceInfo<? extends SqliteCollation> it2 = basicReferenceInfo;
            boolean bl = false;
            specification = specification + " collate " + this.extractName(it2);
        }
        if (!isGenerated && ((SqliteTableColumn)this.getElement()).getDefaultExpression() != null) {
            specification = specification + " default " + ((SqliteTableColumn)this.getElement()).getDefaultExpression();
        }
        if (((SqliteTableColumn)this.getElement()).isNotNull()) {
            specification = specification + " not null";
        }
        if (((SqliteTableColumn)this.getElement()).isAutoInc()) {
            SqliteTable sqliteTable = ((SqliteTableColumn)this.getElement()).getTable();
            BasicKey it3 = sqliteTable != null ? ModelFun.findKey(sqliteTable, CollectionsKt.listOf((Object)((SqliteTableColumn)this.getElement()).getName())) : null;
            boolean bl = false;
            boolean bl2 = it3 == null || !it3.isPrimary();
            if (bl2) {
                specification = specification + " /*autoincrement needs PK*/";
            }
        }
        SqliteOnConflictAlgorithm onNullConflict = ((SqliteTableColumn)this.getElement()).getOnNullConflict();
        if (!((SqliteTableColumn)this.getElement()).isNotNull() && (onNullConflict != null || this.getContext().getHelper().isNullExplicit(null))) {
            specification = specification + " null";
        }
        if (onNullConflict != null) {
            specification = specification + " " + SqliteScriptGeneratorHelperKt.generateOnConflict(onNullConflict);
        }
        return ((Object)StringsKt.trim((CharSequence)((CharSequence)specification))).toString();
    }
}

