/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.redis.generator;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.base.generator.AbstractNamingService;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.script.generator.NamingService;
import com.intellij.database.util.Casing;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0013B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J4\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\b\u0010\f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0010\u001a\u00020\u000eH\u0016J\u001a\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\b\u0010\f\u001a\u0004\u0018\u00010\u0007H\u0002J\u001a\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\n2\b\u0010\f\u001a\u0004\u0018\u00010\u0007H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u0010\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/database/dialects/redis/generator/RedisNamingService;", "Lcom/intellij/database/dialects/base/generator/AbstractNamingService;", "()V", "escapableCharacters", "", "", "keyObjectKinds", "Lcom/intellij/database/model/ObjectKind;", "kotlin.jvm.PlatformType", "catToScript", "", "catName", "kind", "plain", "", "openingQuotes", "forceQuoting", "escape", "isEscapable", "Provider", "intellij.database.dialects.redis"})
@SourceDebugExtension(value={"SMAP\nRedisNamingService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RedisNamingService.kt\ncom/intellij/database/dialects/redis/generator/RedisNamingService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,36:1\n1#2:37\n842#3:38\n882#3,5:39\n*S KotlinDebug\n*F\n+ 1 RedisNamingService.kt\ncom/intellij/database/dialects/redis/generator/RedisNamingService\n*L\n33#1:38\n33#1:39,5\n*E\n"})
public final class RedisNamingService
extends AbstractNamingService {
    @NotNull
    public static final RedisNamingService INSTANCE = new RedisNamingService();
    @NotNull
    private static final List<Character> escapableCharacters;
    @NotNull
    private static final List<ObjectKind> keyObjectKinds;

    private RedisNamingService() {
        Dbms dbms = Dbms.REDIS;
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"REDIS");
        Pattern pattern2 = Pattern.compile("[^\\s']+");
        Intrinsics.checkNotNullExpressionValue((Object)pattern2, (String)"compile(...)");
        Casing casing = CasingProvider.EXACT_CASING;
        Intrinsics.checkNotNullExpressionValue((Object)casing, (String)"EXACT_CASING");
        super(dbms, pattern2, casing);
    }

    @Override
    @NotNull
    public String catToScript(@NotNull String catName, @Nullable ObjectKind kind, boolean plain, @Nullable String openingQuotes, boolean forceQuoting) {
        Intrinsics.checkNotNullParameter((Object)catName, (String)"catName");
        return super.catToScript(this.escape(catName, kind), kind, plain, openingQuotes, forceQuoting);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isEscapable(String catName, ObjectKind kind) {
        char c2;
        block2: {
            if (kind == null) return false;
            if (!keyObjectKinds.contains(kind)) return false;
            CharSequence charSequence = catName;
            int n = 0;
            while (n < charSequence.length()) {
                char it2 = c2 = charSequence.charAt(n);
                boolean bl = false;
                if (!escapableCharacters.contains(Character.valueOf(it2))) {
                    ++n;
                    continue;
                }
                break block2;
            }
            return false;
        }
        Character c3 = Character.valueOf(c2);
        if (c3 == null) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final String escape(String catName, ObjectKind kind) {
        void $this$flatMapTo$iv$iv;
        if (!this.isEscapable(catName, kind)) {
            return catName;
        }
        CharSequence $this$flatMap$iv = catName;
        boolean $i$f$flatMap = false;
        CharSequence charSequence = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (int j = 0; j < $this$flatMapTo$iv$iv.length(); ++j) {
            List list;
            char element$iv$iv;
            char it2 = element$iv$iv = $this$flatMapTo$iv$iv.charAt(j);
            boolean bl = false;
            if (escapableCharacters.contains(Character.valueOf(it2))) {
                Object[] objectArray = new Character[]{Character.valueOf('\\'), Character.valueOf(it2)};
                list = CollectionsKt.listOf((Object[])objectArray);
            } else {
                list = CollectionsKt.listOf((Object)Character.valueOf(it2));
            }
            Iterable list$iv$iv = list;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
    }

    static {
        Object[] objectArray = new Character[]{Character.valueOf('\"'), Character.valueOf('\\')};
        escapableCharacters = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new ObjectKind[]{ObjectKind.COLLECTION, ObjectKind.STRING, ObjectKind.LIST, ObjectKind.SET, ObjectKind.SORTED_SET, ObjectKind.HASH_TABLE, ObjectKind.STREAM, ObjectKind.JSON_DOCUMENT, ObjectKind.DATA_STRUCTURE};
        keyObjectKinds = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/database/dialects/redis/generator/RedisNamingService$Provider;", "Lcom/intellij/database/script/generator/NamingService$Provider;", "()V", "getNamingService", "Lcom/intellij/database/script/generator/NamingService;", "model", "Lcom/intellij/database/model/basic/BasicModel;", "database", "Lcom/intellij/database/model/basic/BasicDatabase;", "intellij.database.dialects.redis"})
    public static final class Provider
    implements NamingService.Provider {
        @Override
        @NotNull
        public NamingService getNamingService(@Nullable BasicModel model2, @Nullable BasicDatabase database) {
            return INSTANCE;
        }
    }
}

