/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.postgresbase.model;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.dialects.postgresbase.model.PgBaseForeignKey;
import com.intellij.database.dialects.postgresbase.model.PgBaseGeneratedModelUtil;
import com.intellij.database.dialects.postgresbase.model.PgBaseOperator;
import com.intellij.database.dialects.postgresbase.model.properties.PgObjectGrantController;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.ModelHelper;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicKey;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModForeignKey;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.meta.BasicMetaField;
import com.intellij.database.model.meta.BasicMetaId;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.meta.BasicMetaUtils;
import com.intellij.database.model.properties.references.BasicByColumnNamesReference;
import com.intellij.database.model.properties.references.BasicByColumnPositionsOrNamesReference;
import com.intellij.database.model.properties.references.BasicIdOrNameReference;
import com.intellij.database.model.properties.references.BasicNameReference;
import com.intellij.database.model.serialization.ModelSerializationFun;
import com.intellij.database.util.Version;
import com.intellij.openapi.util.Pair;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001e\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J4\u0010\u0018\u001a\u00020\b\"\b\b\u0000\u0010\u0019*\u00020\u00152\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00190\u001b2\u0012\u0010\u001c\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00190\u001e0\u001dH\u0016J\u000e\u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020!J\u0016\u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#J\u0018\u0010$\u001a\u00020\b2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006%"}, d2={"Lcom/intellij/database/dialects/postgresbase/model/PgBaseModelHelper;", "Lcom/intellij/database/model/ModelHelper;", "()V", "sequenceTypeSince", "Lcom/intellij/database/util/Version;", "getSequenceTypeSince", "()Lcom/intellij/database/util/Version;", "fillPropertiesWithExamples", "", "e", "Lcom/intellij/database/model/basic/BasicModElement;", "variant", "Lcom/intellij/database/model/ModelHelper$ObjectKindVariant;", "vars", "", "", "modifyParent", "", "getDocumentationLink", "Lcom/intellij/openapi/util/Pair;", "element", "Lcom/intellij/database/model/basic/BasicElement;", "getGrantController", "Lcom/intellij/database/dialects/postgresbase/model/properties/PgObjectGrantController;", "reorderProperties", "E", "meta", "Lcom/intellij/database/model/meta/BasicMetaObject;", "fields", "", "Lcom/intellij/database/model/meta/BasicMetaField;", "resolveReference", "key", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseForeignKey;", "refTable", "Lcom/intellij/database/model/basic/BasicTable;", "updateRefNames", "intellij.database.dialects.postgresbase"})
@SourceDebugExtension(value={"SMAP\nPgBaseModelHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PgBaseModelHelper.kt\ncom/intellij/database/dialects/postgresbase/model/PgBaseModelHelper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,108:1\n1#2:109\n*E\n"})
public abstract class PgBaseModelHelper
extends ModelHelper {
    public final void resolveReference(@NotNull PgBaseForeignKey key2) {
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        BasicTable refTable = key2.getRefTable();
        if (refTable == null) {
            return;
        }
        this.resolveReference(key2, refTable);
    }

    public final void resolveReference(@NotNull PgBaseForeignKey key2, @NotNull BasicTable refTable) {
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        Intrinsics.checkNotNullParameter((Object)refTable, (String)"refTable");
        this.updateRefNames(key2, refTable);
    }

    private final void updateRefNames(PgBaseForeignKey key2, BasicTable refTable) {
        key2.setRefTableRef(BasicIdOrNameReference.create(PgBaseGeneratedModelUtil.getIdReference(key2.getRefTableRef()), BasicMetaUtils.createPortableReference((BasicElement)key2, (BasicElement)refTable, BasicModForeignKey.REF_TABLE_REF)));
        BasicKey basicKey = key2.getRefKey();
        if (basicKey == null) {
            return;
        }
        BasicKey refKey = basicKey;
        key2.setRefKeyRef(BasicByColumnPositionsOrNamesReference.create(PgBaseGeneratedModelUtil.getByColumnPositionsReference(key2.getRefKeyRef()), BasicByColumnNamesReference.create(refKey.getColNames())));
    }

    @NotNull
    public abstract Version getSequenceTypeSince();

    @Override
    @Nullable
    public Pair<String, String> getDocumentationLink(@NotNull BasicElement element2) {
        ObjectKind objectKind;
        ObjectKind objectKind2;
        String string;
        Object object;
        BasicRoot root2;
        Object object2;
        Object object3;
        Object it2;
        Object object4;
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Object object5 = element2.getSchema();
        if (object5 == null || (object5 = object5.getName()) == null) {
            return null;
        }
        Object schemaName = object5;
        CasingProvider casingProvider = element2.getModel();
        if (casingProvider != null && (casingProvider = casingProvider.getRoot()) != null) {
            it2 = object4 = casingProvider;
            boolean bl = false;
            object3 = Intrinsics.areEqual((Object)it2.getDbms(), (Object)Dbms.POSTGRES) ? object4 : null;
        } else {
            object3 = null;
        }
        if ((object2 = (root2 = object3)) != null && (object2 = object2.getServerVersion()) != null) {
            it2 = object4 = object2;
            boolean bl = false;
            int[] nArray = new int[]{7, 1};
            object = ((Version)it2).isOrGreater(nArray) ? object4 : null;
        } else {
            object = null;
        }
        Version ver = object;
        if (ver == null) {
            string = "current";
        } else {
            object4 = new int[1];
            object4[0] = 10;
            if (ver.isOrGreater((int[])object4)) {
                String string2 = ver.toString(1, 1);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            } else {
                String string3 = ver.toString(2, 2);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
            }
        }
        String versionRef = string;
        String p2 = "https://www.postgresql.org/docs/" + versionRef + "/static";
        ObjectKind objectKind3 = element2.getKind();
        Intrinsics.checkNotNullExpressionValue((Object)objectKind3, (String)"getKind(...)");
        ObjectKind kind = objectKind3;
        String kindName = kind.getPresentableName();
        String string4 = element2.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getName(...)");
        String name2 = string4;
        if (ModelSerializationFun.startsWith(name2, '_')) {
            return null;
        }
        String name22 = StringsKt.replace$default((String)name2, (char)'_', (char)'-', (boolean)false, (int)4, null);
        Object object6 = schemaName;
        Object object7 = Intrinsics.areEqual((Object)object6, (Object)"pg_catalog") ? ((Intrinsics.areEqual((Object)(objectKind2 = kind), (Object)ObjectKind.TABLE) ? true : Intrinsics.areEqual((Object)objectKind2, (Object)ObjectKind.VIEW)) ? ModelHelper.link(kindName + " " + name2, p2 + "/catalog-" + name22 + ".html") : (Intrinsics.areEqual((Object)objectKind2, (Object)ObjectKind.SCHEMA) ? ModelHelper.link(DatabaseBundle.message("postgres.system.catalog.name", new Object[0]), p2 + "/catalogs.html") : null)) : (Intrinsics.areEqual((Object)object6, (Object)"information_schema") ? ((Intrinsics.areEqual((Object)(objectKind = kind), (Object)ObjectKind.TABLE) ? true : Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.VIEW)) ? ModelHelper.link(kindName + " " + name2, p2 + "/infoschema-" + name22 + ".html") : (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.SCHEMA) ? ModelHelper.link(DatabaseBundle.message("postgres.information.schema.name", new Object[0]), p2 + "/information-schema.html") : null)) : null);
        return object7;
    }

    @NotNull
    public PgObjectGrantController getGrantController() {
        return PgObjectGrantController.INSTANCE;
    }

    @Override
    public void fillPropertiesWithExamples(@NotNull BasicModElement e2, @NotNull ModelHelper.ObjectKindVariant variant, @NotNull Map<String, String> vars, boolean modifyParent) {
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        Intrinsics.checkNotNullParameter(vars, (String)"vars");
        super.fillPropertiesWithExamples(e2, variant, vars, modifyParent);
        if (e2 instanceof PgBaseOperator) {
            ((PgBaseOperator)e2).setCallRoutineRef(BasicNameReference.create("operator_routine"));
            vars.put("operator_routine", "operator_routine");
        }
    }

    @Override
    public <E extends BasicElement> void reorderProperties(@NotNull BasicMetaObject<E> meta, @NotNull List<BasicMetaField<E>> fields) {
        Intrinsics.checkNotNullParameter(meta, (String)"meta");
        Intrinsics.checkNotNullParameter(fields, (String)"fields");
        super.reorderProperties(meta, fields);
        if (meta.kindOf(PgBaseOperator.class)) {
            BasicMetaId[] basicMetaIdArray = new BasicMetaId[]{PgBaseOperator.CALL_ROUTINE_REF, PgBaseOperator.OPERATOR_KIND, PgBaseOperator.LEFT_TYPE, PgBaseOperator.RIGHT_TYPE, PgBaseOperator.RESTRICT_ROUTINE_REF, PgBaseOperator.JOIN_ROUTINE_REF, PgBaseOperator.COMMUTE_OPERATOR_REF, PgBaseOperator.NEGATE_OPERATOR_REF, PgBaseOperator.HASHES};
            ModelHelper.moveTo(fields, 2, basicMetaIdArray);
        }
    }
}

