/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.postgresbase;

import com.intellij.database.dialects.base.SqlObjectBuilderImpl;
import com.intellij.database.dialects.postgresbase.model.PgBaseLikeDatabase;
import com.intellij.database.dialects.postgresbase.model.PgBaseObjectWithOwner;
import com.intellij.database.dialects.postgresbase.model.PgBaseOperator;
import com.intellij.database.dialects.postgresbase.model.PgBaseRoutine;
import com.intellij.database.dialects.postgresbase.model.properties.PgOperatorKind;
import com.intellij.database.dialects.postgresbase.model.properties.PgRoutineKind;
import com.intellij.database.dialects.postgresbase.model.properties.PgVolatilityKind;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasOperator;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PsiObject;
import com.intellij.database.model.SqlObjectBuilder;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModRoutine;
import com.intellij.database.model.basic.BasicModSourceAware;
import com.intellij.database.model.basic.BasicModView;
import com.intellij.database.model.properties.CompositeText;
import com.intellij.database.model.properties.references.BasicNameReference;
import com.intellij.database.script.SimpleCompositeText;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeSystemBase;
import com.intellij.database.util.ObjectPath;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.sql.dialects.postgres.PgElementTypes;
import com.intellij.sql.dialects.postgres.PgTypes;
import com.intellij.sql.psi.SqlAlterStatement;
import com.intellij.sql.psi.SqlClause;
import com.intellij.sql.psi.SqlCompositeElementType;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlCreateCatalogStatement;
import com.intellij.sql.psi.SqlCreateProcedureStatement;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlElementTypes;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlStringLiteralExpression;
import com.intellij.sql.psi.SqlTokenType;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlReferenceExpressionImpl;
import com.intellij.sql.psi.impl.SqlStringLiteralExpressionImpl;
import com.intellij.sql.psi.stubs.SqlDefinitionStub;
import com.intellij.sql.psi.stubs.SqlNamedElementStub;
import com.intellij.sql.psi.stubs.SqlNamedStubElementType;
import com.intellij.sql.psi.stubs.SqlStubbedElement;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.text.StringKt;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J \u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0004J \u0010\u0011\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u0013\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0018\u0010\u0015\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\u0016\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J \u0010\u0018\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00192\u0006\u0010\r\u001a\u00020\u000eH\u0014J \u0010\u001a\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u001b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0019\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\b\u0010\u000b\u001a\u0004\u0018\u00010\u001eH\u0004\u00a2\u0006\u0002\u0010\u001fJB\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!2\b\u0010\u000b\u001a\u0004\u0018\u00010\u001e2\u0014\u0010#\u001a\u0010\u0012\u0004\u0012\u00020\u001e\u0012\u0006\u0012\u0004\u0018\u00010\u001e0$2\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\"0$H\u0004J\u0014\u0010&\u001a\u0004\u0018\u00010\"2\b\u0010\u000b\u001a\u0004\u0018\u00010\u001eH\u0004J$\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\b\u0010-\u001a\u0004\u0018\u00010.H\u0016J\u0010\u0010/\u001a\u0002002\u0006\u00101\u001a\u000202H\u0002J\u0014\u00103\u001a\u0004\u0018\u00010\"2\b\u0010\u000b\u001a\u0004\u0018\u000104H\u0002J\u0014\u00105\u001a\u0004\u0018\u00010\"2\b\u0010\u000b\u001a\u0004\u0018\u000104H\u0002J\u0012\u00106\u001a\u0004\u0018\u00010\"2\u0006\u0010\u000b\u001a\u000204H\u0014J\u0018\u00107\u001a\u00020\b2\u0006\u0010\t\u001a\u0002082\u0006\u0010\u000b\u001a\u000209H\u0002R\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006:"}, d2={"Lcom/intellij/database/dialects/postgresbase/PgBaseObjectBuilder;", "Lcom/intellij/database/dialects/base/SqlObjectBuilderImpl;", "()V", "lazyCodeBlock", "Lcom/intellij/psi/tree/IElementType;", "getLazyCodeBlock", "()Lcom/intellij/psi/tree/IElementType;", "build", "", "obj", "Lcom/intellij/database/model/basic/BasicModElement;", "source", "Lcom/intellij/database/model/DasObject;", "context", "Lcom/intellij/database/model/SqlObjectBuilder$Context;", "buildDatabase", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseLikeDatabase;", "buildOperator", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseOperator;", "buildRoutine", "Lcom/intellij/database/model/basic/BasicModRoutine;", "buildRoutineKind", "buildRoutineSources", "Lcom/intellij/database/model/basic/BasicModSourceAware;", "buildStatement", "Lcom/intellij/sql/psi/SqlElement;", "buildViewSource", "Lcom/intellij/database/model/basic/BasicModView;", "findNumberInSiblings", "", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/psi/PsiElement;)Ljava/lang/Float;", "findOptions", "", "", "nextElement", "Lkotlin/Function1;", "optionFormatter", "findSchemaInSiblings", "getCompactDefinition", "Lcom/intellij/openapi/util/TextRange;", "path", "Lcom/intellij/database/util/ObjectPath;", "text", "Lcom/intellij/database/model/properties/CompositeText;", "def", "Lcom/intellij/database/model/PsiObject;", "getPgOperatorKind", "Lcom/intellij/database/dialects/postgresbase/model/properties/PgOperatorKind;", "n", "Lcom/intellij/database/model/DasOperator$OperatorNotation;", "getRoutineArgumentsDefinition", "Lcom/intellij/sql/psi/SqlCreateProcedureStatement;", "getRoutineResultDefinition", "getRoutineSourceText", "retrieveOwner", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseObjectWithOwner;", "Lcom/intellij/sql/psi/SqlAlterStatement;", "intellij.database.dialects.postgresbase"})
@SourceDebugExtension(value={"SMAP\nPgBaseObjectBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PgBaseObjectBuilder.kt\ncom/intellij/database/dialects/postgresbase/PgBaseObjectBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 SqlObjectBuilderImpl.kt\ncom/intellij/database/dialects/base/SqlObjectBuilderImpl\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,232:1\n1855#2:233\n1855#2,2:234\n1856#2:236\n624#3,5:237\n613#3,10:242\n636#3:252\n624#3,5:253\n613#3,10:258\n659#3,6:269\n643#3:275\n659#3,6:276\n647#3:282\n659#3,6:283\n624#3,5:289\n647#3:294\n659#3,6:295\n643#3:301\n659#3,6:302\n1#4:268\n14#5:308\n*S KotlinDebug\n*F\n+ 1 PgBaseObjectBuilder.kt\ncom/intellij/database/dialects/postgresbase/PgBaseObjectBuilder\n*L\n65#1:233\n68#1:234,2\n65#1:236\n96#1:237,5\n102#1:242,10\n119#1:252\n119#1:253,5\n120#1:258,10\n167#1:269,6\n192#1:275\n192#1:276,6\n193#1:282\n193#1:283,6\n206#1:289,5\n218#1:294\n218#1:295,6\n220#1:301\n220#1:302,6\n223#1:308\n*E\n"})
public abstract class PgBaseObjectBuilder
extends SqlObjectBuilderImpl {
    @Nullable
    protected abstract IElementType getLazyCodeBlock();

    @Override
    public void build(@NotNull BasicModElement obj2, @NotNull DasObject source, @NotNull SqlObjectBuilder.Context context) {
        Intrinsics.checkNotNullParameter((Object)obj2, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        BasicModElement basicModElement = obj2;
        if (basicModElement instanceof PgBaseOperator) {
            this.buildOperator((PgBaseOperator)obj2, source, context);
        } else if (basicModElement instanceof PgBaseLikeDatabase) {
            this.buildDatabase((PgBaseLikeDatabase)obj2, source, context);
        } else {
            super.build(obj2, source, context);
        }
    }

    @Override
    protected void buildStatement(@NotNull BasicModElement obj2, @NotNull SqlElement source, @NotNull SqlObjectBuilder.Context context) {
        Intrinsics.checkNotNullParameter((Object)obj2, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (obj2 instanceof PgBaseObjectWithOwner && source instanceof SqlAlterStatement) {
            this.retrieveOwner((PgBaseObjectWithOwner)obj2, (SqlAlterStatement)source);
        }
        super.buildStatement(obj2, source, context);
    }

    @Override
    @Nullable
    public TextRange getCompactDefinition(@NotNull ObjectPath path, @NotNull CompositeText text2, @Nullable PsiObject def) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        return Intrinsics.areEqual((Object)path.kind, (Object)ObjectKind.RULE) ? this.getTriggerBodyRange(def) : super.getCompactDefinition(path, text2, def);
    }

    private final void retrieveOwner(PgBaseObjectWithOwner obj2, SqlAlterStatement source) {
        String ownerName = null;
        boolean faceless = false;
        JBIterable<? extends PsiElement> jBIterable = SqlImplUtil.childrenIt((PsiElement)source);
        Intrinsics.checkNotNullExpressionValue(jBIterable, (String)"childrenIt(...)");
        Iterable $this$forEach$iv = (Iterable)jBIterable;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PsiElement it2 = (PsiElement)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)it2), (Object)((Object)SqlElementTypes.SQL_ALTER_INSTRUCTION))) continue;
            JBIterable<? extends PsiElement> jBIterable2 = SqlImplUtil.childrenIt(it2);
            Intrinsics.checkNotNullExpressionValue(jBIterable2, (String)"childrenIt(...)");
            Iterable $this$forEach$iv2 = (Iterable)jBIterable2;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                PsiElement ownerPsi;
                PsiElement psiElement;
                StubElement stub;
                PsiElement alterChild = (PsiElement)element$iv2;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)alterChild), (Object)((Object)SqlElementTypes.SQL_OWNER_TO_CLAUSE))) continue;
                SqlStubbedElement sqlStubbedElement = alterChild instanceof SqlStubbedElement ? (SqlStubbedElement)alterChild : null;
                Object object = stub = sqlStubbedElement != null ? sqlStubbedElement.getStub() : null;
                if (stub != null) {
                    SqlReferenceExpression sqlReferenceExpression;
                    SqlNamedElementStub sqlNamedElementStub = stub instanceof SqlNamedElementStub ? (SqlNamedElementStub)stub : null;
                    if (sqlNamedElementStub != null) {
                        IStubElementType iStubElementType = ((SqlNamedElementStub)stub).getStubType();
                        Intrinsics.checkNotNull((Object)iStubElementType, (String)"null cannot be cast to non-null type com.intellij.sql.psi.stubs.SqlNamedStubElementType<@[FlexibleNullability] com.intellij.psi.stubs.StubElement<*>?, @[FlexibleNullability] com.intellij.psi.PsiElement?>");
                        sqlReferenceExpression = sqlNamedElementStub.getNameReference(((SqlNamedStubElementType)iStubElementType).getTargetReferenceType());
                    } else {
                        sqlReferenceExpression = null;
                    }
                    psiElement = (PsiElement)sqlReferenceExpression;
                } else {
                    IElementType iElementType = PgTypes.PG_TO;
                    Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"PG_TO");
                    PsiElement to = this.findChild(alterChild, iElementType);
                    SqlReferenceElementType sqlReferenceElementType = SqlElementTypes.SQL_USER_REFERENCE;
                    Intrinsics.checkNotNullExpressionValue((Object)sqlReferenceElementType, (String)"SQL_USER_REFERENCE");
                    psiElement = this.findSibling(to, (IElementType)sqlReferenceElementType);
                    if (psiElement == null) {
                        IElementType iElementType2 = PgTypes.PG_SESSION_USER;
                        Intrinsics.checkNotNullExpressionValue((Object)iElementType2, (String)"PG_SESSION_USER");
                        psiElement = this.findSibling(to, iElementType2);
                        if (psiElement == null) {
                            IElementType iElementType3 = PgTypes.PG_CURRENT_USER;
                            Intrinsics.checkNotNullExpressionValue((Object)iElementType3, (String)"PG_CURRENT_USER");
                            psiElement = this.findSibling(to, iElementType3);
                        }
                    }
                }
                PsiElement psiElement2 = ownerPsi = psiElement;
                ownerName = psiElement2 != null ? this.extractName(psiElement2) : null;
                faceless = ownerPsi != null && !(ownerPsi instanceof SqlReferenceExpression);
            }
        }
        if (ownerName != null) {
            obj2.setOwnerRef(BasicNameReference.create(ownerName, faceless));
        }
    }

    /*
     * WARNING - void declaration
     */
    protected final void buildDatabase(@NotNull PgBaseLikeDatabase obj2, @NotNull DasObject source, @NotNull SqlObjectBuilder.Context context) {
        PgBaseLikeDatabase stubbed;
        StubElement stubElement;
        BasicElement basicElement;
        Intrinsics.checkNotNullParameter((Object)obj2, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super.buildNamespace(obj2, source, context);
        SqlObjectBuilderImpl sqlObjectBuilderImpl = this;
        Object $this$stubbed$iv = source;
        boolean $i$f$stubbed = false;
        DasObject dasObject = $this$stubbed$iv;
        if (dasObject instanceof PgBaseLikeDatabase) {
            basicElement = (BasicElement)$this$stubbed$iv;
        } else if (dasObject instanceof SqlStubbedElement) {
            stubElement = ((SqlStubbedElement)((Object)$this$stubbed$iv)).getGreenStub();
            SqlDefinitionStub sqlDefinitionStub = stubElement instanceof SqlDefinitionStub ? (SqlDefinitionStub)stubElement : null;
            BasicElement basicElement2 = sqlDefinitionStub != null ? sqlDefinitionStub.getElement() : null;
            if (!(basicElement2 instanceof PgBaseLikeDatabase)) {
                basicElement2 = null;
            }
            basicElement = (PgBaseLikeDatabase)basicElement2;
        } else {
            basicElement = null;
        }
        if ((stubbed = (PgBaseLikeDatabase)basicElement) != null) {
            obj2.setOwnerRef(stubbed.getOwnerRef());
        } else {
            void this_$iv;
            String ownerName = null;
            $this$stubbed$iv = this;
            PsiElement el$iv = (PsiElement)(source instanceof SqlCreateCatalogStatement ? (SqlCreateCatalogStatement)source : null);
            boolean $i$f$forEachChild = false;
            stubElement = this_$iv;
            PsiElement psiElement = el$iv;
            PsiElement first$iv$iv = psiElement != null ? psiElement.getFirstChild() : null;
            boolean $i$f$forEachSibling = false;
            for (PsiElement tmp$iv$iv = first$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                PsiElement it2 = tmp$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)it2), (Object)PgTypes.PG_OWNER)) continue;
                SqlReferenceElementType sqlReferenceElementType = SqlElementTypes.SQL_USER_REFERENCE;
                Intrinsics.checkNotNullExpressionValue((Object)sqlReferenceElementType, (String)"SQL_USER_REFERENCE");
                PsiElement psiElement2 = this.findSibling(it2, (IElementType)sqlReferenceElementType);
                ownerName = psiElement2 != null ? this.extractName(psiElement2) : null;
            }
            obj2.setOwnerRef(BasicNameReference.create(ownerName));
        }
    }

    @Override
    protected void buildViewSource(@NotNull BasicModView obj2, @NotNull DasObject source, @NotNull SqlObjectBuilder.Context context) {
        Intrinsics.checkNotNullParameter((Object)obj2, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.assignSources(obj2, context, (Function0<? extends CompositeText>)((Function0)new Function0<CompositeText>(this, source){
            final /* synthetic */ PgBaseObjectBuilder this$0;
            final /* synthetic */ DasObject $source;
            {
                this.this$0 = $receiver;
                this.$source = $source;
                super(0);
            }

            @Nullable
            public final CompositeText invoke() {
                return PgBaseObjectBuilder.access$getViewQuery$s541696910(this.this$0, this.$source, CompositeText.Kind.DECOMPILED_TEXT);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void buildRoutine(@NotNull BasicModRoutine obj2, @NotNull DasObject source, @NotNull SqlObjectBuilder.Context context) {
        BasicElement basicElement;
        void $this$stubbedOrBuild$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)obj2, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        PgBaseRoutine cfr_ignored_0 = (PgBaseRoutine)obj2;
        SqlObjectBuilderImpl sqlObjectBuilderImpl = this;
        DasObject dasObject = source;
        BasicElement tgt$iv = obj2;
        boolean $i$f$stubbedOrBuild = false;
        BasicElement basicElement2 = this_$iv;
        void $this$stubbed$iv$iv = $this$stubbedOrBuild$iv;
        boolean $i$f$stubbed = false;
        void var12_11 = $this$stubbed$iv$iv;
        if (var12_11 instanceof PgBaseRoutine) {
            basicElement = (BasicElement)$this$stubbed$iv$iv;
        } else if (var12_11 instanceof SqlStubbedElement) {
            StubElement stubElement = ((SqlStubbedElement)$this$stubbed$iv$iv).getGreenStub();
            SqlDefinitionStub sqlDefinitionStub = stubElement instanceof SqlDefinitionStub ? (SqlDefinitionStub)stubElement : null;
            BasicElement basicElement3 = sqlDefinitionStub != null ? sqlDefinitionStub.getElement() : null;
            if (!(basicElement3 instanceof PgBaseRoutine)) {
                basicElement3 = null;
            }
            basicElement = (PgBaseRoutine)basicElement3;
        } else {
            basicElement = null;
        }
        BasicElement basicElement4 = basicElement;
        if (basicElement == null) {
            boolean bl;
            void this_$iv2;
            Object obj3 = tgt$iv.getMetaObject().newDataObject();
            if (obj3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.database.dialects.postgresbase.model.PgBaseRoutine");
            }
            basicElement2 = (PgBaseRoutine)obj3;
            PgBaseRoutine $this$buildRoutine_u24lambda_u245 = (PgBaseRoutine)basicElement2;
            boolean bl2 = false;
            SqlObjectBuilderImpl sqlObjectBuilderImpl2 = this;
            PsiElement el$iv = (PsiElement)(source instanceof SqlCreateProcedureStatement ? (SqlCreateProcedureStatement)source : null);
            boolean $i$f$forEachChild2 = false;
            void var19_19 = this_$iv2;
            PsiElement psiElement = el$iv;
            PsiElement first$iv$iv = psiElement != null ? psiElement.getFirstChild() : null;
            boolean $i$f$forEachSibling = false;
            for (PsiElement tmp$iv$iv = first$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                IElementType iElementType;
                PsiElement s2;
                PsiElement it2 = tmp$iv$iv;
                boolean bl3 = false;
                PsiElement psiElement2 = s2 = it2.getFirstChild();
                Object object = iElementType = psiElement2 != null ? PsiTreeUtilKt.getElementType((PsiElement)psiElement2) : null;
                if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_IMMUTABLE)) {
                    $this$buildRoutine_u24lambda_u245.setVolatilityKind(PgVolatilityKind.IMMUTABLE);
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_STABLE)) {
                    $this$buildRoutine_u24lambda_u245.setVolatilityKind(PgVolatilityKind.STABLE);
                    continue;
                }
                if (!Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_VOLATILE)) continue;
                $this$buildRoutine_u24lambda_u245.setVolatilityKind(PgVolatilityKind.VOLATILE);
            }
            $this$buildRoutine_u24lambda_u245.setArgumentsDefinition(this.getRoutineArgumentsDefinition(source instanceof SqlCreateProcedureStatement ? (SqlCreateProcedureStatement)source : null));
            $this$buildRoutine_u24lambda_u245.setResultsDefinition(this.getRoutineResultDefinition(source instanceof SqlCreateProcedureStatement ? (SqlCreateProcedureStatement)source : null));
            PgBaseRoutine pgBaseRoutine = $this$buildRoutine_u24lambda_u245;
            String string = $this$buildRoutine_u24lambda_u245.getResultsDefinition();
            if (string != null) {
                void $this$buildRoutine_u24lambda_u245_u24lambda_u244;
                String $i$f$forEachChild2 = string;
                PgBaseRoutine pgBaseRoutine2 = pgBaseRoutine;
                boolean bl4 = false;
                Intrinsics.checkNotNull((Object)$this$buildRoutine_u24lambda_u245_u24lambda_u244);
                pgBaseRoutine = pgBaseRoutine2;
                bl = Boolean.valueOf(StringsKt.contains((CharSequence)((CharSequence)$this$buildRoutine_u24lambda_u245_u24lambda_u244), (CharSequence)"setof ", (boolean)true) || StringsKt.startsWith((String)$this$buildRoutine_u24lambda_u245_u24lambda_u244, (String)"table", (boolean)true)).booleanValue();
            } else {
                bl = false;
            }
            pgBaseRoutine.setReturnsSet(bl);
            basicElement4 = basicElement2;
        }
        PgBaseRoutine stubbed = (PgBaseRoutine)basicElement4;
        ((PgBaseRoutine)obj2).setArgumentsDefinition(stubbed.getArgumentsDefinition());
        ((PgBaseRoutine)obj2).setResultsDefinition(stubbed.getResultsDefinition());
        ((PgBaseRoutine)obj2).setVolatilityKind(stubbed.getVolatilityKind());
        ((PgBaseRoutine)obj2).setReturnsSet(stubbed.isReturnsSet());
        super.buildRoutine(obj2, source, context);
    }

    @Override
    public void buildRoutineKind(@NotNull BasicModRoutine obj2, @NotNull DasObject source) {
        PgRoutineKind pgRoutineKind;
        Intrinsics.checkNotNullParameter((Object)obj2, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        DasRoutine.Kind rk = this.extractRoutineKind(source);
        PgBaseRoutine pgBaseRoutine = (PgBaseRoutine)obj2;
        String string = ((PgBaseRoutine)obj2).getResultsDefinition();
        boolean bl = string != null ? StringsKt.equals((String)string, (String)"trigger", (boolean)true) : false;
        if (bl) {
            pgRoutineKind = PgRoutineKind.PG_TRIGGER;
        } else {
            String string2 = ((PgBaseRoutine)obj2).getResultsDefinition();
            pgRoutineKind = (string2 != null ? StringsKt.equals((String)string2, (String)"event_trigger", (boolean)true) : false) ? PgRoutineKind.PG_EVENT_TRIGGER : (rk == DasRoutine.Kind.PROCEDURE ? PgRoutineKind.PG_PROCEDURE : PgRoutineKind.PG_FUNCTION);
        }
        pgBaseRoutine.setPgRoutineKind(pgRoutineKind);
    }

    @Nullable
    protected final String findSchemaInSiblings(@Nullable PsiElement source) {
        SqlReferenceElementType sqlReferenceElementType = SqlCompositeElementTypes.SQL_SCHEMA_REFERENCE;
        Intrinsics.checkNotNullExpressionValue((Object)sqlReferenceElementType, (String)"SQL_SCHEMA_REFERENCE");
        PsiElement psiElement = this.findSibling(source, (IElementType)sqlReferenceElementType);
        SqlReferenceExpressionImpl sqlReferenceExpressionImpl = psiElement instanceof SqlReferenceExpressionImpl ? (SqlReferenceExpressionImpl)psiElement : null;
        return sqlReferenceExpressionImpl != null ? sqlReferenceExpressionImpl.getName() : null;
    }

    @Nullable
    protected final Float findNumberInSiblings(@Nullable PsiElement source) {
        SqlCompositeElementType sqlCompositeElementType = SqlCompositeElementTypes.SQL_NUMERIC_LITERAL;
        Intrinsics.checkNotNullExpressionValue((Object)sqlCompositeElementType, (String)"SQL_NUMERIC_LITERAL");
        PsiElement num = this.findSibling(source, (IElementType)sqlCompositeElementType);
        Object object = num;
        return object != null && (object = object.getText()) != null ? StringsKt.toFloatOrNull((String)object) : null;
    }

    @NotNull
    protected final List<String> findOptions(@Nullable PsiElement source, @NotNull Function1<? super PsiElement, ? extends PsiElement> nextElement, @NotNull Function1<? super String, String> optionFormatter) {
        PsiElement leftParen;
        Intrinsics.checkNotNullParameter(nextElement, (String)"nextElement");
        Intrinsics.checkNotNullParameter(optionFormatter, (String)"optionFormatter");
        List result2 = new ArrayList();
        SqlTokenType sqlTokenType = SqlElementTypes.SQL_LEFT_PAREN;
        Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType, (String)"SQL_LEFT_PAREN");
        PsiElement psiElement = this.findSibling(source, (IElementType)sqlTokenType);
        if (psiElement == null) {
            return result2;
        }
        PsiElement current = leftParen = psiElement;
        while (true) {
            PsiElement psiElement2;
            block6: {
                PsiElement literal;
                PsiElement option;
                PsiElement psiElement3 = current;
                if ((psiElement3 != null ? PsiTreeUtilKt.getElementType((PsiElement)psiElement3) : null) == null || Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)current), (Object)SqlElementTypes.SQL_RIGHT_PAREN)) break;
                if ((PsiElement)nextElement.invoke((Object)current) == null) {
                    return result2;
                }
                PsiElement psiElement4 = option.getNextSibling();
                SqlCompositeElementType sqlCompositeElementType = SqlElementTypes.SQL_STRING_LITERAL;
                Intrinsics.checkNotNullExpressionValue((Object)sqlCompositeElementType, (String)"SQL_STRING_LITERAL");
                if (this.findSibling(psiElement4, (IElementType)sqlCompositeElementType) == null) {
                    return result2;
                }
                String literalValue = ((SqlStringLiteralExpressionImpl)literal).getValue();
                if (literalValue != null) {
                    result2.add(option.getText() + "=" + optionFormatter.invoke((Object)literalValue));
                }
                SqlObjectBuilderImpl this_$iv = this;
                boolean $i$f$findSibling = false;
                for (PsiElement tmp$iv = literal; tmp$iv != null; tmp$iv = tmp$iv.getNextSibling()) {
                    PsiElement it2 = tmp$iv;
                    boolean bl = false;
                    if (!(!Intrinsics.areEqual((Object)it2, (Object)literal) && !Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)it2), (Object)SqlElementTypes.WHITE_SPACE))) continue;
                    psiElement2 = tmp$iv;
                    break block6;
                }
                psiElement2 = null;
            }
            current = psiElement2;
        }
        return result2;
    }

    @Override
    protected void buildRoutineSources(@NotNull BasicModSourceAware obj2, @NotNull DasObject source, @NotNull SqlObjectBuilder.Context context) {
        Intrinsics.checkNotNullParameter((Object)obj2, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.assignSources(obj2, context, (Function0<? extends CompositeText>)((Function0)new Function0<CompositeText>(source, this){
            final /* synthetic */ DasObject $source;
            final /* synthetic */ PgBaseObjectBuilder this$0;
            {
                this.$source = $source;
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * Enabled aggressive block sorting
             */
            @Nullable
            public final CompositeText invoke() {
                SimpleCompositeText simpleCompositeText;
                SqlCreateProcedureStatement sqlCreateProcedureStatement;
                Object object = this.$source;
                SqlCreateProcedureStatement sqlCreateProcedureStatement2 = sqlCreateProcedureStatement = object instanceof SqlCreateProcedureStatement ? (SqlCreateProcedureStatement)object : null;
                if (sqlCreateProcedureStatement != null) {
                    SqlCreateProcedureStatement sqlCreateProcedureStatement3 = sqlCreateProcedureStatement;
                    PgBaseObjectBuilder pgBaseObjectBuilder = this.this$0;
                    SqlCreateProcedureStatement it2 = sqlCreateProcedureStatement3;
                    boolean bl = false;
                    object = pgBaseObjectBuilder.getRoutineSourceText(it2);
                    if (object != null) {
                        simpleCompositeText = SqlObjectBuilderImpl.asComposite$default(this.this$0, (String)object, null, 1, null);
                        return simpleCompositeText;
                    }
                }
                simpleCompositeText = null;
                return simpleCompositeText;
            }
        }));
    }

    private final String getRoutineArgumentsDefinition(SqlCreateProcedureStatement source) {
        PsiElement rParen;
        PsiElement lParen;
        PsiElement params2;
        block5: {
            block4: {
                PsiElement psiElement = (PsiElement)source;
                IElementType iElementType = PgTypes.PG_PARAMETER_LIST;
                Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"PG_PARAMETER_LIST");
                PsiElement psiElement2 = this.findChild(psiElement, iElementType);
                if (psiElement2 == null) {
                    return null;
                }
                params2 = psiElement2;
                lParen = params2.getFirstChild();
                rParen = params2.getLastChild();
                PsiElement psiElement3 = lParen;
                if (!Intrinsics.areEqual((Object)(psiElement3 != null ? PsiTreeUtilKt.getElementType((PsiElement)psiElement3) : null), (Object)PgTypes.PG_LEFT_PAREN)) break block4;
                PsiElement psiElement4 = rParen;
                if (Intrinsics.areEqual((Object)(psiElement4 != null ? PsiTreeUtilKt.getElementType((PsiElement)psiElement4) : null), (Object)PgTypes.PG_RIGHT_PAREN)) break block5;
            }
            return null;
        }
        String string = params2.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String string2 = string;
        int n = lParen.getStartOffsetInParent() + lParen.getTextLength();
        int n3 = rParen.getStartOffsetInParent();
        String string3 = string2.substring(n, n3);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        return StringKt.nullize$default((String)((Object)StringsKt.trim((CharSequence)string3)).toString(), (boolean)false, (int)1, null);
    }

    private final String getRoutineResultDefinition(SqlCreateProcedureStatement source) {
        PsiElement returns;
        PsiElement psiElement = (PsiElement)source;
        IElementType iElementType = PgTypes.PG_RETURNS_CLAUSE;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"PG_RETURNS_CLAUSE");
        PsiElement psiElement2 = this.findChild(psiElement, iElementType);
        if (psiElement2 == null) {
            return null;
        }
        PsiElement params2 = psiElement2;
        PsiElement psiElement3 = returns = params2.getFirstChild();
        if (!Intrinsics.areEqual((Object)(psiElement3 != null ? PsiTreeUtilKt.getElementType((PsiElement)psiElement3) : null), (Object)PgTypes.PG_RETURNS)) {
            return null;
        }
        String string = params2.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String string2 = string;
        int n = returns.getStartOffsetInParent() + returns.getTextLength();
        String string3 = string2.substring(n);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        return StringKt.nullize$default((String)((Object)StringsKt.trim((CharSequence)string3)).toString(), (boolean)false, (int)1, null);
    }

    @Nullable
    protected String getRoutineSourceText(@NotNull SqlCreateProcedureStatement source) {
        String string;
        IElementType iElementType;
        PsiElement code;
        PsiElement psiElement;
        block8: {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            PsiElement psiElement2 = (PsiElement)source;
            IElementType iElementType2 = PgElementTypes.Misc.PG_LAZY_CODE_BLOCK_PARENT;
            Intrinsics.checkNotNullExpressionValue((Object)iElementType2, (String)"PG_LAZY_CODE_BLOCK_PARENT");
            PsiElement psiElement3 = this.findChild(psiElement2, iElementType2);
            if (psiElement3 == null) {
                PsiElement psiElement4;
                block7: {
                    SqlObjectBuilderImpl this_$iv = this;
                    boolean $i$f$findChild2 = false;
                    SqlObjectBuilderImpl sqlObjectBuilderImpl = this_$iv;
                    PsiElement element$iv$iv = ((PsiElement)source).getFirstChild();
                    boolean $i$f$findSibling = false;
                    for (PsiElement tmp$iv$iv = element$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                        PsiElement it$iv = tmp$iv$iv;
                        boolean bl = false;
                        if (!(it$iv instanceof SqlStringLiteralExpression)) continue;
                        psiElement4 = tmp$iv$iv;
                        break block7;
                    }
                    psiElement4 = null;
                }
                SqlStringLiteralExpression sqlStringLiteralExpression = (SqlStringLiteralExpression)psiElement4;
                return sqlStringLiteralExpression != null ? sqlStringLiteralExpression.getValue() : null;
            }
            PsiElement block = psiElement3;
            SqlObjectBuilderImpl this_$iv = this;
            boolean $i$f$findChild = false;
            SqlObjectBuilderImpl $i$f$findChild2 = this_$iv;
            PsiElement element$iv$iv = block.getFirstChild();
            boolean $i$f$findSibling = false;
            for (PsiElement tmp$iv$iv = element$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                PsiElement it2 = tmp$iv$iv;
                boolean bl = false;
                IElementType type = PsiTreeUtilKt.getElementType((PsiElement)it2);
                if (!(Intrinsics.areEqual((Object)type, (Object)this.getLazyCodeBlock()) || Intrinsics.areEqual((Object)type, (Object)SqlElementTypes.SQL_STRING_LITERAL))) continue;
                psiElement = tmp$iv$iv;
                break block8;
            }
            psiElement = null;
        }
        PsiElement psiElement5 = code = psiElement;
        Object object = iElementType = psiElement5 != null ? PsiTreeUtilKt.getElementType(psiElement5) : null;
        if (Intrinsics.areEqual((Object)iElementType, (Object)this.getLazyCodeBlock())) {
            PsiElement psiElement6 = code;
            string = psiElement6 != null ? psiElement6.getText() : null;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)SqlElementTypes.SQL_STRING_LITERAL)) {
            Intrinsics.checkNotNull((Object)code, (String)"null cannot be cast to non-null type com.intellij.sql.psi.SqlStringLiteralExpression");
            string = ((SqlStringLiteralExpression)code).getValue();
        } else {
            string = null;
        }
        return string;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final void buildOperator(PgBaseOperator obj, DasObject source, SqlObjectBuilder.Context context) {
        block20: {
            block18: {
                block17: {
                    block19: {
                        this.buildBasicElement(obj, source, context);
                        var5_4 = this;
                        $this$stubbed$iv = source;
                        $i$f$stubbed = false;
                        var8_9 = $this$stubbed$iv;
                        if (var8_9 instanceof PgBaseOperator) {
                            v0 = (BasicElement)$this$stubbed$iv;
                        } else if (var8_9 instanceof SqlStubbedElement) {
                            var9_11 = ((SqlStubbedElement)$this$stubbed$iv).getGreenStub();
                            v1 = var9_11 instanceof SqlDefinitionStub != false ? (SqlDefinitionStub)var9_11 : null;
                            v2 = v1 != null ? v1.getElement() : null;
                            if (!(v2 instanceof PgBaseOperator)) {
                                v2 = null;
                            }
                            v0 = (PgBaseOperator)v2;
                        } else {
                            v0 = null;
                        }
                        if ((stubbed = (PgBaseOperator)v0) == null) break block19;
                        obj.setLeftType(stubbed.getLeftType());
                        obj.setRightType(stubbed.getRightType());
                        obj.setOperatorKind(stubbed.getOperatorKind());
                        obj.setCallRoutineRef(stubbed.getCallRoutineRef());
                        break block20;
                    }
                    op = source instanceof DasOperator != false ? (DasOperator)source : null;
                    v3 = op;
                    if (v3 == null || (v3 = v3.getArgumentTypes()) == null || (v3 = (DasType)CollectionsKt.getOrNull((List)v3, (int)0)) == null) {
                        v3 = DasTypeSystemBase.UNKNOWN;
                    }
                    obj.setLeftType((DasType)v3);
                    v4 = op;
                    if (v4 == null || (v4 = v4.getArgumentTypes()) == null || (v4 = (DasType)CollectionsKt.getOrNull((List)v4, (int)1)) == null) {
                        v4 = DasTypeSystemBase.UNKNOWN;
                    }
                    obj.setRightType((DasType)v4);
                    v5 /* !! */  = op;
                    if (v5 /* !! */  == null || (v5 /* !! */  = v5 /* !! */ .getOperatorNotation()) == null) {
                        v5 /* !! */  = DasOperator.OperatorNotation.INFIX;
                    }
                    var6_5 /* !! */  = v5 /* !! */ ;
                    Intrinsics.checkNotNull((Object)var6_5 /* !! */ );
                    obj.setOperatorKind(this.getPgOperatorKind((DasOperator.OperatorNotation)var6_5 /* !! */ ));
                    $i$f$stubbed = this;
                    var8_9 = source instanceof PsiElement != false ? (PsiElement)source : null;
                    var19_15 = obj;
                    $i$f$findChild = false;
                    var10_16 = this_$iv;
                    v6 = el$iv;
                    element$iv$iv = v6 != null ? v6.getFirstChild() : null;
                    $i$f$findSibling = false;
                    for (tmp$iv$iv /* !! */  = element$iv$iv; tmp$iv$iv /* !! */  != null; tmp$iv$iv /* !! */  = tmp$iv$iv /* !! */ .getNextSibling()) {
                        it = tmp$iv$iv /* !! */ ;
                        $i$a$-findChild-PgBaseObjectBuilder$buildOperator$1 = false;
                        if (!(it instanceof SqlClause)) ** GOTO lbl-1000
                        v7 = ((SqlClause)it).getFirstChild();
                        if (Intrinsics.areEqual((Object)(v7 != null ? PsiTreeUtilKt.getElementType((PsiElement)v7) : null), (Object)PgTypes.PG_PROCEDURE)) {
                            v8 = true;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v8 = false;
                        }
                        if (!v8) continue;
                        v9 = tmp$iv$iv /* !! */ ;
                        break block17;
                    }
                    v9 = null;
                }
                v10 = var19_15;
                var6_5 /* !! */  = v9;
                if (var6_5 /* !! */  == null) ** GOTO lbl-1000
                $i$f$findChild /* !! */  = var6_5 /* !! */ ;
                var19_15 = v10;
                $i$a$-let-PgBaseObjectBuilder$buildOperator$2 = false;
                this_$iv = this;
                $i$f$findChild = false;
                tmp$iv$iv /* !! */  = this_$iv;
                element$iv$iv = it.getFirstChild();
                $i$f$findSibling = false;
                for (tmp$iv$iv = element$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                    it$iv = tmp$iv$iv;
                    $i$a$-findSibling-SqlObjectBuilderImpl$findChild$2$iv = false;
                    if (!(it$iv instanceof SqlReferenceExpression)) continue;
                    v11 = tmp$iv$iv;
                    break block18;
                }
                v11 = null;
            }
            v10 = var19_15;
            this_$iv = (SqlReferenceExpression)v11;
            if (this_$iv != null) {
                it = this_$iv;
                var19_15 = v10;
                $i$a$-let-PgBaseObjectBuilder$buildOperator$3 = false;
                v12 = BasicNameReference.create(it.getName(), it.isPlainIdentifier());
                v10 = var19_15;
            } else lbl-1000:
            // 2 sources

            {
                v12 = null;
            }
            v10.setCallRoutineRef(v12);
        }
        if (!context.isStubBuilder()) {
            $this$asSafely$iv = source;
            $i$f$asSafely = false;
            v13 = $this$asSafely$iv;
            if (!(v13 instanceof DasOperator)) {
                v13 = null;
            }
            v14 = (DasOperator)v13;
            v15 = v14 != null ? v14.getResultType() : null;
            if (v15 == null) {
                v15 = DasTypeSystemBase.UNKNOWN;
            }
            obj.setResultType(v15);
        }
    }

    private final PgOperatorKind getPgOperatorKind(DasOperator.OperatorNotation n) {
        if (n == DasOperator.OperatorNotation.INFIX) {
            return PgOperatorKind.BINARY;
        }
        if (n == DasOperator.OperatorNotation.POSTFIX) {
            return PgOperatorKind.POSTFIX;
        }
        return n == DasOperator.OperatorNotation.PREFIX ? PgOperatorKind.PREFIX : PgOperatorKind.UNKNOWN;
    }

    public static final /* synthetic */ SimpleCompositeText access$getViewQuery$s541696910(PgBaseObjectBuilder $this, DasObject source, CompositeText.Kind kind) {
        return super.getViewQuery(source, kind);
    }
}

