/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.testing.utplsql;

import com.intellij.database.console.session.DatabaseSessionManager;
import com.intellij.database.dataSource.DataSourceSchemaMapping;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.InterruptibleDatabaseConnection;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.connection.DGDepartment;
import com.intellij.database.dataSource.connection.statements.CallableStatementData;
import com.intellij.database.dataSource.connection.statements.Configuration;
import com.intellij.database.dataSource.connection.statements.ExecutionMode;
import com.intellij.database.dataSource.connection.statements.SmartStatements;
import com.intellij.database.dataSource.connection.statements.StandardExecutionMode;
import com.intellij.database.dataSource.connection.statements.StandardResultsProcessors;
import com.intellij.database.dataSource.connection.statements.StatementParameters;
import com.intellij.database.dialects.base.OracleDbmsOutputHandler;
import com.intellij.database.dialects.base.generator.ScriptGeneratorHelperKt;
import com.intellij.database.dialects.oracle.testing.utplsql.UtPlSqlHandler;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.database.util.AsyncTask;
import com.intellij.database.util.AsyncUtil;
import com.intellij.database.util.TreePattern;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.testframework.sm.ServiceMessageBuilder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.JBTreeTraverser;
import java.io.Closeable;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import jetbrains.buildServer.messages.serviceMessages.ServiceMessage;
import jetbrains.buildServer.messages.serviceMessages.ServiceMessageParserCallback;
import jetbrains.buildServer.messages.serviceMessages.ServiceMessagesParser;
import jetbrains.buildServer.messages.serviceMessages.TestFailed;
import jetbrains.buildServer.messages.serviceMessages.TestIgnored;
import jetbrains.buildServer.messages.serviceMessages.TestStarted;
import jetbrains.buildServer.messages.serviceMessages.TestStdErr;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u00002\u00020\u0001:\u0001=B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\u0010\n\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\b0\u001cH\u0002J\u001e\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u001e2\u0006\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010 H\u0002J\b\u0010\"\u001a\u00020#H\u0014J\b\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020#H\u0014J4\u0010'\u001a\u00020#2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020 2\u0006\u0010+\u001a\u00020,2\u0012\u0010-\u001a\u000e\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u00020#0.H\u0002J\b\u00100\u001a\u00020\bH\u0002J\n\u00101\u001a\u0004\u0018\u000102H\u0016J\"\u00103\u001a\u00020#2\f\u00104\u001a\b\u0012\u0004\u0012\u00020#0\u001e2\n\u0010*\u001a\u0006\u0012\u0002\b\u00030\u001eH\u0002J\u0012\u00105\u001a\u0004\u0018\u00010\b2\u0006\u00106\u001a\u00020\bH\u0002J\u0010\u00107\u001a\u00020#2\u0006\u00106\u001a\u00020\bH\u0002J\u0016\u00108\u001a\u00020\b2\f\u00109\u001a\b\u0012\u0004\u0012\u00020 0\u001cH\u0002J\u0006\u0010:\u001a\u00020#J \u0010;\u001a\b\u0012\u0004\u0012\u00020#0\u001e2\u0006\u0010<\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010 H\u0002R\u0013\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006>"}, d2={"Lcom/intellij/database/dialects/oracle/testing/utplsql/UtPlSqlHandler;", "Lcom/intellij/execution/process/ProcessHandler;", "project", "Lcom/intellij/openapi/project/Project;", "ds", "Lcom/intellij/database/dataSource/LocalDataSource;", "paths", "", "", "tags", "coveragePath", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/database/dataSource/LocalDataSource;Ljava/util/List;Ljava/util/List;Ljava/lang/String;)V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getDs", "()Lcom/intellij/database/dataSource/LocalDataSource;", "expected", "Lkotlin/text/Regex;", "p", "Lcom/intellij/openapi/progress/EmptyProgressIndicator;", "getP", "()Lcom/intellij/openapi/progress/EmptyProgressIndicator;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getTags", "()Ljava/util/List;", "allSchemas", "", "attachReporter", "Lcom/intellij/database/util/AsyncTask;", "testsReporter", "Lcom/intellij/database/dialects/oracle/testing/utplsql/UtPlSqlHandler$Reporter;", "coverageReporter", "destroyProcessImpl", "", "detachIsDefault", "", "detachProcessImpl", "fetchReporter", "connection", "Lcom/intellij/database/dataSource/DatabaseConnection;", "reporter", "fetchSize", "", "consumer", "Lkotlin/Function1;", "Lcom/intellij/database/remote/jdbc/RemoteResultSet;", "genUuid", "getProcessInput", "Ljava/io/OutputStream;", "hookReporterTermination", "tests", "preprocessOutput", "input", "reportOutput", "runScript", "reporters", "start", "startTests", "testReporter", "Reporter", "intellij.database.dialects.oracle.ex"})
@SourceDebugExtension(value={"SMAP\nUtPlSqlHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UtPlSqlHandler.kt\ncom/intellij/database/dialects/oracle/testing/utplsql/UtPlSqlHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,229:1\n1#2:230\n*E\n"})
public final class UtPlSqlHandler
extends ProcessHandler {
    @NotNull
    private final Project project;
    @NotNull
    private final LocalDataSource ds;
    @NotNull
    private final List<String> paths;
    @NotNull
    private final List<String> tags;
    @Nullable
    private final String coveragePath;
    @NotNull
    private final Logger LOG;
    @NotNull
    private final EmptyProgressIndicator p;
    @NotNull
    private final Regex expected;

    public UtPlSqlHandler(@NotNull Project project, @NotNull LocalDataSource ds, @NotNull List<String> paths2, @NotNull List<String> tags2, @Nullable String coveragePath) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)ds, (String)"ds");
        Intrinsics.checkNotNullParameter(paths2, (String)"paths");
        Intrinsics.checkNotNullParameter(tags2, (String)"tags");
        this.project = project;
        this.ds = ds;
        this.paths = paths2;
        this.tags = tags2;
        this.coveragePath = coveragePath;
        Logger logger2 = Logger.getInstance(((Object)((Object)this)).getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        this.LOG = logger2;
        this.p = new EmptyProgressIndicator();
        this.expected = new Regex("Actual: (.*?)(?: \\(.*\\))? was expected to equal: (.*?)(?: \\(.*\\))?");
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final LocalDataSource getDs() {
        return this.ds;
    }

    @NotNull
    public final List<String> getTags() {
        return this.tags;
    }

    @NotNull
    public final EmptyProgressIndicator getP() {
        return this.p;
    }

    public final void start() {
        Reporter reporter;
        Reporter testReporter = new Reporter("tests_reporter", "ut_teamcity_reporter", this.genUuid());
        String string = this.coveragePath;
        if (string != null) {
            String it2 = string;
            boolean bl = false;
            reporter = new Reporter("coverage_reporter", "ut_coveralls_reporter", this.genUuid());
        } else {
            reporter = null;
        }
        Reporter coverageReporter = reporter;
        AsyncTask<Unit> tests = this.startTests(testReporter, coverageReporter);
        AsyncTask<?> reporter2 = this.attachReporter(testReporter, coverageReporter);
        this.startNotify();
        this.notifyTextAvailable(ServiceMessageBuilder.testsStarted().toString(), ProcessOutputTypes.STDOUT);
        this.hookReporterTermination(tests, reporter2);
    }

    private final String genUuid() {
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return StringsKt.replace$default((String)string, (String)"-", (String)"", (boolean)false, (int)4, null);
    }

    private final void hookReporterTermination(AsyncTask<Unit> tests, AsyncTask<?> reporter) {
        tests.whenComplete(null, (arg_0, arg_1) -> UtPlSqlHandler.hookReporterTermination$lambda$1((Function2)new Function2<Unit, Throwable, Unit>(reporter){
            final /* synthetic */ AsyncTask<?> $reporter;
            {
                this.$reporter = $reporter;
                super(2);
            }

            public final void invoke(@Nullable Unit unit, @Nullable Throwable e2) {
                if (e2 != null) {
                    this.$reporter.cancel();
                }
            }
        }, arg_0, arg_1));
        reporter.whenComplete(null, (arg_0, arg_1) -> UtPlSqlHandler.hookReporterTermination$lambda$2((Function2)new Function2<Object, Throwable, Unit>(this){
            final /* synthetic */ UtPlSqlHandler this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@Nullable Object object, @Nullable Throwable e2) {
                if (!this.this$0.isProcessTerminated()) {
                    if (e2 != null) {
                        if (!AsyncUtil.isCancellation(e2)) {
                            String string = e2.getMessage();
                            if (string == null) {
                                string = "";
                            }
                            this.this$0.notifyTextAvailable(string, ProcessOutputTypes.STDERR);
                        }
                        UtPlSqlHandler.access$notifyProcessTerminated(this.this$0, 1);
                    } else {
                        UtPlSqlHandler.access$notifyProcessTerminated(this.this$0, 0);
                    }
                }
            }
        }, arg_0, arg_1));
    }

    private final AsyncTask<?> attachReporter(Reporter testsReporter, Reporter coverageReporter) {
        return AsyncTask.Companion.currentFrame().computeAsync(UtPlSqlHandler::attachReporter$lambda$3, () -> UtPlSqlHandler.attachReporter$lambda$4(this, testsReporter, coverageReporter));
    }

    private final void fetchReporter(DatabaseConnection connection2, Reporter reporter, int fetchSize, Function1<? super RemoteResultSet, Unit> consumer2) {
        SmartStatements.Companion.poweredBy(connection2).call(new Configuration(false, null, null, fetchSize, null, null, 55, null)).noisy().execute(new StatementParameters().parameter(new CallableStatementData.SimpleOutParameter(1, -10, 0, null, null, 28, null)).asCallData(StringsKt.trimIndent((String)("\n        declare\n          l_reporter " + reporter.getType() + " := " + reporter.getType() + "();\n        begin\n          l_reporter.set_reporter_id('" + reporter.getUuid() + "');\n          ? := l_reporter.get_lines_cursor();\n        end;"))), (ExecutionMode)StandardExecutionMode.GENERIC, StandardResultsProcessors.firstResult((ThrowableConsumer<RemoteResultSet, Exception>)((ThrowableConsumer)arg_0 -> UtPlSqlHandler.fetchReporter$lambda$5(this, consumer2, arg_0))));
    }

    private final void reportOutput(String input) {
        block0: {
            String string = this.preprocessOutput(input);
            if (string == null) break block0;
            String it2 = string;
            boolean bl = false;
            this.notifyTextAvailable(it2 + "\n", ProcessOutputTypes.STDOUT);
        }
    }

    private final String preprocessOutput(String input) {
        Ref.ObjectRef result2 = new Ref.ObjectRef();
        new ServiceMessagesParser().parse(input, new ServiceMessageParserCallback(this, (Ref.ObjectRef<String>)result2){
            final /* synthetic */ UtPlSqlHandler this$0;
            final /* synthetic */ Ref.ObjectRef<String> $result;
            {
                this.this$0 = $receiver;
                this.$result = $result;
            }

            public void parseException(@NotNull ParseException parseException, @NotNull String text2) {
                Intrinsics.checkNotNullParameter((Object)parseException, (String)"parseException");
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                UtPlSqlHandler.access$getLOG$p(this.this$0).warn((Throwable)parseException);
                this.$result.element = text2;
            }

            /*
             * WARNING - void declaration
             */
            public void serviceMessage(@NotNull ServiceMessage message2) {
                Object object;
                String it2;
                Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
                Map map2 = message2.getAttributes();
                Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"getAttributes(...)");
                Map attrs = MapsKt.toMutableMap((Map)map2);
                String string = (String)attrs.get("name");
                if (string != null && (string = this.fixName(string)) != null) {
                    it2 = string;
                    boolean bl = false;
                    attrs.put("name", it2);
                }
                Ref.ObjectRef<String> objectRef = this.$result;
                ServiceMessage serviceMessage = message2;
                if (serviceMessage instanceof TestStarted) {
                    String testName = ((TestStarted)message2).getTestName();
                    if (((TestStarted)message2).getLocationHint() == null) {
                        String string2;
                        Map map3 = attrs;
                        it2 = "locationHint";
                        String string3 = testName;
                        if (string3 != null) {
                            void it3;
                            String string4 = string3;
                            Ref.ObjectRef<String> objectRef2 = objectRef;
                            boolean bl = false;
                            string2 = "db://" + (String)it3;
                            objectRef = objectRef2;
                        } else {
                            string2 = null;
                        }
                        String bl = string2;
                        map3.put(it2, bl);
                    }
                    object = ServiceMessage.asString((String)((TestStarted)message2).getMessageName(), (Map)attrs);
                } else if (serviceMessage instanceof TestStdErr) {
                    void it4;
                    String string5 = ((TestStdErr)message2).getStdErr();
                    Ref.ObjectRef<String> objectRef3 = objectRef;
                    boolean bl = false;
                    boolean bl2 = it4 == null || StringsKt.startsWith$default((String)it4, (String)"Test exception:", (boolean)false, (int)2, null);
                    objectRef = objectRef3;
                    object = bl2 ? null : ServiceMessage.asString((String)((TestStdErr)message2).getMessageName(), (Map)attrs);
                } else if (serviceMessage instanceof TestFailed) {
                    if (((TestFailed)message2).getFailureMessage() == null) {
                        String string6 = (String)attrs.remove("details");
                        if (string6 != null) {
                            MatchResult matchResult;
                            void details;
                            String string7 = string6;
                            UtPlSqlHandler utPlSqlHandler = this.this$0;
                            String bl = string7;
                            Ref.ObjectRef<String> objectRef4 = objectRef;
                            boolean bl3 = false;
                            attrs.put("message", details);
                            MatchResult matchResult2 = UtPlSqlHandler.access$getExpected$p(utPlSqlHandler).matchEntire((CharSequence)details);
                            if (matchResult2 != null) {
                                MatchResult matchResult3;
                                MatchResult $this$serviceMessage_u24lambda_u244_u24lambda_u243 = matchResult3 = matchResult2;
                                boolean bl4 = false;
                                Map map4 = attrs;
                                String string8 = "actual";
                                MatchGroup matchGroup = $this$serviceMessage_u24lambda_u244_u24lambda_u243.getGroups().get(1);
                                String string9 = matchGroup != null ? matchGroup.getValue() : null;
                                map4.put(string8, string9);
                                map4 = attrs;
                                string8 = "expected";
                                MatchGroup matchGroup2 = $this$serviceMessage_u24lambda_u244_u24lambda_u243.getGroups().get(2);
                                string9 = matchGroup2 != null ? matchGroup2.getValue() : null;
                                map4.put(string8, string9);
                                attrs.put("type", "comparisonFailure");
                                matchResult = matchResult3;
                            } else {
                                matchResult = null;
                            }
                            v11 = matchResult;
                            objectRef = objectRef4;
                        } else {
                            v11 = null;
                        }
                    }
                    object = ServiceMessage.asString((String)((TestFailed)message2).getMessageName(), (Map)attrs);
                } else {
                    object = serviceMessage instanceof TestIgnored ? ServiceMessage.asString((String)((TestIgnored)message2).getMessageName(), (Map)attrs) + "\n" + ServiceMessage.asString((String)"testFinished", (Map)attrs) : ServiceMessage.asString((String)message2.getMessageName(), (Map)attrs);
                }
                objectRef.element = object;
            }

            private final String fixName(String $this$fixName) {
                String string = $this$fixName;
                return string != null ? StringsKt.substringAfterLast$default((String)string, (char)'.', null, (int)2, null) : null;
            }

            public void regularText(@NotNull String text2) {
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                this.$result.element = text2;
            }
        });
        return (String)result2.element;
    }

    private final AsyncTask<Unit> startTests(Reporter testReporter, Reporter coverageReporter) {
        return DatabaseSessionManager.getFacade(this.project, this.ds, null, null, false, null, DGDepartment.TEST_RUNNER).runAsync((Function1)new Function1<InterruptibleDatabaseConnection, Unit>(this, testReporter, coverageReporter){
            final /* synthetic */ UtPlSqlHandler this$0;
            final /* synthetic */ Reporter $testReporter;
            final /* synthetic */ Reporter $coverageReporter;
            {
                this.this$0 = $receiver;
                this.$testReporter = $testReporter;
                this.$coverageReporter = $coverageReporter;
                super(1);
            }

            public final void invoke(@NotNull InterruptibleDatabaseConnection connection2) {
                Intrinsics.checkNotNullParameter((Object)connection2, (String)"connection");
                new OracleDbmsOutputHandler().enable(connection2, 10000000);
                Object[] objectArray = new Reporter[]{this.$testReporter, this.$coverageReporter};
                SmartStatements.Companion.poweredBy(connection2).simple().noisy().execute(UtPlSqlHandler.access$runScript(this.this$0, CollectionsKt.listOfNotNull((Object[])objectArray)), startTests.1.INSTANCE);
            }
        });
    }

    private final Iterable<String> allSchemas() {
        TreePattern sc2 = this.ds.getIntrospectionScope();
        boolean bl = false;
        JBTreeTraverser jBTreeTraverser = ((JBTreeTraverser)((JBTreeTraverser)this.ds.getModel().traverser().expand(arg_0 -> UtPlSqlHandler.allSchemas$lambda$10$lambda$7(allSchemas.1.1.INSTANCE, arg_0))).filter(arg_0 -> UtPlSqlHandler.allSchemas$lambda$10$lambda$8((Function1)new Function1<DasObject, Boolean>(sc2){
            final /* synthetic */ TreePattern $sc;
            {
                this.$sc = $sc;
                super(1);
            }

            @NotNull
            public final Boolean invoke(DasObject it2) {
                return Intrinsics.areEqual((Object)it2.getKind(), (Object)ObjectKind.SCHEMA) && DataSourceSchemaMapping.isIntrospected(this.$sc, it2);
            }
        }, arg_0))).map(arg_0 -> UtPlSqlHandler.allSchemas$lambda$10$lambda$9(allSchemas.1.3.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)jBTreeTraverser, (String)"let(...)");
        return (Iterable)jBTreeTraverser;
    }

    private final String runScript(Iterable<Reporter> reporters) {
        return "\n    declare" + CollectionsKt.joinToString$default(reporters, (CharSequence)"", null, null, (int)0, null, (Function1)runScript.1.INSTANCE, (int)30, null) + "\n    begin " + CollectionsKt.joinToString$default(reporters, (CharSequence)"", null, null, (int)0, null, (Function1)runScript.2.INSTANCE, (int)30, null) + "\n      ut_runner.run(\n        ut_varchar2_list (" + CollectionsKt.joinToString$default((Iterable)this.paths, null, null, null, (int)0, null, (Function1)runScript.3.INSTANCE, (int)31, null) + "),\n        ut_reporters(" + CollectionsKt.joinToString$default(reporters, null, null, null, (int)0, null, (Function1)runScript.4.INSTANCE, (int)31, null) + "),\n        false,\n        ut_varchar2_list(" + CollectionsKt.joinToString$default(this.allSchemas(), null, null, null, (int)0, null, (Function1)runScript.5.INSTANCE, (int)31, null) + "),\n        a_tags => " + (this.tags.isEmpty() ? "null" : ScriptGeneratorHelperKt.getSqlString(CollectionsKt.joinToString$default((Iterable)this.tags, (CharSequence)",", null, null, (int)0, null, (Function1)runScript.6.INSTANCE, (int)30, null))) + "\n      );\n    end;";
    }

    @Nullable
    public OutputStream getProcessInput() {
        return null;
    }

    public boolean detachIsDefault() {
        return false;
    }

    protected void detachProcessImpl() {
        this.notifyProcessDetached();
    }

    protected void destroyProcessImpl() {
        this.p.cancel();
    }

    private static final void hookReporterTermination$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    private static final void hookReporterTermination$lambda$2(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    private static final void attachReporter$lambda$3(Runnable it2) {
        AppExecutorUtil.getAppScheduledExecutorService().schedule(it2, 500L, TimeUnit.MILLISECONDS);
    }

    private static final AsyncTask attachReporter$lambda$4(UtPlSqlHandler this$0, Reporter $testsReporter, Reporter $coverageReporter) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$testsReporter, (String)"$testsReporter");
        return DatabaseSessionManager.getFacade(this$0.project, this$0.ds, null, null, false, null, DGDepartment.TEST_RUNNER).runAsync((Function1)new Function1<InterruptibleDatabaseConnection, Unit>(this$0, $testsReporter, $coverageReporter){
            final /* synthetic */ UtPlSqlHandler this$0;
            final /* synthetic */ Reporter $testsReporter;
            final /* synthetic */ Reporter $coverageReporter;
            {
                this.this$0 = $receiver;
                this.$testsReporter = $testsReporter;
                this.$coverageReporter = $coverageReporter;
                super(1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke(@NotNull InterruptibleDatabaseConnection connection2) {
                block8: {
                    Intrinsics.checkNotNullParameter((Object)connection2, (String)"connection");
                    try {
                        UtPlSqlHandler.access$fetchReporter(this.this$0, connection2, this.$testsReporter, 1, (Function1)new Function1<RemoteResultSet, Unit>(this.this$0){
                            final /* synthetic */ UtPlSqlHandler this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@NotNull RemoteResultSet rs) {
                                Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
                                String string = rs.getString(1);
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
                                UtPlSqlHandler.access$reportOutput(this.this$0, string);
                            }
                        });
                        if (this.$coverageReporter == null) break block8;
                        String string = UtPlSqlHandler.access$getCoveragePath$p(this.this$0);
                        Intrinsics.checkNotNull((Object)string);
                        Closeable closeable = new OutputStreamWriter((OutputStream)new FileOutputStream(string), StandardCharsets.UTF_8);
                        UtPlSqlHandler utPlSqlHandler = this.this$0;
                        Reporter reporter = this.$coverageReporter;
                        Throwable throwable = null;
                        try {
                            OutputStreamWriter writer = (OutputStreamWriter)closeable;
                            boolean bl = false;
                            UtPlSqlHandler.access$fetchReporter(utPlSqlHandler, connection2, reporter, 10000, (Function1)new Function1<RemoteResultSet, Unit>(writer){
                                final /* synthetic */ OutputStreamWriter $writer;
                                {
                                    this.$writer = $writer;
                                    super(1);
                                }

                                public final void invoke(@NotNull RemoteResultSet rs) {
                                    Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
                                    this.$writer.write(rs.getString(1));
                                }
                            });
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                        }
                    }
                    catch (Throwable th) {
                        UtPlSqlHandler.access$getLOG$p(this.this$0).warn(th);
                        String string = th.getMessage();
                        if (string == null) {
                            string = th.toString();
                        }
                        this.this$0.notifyTextAvailable(string, ProcessOutputTypes.STDERR);
                    }
                }
            }
        });
    }

    private static final void fetchReporter$lambda$5(UtPlSqlHandler this$0, Function1 $consumer, RemoteResultSet it2) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$consumer, (String)"$consumer");
        this$0.p.checkCanceled();
        Intrinsics.checkNotNull((Object)it2);
        $consumer.invoke((Object)it2);
    }

    private static final boolean allSchemas$lambda$10$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean allSchemas$lambda$10$lambda$8(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final String allSchemas$lambda$10$lambda$9(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$notifyProcessTerminated(UtPlSqlHandler $this, int p0) {
        $this.notifyProcessTerminated(p0);
    }

    public static final /* synthetic */ Logger access$getLOG$p(UtPlSqlHandler $this) {
        return $this.LOG;
    }

    public static final /* synthetic */ Regex access$getExpected$p(UtPlSqlHandler $this) {
        return $this.expected;
    }

    public static final /* synthetic */ String access$runScript(UtPlSqlHandler $this, Iterable reporters) {
        return $this.runScript(reporters);
    }

    public static final /* synthetic */ void access$fetchReporter(UtPlSqlHandler $this, DatabaseConnection connection2, Reporter reporter, int fetchSize, Function1 consumer2) {
        $this.fetchReporter(connection2, reporter, fetchSize, (Function1<? super RemoteResultSet, Unit>)consumer2);
    }

    public static final /* synthetic */ void access$reportOutput(UtPlSqlHandler $this, String input) {
        $this.reportOutput(input);
    }

    public static final /* synthetic */ String access$getCoveragePath$p(UtPlSqlHandler $this) {
        return $this.coveragePath;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0015"}, d2={"Lcom/intellij/database/dialects/oracle/testing/utplsql/UtPlSqlHandler$Reporter;", "", "name", "", "type", "uuid", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "getType", "getUuid", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.database.dialects.oracle.ex"})
    private static final class Reporter {
        @NotNull
        private final String name;
        @NotNull
        private final String type;
        @NotNull
        private final String uuid;

        public Reporter(@NotNull String name2, @NotNull String type, @NotNull String uuid) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
            this.name = name2;
            this.type = type;
            this.uuid = uuid;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final String getType() {
            return this.type;
        }

        @NotNull
        public final String getUuid() {
            return this.uuid;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final String component2() {
            return this.type;
        }

        @NotNull
        public final String component3() {
            return this.uuid;
        }

        @NotNull
        public final Reporter copy(@NotNull String name2, @NotNull String type, @NotNull String uuid) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
            return new Reporter(name2, type, uuid);
        }

        public static /* synthetic */ Reporter copy$default(Reporter reporter, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = reporter.name;
            }
            if ((n & 2) != 0) {
                string2 = reporter.type;
            }
            if ((n & 4) != 0) {
                string3 = reporter.uuid;
            }
            return reporter.copy(string, string2, string3);
        }

        @NotNull
        public String toString() {
            return "Reporter(name=" + this.name + ", type=" + this.type + ", uuid=" + this.uuid + ")";
        }

        public int hashCode() {
            int result2 = this.name.hashCode();
            result2 = result2 * 31 + this.type.hashCode();
            result2 = result2 * 31 + this.uuid.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Reporter)) {
                return false;
            }
            Reporter reporter = (Reporter)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)reporter.name)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.type, (Object)reporter.type)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.uuid, (Object)reporter.uuid);
        }
    }
}

