/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.model;

import com.intellij.database.dialects.oracle.model.OraCollectionTypeBase;
import com.intellij.database.dialects.oracle.model.OraPackageCollectionType;
import com.intellij.database.dialects.oracle.model.OraSchema;
import com.intellij.database.dialects.oracle.model.properties.OraCollectionTypeKind;
import com.intellij.database.dialects.oracle.types.OraAssociativeArrayType;
import com.intellij.database.dialects.oracle.types.OraNestedTableType;
import com.intellij.database.dialects.oracle.types.OraTypeSystem;
import com.intellij.database.dialects.oracle.types.OraVaryingArrayType;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTypeAwareObject;
import com.intellij.database.model.DasUserDefinedType;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.types.DasDefinedType;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeSystemBase;
import com.intellij.database.types.DasTypeUtilsKt;
import com.intellij.database.types.DasUnresolvedType;
import com.intellij.database.util.DasUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0018\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000e\u001a \u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\tH\u0002\u001a\u0018\u0010\u0011\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u00012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u001a,\u0010\u0011\u001a\u00020\u00012\b\u0010\u0010\u001a\u0004\u0018\u00010\t2\b\u0010\u0012\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0013\u001a\u00020\t2\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u001a(\u0010\u0014\u001a\u0004\u0018\u00010\u0005*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u001e\u0010\u0017\u001a\u0004\u0018\u00010\u0001*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u0018"}, d2={"createCollectionType", "Lcom/intellij/database/types/DasType;", "typeDef", "Lcom/intellij/database/dialects/oracle/model/OraCollectionTypeBase;", "getSchema", "Lcom/intellij/database/model/DasObject;", "model", "Lcom/intellij/database/model/basic/BasicModel;", "name", "", "resolveTypeDefinition", "Lcom/intellij/database/model/DasUserDefinedType;", "dasType", "context", "Lcom/intellij/database/model/basic/BasicElement;", "resolveTypeInSchema", "schemaName", "resolveTypeReference", "packageName", "typeName", "getChild", "kind", "Lcom/intellij/database/model/ObjectKind;", "getChildType", "intellij.database.dialects.oracle"})
@JvmName(name="OraModelUtils")
@SourceDebugExtension(value={"SMAP\nOraModelUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OraModelUtils.kt\ncom/intellij/database/dialects/oracle/model/OraModelUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,92:1\n288#2,2:93\n288#2,2:95\n1#3:97\n*S KotlinDebug\n*F\n+ 1 OraModelUtils.kt\ncom/intellij/database/dialects/oracle/model/OraModelUtils\n*L\n17#1:93,2\n19#1:95,2\n*E\n"})
public final class OraModelUtils {
    private static final DasObject getSchema(BasicModel model2, String name2) {
        Object v1;
        block1: {
            Collection<DasObject> collection2 = model2.getNameIndex().getObjectsByName(name2);
            Intrinsics.checkNotNullExpressionValue(collection2, (String)"getObjectsByName(...)");
            Iterable $this$firstOrNull$iv = collection2;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                DasObject it2 = (DasObject)element$iv;
                boolean bl = false;
                if (!(it2 instanceof OraSchema)) continue;
                v1 = element$iv;
                break block1;
            }
            v1 = null;
        }
        return v1;
    }

    private static final DasObject getChild(DasObject $this$getChild, BasicModel model2, ObjectKind kind, String name2) {
        Object v1;
        block1: {
            Collection<DasObject> collection2 = model2.getNameIndex().getObjectsByName(name2);
            Intrinsics.checkNotNullExpressionValue(collection2, (String)"getObjectsByName(...)");
            Iterable $this$firstOrNull$iv = collection2;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                DasObject it2 = (DasObject)element$iv;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)it2.getDasParent(), (Object)$this$getChild) && (kind == null || Intrinsics.areEqual((Object)kind, (Object)ObjectKind.NONE) || Intrinsics.areEqual((Object)kind, (Object)it2.getKind())))) continue;
                v1 = element$iv;
                break block1;
            }
            v1 = null;
        }
        return v1;
    }

    private static final DasType getChildType(DasObject $this$getChildType, BasicModel model2, String name2) {
        for (DasObject obj2 : model2.getNameIndex().getObjectsByNameInsensitive(name2)) {
            if (!Intrinsics.areEqual((Object)obj2.getDasParent(), (Object)$this$getChildType)) continue;
            if (obj2 instanceof DasUserDefinedType) {
                return ((DasUserDefinedType)obj2).getSelfDasType();
            }
            if (!(obj2 instanceof DasTypeAwareObject)) continue;
            return ((DasTypeAwareObject)((Object)obj2)).getDasType();
        }
        return null;
    }

    private static final DasType resolveTypeInSchema(BasicModel model2, String name2, String schemaName) {
        DasType dasType;
        DasObject dasObject = OraModelUtils.getSchema(model2, schemaName);
        if (dasObject != null && (dasType = OraModelUtils.getChildType(dasObject, model2, name2)) != null) {
            DasType it2 = dasType;
            boolean bl = false;
            return it2;
        }
        String expectedSchema = OraTypeSystem.extraPredefinedTypeSchemas.get(name2);
        DasType predefinedType = Intrinsics.areEqual((Object)expectedSchema, (Object)schemaName) ? OraTypeSystem.predefinedTypes.get(name2) : null;
        DasType dasType2 = predefinedType;
        if (dasType2 == null) {
            dasType2 = DasUnresolvedType.Companion.of(schemaName + "." + name2);
        }
        return dasType2;
    }

    @NotNull
    public static final DasType resolveTypeReference(@NotNull DasType dasType, @Nullable BasicElement context) {
        Intrinsics.checkNotNullParameter((Object)dasType, (String)"dasType");
        return OraModelUtils.resolveTypeReference(DasTypeUtilsKt.getSchemaName(dasType), DasTypeUtilsKt.getPackageName(dasType), DasTypeUtilsKt.getTypeName(dasType), context);
    }

    @Nullable
    public static final DasUserDefinedType resolveTypeDefinition(@NotNull DasType dasType, @NotNull BasicElement context) {
        Intrinsics.checkNotNullParameter((Object)dasType, (String)"dasType");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        DasType dasType2 = OraModelUtils.resolveTypeReference(dasType, context);
        Object object = dasType2 instanceof DasDefinedType ? (DasDefinedType)dasType2 : null;
        return object != null && (object = object.getTypeClass()) != null ? object.getDefinition() : null;
    }

    @NotNull
    public static final DasType resolveTypeReference(@Nullable String schemaName, @Nullable String packageName, @NotNull String typeName, @Nullable BasicElement context) {
        DasType predefinedType;
        Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
        String canonicalTypeName = StringUtil.toUpperCase((String)typeName);
        if ((schemaName == null || Intrinsics.areEqual((Object)"SYS", (Object)schemaName) && OraTypeSystem.predefinedSysTypeNames.contains(canonicalTypeName)) && (predefinedType = OraTypeSystem.predefinedTypes.get(canonicalTypeName)) != null) {
            return predefinedType;
        }
        Object object = context;
        if (object == null || (object = object.getModel()) == null) {
            return DasTypeSystemBase.UNKNOWN;
        }
        Object model2 = object;
        CharSequence charSequence = schemaName;
        if (!(charSequence == null || charSequence.length() == 0) && !((charSequence = (CharSequence)packageName) == null || charSequence.length() == 0)) {
            Object object2 = OraModelUtils.getSchema((BasicModel)model2, schemaName);
            if (object2 == null || (object2 = OraModelUtils.getChild((DasObject)object2, (BasicModel)model2, ObjectKind.PACKAGE, packageName)) == null || (object2 = OraModelUtils.getChildType((DasObject)object2, (BasicModel)model2, typeName)) == null) {
                object2 = DasUnresolvedType.Companion.of(schemaName + "." + packageName + "." + typeName);
            }
            return object2;
        }
        CharSequence charSequence2 = schemaName;
        String qualifierName = !(charSequence2 == null || charSequence2.length() == 0) ? schemaName : packageName;
        charSequence2 = qualifierName;
        if (!(charSequence2 == null || charSequence2.length() == 0)) {
            DasObject container;
            Object object3;
            DasObject schema2 = DasUtil.getParentOfKind(context, ObjectKind.SCHEMA, false);
            DasObject dasObject = schema2;
            if (dasObject == null || (dasObject = OraModelUtils.getChild(dasObject, (BasicModel)model2, ObjectKind.PACKAGE, qualifierName)) == null) {
                DasObject dasObject2 = schema2;
                dasObject = dasObject2 != null ? OraModelUtils.getChild(dasObject2, (BasicModel)model2, ObjectKind.OBJECT_TYPE, qualifierName) : null;
            }
            if ((object3 = (container = dasObject)) == null || (object3 = OraModelUtils.getChildType((DasObject)object3, (BasicModel)model2, typeName)) == null) {
                object3 = OraModelUtils.resolveTypeInSchema((BasicModel)model2, typeName, qualifierName);
            }
            return object3;
        }
        Object object4 = DasUtil.getParentOfKind(context, ObjectKind.PACKAGE, false);
        if (object4 == null || (object4 = OraModelUtils.getChildType((DasObject)object4, (BasicModel)model2, typeName)) == null) {
            DasObject dasObject = DasUtil.getParentOfKind(context, ObjectKind.OBJECT_TYPE, false);
            object4 = dasObject != null ? OraModelUtils.getChildType(dasObject, (BasicModel)model2, typeName) : null;
            if (object4 == null) {
                DasObject dasObject3 = DasUtil.getParentOfKind(context, ObjectKind.SCHEMA, false);
                object4 = dasObject3 != null ? OraModelUtils.getChildType(dasObject3, (BasicModel)model2, typeName) : null;
                if (object4 == null) {
                    object4 = DasUnresolvedType.Companion.of(typeName);
                }
            }
        }
        return object4;
    }

    @NotNull
    public static final DasType createCollectionType(@NotNull OraCollectionTypeBase typeDef) {
        DasType dasType;
        Intrinsics.checkNotNullParameter((Object)typeDef, (String)"typeDef");
        OraCollectionTypeKind oraCollectionTypeKind = typeDef.getTypeKind();
        if (oraCollectionTypeKind == null) {
            return DasTypeSystemBase.UNKNOWN;
        }
        OraCollectionTypeKind kind = oraCollectionTypeKind;
        DasTypeSystemBase typeSystem = DasTypeUtilsKt.getTypeSystem(typeDef);
        DataType dataType = typeDef.getElementType().toDataType();
        Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"toDataType(...)");
        DasType elementType = DasTypeUtilsKt.resolve(typeSystem.createDasType(dataType), typeDef);
        switch (WhenMappings.$EnumSwitchMapping$0[kind.ordinal()]) {
            case 1: {
                if (!(typeDef instanceof OraPackageCollectionType)) {
                    return DasTypeSystemBase.UNKNOWN;
                }
                DataType dataType2 = ((OraPackageCollectionType)typeDef).getIndexElementType().toDataType();
                Intrinsics.checkNotNullExpressionValue((Object)dataType2, (String)"toDataType(...)");
                DasType indexType = typeSystem.createDasType(dataType2);
                dasType = new OraAssociativeArrayType(elementType, indexType);
                break;
            }
            case 2: {
                dasType = new OraNestedTableType(elementType);
                break;
            }
            case 3: {
                dasType = new OraVaryingArrayType(typeDef.getUpperBound(), elementType);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return dasType;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[OraCollectionTypeKind.values().length];
            try {
                nArray[OraCollectionTypeKind.ASSOCIATIVE_ARRAY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OraCollectionTypeKind.NESTED_TABLE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OraCollectionTypeKind.VARIABLE_SIZE_ARRAY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

