/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.debugger;

import com.intellij.database.console.client.DatabaseSessionClient;
import com.intellij.database.console.session.DatabaseSession;
import com.intellij.database.console.session.SessionsUtil;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.connection.statements.StringOutParam;
import com.intellij.database.dialects.oracle.debugger.OraBaseSession;
import com.intellij.database.dialects.oracle.debugger.OraConnectionHelperKt;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\r\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u001c\u001a\u00020\u001dJ\u0006\u0010\u001e\u001a\u00020\u001dJ\r\u0010\u001f\u001a\u00020\u001dH\u0000\u00a2\u0006\u0002\b J\r\u0010!\u001a\u00020\u001dH\u0000\u00a2\u0006\u0002\b\"J\b\u0010#\u001a\u00020\u001dH\u0016J\u0006\u0010$\u001a\u00020\u001dJ\u000e\u0010%\u001a\u00020\u001d2\u0006\u0010&\u001a\u00020\u000fJ\u0006\u0010'\u001a\u00020\u001dJ\u0010\u0010(\u001a\u00020\u001d2\b\b\u0002\u0010)\u001a\u00020\nR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0014\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\fR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0016\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\fR\u001e\u0010\u0018\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\fR\u001e\u0010\u001a\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\f\u00a8\u0006*"}, d2={"Lcom/intellij/database/dialects/oracle/debugger/OraExecutingSession;", "Lcom/intellij/database/dialects/oracle/debugger/OraBaseSession;", "connection", "Lcom/intellij/database/dataSource/DatabaseConnection;", "requestOwner", "Lcom/intellij/database/console/client/DatabaseSessionClient;", "(Lcom/intellij/database/dataSource/DatabaseConnection;Lcom/intellij/database/console/client/DatabaseSessionClient;)V", "_active", "Ljava/util/concurrent/atomic/AtomicBoolean;", "active", "", "getActive", "()Z", "alteredToDebuggable", "<set-?>", "", "debugId", "getDebugId", "()Ljava/lang/String;", "debugImmediate", "executing", "getExecuting", "turningDebugOFF", "getTurningDebugOFF", "turningDebugON", "getTurningDebugON", "underDebug", "getUnderDebug", "deactivateDataSource", "", "disconnectAndAbandonConnection", "executionBegin", "executionBegin$intellij_database_dialects_oracle_ex", "executionEnded", "executionEnded$intellij_database_dialects_oracle_ex", "initRemote", "makeSessionDebuggable", "performTargetStatement", "statement", "turnDebugOFF", "turnDebugON", "immediate", "intellij.database.dialects.oracle.ex"})
@SourceDebugExtension(value={"SMAP\nOraExecutingSession.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OraExecutingSession.kt\ncom/intellij/database/dialects/oracle/debugger/OraExecutingSession\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,149:1\n1#2:150\n*E\n"})
public final class OraExecutingSession
extends OraBaseSession {
    @Nullable
    private final DatabaseSessionClient requestOwner;
    @Nullable
    private String debugId;
    private volatile boolean underDebug;
    private volatile boolean turningDebugON;
    private volatile boolean turningDebugOFF;
    private volatile boolean executing;
    private boolean alteredToDebuggable;
    private boolean debugImmediate;
    @NotNull
    private final AtomicBoolean _active;

    public OraExecutingSession(@NotNull DatabaseConnection connection2, @Nullable DatabaseSessionClient requestOwner) {
        Intrinsics.checkNotNullParameter((Object)connection2, (String)"connection");
        super(connection2);
        this.requestOwner = requestOwner;
        this._active = new AtomicBoolean(false);
    }

    @Nullable
    public final String getDebugId() {
        return this.debugId;
    }

    public final boolean getUnderDebug() {
        return this.underDebug;
    }

    public final boolean getTurningDebugON() {
        return this.turningDebugON;
    }

    public final boolean getTurningDebugOFF() {
        return this.turningDebugOFF;
    }

    public final boolean getExecuting() {
        return this.executing;
    }

    public final boolean getActive() {
        return this._active.get();
    }

    @Override
    public void initRemote() {
        super.initRemote();
        this.trace("The session id: " + this.getSessionId());
    }

    public final void makeSessionDebuggable() {
        if (!this.alteredToDebuggable) {
            this.trace("alter session set plsql_debug = true");
            this.call("alter session set plsql_debug = true", new Object[0]);
            this.alteredToDebuggable = true;
        }
        if (this.debugId == null) {
            this.trace("sys.dbms_debug.initialize");
            this.debugId = (String)this.callFunction("sys.dbms_debug.initialize", new StringOutParam(1, 60, null, 4, null), new Object[0]);
            this.trace("Debug id: " + this.debugId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void performTargetStatement(@NotNull String statement2) {
        Intrinsics.checkNotNullParameter((Object)statement2, (String)"statement");
        this.turnDebugON(this.debugImmediate);
        this.trace("Starting the target statement");
        this._active.set(true);
        try {
            this.call(statement2, new Object[0]);
        }
        finally {
            this._active.set(false);
        }
        this.trace("The target statement is completed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void turnDebugON(boolean immediate) {
        if (this.underDebug) {
            return;
        }
        String procedure = "sys.dbms_debug.debug_on(immediate => " + immediate + ")";
        this.trace(procedure);
        try {
            this.turningDebugON = true;
            try {
                this.callProcedure(procedure, new Object[0]);
                this.underDebug = true;
            }
            finally {
                this.turningDebugON = false;
            }
        }
        catch (Throwable exception) {
            Throwable e2 = OraConnectionHelperKt.unwrapException(exception);
            String message2 = OraConnectionHelperKt.prepareGoodMessage(e2, "Cannot turn debugging ON");
            this.trace(message2);
        }
    }

    public static /* synthetic */ void turnDebugON$default(OraExecutingSession oraExecutingSession, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        oraExecutingSession.turnDebugON(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void turnDebugOFF() {
        if (!this.underDebug) {
            return;
        }
        String procedure = "sys.dbms_debug.debug_off";
        this.trace(procedure);
        try {
            this.turningDebugOFF = true;
            try {
                this.callProcedure(procedure, new Object[0]);
                this.underDebug = false;
            }
            finally {
                this.turningDebugOFF = false;
            }
        }
        catch (Throwable exception) {
            Throwable e2 = OraConnectionHelperKt.unwrapException(exception);
            String message2 = OraConnectionHelperKt.prepareGoodMessage(e2, "Cannot turn debugging OFF");
            this.trace(message2);
            this.disconnectAndAbandonConnection();
        }
    }

    public final void executionBegin$intellij_database_dialects_oracle_ex() {
        this.executing = true;
    }

    public final void executionEnded$intellij_database_dialects_oracle_ex() {
        this.executing = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void disconnectAndAbandonConnection() {
        this.trace("Disconnecting");
        try {
            this.getConnection().getRemoteConnection().close();
        }
        finally {
            this.underDebug = false;
        }
    }

    public final void deactivateDataSource() {
        boolean bl;
        boolean bl2 = bl = this.requestOwner != null;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Cannot deactivate data source when session is not specified";
            throw new AssertionError((Object)string);
        }
        DatabaseSessionClient databaseSessionClient = this.requestOwner;
        Intrinsics.checkNotNull((Object)databaseSessionClient);
        Object s2 = databaseSessionClient.getSession();
        Intrinsics.checkNotNullExpressionValue(s2, (String)"<get-session>(...)");
        SessionsUtil.deactivateDataSource((DatabaseSession)s2);
    }
}

