/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mysqlbase.plan;

import com.intellij.database.dialects.base.plan.AbstractPlanModelBuilder;
import com.intellij.database.dialects.mysqlbase.plan.MysqlBaseRawPlanData;
import com.intellij.database.plan.PlanModel;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MysqlBasePlanModelBuilder
extends AbstractPlanModelBuilder<MysqlBaseRawPlanData, MetaNode> {
    private static final Map<String, PlanModel.NodeType> TYPE_MAPPING = new HashMap<String, PlanModel.NodeType>();
    private static final Map<String, PlanModel.NodeType> EXTRA_MAPPING = new HashMap<String, PlanModel.NodeType>();
    private static final Pattern UNION_RESULT_PATTERN = Pattern.compile("<union(\\d+(,(\\d+|\\.\\.\\.))*)>");
    private static final Pattern DERIVED_PATTERN = Pattern.compile("<derived(\\d+)>");

    public MysqlBasePlanModelBuilder() {
        super(EnumSet.of(PlanModel.Feature.TOTAL_COST, PlanModel.Feature.STARTUP_COST));
    }

    @Override
    @NotNull
    public MysqlBaseRawPlanData createData() {
        return new MysqlBaseRawPlanData();
    }

    @Override
    protected void parseData() {
        for (MysqlBaseRawPlanData.PlanRow row : ((MysqlBaseRawPlanData)this.myData).rows) {
            String[] sids;
            Matcher matcher;
            if (!"UNION RESULT".equals(row.selectType) || !(matcher = UNION_RESULT_PATTERN.matcher(row.table)).matches() || (sids = matcher.group(1).split(",")).length == 0) continue;
            int i2 = 0;
            int cur = Integer.parseInt(sids[0]);
            while (i2 < sids.length) {
                int prev = cur;
                ++i2;
                while (i2 < sids.length) {
                    int next = "...".equals(sids[i2]) ? -1 : Integer.parseInt(sids[i2]);
                    boolean gap = prev != -1 && next != -1 && next != prev + 1;
                    prev = next;
                    if (gap) break;
                    ++i2;
                }
                ((MysqlBaseRawPlanData)this.myData).slicing.slice(cur);
                cur = prev;
            }
        }
        MetaNode structure = this.parseStructure();
        this.openNode(null);
        this.openNode(null);
        this.parsePlan(structure);
        this.closeNode(this.createNode(null, PlanModel.NodeType.SELECT, null));
        this.closeNode(new PlanModel.GenericNode(PlanModel.NodeType.ROOT, null));
    }

    private void parseStructureItem(int rowId, List<IntList> unionResults, Int2ObjectMap<List<MetaNode>> metaQueries, Int2ObjectMap<MetaNode> metaQueriesRoot, List<MetaNode> delayed, IntSet usedSubqueries) {
        ArrayList<MetaNode> others;
        MetaNode node2;
        MysqlBaseRawPlanData.PlanRow curRow = ((MysqlBaseRawPlanData)this.myData).rows.get(rowId);
        if ("UNION RESULT".equals(curRow.selectType)) {
            Matcher matcher = UNION_RESULT_PATTERN.matcher(curRow.table);
            if (!matcher.matches()) {
                this.unsupportedFormat("`" + curRow.table + "` does not match `" + UNION_RESULT_PATTERN.pattern() + "`");
            }
            IntArrayList res2 = new IntArrayList();
            String[] sids = matcher.group(1).split(",");
            for (int i2 = 0; i2 < sids.length; ++i2) {
                int to;
                if (sids[i2].equals("...")) {
                    from = Integer.parseInt(sids[i2 - 1]);
                    to = i2 + 1 < sids.length ? Integer.parseInt(sids[i2 + 1]) : ((MysqlBaseRawPlanData)this.myData).slicing.next(from);
                } else {
                    from = Integer.parseInt(sids[i2]);
                    to = from + 1;
                }
                for (int id = from; id < to; ++id) {
                    usedSubqueries.add(id);
                    res2.add(id);
                }
            }
            unionResults.add((IntList)res2);
            return;
        }
        if (curRow.table != null) {
            MetaNode.Type type;
            Matcher matcher = DERIVED_PATTERN.matcher(curRow.table);
            int subId = -1;
            if (matcher.matches()) {
                type = MetaNode.Type.SUBQUERY;
                subId = Integer.parseInt(matcher.group(1));
                usedSubqueries.add(subId);
            } else {
                type = MetaNode.Type.SELECT;
            }
            node2 = new MetaNode(rowId, type, subId);
        } else {
            node2 = new MetaNode(PlanModel.NodeType.VALUE, curRow.type, rowId);
        }
        if (node2.type == MetaNode.Type.SUBQUERY) {
            delayed.add(node2);
        }
        if ((others = (ArrayList<MetaNode>)metaQueries.get(curRow.id)) == null) {
            metaQueriesRoot.put(curRow.id, (Object)node2);
            others = new ArrayList<MetaNode>();
            metaQueries.put(curRow.id, others);
        }
        others.add(this.expandStructure(node2));
    }

    @NotNull
    private MetaNode expandStructure(@NotNull MetaNode node2) {
        if (node2 == null) {
            MysqlBasePlanModelBuilder.$$$reportNull$$$0(0);
        }
        if (node2.rowId != -1) {
            String[] clauses;
            for (String clause : clauses = ((MysqlBaseRawPlanData)this.myData).rows.get((int)node2.rowId).extra.split("; ")) {
                PlanModel.NodeType type = EXTRA_MAPPING.get(clause);
                if (type == null) continue;
                MetaNode tmp = new MetaNode(type, clause, node2.rowId);
                tmp.children.add(node2);
                node2 = tmp;
            }
        }
        MetaNode metaNode = node2;
        if (metaNode == null) {
            MysqlBasePlanModelBuilder.$$$reportNull$$$0(1);
        }
        return metaNode;
    }

    private int bindScalarSubqueryItem(Int2ObjectMap<MetaNode> metaQueriesRoot, IntSet usedSubqueries, List<MetaNode> delayed, int from) {
        MetaNode target2 = (MetaNode)metaQueriesRoot.get(((MysqlBaseRawPlanData)this.myData).rows.get((int)from).id);
        int targetIdx = target2.children.size();
        int i2 = from + 1;
        while (i2 < ((MysqlBaseRawPlanData)this.myData).rows.size()) {
            if (((MysqlBaseRawPlanData)this.myData).rows.get((int)i2).id == ((MysqlBaseRawPlanData)this.myData).rows.get((int)from).id) {
                ++i2;
                continue;
            }
            if (usedSubqueries.contains(((MysqlBaseRawPlanData)this.myData).rows.get((int)i2).id) || ((MysqlBaseRawPlanData)this.myData).rows.get((int)i2).id < ((MysqlBaseRawPlanData)this.myData).rows.get((int)from).id) break;
            MetaNode node2 = new MetaNode(-1, MetaNode.Type.SUBQUERY, ((MysqlBaseRawPlanData)this.myData).rows.get((int)i2).id);
            target2.children.add(targetIdx, node2);
            delayed.add(node2);
            i2 = this.bindScalarSubqueryItem(metaQueriesRoot, usedSubqueries, delayed, i2);
        }
        return i2;
    }

    private void bindScalarSubqueries(Int2ObjectMap<MetaNode> metaQueriesRoot, IntSet usedSubqueries, List<MetaNode> delayed) {
        if (((MysqlBaseRawPlanData)this.myData).rows.get((int)0).id != 1) {
            this.unsupportedFormat();
        }
        int i2 = 0;
        while (i2 < ((MysqlBaseRawPlanData)this.myData).rows.size()) {
            if (usedSubqueries.contains(((MysqlBaseRawPlanData)this.myData).rows.get((int)i2).id)) {
                i2 = this.bindScalarSubqueryItem(metaQueriesRoot, usedSubqueries, delayed, i2);
                continue;
            }
            ++i2;
        }
    }

    private MetaNode parseStructure() {
        ArrayList<IntList> unionResults = new ArrayList<IntList>();
        ArrayList<MetaNode> delayed = new ArrayList<MetaNode>();
        IntOpenHashSet usedSubqueries = new IntOpenHashSet();
        usedSubqueries.add(1);
        Int2ObjectOpenHashMap metaQueries = new Int2ObjectOpenHashMap();
        Int2ObjectOpenHashMap metaQueriesRoot = new Int2ObjectOpenHashMap();
        for (int i2 = 0; i2 < ((MysqlBaseRawPlanData)this.myData).rows.size(); ++i2) {
            this.parseStructureItem(i2, unionResults, (Int2ObjectMap<List<MetaNode>>)metaQueries, (Int2ObjectMap<MetaNode>)metaQueriesRoot, delayed, (IntSet)usedSubqueries);
        }
        this.bindScalarSubqueries((Int2ObjectMap<MetaNode>)metaQueriesRoot, (IntSet)usedSubqueries, delayed);
        for (IntList result2 : unionResults) {
            this.createUnionNodes(result2, (Int2ObjectMap<List<MetaNode>>)metaQueries);
        }
        for (MetaNode node2 : delayed) {
            assert (node2.subId != -1);
            node2.children.add(this.createJoinNodes(node2.subId, (Int2ObjectMap<List<MetaNode>>)metaQueries).get(0));
        }
        return this.createJoinNodes(1, (Int2ObjectMap<List<MetaNode>>)metaQueries).get(0);
    }

    private List<MetaNode> createJoinNodes(int id, Int2ObjectMap<List<MetaNode>> metaQueries) {
        List nodes = (List)metaQueries.get(id);
        if (nodes == null) {
            this.unsupportedFormat();
        }
        if (nodes.size() != 1) {
            MetaNode loop = new MetaNode(PlanModel.NodeType.NESTED_LOOPS, null, ((MetaNode)nodes.get((int)0)).rowId);
            loop.children.addAll(nodes);
            nodes.clear();
            nodes.add(loop);
        }
        return nodes;
    }

    private void createUnionNodes(@NotNull IntList result2, Int2ObjectMap<List<MetaNode>> metaQueries) {
        if (result2 == null) {
            MysqlBasePlanModelBuilder.$$$reportNull$$$0(2);
        }
        List<MetaNode> output = this.createJoinNodes(result2.getInt(0), metaQueries);
        for (int i2 = 1; i2 < result2.size(); ++i2) {
            output.add(this.createJoinNodes(result2.getInt(i2), metaQueries).get(0));
        }
        if (output.size() != 1) {
            MetaNode loop = new MetaNode(PlanModel.NodeType.UNION, null, output.get((int)0).rowId);
            loop.children.addAll(output);
            output.clear();
            output.add(loop);
        }
    }

    @Override
    @NotNull
    protected String parseRawDescription(@NotNull MetaNode node2) {
        if (node2 == null) {
            MysqlBasePlanModelBuilder.$$$reportNull$$$0(3);
        }
        String string = node2.rowId == -1 ? "" : ((MysqlBaseRawPlanData)this.myData).rows.get((int)node2.rowId).extra;
        if (string == null) {
            MysqlBasePlanModelBuilder.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    @Nullable
    protected String parseAccessRelation(@NotNull MetaNode node2) {
        if (node2 == null) {
            MysqlBasePlanModelBuilder.$$$reportNull$$$0(5);
        }
        return node2.rowId == -1 ? null : ((MysqlBaseRawPlanData)this.myData).rows.get((int)node2.rowId).table;
    }

    @Override
    @Nullable
    protected BigDecimal parsePlanNumRows(@NotNull MetaNode node2) {
        if (node2 == null) {
            MysqlBasePlanModelBuilder.$$$reportNull$$$0(6);
        }
        return node2.rowId == -1 ? null : ((MysqlBaseRawPlanData)this.myData).rows.get((int)node2.rowId).rows;
    }

    @Override
    @Nullable
    protected String parseAccessIndex(@NotNull MetaNode node2) {
        if (node2 == null) {
            MysqlBasePlanModelBuilder.$$$reportNull$$$0(7);
        }
        return node2.rowId == -1 ? "" : ((MysqlBaseRawPlanData)this.myData).rows.get((int)node2.rowId).key;
    }

    @Override
    protected void parsePlan(@NotNull MetaNode node2) {
        if (node2 == null) {
            MysqlBasePlanModelBuilder.$$$reportNull$$$0(8);
        }
        if (!this.openNode(node2)) {
            return;
        }
        this.parseSubPlans(node2);
        PlanModel.NodeType type = PlanModel.NodeType.UNKNOWN;
        String typeStr = null;
        switch (node2.type) {
            case SELECT: {
                MysqlBaseRawPlanData.PlanRow row = ((MysqlBaseRawPlanData)this.myData).rows.get(node2.rowId);
                typeStr = row.type;
                type = TYPE_MAPPING.get(typeStr);
                if (type != null) break;
                type = row.extra.contains("No tables used") ? PlanModel.NodeType.VALUE : PlanModel.NodeType.ACCESS;
                break;
            }
            case TYPE: {
                type = node2.nodeType;
                typeStr = node2.nodeTypeStr;
                break;
            }
            case SUBQUERY: {
                type = PlanModel.NodeType.SUBQUERY;
            }
        }
        PlanModel.GenericNode res2 = this.createNode(node2, type, typeStr);
        this.closeNode(res2);
    }

    @Override
    protected void parseSubPlans(@NotNull MetaNode node2) {
        if (node2 == null) {
            MysqlBasePlanModelBuilder.$$$reportNull$$$0(9);
        }
        for (MetaNode child : node2.children) {
            this.parsePlan(child);
        }
    }

    @Override
    protected void parseStatement(@NotNull MetaNode node2) {
        if (node2 == null) {
            MysqlBasePlanModelBuilder.$$$reportNull$$$0(10);
        }
    }

    @Override
    @Nullable
    protected Double parseTotalCost(@NotNull MetaNode node2) {
        if (node2 == null) {
            MysqlBasePlanModelBuilder.$$$reportNull$$$0(11);
        }
        return null;
    }

    @Override
    @Nullable
    protected Double parseStartupCost(@NotNull MetaNode node2) {
        if (node2 == null) {
            MysqlBasePlanModelBuilder.$$$reportNull$$$0(12);
        }
        return null;
    }

    @Override
    protected boolean parseSubqueryCorrelated(@NotNull MetaNode node2) {
        if (node2 == null) {
            MysqlBasePlanModelBuilder.$$$reportNull$$$0(13);
        }
        MetaNode target2 = null;
        for (MetaNode child : node2.children) {
            if (child.rowId == -1) continue;
            MysqlBaseRawPlanData.PlanRow row = ((MysqlBaseRawPlanData)this.myData).rows.get(child.rowId);
            if (node2.subId != row.id) continue;
            if (target2 != null) {
                this.unsupportedFormat();
            }
            target2 = child;
        }
        if (target2 == null) {
            this.unsupportedFormat();
        }
        return ((MysqlBaseRawPlanData)this.myData).rows.get((int)target2.rowId).selectType.startsWith("DEPENDENT");
    }

    @Override
    protected boolean parseSubqueryScalar(@NotNull MetaNode node2) {
        if (node2 == null) {
            MysqlBasePlanModelBuilder.$$$reportNull$$$0(14);
        }
        return false;
    }

    static {
        TYPE_MAPPING.put("system", PlanModel.NodeType.VALUE);
        TYPE_MAPPING.put("const", PlanModel.NodeType.UNIQUE_INDEX_SCAN);
        TYPE_MAPPING.put("eq_ref", PlanModel.NodeType.UNIQUE_INDEX_SCAN);
        TYPE_MAPPING.put("ref", PlanModel.NodeType.UNIQUE_INDEX_SCAN);
        TYPE_MAPPING.put("fulltext", PlanModel.NodeType.INDEX_SCAN);
        TYPE_MAPPING.put("ref_or_null", PlanModel.NodeType.UNIQUE_INDEX_SCAN);
        TYPE_MAPPING.put("index_merge", PlanModel.NodeType.BITMAP_INDEX_SCAN);
        TYPE_MAPPING.put("unique_subquery", PlanModel.NodeType.UNIQUE_INDEX_SCAN);
        TYPE_MAPPING.put("index_subquery", PlanModel.NodeType.INDEX_SCAN);
        TYPE_MAPPING.put("range", PlanModel.NodeType.INDEX_SCAN);
        TYPE_MAPPING.put("index", PlanModel.NodeType.FULL_INDEX_SCAN);
        TYPE_MAPPING.put("ALL", PlanModel.NodeType.SEQ_SCAN);
        EXTRA_MAPPING.put("Using filesort", PlanModel.NodeType.SORT);
        EXTRA_MAPPING.put("Using temporary", PlanModel.NodeType.TEMPORARY);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/mysqlbase/plan/MysqlBasePlanModelBuilder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/mysqlbase/plan/MysqlBasePlanModelBuilder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "expandStructure";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "parseRawDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "expandStructure";
                break;
            }
            case 1: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createUnionNodes";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "parseRawDescription";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "parseAccessRelation";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "parsePlanNumRows";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "parseAccessIndex";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "parsePlan";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "parseSubPlans";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "parseStatement";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "parseTotalCost";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "parseStartupCost";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "parseSubqueryCorrelated";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "parseSubqueryScalar";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4 -> new IllegalStateException(string);
        };
    }

    public static final class MetaNode {
        public final int rowId;
        public final int subId;
        public final Type type;
        public final PlanModel.NodeType nodeType;
        public final String nodeTypeStr;
        public final List<MetaNode> children;

        private MetaNode(int id, Type type, int subId) {
            this.children = new ArrayList<MetaNode>(0);
            this.rowId = id;
            this.type = type;
            this.subId = subId;
            this.nodeType = null;
            this.nodeTypeStr = null;
        }

        private MetaNode(@NotNull PlanModel.NodeType type, @Nullable String typeStr, int rowId) {
            if (type == null) {
                MetaNode.$$$reportNull$$$0(0);
            }
            this.children = new ArrayList<MetaNode>(0);
            this.rowId = rowId;
            this.type = Type.TYPE;
            this.subId = -1;
            this.nodeType = type;
            this.nodeTypeStr = typeStr;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/database/dialects/mysqlbase/plan/MysqlBasePlanModelBuilder$MetaNode", "<init>"));
        }

        static enum Type {
            SELECT,
            SUBQUERY,
            TYPE;

        }
    }
}

