/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mysqlbase.introspector.jdbc;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dataSource.connection.statements.ExecutionMode;
import com.intellij.database.dataSource.connection.statements.SmartStatementFactoryService;
import com.intellij.database.dataSource.connection.statements.StandardExecutionMode;
import com.intellij.database.dataSource.connection.statements.StandardResultsProcessors;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.DialectUtils;
import com.intellij.database.dialects.base.introspector.jdbc.JdbcSourceLoader;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.basic.BasicModSourceAware;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MysqlBaseJdbcSourceLoader
extends JdbcSourceLoader {
    public MysqlBaseJdbcSourceLoader(@NotNull Dbms dbms) {
        if (dbms == null) {
            MysqlBaseJdbcSourceLoader.$$$reportNull$$$0(0);
        }
        super(dbms);
    }

    @Override
    protected boolean loadRoutine(@NotNull BasicModSourceAware object, @NotNull DatabaseConnectionCore connection2) throws Exception {
        String src2;
        if (object == null) {
            MysqlBaseJdbcSourceLoader.$$$reportNull$$$0(1);
        }
        if (connection2 == null) {
            MysqlBaseJdbcSourceLoader.$$$reportNull$$$0(2);
        }
        if (StringUtil.isEmpty((String)(src2 = DbImplUtilCore.concatStringResults(connection2, this.myDbms, "select routine_definition from information_schema.routines where routine_name = " + MysqlBaseJdbcSourceLoader.str(object.getName()) + "   and routine_schema = " + MysqlBaseJdbcSourceLoader.str(DasUtil.getSchema(object)), 0, DbImplUtilCore.ConcatenationProps.NO_CONCAT)))) {
            return false;
        }
        MysqlBaseJdbcSourceLoader.applySourceText(object, src2, false);
        return true;
    }

    @Override
    public Pair<String, DbImplUtilCore.ConcatenationProps> sqlViewDefinition(@NotNull DasObject element2) {
        if (element2 == null) {
            MysqlBaseJdbcSourceLoader.$$$reportNull$$$0(3);
        }
        return Pair.create((Object)("SELECT view_definition FROM information_schema.views WHERE table_name = '" + element2.getName() + "' AND table_schema = '" + MysqlBaseJdbcSourceLoader.getDBName(element2) + "'"), (Object)DbImplUtilCore.ConcatenationProps.NO_CONCAT);
    }

    @Override
    public boolean supportsProcedureDefinition() {
        return true;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtilCore.ConcatenationProps> sqlProcedureDefinition(@NotNull DasRoutine element2) {
        if (element2 == null) {
            MysqlBaseJdbcSourceLoader.$$$reportNull$$$0(4);
        }
        Pair pair = Pair.create((Object)("SELECT routine_definition FROM information_schema.routines WHERE routine_name = '" + element2.getName() + "' AND routine_schema = '" + MysqlBaseJdbcSourceLoader.getDBName(element2) + "'"), (Object)DbImplUtilCore.ConcatenationProps.NO_CONCAT);
        if (pair == null) {
            MysqlBaseJdbcSourceLoader.$$$reportNull$$$0(5);
        }
        return pair;
    }

    @Override
    public boolean supportsViewDefinition() {
        return true;
    }

    @NotNull
    public static String getDBName(@NotNull DasObject qualifier) {
        if (qualifier == null) {
            MysqlBaseJdbcSourceLoader.$$$reportNull$$$0(6);
        }
        String string = DasUtil.getName(MysqlBaseJdbcSourceLoader.getDB(qualifier));
        if (string == null) {
            MysqlBaseJdbcSourceLoader.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Nullable
    private static DasObject getDB(@NotNull DasObject qualifier) {
        DasObject schema2;
        if (qualifier == null) {
            MysqlBaseJdbcSourceLoader.$$$reportNull$$$0(8);
        }
        return (schema2 = DasUtil.getSchemaObject(qualifier)) != null && !StringUtil.isEmpty((String)schema2.getName()) ? schema2 : DasUtil.getCatalogObject(qualifier);
    }

    @Override
    @NotNull
    public String tryToLoadProcedureDefinition(@NotNull DasRoutine procedure, @NotNull DatabaseConnectionCore connection2) throws Exception {
        if (procedure == null) {
            MysqlBaseJdbcSourceLoader.$$$reportNull$$$0(9);
        }
        if (connection2 == null) {
            MysqlBaseJdbcSourceLoader.$$$reportNull$$$0(10);
        }
        Dbms dbms = connection2.getDbms();
        DatabaseDialectEx dialect = DbImplUtilCore.getDatabaseDialect(dbms);
        String type = procedure.getRoutineKind().name();
        String query = new DdlBuilder().withDialect(dialect).qualifyReferences(true).keywords("SHOW", "CREATE", type).space().qualifiedRef(procedure).getStatement();
        String string = SmartStatementFactoryService.getInstance().poweredBy(connection2).simple().noisy().execute(query, (ExecutionMode)StandardExecutionMode.QUERY, StandardResultsProcessors.throwableResultsTransformer(rs -> {
            if (!rs.next()) {
                return "-- failed to load definition";
            }
            DdlBuilder builder = new DdlBuilder().withDialect(dialect).qualifyReferences(true).splitStatements(true);
            dialect.sqlDropProcedure(builder, procedure).newStatement().plain(rs.getString(3));
            return DialectUtils.sqlConcat(builder.getStatements());
        }, ""));
        if (string == null) {
            MysqlBaseJdbcSourceLoader.$$$reportNull$$$0(11);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 7, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 2: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/mysqlbase/introspector/jdbc/MysqlBaseJdbcSourceLoader";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "procedure";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/mysqlbase/introspector/jdbc/MysqlBaseJdbcSourceLoader";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlProcedureDefinition";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDBName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadProcedureDefinition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadRoutine";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "sqlViewDefinition";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "sqlProcedureDefinition";
                break;
            }
            case 5: 
            case 7: 
            case 11: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getDBName";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getDB";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadProcedureDefinition";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 7, 11 -> new IllegalStateException(string);
        };
    }
}

