/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mssql.plan;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.DatabaseNotifications;
import com.intellij.database.Dbms;
import com.intellij.database.dialects.base.plan.AbstractXmlPlanModelBuilder;
import com.intellij.database.dialects.mssql.plan.MsRawPlanData;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.basic.BasicTableOrViewColumn;
import com.intellij.database.plan.PlanModel;
import com.intellij.database.plan.PlanRetrievalException;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbTable;
import com.intellij.database.schemaEditor.model.DeColumn;
import com.intellij.database.schemaEditor.model.DeIndex;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.script.generator.NamingService;
import com.intellij.database.script.generator.NamingServices;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.database.view.editors.DatabaseTableEditor;
import com.intellij.database.view.models.builder.IndexModelBuilder;
import com.intellij.database.view.models.builder.TableModelBuilder;
import com.intellij.database.view.ui.DbRefactoringDialogHelper;
import com.intellij.database.view.ui.DbTableDialog;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.JavaXmlDocumentKt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import java.io.IOException;
import java.io.StringReader;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.xpath.XPathExpression;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class MsPlanModelBuilder
extends AbstractXmlPlanModelBuilder<MsRawPlanData, Element> {
    private static final Map<String, PlanModel.NodeType> LOGICAL_MAPPING = new HashMap<String, PlanModel.NodeType>();
    private static final Map<Pair<PlanModel.NodeType, String>, PlanModel.NodeType> PHYSICAL_MAPPING = new HashMap<Pair<PlanModel.NodeType, String>, PlanModel.NodeType>();
    private static final Map<String, PlanModel.NodeType> STATEMENT_MAPPING = new HashMap<String, PlanModel.NodeType>();
    private final XPathExpression STATEMENTS_QUERY = this.compileXPath("//Statements/StmtSimple");
    private final XPathExpression FIRST_OP_QUERY = this.compileXPath("QueryPlan/RelOp");
    private final XPathExpression MISSING_INDICES_QUERY = this.compileXPath("QueryPlan/MissingIndexes/MissingIndexGroup");
    private final XPathExpression ACCESS_OBJECT_QUERY = this.compileXPath("*/Object");
    private final XPathExpression RUNTIME_QUERY = this.compileXPath("RunTimeInformation/RunTimeCountersPerThread");
    private final XPathExpression SUB_OPS_QUERY = this.compileXPath("*/RelOp");

    public MsPlanModelBuilder() {
        super(EnumSet.of(PlanModel.Feature.STARTUP_COST));
    }

    @Override
    @NotNull
    public MsRawPlanData createData() {
        return new MsRawPlanData();
    }

    @Override
    protected void parseData() {
        this.parseXmls(((MsRawPlanData)this.myData).xmls);
    }

    private void parseXmls(@NotNull List<String> xmls) {
        if (xmls == null) {
            MsPlanModelBuilder.$$$reportNull$$$0(0);
        }
        try {
            DocumentBuilder builder = JavaXmlDocumentKt.createDocumentBuilder();
            this.openNode(null);
            for (String xml : xmls) {
                Document doc = builder.parse(new InputSource(new StringReader(xml)));
                NodeList statements2 = MsPlanModelBuilder.queryElements(this.STATEMENTS_QUERY, doc.getDocumentElement());
                if (statements2.getLength() == 0) continue;
                for (int i2 = 0; i2 < statements2.getLength(); ++i2) {
                    Element statement2 = (Element)statements2.item(i2);
                    this.parseStatement(statement2);
                }
            }
            this.closeNode(new PlanModel.GenericNode(PlanModel.NodeType.ROOT, null));
        }
        catch (IOException | SAXException e2) {
            throw new PlanRetrievalException("Failed to parse XML", e2);
        }
    }

    @Override
    @NotNull
    protected String parseRawDescription(final @NotNull Element element2) {
        if (element2 == null) {
            MsPlanModelBuilder.$$$reportNull$$$0(1);
        }
        String string = new Object(){
            final StringBuilder sb = new StringBuilder();
            {
                this.visit("", element2);
            }

            void visit(String prefix, Element el) {
                int i2;
                NamedNodeMap attributes2 = el.getAttributes();
                for (i2 = 0; i2 < attributes2.getLength(); ++i2) {
                    Attr attr = (Attr)attributes2.item(i2);
                    this.sb.append(prefix).append(attr.getName()).append(" = ").append(attr.getValue()).append(";\n");
                }
                for (i2 = 0; i2 < el.getChildNodes().getLength(); ++i2) {
                    Element child = (Element)ObjectUtils.tryCast((Object)el.getChildNodes().item(i2), Element.class);
                    if (child == null || "RelOp".equals(child.getTagName()) || "OutputList".equals(child.getTagName()) || "DefinedValues".equals(child.getTagName())) continue;
                    this.visit(prefix + child.getTagName() + ".", child);
                }
            }
        }.sb.toString();
        if (string == null) {
            MsPlanModelBuilder.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @Nullable
    protected String parseAccessRelation(@NotNull Element element2) {
        Element obj2;
        if (element2 == null) {
            MsPlanModelBuilder.$$$reportNull$$$0(3);
        }
        if ((obj2 = MsPlanModelBuilder.queryElement(this.ACCESS_OBJECT_QUERY, element2)) == null) {
            this.unsupportedFormat();
        }
        return obj2.getAttribute("Schema") + "." + obj2.getAttribute("Table");
    }

    @Override
    @Nullable
    protected BigDecimal parsePlanNumRows(@NotNull Element element2) {
        if (element2 == null) {
            MsPlanModelBuilder.$$$reportNull$$$0(4);
        }
        try {
            if ("RelOp".equals(element2.getTagName())) {
                return new BigDecimal(element2.getAttribute("EstimateRows"));
            }
            return new BigDecimal(element2.getAttribute("StatementEstRows"));
        }
        catch (NumberFormatException e2) {
            return null;
        }
    }

    @Override
    @Nullable
    protected String parseAccessIndex(@NotNull Element element2) {
        Element obj2;
        if (element2 == null) {
            MsPlanModelBuilder.$$$reportNull$$$0(5);
        }
        if ((obj2 = MsPlanModelBuilder.queryElement(this.ACCESS_OBJECT_QUERY, element2)) == null) {
            this.unsupportedFormat();
        }
        return obj2.getAttribute("Index");
    }

    @Override
    protected void parsePlan(@NotNull Element state) {
        if (state == null) {
            MsPlanModelBuilder.$$$reportNull$$$0(6);
        }
        this.openNode(null);
        this.parseSubPlans(state);
        String logOp = state.getAttribute("LogicalOp");
        String phyOp = state.getAttribute("PhysicalOp");
        PlanModel.NodeType type = LOGICAL_MAPPING.get(logOp);
        type = (PlanModel.NodeType)((Object)ObjectUtils.chooseNotNull((Object)((Object)PHYSICAL_MAPPING.get(Pair.create((Object)((Object)type), (Object)phyOp))), (Object)((Object)type)));
        if (type == null) {
            type = PlanModel.NodeType.UNKNOWN;
        }
        String text2 = phyOp.equals(logOp) ? phyOp : logOp + " - " + phyOp;
        PlanModel.GenericNode node2 = this.createNode(state, type, text2);
        this.closeNode(node2);
    }

    @Override
    protected void parseSubPlans(@NotNull Element element2) {
        if (element2 == null) {
            MsPlanModelBuilder.$$$reportNull$$$0(7);
        }
        NodeList sub = MsPlanModelBuilder.queryElements(this.SUB_OPS_QUERY, element2);
        for (int i2 = 0; i2 < sub.getLength(); ++i2) {
            this.parsePlan((Element)sub.item(i2));
        }
    }

    @Override
    protected void parseStatement(@NotNull Element element2) {
        String stmtType;
        PlanModel.NodeType type;
        if (element2 == null) {
            MsPlanModelBuilder.$$$reportNull$$$0(8);
        }
        this.openNode(null);
        Element plan = this.querySingleElement(this.FIRST_OP_QUERY, element2);
        if (plan != null) {
            this.parsePlan(plan);
        }
        if ((type = STATEMENT_MAPPING.get(stmtType = element2.getAttribute("StatementType"))) == null) {
            type = PlanModel.NodeType.STATEMENT;
        }
        PlanModel.GenericNode node2 = this.createNode(element2, type, type == PlanModel.NodeType.STATEMENT ? stmtType : null);
        node2.setHints(MsPlanModelBuilder.parseMissingIndices(MsPlanModelBuilder.queryElements(this.MISSING_INDICES_QUERY, element2)));
        this.closeNode(node2);
    }

    private static PlanModel.Hint[] parseMissingIndices(@NotNull NodeList element2) {
        if (element2 == null) {
            MsPlanModelBuilder.$$$reportNull$$$0(9);
        }
        if (element2.getLength() == 0) {
            return PlanModel.GenericNode.NO_HINTS;
        }
        ArrayList<PlanModel.Hint> res2 = new ArrayList<PlanModel.Hint>(element2.getLength());
        NamingService ns = NamingServices.getNamingService(Dbms.MSSQL);
        for (int i2 = 0; i2 < element2.getLength(); ++i2) {
            Element group2 = (Element)element2.item(i2);
            double impact = Double.parseDouble(group2.getAttribute("Impact"));
            NodeList indices = group2.getElementsByTagName("MissingIndex");
            for (int j = 0; j < indices.getLength(); ++j) {
                Element index2 = (Element)indices.item(j);
                ObjectPath path = ObjectPath.create(ns.unquoteIdentifier(StringUtil.notNullize((String)index2.getAttribute("Database"))), ObjectKind.DATABASE).append(ns.unquoteIdentifier(StringUtil.notNullize((String)index2.getAttribute("Schema"))), ObjectKind.SCHEMA).append(ns.unquoteIdentifier(StringUtil.notNullize((String)index2.getAttribute("Table"))), ObjectKind.TABLE);
                ArrayList<String> eq = new ArrayList<String>();
                ArrayList<String> inEq = new ArrayList<String>();
                ArrayList<String> incl = new ArrayList<String>();
                NodeList columnsGr = index2.getElementsByTagName("ColumnGroup");
                for (int k = 0; k < columnsGr.getLength(); ++k) {
                    ArrayList<String> tgt;
                    Element columns2 = (Element)columnsGr.item(k);
                    String usage = columns2.getAttribute("Usage");
                    ArrayList<String> arrayList = "EQUALITY".equals(usage) ? eq : ("INEQUALITY".equals(usage) ? inEq : (tgt = "INCLUDE".equals(usage) ? incl : null));
                    if (tgt == null) continue;
                    NodeList colNames = columns2.getElementsByTagName("Column");
                    for (int m = 0; m < colNames.getLength(); ++m) {
                        Element col = (Element)colNames.item(m);
                        tgt.add(ns.unquoteIdentifier(StringUtil.notNullize((String)col.getAttribute("Name"))));
                    }
                }
                res2.add(MsPlanModelBuilder.createIndexHint(path, eq, inEq, incl, impact));
            }
        }
        return res2.toArray(PlanModel.GenericNode.NO_HINTS);
    }

    private static PlanModel.Hint createIndexHint(ObjectPath path, List<String> eq, List<String> inEq, List<String> incl, double impact) {
        HtmlBuilder text2 = new HtmlBuilder();
        text2.append(DatabaseBundle.message("MsMissingIndex.missing.index.on.0", path.getDisplayName())).appendRaw("\n\t").append(DatabaseBundle.message("MsMissingIndex.impact.0", impact)).appendRaw("\n");
        MsPlanModelBuilder.appendColumns(eq, text2, DatabaseBundle.message("MsMissingIndex.equality", new Object[0]));
        MsPlanModelBuilder.appendColumns(inEq, text2, DatabaseBundle.message("MsMissingIndex.inequality", new Object[0]));
        MsPlanModelBuilder.appendColumns(incl, text2, DatabaseBundle.message("MsMissingIndex.include", new Object[0]));
        text2.appendLink("$ACTION0", DatabaseBundle.message("MsMissingIndex.create", new Object[0]));
        return new PlanModel.Hint(text2.toString(), MsPlanModelBuilder.createIndexAction(path, eq, inEq, incl));
    }

    private static void appendColumns(List<String> eq, HtmlBuilder text2, @Nls String usage) {
        if (!eq.isEmpty()) {
            text2.append("\t").append(DatabaseBundle.message("MsMissingIndex.0.columns.1", usage, String.join((CharSequence)", ", eq))).appendRaw("\n");
        }
    }

    private static PlanModel.Action createIndexAction(final ObjectPath path, final List<String> eq, final List<String> inEq, List<String> incl) {
        return new PlanModel.Action(){

            @Override
            public void perform(@NotNull DbDataSource dataSource2) {
                BasicTable basicTable;
                DbTable table;
                if (dataSource2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((table = (DbTable)ObjectUtils.tryCast((Object)DbSqlUtilCore.findElement(dataSource2, path), DbTable.class)) == null) {
                    DatabaseNotifications.DATABASE_EXECUTION_GROUP.createNotification(DatabaseBundle.message("MsMissingIndex.notification.content.unable.to.find.table", path.getDisplayName()), NotificationType.INFORMATION).setDisplayId("MsPlanModelBuilder.unable.to.find.table").notify(dataSource2.getProject());
                }
                if ((basicTable = (BasicTable)ObjectUtils.tryCast((Object)(table == null ? null : table.getDelegate()), BasicTable.class)) == null) {
                    return;
                }
                Set columns2 = JBIterable.from((Iterable)eq).append((Iterable)inEq).filterMap(c2 -> (BasicTableOrViewColumn)basicTable.getColumns().get((String)c2)).toSet();
                DbTableDialog dialog = DbRefactoringDialogHelper.newModifyTableDialog(new DatabaseEditorContext(table, null), basicTable);
                DbRefactoringDialogHelper.bootstrap(dialog, (Computable<? extends DeObject>)((Computable)() -> {
                    Ref newIndex = Ref.create();
                    ((TableModelBuilder)((TableModelBuilder.TableIndexModelBuilder)((TableModelBuilder.TableIndexModelBuilder)((IndexModelBuilder)((Object)TableModelBuilder.modify(((DatabaseTableEditor)dialog.getEditor()).getTableModel()).withIndex(""))).addColumns((Iterable<DeColumn>)DbRefactoringDialogHelper.export(dialog, columns2), DasIndex.Sorting.NONE)).addAndGet((Ref<DeIndex>)newIndex)).leave()).commit();
                    return (DeObject)newIndex.get();
                }));
                dialog.finishAndShow();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/dialects/mssql/plan/MsPlanModelBuilder$2", "perform"));
            }
        };
    }

    @Override
    @Nullable
    protected Double parseTotalCost(@NotNull Element element2) {
        if (element2 == null) {
            MsPlanModelBuilder.$$$reportNull$$$0(10);
        }
        try {
            if ("RelOp".equals(element2.getTagName())) {
                return Double.valueOf(element2.getAttribute("EstimatedTotalSubtreeCost"));
            }
            return Double.valueOf(element2.getAttribute("StatementSubTreeCost"));
        }
        catch (NumberFormatException e2) {
            return null;
        }
    }

    @Override
    protected void parseActualInfo(@NotNull Element element2, @NotNull PlanModel.GenericNode node2) {
        NodeList runtime;
        if (element2 == null) {
            MsPlanModelBuilder.$$$reportNull$$$0(11);
        }
        if (node2 == null) {
            MsPlanModelBuilder.$$$reportNull$$$0(12);
        }
        if ((runtime = MsPlanModelBuilder.queryElements(this.RUNTIME_QUERY, element2)).getLength() != 0) {
            this.myActual = true;
        }
        Double total = null;
        BigDecimal rows = null;
        for (int i2 = 0; i2 < runtime.getLength(); ++i2) {
            String threadRows;
            BigDecimal threadRowsN;
            Double threadElapsedMs;
            Element thread = (Element)runtime.item(i2);
            String threadElapsed = MsPlanModelBuilder.getAttr(thread, "ActualElapsedms");
            Double d2 = threadElapsedMs = threadElapsed == null ? null : Double.valueOf(Double.parseDouble(threadElapsed));
            if (threadElapsedMs != null && (total == null || total.compareTo(threadElapsedMs) < 0)) {
                total = threadElapsedMs;
            }
            BigDecimal bigDecimal = threadRowsN = (threadRows = MsPlanModelBuilder.getAttr(thread, "ActualRows")) == null ? null : new BigDecimal(threadRows);
            if (threadRowsN == null) continue;
            rows = rows == null ? threadRowsN : threadRowsN.add(rows);
        }
        node2.setActualTotalTime(total);
        node2.setActualStartupTime(null);
        node2.setActualNumRows(rows);
    }

    @Override
    @Nullable
    protected Double parseStartupCost(@NotNull Element element2) {
        if (element2 == null) {
            MsPlanModelBuilder.$$$reportNull$$$0(13);
        }
        return null;
    }

    @Override
    protected boolean parseSubqueryCorrelated(@NotNull Element element2) {
        if (element2 == null) {
            MsPlanModelBuilder.$$$reportNull$$$0(14);
        }
        return false;
    }

    @Override
    protected boolean parseSubqueryScalar(@NotNull Element element2) {
        if (element2 == null) {
            MsPlanModelBuilder.$$$reportNull$$$0(15);
        }
        return false;
    }

    static {
        LOGICAL_MAPPING.put("Aggregate", PlanModel.NodeType.AGGREGATE);
        LOGICAL_MAPPING.put("Assert", PlanModel.NodeType.OPERATION);
        LOGICAL_MAPPING.put("Async Concat", PlanModel.NodeType.UNION_ALL);
        LOGICAL_MAPPING.put("Batch Hash Table Build", PlanModel.NodeType.TRANSFORM);
        LOGICAL_MAPPING.put("Bitmap Create", PlanModel.NodeType.TRANSFORM);
        LOGICAL_MAPPING.put("Clustered Index Scan", PlanModel.NodeType.FULL_INDEX_SCAN);
        LOGICAL_MAPPING.put("Clustered Index Seek", PlanModel.NodeType.INDEX_SCAN);
        LOGICAL_MAPPING.put("Clustered Update", PlanModel.NodeType.UNKNOWN);
        LOGICAL_MAPPING.put("Collapse", PlanModel.NodeType.TRANSFORM);
        LOGICAL_MAPPING.put("Compute Scalar", PlanModel.NodeType.VALUE);
        LOGICAL_MAPPING.put("Concatenation", PlanModel.NodeType.UNION_ALL);
        LOGICAL_MAPPING.put("Constant Scan", PlanModel.NodeType.VALUE);
        LOGICAL_MAPPING.put("Cross Join", PlanModel.NodeType.NESTED_LOOPS);
        LOGICAL_MAPPING.put("Delete", PlanModel.NodeType.STATEMENT);
        LOGICAL_MAPPING.put("Deleted Scan", PlanModel.NodeType.ACCESS);
        LOGICAL_MAPPING.put("Distinct Sort", PlanModel.NodeType.SORT_UNIQUE);
        LOGICAL_MAPPING.put("Distinct", PlanModel.NodeType.UNIQUE);
        LOGICAL_MAPPING.put("Distribute Streams", PlanModel.NodeType.TRANSFORM);
        LOGICAL_MAPPING.put("Eager Spool", PlanModel.NodeType.TEMPORARY);
        LOGICAL_MAPPING.put("Filter", PlanModel.NodeType.FILTER);
        LOGICAL_MAPPING.put("Flow Distinct", PlanModel.NodeType.UNIQUE);
        LOGICAL_MAPPING.put("Full Outer Join", PlanModel.NodeType.JOIN);
        LOGICAL_MAPPING.put("Gather Streams", PlanModel.NodeType.TRANSFORM);
        LOGICAL_MAPPING.put("Generic", PlanModel.NodeType.UNKNOWN);
        LOGICAL_MAPPING.put("Index Scan", PlanModel.NodeType.FULL_INDEX_SCAN);
        LOGICAL_MAPPING.put("Index Seek", PlanModel.NodeType.INDEX_SCAN);
        LOGICAL_MAPPING.put("Inner Join", PlanModel.NodeType.JOIN);
        LOGICAL_MAPPING.put("Insert", PlanModel.NodeType.INSERT);
        LOGICAL_MAPPING.put("Inserted Scan", PlanModel.NodeType.ACCESS);
        LOGICAL_MAPPING.put("Lazy Spool", PlanModel.NodeType.TEMPORARY);
        LOGICAL_MAPPING.put("Left Anti Semi Join", PlanModel.NodeType.JOIN);
        LOGICAL_MAPPING.put("Left Outer Join", PlanModel.NodeType.JOIN);
        LOGICAL_MAPPING.put("Left Semi Join", PlanModel.NodeType.JOIN);
        LOGICAL_MAPPING.put("Log Row Scan", PlanModel.NodeType.OPERATION);
        LOGICAL_MAPPING.put("Merge Interval", PlanModel.NodeType.TRANSFORM);
        LOGICAL_MAPPING.put("Parameter Table Scan", PlanModel.NodeType.ACCESS);
        LOGICAL_MAPPING.put("Partial Aggregate", PlanModel.NodeType.AGGREGATE);
        LOGICAL_MAPPING.put("Print", PlanModel.NodeType.UNKNOWN);
        LOGICAL_MAPPING.put("Remote Delete", PlanModel.NodeType.DELETE);
        LOGICAL_MAPPING.put("Remote Index Scan", PlanModel.NodeType.FULL_INDEX_SCAN);
        LOGICAL_MAPPING.put("Remote Index Seek", PlanModel.NodeType.INDEX_SCAN);
        LOGICAL_MAPPING.put("Remote Insert", PlanModel.NodeType.INSERT);
        LOGICAL_MAPPING.put("Remote Query", PlanModel.NodeType.SELECT);
        LOGICAL_MAPPING.put("Remote Scan", PlanModel.NodeType.SEQ_SCAN);
        LOGICAL_MAPPING.put("Remote Update", PlanModel.NodeType.UPDATE);
        LOGICAL_MAPPING.put("Repartition Streams", PlanModel.NodeType.TRANSFORM);
        LOGICAL_MAPPING.put("RID Lookup", PlanModel.NodeType.ROWID_ACCESS);
        LOGICAL_MAPPING.put("Right Anti Semi Join", PlanModel.NodeType.JOIN);
        LOGICAL_MAPPING.put("Right Outer Join", PlanModel.NodeType.JOIN);
        LOGICAL_MAPPING.put("Right Semi Join", PlanModel.NodeType.JOIN);
        LOGICAL_MAPPING.put("Segment", PlanModel.NodeType.TRANSFORM);
        LOGICAL_MAPPING.put("Sequence", PlanModel.NodeType.SEQUENTIALLY);
        LOGICAL_MAPPING.put("Sort", PlanModel.NodeType.SORT);
        LOGICAL_MAPPING.put("Split", PlanModel.NodeType.TRANSFORM);
        LOGICAL_MAPPING.put("Switch", PlanModel.NodeType.TRANSFORM);
        LOGICAL_MAPPING.put("Table-valued function", PlanModel.NodeType.TABLE_FUNCTION);
        LOGICAL_MAPPING.put("Table Scan", PlanModel.NodeType.SEQ_SCAN);
        LOGICAL_MAPPING.put("Top", PlanModel.NodeType.TRANSFORM);
        LOGICAL_MAPPING.put("TopN Sort", PlanModel.NodeType.TRANSFORM);
        LOGICAL_MAPPING.put("UDX", PlanModel.NodeType.TRANSFORM);
        LOGICAL_MAPPING.put("Union", PlanModel.NodeType.UNION);
        LOGICAL_MAPPING.put("Update", PlanModel.NodeType.UPDATE);
        LOGICAL_MAPPING.put("Merge", PlanModel.NodeType.MERGE);
        LOGICAL_MAPPING.put("Merge Stats", PlanModel.NodeType.UNKNOWN);
        LOGICAL_MAPPING.put("Local Stats", PlanModel.NodeType.UNKNOWN);
        LOGICAL_MAPPING.put("Window Spool", PlanModel.NodeType.TEMPORARY);
        PHYSICAL_MAPPING.put((Pair<PlanModel.NodeType, String>)Pair.create((Object)((Object)PlanModel.NodeType.JOIN), (Object)"Nested Loops"), PlanModel.NodeType.NESTED_LOOPS);
        PHYSICAL_MAPPING.put((Pair<PlanModel.NodeType, String>)Pair.create((Object)((Object)PlanModel.NodeType.JOIN), (Object)"Merge Join"), PlanModel.NodeType.MERGE_JOIN);
        PHYSICAL_MAPPING.put((Pair<PlanModel.NodeType, String>)Pair.create((Object)((Object)PlanModel.NodeType.JOIN), (Object)"Hash Match"), PlanModel.NodeType.HASH_JOIN);
        STATEMENT_MAPPING.put("SELECT", PlanModel.NodeType.SELECT);
        STATEMENT_MAPPING.put("MERGE", PlanModel.NodeType.MERGE);
        STATEMENT_MAPPING.put("DELETE", PlanModel.NodeType.DELETE);
        STATEMENT_MAPPING.put("INSERT", PlanModel.NodeType.INSERT);
        STATEMENT_MAPPING.put("UPDATE", PlanModel.NodeType.UPDATE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmls";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/mssql/plan/MsPlanModelBuilder";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/mssql/plan/MsPlanModelBuilder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "parseRawDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parseXmls";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "parseRawDescription";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "parseAccessRelation";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "parsePlanNumRows";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "parseAccessIndex";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "parsePlan";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "parseSubPlans";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "parseStatement";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "parseMissingIndices";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "parseTotalCost";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "parseActualInfo";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "parseStartupCost";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "parseSubqueryCorrelated";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "parseSubqueryScalar";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

