/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.hsql.types;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.base.types.DasTypeSystemImpl;
import com.intellij.database.dialects.hsql.types.HsqlArrayType;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeCategory;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\nH\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\nH\u0016\u00a8\u0006\u0011"}, d2={"Lcom/intellij/database/dialects/hsql/types/HSqlTypeSystem;", "Lcom/intellij/database/dialects/base/types/DasTypeSystemImpl;", "dbms", "Lcom/intellij/database/Dbms;", "(Lcom/intellij/database/Dbms;)V", "doCreateArrayType", "Lcom/intellij/database/dialects/hsql/types/HsqlArrayType;", "componentType", "Lcom/intellij/database/types/DasType;", "getDefaultTypeName", "", "cat", "Lcom/intellij/database/types/DasTypeCategory;", "getNormalizedTypeName", "name", "getTypeCategoryByName", "typeName", "intellij.database.dialects.hsql"})
public final class HSqlTypeSystem
extends DasTypeSystemImpl {
    public HSqlTypeSystem(@NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        super(dbms);
    }

    @Override
    @NotNull
    public String getNormalizedTypeName(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return switch (super.getNormalizedTypeName(name2)) {
            case "DEC" -> "DECIMAL";
            case "INT" -> "INTEGER";
            case "OBJECT" -> "OTHER";
            case "FLOAT" -> "DOUBLE";
            case "REAL" -> "DOUBLE";
            case "DOUBLE PRECISION" -> "DOUBLE";
            case "CHAR" -> "CHARACTER";
            case "CHARACTER VARYING" -> "VARCHAR";
            case "CHAR VARYING" -> "VARCHAR";
            case "CHARACTER LARGE OBJECT" -> "CLOB";
            case "CHAR LARGE OBJECT" -> "CLOB";
            case "VARCHAR_IGNORECASE" -> "VARCHAR";
            case "LONGVARCHAR" -> "VARCHAR";
            case "BINARY VARYING" -> "VARBINARY";
            case "BINARY LARGE OBJECT" -> "BLOB";
            case "LONGVARBINARY" -> "VARBINARY";
            case "DATETIME" -> "TIMESTAMP";
            default -> {
                void var2_2;
                yield var2_2;
            }
        };
    }

    @Override
    @Nullable
    public String getDefaultTypeName(@NotNull DasTypeCategory cat) {
        Intrinsics.checkNotNullParameter((Object)((Object)cat), (String)"cat");
        return switch (WhenMappings.$EnumSwitchMapping$0[cat.ordinal()]) {
            case 1 -> "integer";
            case 2 -> "numeric";
            case 3 -> "varchar";
            case 4 -> "boolean";
            case 5 -> "datetime";
            case 6 -> "date";
            case 7 -> "time";
            case 8 -> "timestamp";
            case 9 -> "interval";
            case 10 -> "blob";
            default -> null;
        };
    }

    @Override
    @NotNull
    public DasTypeCategory getTypeCategoryByName(@NotNull String typeName) {
        Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
        return switch (typeName) {
            case "CLOB" -> DasTypeCategory.STRING;
            case "BLOB" -> DasTypeCategory.BYTES;
            case "BIT VARYING" -> DasTypeCategory.INTEGER;
            default -> super.getTypeCategoryByName(typeName);
        };
    }

    @Override
    @NotNull
    protected HsqlArrayType doCreateArrayType(@NotNull DasType componentType) {
        Intrinsics.checkNotNullParameter((Object)componentType, (String)"componentType");
        return new HsqlArrayType(componentType);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DasTypeCategory.values().length];
            try {
                nArray[DasTypeCategory.INTEGER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.REAL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.STRING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.BOOLEAN.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.DATE_TIME.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.DATE.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.TIME.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.TIMESTAMP.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.INTERVAL.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.BYTES.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

