/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.h2.introspector;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.base.introspector.BaseIntrospectionFunctions;
import com.intellij.database.dialects.base.introspector.BaseIntrospector;
import com.intellij.database.dialects.base.introspector.BaseMultiDatabaseIntrospector;
import com.intellij.database.dialects.base.introspector.BaseNativeIntrospector;
import com.intellij.database.dialects.base.introspector.NameCache;
import com.intellij.database.dialects.h2.introspector.H2IntroQueries;
import com.intellij.database.dialects.h2.introspector.H2Introspector;
import com.intellij.database.dialects.h2.introspector.H2IntrospectorKt;
import com.intellij.database.dialects.h2.model.H2Aggregate;
import com.intellij.database.dialects.h2.model.H2Argument;
import com.intellij.database.dialects.h2.model.H2Check;
import com.intellij.database.dialects.h2.model.H2Constant;
import com.intellij.database.dialects.h2.model.H2Constraint;
import com.intellij.database.dialects.h2.model.H2Database;
import com.intellij.database.dialects.h2.model.H2Domain;
import com.intellij.database.dialects.h2.model.H2ForeignKey;
import com.intellij.database.dialects.h2.model.H2Index;
import com.intellij.database.dialects.h2.model.H2Key;
import com.intellij.database.dialects.h2.model.H2LikeRoutine;
import com.intellij.database.dialects.h2.model.H2LikeTable;
import com.intellij.database.dialects.h2.model.H2Role;
import com.intellij.database.dialects.h2.model.H2Root;
import com.intellij.database.dialects.h2.model.H2Routine;
import com.intellij.database.dialects.h2.model.H2Schema;
import com.intellij.database.dialects.h2.model.H2Sequence;
import com.intellij.database.dialects.h2.model.H2Synonym;
import com.intellij.database.dialects.h2.model.H2Table;
import com.intellij.database.dialects.h2.model.H2TableColumn;
import com.intellij.database.dialects.h2.model.H2Trigger;
import com.intellij.database.dialects.h2.model.H2User;
import com.intellij.database.dialects.h2.model.H2View;
import com.intellij.database.introspection.DBIntrospectionContext;
import com.intellij.database.introspection.DBIntrospector;
import com.intellij.database.layoutedQueries.DBTransaction;
import com.intellij.database.model.ArgumentDirection;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PerObjectVersion;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.basic.BasicDataObject;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModArgument;
import com.intellij.database.model.basic.BasicModMateDatabase;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModSchema;
import com.intellij.database.model.basic.BasicModTableOrViewColumn;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.families.NamingFamily;
import com.intellij.database.model.meta.BasicMetaUtils;
import com.intellij.database.model.properties.BasicReference;
import com.intellij.database.model.properties.CascadeRule;
import com.intellij.database.model.properties.ColumnKind;
import com.intellij.database.model.properties.CompositeText;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.model.properties.references.BasicInlineObjectReference;
import com.intellij.database.model.properties.references.BasicKeyByIndexReference;
import com.intellij.database.model.properties.references.BasicNameReference;
import com.intellij.database.model.properties.references.BasicParentReference;
import com.intellij.database.remote.jdba.exceptions.DBException;
import com.intellij.database.script.SimpleCompositeText;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeSystemBase;
import com.intellij.database.types.DasTypeSystems;
import com.intellij.database.types.DasTypeUtilsKt;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.JdbcUtil;
import com.intellij.database.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.h2.H2Dialect;
import com.intellij.sql.dialects.h2.H2Lexer;
import com.intellij.sql.dialects.h2.psi.H2OnUpdateClause;
import com.intellij.sql.psi.SqlCompositeElement;
import com.intellij.sql.psi.SqlConstraintDefinition;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlIdentifierKeywordTokenType;
import com.intellij.sql.psi.SqlKeywordTokenType;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlTypeElement;
import com.intellij.sql.psi.impl.SqlColumnGeneratedClause;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.util.SmartList;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.text.StringKt;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001:\u0004-./0B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ&\u0010\u0014\u001a \u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0015R\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001H\u0014J4\u0010\u0016\u001a\u001e\u0012\u0004\u0012\u00020\u00030\u0017R\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00012\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0003H\u0014J4\u0010\u001b\u001a\u001e\u0012\u0004\u0012\u00020\u00040\u001cR\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u001d2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u0004H\u0014J\"\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010#\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020\u000bH\u0002J*\u0010%\u001a\u00020 2\u0006\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010'2\u0006\u0010#\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020\u000bH\u0002J\u0014\u0010)\u001a\u00020\u000b*\u00020\u000b2\u0006\u0010*\u001a\u00020\u000bH\u0002J\u0014\u0010+\u001a\u00020\u000b*\u00020\u000b2\u0006\u0010*\u001a\u00020\u000bH\u0002J\u000e\u0010,\u001a\u0004\u0018\u00010'*\u00020\"H\u0002R\u0014\u0010\n\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0010R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/intellij/database/dialects/h2/introspector/H2Introspector;", "Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector;", "Lcom/intellij/database/dialects/h2/model/H2Root;", "Lcom/intellij/database/dialects/h2/model/H2Database;", "Lcom/intellij/database/dialects/h2/model/H2Schema;", "context", "Lcom/intellij/database/introspection/DBIntrospectionContext;", "modelFactory", "Lcom/intellij/database/model/ModelFactory;", "(Lcom/intellij/database/introspection/DBIntrospectionContext;Lcom/intellij/database/model/ModelFactory;)V", "defaultVarDataMaxLength", "", "getDefaultVarDataMaxLength", "()I", "isNewSchema", "", "()Z", "isV2", "typeSystem", "Lcom/intellij/database/types/DasTypeSystemBase;", "createDatabaseLister", "Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector$DatabaseLister;", "createDatabaseRetriever", "Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector$BaseDatabaseRetriever;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "database", "createSchemaRetriever", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractSchemaRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector;", "schema", "getDasType", "Lcom/intellij/database/types/DasType;", "typeName", "", "precision", "scale", "getIntervalDasType", "primary", "Lcom/intellij/database/dialects/h2/introspector/H2Introspector$Interval;", "secondary", "maskDefaultPrecision", "default", "maskDefaultScale", "toIntervalKind", "Factory", "H2DatabaseBaseDatabaseRetriever", "H2SchemaAbstractSchemaRetriever", "Interval", "intellij.database.dialects.h2"})
public final class H2Introspector
extends BaseMultiDatabaseIntrospector<H2Root, H2Database, H2Schema> {
    @NotNull
    private final DasTypeSystemBase typeSystem;

    public H2Introspector(@NotNull DBIntrospectionContext context, @NotNull ModelFactory modelFactory) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)modelFactory, (String)"modelFactory");
        BaseIntrospector.Nature nature = BaseIntrospector.DefaultNature.INSTANCE;
        Dbms dbms = Dbms.H2;
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"H2");
        super(context, nature, dbms, modelFactory);
        this.typeSystem = DasTypeSystems.getTypeSystem(this.dbms);
    }

    @Override
    @NotNull
    protected BaseMultiDatabaseIntrospector.DatabaseLister<?, ?> createDatabaseLister() {
        return new BaseMultiDatabaseIntrospector.DatabaseLister<H2IntroQueries.DbInfo, H2Database>(this){
            final /* synthetic */ H2Introspector this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            protected List<H2IntroQueries.DbInfo> listDatabases(@NotNull DBTransaction tran) {
                Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
                return H2IntroQueries.INSTANCE.retrieveDatabases(tran, H2Introspector.access$isNewSchema(this.this$0));
            }

            @NotNull
            protected H2Database applyDatabase(@NotNull ModNamingFamily<?> databases2, @NotNull H2IntroQueries.DbInfo db) {
                Intrinsics.checkNotNullParameter(databases2, (String)"databases");
                Intrinsics.checkNotNullParameter((Object)db, (String)"db");
                return (H2Database)this.renew(databases2, db.catalog_name);
            }
        };
    }

    @Override
    @NotNull
    protected BaseMultiDatabaseIntrospector.BaseDatabaseRetriever<H2Database> createDatabaseRetriever(@NotNull DBTransaction transaction, @NotNull H2Database database) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        return new H2DatabaseBaseDatabaseRetriever(transaction, database);
    }

    @Override
    @NotNull
    protected BaseNativeIntrospector.AbstractSchemaRetriever<H2Schema> createSchemaRetriever(@NotNull DBTransaction transaction, @NotNull H2Schema schema2) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)schema2, (String)"schema");
        return new H2SchemaAbstractSchemaRetriever(transaction, schema2);
    }

    private final int maskDefaultPrecision(int $this$maskDefaultPrecision, int n) {
        return $this$maskDefaultPrecision != n ? $this$maskDefaultPrecision : -1;
    }

    private final int maskDefaultScale(int $this$maskDefaultScale, int n) {
        return $this$maskDefaultScale != n ? $this$maskDefaultScale : 0;
    }

    private final DasType getIntervalDasType(Interval primary, Interval secondary, int precision, int scale) {
        StringBuilder stringBuilder;
        int actualScale = (primary == Interval.SECOND || secondary == Interval.SECOND) && scale != 6 ? scale : 0;
        int actualPrecision = precision != 2 || actualScale != 0 && secondary == null ? precision : 0;
        StringBuilder $this$getIntervalDasType_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$getIntervalDasType_u24lambda_u240.append("INTERVAL " + primary.name());
        if (actualPrecision != 0) {
            $this$getIntervalDasType_u24lambda_u240.append("(" + actualPrecision);
            if (actualScale != 0 && secondary == null) {
                $this$getIntervalDasType_u24lambda_u240.append(", " + actualScale);
            }
            $this$getIntervalDasType_u24lambda_u240.append(")");
        }
        if (secondary != null) {
            $this$getIntervalDasType_u24lambda_u240.append(" TO " + secondary.name());
            if (actualScale != 0) {
                $this$getIntervalDasType_u24lambda_u240.append("(" + actualScale + ")");
            }
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String spec2 = string;
        DataType dataType = DataTypeFactory.of(spec2);
        Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"of(...)");
        DataType dataType2 = dataType;
        return this.typeSystem.createDasType(dataType2);
    }

    private final Interval toIntervalKind(String $this$toIntervalKind) {
        Interval interval;
        try {
            interval = Interval.valueOf($this$toIntervalKind);
        }
        catch (Exception e2) {
            interval = null;
        }
        return interval;
    }

    private final DasType getDasType(String typeName, int precision, int scale) {
        CharSequence charSequence = typeName;
        if (charSequence == null || charSequence.length() == 0) {
            return DasTypeSystemBase.UNKNOWN;
        }
        if (StringsKt.startsWith$default((String)typeName, (String)"INTERVAL", (boolean)false, (int)2, null)) {
            char[] cArray = new char[]{' '};
            List components = StringsKt.split$default((CharSequence)typeName, (char[])cArray, (boolean)false, (int)0, (int)6, null);
            Object object = (String)CollectionsKt.getOrNull((List)components, (int)1);
            if (object == null || (object = this.toIntervalKind((String)object)) == null) {
                return DasTypeSystemBase.UNKNOWN;
            }
            Object primaryKind = object;
            String string = (String)CollectionsKt.getOrNull((List)components, (int)3);
            Interval secondaryKind = string != null ? this.toIntervalKind(string) : null;
            return this.getIntervalDasType((Interval)((Object)primaryKind), secondaryKind, precision, scale);
        }
        int[] primaryKind = new int[]{1, 4, 197};
        int timestampDefaultPrecision = this.getServerVersion().isOrGreater(primaryKind) ? 6 : 10;
        int actualPrecision = 0;
        int actualScale = 0;
        String suffix2 = "";
        String actualTypeName = typeName;
        switch (typeName) {
            case "DECIMAL": 
            case "NUMBER": 
            case "NUMERIC": 
            case "DEC": {
                if (this.isV2()) {
                    actualScale = this.maskDefaultScale(scale, 0);
                    actualPrecision = actualScale != 0 ? precision : this.maskDefaultPrecision(precision, 100000);
                    break;
                }
                actualScale = this.maskDefaultScale(scale, Short.MAX_VALUE);
                actualPrecision = actualScale != 0 ? precision : this.maskDefaultPrecision(precision, 65535);
                break;
            }
            case "DECFLOAT": {
                actualPrecision = this.maskDefaultPrecision(precision, 100000);
                break;
            }
            case "TIME": {
                actualPrecision = this.maskDefaultPrecision(this.isV2() ? precision : scale, 0);
                break;
            }
            case "TIMESTAMP": 
            case "DATETIME": {
                actualPrecision = this.maskDefaultPrecision(this.isV2() ? precision : scale, timestampDefaultPrecision);
                break;
            }
            case "TIMESTAMP WITH TIME ZONE": {
                actualPrecision = this.maskDefaultPrecision(this.isV2() ? precision : scale, timestampDefaultPrecision);
                actualTypeName = "TIMESTAMP";
                suffix2 = "WITH TIME ZONE";
                break;
            }
            case "TIME WITH TIME ZONE": {
                actualPrecision = this.maskDefaultPrecision(this.isV2() ? precision : scale, 0);
                actualTypeName = "TIME";
                suffix2 = "WITH TIME ZONE";
                break;
            }
            case "DOUBLE PRECISION": 
            case "DOUBLE": 
            case "TINYINT": 
            case "INTEGER": 
            case "NULL": 
            case "BIGINT": 
            case "BOOLEAN": 
            case "DATE": 
            case "SMALLINT": 
            case "REAL": {
                actualPrecision = -1;
                break;
            }
            case "VARCHAR_IGNORECASE": 
            case "JSON": 
            case "BINARY VARYING": 
            case "JAVA_OBJECT": 
            case "CHARACTER VARYING": {
                actualPrecision = this.maskDefaultPrecision(precision, this.getDefaultVarDataMaxLength());
                break;
            }
            case "CHARACTER": {
                actualPrecision = this.maskDefaultPrecision(precision, 1);
                break;
            }
            case "BLOB": 
            case "CHAR": 
            case "BINARY LARGE OBJECT": 
            case "CLOB": 
            case "CHARACTER LARGE OBJECT": 
            case "VARCHAR": {
                actualPrecision = this.maskDefaultPrecision(precision, Integer.MAX_VALUE);
                break;
            }
            default: {
                actualPrecision = this.maskDefaultPrecision(precision, 0);
            }
        }
        DataType dataType = DataTypeFactory.of(null, actualTypeName, actualPrecision, actualScale, null, suffix2, false, false);
        Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"of(...)");
        DataType dataType2 = dataType;
        return this.typeSystem.createDasType(dataType2);
    }

    private final boolean isV2() {
        int[] nArray = new int[]{2};
        return this.getServerVersion().isOrGreater(nArray);
    }

    private final boolean isNewSchema() {
        Object object;
        return this.isV2() && !Intrinsics.areEqual((object = this.getDbConnection()) != null && (object = object.getConnectionPoint()) != null && (object = object.getConnectionProperties()) != null ? ((Properties)object).getProperty("OLD_INFORMATION_SCHEMA") : null, (Object)"true");
    }

    private final int getDefaultVarDataMaxLength() {
        int[] nArray = new int[]{2, 2};
        return this.getServerVersion().isOrGreater(nArray) ? 1000000000 : 0x100000;
    }

    public static final /* synthetic */ int access$maskDefaultPrecision(H2Introspector $this, int $receiver, int n) {
        return $this.maskDefaultPrecision($receiver, n);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0016\u00a8\u0006\u0017"}, d2={"Lcom/intellij/database/dialects/h2/introspector/H2Introspector$Factory;", "Lcom/intellij/database/introspection/DBIntrospector$Factory;", "()V", "createIntrospector", "Lcom/intellij/database/dialects/h2/introspector/H2Introspector;", "context", "Lcom/intellij/database/introspection/DBIntrospectionContext;", "dbms", "Lcom/intellij/database/Dbms;", "modelFactory", "Lcom/intellij/database/model/ModelFactory;", "getVersion", "", "kind", "Lcom/intellij/database/model/ObjectKind;", "isOutdatedCheckSupported", "", "e", "Lcom/intellij/database/model/basic/BasicElement;", "isSupported", "version", "Lcom/intellij/database/util/Version;", "VERSION", "intellij.database.dialects.h2"})
    public static final class Factory
    implements DBIntrospector.Factory {
        @Override
        public boolean isSupported(@NotNull Version version) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            int[] nArray = new int[]{1, 4, 196};
            return version.isOrGreater(nArray);
        }

        @Override
        @NotNull
        public H2Introspector createIntrospector(@NotNull DBIntrospectionContext context, @NotNull Dbms dbms, @NotNull ModelFactory modelFactory) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
            Intrinsics.checkNotNullParameter((Object)modelFactory, (String)"modelFactory");
            return new H2Introspector(context, modelFactory);
        }

        @Override
        public int getVersion(@NotNull ObjectKind kind) {
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            return VERSION.INSTANCE.get(kind);
        }

        @Override
        public boolean isOutdatedCheckSupported(@Nullable BasicElement e2) {
            return false;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/database/dialects/h2/introspector/H2Introspector$Factory$VERSION;", "Lcom/intellij/database/model/PerObjectVersion;", "()V", "intellij.database.dialects.h2"})
        public static final class VERSION
        extends PerObjectVersion {
            @NotNull
            public static final VERSION INSTANCE = new VERSION();

            private VERSION() {
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0082\u0004\u0018\u00002\u001e\u0012\u0004\u0012\u00020\u00020\u0001R\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00050\u0003B\u0015\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0002J\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0002J\b\u0010\u000e\u001a\u00020\u000bH\u0016J\b\u0010\u000f\u001a\u00020\u000bH\u0016J\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0002\u00a8\u0006\u0011"}, d2={"Lcom/intellij/database/dialects/h2/introspector/H2Introspector$H2DatabaseBaseDatabaseRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector$BaseDatabaseRetriever;", "Lcom/intellij/database/dialects/h2/model/H2Database;", "Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector;", "Lcom/intellij/database/dialects/h2/model/H2Root;", "Lcom/intellij/database/dialects/h2/model/H2Schema;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "database", "(Lcom/intellij/database/dialects/h2/introspector/H2Introspector;Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/h2/model/H2Database;)V", "retrieveCollations", "", "db", "retrieveRoles", "retrieveSchemas", "retrieveServerAndDatabaseObjects", "retrieveUsers", "intellij.database.dialects.h2"})
    @SourceDebugExtension(value={"SMAP\nH2Introspector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 H2Introspector.kt\ncom/intellij/database/dialects/h2/introspector/H2Introspector$H2DatabaseBaseDatabaseRetriever\n+ 2 BaseIntrospectionFunctions.kt\ncom/intellij/database/dialects/base/introspector/BaseIntrospectionFunctions\n+ 3 BaseNativeIntrospector.kt\ncom/intellij/database/dialects/base/introspector/BaseNativeIntrospector\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1022:1\n181#2,4:1023\n185#2,3:1034\n181#2,4:1037\n185#2,3:1048\n181#2,4:1051\n185#2,3:1063\n619#3,7:1027\n619#3,7:1041\n619#3,2:1055\n622#3,4:1059\n1855#4,2:1057\n*S KotlinDebug\n*F\n+ 1 H2Introspector.kt\ncom/intellij/database/dialects/h2/introspector/H2Introspector$H2DatabaseBaseDatabaseRetriever\n*L\n97#1:1023,4\n97#1:1034,3\n111#1:1037,4\n111#1:1048,3\n124#1:1051,4\n124#1:1063,3\n98#1:1027,7\n112#1:1041,7\n125#1:1055,2\n125#1:1059,4\n126#1:1057,2\n*E\n"})
    private final class H2DatabaseBaseDatabaseRetriever
    extends BaseMultiDatabaseIntrospector.BaseDatabaseRetriever<H2Database> {
        public H2DatabaseBaseDatabaseRetriever(@NotNull DBTransaction transaction, H2Database database) {
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            Intrinsics.checkNotNullParameter((Object)database, (String)"database");
            super((BaseMultiDatabaseIntrospector)H2Introspector.this, transaction, (BasicModMateDatabase)database);
        }

        @Override
        public void retrieveSchemas() {
            super.retrieveSchemas();
            List<H2IntroQueries.SchemaInfo> schemaInfos2 = H2IntroQueries.INSTANCE.retrieveSchemas(this.getTransaction(), H2Introspector.this.isNewSchema());
            this.inDatabase((Function1)new Function1<H2Database, Unit>(schemaInfos2){
                final /* synthetic */ List<H2IntroQueries.SchemaInfo> $schemaInfos;
                {
                    this.$schemaInfos = $schemaInfos;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull H2Database db) {
                    void $this$applySchemasImpl$iv;
                    Intrinsics.checkNotNullParameter((Object)db, (String)"db");
                    NamingFamily namingFamily = db.getSchemas();
                    Intrinsics.checkNotNullExpressionValue((Object)namingFamily, (String)"getSchemas(...)");
                    NamingFamily namingFamily2 = namingFamily;
                    List<H2IntroQueries.SchemaInfo> scs$iv = this.$schemaInfos;
                    boolean $i$f$applySchemasImpl = false;
                    $this$applySchemasImpl$iv.markChildrenAsSyncPending();
                    Iterable $this$forEach$iv$iv = scs$iv;
                    boolean $i$f$forEach = false;
                    Iterator<T> iterator = $this$forEach$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        void info2;
                        T element$iv$iv;
                        T sc$iv = element$iv$iv = iterator.next();
                        boolean bl = false;
                        H2IntroQueries.SchemaInfo schemaInfo = (H2IntroQueries.SchemaInfo)sc$iv;
                        void $this$invoke_u24lambda_u241 = $this$applySchemasImpl$iv;
                        boolean bl2 = false;
                        E e2 = db.getSchemas().createOrGet(info2.schema_name);
                        H2Schema $this$invoke_u24lambda_u241_u24lambda_u240 = (H2Schema)e2;
                        boolean bl3 = false;
                        $this$invoke_u24lambda_u241_u24lambda_u240.setComment(info2.remarks);
                        $this$invoke_u24lambda_u241_u24lambda_u240.setCurrent(info2.is_default);
                    }
                    $this$applySchemasImpl$iv.removeSyncPendingChildren();
                    $this$applySchemasImpl$iv.sort();
                }
            });
        }

        @Override
        public void retrieveServerAndDatabaseObjects() {
            super.retrieveServerAndDatabaseObjects();
            this.inDatabase((Function1)new Function1<H2Database, Unit>(this){
                final /* synthetic */ H2DatabaseBaseDatabaseRetriever this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull H2Database db) {
                    Intrinsics.checkNotNullParameter((Object)db, (String)"db");
                    H2DatabaseBaseDatabaseRetriever.access$retrieveUsers(this.this$0, db);
                    H2DatabaseBaseDatabaseRetriever.access$retrieveRoles(this.this$0, db);
                    H2DatabaseBaseDatabaseRetriever.access$retrieveCollations(this.this$0, db);
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveUsers(H2Database db) {
            void $this$modifyAndCleanup_u24default$iv;
            ObjectKind objectKind = ObjectKind.USER;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"USER");
            H2Introspector.this.reportRetrieving(objectKind);
            ModFamily modFamily = db.getUsers();
            H2Introspector h2Introspector = H2Introspector.this;
            boolean inc$iv = true;
            boolean $i$f$modifyAndCleanup = false;
            $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
            ModNamingFamily users = (ModNamingFamily)$this$modifyAndCleanup_u24default$iv;
            boolean bl = false;
            BaseNativeIntrospector this_$iv = h2Introspector;
            boolean $i$f$continueOnDbError = false;
            try {
                boolean bl2 = false;
                H2IntroQueries.INSTANCE.processUsers(this.getTransaction(), h2Introspector.isNewSchema(), (Function1<? super H2IntroQueries.UserInfo, Unit>)((Function1)new Function1<H2IntroQueries.UserInfo, Unit>((ModNamingFamily<? extends H2User>)users){
                    final /* synthetic */ ModNamingFamily<? extends H2User> $users;
                    {
                        this.$users = $users;
                        super(1);
                    }

                    public final void invoke(@NotNull H2IntroQueries.UserInfo info2) {
                        H2User h2User;
                        Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
                        H2User $this$invoke_u24lambda_u240 = h2User = this.$users.createOrGet(info2.name);
                        boolean bl = false;
                        $this$invoke_u24lambda_u240.setAdmin(info2.is_admin);
                        $this$invoke_u24lambda_u240.setComment(info2.remarks);
                    }
                }));
            }
            catch (DBException e$iv) {
                this_$iv.getErrorSink().consume(null, (Object)e$iv);
            }
            $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
            $this$modifyAndCleanup_u24default$iv.sort();
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveRoles(H2Database db) {
            void $this$modifyAndCleanup_u24default$iv;
            ObjectKind objectKind = ObjectKind.ROLE;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"ROLE");
            H2Introspector.this.reportRetrieving(objectKind);
            ModFamily modFamily = db.getRoles();
            H2Introspector h2Introspector = H2Introspector.this;
            boolean inc$iv = true;
            boolean $i$f$modifyAndCleanup = false;
            $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
            ModNamingFamily roles = (ModNamingFamily)$this$modifyAndCleanup_u24default$iv;
            boolean bl = false;
            BaseNativeIntrospector this_$iv = h2Introspector;
            boolean $i$f$continueOnDbError = false;
            try {
                boolean bl2 = false;
                H2IntroQueries.INSTANCE.processRoles(this.getTransaction(), h2Introspector.isNewSchema(), (Function1<? super H2IntroQueries.RoleInfo, Unit>)((Function1)new Function1<H2IntroQueries.RoleInfo, Unit>((ModNamingFamily<? extends H2Role>)roles){
                    final /* synthetic */ ModNamingFamily<? extends H2Role> $roles;
                    {
                        this.$roles = $roles;
                        super(1);
                    }

                    public final void invoke(@NotNull H2IntroQueries.RoleInfo info2) {
                        H2Role h2Role;
                        Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
                        H2Role $this$invoke_u24lambda_u240 = h2Role = this.$roles.createOrGet(info2.name);
                        boolean bl = false;
                        $this$invoke_u24lambda_u240.setComment(info2.remarks);
                    }
                }));
            }
            catch (DBException e$iv) {
                this_$iv.getErrorSink().consume(null, (Object)e$iv);
            }
            $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
            $this$modifyAndCleanup_u24default$iv.sort();
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveCollations(H2Database db) {
            void $this$modifyAndCleanup_u24default$iv;
            ObjectKind objectKind = ObjectKind.COLLATION;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"COLLATION");
            H2Introspector.this.reportRetrieving(objectKind);
            ModFamily modFamily = db.getCollations();
            H2Introspector h2Introspector = H2Introspector.this;
            boolean inc$iv = true;
            boolean $i$f$modifyAndCleanup = false;
            $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
            ModNamingFamily collations = (ModNamingFamily)$this$modifyAndCleanup_u24default$iv;
            boolean bl = false;
            BaseNativeIntrospector this_$iv = h2Introspector;
            boolean $i$f$continueOnDbError = false;
            try {
                boolean bl2 = false;
                Iterable $this$forEach$iv = H2IntroQueries.INSTANCE.retrieveCollations(this.getTransaction(), h2Introspector.isNewSchema());
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String it2 = (String)element$iv;
                    boolean bl3 = false;
                    collations.createOrGet(it2);
                }
            }
            catch (DBException e$iv) {
                this_$iv.getErrorSink().consume(null, (Object)e$iv);
            }
            $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
            $this$modifyAndCleanup_u24default$iv.sort();
        }

        public static final /* synthetic */ void access$retrieveUsers(H2DatabaseBaseDatabaseRetriever $this, H2Database db) {
            $this.retrieveUsers(db);
        }

        public static final /* synthetic */ void access$retrieveRoles(H2DatabaseBaseDatabaseRetriever $this, H2Database db) {
            $this.retrieveRoles(db);
        }

        public static final /* synthetic */ void access$retrieveCollations(H2DatabaseBaseDatabaseRetriever $this, H2Database db) {
            $this.retrieveCollations(db);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00ae\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001c\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u001e\u0012\u0004\u0012\u00020\u00020\u0001R\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00020\u0003B\u0015\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\tJ \u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 H\u0002J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\fH\u0002J\u0018\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u0016\u0010(\u001a\b\u0012\u0004\u0012\u00020\f0\u00102\u0006\u0010)\u001a\u00020\fH\u0002J\"\u0010*\u001a\u00020\u001c2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\b\b\u0002\u0010/\u001a\u00020&H\u0002J\u0010\u00100\u001a\u00020\f2\u0006\u0010)\u001a\u00020\fH\u0002JC\u00101\u001a\n 3*\u0004\u0018\u0001H2H2\"\b\b\u0000\u00102*\u0002042\f\u00105\u001a\b\u0012\u0004\u0012\u0002H2062\u0006\u00107\u001a\u00020\f2\f\u00108\u001a\b\u0012\u0004\u0012\u00020\f0\u0010H\u0002\u00a2\u0006\u0002\u00109J\u0010\u0010:\u001a\u00020\u001c2\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0010\u0010;\u001a\u00020\u001c2\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0010\u0010<\u001a\u00020\u001c2\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0010\u0010=\u001a\u00020\u001c2\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0010\u0010>\u001a\u00020\u001c2\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0010\u0010?\u001a\u00020\u001c2\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0010\u0010@\u001a\u00020\u001c2\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0010\u0010A\u001a\u00020\u001c2\u0006\u0010\b\u001a\u00020\u0002H\u0002J\b\u0010B\u001a\u00020\u001cH\u0014J\u0010\u0010C\u001a\u00020\u001c2\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0010\u0010D\u001a\u00020\u001c2\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0010\u0010E\u001a\u00020\u001c2\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0010\u0010F\u001a\u00020\u001c2\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0010\u0010G\u001a\u00020\u001c2\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0010\u0010H\u001a\u00020\u001c2\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0010\u0010I\u001a\u00020\u001c2\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0010\u0010J\u001a\u00020\u001c2\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0010\u0010K\u001a\u00020\u001c2\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0010\u0010L\u001a\u00020\u001c2\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u001a\u0010M\u001a\u0004\u0018\u00010\u00152\u0006\u0010N\u001a\u00020&2\u0006\u0010O\u001a\u00020\u0016H\u0002J\u001a\u0010P\u001a\u0004\u0018\u00010\u00152\u0006\u0010N\u001a\u00020&2\u0006\u0010O\u001a\u00020\u0016H\u0002J\f\u0010Q\u001a\u00020\u0016*\u00020.H\u0002J\u0014\u0010R\u001a\u00020S*\u00020\u00162\u0006\u0010T\u001a\u00020&H\u0002J\u0014\u0010U\u001a\u00020S*\u00020\u00162\u0006\u0010T\u001a\u00020&H\u0002J\f\u0010V\u001a\u00020\u0016*\u00020WH\u0002J\u000e\u0010X\u001a\u0004\u0018\u00010\f*\u00020YH\u0002J\u000e\u0010Z\u001a\u0004\u0018\u00010\f*\u00020YH\u0002J\f\u0010[\u001a\u00020\\*\u00020\fH\u0002R*\u0010\n\u001a\u001e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bj\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R6\u0010\u000f\u001a*\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u00100\u000bj\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u0010`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0014\u001a\u00020\u0015*\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0018\u0010\u0019\u001a\u00020\u0015*\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0018\u00a8\u0006]"}, d2={"Lcom/intellij/database/dialects/h2/introspector/H2Introspector$H2SchemaAbstractSchemaRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractSchemaRetriever;", "Lcom/intellij/database/dialects/h2/model/H2Schema;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector;", "Lcom/intellij/database/dialects/h2/model/H2Root;", "Lcom/intellij/database/dialects/h2/model/H2Database;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "schema", "(Lcom/intellij/database/dialects/h2/introspector/H2Introspector;Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/h2/model/H2Schema;)V", "arrayElementTypes", "Ljava/util/HashMap;", "", "Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$ArrayElementInfo;", "Lkotlin/collections/HashMap;", "enumValues", "", "rowFields", "Lcom/intellij/util/containers/MultiMap;", "Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$RowFieldInfo;", "lowerBound", "Ljava/math/BigInteger;", "Lcom/intellij/database/types/DasType;", "getLowerBound", "(Lcom/intellij/database/types/DasType;)Ljava/math/BigInteger;", "upperBound", "getUpperBound", "applyIndexColumns", "", "index", "Lcom/intellij/database/dialects/h2/model/H2Index;", "columns", "", "Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$IndexColumnInfo;", "getCascadeRule", "Lcom/intellij/database/model/properties/CascadeRule;", "code", "isPossibleToIntrospectSchemaIncrementally", "", "tran", "parseColumnList", "s", "processSequenceLike", "sequence", "Lcom/intellij/database/dialects/h2/model/H2Sequence;", "info", "Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$SequenceLikeInfo;", "isIdentity", "removeParens", "renewConstraint", "C", "kotlin.jvm.PlatformType", "Lcom/intellij/database/dialects/h2/model/H2Constraint;", "family", "Lcom/intellij/database/model/families/ModNamingFamily;", "constraintName", "colNames", "(Lcom/intellij/database/model/families/ModNamingFamily;Ljava/lang/String;Ljava/util/List;)Lcom/intellij/database/dialects/h2/model/H2Constraint;", "retrieveArrayTypes", "retrieveColumns", "retrieveConstants", "retrieveConstraints", "retrieveDomainChecks", "retrieveDomains", "retrieveEnumValues", "retrieveIndexes", "retrieveMainContent", "retrieveRoutines", "retrieveRoutinesV2", "retrieveRowFields", "retrieveSequences", "retrieveSourcesV2", "retrieveSynonyms", "retrieveTables", "retrieveTriggerSources", "retrieveTriggers", "retrieveViewSources", "sequenceUnlimitedMaximumDefault", "isAsc", "type", "sequenceUnlimitedMinimumDefault", "dasType", "decimalLowerBound", "", "exclusive", "decimalUpperBound", "getDasType", "Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$TypedObjectInfo;", "javaClassName", "Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$RoutineInfoV2;", "javaMethodName", "toCompositeText", "Lcom/intellij/database/script/SimpleCompositeText;", "intellij.database.dialects.h2"})
    @SourceDebugExtension(value={"SMAP\nH2Introspector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 H2Introspector.kt\ncom/intellij/database/dialects/h2/introspector/H2Introspector$H2SchemaAbstractSchemaRetriever\n+ 2 BaseNativeIntrospector.kt\ncom/intellij/database/dialects/base/introspector/BaseNativeIntrospector\n+ 3 BaseIntrospectionFunctions.kt\ncom/intellij/database/dialects/base/introspector/BaseIntrospectionFunctions\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1022:1\n619#2,7:1023\n619#2,7:1030\n619#2,7:1037\n619#2,7:1048\n619#2,7:1074\n619#2,7:1094\n619#2,7:1122\n619#2,7:1153\n619#2,7:1185\n619#2,7:1224\n619#2,7:1241\n619#2,7:1261\n619#2,7:1289\n619#2,2:1309\n622#2,4:1315\n619#2,2:1340\n622#2,4:1344\n619#2,7:1358\n619#2,7:1372\n181#3,4:1044\n185#3,3:1055\n221#3,3:1062\n224#3:1067\n199#3,6:1068\n206#3,5:1081\n225#3:1086\n198#3,7:1087\n206#3,5:1101\n221#3,3:1110\n224#3:1115\n199#3,6:1116\n206#3,5:1129\n225#3:1134\n221#3,3:1141\n224#3:1146\n199#3,6:1147\n206#3,5:1160\n225#3:1165\n221#3,3:1173\n224#3:1178\n199#3,6:1179\n206#3,5:1192\n225#3:1197\n221#3,3:1212\n224#3:1217\n199#3,6:1218\n206#3,5:1231\n225#3:1236\n181#3,4:1237\n185#3,3:1248\n198#3,7:1254\n206#3,5:1268\n221#3,3:1277\n224#3:1282\n199#3,6:1283\n206#3,5:1296\n225#3:1301\n198#3,7:1302\n206#3,5:1319\n221#3,3:1328\n224#3:1333\n199#3,6:1334\n206#3,5:1348\n225#3:1353\n181#3,4:1354\n185#3,3:1365\n181#3,4:1368\n185#3,3:1379\n1549#4:1058\n1620#4,3:1059\n1549#4:1106\n1620#4,3:1107\n1360#4:1135\n1446#4,5:1136\n1864#4,3:1166\n1549#4:1169\n1620#4,3:1170\n1549#4:1198\n1620#4,3:1199\n1611#4:1202\n1855#4:1203\n1856#4:1206\n1612#4:1207\n1549#4:1208\n1620#4,3:1209\n1789#4,3:1251\n1549#4:1273\n1620#4,3:1274\n1855#4,2:1311\n1855#4,2:1313\n1549#4:1324\n1620#4,3:1325\n1855#4,2:1342\n37#5,2:1065\n37#5,2:1113\n37#5,2:1144\n37#5,2:1176\n37#5,2:1215\n37#5,2:1280\n37#5,2:1331\n1#6:1204\n1#6:1205\n*S KotlinDebug\n*F\n+ 1 H2Introspector.kt\ncom/intellij/database/dialects/h2/introspector/H2Introspector$H2SchemaAbstractSchemaRetriever\n*L\n184#1:1023,7\n193#1:1030,7\n202#1:1037,7\n212#1:1048,7\n229#1:1074,7\n245#1:1094,7\n265#1:1122,7\n322#1:1153,7\n529#1:1185,7\n570#1:1224,7\n588#1:1241,7\n685#1:1261,7\n717#1:1289,7\n737#1:1309,2\n737#1:1315,4\n773#1:1340,2\n773#1:1344,4\n802#1:1358,7\n820#1:1372,7\n211#1:1044,4\n211#1:1055,3\n228#1:1062,3\n228#1:1067\n228#1:1068,6\n228#1:1081,5\n228#1:1086\n244#1:1087,7\n244#1:1101,5\n264#1:1110,3\n264#1:1115\n264#1:1116,6\n264#1:1129,5\n264#1:1134\n321#1:1141,3\n321#1:1146\n321#1:1147,6\n321#1:1160,5\n321#1:1165\n528#1:1173,3\n528#1:1178\n528#1:1179,6\n528#1:1192,5\n528#1:1197\n569#1:1212,3\n569#1:1217\n569#1:1218,6\n569#1:1231,5\n569#1:1236\n587#1:1237,4\n587#1:1248,3\n684#1:1254,7\n684#1:1268,5\n716#1:1277,3\n716#1:1282\n716#1:1283,6\n716#1:1296,5\n716#1:1301\n736#1:1302,7\n736#1:1319,5\n772#1:1328,3\n772#1:1333\n772#1:1334,6\n772#1:1348,5\n772#1:1353\n801#1:1354,4\n801#1:1365,3\n819#1:1368,4\n819#1:1379,3\n228#1:1058\n228#1:1059,3\n264#1:1106\n264#1:1107,3\n320#1:1135\n320#1:1136,5\n512#1:1166,3\n528#1:1169\n528#1:1170,3\n560#1:1198\n560#1:1199,3\n561#1:1202\n561#1:1203\n561#1:1206\n561#1:1207\n569#1:1208\n569#1:1209,3\n671#1:1251,3\n716#1:1273\n716#1:1274,3\n738#1:1311,2\n739#1:1313,2\n772#1:1324\n772#1:1325,3\n782#1:1342,2\n228#1:1065,2\n264#1:1113,2\n321#1:1144,2\n528#1:1176,2\n569#1:1215,2\n716#1:1280,2\n772#1:1331,2\n561#1:1205\n*E\n"})
    private final class H2SchemaAbstractSchemaRetriever
    extends BaseNativeIntrospector.AbstractSchemaRetriever<H2Schema> {
        @NotNull
        private final HashMap<String, List<String>> enumValues;
        @NotNull
        private final HashMap<String, H2IntroQueries.ArrayElementInfo> arrayElementTypes;
        @NotNull
        private final MultiMap<String, H2IntroQueries.RowFieldInfo> rowFields;

        public H2SchemaAbstractSchemaRetriever(@NotNull DBTransaction transaction, H2Schema schema2) {
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            Intrinsics.checkNotNullParameter((Object)schema2, (String)"schema");
            super((BaseNativeIntrospector)H2Introspector.this, transaction, (BasicModSchema)schema2);
            this.enumValues = new HashMap();
            this.arrayElementTypes = new HashMap();
            this.rowFields = new MultiMap();
        }

        @Override
        public boolean isPossibleToIntrospectSchemaIncrementally(@NotNull DBTransaction tran, @NotNull H2Schema schema2) {
            Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
            Intrinsics.checkNotNullParameter((Object)schema2, (String)"schema");
            return true;
        }

        @Override
        protected void retrieveMainContent() {
            this.inSchema((Function1)new Function1<H2Schema, Unit>(H2Introspector.this, this){
                final /* synthetic */ H2Introspector this$0;
                final /* synthetic */ H2SchemaAbstractSchemaRetriever this$1;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    super(1);
                }

                public final void invoke(@NotNull H2Schema schema2) {
                    Intrinsics.checkNotNullParameter((Object)schema2, (String)"schema");
                    if (H2Introspector.access$isNewSchema(this.this$0)) {
                        H2SchemaAbstractSchemaRetriever.access$retrieveEnumValues(this.this$1, schema2);
                        H2SchemaAbstractSchemaRetriever.access$retrieveArrayTypes(this.this$1, schema2);
                        H2SchemaAbstractSchemaRetriever.access$retrieveRowFields(this.this$1, schema2);
                    }
                    H2SchemaAbstractSchemaRetriever.access$retrieveSequences(this.this$1, schema2);
                    H2SchemaAbstractSchemaRetriever.access$getModel(this.this$1).writeSources(() -> retrieveMainContent.1.invoke$lambda$0(this.this$1, schema2, this.this$0));
                    H2SchemaAbstractSchemaRetriever.access$retrieveConstraints(this.this$1, schema2);
                    H2SchemaAbstractSchemaRetriever.access$retrieveSynonyms(this.this$1, schema2);
                    if (H2Introspector.access$isNewSchema(this.this$0)) {
                        H2SchemaAbstractSchemaRetriever.access$retrieveSourcesV2(this.this$1, schema2);
                    }
                }

                private static final void invoke$lambda$0(H2SchemaAbstractSchemaRetriever this$0, H2Schema $schema, H2Introspector this$1) {
                    Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                    Intrinsics.checkNotNullParameter((Object)$schema, (String)"$schema");
                    Intrinsics.checkNotNullParameter((Object)this$1, (String)"this$1");
                    H2SchemaAbstractSchemaRetriever.access$retrieveDomains(this$0, $schema);
                    if (H2Introspector.access$isNewSchema(this$1)) {
                        H2SchemaAbstractSchemaRetriever.access$retrieveDomainChecks(this$0, $schema);
                    }
                    H2SchemaAbstractSchemaRetriever.access$retrieveTables(this$0, $schema);
                    H2SchemaAbstractSchemaRetriever.access$retrieveColumns(this$0, $schema);
                    H2SchemaAbstractSchemaRetriever.access$retrieveIndexes(this$0, $schema);
                    H2SchemaAbstractSchemaRetriever.access$retrieveTriggers(this$0, $schema);
                    H2SchemaAbstractSchemaRetriever.access$retrieveConstants(this$0, $schema);
                    if (H2Introspector.access$isNewSchema(this$1)) {
                        H2SchemaAbstractSchemaRetriever.access$retrieveRoutinesV2(this$0, $schema);
                    } else {
                        H2SchemaAbstractSchemaRetriever.access$retrieveRoutines(this$0, $schema);
                    }
                }
            });
        }

        private final SimpleCompositeText toCompositeText(String $this$toCompositeText) {
            return BaseIntrospectionFunctions.toCompositeText(((Object)StringsKt.trim((CharSequence)$this$toCompositeText)).toString(), CompositeText.Kind.DECOMPILED_TEXT);
        }

        private final void retrieveEnumValues(H2Schema schema2) {
            H2Introspector.this.reportRetrieving("enum values", "introspection.retrieve.enums");
            BaseNativeIntrospector this_$iv = H2Introspector.this;
            boolean $i$f$continueOnDbError = false;
            try {
                boolean bl = false;
                H2IntroQueries.INSTANCE.processEnumValues(this.getTransaction(), schema2, (Function1<? super H2IntroQueries.EnumValueInfo, Unit>)((Function1)new Function1<H2IntroQueries.EnumValueInfo, Unit>(this){
                    final /* synthetic */ H2SchemaAbstractSchemaRetriever this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull H2IntroQueries.EnumValueInfo info2) {
                        Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
                        ((Map)H2SchemaAbstractSchemaRetriever.access$getEnumValues$p(this.this$0)).put(info2.enum_identifier, ArraysKt.asList((Object[])info2.enum_values));
                    }
                }));
            }
            catch (DBException e$iv) {
                this_$iv.getErrorSink().consume(null, (Object)e$iv);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveArrayTypes(H2Schema schema2) {
            H2Introspector.this.reportRetrieving("array types", "introspection.retrieve.array.types");
            BaseNativeIntrospector baseNativeIntrospector = H2Introspector.this;
            H2Introspector h2Introspector = H2Introspector.this;
            boolean $i$f$continueOnDbError = false;
            try {
                boolean bl = false;
                H2IntroQueries.INSTANCE.processArrayElements(this.getTransaction(), schema2, h2Introspector.isNewSchema(), (Function1<? super H2IntroQueries.ArrayElementInfo, Unit>)((Function1)new Function1<H2IntroQueries.ArrayElementInfo, Unit>(this){
                    final /* synthetic */ H2SchemaAbstractSchemaRetriever this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull H2IntroQueries.ArrayElementInfo info2) {
                        Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
                        ((Map)H2SchemaAbstractSchemaRetriever.access$getArrayElementTypes$p(this.this$0)).put(info2.collection_type_identifier, info2);
                    }
                }));
            }
            catch (DBException e$iv) {
                void this_$iv;
                this_$iv.getErrorSink().consume(null, (Object)e$iv);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveRowFields(H2Schema schema2) {
            H2Introspector.this.reportRetrieving("row fields", "introspection.retrieve.row.fields");
            BaseNativeIntrospector baseNativeIntrospector = H2Introspector.this;
            H2Introspector h2Introspector = H2Introspector.this;
            boolean $i$f$continueOnDbError = false;
            try {
                boolean bl = false;
                H2IntroQueries.INSTANCE.processRowFields(this.getTransaction(), schema2, h2Introspector.isNewSchema(), (Function1<? super H2IntroQueries.RowFieldInfo, Unit>)((Function1)new Function1<H2IntroQueries.RowFieldInfo, Unit>(this){
                    final /* synthetic */ H2SchemaAbstractSchemaRetriever this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull H2IntroQueries.RowFieldInfo info2) {
                        Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
                        H2SchemaAbstractSchemaRetriever.access$getRowFields$p(this.this$0).putValue((Object)info2.row_identifier, (Object)info2);
                    }
                }));
            }
            catch (DBException e$iv) {
                void this_$iv;
                this_$iv.getErrorSink().consume(null, (Object)e$iv);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveDomains(H2Schema schema2) {
            void $this$modifyAndCleanup_u24default$iv;
            H2Introspector.this.reportRetrieving("domains", "introspection.retrieve.domains");
            ModFamily modFamily = schema2.getDomains();
            H2Introspector h2Introspector = H2Introspector.this;
            boolean inc$iv = true;
            boolean $i$f$modifyAndCleanup = false;
            $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
            ModNamingFamily domains = (ModNamingFamily)$this$modifyAndCleanup_u24default$iv;
            boolean bl = false;
            BaseNativeIntrospector this_$iv = h2Introspector;
            boolean $i$f$continueOnDbError = false;
            try {
                boolean bl2 = false;
                H2IntroQueries.INSTANCE.processDomains(this.getTransaction(), schema2, h2Introspector.isNewSchema(), (Function1<? super H2IntroQueries.DomainInfo, Unit>)((Function1)new Function1<H2IntroQueries.DomainInfo, Unit>((ModNamingFamily<? extends H2Domain>)domains, this){
                    final /* synthetic */ ModNamingFamily<? extends H2Domain> $domains;
                    final /* synthetic */ H2SchemaAbstractSchemaRetriever this$0;
                    {
                        this.$domains = $domains;
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull H2IntroQueries.DomainInfo info2) {
                        Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
                        H2Domain h2Domain = this.$domains.createOrGet(info2.name);
                        H2SchemaAbstractSchemaRetriever h2SchemaAbstractSchemaRetriever = this.this$0;
                        H2Domain $this$invoke_u24lambda_u240 = h2Domain;
                        boolean bl = false;
                        $this$invoke_u24lambda_u240.setDasType(H2SchemaAbstractSchemaRetriever.access$getDasType(h2SchemaAbstractSchemaRetriever, info2));
                        $this$invoke_u24lambda_u240.setDefaultExpression(info2.domain_default);
                        $this$invoke_u24lambda_u240.setOnUpdateExpression(info2.domain_on_update);
                        String string = info2.sql;
                        $this$invoke_u24lambda_u240.setSourceText(string != null ? H2SchemaAbstractSchemaRetriever.access$toCompositeText(h2SchemaAbstractSchemaRetriever, string) : null);
                        $this$invoke_u24lambda_u240.setComment(info2.remarks);
                    }
                }));
            }
            catch (DBException e$iv) {
                this_$iv.getErrorSink().consume(null, (Object)e$iv);
            }
            $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
            $this$modifyAndCleanup_u24default$iv.sort();
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveDomainChecks(H2Schema schema2) {
            void families$iv;
            void $this$mapTo$iv$iv;
            H2Introspector.this.reportRetrieving("domain checks", "introspection.retrieve.domain.checks");
            ModNamingFamily<? extends H2Domain> modNamingFamily = schema2.getDomains();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getDomains(...)");
            Iterable $this$map$iv = modNamingFamily;
            boolean $i$f$map = false;
            Object object = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                H2Domain h2Domain = (H2Domain)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(it2.getChecks());
            }
            $this$map$iv = (List)destination$iv$iv;
            object = H2Introspector.this;
            boolean inc$iv = true;
            boolean $i$f$modifyFamiliesAndCleanup = false;
            void $this$toTypedArray$iv$iv = families$iv;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv$iv = $this$toTypedArray$iv$iv;
            ModFamily[] fs$iv = thisCollection$iv$iv.toArray(new ModNamingFamily[0]);
            ModFamily[] families$iv$iv = Arrays.copyOf(fs$iv, fs$iv.length);
            boolean $i$f$modifyFamiliesAndCleanup2 = false;
            for (ModFamily f$iv$iv : families$iv$iv) {
                f$iv$iv.markChildrenAsSyncPending();
            }
            boolean bl = false;
            BaseNativeIntrospector this_$iv = (BaseNativeIntrospector)object;
            boolean $i$f$continueOnDbError = false;
            try {
                boolean bl2 = false;
                NameCache<H2Domain> domainCache = new NameCache<H2Domain>();
                H2IntroQueries.INSTANCE.processDomainChecks(this.getTransaction(), schema2, (Function1<? super H2IntroQueries.DomainCheckInfo, Unit>)((Function1)new Function1<H2IntroQueries.DomainCheckInfo, Unit>(domainCache, schema2){
                    final /* synthetic */ NameCache<H2Domain> $domainCache;
                    final /* synthetic */ H2Schema $schema;
                    {
                        this.$domainCache = $domainCache;
                        this.$schema = $schema;
                        super(1);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    public final void invoke(@NotNull H2IntroQueries.DomainCheckInfo info) {
                        block3: {
                            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
                            var3_2 = this.$domainCache;
                            var4_3 = info.domain_name;
                            var5_4 = this.$schema;
                            $i$f$get = false;
                            var7_7 = this_$iv;
                            create$iv$iv = false;
                            $i$f$get = false;
                            if (this_$iv$iv.getV() == null) ** GOTO lbl-1000
                            v0 = this_$iv$iv.getV();
                            Intrinsics.checkNotNull(v0);
                            if (Intrinsics.areEqual((Object)v0.getName(), (Object)name$iv)) {
                                v1 = this_$iv$iv.getV();
                            } else lbl-1000:
                            // 2 sources

                            {
                                var10_10 = (Function1)new Function1<ModNamingFamily<? extends T>, T>(create$iv$iv, (String)name$iv){
                                    final /* synthetic */ boolean $create;
                                    final /* synthetic */ String $name;
                                    {
                                        this.$create = $create;
                                        this.$name = $name;
                                        super(1);
                                    }

                                    @Nullable
                                    public final T invoke(@NotNull ModNamingFamily<? extends T> $this$invoke) {
                                        Intrinsics.checkNotNullParameter($this$invoke, (String)"$this$invoke");
                                        return (T)(this.$create ? $this$invoke.createOrGet(this.$name) : (BasicModNamedElement)$this$invoke.get(this.$name));
                                    }
                                };
                                var11_11 = this_$iv$iv;
                                var13_12 = this_$iv$iv;
                                $i$a$-get-H2Introspector$H2SchemaAbstractSchemaRetriever$retrieveDomainChecks$2$1$1$domain$1 = false;
                                v2 = var5_4.getDomains();
                                Intrinsics.checkNotNullExpressionValue(v2, (String)"getDomains(...)");
                                var13_12.setV((BasicModNamedElement)((H2Domain)it.invoke(v2)));
                                v1 = this_$iv$iv.getV();
                            }
                            v3 = (H2Domain)v1;
                            if (v3 == null) {
                                return;
                            }
                            domain = v3;
                            v4 = domain.getChecks().createOrGet(info.constraint_name);
                            if (v4 == null) break block3;
                            $this$invoke_u24lambda_u241 = var3_2 = v4;
                            $i$a$-apply-H2Introspector$H2SchemaAbstractSchemaRetriever$retrieveDomainChecks$2$1$1$1 = false;
                            $this$invoke_u24lambda_u241.setPredicate(info.check_clause);
                            $this$invoke_u24lambda_u241.setNameSurrogate(StringsKt.startsWith$default((String)info.constraint_name, (String)"CONSTRAINT_", (boolean)false, (int)2, null));
                        }
                    }
                }));
            }
            catch (DBException e$iv) {
                this_$iv.getErrorSink().consume(null, (Object)e$iv);
            }
            for (ModFamily f$iv$iv : families$iv$iv) {
                f$iv$iv.removeSyncPendingChildren();
                f$iv$iv.sort();
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveTables(H2Schema schema2) {
            void families$iv;
            ObjectKind objectKind = ObjectKind.TABLE;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"TABLE");
            H2Introspector.this.reportRetrieving(objectKind);
            ModFamily[] modFamilyArray = new ModFamily[2];
            Intrinsics.checkNotNullExpressionValue(schema2.getTables(), (String)"getTables(...)");
            Intrinsics.checkNotNullExpressionValue(schema2.getViews(), (String)"getViews(...)");
            H2Introspector h2Introspector = H2Introspector.this;
            boolean inc$iv = true;
            boolean $i$f$modifyFamiliesAndCleanup = false;
            for (void f$iv : families$iv) {
                f$iv.markChildrenAsSyncPending();
            }
            boolean bl = false;
            BaseNativeIntrospector this_$iv = h2Introspector;
            boolean $i$f$continueOnDbError = false;
            try {
                boolean bl2 = false;
                H2IntroQueries.INSTANCE.processTables(this.getTransaction(), schema2, h2Introspector.isNewSchema(), (Function1<? super H2IntroQueries.TableInfo, Unit>)((Function1)new Function1<H2IntroQueries.TableInfo, Unit>(schema2, this){
                    final /* synthetic */ H2Schema $schema;
                    final /* synthetic */ H2SchemaAbstractSchemaRetriever this$0;
                    {
                        this.$schema = $schema;
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull H2IntroQueries.TableInfo info2) {
                        ModNamingFamily<H2LikeTable> modNamingFamily;
                        Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
                        if (info2.is_view) {
                            ModNamingFamily<? extends H2View> modNamingFamily2 = this.$schema.getViews();
                            modNamingFamily = modNamingFamily2;
                            Intrinsics.checkNotNullExpressionValue(modNamingFamily2, (String)"getViews(...)");
                        } else {
                            ModNamingFamily<? extends H2Table> modNamingFamily3 = this.$schema.getTables();
                            modNamingFamily = modNamingFamily3;
                            Intrinsics.checkNotNullExpressionValue(modNamingFamily3, (String)"getTables(...)");
                        }
                        ModNamingFamily<H2LikeTable> family = modNamingFamily;
                        H2LikeTable h2LikeTable = family.createOrGet(info2.table_name);
                        H2SchemaAbstractSchemaRetriever h2SchemaAbstractSchemaRetriever = this.this$0;
                        H2LikeTable $this$invoke_u24lambda_u240 = h2LikeTable;
                        boolean bl = false;
                        if ($this$invoke_u24lambda_u240 instanceof H2Table) {
                            ((H2Table)$this$invoke_u24lambda_u240).setTemporary(info2.is_temp);
                        }
                        if ($this$invoke_u24lambda_u240 instanceof H2View) {
                            String string = info2.sql;
                            ((H2View)$this$invoke_u24lambda_u240).setSourceText(string != null ? H2SchemaAbstractSchemaRetriever.access$toCompositeText(h2SchemaAbstractSchemaRetriever, string) : null);
                        }
                        $this$invoke_u24lambda_u240.setComment(info2.remarks);
                    }
                }));
            }
            catch (DBException e$iv) {
                this_$iv.getErrorSink().consume(null, (Object)e$iv);
            }
            for (void f$iv : families$iv) {
                f$iv.removeSyncPendingChildren();
                f$iv.sort();
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveColumns(H2Schema schema2) {
            void families$iv;
            H2View it2;
            Collection collection2;
            Iterable $this$mapTo$iv$iv;
            ObjectKind objectKind = ObjectKind.COLUMN;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"COLUMN");
            H2Introspector.this.reportRetrieving(objectKind);
            ModNamingFamily<? extends H2Table> modNamingFamily = schema2.getTables();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getTables(...)");
            Iterable $this$map$iv = modNamingFamily;
            boolean $i$f$map = false;
            Object object = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                H2Table h2Table = (H2Table)item$iv$iv;
                collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(it2.getColumns());
            }
            Collection collection3 = (List)destination$iv$iv;
            ModNamingFamily<? extends H2View> modNamingFamily2 = schema2.getViews();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily2, (String)"getViews(...)");
            $this$map$iv = modNamingFamily2;
            collection2 = collection3;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it2 = (H2View)item$iv$iv;
                Collection collection4 = destination$iv$iv;
                boolean bl = false;
                collection4.add(it2.getColumns());
            }
            $this$map$iv = CollectionsKt.plus((Collection)collection2, (Iterable)((List)destination$iv$iv));
            object = H2Introspector.this;
            boolean inc$iv = true;
            boolean $i$f$modifyFamiliesAndCleanup = false;
            void $this$toTypedArray$iv$iv = families$iv;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv$iv = $this$toTypedArray$iv$iv;
            ModFamily[] fs$iv = thisCollection$iv$iv.toArray(new ModPositioningNamingFamily[0]);
            ModFamily[] families$iv$iv = Arrays.copyOf(fs$iv, fs$iv.length);
            boolean $i$f$modifyFamiliesAndCleanup2 = false;
            for (ModFamily f$iv$iv : families$iv$iv) {
                f$iv$iv.markChildrenAsSyncPending();
            }
            boolean bl = false;
            BaseNativeIntrospector this_$iv = (BaseNativeIntrospector)object;
            boolean $i$f$continueOnDbError = false;
            try {
                boolean bl2 = false;
                NameCache<H2LikeTable> tableCache2 = new NameCache<H2LikeTable>();
                H2IntroQueries.INSTANCE.processColumns(this.getTransaction(), schema2, ((H2Introspector)object).isNewSchema(), (Function1<? super H2IntroQueries.ColumnInfo, Unit>)((Function1)new Function1<H2IntroQueries.ColumnInfo, Unit>(tableCache2, schema2, this, (H2Introspector)object){
                    final /* synthetic */ NameCache<H2LikeTable> $tableCache;
                    final /* synthetic */ H2Schema $schema;
                    final /* synthetic */ H2SchemaAbstractSchemaRetriever this$0;
                    final /* synthetic */ H2Introspector this$1;
                    {
                        this.$tableCache = $tableCache;
                        this.$schema = $schema;
                        this.this$0 = $receiver;
                        this.this$1 = $receiver2;
                        super(1);
                    }

                    /*
                     * Unable to fully structure code
                     * Could not resolve type clashes
                     */
                    public final void invoke(@NotNull H2IntroQueries.ColumnInfo info) {
                        block16: {
                            block18: {
                                block19: {
                                    block15: {
                                        block17: {
                                            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
                                            var4_2 = this.$tableCache;
                                            var5_3 = info.table_name;
                                            var6_4 = this.$schema;
                                            $i$f$get = false;
                                            var8_7 = this_$iv;
                                            create$iv$iv = false;
                                            $i$f$get = false;
                                            if (this_$iv$iv.getV() == null) ** GOTO lbl-1000
                                            v0 = this_$iv$iv.getV();
                                            Intrinsics.checkNotNull(v0);
                                            if (Intrinsics.areEqual((Object)v0.getName(), (Object)name$iv)) {
                                                v1 = this_$iv$iv.getV();
                                            } else lbl-1000:
                                            // 2 sources

                                            {
                                                var11_16 /* !! */  = (Function1)new Function1<ModNamingFamily<? extends T>, T>(create$iv$iv, (String)name$iv){
                                                    final /* synthetic */ boolean $create;
                                                    final /* synthetic */ String $name;
                                                    {
                                                        this.$create = $create;
                                                        this.$name = $name;
                                                        super(1);
                                                    }

                                                    @Nullable
                                                    public final T invoke(@NotNull ModNamingFamily<? extends T> $this$invoke) {
                                                        Intrinsics.checkNotNullParameter($this$invoke, (String)"$this$invoke");
                                                        return (T)(this.$create ? $this$invoke.createOrGet(this.$name) : (BasicModNamedElement)$this$invoke.get(this.$name));
                                                    }
                                                };
                                                var12_17 = this_$iv$iv;
                                                var20_19 = this_$iv$iv;
                                                $i$a$-get-H2Introspector$H2SchemaAbstractSchemaRetriever$retrieveColumns$3$1$1$table$1 = false;
                                                v2 = var6_4.getTables();
                                                Intrinsics.checkNotNullExpressionValue(v2, (String)"getTables(...)");
                                                v3 = (H2LikeTable)it.invoke(v2);
                                                if (v3 == null) {
                                                    v4 = var6_4.getViews();
                                                    Intrinsics.checkNotNullExpressionValue(v4, (String)"getViews(...)");
                                                    v3 = (H2LikeTable)it.invoke(v4);
                                                }
                                                var20_19.setV((BasicModNamedElement)v3);
                                                v1 = this_$iv$iv.getV();
                                            }
                                            v5 = (H2LikeTable)v1;
                                            if (v5 == null) {
                                                return;
                                            }
                                            table = v5;
                                            var3_24 = table.getColumns().createOrGetAt(info.ordinal_position);
                                            var4_2 = this.this$0;
                                            var5_3 = this.this$1;
                                            var6_4 = this.$schema;
                                            $this$invoke_u24lambda_u243 = (BasicModTableOrViewColumn)var3_24;
                                            $i$a$-apply-H2Introspector$H2SchemaAbstractSchemaRetriever$retrieveColumns$3$1$1$1 = false;
                                            $this$invoke_u24lambda_u243.setName(info.column_name);
                                            $this$invoke_u24lambda_u243.setDasType(H2SchemaAbstractSchemaRetriever.access$getDasType((H2SchemaAbstractSchemaRetriever)var4_2, info));
                                            v6 = $this$invoke_u24lambda_u243;
                                            v7 = info.column_default;
                                            if (v7 != null) {
                                                $i$f$get = create$iv$iv = v7;
                                                var11_16 /* !! */  = v6;
                                                $i$a$-takeIf-H2Introspector$H2SchemaAbstractSchemaRetriever$retrieveColumns$3$1$1$1$1 = false;
                                                v6 = var11_16 /* !! */ ;
                                                v8 = Boolean.valueOf(H2Introspector.access$isNewSchema((H2Introspector)var5_3) != false || info.is_identity == false).booleanValue() ? create$iv$iv : null;
                                            } else {
                                                v8 = null;
                                            }
                                            v6.setDefaultExpression(v8);
                                            if (!($this$invoke_u24lambda_u243 instanceof H2TableColumn)) break block16;
                                            if (!H2Introspector.access$isNewSchema((H2Introspector)var5_3)) break block17;
                                            ((H2TableColumn)$this$invoke_u24lambda_u243).setOnUpdate(info.column_on_update);
                                            if (info.is_identity) {
                                                sequence = (H2Sequence)BasicMetaUtils.getMetaObject((Family)var6_4.getSequences()).newDataObject();
                                                Intrinsics.checkNotNull((Object)sequence);
                                                H2SchemaAbstractSchemaRetriever.access$processSequenceLike((H2SchemaAbstractSchemaRetriever)var4_2, sequence, info, info.is_identity);
                                                BasicDataObject.freeze(sequence);
                                                ((H2TableColumn)$this$invoke_u24lambda_u243).setSequenceRef(BasicInlineObjectReference.create(sequence));
                                            } else {
                                                ((H2TableColumn)$this$invoke_u24lambda_u243).setSequenceRef(null);
                                            }
                                            break block18;
                                        }
                                        if (!H2Introspector.access$isV2((H2Introspector)var5_3)) break block19;
                                        columnPsi = SqlPsiElementFactory.createColumnFromText(info.column_name + " " + info.getColumn_type(), H2Dialect.INSTANCE, H2Introspector.access$getProject((H2Introspector)var5_3));
                                        v9 /* !! */  = columnPsi;
                                        if (v9 /* !! */  == null || (v9 /* !! */  = (it = v9 /* !! */ .getConstraints())) == null) ** GOTO lbl-1000
                                        Intrinsics.checkNotNull((Object)v9 /* !! */ );
                                        $this$firstOrNull$iv = it;
                                        $i$f$firstOrNull = false;
                                        for (T element$iv : $this$firstOrNull$iv) {
                                            it = (SqlConstraintDefinition)element$iv;
                                            $i$a$-firstOrNull-H2Introspector$H2SchemaAbstractSchemaRetriever$retrieveColumns$3$1$1$1$defaultHolder$1 = false;
                                            if (!(it.getConstraintType() == SqlConstraintDefinition.Type.DEFAULT)) continue;
                                            v10 = element$iv;
                                            break block15;
                                        }
                                        v10 = null;
                                    }
                                    if ((v9 /* !! */  = (SqlConstraintDefinition)v10) != null) {
                                        v11 = (SqlCompositeElement)v9 /* !! */ ;
                                    } else lbl-1000:
                                    // 2 sources

                                    {
                                        v11 = (SqlCompositeElement)PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)columnPsi), SqlColumnGeneratedClause.class);
                                    }
                                    defaultHolder = v11;
                                    onUpdateClause = (H2OnUpdateClause)PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)columnPsi), H2OnUpdateClause.class);
                                    v12 = (SqlExpression)PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)defaultHolder), SqlExpression.class);
                                    ((H2TableColumn)$this$invoke_u24lambda_u243).setDefaultExpression(v12 != null ? v12.getText() : null);
                                    v13 = onUpdateClause;
                                    ((H2TableColumn)$this$invoke_u24lambda_u243).setOnUpdate(v13 != null && (v13 = v13.getExpression()) != null ? v13.getText() : null);
                                }
                                ((H2TableColumn)$this$invoke_u24lambda_u243).setSequenceRef(BasicNameReference.create(info.sequence_name));
                            }
                            v14 = (H2TableColumn)$this$invoke_u24lambda_u243;
                            if (info.is_generated || Intrinsics.areEqual((Object)info.identity_generation, (Object)"ALWAYS")) {
                                v15 = ColumnKind.GENERATED_VIRTUAL;
                            } else if (info.is_identity) {
                                v16 = info.getColumn_type();
                                v15 = (v16 != null ? StringsKt.contains((CharSequence)v16, (CharSequence)"generated always", (boolean)true) : false) ? ColumnKind.GENERATED_VIRTUAL : ColumnKind.GENERATED_STORED;
                            } else {
                                v15 = ColumnKind.NORMAL;
                            }
                            v14.setColumnKind(v15);
                            ((H2TableColumn)$this$invoke_u24lambda_u243).setHidden(info.is_visible == false);
                        }
                        $this$invoke_u24lambda_u243.setNotNull(info.is_nullable == false);
                        $this$invoke_u24lambda_u243.setComment(info.remarks);
                    }
                }));
            }
            catch (DBException e$iv) {
                this_$iv.getErrorSink().consume(null, (Object)e$iv);
            }
            for (ModFamily f$iv$iv : families$iv$iv) {
                f$iv$iv.removeSyncPendingChildren();
                f$iv$iv.sort();
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveConstraints(H2Schema schema2) {
            void $this$flatMapTo$iv$iv;
            H2Introspector.this.reportRetrieving("constraints", "introspection.retrieve.constraints");
            ModNamingFamily<? extends H2Table> modNamingFamily = schema2.getTables();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getTables(...)");
            Iterable $this$flatMap$iv = modNamingFamily;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                H2Table t = (H2Table)element$iv$iv;
                boolean bl = false;
                Object[] objectArray = new ModNamingFamily[3];
                Intrinsics.checkNotNullExpressionValue((Object)t.getKeys(), (String)"getKeys(...)");
                Intrinsics.checkNotNullExpressionValue((Object)t.getForeignKeys(), (String)"getForeignKeys(...)");
                Intrinsics.checkNotNullExpressionValue((Object)t.getChecks(), (String)"getChecks(...)");
                Iterable list$iv$iv = CollectionsKt.listOf((Object[])objectArray);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List involvingFamilies = (List)destination$iv$iv;
            H2Introspector h2Introspector = H2Introspector.this;
            boolean inc$iv = true;
            boolean $i$f$modifyFamiliesAndCleanup = false;
            Collection $this$toTypedArray$iv$iv = involvingFamilies;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv$iv = $this$toTypedArray$iv$iv;
            ModFamily[] fs$iv = thisCollection$iv$iv.toArray(new ModNamingFamily[0]);
            ModFamily[] families$iv$iv = Arrays.copyOf(fs$iv, fs$iv.length);
            boolean $i$f$modifyFamiliesAndCleanup2 = false;
            for (ModFamily f$iv$iv : families$iv$iv) {
                f$iv$iv.markChildrenAsSyncPending();
            }
            boolean bl = false;
            BaseNativeIntrospector this_$iv = h2Introspector;
            boolean $i$f$continueOnDbError = false;
            try {
                boolean bl2 = false;
                NameCache<H2Table> tableCache2 = new NameCache<H2Table>();
                HashMap<Object, H2Constraint> constraintMap = new HashMap<Object, H2Constraint>();
                H2IntroQueries.INSTANCE.processConstraints(this.getTransaction(), schema2, h2Introspector.isNewSchema(), (Function1<? super H2IntroQueries.ConstraintInfo, Unit>)((Function1)new Function1<H2IntroQueries.ConstraintInfo, Unit>(tableCache2, this, h2Introspector, constraintMap, schema2){
                    final /* synthetic */ NameCache<H2Table> $tableCache;
                    final /* synthetic */ H2SchemaAbstractSchemaRetriever this$0;
                    final /* synthetic */ H2Introspector this$1;
                    final /* synthetic */ HashMap<Object, H2Constraint> $constraintMap;
                    final /* synthetic */ H2Schema $schema;
                    {
                        this.$tableCache = $tableCache;
                        this.this$0 = $receiver;
                        this.this$1 = $receiver2;
                        this.$constraintMap = $constraintMap;
                        this.$schema = $schema;
                        super(1);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    public final void invoke(@NotNull H2IntroQueries.ConstraintInfo info) {
                        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
                        var4_2 = this.$tableCache;
                        var5_3 = info.table_name;
                        var6_4 = this.$schema;
                        $i$f$get = false;
                        var8_8 = this_$iv;
                        create$iv$iv = false;
                        $i$f$get = false;
                        if (this_$iv$iv.getV() == null) ** GOTO lbl-1000
                        v0 = this_$iv$iv.getV();
                        Intrinsics.checkNotNull(v0);
                        if (Intrinsics.areEqual((Object)v0.getName(), (Object)name$iv)) {
                            v1 = this_$iv$iv.getV();
                        } else lbl-1000:
                        // 2 sources

                        {
                            var11_12 = (Function1)new Function1<ModNamingFamily<? extends T>, T>(create$iv$iv, (String)name$iv){
                                final /* synthetic */ boolean $create;
                                final /* synthetic */ String $name;
                                {
                                    this.$create = $create;
                                    this.$name = $name;
                                    super(1);
                                }

                                @Nullable
                                public final T invoke(@NotNull ModNamingFamily<? extends T> $this$invoke) {
                                    Intrinsics.checkNotNullParameter($this$invoke, (String)"$this$invoke");
                                    return (T)(this.$create ? $this$invoke.createOrGet(this.$name) : (BasicModNamedElement)$this$invoke.get(this.$name));
                                }
                            };
                            var12_13 = this_$iv$iv;
                            var14_14 = this_$iv$iv;
                            $i$a$-get-H2Introspector$H2SchemaAbstractSchemaRetriever$retrieveConstraints$1$1$1$table$1 = false;
                            v2 = var6_4.getTables();
                            Intrinsics.checkNotNullExpressionValue(v2, (String)"getTables(...)");
                            var14_14.setV((BasicModNamedElement)((H2Table)it.invoke(v2)));
                            v1 = this_$iv$iv.getV();
                        }
                        v3 = (H2Table)v1;
                        if (v3 == null) {
                            return;
                        }
                        table = v3;
                        v4 = info.unique_index_name;
                        if (v4 != null) {
                            it = v4;
                            $i$a$-let-H2Introspector$H2SchemaAbstractSchemaRetriever$retrieveConstraints$1$1$1$index$1 = false;
                            v5 = (H2Index)table.getIndices().get(it);
                        } else {
                            v5 = null;
                        }
                        v6 = index = v5;
                        v7 = v6 != null ? v6.getColNames() : null;
                        if (v7 == null) {
                            v8 = info.column_list;
                            if (v8 == null) {
                                v8 = "";
                            }
                            v7 = H2SchemaAbstractSchemaRetriever.access$parseColumnList(this.this$0, v8);
                        }
                        colNames = v7;
                        it = info.constraint_type;
                        tmp = -1;
                        switch (it.hashCode()) {
                            case 1284802305: {
                                if (it.equals("PRIMARY KEY")) {
                                    tmp = 1;
                                }
                                break;
                            }
                            case -1787199535: {
                                if (it.equals("UNIQUE")) {
                                    tmp = 2;
                                }
                                break;
                            }
                            case 64089320: {
                                if (it.equals("CHECK")) {
                                    tmp = 3;
                                }
                                break;
                            }
                            case 704200915: {
                                if (it.equals("FOREIGN KEY")) {
                                    tmp = 4;
                                }
                                break;
                            }
                            case 2137260521: {
                                if (it.equals("REFERENTIAL")) {
                                    tmp = 4;
                                }
                                break;
                            }
                        }
                        switch (tmp) {
                            case 1: {
                                v9 = table.getKeys();
                                Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"getKeys(...)");
                                var7_6 = H2SchemaAbstractSchemaRetriever.access$renewConstraint(this.this$0, (ModNamingFamily)v9, info.constraint_name, colNames);
                                $this$invoke_u24lambda_u242 = (H2Key)var7_6;
                                $i$a$-apply-H2Introspector$H2SchemaAbstractSchemaRetriever$retrieveConstraints$1$1$1$constraint$1 = false;
                                $this$invoke_u24lambda_u242.setPrimary(true);
                                v10 = var7_6;
                                break;
                            }
                            case 2: {
                                v11 = table.getKeys();
                                Intrinsics.checkNotNullExpressionValue((Object)v11, (String)"getKeys(...)");
                                v10 = H2SchemaAbstractSchemaRetriever.access$renewConstraint(this.this$0, (ModNamingFamily)v11, info.constraint_name, colNames);
                                break;
                            }
                            case 3: {
                                v12 = table.getChecks();
                                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)"getChecks(...)");
                                var7_7 = H2SchemaAbstractSchemaRetriever.access$renewConstraint(this.this$0, (ModNamingFamily)v12, info.constraint_name, colNames);
                                var8_8 = this.this$0;
                                $this$invoke_u24lambda_u244 = (H2Check)var7_7;
                                $i$a$-apply-H2Introspector$H2SchemaAbstractSchemaRetriever$retrieveConstraints$1$1$1$constraint$2 = false;
                                v13 = $this$invoke_u24lambda_u244;
                                v14 = info.check_expression;
                                if (v14 != null) {
                                    it = v14;
                                    var12_13 = v13;
                                    $i$a$-let-H2Introspector$H2SchemaAbstractSchemaRetriever$retrieveConstraints$1$1$1$constraint$2$1 = false;
                                    v15 = H2SchemaAbstractSchemaRetriever.access$removeParens(var8_8, it);
                                    v13 = var12_13;
                                } else {
                                    v15 = null;
                                }
                                v13.setPredicate(v15);
                                v10 = var7_7;
                                break;
                            }
                            case 4: {
                                v16 = table.getForeignKeys();
                                Intrinsics.checkNotNullExpressionValue((Object)v16, (String)"getForeignKeys(...)");
                                v10 = H2SchemaAbstractSchemaRetriever.access$renewConstraint(this.this$0, (ModNamingFamily)v16, info.constraint_name, colNames);
                                break;
                            }
                            default: {
                                return;
                            }
                        }
                        constraint = v10;
                        key = H2Introspector.access$isNewSchema(this.this$1) != false ? (Serializable)info.constraint_name : (Serializable)TuplesKt.to((Object)info.table_name, (Object)info.constraint_name);
                        v17 = this.$constraintMap;
                        Intrinsics.checkNotNull((Object)constraint);
                        v17.put(key, constraint);
                        constraint.setNameSurrogate(StringsKt.startsWith$default((String)info.constraint_name, (String)"CONSTRAINT_", (boolean)false, (int)2, null));
                        constraint.setColNames((List<String>)colNames);
                        constraint.setComment(info.remarks);
                    }
                }));
                H2IntroQueries.INSTANCE.processForeignKeys(this.getTransaction(), schema2, h2Introspector.isNewSchema(), (Function1<? super H2IntroQueries.ForeignKeyInfo, Unit>)((Function1)new Function1<H2IntroQueries.ForeignKeyInfo, Unit>(h2Introspector, constraintMap, this){
                    final /* synthetic */ H2Introspector this$0;
                    final /* synthetic */ HashMap<Object, H2Constraint> $constraintMap;
                    final /* synthetic */ H2SchemaAbstractSchemaRetriever this$1;
                    {
                        this.this$0 = $receiver;
                        this.$constraintMap = $constraintMap;
                        this.this$1 = $receiver2;
                        super(1);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke(@NotNull H2IntroQueries.ForeignKeyInfo info2) {
                        BasicReference basicReference;
                        Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
                        H2Constraint h2Constraint = H2Introspector.access$isNewSchema(this.this$0) ? this.$constraintMap.get(info2.fk_name) : this.$constraintMap.get(TuplesKt.to((Object)info2.fktable_name, (Object)info2.fk_name));
                        H2ForeignKey h2ForeignKey = h2Constraint instanceof H2ForeignKey ? (H2ForeignKey)h2Constraint : null;
                        if (h2ForeignKey == null) {
                            return;
                        }
                        H2ForeignKey key2 = h2ForeignKey;
                        BasicNameReference nameRef = BasicNameReference.create(info2.pk_name);
                        if (H2Introspector.access$isV2(this.this$0)) {
                            key2.setRefKeyRef(nameRef);
                        } else {
                            key2.setRefKeyRef(BasicKeyByIndexReference.create(nameRef));
                        }
                        H2ForeignKey h2ForeignKey2 = key2;
                        if (H2Introspector.access$isNewSchema(this.this$0)) {
                            H2Constraint h2Constraint2 = this.$constraintMap.get(info2.pk_name);
                            DasTable dasTable = h2Constraint2 != null ? h2Constraint2.getTable() : null;
                            H2LikeTable h2LikeTable = dasTable instanceof H2LikeTable ? (H2LikeTable)dasTable : null;
                            if (h2LikeTable != null) {
                                void it2;
                                H2LikeTable h2LikeTable2 = h2LikeTable;
                                H2ForeignKey h2ForeignKey3 = h2ForeignKey2;
                                boolean bl = false;
                                basicReference = BasicParentReference.create(it2.getSchemaName(), BasicNameReference.create(it2.getName()));
                                h2ForeignKey2 = h2ForeignKey3;
                            } else {
                                basicReference = null;
                            }
                        } else {
                            String string;
                            String it2 = string = info2.pktable_name;
                            H2ForeignKey h2ForeignKey4 = h2ForeignKey2;
                            boolean bl = false;
                            boolean bl2 = ((CharSequence)it2).length() > 0;
                            h2ForeignKey2 = h2ForeignKey4;
                            String string2 = bl2 ? string : null;
                            if (string2 != null) {
                                it2 = string2;
                                h2ForeignKey4 = h2ForeignKey2;
                                boolean bl3 = false;
                                basicReference = BasicParentReference.create(info2.pktable_schema, BasicNameReference.create(info2.pktable_name));
                                h2ForeignKey2 = h2ForeignKey4;
                            } else {
                                basicReference = null;
                            }
                        }
                        h2ForeignKey2.setRefTableRef(basicReference);
                        key2.setOnUpdate(H2SchemaAbstractSchemaRetriever.access$getCascadeRule(this.this$1, info2.update_rule));
                        key2.setOnDelete(H2SchemaAbstractSchemaRetriever.access$getCascadeRule(this.this$1, info2.delete_rule));
                    }
                }));
                if (h2Introspector.isNewSchema()) {
                    H2IntroQueries.INSTANCE.processCheckConstraints(this.getTransaction(), schema2, (Function1<? super H2IntroQueries.CheckInfo, Unit>)((Function1)new Function1<H2IntroQueries.CheckInfo, Unit>(constraintMap){
                        final /* synthetic */ HashMap<Object, H2Constraint> $constraintMap;
                        {
                            this.$constraintMap = $constraintMap;
                            super(1);
                        }

                        public final void invoke(@NotNull H2IntroQueries.CheckInfo info2) {
                            Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
                            H2Constraint h2Constraint = this.$constraintMap.get(info2.constraint_name);
                            H2Check h2Check = h2Constraint instanceof H2Check ? (H2Check)h2Constraint : null;
                            if (h2Check != null) {
                                h2Check.setPredicate(info2.check_clause);
                            }
                        }
                    }));
                    MultiMap keyColumnNames = new MultiMap();
                    H2IntroQueries.INSTANCE.processKeyColumnsV2(this.getTransaction(), schema2, (Function1<? super H2IntroQueries.ForeignKeyColumnInfo, Unit>)((Function1)new Function1<H2IntroQueries.ForeignKeyColumnInfo, Unit>(constraintMap, (MultiMap<H2Constraint, String>)keyColumnNames){
                        final /* synthetic */ HashMap<Object, H2Constraint> $constraintMap;
                        final /* synthetic */ MultiMap<H2Constraint, String> $keyColumnNames;
                        {
                            this.$constraintMap = $constraintMap;
                            this.$keyColumnNames = $keyColumnNames;
                            super(1);
                        }

                        public final void invoke(@NotNull H2IntroQueries.ForeignKeyColumnInfo info2) {
                            Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
                            H2Constraint h2Constraint = this.$constraintMap.get(info2.constraint_name);
                            if (h2Constraint == null) {
                                return;
                            }
                            H2Constraint key2 = h2Constraint;
                            if (!this.$keyColumnNames.get((Object)key2).contains(info2.column_name)) {
                                this.$keyColumnNames.putValue((Object)key2, (Object)info2.column_name);
                            }
                        }
                    }));
                    for (Map.Entry entry : keyColumnNames.entrySet()) {
                        Intrinsics.checkNotNull((Object)entry);
                        H2Constraint key2 = (H2Constraint)entry.getKey();
                        Collection names2 = (Collection)entry.getValue();
                        Intrinsics.checkNotNull((Object)names2);
                        key2.setColNames(CollectionsKt.toList((Iterable)names2));
                    }
                }
            }
            catch (DBException e$iv) {
                this_$iv.getErrorSink().consume(null, (Object)e$iv);
            }
            for (ModFamily f$iv$iv : families$iv$iv) {
                f$iv$iv.removeSyncPendingChildren();
                f$iv$iv.sort();
            }
        }

        private final String removeParens(String s2) {
            String string;
            if (StringsKt.startsWith$default((CharSequence)s2, (char)'(', (boolean)false, (int)2, null) && StringsKt.endsWith$default((CharSequence)s2, (char)')', (boolean)false, (int)2, null)) {
                String string2 = s2.substring(1, StringsKt.getLastIndex((CharSequence)s2));
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            } else {
                string = s2;
            }
            return string;
        }

        private final <C extends H2Constraint> C renewConstraint(ModNamingFamily<C> family, String constraintName, List<String> colNames) {
            H2Constraint h2Constraint;
            if (((CharSequence)constraintName).length() > 0) {
                h2Constraint = (H2Constraint)family.createOrGet(constraintName);
            } else {
                H2Constraint h2Constraint2 = (H2Constraint)family.find(arg_0 -> H2SchemaAbstractSchemaRetriever.renewConstraint$lambda$17((Function1)new Function1<C, Boolean>(colNames){
                    final /* synthetic */ List<String> $colNames;
                    {
                        this.$colNames = $colNames;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(C it2) {
                        String string = it2.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                        return ((CharSequence)string).length() == 0 && it2.isSyncPending() && Intrinsics.areEqual(it2.getColNames(), this.$colNames);
                    }
                }, arg_0));
                if (h2Constraint2 != null) {
                    H2Constraint h2Constraint3;
                    H2Constraint $this$renewConstraint_u24lambda_u2418 = h2Constraint3 = h2Constraint2;
                    boolean bl = false;
                    $this$renewConstraint_u24lambda_u2418.setSyncPending(false);
                    h2Constraint = h2Constraint3;
                } else {
                    h2Constraint = (H2Constraint)family.createNewOne();
                }
            }
            return (C)h2Constraint;
        }

        private final List<String> parseColumnList(String s2) {
            SmartList columnNames = new SmartList();
            H2Lexer lexer = new H2Lexer();
            lexer.start(s2);
            IElementType tokenType = lexer.getTokenType();
            while (tokenType != null) {
                if (Intrinsics.areEqual((Object)tokenType, (Object)SqlTokens.SQL_IDENT) || tokenType instanceof SqlIdentifierKeywordTokenType || tokenType instanceof SqlKeywordTokenType) {
                    ((Collection)columnNames).add(lexer.getTokenText());
                }
                lexer.advance();
                tokenType = lexer.getTokenType();
            }
            return (List)columnNames;
        }

        private final CascadeRule getCascadeRule(String code) {
            return switch (code) {
                case "0", "CASCADE" -> CascadeRule.cascade;
                case "1", "RESTRICT" -> CascadeRule.restrict;
                case "2", "SET NULL" -> CascadeRule.set_null;
                case "4", "SET DEFAULT" -> CascadeRule.set_default;
                default -> CascadeRule.no_action;
            };
        }

        /*
         * WARNING - void declaration
         */
        private final DasType getDasType(H2IntroQueries.TypedObjectInfo $this$getDasType) {
            int actualPrecision;
            block40: {
                if ($this$getDasType.getColumn_type() != null) {
                    String string = $this$getDasType.getColumn_type();
                    Intrinsics.checkNotNull((Object)string);
                    SqlTypeElement sqlTypeElement = SqlPsiElementFactory.createDataTypeFromText(string, H2Dialect.INSTANCE, H2Introspector.this.getProject(), null, false);
                    Intrinsics.checkNotNull((Object)sqlTypeElement, (String)"null cannot be cast to non-null type com.intellij.sql.psi.SqlTypeElement");
                    SqlTypeElement fragment = sqlTypeElement;
                    DasType dasType = fragment.getDasType();
                    Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"getDasType(...)");
                    return dasType;
                }
                if ($this$getDasType.getDomain_name() != null) {
                    String string = $this$getDasType.getDomain_schema();
                    String string2 = $this$getDasType.getDomain_name();
                    Intrinsics.checkNotNull((Object)string2);
                    DataType dataType = DataTypeFactory.of(string, string2, -1, 0, null, null, false, true);
                    Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"of(...)");
                    DataType dataType2 = dataType;
                    return H2Introspector.this.typeSystem.createDasType(dataType2);
                }
                actualPrecision = $this$getDasType.getPrecision() <= Integer.MAX_VALUE ? (int)$this$getDasType.getPrecision() : Integer.MAX_VALUE;
                String string = $this$getDasType.getType_name();
                if (string == null) break block40;
                int n = -1;
                switch (string.hashCode()) {
                    case 1353045189: {
                        if (string.equals("INTERVAL")) {
                            n = 1;
                        }
                        break;
                    }
                    case 2133249: {
                        if (string.equals("ENUM")) {
                            n = 2;
                        }
                        break;
                    }
                    case 62552633: {
                        if (string.equals("ARRAY")) {
                            n = 3;
                        }
                        break;
                    }
                    case 81338: {
                        if (string.equals("ROW")) {
                            n = 4;
                        }
                        break;
                    }
                    case -1666320270: {
                        if (string.equals("GEOMETRY")) {
                            n = 5;
                        }
                        break;
                    }
                }
                switch (n) {
                    case 1: {
                        Object object;
                        if ($this$getDasType.getInterval_type() == null) {
                            return DasTypeSystemBase.UNKNOWN;
                        }
                        String string3 = $this$getDasType.getInterval_type();
                        Intrinsics.checkNotNull((Object)string3);
                        char[] cArray = new char[]{' '};
                        List components = StringsKt.split$default((CharSequence)string3, (char[])cArray, (boolean)false, (int)0, (int)6, null);
                        String string4 = (String)CollectionsKt.getOrNull((List)components, (int)0);
                        if (string4 == null || (object = H2Introspector.this.toIntervalKind(string4)) == null) {
                            return DasTypeSystemBase.UNKNOWN;
                        }
                        Interval primaryKind = object;
                        object = (String)CollectionsKt.getOrNull((List)components, (int)2);
                        Interval secondaryKind = object != null ? H2Introspector.this.toIntervalKind((String)object) : null;
                        return H2Introspector.this.getIntervalDasType(primaryKind, secondaryKind, $this$getDasType.getInterval_precision(), actualPrecision);
                    }
                    case 5: {
                        StringBuilder primaryKind;
                        if ($this$getDasType.getGeometry_type() == null && $this$getDasType.getGeometry_srid() == null) {
                            DasTypeSystemBase dasTypeSystemBase = H2Introspector.this.typeSystem;
                            DataType dataType = DataTypeFactory.of("GEOMETRY");
                            Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"of(...)");
                            return dasTypeSystemBase.createDasType(dataType);
                        }
                        StringBuilder $this$getDasType_u24lambda_u2419 = primaryKind = new StringBuilder();
                        boolean bl = false;
                        String string5 = $this$getDasType.getGeometry_type();
                        if (string5 == null) {
                            string5 = "GEOMETRY";
                        }
                        $this$getDasType_u24lambda_u2419.append(string5);
                        if ($this$getDasType.getGeometry_srid() != null) {
                            $this$getDasType_u24lambda_u2419.append(", ").append($this$getDasType.getGeometry_srid());
                        }
                        String string6 = primaryKind.toString();
                        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toString(...)");
                        String arg = string6;
                        String string7 = $this$getDasType.getType_name();
                        Intrinsics.checkNotNull((Object)string7);
                        DataType dataType = DataTypeFactory.ofArgs(null, string7, arg, false);
                        Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"ofArgs(...)");
                        DataType dataType3 = dataType;
                        return H2Introspector.this.typeSystem.createDasType(dataType3);
                    }
                    case 2: {
                        if ($this$getDasType.getDtd_identifier() == null) {
                            return DasTypeSystemBase.UNKNOWN;
                        }
                        String string8 = $this$getDasType.getDtd_identifier();
                        Intrinsics.checkNotNull((Object)string8);
                        List<String> list = this.enumValues.get(string8);
                        if (list == null) {
                            return DasTypeSystemBase.UNKNOWN;
                        }
                        List<String> enumValues = list;
                        String string9 = $this$getDasType.getType_name();
                        Intrinsics.checkNotNull((Object)string9);
                        DataType dataType = DataTypeFactory.ofValues(null, null, string9, enumValues, false);
                        Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"ofValues(...)");
                        DataType dataType4 = dataType;
                        return H2Introspector.this.typeSystem.createDasType(dataType4);
                    }
                    case 3: {
                        StringBuilder bl;
                        if ($this$getDasType.getDtd_identifier() == null) {
                            DasType dasType;
                            if (H2Introspector.this.isV2()) {
                                dasType = DasTypeSystemBase.UNKNOWN;
                            } else {
                                DasTypeSystemBase dasTypeSystemBase = H2Introspector.this.typeSystem;
                                String string10 = $this$getDasType.getType_name();
                                Intrinsics.checkNotNull((Object)string10);
                                DataType dataType = DataTypeFactory.of(string10);
                                Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"of(...)");
                                dasType = dasTypeSystemBase.createDasType(dataType);
                            }
                            return dasType;
                        }
                        String string11 = $this$getDasType.getDtd_identifier();
                        Intrinsics.checkNotNull((Object)string11);
                        Object object = this.arrayElementTypes.get(string11);
                        if (object == null || (object = this.getDasType((H2IntroQueries.TypedObjectInfo)object)) == null) {
                            return DasTypeSystemBase.UNKNOWN;
                        }
                        Object elementType = object;
                        DataType dataType = elementType.toDataType();
                        Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"toDataType(...)");
                        DataType elementDataType = dataType;
                        StringBuilder $this$getDasType_u24lambda_u2420 = bl = new StringBuilder();
                        boolean bl2 = false;
                        String string12 = elementDataType.suffix;
                        if (string12 == null) {
                            string12 = "";
                        }
                        $this$getDasType_u24lambda_u2420.append(string12);
                        if ($this$getDasType_u24lambda_u2420.length() > 0) {
                            $this$getDasType_u24lambda_u2420.append(' ');
                        }
                        $this$getDasType_u24lambda_u2420.append("ARRAY");
                        if ($this$getDasType.getMaximum_cardinality() != null) {
                            Integer n3 = $this$getDasType.getMaximum_cardinality();
                            int n4 = 65536;
                            if (n3 == null || n3 != n4) {
                                $this$getDasType_u24lambda_u2420.append("[" + $this$getDasType.getMaximum_cardinality() + "]");
                            }
                        }
                        String string13 = bl.toString();
                        Intrinsics.checkNotNullExpressionValue((Object)string13, (String)"toString(...)");
                        String suffix2 = string13;
                        DataType dataType5 = DataTypeFactory.withSuffix(elementType.toDataType(), suffix2);
                        Intrinsics.checkNotNullExpressionValue((Object)dataType5, (String)"withSuffix(...)");
                        DataType dataType6 = dataType5;
                        return H2Introspector.this.typeSystem.createDasType(dataType6);
                    }
                    case 4: {
                        if ($this$getDasType.getDtd_identifier() == null) {
                            return DasTypeSystemBase.UNKNOWN;
                        }
                        DdlBuilder ddlBuilder = new DdlBuilder().withDialect(DbImplUtilCore.getDatabaseDialect(H2Introspector.this.dbms)).quoteIdentifiers(false);
                        Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder, (String)"quoteIdentifiers(...)");
                        DdlBuilder argBuilder = ddlBuilder;
                        String string14 = $this$getDasType.getDtd_identifier();
                        Intrinsics.checkNotNull((Object)string14);
                        Collection collection2 = this.rowFields.get((Object)string14);
                        Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"get(...)");
                        Iterable $this$forEachIndexed$iv = collection2;
                        boolean $i$f$forEachIndexed = false;
                        int index$iv = 0;
                        for (Object item$iv : $this$forEachIndexed$iv) {
                            void field;
                            int n5;
                            if ((n5 = index$iv++) < 0) {
                                CollectionsKt.throwIndexOverflow();
                            }
                            H2IntroQueries.RowFieldInfo rowFieldInfo = (H2IntroQueries.RowFieldInfo)item$iv;
                            int i2 = n5;
                            boolean bl = false;
                            if (i2 > 0) {
                                argBuilder.plain(", ");
                            }
                            argBuilder.identifier(field.field_name);
                            argBuilder.plain(" ");
                            Intrinsics.checkNotNull((Object)field);
                            argBuilder.type(this.getDasType((H2IntroQueries.TypedObjectInfo)field).toDataType());
                        }
                        String string15 = $this$getDasType.getType_name();
                        Intrinsics.checkNotNull((Object)string15);
                        DataType dataType = DataTypeFactory.ofArgs(null, string15, argBuilder.getStatement(), false);
                        Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"ofArgs(...)");
                        DataType dataType7 = dataType;
                        return H2Introspector.this.typeSystem.createDasType(dataType7);
                    }
                }
            }
            return H2Introspector.this.getDasType($this$getDasType.getType_name(), actualPrecision, $this$getDasType.getScale());
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveIndexes(H2Schema schema2) {
            void families$iv;
            void $this$mapTo$iv$iv;
            ObjectKind objectKind = ObjectKind.INDEX;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"INDEX");
            H2Introspector.this.reportRetrieving(objectKind);
            ModNamingFamily<? extends H2Table> modNamingFamily = schema2.getTables();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getTables(...)");
            Iterable $this$map$iv = modNamingFamily;
            boolean $i$f$map = false;
            Object object = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                H2Table h2Table = (H2Table)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(it2.getIndices());
            }
            $this$map$iv = (List)destination$iv$iv;
            object = H2Introspector.this;
            boolean inc$iv = true;
            boolean $i$f$modifyFamiliesAndCleanup = false;
            void $this$toTypedArray$iv$iv = families$iv;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv$iv = $this$toTypedArray$iv$iv;
            ModFamily[] fs$iv = thisCollection$iv$iv.toArray(new ModNamingFamily[0]);
            ModFamily[] families$iv$iv = Arrays.copyOf(fs$iv, fs$iv.length);
            boolean $i$f$modifyFamiliesAndCleanup2 = false;
            for (ModFamily f$iv$iv : families$iv$iv) {
                f$iv$iv.markChildrenAsSyncPending();
            }
            boolean bl = false;
            BaseNativeIntrospector this_$iv = (BaseNativeIntrospector)object;
            boolean $i$f$continueOnDbError = false;
            try {
                boolean bl2 = false;
                NameCache<H2Table> tableCache2 = new NameCache<H2Table>();
                H2IntroQueries.INSTANCE.processIndexes(this.getTransaction(), schema2, ((H2Introspector)object).isNewSchema(), (Function1<? super H2IntroQueries.IndexInfo, Unit>)((Function1)new Function1<H2IntroQueries.IndexInfo, Unit>(tableCache2, schema2){
                    final /* synthetic */ NameCache<H2Table> $tableCache;
                    final /* synthetic */ H2Schema $schema;
                    {
                        this.$tableCache = $tableCache;
                        this.$schema = $schema;
                        super(1);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    public final void invoke(@NotNull H2IntroQueries.IndexInfo info) {
                        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
                        var4_2 = this.$tableCache;
                        var5_3 = info.table_name;
                        var6_5 = this.$schema;
                        $i$f$get = false;
                        var8_7 = this_$iv;
                        create$iv$iv = false;
                        $i$f$get = false;
                        if (this_$iv$iv.getV() == null) ** GOTO lbl-1000
                        v0 = this_$iv$iv.getV();
                        Intrinsics.checkNotNull(v0);
                        if (Intrinsics.areEqual((Object)v0.getName(), (Object)name$iv)) {
                            v1 = this_$iv$iv.getV();
                        } else lbl-1000:
                        // 2 sources

                        {
                            var11_10 = (Function1)new Function1<ModNamingFamily<? extends T>, T>(create$iv$iv, (String)name$iv){
                                final /* synthetic */ boolean $create;
                                final /* synthetic */ String $name;
                                {
                                    this.$create = $create;
                                    this.$name = $name;
                                    super(1);
                                }

                                @Nullable
                                public final T invoke(@NotNull ModNamingFamily<? extends T> $this$invoke) {
                                    Intrinsics.checkNotNullParameter($this$invoke, (String)"$this$invoke");
                                    return (T)(this.$create ? $this$invoke.createOrGet(this.$name) : (BasicModNamedElement)$this$invoke.get(this.$name));
                                }
                            };
                            var12_11 = this_$iv$iv;
                            var14_12 = this_$iv$iv;
                            $i$a$-get-H2Introspector$H2SchemaAbstractSchemaRetriever$retrieveIndexes$2$1$1$table$1 = false;
                            v2 = var6_5.getTables();
                            Intrinsics.checkNotNullExpressionValue(v2, (String)"getTables(...)");
                            var14_12.setV((BasicModNamedElement)((H2Table)it.invoke(v2)));
                            v1 = this_$iv$iv.getV();
                        }
                        v3 = (H2Table)v1;
                        if (v3 == null) {
                            return;
                        }
                        table = v3;
                        var3_15 = table.getIndices().createOrGet(info.index_name);
                        $this$invoke_u24lambda_u241 = (H2Index)var3_15;
                        $i$a$-apply-H2Introspector$H2SchemaAbstractSchemaRetriever$retrieveIndexes$2$1$1$1 = false;
                        $this$invoke_u24lambda_u241.setNameSurrogate(info.is_generated);
                        $this$invoke_u24lambda_u241.setUnique(info.non_unique == false);
                        $this$invoke_u24lambda_u241.setComment(info.remarks);
                    }
                }));
                NameCache<H2Index> indexCache = new NameCache<H2Index>();
                ArrayList<H2IntroQueries.IndexColumnInfo> indexColumns = new ArrayList<H2IntroQueries.IndexColumnInfo>();
                H2IntroQueries.INSTANCE.processIndexColumns(this.getTransaction(), schema2, ((H2Introspector)object).isNewSchema(), (Function1<? super H2IntroQueries.IndexColumnInfo, Unit>)((Function1)new Function1<H2IntroQueries.IndexColumnInfo, Unit>(tableCache2, indexCache, indexColumns, this, schema2){
                    final /* synthetic */ NameCache<H2Table> $tableCache;
                    final /* synthetic */ NameCache<H2Index> $indexCache;
                    final /* synthetic */ ArrayList<H2IntroQueries.IndexColumnInfo> $indexColumns;
                    final /* synthetic */ H2SchemaAbstractSchemaRetriever this$0;
                    final /* synthetic */ H2Schema $schema;
                    {
                        this.$tableCache = $tableCache;
                        this.$indexCache = $indexCache;
                        this.$indexColumns = $indexColumns;
                        this.this$0 = $receiver;
                        this.$schema = $schema;
                        super(1);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    public final void invoke(@NotNull H2IntroQueries.IndexColumnInfo info) {
                        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
                        var4_2 = this.$tableCache;
                        var5_3 = info.table_name;
                        var6_4 = this.this$0;
                        var7_5 = this.$indexCache;
                        var8_6 = this.$indexColumns;
                        var9_8 = this.$schema;
                        $i$f$get = false;
                        var11_10 = this_$iv;
                        create$iv$iv = false;
                        $i$f$get = false;
                        if (this_$iv$iv.getV() == null) ** GOTO lbl-1000
                        v0 = this_$iv$iv.getV();
                        Intrinsics.checkNotNull(v0);
                        if (Intrinsics.areEqual((Object)v0.getName(), (Object)name$iv)) {
                            v1 = this_$iv$iv.getV();
                        } else lbl-1000:
                        // 2 sources

                        {
                            var14_16 = (Function1)new Function1<ModNamingFamily<? extends T>, T>(create$iv$iv, (String)name$iv){
                                final /* synthetic */ boolean $create;
                                final /* synthetic */ String $name;
                                {
                                    this.$create = $create;
                                    this.$name = $name;
                                    super(1);
                                }

                                @Nullable
                                public final T invoke(@NotNull ModNamingFamily<? extends T> $this$invoke) {
                                    Intrinsics.checkNotNullParameter($this$invoke, (String)"$this$invoke");
                                    return (T)(this.$create ? $this$invoke.createOrGet(this.$name) : (BasicModNamedElement)$this$invoke.get(this.$name));
                                }
                            };
                            var15_18 = this_$iv$iv;
                            var17_19 = this_$iv$iv;
                            $i$a$-get-H2Introspector$H2SchemaAbstractSchemaRetriever$retrieveIndexes$2$1$2$table$1 = false;
                            H2SchemaAbstractSchemaRetriever.access$applyIndexColumns((H2SchemaAbstractSchemaRetriever)var6_4, var7_5.getV(), var8_6);
                            var7_5.setV(null);
                            v2 = var9_8.getTables();
                            Intrinsics.checkNotNullExpressionValue(v2, (String)"getTables(...)");
                            var17_19.setV((BasicModNamedElement)((H2Table)it.invoke(v2)));
                            v1 = this_$iv$iv.getV();
                        }
                        v3 = (H2Table)v1;
                        if (v3 == null) {
                            return;
                        }
                        table = v3;
                        var3_22 = this.$indexCache;
                        this_$iv = info.index_name;
                        var5_3 = this.this$0;
                        var6_4 = this.$indexCache;
                        var7_5 = this.$indexColumns;
                        $i$f$get = false;
                        var9_8 = this_$iv;
                        create$iv$iv = false;
                        $i$f$get = false;
                        if (this_$iv$iv.getV() == null) ** GOTO lbl-1000
                        v4 = this_$iv$iv.getV();
                        Intrinsics.checkNotNull(v4);
                        if (Intrinsics.areEqual((Object)v4.getName(), (Object)name$iv)) {
                            v5 = this_$iv$iv.getV();
                        } else lbl-1000:
                        // 2 sources

                        {
                            create$iv$iv = (Function1)new Function1<ModNamingFamily<? extends T>, T>(create$iv$iv, (String)name$iv){
                                final /* synthetic */ boolean $create;
                                final /* synthetic */ String $name;
                                {
                                    this.$create = $create;
                                    this.$name = $name;
                                    super(1);
                                }

                                @Nullable
                                public final T invoke(@NotNull ModNamingFamily<? extends T> $this$invoke) {
                                    Intrinsics.checkNotNullParameter($this$invoke, (String)"$this$invoke");
                                    return (T)(this.$create ? $this$invoke.createOrGet(this.$name) : (BasicModNamedElement)$this$invoke.get(this.$name));
                                }
                            };
                            $i$f$get = this_$iv$iv;
                            var17_19 = this_$iv$iv;
                            $i$a$-get-H2Introspector$H2SchemaAbstractSchemaRetriever$retrieveIndexes$2$1$2$1 = false;
                            H2SchemaAbstractSchemaRetriever.access$applyIndexColumns((H2SchemaAbstractSchemaRetriever)var5_3, (H2Index)var6_4.getV(), (List)var7_5);
                            v6 = table.getIndices();
                            Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"getIndices(...)");
                            var17_19.setV((BasicModNamedElement)((H2Index)it.invoke((Object)v6)));
                            v5 = this_$iv$iv.getV();
                        }
                        ((Collection)this.$indexColumns).add(info);
                    }
                }));
                this.applyIndexColumns(indexCache.getV(), (List<H2IntroQueries.IndexColumnInfo>)indexColumns);
            }
            catch (DBException e$iv) {
                this_$iv.getErrorSink().consume(null, (Object)e$iv);
            }
            for (ModFamily f$iv$iv : families$iv$iv) {
                f$iv$iv.removeSyncPendingChildren();
                f$iv$iv.sort();
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void applyIndexColumns(H2Index index2, List<H2IntroQueries.IndexColumnInfo> columns2) {
            H2Index h2Index = index2;
            if (h2Index != null) {
                void destination$iv;
                void $this$mapNotNullTo$iv;
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv;
                H2Index h2Index2;
                H2Index $this$applyIndexColumns_u24lambda_u2428 = h2Index2 = h2Index;
                boolean bl = false;
                Iterable iterable = columns2;
                H2Index h2Index3 = $this$applyIndexColumns_u24lambda_u2428;
                boolean $i$f$map22 = false;
                void var9_10 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it2;
                    H2IntroQueries.IndexColumnInfo indexColumnInfo = (H2IntroQueries.IndexColumnInfo)item$iv$iv;
                    Collection collection2 = destination$iv$iv;
                    boolean bl2 = false;
                    collection2.add(it2.column_name);
                }
                h2Index3.setColNames((List)destination$iv$iv);
                $this$map$iv = columns2;
                Collection $i$f$map22 = new LinkedHashSet();
                h2Index3 = $this$applyIndexColumns_u24lambda_u2428;
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv.iterator();
                while (iterator.hasNext()) {
                    String it$iv;
                    String string;
                    Object element$iv$iv;
                    Object element$iv = element$iv$iv = iterator.next();
                    boolean bl3 = false;
                    H2IntroQueries.IndexColumnInfo c2 = (H2IntroQueries.IndexColumnInfo)element$iv;
                    boolean bl4 = false;
                    String it3 = string = c2.column_name;
                    boolean bl5 = false;
                    if ((c2.is_desc ? string : null) == null) continue;
                    it$iv = it$iv;
                    boolean bl6 = false;
                    destination$iv.add(it$iv);
                }
                h2Index3.setReverseColNames((Set)destination$iv);
            }
            columns2.clear();
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveTriggers(H2Schema schema2) {
            void families$iv;
            void $this$mapTo$iv$iv;
            ObjectKind objectKind = ObjectKind.TRIGGER;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"TRIGGER");
            H2Introspector.this.reportRetrieving(objectKind);
            NameCache<H2Table> tableCache2 = new NameCache<H2Table>();
            ModNamingFamily<? extends H2Table> modNamingFamily = schema2.getTables();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getTables(...)");
            Iterable $this$map$iv = modNamingFamily;
            boolean $i$f$map = false;
            Object object = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                H2Table h2Table = (H2Table)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(it2.getTriggers());
            }
            $this$map$iv = (List)destination$iv$iv;
            object = H2Introspector.this;
            boolean inc$iv = true;
            boolean $i$f$modifyFamiliesAndCleanup = false;
            void $this$toTypedArray$iv$iv = families$iv;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv$iv = $this$toTypedArray$iv$iv;
            ModFamily[] fs$iv = thisCollection$iv$iv.toArray(new ModNamingFamily[0]);
            ModFamily[] families$iv$iv = Arrays.copyOf(fs$iv, fs$iv.length);
            boolean $i$f$modifyFamiliesAndCleanup2 = false;
            for (ModFamily f$iv$iv : families$iv$iv) {
                f$iv$iv.markChildrenAsSyncPending();
            }
            boolean bl = false;
            BaseNativeIntrospector this_$iv = (BaseNativeIntrospector)object;
            boolean $i$f$continueOnDbError = false;
            try {
                boolean bl2 = false;
                H2IntroQueries.INSTANCE.processTriggers(this.getTransaction(), schema2, ((H2Introspector)object).isNewSchema(), (Function1<? super H2IntroQueries.TriggerInfo, Unit>)((Function1)new Function1<H2IntroQueries.TriggerInfo, Unit>(tableCache2, schema2, this){
                    final /* synthetic */ NameCache<H2Table> $tableCache;
                    final /* synthetic */ H2Schema $schema;
                    final /* synthetic */ H2SchemaAbstractSchemaRetriever this$0;
                    {
                        this.$tableCache = $tableCache;
                        this.$schema = $schema;
                        this.this$0 = $receiver;
                        super(1);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    public final void invoke(@NotNull H2IntroQueries.TriggerInfo info) {
                        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
                        var4_2 = this.$tableCache;
                        var5_3 = info.table_name;
                        var6_4 = this.$schema;
                        $i$f$get = false;
                        var8_7 = this_$iv;
                        create$iv$iv = false;
                        $i$f$get = false;
                        if (this_$iv$iv.getV() == null) ** GOTO lbl-1000
                        v0 = this_$iv$iv.getV();
                        Intrinsics.checkNotNull(v0);
                        if (Intrinsics.areEqual((Object)v0.getName(), (Object)name$iv)) {
                            v1 = this_$iv$iv.getV();
                        } else lbl-1000:
                        // 2 sources

                        {
                            var11_10 = (Function1)new Function1<ModNamingFamily<? extends T>, T>(create$iv$iv, (String)name$iv){
                                final /* synthetic */ boolean $create;
                                final /* synthetic */ String $name;
                                {
                                    this.$create = $create;
                                    this.$name = $name;
                                    super(1);
                                }

                                @Nullable
                                public final T invoke(@NotNull ModNamingFamily<? extends T> $this$invoke) {
                                    Intrinsics.checkNotNullParameter($this$invoke, (String)"$this$invoke");
                                    return (T)(this.$create ? $this$invoke.createOrGet(this.$name) : (BasicModNamedElement)$this$invoke.get(this.$name));
                                }
                            };
                            var12_11 = this_$iv$iv;
                            var14_12 = this_$iv$iv;
                            $i$a$-get-H2Introspector$H2SchemaAbstractSchemaRetriever$retrieveTriggers$2$1$1$table$1 = false;
                            v2 = var6_4.getTables();
                            Intrinsics.checkNotNullExpressionValue(v2, (String)"getTables(...)");
                            var14_12.setV((BasicModNamedElement)((H2Table)it.invoke(v2)));
                            v1 = this_$iv$iv.getV();
                        }
                        v3 = (H2Table)v1;
                        if (v3 == null) {
                            return;
                        }
                        table = v3;
                        var3_15 = table.getTriggers().createOrGet(info.trigger_name);
                        var4_2 = this.this$0;
                        $this$invoke_u24lambda_u241 = var3_15;
                        $i$a$-apply-H2Introspector$H2SchemaAbstractSchemaRetriever$retrieveTriggers$2$1$1$1 = false;
                        $this$invoke_u24lambda_u241.setSchemaName(info.trigger_schema);
                        v4 = info.sql;
                        $this$invoke_u24lambda_u241.setSourceText(v4 != null ? H2SchemaAbstractSchemaRetriever.access$toCompositeText((H2SchemaAbstractSchemaRetriever)var4_2, v4) : null);
                        $this$invoke_u24lambda_u241.setTurn(H2IntrospectorKt.access$asTrigTurn(info));
                        $this$invoke_u24lambda_u241.setEvents(SetsKt.setOf((Object)H2IntrospectorKt.access$asEvent(info)));
                        $this$invoke_u24lambda_u241.setComment(info.remarks);
                    }
                }));
            }
            catch (DBException e$iv) {
                this_$iv.getErrorSink().consume(null, (Object)e$iv);
            }
            for (ModFamily f$iv$iv : families$iv$iv) {
                f$iv$iv.removeSyncPendingChildren();
                f$iv$iv.sort();
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveSequences(H2Schema schema2) {
            void $this$modifyAndCleanup_u24default$iv;
            ObjectKind objectKind = ObjectKind.SEQUENCE;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"SEQUENCE");
            H2Introspector.this.reportRetrieving(objectKind);
            ModFamily modFamily = schema2.getSequences();
            H2Introspector h2Introspector = H2Introspector.this;
            boolean inc$iv = true;
            boolean $i$f$modifyAndCleanup = false;
            $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
            ModNamingFamily sequences = (ModNamingFamily)$this$modifyAndCleanup_u24default$iv;
            boolean bl = false;
            BaseNativeIntrospector this_$iv = h2Introspector;
            boolean $i$f$continueOnDbError = false;
            try {
                boolean bl2 = false;
                Ref.IntRef order2 = new Ref.IntRef();
                H2IntroQueries.INSTANCE.processSequences(this.getTransaction(), schema2, h2Introspector.isNewSchema(), (Function1<? super H2IntroQueries.SequenceInfo, Unit>)((Function1)new Function1<H2IntroQueries.SequenceInfo, Unit>((ModNamingFamily<? extends H2Sequence>)sequences, this, order2){
                    final /* synthetic */ ModNamingFamily<? extends H2Sequence> $sequences;
                    final /* synthetic */ H2SchemaAbstractSchemaRetriever this$0;
                    final /* synthetic */ Ref.IntRef $order;
                    {
                        this.$sequences = $sequences;
                        this.this$0 = $receiver;
                        this.$order = $order;
                        super(1);
                    }

                    public final void invoke(@NotNull H2IntroQueries.SequenceInfo info2) {
                        Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
                        H2Sequence sequence = this.$sequences.createOrGet(info2.sequence_name);
                        Intrinsics.checkNotNull((Object)sequence);
                        H2SchemaAbstractSchemaRetriever.processSequenceLike$default(this.this$0, sequence, info2, false, 4, null);
                        sequence.setNameSurrogate(info2.is_generated);
                        Object object = StringKt.nullize$default((String)info2.remarks, (boolean)false, (int)1, null);
                        if (object == null) {
                            if (info2.is_generated) {
                                ++this.$order.element;
                                object = "#" + this.$order.element;
                            } else {
                                object = null;
                            }
                        }
                        sequence.setComment((String)object);
                    }
                }));
            }
            catch (DBException e$iv) {
                this_$iv.getErrorSink().consume(null, (Object)e$iv);
            }
            $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
            $this$modifyAndCleanup_u24default$iv.sort();
        }

        private final void processSequenceLike(H2Sequence sequence, H2IntroQueries.SequenceLikeInfo info2, boolean isIdentity) {
            SequenceIdentity sequenceIdentity;
            BigInteger bigInteger;
            BigInteger bigInteger2;
            BigInteger bigInteger3;
            BigInteger bigInteger4;
            BigInteger bigInteger5;
            BigInteger bigInteger6;
            Long l = info2.getStart_value();
            if (l != null) {
                BigInteger bigInteger7 = BigInteger.valueOf(l);
                bigInteger6 = bigInteger7;
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger7, (String)"valueOf(...)");
            } else {
                bigInteger6 = null;
            }
            BigInteger start2 = bigInteger6;
            Long l2 = info2.getLast_value();
            if (l2 != null) {
                BigInteger bigInteger8 = BigInteger.valueOf(l2);
                bigInteger5 = bigInteger8;
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger8, (String)"valueOf(...)");
            } else {
                bigInteger5 = null;
            }
            BigInteger last2 = bigInteger5;
            Long l3 = info2.getNext_value();
            if (l3 != null) {
                BigInteger bigInteger9 = BigInteger.valueOf(l3);
                bigInteger4 = bigInteger9;
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger9, (String)"valueOf(...)");
            } else {
                bigInteger4 = null;
            }
            BigInteger next = bigInteger4;
            Long l4 = info2.getMin_value();
            if (l4 != null) {
                BigInteger bigInteger10 = BigInteger.valueOf(l4);
                bigInteger3 = bigInteger10;
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger10, (String)"valueOf(...)");
            } else {
                bigInteger3 = null;
            }
            BigInteger minimum = bigInteger3;
            Long l5 = info2.getMax_value();
            if (l5 != null) {
                BigInteger bigInteger11 = BigInteger.valueOf(l5);
                bigInteger2 = bigInteger11;
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger11, (String)"valueOf(...)");
            } else {
                bigInteger2 = null;
            }
            BigInteger maximum = bigInteger2;
            Long l6 = info2.getIncrement();
            if (l6 != null) {
                BigInteger bigInteger12 = BigInteger.valueOf(l6);
                bigInteger = bigInteger12;
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger12, (String)"valueOf(...)");
            } else {
                bigInteger = null;
            }
            BigInteger increment = bigInteger;
            boolean isAsc = BaseIntrospectionFunctions.isAscSequenceIncrement$default(increment, false, 1, null);
            H2Sequence h2Sequence = sequence;
            H2Introspector h2Introspector = H2Introspector.this;
            H2Sequence $this$processSequenceLike_u24lambda_u2434 = h2Sequence;
            boolean bl = false;
            $this$processSequenceLike_u24lambda_u2434.setDasType(this.dasType(info2));
            $this$processSequenceLike_u24lambda_u2434.setStartValue(start2);
            if (!isIdentity) {
                sequenceIdentity = SequenceIdentity.UNKNOWN;
            } else {
                DasType dasType = $this$processSequenceLike_u24lambda_u2434.getDasType();
                Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"getDasType(...)");
                BigInteger bigInteger13 = h2Introspector.isNewSchema() ? next : BaseIntrospectionFunctions.nextByLast(last2, increment, start2);
                DasType dasType2 = $this$processSequenceLike_u24lambda_u2434.getDasType();
                Intrinsics.checkNotNullExpressionValue((Object)dasType2, (String)"getDasType(...)");
                sequenceIdentity = SequenceIdentity.of(BaseIntrospectionFunctions.nullize(minimum, this.sequenceUnlimitedMinimumDefault(isAsc, dasType)), bigInteger13, increment, BaseIntrospectionFunctions.nullize(maximum, this.sequenceUnlimitedMaximumDefault(isAsc, dasType2)));
            }
            $this$processSequenceLike_u24lambda_u2434.setSequenceIdentity(sequenceIdentity);
            $this$processSequenceLike_u24lambda_u2434.setCacheSize(info2.getCache());
            $this$processSequenceLike_u24lambda_u2434.setCycled(info2.is_cycle());
        }

        static /* synthetic */ void processSequenceLike$default(H2SchemaAbstractSchemaRetriever h2SchemaAbstractSchemaRetriever, H2Sequence h2Sequence, H2IntroQueries.SequenceLikeInfo sequenceLikeInfo, boolean bl, int n, Object object) {
            if ((n & 4) != 0) {
                bl = true;
            }
            h2SchemaAbstractSchemaRetriever.processSequenceLike(h2Sequence, sequenceLikeInfo, bl);
        }

        /*
         * Unable to fully structure code
         */
        private final DasType dasType(H2IntroQueries.SequenceLikeInfo $this$dasType) {
            block17: {
                block16: {
                    if (!H2Introspector.access$isV2(H2Introspector.this)) {
                        v0 = H2Introspector.access$getTypeSystem$p(H2Introspector.this);
                        v1 = DataTypeFactory.of("BIGINT");
                        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"of(...)");
                        return v0.createDasType(v1);
                    }
                    size = -1;
                    typeName = null;
                    seq_type_name = $this$dasType.getSeq_type_name();
                    if (seq_type_name == null) break block16;
                    switch (seq_type_name.hashCode()) {
                        case -1282431251: {
                            if (seq_type_name.equals("NUMERIC")) break;
                            ** break;
                        }
                        case 176095624: {
                            if (!seq_type_name.equals("SMALLINT")) {
                                ** break;
                            }
                            ** GOTO lbl39
                        }
                        case 2511262: {
                            if (!seq_type_name.equals("REAL")) {
                                ** break;
                            }
                            ** GOTO lbl39
                        }
                        case 1959128815: {
                            if (!seq_type_name.equals("BIGINT")) {
                                ** break;
                            }
                            ** GOTO lbl39
                        }
                        case 1345372058: {
                            if (seq_type_name.equals("DECFLOAT")) break;
                            ** break;
                        }
                        case -594415409: {
                            if (!seq_type_name.equals("TINYINT")) {
                                ** break;
                            }
                            ** GOTO lbl39
                        }
                        case 1770063567: {
                            if (!seq_type_name.equals("DOUBLE PRECISION")) {
                                ** break;
                            }
                            ** GOTO lbl39
                        }
                        case -1618932450: {
                            if (!seq_type_name.equals("INTEGER")) ** break;
lbl39:
                            // 6 sources

                            typeName = seq_type_name;
                            break block17;
                        }
                    }
                    typeName = seq_type_name;
                    size = $this$dasType.getSeq_numeric_scale() == 0 ? H2Introspector.access$maskDefaultPrecision(H2Introspector.this, $this$dasType.getSeq_numeric_precision(), 19) : $this$dasType.getSeq_numeric_precision();
                    break block17;
                }
                typeName = "BIGINT";
            }
            v2 = DataTypeFactory.of(null, typeName, size, 0, null, null, false, false);
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"of(...)");
            dataType = v2;
            return H2Introspector.access$getTypeSystem$p(H2Introspector.this).createDasType(dataType);
        }

        private final BigInteger sequenceUnlimitedMinimumDefault(boolean isAsc, DasType type) {
            return isAsc ? null : this.getLowerBound(type);
        }

        private final BigInteger sequenceUnlimitedMaximumDefault(boolean isAsc, DasType type) {
            return isAsc ? this.getUpperBound(type) : null;
        }

        /*
         * Enabled aggressive block sorting
         */
        private final BigInteger getLowerBound(DasType $this$lowerBound) {
            BigInteger bigInteger;
            String string = StringUtil.toUpperCase((String)DasTypeUtilsKt.getTypeName($this$lowerBound));
            if (string != null) {
                int n = -1;
                switch (string.hashCode()) {
                    case -1282431251: {
                        if (!string.equals("NUMERIC")) break;
                        n = 1;
                        break;
                    }
                    case 2511262: {
                        if (!string.equals("REAL")) break;
                        n = 2;
                        break;
                    }
                    case -2034720975: {
                        if (!string.equals("DECIMAL")) break;
                        n = 1;
                        break;
                    }
                    case 1345372058: {
                        if (!string.equals("DECFLOAT")) break;
                        n = 3;
                        break;
                    }
                    case -594415409: {
                        if (!string.equals("TINYINT")) break;
                        n = 4;
                        break;
                    }
                    case 1770063567: {
                        if (!string.equals("DOUBLE PRECISION")) break;
                        n = 5;
                        break;
                    }
                }
                switch (n) {
                    case 4: {
                        BigInteger bigInteger2 = BigInteger.valueOf(-128);
                        bigInteger = bigInteger2;
                        Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"valueOf(...)");
                        return bigInteger;
                    }
                    case 2: {
                        BigInteger bigInteger3 = BigInteger.valueOf(-16777216);
                        bigInteger = bigInteger3;
                        Intrinsics.checkNotNullExpressionValue((Object)bigInteger3, (String)"valueOf(...)");
                        return bigInteger;
                    }
                    case 5: {
                        BigInteger bigInteger4 = BigInteger.valueOf(-9007199254740992L);
                        bigInteger = bigInteger4;
                        Intrinsics.checkNotNullExpressionValue((Object)bigInteger4, (String)"valueOf(...)");
                        return bigInteger;
                    }
                    case 1: {
                        BigInteger bigInteger5 = BigInteger.valueOf(this.decimalLowerBound($this$lowerBound, true));
                        bigInteger = bigInteger5;
                        Intrinsics.checkNotNullExpressionValue((Object)bigInteger5, (String)"valueOf(...)");
                        return bigInteger;
                    }
                    case 3: {
                        BigInteger bigInteger6 = BigInteger.valueOf(this.decimalLowerBound($this$lowerBound, false));
                        bigInteger = bigInteger6;
                        Intrinsics.checkNotNullExpressionValue((Object)bigInteger6, (String)"valueOf(...)");
                        return bigInteger;
                    }
                }
            }
            BigInteger bigInteger7 = DasTypeUtilsKt.getMinValue($this$lowerBound);
            bigInteger = bigInteger7;
            if (bigInteger7 != null) return bigInteger;
            BigInteger bigInteger8 = BigInteger.valueOf(Long.MIN_VALUE);
            bigInteger = bigInteger8;
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger8, (String)"valueOf(...)");
            return bigInteger;
        }

        private final long decimalLowerBound(DasType $this$decimalLowerBound, boolean exclusive) {
            long upperBound = this.decimalUpperBound($this$decimalLowerBound, exclusive);
            return upperBound == Long.MAX_VALUE ? Long.MIN_VALUE : -upperBound;
        }

        /*
         * Enabled aggressive block sorting
         */
        private final BigInteger getUpperBound(DasType $this$upperBound) {
            BigInteger bigInteger;
            String string = StringUtil.toUpperCase((String)DasTypeUtilsKt.getTypeName($this$upperBound));
            if (string != null) {
                int n = -1;
                switch (string.hashCode()) {
                    case -1282431251: {
                        if (!string.equals("NUMERIC")) break;
                        n = 1;
                        break;
                    }
                    case 2511262: {
                        if (!string.equals("REAL")) break;
                        n = 2;
                        break;
                    }
                    case -2034720975: {
                        if (!string.equals("DECIMAL")) break;
                        n = 1;
                        break;
                    }
                    case 1345372058: {
                        if (!string.equals("DECFLOAT")) break;
                        n = 3;
                        break;
                    }
                    case -594415409: {
                        if (!string.equals("TINYINT")) break;
                        n = 4;
                        break;
                    }
                    case 1770063567: {
                        if (!string.equals("DOUBLE PRECISION")) break;
                        n = 5;
                        break;
                    }
                }
                switch (n) {
                    case 4: {
                        BigInteger bigInteger2 = BigInteger.valueOf(127);
                        bigInteger = bigInteger2;
                        Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"valueOf(...)");
                        return bigInteger;
                    }
                    case 2: {
                        BigInteger bigInteger3 = BigInteger.valueOf(0x1000000);
                        bigInteger = bigInteger3;
                        Intrinsics.checkNotNullExpressionValue((Object)bigInteger3, (String)"valueOf(...)");
                        return bigInteger;
                    }
                    case 5: {
                        BigInteger bigInteger4 = BigInteger.valueOf(0x20000000000000L);
                        bigInteger = bigInteger4;
                        Intrinsics.checkNotNullExpressionValue((Object)bigInteger4, (String)"valueOf(...)");
                        return bigInteger;
                    }
                    case 1: {
                        BigInteger bigInteger5 = BigInteger.valueOf(this.decimalUpperBound($this$upperBound, true));
                        bigInteger = bigInteger5;
                        Intrinsics.checkNotNullExpressionValue((Object)bigInteger5, (String)"valueOf(...)");
                        return bigInteger;
                    }
                    case 3: {
                        BigInteger bigInteger6 = BigInteger.valueOf(this.decimalUpperBound($this$upperBound, false));
                        bigInteger = bigInteger6;
                        Intrinsics.checkNotNullExpressionValue((Object)bigInteger6, (String)"valueOf(...)");
                        return bigInteger;
                    }
                }
            }
            BigInteger bigInteger7 = DasTypeUtilsKt.getMaxValue($this$upperBound);
            bigInteger = bigInteger7;
            if (bigInteger7 != null) return bigInteger;
            BigInteger bigInteger8 = BigInteger.valueOf(Long.MAX_VALUE);
            bigInteger = bigInteger8;
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger8, (String)"valueOf(...)");
            return bigInteger;
        }

        /*
         * WARNING - void declaration
         */
        private final long decimalUpperBound(DasType $this$decimalUpperBound, boolean exclusive) {
            long l;
            DataType dataType = $this$decimalUpperBound.toDataType();
            Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"toDataType(...)");
            DataType dt = dataType;
            int p2 = dt.getPrecision() - dt.scale;
            boolean bl = 1 <= p2 ? p2 < 19 : false;
            if (bl) {
                void $this$fold$iv;
                Iterable iterable = (Iterable)new IntRange(1, p2);
                long initial$iv = 1L;
                boolean $i$f$fold = false;
                long accumulator$iv = initial$iv;
                Iterator iterator = $this$fold$iv.iterator();
                while (iterator.hasNext()) {
                    int element$iv = ((IntIterator)iterator).nextInt();
                    long res2 = accumulator$iv;
                    boolean bl2 = false;
                    accumulator$iv = res2 * (long)10;
                }
                long result2 = accumulator$iv;
                if (exclusive) {
                    long l2 = result2;
                    result2 = l2 + -1L;
                }
                l = result2;
            } else {
                l = Long.MAX_VALUE;
            }
            return l;
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveRoutines(H2Schema schema2) {
            void $this$mapTo$iv$iv;
            void families$iv;
            ObjectKind objectKind = ObjectKind.ROUTINE;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"ROUTINE");
            H2Introspector.this.reportRetrieving(objectKind);
            HashMap<String, H2LikeRoutine> aliasMap = new HashMap<String, H2LikeRoutine>();
            ModNamingFamily<? extends H2Routine> modNamingFamily = schema2.getRoutines();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getRoutines(...)");
            ModNamingFamily<? extends H2Routine> routines = modNamingFamily;
            ModNamingFamily<? extends H2Aggregate> modNamingFamily2 = schema2.getAggregates();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily2, (String)"getAggregates(...)");
            ModNamingFamily<? extends H2Aggregate> aggregates = modNamingFamily2;
            ModFamily[] modFamilyArray = new ModFamily[]{routines, aggregates};
            Object object = H2Introspector.this;
            boolean inc$iv = true;
            boolean $i$f$modifyFamiliesAndCleanup = false;
            for (void f$iv : families$iv) {
                f$iv.markChildrenAsSyncPending();
            }
            boolean bl3 = false;
            BaseNativeIntrospector this_$iv = (BaseNativeIntrospector)object;
            boolean $i$f$continueOnDbError = false;
            try {
                boolean bl2 = false;
                H2IntroQueries.INSTANCE.processRoutines(this.getTransaction(), schema2, (Function1<? super H2IntroQueries.RoutineInfo, Unit>)((Function1)new Function1<H2IntroQueries.RoutineInfo, Unit>(aggregates, routines, aliasMap, this){
                    final /* synthetic */ ModNamingFamily<? extends H2Aggregate> $aggregates;
                    final /* synthetic */ ModNamingFamily<? extends H2Routine> $routines;
                    final /* synthetic */ HashMap<String, H2LikeRoutine> $aliasMap;
                    final /* synthetic */ H2SchemaAbstractSchemaRetriever this$0;
                    {
                        this.$aggregates = $aggregates;
                        this.$routines = $routines;
                        this.$aliasMap = $aliasMap;
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull H2IntroQueries.RoutineInfo info2) {
                        H2LikeRoutine h2LikeRoutine;
                        Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
                        String aliasName = info2.alias_name;
                        int colCount = info2.column_count;
                        Object object = info2.source;
                        if ((object == null || object.length() == 0) && ((object = (CharSequence)info2.java_method) == null || object.length() == 0)) {
                            h2LikeRoutine = this.$aggregates.createOrGet(aliasName);
                        } else {
                            Object object2;
                            object = (H2Routine)this.$routines.find(arg_0 -> retrieveRoutines.1.1.1.invoke$lambda$0((Function1)new Function1<H2Routine, Boolean>(aliasName, colCount){
                                final /* synthetic */ String $aliasName;
                                final /* synthetic */ int $colCount;
                                {
                                    this.$aliasName = $aliasName;
                                    this.$colCount = $colCount;
                                    super(1);
                                }

                                @NotNull
                                public final Boolean invoke(H2Routine it2) {
                                    return Intrinsics.areEqual((Object)it2.getName(), (Object)this.$aliasName) && it2.getArguments().size() == this.$colCount + 1;
                                }
                            }, arg_0));
                            if (object != null) {
                                Object object3;
                                Object $this$invoke_u24lambda_u241 = object3 = object;
                                boolean bl = false;
                                $this$invoke_u24lambda_u241.resetSyncPending();
                                object2 = object3;
                            } else {
                                E e2 = this.$routines.createNewOne();
                                H2Routine $this$invoke_u24lambda_u242 = (H2Routine)e2;
                                boolean bl = false;
                                $this$invoke_u24lambda_u242.setName(aliasName);
                                object2 = (H2Routine)e2;
                            }
                            h2LikeRoutine = (H2LikeRoutine)object2;
                        }
                        H2LikeRoutine routine2 = h2LikeRoutine;
                        Map map2 = this.$aliasMap;
                        String string = aliasName + "/" + colCount;
                        Intrinsics.checkNotNull((Object)routine2);
                        map2.put(string, routine2);
                        object = this.this$0;
                        H2LikeRoutine $this$invoke_u24lambda_u243 = routine2;
                        boolean bl = false;
                        $this$invoke_u24lambda_u243.setRoutineKind(info2.is_func ? DasRoutine.Kind.FUNCTION : DasRoutine.Kind.PROCEDURE);
                        if ($this$invoke_u24lambda_u243 instanceof H2Routine) {
                            ((H2Routine)$this$invoke_u24lambda_u243).setJavaClass(info2.java_class);
                            String string2 = info2.source;
                            ((H2Routine)$this$invoke_u24lambda_u243).setSourceText(string2 != null && (string2 = StringKt.nullize$default((String)string2, (boolean)false, (int)1, null)) != null ? H2SchemaAbstractSchemaRetriever.access$toCompositeText((H2SchemaAbstractSchemaRetriever)object, string2) : null);
                            ((H2Routine)$this$invoke_u24lambda_u243).setJavaMethod(info2.java_method);
                        } else {
                            $this$invoke_u24lambda_u243.setJavaClass(info2.java_class);
                        }
                        $this$invoke_u24lambda_u243.setComment(info2.remarks);
                    }

                    private static final boolean invoke$lambda$0(Function1 $tmp0, Object p0) {
                        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                        return (Boolean)$tmp0.invoke(p0);
                    }
                }));
            }
            catch (DBException e$iv) {
                this_$iv.getErrorSink().consume(null, (Object)e$iv);
            }
            int n = ((void)families$iv).length;
            for (int j = 0; j < n; ++j) {
                void f$iv;
                f$iv = families$iv[j];
                f$iv.removeSyncPendingChildren();
                f$iv.sort();
            }
            Iterable $this$map$iv = routines;
            boolean $i$f$map = false;
            object = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                H2Routine bl3 = (H2Routine)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl4 = false;
                collection2.add(it2.getArguments());
            }
            $this$map$iv = (List)destination$iv$iv;
            object = H2Introspector.this;
            inc$iv = true;
            $i$f$modifyFamiliesAndCleanup = false;
            void $this$toTypedArray$iv$iv = families$iv;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv$iv = $this$toTypedArray$iv$iv;
            ModFamily[] fs$iv = thisCollection$iv$iv.toArray(new ModPositioningNamingFamily[0]);
            ModFamily[] families$iv$iv = Arrays.copyOf(fs$iv, fs$iv.length);
            boolean $i$f$modifyFamiliesAndCleanup2 = false;
            for (ModFamily f$iv$iv : families$iv$iv) {
                f$iv$iv.markChildrenAsSyncPending();
            }
            boolean bl5 = false;
            BaseNativeIntrospector this_$iv2 = (BaseNativeIntrospector)object;
            boolean $i$f$continueOnDbError2 = false;
            try {
                boolean bl6 = false;
                H2IntroQueries.INSTANCE.processRoutineArguments(this.getTransaction(), schema2, (Function1<? super H2IntroQueries.RoutineArgumentInfo, Unit>)((Function1)new Function1<H2IntroQueries.RoutineArgumentInfo, Unit>(aliasMap, this){
                    final /* synthetic */ HashMap<String, H2LikeRoutine> $aliasMap;
                    final /* synthetic */ H2SchemaAbstractSchemaRetriever this$0;
                    {
                        this.$aliasMap = $aliasMap;
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull H2IntroQueries.RoutineArgumentInfo info2) {
                        Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
                        H2LikeRoutine h2LikeRoutine = this.$aliasMap.get(info2.alias_name + "/" + info2.column_count);
                        if (h2LikeRoutine == null) {
                            return;
                        }
                        H2LikeRoutine routine2 = h2LikeRoutine;
                        E e2 = routine2.getArguments().createOrGetAt(info2.pos);
                        H2SchemaAbstractSchemaRetriever h2SchemaAbstractSchemaRetriever = this.this$0;
                        H2Argument $this$invoke_u24lambda_u240 = (H2Argument)e2;
                        boolean bl = false;
                        $this$invoke_u24lambda_u240.setName(info2.column_name);
                        $this$invoke_u24lambda_u240.setArgumentDirection(info2._column_type == 5 ? ArgumentDirection.RETURN : ArgumentDirection.IN);
                        $this$invoke_u24lambda_u240.setDasType(H2SchemaAbstractSchemaRetriever.access$getDasType(h2SchemaAbstractSchemaRetriever, info2));
                    }
                }));
            }
            catch (DBException e$iv) {
                this_$iv2.getErrorSink().consume(null, (Object)e$iv);
            }
            for (ModFamily f$iv$iv : families$iv$iv) {
                f$iv$iv.removeSyncPendingChildren();
                f$iv$iv.sort();
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveRoutinesV2(H2Schema schema2) {
            void $this$mapTo$iv$iv;
            void families$iv;
            ObjectKind objectKind = ObjectKind.ROUTINE;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"ROUTINE");
            H2Introspector.this.reportRetrieving(objectKind);
            HashMap<String, H2LikeRoutine> routineMap = new HashMap<String, H2LikeRoutine>();
            ModNamingFamily<? extends H2Routine> modNamingFamily = schema2.getRoutines();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getRoutines(...)");
            ModNamingFamily<? extends H2Routine> routines = modNamingFamily;
            ModNamingFamily<? extends H2Aggregate> modNamingFamily2 = schema2.getAggregates();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily2, (String)"getAggregates(...)");
            ModNamingFamily<? extends H2Aggregate> aggregates = modNamingFamily2;
            ModFamily[] modFamilyArray = new ModFamily[]{routines, aggregates};
            Object object = H2Introspector.this;
            boolean inc$iv = true;
            boolean $i$f$modifyFamiliesAndCleanup = false;
            for (void f$iv : families$iv) {
                f$iv.markChildrenAsSyncPending();
            }
            boolean bl5 = false;
            BaseNativeIntrospector this_$iv = (BaseNativeIntrospector)object;
            boolean $i$f$continueOnDbError = false;
            try {
                H2LikeRoutine h2LikeRoutine;
                String string;
                Map map2;
                H2LikeRoutine it2;
                boolean bl2 = false;
                Iterable $this$forEach$iv = routines;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it2 = (H2Routine)element$iv;
                    boolean bl3 = false;
                    map2 = routineMap;
                    String string2 = it2.getSpecificName();
                    if (string2 == null) {
                        string2 = "";
                    }
                    string = string2;
                    Intrinsics.checkNotNull((Object)string);
                    Intrinsics.checkNotNull((Object)it2);
                    h2LikeRoutine = it2;
                    map2.put(string, h2LikeRoutine);
                }
                $this$forEach$iv = aggregates;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it2 = (H2Aggregate)element$iv;
                    boolean bl4 = false;
                    map2 = routineMap;
                    String string3 = it2.getSpecificName();
                    if (string3 == null) {
                        string3 = "";
                    }
                    string = string3;
                    Intrinsics.checkNotNull((Object)string);
                    Intrinsics.checkNotNull((Object)it2);
                    h2LikeRoutine = it2;
                    map2.put(string, h2LikeRoutine);
                }
                H2IntroQueries.INSTANCE.processRoutinesV2(this.getTransaction(), schema2, ((H2Introspector)object).isNewSchema(), (Function1<? super H2IntroQueries.RoutineInfoV2, Unit>)((Function1)new Function1<H2IntroQueries.RoutineInfoV2, Unit>(aggregates, routines, routineMap, this){
                    final /* synthetic */ ModNamingFamily<? extends H2Aggregate> $aggregates;
                    final /* synthetic */ ModNamingFamily<? extends H2Routine> $routines;
                    final /* synthetic */ HashMap<String, H2LikeRoutine> $routineMap;
                    final /* synthetic */ H2SchemaAbstractSchemaRetriever this$0;
                    {
                        this.$aggregates = $aggregates;
                        this.$routines = $routines;
                        this.$routineMap = $routineMap;
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull H2IntroQueries.RoutineInfoV2 info2) {
                        H2LikeRoutine h2LikeRoutine;
                        Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
                        String routineName = info2.routine_name;
                        String string = info2.specific_name;
                        if (string == null) {
                            return;
                        }
                        String specificName = string;
                        boolean isAggregate = Intrinsics.areEqual((Object)info2.routine_type, (Object)"AGGREGATE");
                        boolean isFunction = Intrinsics.areEqual((Object)info2.routine_type, (Object)"FUNCTION");
                        ModNamingFamily<H2LikeRoutine> family = isAggregate ? this.$aggregates : this.$routines;
                        H2LikeRoutine h2LikeRoutine2 = this.$routineMap.get(specificName);
                        if (h2LikeRoutine2 != null) {
                            H2LikeRoutine $this$invoke_u24lambda_u240 = var11_7 = h2LikeRoutine2;
                            boolean bl = false;
                            $this$invoke_u24lambda_u240.resetSyncPending();
                            h2LikeRoutine = var11_7;
                        } else {
                            var11_7 = family.createNewOne();
                            HashMap<String, H2LikeRoutine> hashMap = this.$routineMap;
                            H2LikeRoutine $this$invoke_u24lambda_u241 = var11_7;
                            boolean bl = false;
                            $this$invoke_u24lambda_u241.setName(routineName);
                            ((Map)hashMap).put(specificName, $this$invoke_u24lambda_u241);
                            h2LikeRoutine = var11_7;
                        }
                        Object object = h2LikeRoutine;
                        Intrinsics.checkNotNull((Object)object);
                        H2LikeRoutine routine2 = object;
                        routine2.setSpecificName(specificName);
                        object = this.this$0;
                        H2LikeRoutine $this$invoke_u24lambda_u242 = routine2;
                        boolean bl = false;
                        $this$invoke_u24lambda_u242.setRoutineKind(isFunction ? DasRoutine.Kind.FUNCTION : DasRoutine.Kind.PROCEDURE);
                        if ($this$invoke_u24lambda_u242 instanceof H2Routine) {
                            ((H2Routine)$this$invoke_u24lambda_u242).setJavaClass(H2SchemaAbstractSchemaRetriever.access$javaClassName((H2SchemaAbstractSchemaRetriever)object, info2));
                            ((H2Routine)$this$invoke_u24lambda_u242).setJavaMethod(H2SchemaAbstractSchemaRetriever.access$javaMethodName((H2SchemaAbstractSchemaRetriever)object, info2));
                            String string2 = info2.routine_definition;
                            ((H2Routine)$this$invoke_u24lambda_u242).setSourceText(string2 != null && (string2 = StringKt.nullize$default((String)string2, (boolean)false, (int)1, null)) != null ? H2SchemaAbstractSchemaRetriever.access$toCompositeText((H2SchemaAbstractSchemaRetriever)object, string2) : null);
                        } else {
                            $this$invoke_u24lambda_u242.setJavaClass(info2.external_name);
                        }
                        if (isFunction) {
                            $this$invoke_u24lambda_u242.createOrGetReturnArgument().setDasType(H2SchemaAbstractSchemaRetriever.access$getDasType((H2SchemaAbstractSchemaRetriever)object, info2));
                        }
                        $this$invoke_u24lambda_u242.setComment(info2.remarks);
                    }
                }));
            }
            catch (DBException e$iv) {
                this_$iv.getErrorSink().consume(null, (Object)e$iv);
            }
            int n = ((void)families$iv).length;
            for (int j = 0; j < n; ++j) {
                void f$iv;
                f$iv = families$iv[j];
                f$iv.removeSyncPendingChildren();
                f$iv.sort();
            }
            Iterable $this$map$iv = routines;
            boolean $i$f$map = false;
            object = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it3;
                H2Routine bl5 = (H2Routine)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl6 = false;
                collection2.add(it3.getArguments());
            }
            $this$map$iv = (List)destination$iv$iv;
            object = H2Introspector.this;
            inc$iv = true;
            $i$f$modifyFamiliesAndCleanup = false;
            void $this$toTypedArray$iv$iv = families$iv;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv$iv = $this$toTypedArray$iv$iv;
            ModFamily[] fs$iv = thisCollection$iv$iv.toArray(new ModPositioningNamingFamily[0]);
            ModFamily[] families$iv$iv = Arrays.copyOf(fs$iv, fs$iv.length);
            boolean $i$f$modifyFamiliesAndCleanup2 = false;
            for (ModFamily f$iv$iv : families$iv$iv) {
                f$iv$iv.markChildrenAsSyncPending();
            }
            boolean bl7 = false;
            BaseNativeIntrospector this_$iv2 = (BaseNativeIntrospector)object;
            boolean $i$f$continueOnDbError2 = false;
            try {
                boolean bl8 = false;
                H2IntroQueries.INSTANCE.processRoutineArgumentsV2(this.getTransaction(), schema2, ((H2Introspector)object).isNewSchema(), (Function1<? super H2IntroQueries.RoutineArgumentInfoV2, Unit>)((Function1)new Function1<H2IntroQueries.RoutineArgumentInfoV2, Unit>(routineMap, this){
                    final /* synthetic */ HashMap<String, H2LikeRoutine> $routineMap;
                    final /* synthetic */ H2SchemaAbstractSchemaRetriever this$0;
                    {
                        this.$routineMap = $routineMap;
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull H2IntroQueries.RoutineArgumentInfoV2 info2) {
                        Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
                        H2LikeRoutine h2LikeRoutine = this.$routineMap.get(info2.specific_name);
                        if (h2LikeRoutine == null) {
                            return;
                        }
                        H2LikeRoutine routine2 = h2LikeRoutine;
                        E e2 = routine2.getArguments().createOrGetAt(info2.ordinal_position);
                        H2SchemaAbstractSchemaRetriever h2SchemaAbstractSchemaRetriever = this.this$0;
                        H2Argument $this$invoke_u24lambda_u240 = (H2Argument)e2;
                        boolean bl = false;
                        $this$invoke_u24lambda_u240.setName(info2.parameter_name);
                        $this$invoke_u24lambda_u240.setArgumentDirection(ArgumentDirection.IN);
                        $this$invoke_u24lambda_u240.setDasType(H2SchemaAbstractSchemaRetriever.access$getDasType(h2SchemaAbstractSchemaRetriever, info2));
                    }
                }));
                Iterable $this$forEach$iv = routines;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    H2Routine it4 = (H2Routine)element$iv;
                    boolean bl9 = false;
                    BasicModArgument basicModArgument = (BasicModArgument)it4.getReturnArgument();
                    if (basicModArgument == null) continue;
                    basicModArgument.resetSyncPending();
                }
            }
            catch (DBException e$iv) {
                this_$iv2.getErrorSink().consume(null, (Object)e$iv);
            }
            for (ModFamily f$iv$iv : families$iv$iv) {
                f$iv$iv.removeSyncPendingChildren();
                f$iv$iv.sort();
            }
        }

        private final String javaMethodName(H2IntroQueries.RoutineInfoV2 $this$javaMethodName) {
            String string;
            if ($this$javaMethodName.external_name == null) {
                return null;
            }
            String string2 = $this$javaMethodName.external_name;
            Intrinsics.checkNotNull((Object)string2);
            int p2 = StringsKt.lastIndexOf$default((CharSequence)string2, (char)'.', (int)0, (boolean)false, (int)6, null);
            if (p2 >= 0) {
                String string3;
                String string4 = $this$javaMethodName.external_name;
                Intrinsics.checkNotNull((Object)string4);
                String string5 = string4.substring(p2 + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
                String it2 = string3 = string5;
                boolean bl = false;
                string = !Intrinsics.areEqual((Object)it2, (Object)"null") ? string3 : null;
            } else {
                string = null;
            }
            return string;
        }

        private final String javaClassName(H2IntroQueries.RoutineInfoV2 $this$javaClassName) {
            String string;
            if ($this$javaClassName.external_name == null) {
                return null;
            }
            String string2 = $this$javaClassName.external_name;
            Intrinsics.checkNotNull((Object)string2);
            int p2 = StringsKt.lastIndexOf$default((CharSequence)string2, (char)'.', (int)0, (boolean)false, (int)6, null);
            if (p2 >= 0) {
                String string3;
                String string4 = $this$javaClassName.external_name;
                Intrinsics.checkNotNull((Object)string4);
                String string5 = string4.substring(0, p2);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
                String it2 = string3 = string5;
                boolean bl = false;
                string = !Intrinsics.areEqual((Object)it2, (Object)"null") ? string3 : null;
            } else {
                string = null;
            }
            return string;
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveConstants(H2Schema schema2) {
            void $this$modifyAndCleanup_u24default$iv;
            ObjectKind objectKind = ObjectKind.CONSTANT;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"CONSTANT");
            H2Introspector.this.reportRetrieving(objectKind);
            ModFamily modFamily = schema2.getConstants();
            H2Introspector h2Introspector = H2Introspector.this;
            boolean inc$iv = true;
            boolean $i$f$modifyAndCleanup = false;
            $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
            ModNamingFamily constants = (ModNamingFamily)$this$modifyAndCleanup_u24default$iv;
            boolean bl = false;
            BaseNativeIntrospector this_$iv = h2Introspector;
            boolean $i$f$continueOnDbError = false;
            try {
                boolean bl2 = false;
                H2IntroQueries.INSTANCE.processConstants(this.getTransaction(), schema2, h2Introspector.isNewSchema(), (Function1<? super H2IntroQueries.ConstantInfo, Unit>)((Function1)new Function1<H2IntroQueries.ConstantInfo, Unit>((ModNamingFamily<? extends H2Constant>)constants){
                    final /* synthetic */ ModNamingFamily<? extends H2Constant> $constants;
                    {
                        this.$constants = $constants;
                        super(1);
                    }

                    public final void invoke(@NotNull H2IntroQueries.ConstantInfo info2) {
                        String string;
                        H2Constant h2Constant;
                        Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
                        H2Constant $this$invoke_u24lambda_u240 = h2Constant = this.$constants.createOrGet(info2.constant_name);
                        boolean bl = false;
                        int num = StringUtil.parseInt((String)info2.data_type, (int)Integer.MIN_VALUE);
                        if (num == Integer.MIN_VALUE) {
                            string = info2.data_type;
                        } else {
                            String string2 = JdbcUtil.getJdbcTypeName(num);
                            string = string2;
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getJdbcTypeName(...)");
                        }
                        String typeName = string;
                        Intrinsics.checkNotNull((Object)$this$invoke_u24lambda_u240);
                        DasTypeSystemBase dasTypeSystemBase = DasTypeUtilsKt.getTypeSystem($this$invoke_u24lambda_u240);
                        DataType dataType = DataTypeFactory.of(typeName);
                        Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"of(...)");
                        $this$invoke_u24lambda_u240.setDasType(dasTypeSystemBase.createDasType(dataType));
                        $this$invoke_u24lambda_u240.setValue(info2.sql);
                        $this$invoke_u24lambda_u240.setComment(info2.remarks);
                    }
                }));
            }
            catch (DBException e$iv) {
                this_$iv.getErrorSink().consume(null, (Object)e$iv);
            }
            $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
            $this$modifyAndCleanup_u24default$iv.sort();
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveSynonyms(H2Schema schema2) {
            void $this$modifyAndCleanup_u24default$iv;
            Object object = new int[]{1, 4, 197};
            if (!H2Introspector.this.getServerVersion().isOrGreater((int)object)) {
                return;
            }
            ObjectKind objectKind = ObjectKind.SYNONYM;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"SYNONYM");
            H2Introspector.this.reportRetrieving(objectKind);
            object = schema2.getSynonyms();
            H2Introspector h2Introspector = H2Introspector.this;
            boolean inc$iv = true;
            boolean $i$f$modifyAndCleanup = false;
            $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
            ModNamingFamily synonyms = (ModNamingFamily)$this$modifyAndCleanup_u24default$iv;
            boolean bl = false;
            BaseNativeIntrospector this_$iv = h2Introspector;
            boolean $i$f$continueOnDbError = false;
            try {
                boolean bl2 = false;
                H2IntroQueries.INSTANCE.processSynonyms(this.getTransaction(), schema2, (Function1<? super H2IntroQueries.SynonymInfo, Unit>)((Function1)new Function1<H2IntroQueries.SynonymInfo, Unit>((ModNamingFamily<? extends H2Synonym>)synonyms){
                    final /* synthetic */ ModNamingFamily<? extends H2Synonym> $synonyms;
                    {
                        this.$synonyms = $synonyms;
                        super(1);
                    }

                    public final void invoke(@NotNull H2IntroQueries.SynonymInfo info2) {
                        H2Synonym h2Synonym;
                        Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
                        H2Synonym $this$invoke_u24lambda_u240 = h2Synonym = this.$synonyms.createOrGet(info2.synonym_name);
                        boolean bl = false;
                        $this$invoke_u24lambda_u240.setTargetObjectRef(BasicParentReference.create(info2.synonym_for_schema, BasicNameReference.create(info2.synonym_for)));
                        $this$invoke_u24lambda_u240.setComment(info2.remarks);
                    }
                }));
            }
            catch (DBException e$iv) {
                this_$iv.getErrorSink().consume(null, (Object)e$iv);
            }
            $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
            $this$modifyAndCleanup_u24default$iv.sort();
        }

        private final void retrieveSourcesV2(H2Schema schema2) {
            this.getModel().writeSources(() -> H2SchemaAbstractSchemaRetriever.retrieveSourcesV2$lambda$55(this, schema2));
        }

        private final void retrieveViewSources(H2Schema schema2) {
            H2Introspector.this.reportRetrieving("view sources", "introspection.retrieve.view.sources");
            H2IntroQueries.INSTANCE.processViewSources(this.getTransaction(), schema2, (Function1<? super H2IntroQueries.SourceInfo, Unit>)((Function1)new Function1<H2IntroQueries.SourceInfo, Unit>(schema2, this){
                final /* synthetic */ H2Schema $schema;
                final /* synthetic */ H2SchemaAbstractSchemaRetriever this$0;
                {
                    this.$schema = $schema;
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull H2IntroQueries.SourceInfo info2) {
                    Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
                    H2View h2View = (H2View)this.$schema.getViews().get(info2.name);
                    if (h2View != null) {
                        String string = info2.sql;
                        h2View.setSourceText(string != null ? H2SchemaAbstractSchemaRetriever.access$toCompositeText(this.this$0, string) : null);
                    }
                }
            }));
        }

        private final void retrieveTriggerSources(H2Schema schema2) {
            H2Introspector.this.reportRetrieving("trigger sources", "introspection.retrieve.trigger.sources");
            HashMap<String, H2Trigger> triggerMap = new HashMap<String, H2Trigger>();
            for (H2Table h2Table : schema2.getTables()) {
                for (H2Trigger h2Trigger : h2Table.getTriggers()) {
                    String string;
                    Map map2 = triggerMap;
                    Intrinsics.checkNotNullExpressionValue((Object)h2Trigger.getName(), (String)"getName(...)");
                    Intrinsics.checkNotNull((Object)h2Trigger);
                    H2Trigger h2Trigger2 = h2Trigger;
                    map2.put(string, h2Trigger2);
                }
            }
            H2IntroQueries.INSTANCE.processTriggerSources(this.getTransaction(), schema2, (Function1<? super H2IntroQueries.SourceInfo, Unit>)((Function1)new Function1<H2IntroQueries.SourceInfo, Unit>(triggerMap, this){
                final /* synthetic */ HashMap<String, H2Trigger> $triggerMap;
                final /* synthetic */ H2SchemaAbstractSchemaRetriever this$0;
                {
                    this.$triggerMap = $triggerMap;
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull H2IntroQueries.SourceInfo info2) {
                    Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
                    H2Trigger h2Trigger = this.$triggerMap.get(info2.name);
                    if (h2Trigger != null) {
                        String string = info2.sql;
                        h2Trigger.setSourceText(string != null ? H2SchemaAbstractSchemaRetriever.access$toCompositeText(this.this$0, string) : null);
                    }
                }
            }));
        }

        private static final boolean renewConstraint$lambda$17(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final void retrieveSourcesV2$lambda$55(H2SchemaAbstractSchemaRetriever this$0, H2Schema $schema) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$schema, (String)"$schema");
            this$0.retrieveViewSources($schema);
            this$0.retrieveTriggerSources($schema);
        }

        public static final /* synthetic */ void access$retrieveEnumValues(H2SchemaAbstractSchemaRetriever $this, H2Schema schema2) {
            $this.retrieveEnumValues(schema2);
        }

        public static final /* synthetic */ void access$retrieveArrayTypes(H2SchemaAbstractSchemaRetriever $this, H2Schema schema2) {
            $this.retrieveArrayTypes(schema2);
        }

        public static final /* synthetic */ void access$retrieveRowFields(H2SchemaAbstractSchemaRetriever $this, H2Schema schema2) {
            $this.retrieveRowFields(schema2);
        }

        public static final /* synthetic */ void access$retrieveSequences(H2SchemaAbstractSchemaRetriever $this, H2Schema schema2) {
            $this.retrieveSequences(schema2);
        }

        public static final /* synthetic */ BasicModModel access$getModel(H2SchemaAbstractSchemaRetriever $this) {
            return $this.getModel();
        }

        public static final /* synthetic */ void access$retrieveConstraints(H2SchemaAbstractSchemaRetriever $this, H2Schema schema2) {
            $this.retrieveConstraints(schema2);
        }

        public static final /* synthetic */ void access$retrieveSynonyms(H2SchemaAbstractSchemaRetriever $this, H2Schema schema2) {
            $this.retrieveSynonyms(schema2);
        }

        public static final /* synthetic */ void access$retrieveSourcesV2(H2SchemaAbstractSchemaRetriever $this, H2Schema schema2) {
            $this.retrieveSourcesV2(schema2);
        }

        public static final /* synthetic */ void access$retrieveDomains(H2SchemaAbstractSchemaRetriever $this, H2Schema schema2) {
            $this.retrieveDomains(schema2);
        }

        public static final /* synthetic */ void access$retrieveDomainChecks(H2SchemaAbstractSchemaRetriever $this, H2Schema schema2) {
            $this.retrieveDomainChecks(schema2);
        }

        public static final /* synthetic */ void access$retrieveTables(H2SchemaAbstractSchemaRetriever $this, H2Schema schema2) {
            $this.retrieveTables(schema2);
        }

        public static final /* synthetic */ void access$retrieveColumns(H2SchemaAbstractSchemaRetriever $this, H2Schema schema2) {
            $this.retrieveColumns(schema2);
        }

        public static final /* synthetic */ void access$retrieveIndexes(H2SchemaAbstractSchemaRetriever $this, H2Schema schema2) {
            $this.retrieveIndexes(schema2);
        }

        public static final /* synthetic */ void access$retrieveTriggers(H2SchemaAbstractSchemaRetriever $this, H2Schema schema2) {
            $this.retrieveTriggers(schema2);
        }

        public static final /* synthetic */ void access$retrieveConstants(H2SchemaAbstractSchemaRetriever $this, H2Schema schema2) {
            $this.retrieveConstants(schema2);
        }

        public static final /* synthetic */ void access$retrieveRoutinesV2(H2SchemaAbstractSchemaRetriever $this, H2Schema schema2) {
            $this.retrieveRoutinesV2(schema2);
        }

        public static final /* synthetic */ void access$retrieveRoutines(H2SchemaAbstractSchemaRetriever $this, H2Schema schema2) {
            $this.retrieveRoutines(schema2);
        }

        public static final /* synthetic */ SimpleCompositeText access$toCompositeText(H2SchemaAbstractSchemaRetriever $this, String $receiver) {
            return $this.toCompositeText($receiver);
        }

        public static final /* synthetic */ HashMap access$getEnumValues$p(H2SchemaAbstractSchemaRetriever $this) {
            return $this.enumValues;
        }

        public static final /* synthetic */ HashMap access$getArrayElementTypes$p(H2SchemaAbstractSchemaRetriever $this) {
            return $this.arrayElementTypes;
        }

        public static final /* synthetic */ MultiMap access$getRowFields$p(H2SchemaAbstractSchemaRetriever $this) {
            return $this.rowFields;
        }

        public static final /* synthetic */ DasType access$getDasType(H2SchemaAbstractSchemaRetriever $this, H2IntroQueries.TypedObjectInfo $receiver) {
            return $this.getDasType($receiver);
        }

        public static final /* synthetic */ void access$processSequenceLike(H2SchemaAbstractSchemaRetriever $this, H2Sequence sequence, H2IntroQueries.SequenceLikeInfo info2, boolean isIdentity) {
            $this.processSequenceLike(sequence, info2, isIdentity);
        }

        public static final /* synthetic */ List access$parseColumnList(H2SchemaAbstractSchemaRetriever $this, String s2) {
            return $this.parseColumnList(s2);
        }

        public static final /* synthetic */ H2Constraint access$renewConstraint(H2SchemaAbstractSchemaRetriever $this, ModNamingFamily family, String constraintName, List colNames) {
            return $this.renewConstraint(family, constraintName, colNames);
        }

        public static final /* synthetic */ String access$removeParens(H2SchemaAbstractSchemaRetriever $this, String s2) {
            return $this.removeParens(s2);
        }

        public static final /* synthetic */ CascadeRule access$getCascadeRule(H2SchemaAbstractSchemaRetriever $this, String code) {
            return $this.getCascadeRule(code);
        }

        public static final /* synthetic */ void access$applyIndexColumns(H2SchemaAbstractSchemaRetriever $this, H2Index index2, List columns2) {
            $this.applyIndexColumns(index2, columns2);
        }

        public static final /* synthetic */ String access$javaClassName(H2SchemaAbstractSchemaRetriever $this, H2IntroQueries.RoutineInfoV2 $receiver) {
            return $this.javaClassName($receiver);
        }

        public static final /* synthetic */ String access$javaMethodName(H2SchemaAbstractSchemaRetriever $this, H2IntroQueries.RoutineInfoV2 $receiver) {
            return $this.javaMethodName($receiver);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\b\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lcom/intellij/database/dialects/h2/introspector/H2Introspector$Interval;", "", "(Ljava/lang/String;I)V", "YEAR", "MONTH", "DAY", "HOUR", "MINUTE", "SECOND", "intellij.database.dialects.h2"})
    private static final class Interval
    extends Enum<Interval> {
        public static final /* enum */ Interval YEAR = new Interval();
        public static final /* enum */ Interval MONTH = new Interval();
        public static final /* enum */ Interval DAY = new Interval();
        public static final /* enum */ Interval HOUR = new Interval();
        public static final /* enum */ Interval MINUTE = new Interval();
        public static final /* enum */ Interval SECOND = new Interval();
        private static final /* synthetic */ Interval[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Interval[] values() {
            return (Interval[])$VALUES.clone();
        }

        public static Interval valueOf(String value2) {
            return Enum.valueOf(Interval.class, value2);
        }

        @NotNull
        public static EnumEntries<Interval> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = intervalArray = new Interval[]{Interval.YEAR, Interval.MONTH, Interval.DAY, Interval.HOUR, Interval.MINUTE, Interval.SECOND};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

