/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.h2.generator.producers;

import com.intellij.database.dialects.base.generator.AbstractScriptGeneratorKt;
import com.intellij.database.dialects.base.generator.BaseAlterGeneratorKt;
import com.intellij.database.dialects.base.generator.ScriptGeneratorHelper;
import com.intellij.database.dialects.base.generator.ScriptingContext;
import com.intellij.database.dialects.base.generator.producers.AlterData;
import com.intellij.database.dialects.base.generator.producers.AlterSequence;
import com.intellij.database.dialects.base.generator.producers.Flags;
import com.intellij.database.dialects.h2.generator.producers.H2SequenceProducersKt;
import com.intellij.database.dialects.h2.model.H2Sequence;
import com.intellij.database.model.ElementAlteration;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.basic.BasicModSequence;
import com.intellij.database.model.meta.BasicMetaId;
import com.intellij.database.model.meta.BasicMetaPropertyId;
import com.intellij.database.script.generator.ScriptingCapabilities;
import java.math.BigInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0014J\u0012\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0014J\b\u0010\u0012\u001a\u00020\u000fH\u0016J\b\u0010\u0013\u001a\u00020\u000fH\u0014\u00a8\u0006\u0014"}, d2={"Lcom/intellij/database/dialects/h2/generator/producers/H2AlterSequence;", "Lcom/intellij/database/dialects/base/generator/producers/AlterSequence;", "Lcom/intellij/database/dialects/h2/model/H2Sequence;", "context", "Lcom/intellij/database/dialects/base/generator/ScriptingContext;", "elements", "Lcom/intellij/database/model/ElementAlteration;", "(Lcom/intellij/database/dialects/base/generator/ScriptingContext;Lcom/intellij/database/model/ElementAlteration;)V", "canAlter", "Lcom/intellij/database/script/generator/ScriptingCapabilities$VersionedCapability;", "", "prop", "Lcom/intellij/database/model/meta/BasicMetaId;", "canRename", "doProduceAlterStartValueClause", "", "startValue", "Ljava/math/BigInteger;", "produceAlterComment", "produceAlterStartValueClause", "intellij.database.dialects.h2"})
public final class H2AlterSequence
extends AlterSequence<H2Sequence> {
    public H2AlterSequence(@NotNull ScriptingContext context, @NotNull ElementAlteration<? extends H2Sequence> elements2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(elements2, (String)"elements");
        super(context, elements2);
    }

    @Override
    @NotNull
    protected ScriptingCapabilities.VersionedCapability<Boolean> canRename() {
        return AbstractScriptGeneratorKt.getUNSUPPORTED();
    }

    @Override
    public void produceAlterComment() {
        BaseAlterGeneratorKt.commentStatement$default(this, "sequence", null, 2, null);
    }

    @Override
    @NotNull
    public ScriptingCapabilities.VersionedCapability<Boolean> canAlter(@NotNull BasicMetaId prop) {
        Intrinsics.checkNotNullParameter((Object)prop, (String)"prop");
        BasicMetaId basicMetaId = prop;
        return Intrinsics.areEqual((Object)basicMetaId, H2Sequence.DAS_TYPE) ? AbstractScriptGeneratorKt.getUNSUPPORTED() : (Intrinsics.areEqual((Object)basicMetaId, (Object)H2Sequence.START_VALUE) ? H2SequenceProducersKt.access$getStartValueSupported() : super.canAlter(prop));
    }

    @Override
    protected void produceAlterStartValueClause() {
        Flags flags = this.getFlags();
        BasicMetaPropertyId<BigInteger> basicMetaPropertyId = BasicModSequence.START_VALUE;
        Intrinsics.checkNotNullExpressionValue(basicMetaPropertyId, (String)"START_VALUE");
        if (flags.get(basicMetaPropertyId)) {
            this.doProduceAlterStartValueClause(((H2Sequence)this.getTo()).getStartValue());
        } else {
            BasicMetaPropertyId basicMetaPropertyId2 = H2Sequence.START_VALUE;
            Intrinsics.checkNotNullExpressionValue((Object)basicMetaPropertyId2, (String)"START_VALUE");
            if (this.canAlter(basicMetaPropertyId2).get(this.getTask().getVersion()).booleanValue()) {
                BigInteger startValue = ((H2Sequence)this.getTo()).getStartValue();
                SequenceIdentity sequenceIdentity = ((H2Sequence)this.getTo()).getSequenceIdentity();
                Intrinsics.checkNotNullExpressionValue((Object)sequenceIdentity, (String)"getSequenceIdentity(...)");
                SequenceIdentity identity = sequenceIdentity;
                BigInteger min = identity.min;
                BigInteger max = identity.max;
                if (startValue != null && (min != null && startValue.compareTo(min) < 0 || max != null && startValue.compareTo(max) > 0)) {
                    BigInteger bigInteger = identity.next;
                    if (bigInteger == null) {
                        bigInteger = identity.increment.compareTo(BigInteger.ZERO) > 0 ? min : max;
                    }
                    BigInteger newStartValue = bigInteger;
                    this.doProduceAlterStartValueClause(newStartValue);
                }
            }
        }
    }

    @Override
    protected void doProduceAlterStartValueClause(@Nullable BigInteger startValue) {
        BasicMetaPropertyId basicMetaPropertyId = H2Sequence.START_VALUE;
        Intrinsics.checkNotNullExpressionValue((Object)basicMetaPropertyId, (String)"START_VALUE");
        if (!this.canAlter(basicMetaPropertyId).get(this.getTask().getVersion()).booleanValue()) {
            ScriptGeneratorHelper scriptGeneratorHelper = this.getContext().getHelper();
            AlterData alterData = this.getData();
            BasicMetaPropertyId basicMetaPropertyId2 = H2Sequence.START_VALUE;
            Intrinsics.checkNotNullExpressionValue((Object)basicMetaPropertyId2, (String)"START_VALUE");
            scriptGeneratorHelper.produceAlterNotSupported(alterData, basicMetaPropertyId2);
            return;
        }
        super.doProduceAlterStartValueClause(startValue);
    }
}

