/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.greenplum.model.properties;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class GPlumPartitionTree {
    public static final long NO_PARENT = 0L;
    private static final String CHILD_SEPARATOR = "$";
    private static final String VERTEX_SEPARATOR = "&";
    private final Long2ObjectMap<LongSet> myAdjacencyList = new Long2ObjectOpenHashMap();
    private final Long2LongMap myParents = new Long2LongOpenHashMap();

    public void addEdge(long from, long to) {
        this.getChildren(from).add(to);
        this.myParents.put(to, from);
    }

    public void removeEdges(long vertex) {
        long[] lArray = this.getChildrenAsArray(vertex);
        int n = lArray.length;
        for (int j = 0; j < n; ++j) {
            Long child = lArray[j];
            this.removeEdges(child);
        }
        this.myAdjacencyList.remove(vertex);
        long parent2 = this.myParents.get(vertex);
        if (parent2 != 0L) {
            this.getChildren(parent2).remove(vertex);
        }
    }

    public long getParent(long vertex) {
        return this.myParents.get(vertex);
    }

    @NotNull
    public String serialize() {
        if (this.myAdjacencyList.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        long[] vertices = this.myAdjacencyList.keySet().toLongArray();
        Arrays.sort(vertices);
        for (long vertex : vertices) {
            long[] children2 = this.getChildrenAsArray(vertex);
            if (children2.length == 0) continue;
            Arrays.sort(children2);
            sb.append(vertex).append(CHILD_SEPARATOR);
            for (long child : children2) {
                sb.append(child).append(CHILD_SEPARATOR);
            }
            sb.append(VERTEX_SEPARATOR);
        }
        String string = sb.toString();
        if (string == null) {
            GPlumPartitionTree.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void deserialize(@NotNull String value2) {
        if (value2 == null) {
            GPlumPartitionTree.$$$reportNull$$$0(1);
        }
        List splitted = StringUtil.split((String)value2, (String)VERTEX_SEPARATOR);
        for (String s2 : splitted) {
            if (StringUtil.isEmptyOrSpaces((String)s2)) continue;
            List children2 = StringUtil.split((String)s2, (String)CHILD_SEPARATOR);
            String parentString = (String)ContainerUtil.getFirstItem((List)children2);
            if (parentString == null) {
                this.clearAndReportError();
                return;
            }
            try {
                long parent2 = Long.parseLong(parentString);
                for (int i2 = 1; i2 < children2.size(); ++i2) {
                    String childString = (String)children2.get(i2);
                    if (StringUtil.isEmptyOrSpaces((String)childString)) continue;
                    long child = Long.parseLong(childString);
                    this.addEdge(parent2, child);
                }
            }
            catch (NumberFormatException e2) {
                this.clearAndReportError();
            }
        }
    }

    public long[] getChildrenAsArray(long vertex) {
        return this.getChildren(vertex).toLongArray();
    }

    public boolean containsChild(long vertex, long child) {
        return this.getChildren(vertex).contains(child);
    }

    @NotNull
    private LongSet getChildren(long vertex) {
        if (!this.myAdjacencyList.containsKey(vertex)) {
            this.myAdjacencyList.put(vertex, (Object)new LongOpenHashSet());
        }
        LongSet longSet = (LongSet)this.myAdjacencyList.get(vertex);
        if (longSet == null) {
            GPlumPartitionTree.$$$reportNull$$$0(2);
        }
        return longSet;
    }

    private void clearAndReportError() {
        this.myAdjacencyList.clear();
        this.myParents.clear();
        throw new IllegalStateException("Failed to read partitions tree");
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (!(o2 instanceof GPlumPartitionTree)) {
            return false;
        }
        GPlumPartitionTree tree = (GPlumPartitionTree)o2;
        return this.myAdjacencyList.equals(tree.myAdjacencyList) && this.myParents.equals(tree.myParents);
    }

    public int hashCode() {
        return Objects.hash(this.myAdjacencyList, this.myParents);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/greenplum/model/properties/GPlumPartitionTree";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "serialize";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/greenplum/model/properties/GPlumPartitionTree";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

