/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.greenplum.introspector;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.base.introspector.BaseIntrospectionFunctions;
import com.intellij.database.dialects.base.introspector.BaseNativeIntrospector;
import com.intellij.database.dialects.base.introspector.IdCache;
import com.intellij.database.dialects.greenplum.introspector.GPlumIntroQueries;
import com.intellij.database.dialects.greenplum.introspector.GPlumIntrospector;
import com.intellij.database.dialects.greenplum.model.GPlumDatabase;
import com.intellij.database.dialects.greenplum.model.GPlumExternalTable;
import com.intellij.database.dialects.greenplum.model.GPlumLocalTable;
import com.intellij.database.dialects.greenplum.model.GPlumMatView;
import com.intellij.database.dialects.greenplum.model.GPlumModelHelper;
import com.intellij.database.dialects.greenplum.model.GPlumPartition;
import com.intellij.database.dialects.greenplum.model.GPlumRoot;
import com.intellij.database.dialects.greenplum.model.GPlumSchema;
import com.intellij.database.dialects.greenplum.model.GPlumTable;
import com.intellij.database.dialects.greenplum.model.GPlumTablespace;
import com.intellij.database.dialects.greenplum.model.properties.GPlumExternalTableFormat;
import com.intellij.database.dialects.greenplum.model.properties.GPlumExternalTableRejectLimitType;
import com.intellij.database.dialects.greenplum.model.properties.GPlumPartitionKind;
import com.intellij.database.dialects.greenplum.model.properties.GPlumPartitionTree;
import com.intellij.database.dialects.postgresbase.introspector.IntroStep;
import com.intellij.database.dialects.postgresbase.introspector.PgBaseIntroQueries;
import com.intellij.database.dialects.postgresbase.introspector.PgBaseIntrospector;
import com.intellij.database.dialects.postgresbase.introspector.PgBaseIntrospectorKt;
import com.intellij.database.dialects.postgresbase.model.PgBaseLikeStoredTable;
import com.intellij.database.dialects.postgresgreenplumbase.introspector.PgGPlumBaseIntroQueries;
import com.intellij.database.dialects.postgresgreenplumbase.introspector.PgGPlumBaseIntrospector;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseDatabase;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseLikeStoredTable;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseModelHelper;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseSchema;
import com.intellij.database.introspection.DBIntrospectionContext;
import com.intellij.database.introspection.DBIntrospector;
import com.intellij.database.layoutedQueries.DBTransaction;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PerObjectVersion;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModIdentifiedElement;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModIdentifyingFamily;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.remote.jdba.exceptions.DBException;
import com.intellij.database.remote.jdba.sql.Scriptum;
import com.intellij.database.remote.jdba.sql.SqlQuery;
import com.intellij.database.util.Version;
import com.intellij.util.text.StringKt;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u0000 )2\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001:\u0005)*+,-B\u0017\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ4\u0010\u0017\u001a\u001e\u0012\u0004\u0012\u00020\u00030\u0018R\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0003H\u0014J4\u0010\u001d\u001a\u001e\u0012\u0004\u0012\u00020\u00030\u001eR\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0003H\u0014J6\u0010\u001f\u001a \u0012\u0006\b\u0001\u0012\u00020\u00040 R\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040!2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020\u0004H\u0014J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020$H\u0016J\b\u0010&\u001a\u00020'H\u0014J\b\u0010(\u001a\u00020\u000fH\u0014R\u0014\u0010\n\u001a\u00020\u000b8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0010R\u0014\u0010\u0012\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010R\u0014\u0010\u0013\u001a\u00020\u00148TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006."}, d2={"Lcom/intellij/database/dialects/greenplum/introspector/GPlumIntrospector;", "Lcom/intellij/database/dialects/postgresgreenplumbase/introspector/PgGPlumBaseIntrospector;", "Lcom/intellij/database/dialects/greenplum/model/GPlumRoot;", "Lcom/intellij/database/dialects/greenplum/model/GPlumDatabase;", "Lcom/intellij/database/dialects/greenplum/model/GPlumSchema;", "context", "Lcom/intellij/database/introspection/DBIntrospectionContext;", "factory", "Lcom/intellij/database/model/ModelFactory;", "(Lcom/intellij/database/introspection/DBIntrospectionContext;Lcom/intellij/database/model/ModelFactory;)V", "helper", "Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseModelHelper;", "getHelper", "()Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseModelHelper;", "isFifth", "", "()Z", "isSeventh", "isSixth", "queries", "Lcom/intellij/database/dialects/postgresgreenplumbase/introspector/PgGPlumBaseIntroQueries;", "getQueries", "()Lcom/intellij/database/dialects/postgresgreenplumbase/introspector/PgGPlumBaseIntroQueries;", "createDatabaseRetriever", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntrospector$DatabaseRetriever;", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntrospector;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "database", "createNativeRetriever", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntrospector$NativeRetriever;", "createSchemaRetriever", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractSchemaRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector;", "schema", "generateDbAge", "", "tx", "initConnectionRelatedState", "", "isItPossibleToRetrieveCurrentXid", "Companion", "Factory", "MyDatabaseRetriever", "MyNativeRetriever", "MySchemaRetriever", "intellij.database.dialects.greenplum"})
public final class GPlumIntrospector
extends PgGPlumBaseIntrospector<GPlumRoot, GPlumDatabase, GPlumSchema> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final GPlumIntroQueries QUERIES;

    @Override
    @NotNull
    protected PgGPlumBaseModelHelper getHelper() {
        return GPlumModelHelper.INSTANCE;
    }

    public GPlumIntrospector(@NotNull DBIntrospectionContext context, @NotNull ModelFactory factory) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        Dbms dbms = Dbms.GREENPLUM;
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"GREENPLUM");
        super(context, dbms, factory);
    }

    private final boolean isFifth() {
        int[] nArray = new int[]{5};
        return this.getServerVersion().isOrGreater(nArray);
    }

    private final boolean isSixth() {
        int[] nArray = new int[]{6};
        return this.getServerVersion().isOrGreater(nArray);
    }

    private final boolean isSeventh() {
        int[] nArray = new int[]{7};
        return this.getServerVersion().isOrGreater(nArray);
    }

    @Override
    @NotNull
    protected PgGPlumBaseIntroQueries getQueries() {
        return QUERIES;
    }

    @Override
    @NotNull
    public String generateDbAge(@NotNull String tx) {
        Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
        return "pg_catalog.age(pg_catalog.xidin(pg_catalog.int8out(" + tx + ")))";
    }

    @Override
    protected void initConnectionRelatedState() {
        super.initConnectionRelatedState();
        BaseIntrospectionFunctions.setMajorMinorVersionParameters(this.getServerVersion(), 7, new IntRange(0, 0), this.getParametersMap());
        BaseIntrospectionFunctions.setMajorMinorVersionParameters(this.getServerVersion(), 6, new IntRange(0, 1), this.getParametersMap());
        BaseIntrospectionFunctions.setMajorMinorVersionParameters(this.getServerVersion(), 5, new IntRange(0, 23), this.getParametersMap());
        BaseIntrospectionFunctions.setMajorMinorVersionParameters(this.getServerVersion(), 4, new IntRange(0, 3), this.getParametersMap());
    }

    @Override
    protected boolean isItPossibleToRetrieveCurrentXid() {
        int[] nArray = new int[]{5};
        return this.getServerVersion().isOrGreater(nArray);
    }

    @Override
    @NotNull
    protected BaseNativeIntrospector.AbstractSchemaRetriever<? extends GPlumSchema> createSchemaRetriever(@NotNull DBTransaction transaction, @NotNull GPlumSchema schema2) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)schema2, (String)"schema");
        return new MySchemaRetriever(transaction, schema2);
    }

    @Override
    @NotNull
    protected PgBaseIntrospector.DatabaseRetriever<GPlumDatabase> createDatabaseRetriever(@NotNull DBTransaction transaction, @NotNull GPlumDatabase database) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        return new MyDatabaseRetriever(transaction, database);
    }

    @Override
    @NotNull
    protected PgBaseIntrospector.NativeRetriever<GPlumDatabase> createNativeRetriever(@NotNull DBTransaction transaction, @NotNull GPlumDatabase database) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        return new MyNativeRetriever(transaction, database);
    }

    public static final /* synthetic */ boolean access$isSeventh(GPlumIntrospector $this) {
        return $this.isSeventh();
    }

    public static final /* synthetic */ List access$parseListOfLongs(GPlumIntrospector $this, String str) {
        return $this.parseListOfLongs(str);
    }

    public static final /* synthetic */ GPlumIntroQueries access$getQUERIES$cp() {
        return QUERIES;
    }

    public static final /* synthetic */ List access$parseList(GPlumIntrospector $this, String str, Function1 converter) {
        return $this.parseList(str, converter);
    }

    static {
        Scriptum scriptum = Scriptum.of(GPlumIntroQueries.class);
        Intrinsics.checkNotNullExpressionValue((Object)scriptum, (String)"of(...)");
        QUERIES = new GPlumIntroQueries(scriptum);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/database/dialects/greenplum/introspector/GPlumIntrospector$Companion;", "", "()V", "QUERIES", "Lcom/intellij/database/dialects/greenplum/introspector/GPlumIntroQueries;", "intellij.database.dialects.greenplum"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0012\u0010\u0011\u001a\u00020\u00102\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016H\u0016\u00a8\u0006\u0018"}, d2={"Lcom/intellij/database/dialects/greenplum/introspector/GPlumIntrospector$Factory;", "Lcom/intellij/database/introspection/DBIntrospector$Factory;", "()V", "createIntrospector", "Lcom/intellij/database/introspection/DBIntrospector;", "context", "Lcom/intellij/database/introspection/DBIntrospectionContext;", "dbms", "Lcom/intellij/database/Dbms;", "modelFactory", "Lcom/intellij/database/model/ModelFactory;", "getVersion", "", "kind", "Lcom/intellij/database/model/ObjectKind;", "isIncremental", "", "isOutdatedCheckSupported", "e", "Lcom/intellij/database/model/basic/BasicElement;", "isSupported", "version", "Lcom/intellij/database/util/Version;", "VERSION", "intellij.database.dialects.greenplum"})
    public static final class Factory
    implements DBIntrospector.Factory {
        @Override
        public boolean isSupported(@NotNull Version version) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            return true;
        }

        @Override
        public boolean isIncremental() {
            return true;
        }

        @Override
        @NotNull
        public DBIntrospector createIntrospector(@NotNull DBIntrospectionContext context, @NotNull Dbms dbms, @NotNull ModelFactory modelFactory) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
            Intrinsics.checkNotNullParameter((Object)modelFactory, (String)"modelFactory");
            return new GPlumIntrospector(context, modelFactory);
        }

        @Override
        public int getVersion(@NotNull ObjectKind kind) {
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            return VERSION.INSTANCE.get(kind);
        }

        @Override
        public boolean isOutdatedCheckSupported(@Nullable BasicElement e2) {
            return !(e2 instanceof GPlumTablespace) && PgBaseIntrospectorKt.canCheckOutdated(e2);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/database/dialects/greenplum/introspector/GPlumIntrospector$Factory$VERSION;", "Lcom/intellij/database/model/PerObjectVersion;", "()V", "intellij.database.dialects.greenplum"})
        public static final class VERSION
        extends PerObjectVersion {
            @NotNull
            public static final VERSION INSTANCE = new VERSION();

            private VERSION() {
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u001e\u0012\u0004\u0012\u00020\u00020\u0001R\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00050\u0003B\u0015\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0014J\u0018\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0014J\u0018\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0014J\u0018\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0014J\u0018\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0014\u00a8\u0006\u0013"}, d2={"Lcom/intellij/database/dialects/greenplum/introspector/GPlumIntrospector$MyDatabaseRetriever;", "Lcom/intellij/database/dialects/postgresgreenplumbase/introspector/PgGPlumBaseIntrospector$PgGPlumBaseDatabaseRetriever;", "Lcom/intellij/database/dialects/greenplum/model/GPlumDatabase;", "Lcom/intellij/database/dialects/postgresgreenplumbase/introspector/PgGPlumBaseIntrospector;", "Lcom/intellij/database/dialects/greenplum/model/GPlumRoot;", "Lcom/intellij/database/dialects/greenplum/model/GPlumSchema;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "database", "(Lcom/intellij/database/dialects/greenplum/introspector/GPlumIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/greenplum/model/GPlumDatabase;)V", "beforeServerAndDatabaseObjectsRetrieval", "", "introspectDatabaseObjects", "detectDropped", "", "loadNew", "introspectUserMappings", "retrieveForeignDataWrappers", "retrieveForeignServers", "intellij.database.dialects.greenplum"})
    private final class MyDatabaseRetriever
    extends PgGPlumBaseIntrospector.PgGPlumBaseDatabaseRetriever<GPlumDatabase> {
        public MyDatabaseRetriever(@NotNull DBTransaction transaction, GPlumDatabase database) {
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            Intrinsics.checkNotNullParameter((Object)database, (String)"database");
            super((PgGPlumBaseIntrospector)GPlumIntrospector.this, transaction, (PgGPlumBaseDatabase)database);
        }

        @Override
        protected void beforeServerAndDatabaseObjectsRetrieval() {
            super.beforeServerAndDatabaseObjectsRetrieval();
            this.setQueryParameter("umenabled", this.getMySuper() && GPlumIntrospector.this.isSixth());
        }

        @Override
        protected void introspectDatabaseObjects(boolean detectDropped, boolean loadNew) {
            super.introspectDatabaseObjects(detectDropped && GPlumIntrospector.this.isFifth(), loadNew && GPlumIntrospector.this.isFifth());
        }

        @Override
        protected void retrieveForeignDataWrappers(boolean detectDropped, boolean loadNew) {
            super.retrieveForeignDataWrappers(detectDropped && GPlumIntrospector.this.isSixth(), loadNew && GPlumIntrospector.this.isSixth());
        }

        @Override
        protected void retrieveForeignServers(boolean detectDropped, boolean loadNew) {
            super.retrieveForeignServers(detectDropped && GPlumIntrospector.this.isSixth(), loadNew && GPlumIntrospector.this.isSixth());
        }

        @Override
        protected void introspectUserMappings(boolean detectDropped, boolean loadNew) {
            super.introspectUserMappings(detectDropped && GPlumIntrospector.this.isSixth(), loadNew && GPlumIntrospector.this.isSixth());
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u001e\u0012\u0004\u0012\u00020\u00020\u0001R\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00050\u0003B\u0015\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lcom/intellij/database/dialects/greenplum/introspector/GPlumIntrospector$MyNativeRetriever;", "Lcom/intellij/database/dialects/postgresgreenplumbase/introspector/PgGPlumBaseIntrospector$PgGPlumBaseNativeRetriever;", "Lcom/intellij/database/dialects/greenplum/model/GPlumDatabase;", "Lcom/intellij/database/dialects/postgresgreenplumbase/introspector/PgGPlumBaseIntrospector;", "Lcom/intellij/database/dialects/greenplum/model/GPlumRoot;", "Lcom/intellij/database/dialects/greenplum/model/GPlumSchema;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "database", "(Lcom/intellij/database/dialects/greenplum/introspector/GPlumIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/greenplum/model/GPlumDatabase;)V", "intellij.database.dialects.greenplum"})
    private final class MyNativeRetriever
    extends PgGPlumBaseIntrospector.PgGPlumBaseNativeRetriever<GPlumDatabase> {
        public MyNativeRetriever(@NotNull DBTransaction transaction, GPlumDatabase database) {
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            Intrinsics.checkNotNullParameter((Object)database, (String)"database");
            super((PgGPlumBaseIntrospector)GPlumIntrospector.this, transaction, (PgGPlumBaseDatabase)database);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u001e\u0012\u0004\u0012\u00020\u00020\u0001R\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00020\u0003B\u0015\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\tJ\b\u0010\f\u001a\u00020\rH\u0014J!\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u0012H\u0014\u00a2\u0006\u0002\u0010\u0013J#\u0010\u0014\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00160\u00150\u00122\u0006\u0010\b\u001a\u00020\u0002H\u0014\u00a2\u0006\u0002\u0010\u0017J\"\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\u0018\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0014J\u0018\u0010#\u001a\u00020\r2\u0006\u0010$\u001a\u00020\u000b2\u0006\u0010%\u001a\u00020\u000bH\u0014J\u0018\u0010&\u001a\u00020\r2\u0006\u0010$\u001a\u00020\u000b2\u0006\u0010%\u001a\u00020\u000bH\u0014J\u0018\u0010'\u001a\u00020\r2\u0006\u0010$\u001a\u00020\u000b2\u0006\u0010%\u001a\u00020\u000bH\u0014J\b\u0010(\u001a\u00020\rH\u0002J\b\u0010)\u001a\u00020\rH\u0014J\u0018\u0010*\u001a\u00020\r2\u0006\u0010$\u001a\u00020\u000b2\u0006\u0010%\u001a\u00020\u000bH\u0002J\b\u0010+\u001a\u00020\rH\u0014J\u0018\u0010,\u001a\u00020\r2\u0006\u0010$\u001a\u00020\u000b2\u0006\u0010%\u001a\u00020\u000bH\u0014J\u0018\u0010-\u001a\u00020\r2\u0006\u0010$\u001a\u00020\u000b2\u0006\u0010%\u001a\u00020\u000bH\u0014J\u0018\u0010.\u001a\u00020\r2\u0006\u0010$\u001a\u00020\u000b2\u0006\u0010%\u001a\u00020\u000bH\u0002J\b\u0010/\u001a\u00020\u000bH\u0014J\u000e\u00100\u001a\b\u0012\u0004\u0012\u00020201H\u0014J\b\u00103\u001a\u00020\u000bH\u0014R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/intellij/database/dialects/greenplum/introspector/GPlumIntrospector$MySchemaRetriever;", "Lcom/intellij/database/dialects/postgresgreenplumbase/introspector/PgGPlumBaseIntrospector$PgGPlumBaseSchemaRetriever;", "Lcom/intellij/database/dialects/greenplum/model/GPlumSchema;", "Lcom/intellij/database/dialects/postgresgreenplumbase/introspector/PgGPlumBaseIntrospector;", "Lcom/intellij/database/dialects/greenplum/model/GPlumRoot;", "Lcom/intellij/database/dialects/greenplum/model/GPlumDatabase;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "schema", "(Lcom/intellij/database/dialects/greenplum/introspector/GPlumIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/greenplum/model/GPlumSchema;)V", "wasExternalTables", "", "analyzeBriefInfo", "", "fixLabelsOrder", "", "", "labels", "", "([Ljava/lang/String;)Ljava/util/List;", "getSchemaChildrenToDrop", "Lcom/intellij/database/model/families/ModIdentifyingFamily;", "Lcom/intellij/database/model/basic/BasicModIdentifiedElement;", "(Lcom/intellij/database/dialects/greenplum/model/GPlumSchema;)[Lcom/intellij/database/model/families/ModIdentifyingFamily;", "getTableOrView", "Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseLikeStoredTable;", "relKind", "", "tableId", "", "processModView", "table", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseLikeStoredTable;", "t", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$OneTable;", "retrieveAccessMethodOperators", "detectDropped", "loadNew", "retrieveAccessMethodProcedures", "retrieveCollations", "retrieveDistributedColumns", "retrieveEnumLabels", "retrieveExternalTables", "retrieveForeignTablesInfo", "retrieveOperatorClasses", "retrieveOperatorFamilies", "retrievePartitions", "shouldIntrospectTableRelatedDataIncremental", "steps", "", "Lcom/intellij/database/dialects/postgresbase/introspector/IntroStep;", "wasDataTables", "intellij.database.dialects.greenplum"})
    @SourceDebugExtension(value={"SMAP\nGPlumIntrospector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GPlumIntrospector.kt\ncom/intellij/database/dialects/greenplum/introspector/GPlumIntrospector$MySchemaRetriever\n+ 2 BaseNativeIntrospector.kt\ncom/intellij/database/dialects/base/introspector/BaseNativeIntrospector\n*L\n1#1,298:1\n619#2,7:299\n*S KotlinDebug\n*F\n+ 1 GPlumIntrospector.kt\ncom/intellij/database/dialects/greenplum/introspector/GPlumIntrospector$MySchemaRetriever\n*L\n159#1:299,7\n*E\n"})
    private final class MySchemaRetriever
    extends PgGPlumBaseIntrospector.PgGPlumBaseSchemaRetriever<GPlumSchema> {
        private boolean wasExternalTables;

        public MySchemaRetriever(@NotNull DBTransaction transaction, GPlumSchema schema2) {
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            Intrinsics.checkNotNullParameter((Object)schema2, (String)"schema");
            super((PgGPlumBaseIntrospector)GPlumIntrospector.this, transaction, (PgGPlumBaseSchema)schema2);
        }

        @Override
        @NotNull
        protected List<IntroStep> steps() {
            return PgBaseIntrospectorKt.add(PgBaseIntrospectorKt.add(PgBaseIntrospectorKt.add(super.steps(), 21, (Function2<? super Boolean, ? super Boolean, Unit>)((Function2)new Function2<Boolean, Boolean, Unit>(this, GPlumIntrospector.this){
                final /* synthetic */ MySchemaRetriever this$0;
                final /* synthetic */ GPlumIntrospector this$1;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    super(2);
                }

                public final void invoke(boolean detectDropped, boolean loadNew) {
                    MySchemaRetriever.access$retrieveExternalTables(this.this$0, detectDropped && !GPlumIntrospector.access$isSeventh(this.this$1), loadNew && !GPlumIntrospector.access$isSeventh(this.this$1));
                }
            })), 22, (Function2<? super Boolean, ? super Boolean, Unit>)((Function2)new Function2<Boolean, Boolean, Unit>(this, GPlumIntrospector.this){
                final /* synthetic */ MySchemaRetriever this$0;
                final /* synthetic */ GPlumIntrospector this$1;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    super(2);
                }

                public final void invoke(boolean detectDropped, boolean loadNew) {
                    MySchemaRetriever.access$retrievePartitions(this.this$0, detectDropped && !GPlumIntrospector.access$isSeventh(this.this$1), loadNew && !GPlumIntrospector.access$isSeventh(this.this$1));
                }
            })), 71, (Function2<? super Boolean, ? super Boolean, Unit>)((Function2)new Function2<Boolean, Boolean, Unit>(this){
                final /* synthetic */ MySchemaRetriever this$0;
                {
                    this.this$0 = $receiver;
                    super(2);
                }

                public final void invoke(boolean detectDropped, boolean loadNew) {
                    MySchemaRetriever.access$retrieveDistributedColumns(this.this$0);
                }
            }));
        }

        @Override
        protected void retrieveOperatorFamilies(boolean detectDropped, boolean loadNew) {
            super.retrieveOperatorFamilies(detectDropped && GPlumIntrospector.this.isFifth(), loadNew && GPlumIntrospector.this.isFifth());
        }

        @Override
        protected void retrieveOperatorClasses(boolean detectDropped, boolean loadNew) {
            super.retrieveOperatorClasses(detectDropped && GPlumIntrospector.this.isFifth(), loadNew && GPlumIntrospector.this.isFifth());
        }

        @Override
        protected void retrieveAccessMethodOperators(boolean detectDropped, boolean loadNew) {
            super.retrieveAccessMethodOperators(detectDropped && GPlumIntrospector.this.isFifth(), loadNew && GPlumIntrospector.this.isFifth());
        }

        @Override
        protected void retrieveAccessMethodProcedures(boolean detectDropped, boolean loadNew) {
            super.retrieveAccessMethodProcedures(detectDropped && GPlumIntrospector.this.isFifth(), loadNew && GPlumIntrospector.this.isFifth());
        }

        @Override
        protected void analyzeBriefInfo() {
            super.analyzeBriefInfo();
            Boolean bl = this.performQuery(GPlumIntrospector.this.getQueries().isSuperUser());
            boolean isSuper = bl != null ? bl : false;
            this.setQueryParameter("SUPER", isSuper);
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveDistributedColumns() {
            GPlumIntrospector.this.reportRetrieving("distribution key columns", "introspection.retrieve.distributedKey.columns");
            BaseNativeIntrospector baseNativeIntrospector = GPlumIntrospector.this;
            GPlumIntrospector gPlumIntrospector = GPlumIntrospector.this;
            boolean $i$f$continueOnDbError = false;
            try {
                boolean bl = false;
                this.inSchema((Function1)new Function1<GPlumSchema, Unit>(this, gPlumIntrospector){
                    final /* synthetic */ MySchemaRetriever this$0;
                    final /* synthetic */ GPlumIntrospector this$1;
                    {
                        this.this$0 = $receiver;
                        this.this$1 = $receiver2;
                        super(1);
                    }

                    public final void invoke(@NotNull GPlumSchema schema2) {
                        Intrinsics.checkNotNullParameter((Object)schema2, (String)"schema");
                        IdCache<GPlumTable> tableCache2 = new IdCache<GPlumTable>();
                        BaseNativeIntrospector.AbstractRetriever.performQueryHandleEachRow$default(this.this$0, GPlumIntrospector.access$getQUERIES$cp().getRetrieveDistributionKeys(), 0, (Function1)new Function1<GPlumIntroQueries.OneDistributionKeys, Unit>(tableCache2, this.this$1, schema2){
                            final /* synthetic */ IdCache<GPlumTable> $tableCache;
                            final /* synthetic */ GPlumIntrospector this$0;
                            final /* synthetic */ GPlumSchema $schema;
                            {
                                this.$tableCache = $tableCache;
                                this.this$0 = $receiver;
                                this.$schema = $schema;
                                super(1);
                            }

                            /*
                             * Unable to fully structure code
                             */
                            public final void invoke(@NotNull GPlumIntroQueries.OneDistributionKeys keys) {
                                Intrinsics.checkNotNullParameter((Object)keys, (String)"keys");
                                var4_2 = this.$tableCache;
                                var5_3 = keys.table_id;
                                var7_4 = this.$schema;
                                $i$f$get = false;
                                this_$iv$iv = this_$iv;
                                $i$f$getOrCache = false;
                                if (this_$iv$iv.getV() == null) ** GOTO lbl-1000
                                v0 = this_$iv$iv.getV();
                                Intrinsics.checkNotNull(v0);
                                if (v0.getObjectId() == id$iv) {
                                    v1 = this_$iv$iv.getV();
                                } else lbl-1000:
                                // 2 sources

                                {
                                    var11_8 = id$iv;
                                    var13_9 = this_$iv$iv;
                                    var14_10 = this_$iv$iv;
                                    $i$a$-getOrCache-IdCache$get$1$iv = false;
                                    var16_12 = (Function1)new Function1<ModIdentifyingFamily<? extends T>, T>((long)id$iv){
                                        final /* synthetic */ long $id;
                                        {
                                            this.$id = $id;
                                            super(1);
                                        }

                                        @Nullable
                                        public final T invoke(@NotNull ModIdentifyingFamily<? extends T> $this$invoke) {
                                            Intrinsics.checkNotNullParameter($this$invoke, (String)"$this$invoke");
                                            return (T)((BasicModIdentifiedElement)$this$invoke.getByObjectId(this.$id));
                                        }
                                    };
                                    $this$invoke_u24lambda_u240 = $this$get_u24lambda_u240$iv;
                                    $i$a$-get-GPlumIntrospector$MySchemaRetriever$retrieveDistributedColumns$1$1$1$table$1 = false;
                                    v2 = var7_4.getTables();
                                    Intrinsics.checkNotNullExpressionValue(v2, (String)"getTables(...)");
                                    v3 = (GPlumTable)it.invoke(v2);
                                    if (v3 == null) {
                                        v4 = var7_4.getExternalTables();
                                        Intrinsics.checkNotNullExpressionValue(v4, (String)"getExternalTables(...)");
                                        v3 = (GPlumTable)it.invoke(v4);
                                    }
                                    var14_10.setV((BasicModIdentifiedElement)v3);
                                    v1 = this_$iv$iv.getV();
                                }
                                v5 = (GPlumTable)v1;
                                if (v5 == null) {
                                    return;
                                }
                                table = v5;
                                distKeys = GPlumIntrospector.access$parseList(this.this$0, keys.distribution_keys, retrieveDistributedColumns.1.distKeys.1.INSTANCE);
                                if (distKeys.isEmpty()) {
                                    table.setDistributedRandomly(true);
                                    table.setDistributionKeys(CollectionsKt.emptyList());
                                } else {
                                    table.setDistributedRandomly(false);
                                    table.setDistributionKeys(distKeys);
                                }
                            }
                        }, 2, null);
                    }
                });
            }
            catch (DBException e$iv) {
                void this_$iv;
                this_$iv.getErrorSink().consume(null, (Object)e$iv);
            }
        }

        private final void retrievePartitions(boolean detectDropped, boolean loadNew) {
            ObjectKind objectKind = ObjectKind.PARTITION;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"PARTITION");
            GPlumIntrospector.this.reportRetrieving(objectKind);
            this.inSchema((Function1)new Function1<GPlumSchema, Unit>(GPlumIntrospector.this, detectDropped, this, loadNew){
                final /* synthetic */ GPlumIntrospector this$0;
                final /* synthetic */ boolean $detectDropped;
                final /* synthetic */ MySchemaRetriever this$1;
                final /* synthetic */ boolean $loadNew;
                {
                    this.this$0 = $receiver;
                    this.$detectDropped = $detectDropped;
                    this.this$1 = $receiver2;
                    this.$loadNew = $loadNew;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull GPlumSchema schema2) {
                    void families$iv;
                    void $this$mapTo$iv$iv;
                    Intrinsics.checkNotNullParameter((Object)schema2, (String)"schema");
                    ModNamingIdentifyingFamily<? extends GPlumLocalTable> modNamingIdentifyingFamily = schema2.getTables();
                    Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"getTables(...)");
                    Iterable $this$map$iv = modNamingIdentifyingFamily;
                    boolean $i$f$map = false;
                    Object object = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it2;
                        GPlumLocalTable gPlumLocalTable = (GPlumLocalTable)item$iv$iv;
                        Collection collection2 = destination$iv$iv;
                        boolean bl = false;
                        collection2.add(it2.getPartitions());
                    }
                    $this$map$iv = (List)destination$iv$iv;
                    object = this.this$0;
                    boolean bl = this.$detectDropped;
                    MySchemaRetriever mySchemaRetriever = this.this$1;
                    boolean bl2 = this.$loadNew;
                    boolean inc$iv = true;
                    boolean $i$f$modifyFamiliesAndCleanup = false;
                    void $this$toTypedArray$iv$iv = families$iv;
                    boolean $i$f$toTypedArray = false;
                    void thisCollection$iv$iv = $this$toTypedArray$iv$iv;
                    ModFamily[] fs$iv = thisCollection$iv$iv.toArray(new ModNamingIdentifyingFamily[0]);
                    ModFamily[] families$iv$iv = Arrays.copyOf(fs$iv, fs$iv.length);
                    boolean $i$f$modifyFamiliesAndCleanup2 = false;
                    for (ModFamily f$iv$iv : families$iv$iv) {
                        f$iv$iv.markChildrenAsSyncPending();
                    }
                    boolean bl3 = false;
                    BaseNativeIntrospector this_$iv = (BaseNativeIntrospector)object;
                    boolean $i$f$continueOnDbError = false;
                    try {
                        boolean bl4 = false;
                        if (bl) {
                            LongOpenHashSet ids = new LongOpenHashSet((long[])MySchemaRetriever.access$performQuery(mySchemaRetriever, GPlumIntrospector.access$getQUERIES$cp().getRetrieveExistentPartitions()));
                            ModNamingIdentifyingFamily<? extends GPlumLocalTable> modNamingIdentifyingFamily2 = schema2.getTables();
                            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily2, (String)"getTables(...)");
                            Iterable $this$forEach$iv = modNamingIdentifyingFamily2;
                            boolean $i$f$forEach = false;
                            for (T element$iv : $this$forEach$iv) {
                                GPlumLocalTable t = (GPlumLocalTable)element$iv;
                                boolean bl5 = false;
                                ModNamingIdentifyingFamily<? extends GPlumPartition> modNamingIdentifyingFamily3 = t.getPartitions();
                                Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily3, (String)"getPartitions(...)");
                                Iterable $this$forEach$iv2 = modNamingIdentifyingFamily3;
                                boolean $i$f$forEach2 = false;
                                for (T element$iv2 : $this$forEach$iv2) {
                                    GPlumPartition it3 = (GPlumPartition)element$iv2;
                                    boolean bl6 = false;
                                    if (!ids.contains(it3.getObjectId())) continue;
                                    it3.resetSyncPending();
                                }
                            }
                        }
                        if (bl2) {
                            void $this$forEach$iv;
                            void $this$groupByTo$iv$iv;
                            Object $this$groupBy$iv = (Iterable)MySchemaRetriever.access$performQuery(mySchemaRetriever, GPlumIntrospector.access$getQUERIES$cp().getRetrievePartitions());
                            boolean $i$f$groupBy = false;
                            Iterable $i$f$forEach = $this$groupBy$iv;
                            Map destination$iv$iv2 = new LinkedHashMap<K, V>();
                            boolean $i$f$groupByTo = false;
                            for (T element$iv$iv : $this$groupByTo$iv$iv) {
                                Object object2;
                                GPlumIntroQueries.OnePartition it4 = (GPlumIntroQueries.OnePartition)element$iv$iv;
                                boolean bl7 = false;
                                Long key$iv$iv = it4.table_id;
                                Map $this$getOrPut$iv$iv$iv = destination$iv$iv2;
                                boolean $i$f$getOrPut = false;
                                V value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                                if (value$iv$iv$iv == null) {
                                    boolean bl8 = false;
                                    List answer$iv$iv$iv = new ArrayList<E>();
                                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                                    object2 = answer$iv$iv$iv;
                                } else {
                                    object2 = value$iv$iv$iv;
                                }
                                List list$iv$iv = (List)object2;
                                list$iv$iv.add(element$iv$iv);
                            }
                            $this$groupBy$iv = destination$iv$iv2;
                            boolean $i$f$forEach3 = false;
                            Iterator<Map.Entry<K, V>> iterator = $this$forEach$iv.entrySet().iterator();
                            while (iterator.hasNext()) {
                                GPlumLocalTable table;
                                Map.Entry<K, V> element$iv;
                                Map.Entry<K, V> entry = element$iv = iterator.next();
                                boolean bl9 = false;
                                long table_id = ((Number)entry.getKey()).longValue();
                                List ps = (List)entry.getValue();
                                if ((GPlumLocalTable)schema2.getTables().getByObjectId(table_id) == null) continue;
                                GPlumPartitionTree gPlumPartitionTree = table.getPartitionsTree();
                                if (gPlumPartitionTree == null) {
                                    gPlumPartitionTree = new GPlumPartitionTree();
                                }
                                GPlumPartitionTree gPlumPartitionTree2 = gPlumPartitionTree;
                                Intrinsics.checkNotNull((Object)gPlumPartitionTree2);
                                GPlumPartitionTree tree = gPlumPartitionTree2;
                                table.setPartitionsTree(tree);
                                for (GPlumIntroQueries.OnePartition p2 : ps) {
                                    void $this$mapTo$iv$iv2;
                                    void $this$map$iv2;
                                    GPlumPartition partition = table.getPartitions().renew(p2.id, p2.name);
                                    partition.setPartitionKind(GPlumPartitionKind.of(p2.kind));
                                    Iterable iterable = GPlumIntrospector.access$parseListOfLongs((GPlumIntrospector)object, p2.columns);
                                    GPlumPartition gPlumPartition = partition;
                                    boolean $i$f$map2 = false;
                                    void var38_55 = $this$map$iv2;
                                    Collection destination$iv$iv3 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                                    boolean $i$f$mapTo2 = false;
                                    for (T item$iv$iv : $this$mapTo$iv$iv2) {
                                        void it5;
                                        long l = ((Number)item$iv$iv).longValue();
                                        Collection collection3 = destination$iv$iv3;
                                        boolean bl10 = false;
                                        collection3.add((int)it5);
                                    }
                                    gPlumPartition.setColumns((List)destination$iv$iv3);
                                    partition.setValues(StringKt.nullize((String)p2.values_list, (boolean)true));
                                    partition.setStartValue(StringKt.nullize((String)p2.start_value, (boolean)true));
                                    partition.setEndValue(StringKt.nullize((String)p2.end_value, (boolean)true));
                                    partition.setEveryValue(StringKt.nullize((String)p2.every_value, (boolean)true));
                                    partition.setStartInclusive(p2.start_inclusive);
                                    partition.setEndInclusive(p2.end_inclusive);
                                    partition.setDefaultPartition(p2.is_default);
                                    partition.setOrder(p2.order);
                                    partition.setLevel(p2.level);
                                    tree.addEdge(p2.parent_id, p2.id);
                                }
                            }
                        }
                    }
                    catch (DBException e$iv) {
                        this_$iv.getErrorSink().consume(null, (Object)((Object)e$iv));
                    }
                    for (ModFamily f$iv$iv : families$iv$iv) {
                        f$iv$iv.removeSyncPendingChildren();
                        f$iv$iv.sort();
                    }
                }
            });
        }

        private final void retrieveExternalTables(boolean detectDropped, boolean loadNew) {
            GPlumIntrospector.this.reportRetrieving("external tables", "introspection.retrieve.external.tables");
            this.inSchema((Function1)new Function1<GPlumSchema, Unit>(GPlumIntrospector.this, detectDropped, this, loadNew){
                final /* synthetic */ GPlumIntrospector this$0;
                final /* synthetic */ boolean $detectDropped;
                final /* synthetic */ MySchemaRetriever this$1;
                final /* synthetic */ boolean $loadNew;
                {
                    this.this$0 = $receiver;
                    this.$detectDropped = $detectDropped;
                    this.this$1 = $receiver2;
                    this.$loadNew = $loadNew;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull GPlumSchema schema2) {
                    void $this$modifyAndCleanup_u24default$iv;
                    Intrinsics.checkNotNullParameter((Object)schema2, (String)"schema");
                    ModFamily modFamily = schema2.getExternalTables();
                    GPlumIntrospector gPlumIntrospector = this.this$0;
                    boolean bl = this.$detectDropped;
                    MySchemaRetriever mySchemaRetriever = this.this$1;
                    boolean bl2 = this.$loadNew;
                    boolean inc$iv = true;
                    boolean $i$f$modifyAndCleanup = false;
                    $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
                    ModNamingIdentifyingFamily it2 = (ModNamingIdentifyingFamily)$this$modifyAndCleanup_u24default$iv;
                    boolean bl3 = false;
                    BaseNativeIntrospector this_$iv = gPlumIntrospector;
                    boolean $i$f$continueOnDbError = false;
                    try {
                        boolean bl4 = false;
                        if (bl) {
                            long[] $this$forEach$iv = (long[])MySchemaRetriever.access$performQuery(mySchemaRetriever, GPlumIntrospector.access$getQUERIES$cp().getRetrieveExistentExternalTables());
                            boolean $i$f$forEach = false;
                            int n = $this$forEach$iv.length;
                            for (int j = 0; j < n; ++j) {
                                long element$iv;
                                long it3 = element$iv = $this$forEach$iv[j];
                                boolean bl5 = false;
                                GPlumExternalTable gPlumExternalTable = (GPlumExternalTable)schema2.getExternalTables().getByObjectId(it3);
                                if (gPlumExternalTable != null) {
                                    gPlumExternalTable.resetSyncPending();
                                }
                            }
                        }
                        if (bl2) {
                            BaseNativeIntrospector.AbstractRetriever.performQueryHandleEachRow$default(mySchemaRetriever, GPlumIntrospector.access$getQUERIES$cp().getRetrieveExternalTables(), 0, (Function1)new Function1<GPlumIntroQueries.OneExternalTable, Unit>(mySchemaRetriever, schema2){
                                final /* synthetic */ MySchemaRetriever this$0;
                                final /* synthetic */ GPlumSchema $schema;
                                {
                                    this.this$0 = $receiver;
                                    this.$schema = $schema;
                                    super(1);
                                }

                                public final void invoke(@NotNull GPlumIntroQueries.OneExternalTable t) {
                                    Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                                    MySchemaRetriever.access$setWasExternalTables$p(this.this$0, true);
                                    GPlumExternalTable table = this.$schema.getExternalTables().renew(t.id, t.name);
                                    table.setStateNumber(t.state_number);
                                    table.setWritable(t.writable);
                                    table.setLocations(ArraysKt.toList((Object[])t.locations));
                                    table.setCommand(t.command);
                                    table.setExecLocation(t.exec_location);
                                    table.setFormat(GPlumExternalTableFormat.of(t.format));
                                    String string = t.format_options;
                                    table.setFormatOptions(string != null ? ((Object)StringsKt.trim((CharSequence)string)).toString() : null);
                                    table.setEncoding(t.encoding);
                                    table.setRejectLimit(t.reject_limit);
                                    table.setRejectLimitType(GPlumExternalTableRejectLimitType.of(t.reject_limit_type));
                                }
                            }, 2, null);
                        }
                    }
                    catch (DBException e$iv) {
                        this_$iv.getErrorSink().consume(null, (Object)((Object)e$iv));
                    }
                    $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
                    $this$modifyAndCleanup_u24default$iv.sort();
                }
            });
        }

        @Override
        protected void retrieveCollations(boolean detectDropped, boolean loadNew) {
            super.retrieveCollations(detectDropped && GPlumIntrospector.this.isSixth(), loadNew && GPlumIntrospector.this.isSixth());
        }

        @Override
        protected void retrieveForeignTablesInfo() {
            if (GPlumIntrospector.this.isSixth()) {
                super.retrieveForeignTablesInfo();
            }
        }

        @Override
        @NotNull
        protected ModIdentifyingFamily<? extends BasicModIdentifiedElement>[] getSchemaChildrenToDrop(@NotNull GPlumSchema schema2) {
            Intrinsics.checkNotNullParameter((Object)schema2, (String)"schema");
            Object[] objectArray = new ModNamingIdentifyingFamily[]{schema2.getExternalTables()};
            return (ModIdentifyingFamily[])ArraysKt.plus((Object[])super.getSchemaChildrenToDrop((PgGPlumBaseSchema)schema2), (Object[])objectArray);
        }

        @Override
        protected boolean wasDataTables() {
            return super.wasDataTables() || this.wasExternalTables;
        }

        @Override
        protected boolean shouldIntrospectTableRelatedDataIncremental() {
            return super.shouldIntrospectTableRelatedDataIncremental() || ((GPlumSchema)this.getSchema()).getExternalTables().hasChildren();
        }

        @Override
        protected void processModView(@NotNull PgBaseLikeStoredTable table, @NotNull PgBaseIntroQueries.OneTable t) {
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        }

        @Override
        @Nullable
        protected PgGPlumBaseLikeStoredTable getTableOrView(@NotNull GPlumSchema schema2, char relKind, long tableId) {
            Intrinsics.checkNotNullParameter((Object)schema2, (String)"schema");
            PgGPlumBaseLikeStoredTable pgGPlumBaseLikeStoredTable = super.getTableOrView((PgGPlumBaseSchema)schema2, relKind, tableId);
            if (pgGPlumBaseLikeStoredTable == null) {
                char c2 = relKind;
                if (c2 == 'e') {
                    pgGPlumBaseLikeStoredTable = (PgGPlumBaseLikeStoredTable)schema2.getExternalTables().getByObjectId(tableId);
                } else if (c2 == '\u0000') {
                    GPlumMatView gPlumMatView = (GPlumMatView)schema2.getMatViews().getByObjectId(tableId);
                    pgGPlumBaseLikeStoredTable = gPlumMatView != null ? (PgGPlumBaseLikeStoredTable)gPlumMatView : (PgGPlumBaseLikeStoredTable)schema2.getExternalTables().getByObjectId(tableId);
                } else {
                    pgGPlumBaseLikeStoredTable = null;
                }
            }
            return pgGPlumBaseLikeStoredTable;
        }

        @Override
        protected void retrieveEnumLabels() {
            if (GPlumIntrospector.this.isFifth()) {
                super.retrieveEnumLabels();
            }
        }

        @Override
        @NotNull
        protected List<String> fixLabelsOrder(@NotNull String[] labels) {
            Intrinsics.checkNotNullParameter((Object)labels, (String)"labels");
            return CollectionsKt.sorted((Iterable)CollectionsKt.listOf((Object[])Arrays.copyOf(labels, labels.length)));
        }

        public static final /* synthetic */ void access$retrieveExternalTables(MySchemaRetriever $this, boolean detectDropped, boolean loadNew) {
            $this.retrieveExternalTables(detectDropped, loadNew);
        }

        public static final /* synthetic */ void access$retrievePartitions(MySchemaRetriever $this, boolean detectDropped, boolean loadNew) {
            $this.retrievePartitions(detectDropped, loadNew);
        }

        public static final /* synthetic */ void access$retrieveDistributedColumns(MySchemaRetriever $this) {
            $this.retrieveDistributedColumns();
        }

        public static final /* synthetic */ Object access$performQuery(MySchemaRetriever $this, SqlQuery query) {
            return $this.performQuery(query);
        }

        public static final /* synthetic */ void access$setWasExternalTables$p(MySchemaRetriever $this, boolean bl) {
            $this.wasExternalTables = bl;
        }
    }
}

