/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.generic.types;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.base.types.DasTypeSystemImpl;
import com.intellij.database.types.DasTypeCategory;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0006H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/database/dialects/generic/types/GenericTypeSystem;", "Lcom/intellij/database/dialects/base/types/DasTypeSystemImpl;", "dbms", "Lcom/intellij/database/Dbms;", "(Lcom/intellij/database/Dbms;)V", "getNormalizedTypeName", "", "name", "getTypeCategoryByName", "Lcom/intellij/database/types/DasTypeCategory;", "typeName", "intellij.database.dialects.generic"})
public final class GenericTypeSystem
extends DasTypeSystemImpl {
    public GenericTypeSystem(@NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        super(dbms);
    }

    @Override
    @NotNull
    public String getNormalizedTypeName(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return switch (super.getNormalizedTypeName(name2)) {
            case "character" -> "char";
            case "char varying" -> "varchar";
            case "character varying" -> "varchar";
            case "national char" -> "nchar";
            case "national character" -> "nchar";
            case "national char varying" -> "nchar varying";
            case "national character varying" -> "nchar varying";
            case "dec" -> "decimal";
            case "int" -> "integer";
            default -> {
                void var2_2;
                yield var2_2;
            }
        };
    }

    @Override
    @NotNull
    public DasTypeCategory getTypeCategoryByName(@NotNull String typeName) {
        Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
        return switch (typeName) {
            case "bit" -> DasTypeCategory.INTEGER;
            case "bit varying" -> DasTypeCategory.INTEGER;
            case "numeric" -> DasTypeCategory.REAL;
            case "decimal" -> DasTypeCategory.REAL;
            default -> super.getTypeCategoryByName(typeName);
        };
    }
}

