/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.exasol;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.base.AbstractDatabaseDialect;
import com.intellij.database.dialects.base.TypeHelper;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.SearchPath;
import com.intellij.openapi.util.text.StringUtil;
import java.sql.SQLException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExaDialect
extends AbstractDatabaseDialect
implements DatabaseDialect {
    private ExaDialect() {
        super(new TypeHelper.ExaTypeHelper());
    }

    @Override
    @NotNull
    public Dbms getDbms() {
        Dbms dbms = Dbms.EXASOL;
        if (dbms == null) {
            ExaDialect.$$$reportNull$$$0(0);
        }
        return dbms;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return "Exasol";
    }

    @Override
    public String sqlSetSearchPath(@NotNull SearchPath path) {
        if (path == null) {
            ExaDialect.$$$reportNull$$$0(1);
        }
        ObjectPath current = path.getCurrent();
        if (current.kind != ObjectKind.SCHEMA && current.kind != ObjectKind.EXTERNAL_SCHEMA) {
            return null;
        }
        String schema2 = this.getNamingService().catToScript(current.getName(), current.kind, this.getCodeStyle().getQuotesPriority());
        return String.format("open schema %s", schema2);
    }

    @Override
    public boolean supportsEmptyTables() {
        return false;
    }

    @Override
    public boolean supportsInsertInto() {
        return super.supportsInsertInto();
    }

    @Override
    @NotNull
    public DdlBuilder qualifiedIdentifier(@NotNull DdlBuilder builder, @NotNull String identifier, @Nullable DasObject object, @NotNull DasObject qualifier) {
        DasObject schema2;
        if (builder == null) {
            ExaDialect.$$$reportNull$$$0(2);
        }
        if (identifier == null) {
            ExaDialect.$$$reportNull$$$0(3);
        }
        if (qualifier == null) {
            ExaDialect.$$$reportNull$$$0(4);
        }
        DasObject schemaOrExternal = (schema2 = DasUtil.getSchemaObject(qualifier)) == null ? DasUtil.getParentOfKind(qualifier, ObjectKind.EXTERNAL_SCHEMA, false) : schema2;
        DdlBuilder ddlBuilder = builder.qualifiedRef(object, identifier, schemaOrExternal, DasUtil.getName(schemaOrExternal), null, null, null, null);
        if (ddlBuilder == null) {
            ExaDialect.$$$reportNull$$$0(5);
        }
        return ddlBuilder;
    }

    @Override
    public boolean supportsCommonTableExpression() {
        return true;
    }

    @Override
    public SearchPath tryToLoadSearchPath(@NotNull DatabaseConnectionCore connection2) throws SQLException {
        String s2;
        if (connection2 == null) {
            ExaDialect.$$$reportNull$$$0(6);
        }
        return StringUtil.isEmpty((String)(s2 = DbImplUtilCore.concatStringResults(connection2, connection2.getDbms(), "select current_schema", 1, DbImplUtilCore.ConcatenationProps.NO_CONCAT))) ? null : SearchPath.of(ObjectPath.create("EXA_DB", ObjectKind.DATABASE).append(s2, ObjectKind.SCHEMA));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/exasol/ExaDialect";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/exasol/ExaDialect";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "qualifiedIdentifier";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "sqlSetSearchPath";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "qualifiedIdentifier";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadSearchPath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 6 -> new IllegalArgumentException(string);
        };
    }
}

