/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.couchbase;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.base.BaseHookUpHelper;
import com.intellij.database.dialects.couchbase.CouchbaseHookUpHelper;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.openapi.util.text.StringUtil;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0012\u0010\t\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\nH\u0016J\u0012\u0010\u000b\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\nH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/database/dialects/couchbase/CouchbaseHookUpHelper;", "Lcom/intellij/database/dialects/base/BaseHookUpHelper;", "dbms", "Lcom/intellij/database/Dbms;", "(Lcom/intellij/database/Dbms;)V", "hasUniqueIndex", "", "table", "Lcom/intellij/database/model/DasTable;", "isSortingApplicable", "Lcom/intellij/database/model/DasObject;", "isTwoPhaseSelect", "intellij.database.dialects.couchbase"})
public final class CouchbaseHookUpHelper
extends BaseHookUpHelper {
    public CouchbaseHookUpHelper(@NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        super(dbms);
    }

    @Override
    public boolean isTwoPhaseSelect(@Nullable DasObject table) {
        if (!(table instanceof DasTable)) {
            return false;
        }
        DasObject parent2 = ((DasTable)table).getDasParent();
        return parent2 != null && StringUtil.equalsIgnoreCase((CharSequence)"default", (CharSequence)parent2.getName()) && !this.hasUniqueIndex((DasTable)table);
    }

    @Override
    public boolean isSortingApplicable(@Nullable DasObject table) {
        return table instanceof DasTable ? this.hasUniqueIndex((DasTable)table) : super.isSortingApplicable(table);
    }

    private final boolean hasUniqueIndex(DasTable table) {
        return table.getDasChildren(ObjectKind.INDEX).filter(arg_0 -> CouchbaseHookUpHelper.hasUniqueIndex$lambda$0(hasUniqueIndex.1.INSTANCE, arg_0)).isNotEmpty();
    }

    private static final boolean hasUniqueIndex$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }
}

