/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.clickhouse.introspector;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.base.introspector.BaseIntrospectionFunctions;
import com.intellij.database.dialects.base.introspector.BaseIntrospector;
import com.intellij.database.dialects.base.introspector.BaseNativeIntrospector;
import com.intellij.database.dialects.base.introspector.BaseSingleDatabaseIntrospector;
import com.intellij.database.dialects.base.introspector.IntrospectorSqlHelper;
import com.intellij.database.dialects.clickhouse.introspector.CHouseIntroQueries;
import com.intellij.database.dialects.clickhouse.introspector.CHouseIntrospector;
import com.intellij.database.dialects.clickhouse.introspector.CHouseIntrospector$CHouseSchemaRetriever$retrieveColumns$;
import com.intellij.database.dialects.clickhouse.introspector.CHouseIntrospector$applySchemas$1$invoke$;
import com.intellij.database.dialects.clickhouse.introspector.CHouseIntrospectorKt;
import com.intellij.database.dialects.clickhouse.model.CHouseLikeColumn;
import com.intellij.database.dialects.clickhouse.model.CHouseLikeTable;
import com.intellij.database.dialects.clickhouse.model.CHouseMatView;
import com.intellij.database.dialects.clickhouse.model.CHouseRole;
import com.intellij.database.dialects.clickhouse.model.CHouseRoot;
import com.intellij.database.dialects.clickhouse.model.CHouseRoutine;
import com.intellij.database.dialects.clickhouse.model.CHouseSchema;
import com.intellij.database.dialects.clickhouse.model.CHouseTable;
import com.intellij.database.dialects.clickhouse.model.CHouseTableColumn;
import com.intellij.database.dialects.clickhouse.model.CHouseUser;
import com.intellij.database.dialects.clickhouse.model.CHouseView;
import com.intellij.database.introspection.DBIntrospectionContext;
import com.intellij.database.introspection.DBIntrospector;
import com.intellij.database.layoutedQueries.DBTransaction;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ElementCacheKt;
import com.intellij.database.model.ElementCacheOptimizersKt;
import com.intellij.database.model.ElementChecker;
import com.intellij.database.model.ElementSearchCache;
import com.intellij.database.model.ElementSearcher;
import com.intellij.database.model.ElementSearcherNN;
import com.intellij.database.model.FamilySearcher;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PerObjectVersion;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModMateNamespace;
import com.intellij.database.model.basic.BasicModSchema;
import com.intellij.database.model.basic.BasicModView;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.families.NamingFamily;
import com.intellij.database.model.families.PositioningNamingFamily;
import com.intellij.database.model.properties.ColumnKind;
import com.intellij.database.model.properties.CompositeText;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.remote.jdba.exceptions.DBException;
import com.intellij.database.types.DasTypeSystemBase;
import com.intellij.database.types.DasTypeSystems;
import com.intellij.database.util.Version;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.util.text.StringKt;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\n\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0004$%&'B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002J.\u0010\u000e\u001a\u0018\u0012\u0004\u0012\u00020\u00020\u000fR\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0014J.\u0010\u0013\u001a\u0018\u0012\u0004\u0012\u00020\u00020\u0014R\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0014J\u001c\u0010\u0015\u001a\u00060\u0016R\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0003H\u0014J\u0010\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u0011H\u0014J\u0018\u0010\u001a\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0003H\u0002J&\u0010\u001b\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u00112\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00030\f2\u0006\u0010\u001d\u001a\u00020\u001eH\u0014J\u0010\u0010\u001f\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u0011H\u0014J\b\u0010 \u001a\u00020\nH\u0016J\u0010\u0010!\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u0011H\u0002J\u0010\u0010\"\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u0011H\u0002J\u0010\u0010#\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u0011H\u0002\u00a8\u0006("}, d2={"Lcom/intellij/database/dialects/clickhouse/introspector/CHouseIntrospector;", "Lcom/intellij/database/dialects/base/introspector/BaseSingleDatabaseIntrospector;", "Lcom/intellij/database/dialects/clickhouse/model/CHouseRoot;", "Lcom/intellij/database/dialects/clickhouse/model/CHouseSchema;", "context", "Lcom/intellij/database/introspection/DBIntrospectionContext;", "modelFactory", "Lcom/intellij/database/model/ModelFactory;", "(Lcom/intellij/database/introspection/DBIntrospectionContext;Lcom/intellij/database/model/ModelFactory;)V", "applySchemas", "", "newSchemas", "", "", "createDatabaseRetriever", "Lcom/intellij/database/dialects/base/introspector/BaseSingleDatabaseIntrospector$BaseDatabaseRetriever;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "database", "createNativeRetriever", "Lcom/intellij/database/dialects/base/introspector/BaseSingleDatabaseIntrospector$BaseNativeRetriever;", "createSchemaRetriever", "Lcom/intellij/database/dialects/clickhouse/introspector/CHouseIntrospector$CHouseSchemaRetriever;", "schema", "introspectNamespacesInTran", "tran", "introspectOneSchema", "introspectSchemasAuto", "schemas", "whole", "", "introspectTheServerObjects", "retrieveAndApplySchemas", "retrieveFunctions", "retrieveRoles", "retrieveUsers", "CHouseDatabaseRetriever", "CHouseNativeRetriever", "CHouseSchemaRetriever", "Factory", "intellij.database.dialects.clickhouse"})
public final class CHouseIntrospector
extends BaseSingleDatabaseIntrospector<CHouseRoot, CHouseSchema> {
    public CHouseIntrospector(@NotNull DBIntrospectionContext context, @NotNull ModelFactory modelFactory) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)modelFactory, (String)"modelFactory");
        BaseIntrospector.Nature nature = BaseIntrospector.DefaultNature.INSTANCE;
        Dbms dbms = Dbms.CLICKHOUSE;
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"CLICKHOUSE");
        super(context, nature, dbms, modelFactory);
    }

    @Override
    protected void introspectNamespacesInTran(@NotNull DBTransaction tran) {
        Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
        List<String> schemaNames2 = CHouseIntroQueries.INSTANCE.retrieveSchemas(tran);
        this.applySchemas(schemaNames2);
    }

    @Override
    public void retrieveAndApplySchemas() {
        List schemaNames2 = (List)this.inTransaction(retrieveAndApplySchemas.schemaNames.1.INSTANCE);
        this.applySchemas(schemaNames2);
    }

    private final void applySchemas(List<String> newSchemas) {
        this.inModel((Function1)new Function1<CHouseRoot, Unit>(newSchemas){
            final /* synthetic */ List<String> $newSchemas;
            {
                this.$newSchemas = $newSchemas;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull CHouseRoot root2) {
                void scs$iv;
                void $this$applySchemasNamed$iv$iv;
                void $this$applySchemasNamed$iv;
                Intrinsics.checkNotNullParameter((Object)root2, (String)"root");
                NamingFamily namingFamily = root2.getSchemas();
                Intrinsics.checkNotNullExpressionValue((Object)namingFamily, (String)"getSchemas(...)");
                NamingFamily namingFamily2 = namingFamily;
                List<String> list = this.$newSchemas;
                List<String> list2 = this.$newSchemas;
                boolean $i$f$applySchemasNamed = false;
                void var6_6 = $this$applySchemasNamed$iv;
                ElementSearchCache searchCache$iv$iv = new ElementSearchCache();
                boolean $i$f$applySchemasNamed2 = false;
                ElementSearcherNN<T, void> schemas$iv$iv = ElementCacheOptimizersKt.byName(ElementCacheKt.searchElement(searchCache$iv$iv), (Function1)new Function1<String, String>(){

                    /*
                     * Ignored method signature, as it can't be verified against descriptor
                     * WARNING - void declaration
                     */
                    @NotNull
                    public final String invoke(Object $this$byName) {
                        void var2_2;
                        String it2 = (String)$this$byName;
                        boolean bl = false;
                        return var2_2;
                    }
                }).inFamily((Family)$this$applySchemasNamed$iv$iv).orCreate(applySchemas$1$invoke$$inlined$applySchemasNamed$2.INSTANCE);
                void $this$applySchemasImpl$iv$iv$iv = $this$applySchemasNamed$iv$iv;
                boolean $i$f$applySchemasImpl = false;
                $this$applySchemasImpl$iv$iv$iv.markChildrenAsSyncPending();
                Iterable $this$forEach$iv$iv$iv$iv = (Iterable)scs$iv;
                boolean $i$f$forEach = false;
                Iterator<T> iterator = $this$forEach$iv$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    void sc2;
                    void sc$iv$iv;
                    T element$iv$iv$iv$iv;
                    T sc$iv$iv$iv = element$iv$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    T t = sc$iv$iv$iv;
                    void $this$applySchemasNamed_u24lambda_u248$iv$iv = $this$applySchemasImpl$iv$iv$iv;
                    boolean bl2 = false;
                    BasicModMateNamespace $this$applySchemasNamed_u24lambda_u248_u24lambda_u247$iv$iv = (BasicModMateNamespace)schemas$iv$iv.find(sc$iv$iv);
                    boolean bl3 = false;
                    String string = (String)sc$iv$iv;
                    CHouseSchema $this$invoke_u24lambda_u241 = (CHouseSchema)$this$applySchemasNamed_u24lambda_u248_u24lambda_u247$iv$iv;
                    boolean bl4 = false;
                    $this$invoke_u24lambda_u241.setCurrent(Intrinsics.areEqual((Object)sc2, (Object)CollectionsKt.first(list2)));
                }
                $this$applySchemasImpl$iv$iv$iv.removeSyncPendingChildren();
                $this$applySchemasImpl$iv$iv$iv.sort();
            }
        });
    }

    @Override
    protected void introspectSchemasAuto(@NotNull DBTransaction tran, @NotNull List<? extends CHouseSchema> schemas2, boolean whole) {
        Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
        Intrinsics.checkNotNullParameter(schemas2, (String)"schemas");
        for (CHouseSchema cHouseSchema : schemas2) {
            this.introspectOneSchema(tran, cHouseSchema);
        }
    }

    private final void introspectOneSchema(DBTransaction tran, CHouseSchema schema2) {
        this.handleErrors("Introspect schema " + schema2.getName(), (Function0<Unit>)((Function0)new Function0<Unit>(this, tran, schema2){
            final /* synthetic */ CHouseIntrospector this$0;
            final /* synthetic */ DBTransaction $tran;
            final /* synthetic */ CHouseSchema $schema;
            {
                this.this$0 = $receiver;
                this.$tran = $tran;
                this.$schema = $schema;
                super(0);
            }

            public final void invoke() {
                CHouseSchemaRetriever retriever = this.this$0.createSchemaRetriever(this.$tran, this.$schema);
                retriever.process();
            }
        }));
    }

    @Override
    protected void introspectTheServerObjects(@NotNull DBTransaction tran) {
        Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
        this.retrieveFunctions(tran);
        this.retrieveUsers(tran);
        this.retrieveRoles(tran);
    }

    private final void retrieveFunctions(DBTransaction tran) {
        this.reportRetrieving("server objects", "introspection.retrieve.serverObjects");
        this.inModel((Function1)new Function1<CHouseRoot, Unit>(this, tran){
            final /* synthetic */ CHouseIntrospector this$0;
            final /* synthetic */ DBTransaction $tran;
            {
                this.this$0 = $receiver;
                this.$tran = $tran;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull CHouseRoot root2) {
                void $this$modifyAndCleanup_u24default$iv;
                Intrinsics.checkNotNullParameter((Object)root2, (String)"root");
                ModFamily modFamily = root2.getRoutines();
                CHouseIntrospector cHouseIntrospector = this.this$0;
                DBTransaction dBTransaction = this.$tran;
                boolean inc$iv = true;
                boolean $i$f$modifyAndCleanup = false;
                $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
                ModNamingFamily it2 = (ModNamingFamily)$this$modifyAndCleanup_u24default$iv;
                boolean bl = false;
                BaseNativeIntrospector this_$iv = cHouseIntrospector;
                boolean $i$f$continueOnDbError = false;
                try {
                    boolean bl2 = false;
                    CHouseIntroQueries.INSTANCE.processFunctions(dBTransaction, (Function1<? super CHouseIntroQueries.FunctionInfo, Unit>)((Function1)new Function1<CHouseIntroQueries.FunctionInfo, Unit>(root2){
                        final /* synthetic */ CHouseRoot $root;
                        {
                            this.$root = $root;
                            super(1);
                        }

                        public final void invoke(@NotNull CHouseIntroQueries.FunctionInfo r) {
                            Intrinsics.checkNotNullParameter((Object)r, (String)"r");
                            CHouseRoutine routine2 = this.$root.getRoutines().createOrGet(r.name);
                            Boolean bl = r.is_aggregate;
                            routine2.setAggregate(bl != null ? bl : false);
                            routine2.getArguments().clear();
                        }
                    }));
                }
                catch (DBException e$iv) {
                    this_$iv.getErrorSink().consume(null, (Object)((Object)e$iv));
                }
                $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
                $this$modifyAndCleanup_u24default$iv.sort();
            }
        });
    }

    private final void retrieveUsers(DBTransaction tran) {
        this.reportRetrieving("server objects", "introspection.retrieve.serverObjects");
        this.inModel((Function1)new Function1<CHouseRoot, Unit>(this, tran){
            final /* synthetic */ CHouseIntrospector this$0;
            final /* synthetic */ DBTransaction $tran;
            {
                this.this$0 = $receiver;
                this.$tran = $tran;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull CHouseRoot root2) {
                void $this$modifyAndCleanup_u24default$iv;
                Intrinsics.checkNotNullParameter((Object)root2, (String)"root");
                ModFamily modFamily = root2.getUsers();
                CHouseIntrospector cHouseIntrospector = this.this$0;
                DBTransaction dBTransaction = this.$tran;
                boolean inc$iv = true;
                boolean $i$f$modifyAndCleanup = false;
                $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
                ModNamingFamily it2 = (ModNamingFamily)$this$modifyAndCleanup_u24default$iv;
                boolean bl = false;
                BaseNativeIntrospector this_$iv = cHouseIntrospector;
                boolean $i$f$continueOnDbError = false;
                try {
                    boolean bl2 = false;
                    CHouseIntroQueries.INSTANCE.processUsers(dBTransaction, (Function1<? super CHouseIntroQueries.UserInfo, Unit>)((Function1)new Function1<CHouseIntroQueries.UserInfo, Unit>(root2){
                        final /* synthetic */ CHouseRoot $root;
                        {
                            this.$root = $root;
                            super(1);
                        }

                        public final void invoke(@NotNull CHouseIntroQueries.UserInfo u) {
                            CHouseUser cHouseUser;
                            Intrinsics.checkNotNullParameter((Object)u, (String)"u");
                            CHouseUser $this$invoke_u24lambda_u240 = cHouseUser = this.$root.getUsers().createOrGet(u.name);
                            boolean bl = false;
                            $this$invoke_u24lambda_u240.setAuthType(u.auth_type);
                            $this$invoke_u24lambda_u240.setHostIp(ArraysKt.toList((Object[])u.host_ip));
                            $this$invoke_u24lambda_u240.setHostNames(ArraysKt.toList((Object[])u.host_names));
                            $this$invoke_u24lambda_u240.setHostNamesLike(ArraysKt.toList((Object[])u.host_names_like));
                            $this$invoke_u24lambda_u240.setHostNamesRegexp(ArraysKt.toList((Object[])u.host_names_regexp));
                            $this$invoke_u24lambda_u240.setDefaultRolesAll(u.default_roles_all);
                            $this$invoke_u24lambda_u240.setDefaultRolesList(ArraysKt.toList((Object[])(u.default_roles_all ? u.default_roles_except : u.default_roles_list)));
                        }
                    }));
                }
                catch (DBException e$iv) {
                    this_$iv.getErrorSink().consume(null, (Object)((Object)e$iv));
                }
                $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
                $this$modifyAndCleanup_u24default$iv.sort();
            }
        });
    }

    private final void retrieveRoles(DBTransaction tran) {
        this.reportRetrieving("server objects", "introspection.retrieve.serverObjects");
        this.inModel((Function1)new Function1<CHouseRoot, Unit>(this, tran){
            final /* synthetic */ CHouseIntrospector this$0;
            final /* synthetic */ DBTransaction $tran;
            {
                this.this$0 = $receiver;
                this.$tran = $tran;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull CHouseRoot root2) {
                void $this$modifyAndCleanup_u24default$iv;
                Intrinsics.checkNotNullParameter((Object)root2, (String)"root");
                ModFamily modFamily = root2.getRoles();
                CHouseIntrospector cHouseIntrospector = this.this$0;
                DBTransaction dBTransaction = this.$tran;
                boolean inc$iv = true;
                boolean $i$f$modifyAndCleanup = false;
                $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
                ModNamingFamily it2 = (ModNamingFamily)$this$modifyAndCleanup_u24default$iv;
                boolean bl = false;
                BaseNativeIntrospector this_$iv = cHouseIntrospector;
                boolean $i$f$continueOnDbError = false;
                try {
                    boolean bl2 = false;
                    CHouseIntroQueries.INSTANCE.processRoles(dBTransaction, (Function1<? super CHouseIntroQueries.RoleInfo, Unit>)((Function1)new Function1<CHouseIntroQueries.RoleInfo, Unit>(root2){
                        final /* synthetic */ CHouseRoot $root;
                        {
                            this.$root = $root;
                            super(1);
                        }

                        public final void invoke(@NotNull CHouseIntroQueries.RoleInfo r) {
                            CHouseRole cHouseRole;
                            Intrinsics.checkNotNullParameter((Object)r, (String)"r");
                            CHouseRole $this$invoke_u24lambda_u240 = cHouseRole = this.$root.getRoles().createOrGet(r.name);
                            boolean bl = false;
                        }
                    }));
                }
                catch (DBException e$iv) {
                    this_$iv.getErrorSink().consume(null, (Object)((Object)e$iv));
                }
                $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
                $this$modifyAndCleanup_u24default$iv.sort();
            }
        });
    }

    @Override
    @NotNull
    protected BaseSingleDatabaseIntrospector.BaseDatabaseRetriever<CHouseRoot> createDatabaseRetriever(@NotNull DBTransaction transaction, @NotNull CHouseRoot database) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        return new CHouseDatabaseRetriever(transaction);
    }

    @Override
    @NotNull
    protected BaseSingleDatabaseIntrospector.BaseNativeRetriever<CHouseRoot> createNativeRetriever(@NotNull DBTransaction transaction, @NotNull CHouseRoot database) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        return new CHouseNativeRetriever(transaction);
    }

    @NotNull
    protected CHouseSchemaRetriever createSchemaRetriever(@NotNull DBTransaction transaction, @NotNull CHouseSchema schema2) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)schema2, (String)"schema");
        return new CHouseSchemaRetriever(transaction, schema2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u0018\u0012\u0004\u0012\u00020\u00020\u0001R\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00040\u0003B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/database/dialects/clickhouse/introspector/CHouseIntrospector$CHouseDatabaseRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseSingleDatabaseIntrospector$BaseDatabaseRetriever;", "Lcom/intellij/database/dialects/clickhouse/model/CHouseRoot;", "Lcom/intellij/database/dialects/base/introspector/BaseSingleDatabaseIntrospector;", "Lcom/intellij/database/dialects/clickhouse/model/CHouseSchema;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "(Lcom/intellij/database/dialects/clickhouse/introspector/CHouseIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;)V", "process", "", "intellij.database.dialects.clickhouse"})
    private final class CHouseDatabaseRetriever
    extends BaseSingleDatabaseIntrospector.BaseDatabaseRetriever<CHouseRoot> {
        public CHouseDatabaseRetriever(DBTransaction transaction) {
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            super(CHouseIntrospector.this, transaction);
        }

        @Override
        public void process() {
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\b\u0082\u0004\u0018\u00002\u0018\u0012\u0004\u0012\u00020\u00020\u0001R\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00040\u0003B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J8\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0018\u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\u0010H\u0014\u00a8\u0006\u0013"}, d2={"Lcom/intellij/database/dialects/clickhouse/introspector/CHouseIntrospector$CHouseNativeRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseSingleDatabaseIntrospector$BaseNativeRetriever;", "Lcom/intellij/database/dialects/clickhouse/model/CHouseRoot;", "Lcom/intellij/database/dialects/base/introspector/BaseSingleDatabaseIntrospector;", "Lcom/intellij/database/dialects/clickhouse/model/CHouseSchema;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "(Lcom/intellij/database/dialects/clickhouse/introspector/CHouseIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;)V", "retrieveNativeDefinitionsFor", "", "kind", "Lcom/intellij/database/model/ObjectKind;", "elements", "", "Lcom/intellij/database/model/basic/BasicElement;", "result", "", "", "", "intellij.database.dialects.clickhouse"})
    private final class CHouseNativeRetriever
    extends BaseSingleDatabaseIntrospector.BaseNativeRetriever<CHouseRoot> {
        public CHouseNativeRetriever(DBTransaction transaction) {
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            super(CHouseIntrospector.this, transaction);
        }

        @Override
        protected void retrieveNativeDefinitionsFor(@NotNull ObjectKind kind, @NotNull Iterable<? extends BasicElement> elements2, @NotNull Map<BasicElement, String[]> result2) {
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            Intrinsics.checkNotNullParameter(elements2, (String)"elements");
            Intrinsics.checkNotNullParameter(result2, (String)"result");
            if (!(Intrinsics.areEqual((Object)kind, (Object)ObjectKind.TABLE) || Intrinsics.areEqual((Object)kind, (Object)ObjectKind.VIEW) || Intrinsics.areEqual((Object)kind, (Object)ObjectKind.MAT_VIEW))) {
                return;
            }
            for (BasicElement basicElement : elements2) {
                Map<BasicElement, String[]> map2 = result2;
                String[] stringArray = new String[1];
                DBTransaction dBTransaction = this.getTransaction();
                Intrinsics.checkNotNull((Object)basicElement, (String)"null cannot be cast to non-null type com.intellij.database.dialects.clickhouse.model.CHouseLikeTable");
                stringArray[0] = CHouseIntroQueries.INSTANCE.retrieveTableSource(dBTransaction, (CHouseLikeTable)basicElement);
                map2.put(basicElement, stringArray);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0084\u0004\u0018\u00002\u001e\u0012\u0004\u0012\u00020\u00020\u0001R\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\u0003B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\fH\u0002J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J$\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u00132\u000e\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u0015H\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0007\u001a\u00020\u0002H\u0002J\u0010\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u0007\u001a\u00020\u0002H\u0002J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\f2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u00020\u001b2\u0006\u0010\u0007\u001a\u00020\u0002H\u0002J\u0010\u0010\"\u001a\u00020\u001b2\u0006\u0010\u0007\u001a\u00020\u0002H\u0002J\u0010\u0010#\u001a\u00020\u001b2\u0006\u0010\u0007\u001a\u00020\u0002H\u0002\u00a8\u0006$"}, d2={"Lcom/intellij/database/dialects/clickhouse/introspector/CHouseIntrospector$CHouseSchemaRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractSchemaRetriever;", "Lcom/intellij/database/dialects/clickhouse/model/CHouseSchema;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector;", "Lcom/intellij/database/dialects/clickhouse/model/CHouseRoot;", "tran", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "schema", "(Lcom/intellij/database/dialects/clickhouse/introspector/CHouseIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/clickhouse/model/CHouseSchema;)V", "getColumnKind", "Lcom/intellij/database/model/properties/ColumnKind;", "extra", "", "getCreate", "Lcom/intellij/sql/psi/SqlCreateStatement;", "src", "isPossibleToIntrospectSchemaIncrementally", "", "matViewSearcher", "Lcom/intellij/database/model/ElementSearcherNN;", "Lcom/intellij/database/dialects/clickhouse/model/CHouseMatView;", "Lcom/intellij/database/dialects/clickhouse/introspector/CHouseIntroQueries$TableInfo;", "views", "Lcom/intellij/database/model/families/ModNamingFamily;", "patchMvEngineEntry", "t", "process", "", "retrieveColumns", "retrieveMatViewSources", "retrieveTableSource", "table", "Lcom/intellij/database/dialects/clickhouse/model/CHouseLikeTable;", "retrieveTableSources", "retrieveTables", "retrieveViewSources", "intellij.database.dialects.clickhouse"})
    @SourceDebugExtension(value={"SMAP\nCHouseIntrospector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CHouseIntrospector.kt\ncom/intellij/database/dialects/clickhouse/introspector/CHouseIntrospector$CHouseSchemaRetriever\n+ 2 BaseIntrospectionFunctions.kt\ncom/intellij/database/dialects/base/introspector/BaseIntrospectionFunctions\n+ 3 BaseNativeIntrospector.kt\ncom/intellij/database/dialects/base/introspector/BaseNativeIntrospector\n+ 4 ElementCache.kt\ncom/intellij/database/model/ElementChecker\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 IntrospectorSqlHelper.kt\ncom/intellij/database/dialects/base/introspector/IntrospectorSqlHelper\n+ 7 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,364:1\n198#2,7:365\n206#2,5:379\n239#2:385\n242#2:392\n243#2:400\n247#2:405\n619#3,2:372\n622#3,4:375\n619#3,7:393\n128#3,2:406\n131#3,8:409\n28#4:374\n28#4:384\n1855#5,2:386\n1855#5,2:388\n1855#5,2:390\n1855#5,2:401\n1855#5,2:403\n26#6:408\n1#7:417\n*S KotlinDebug\n*F\n+ 1 CHouseIntrospector.kt\ncom/intellij/database/dialects/clickhouse/introspector/CHouseIntrospector$CHouseSchemaRetriever\n*L\n185#1:365,7\n185#1:379,5\n260#1:385\n260#1:392\n260#1:400\n260#1:405\n186#1:372,2\n186#1:375,4\n265#1:393,7\n318#1:406,2\n318#1:409,8\n190#1:374\n243#1:384\n261#1:386,2\n262#1:388,2\n263#1:390,2\n262#1:401,2\n263#1:403,2\n318#1:408\n*E\n"})
    protected final class CHouseSchemaRetriever
    extends BaseNativeIntrospector.AbstractSchemaRetriever<CHouseSchema> {
        public CHouseSchemaRetriever(@NotNull DBTransaction tran, CHouseSchema schema2) {
            Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
            Intrinsics.checkNotNullParameter((Object)schema2, (String)"schema");
            super((BaseNativeIntrospector)CHouseIntrospector.this, tran, (BasicModSchema)schema2);
        }

        @Override
        public boolean isPossibleToIntrospectSchemaIncrementally(@NotNull DBTransaction tran, @NotNull CHouseSchema schema2) {
            Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
            Intrinsics.checkNotNullParameter((Object)schema2, (String)"schema");
            return false;
        }

        @Override
        public void process() {
            BaseNativeIntrospector baseNativeIntrospector = CHouseIntrospector.this;
            String string = ((CHouseSchema)this.getSchema()).getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            BaseNativeIntrospector.reportIntrospectingSchema$default(baseNativeIntrospector, string, this.getMode(), null, 4, null);
            this.prepareParameters();
            this.inSchema((Function1)new Function1<CHouseSchema, Unit>(this){
                final /* synthetic */ CHouseSchemaRetriever this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull CHouseSchema schema2) {
                    Intrinsics.checkNotNullParameter((Object)schema2, (String)"schema");
                    CHouseSchemaRetriever.access$retrieveTables(this.this$0, schema2);
                }
            });
            this.inSchema((Function1)new Function1<CHouseSchema, Unit>(this){
                final /* synthetic */ CHouseSchemaRetriever this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull CHouseSchema schema2) {
                    Intrinsics.checkNotNullParameter((Object)schema2, (String)"schema");
                    CHouseSchemaRetriever.access$retrieveColumns(this.this$0, schema2);
                }
            });
            this.inSchema((Function1)new Function1<CHouseSchema, Unit>(CHouseIntrospector.this, this){
                final /* synthetic */ CHouseIntrospector this$0;
                final /* synthetic */ CHouseSchemaRetriever this$1;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull CHouseSchema schema2) {
                    void this_$iv;
                    Intrinsics.checkNotNullParameter((Object)schema2, (String)"schema");
                    BaseNativeIntrospector baseNativeIntrospector = this.this$0;
                    CHouseSchemaRetriever cHouseSchemaRetriever = this.this$1;
                    boolean $i$f$writeSources = false;
                    this_$iv.getModel().writeSources(new Runnable(cHouseSchemaRetriever, schema2){
                        final /* synthetic */ CHouseSchemaRetriever this$0;
                        final /* synthetic */ CHouseSchema $schema$inlined;
                        {
                            this.this$0 = cHouseSchemaRetriever;
                            this.$schema$inlined = cHouseSchema;
                        }

                        public final void run() {
                            boolean bl = false;
                            CHouseSchemaRetriever.access$retrieveViewSources(this.this$0, this.$schema$inlined);
                            CHouseSchemaRetriever.access$retrieveMatViewSources(this.this$0, this.$schema$inlined);
                            CHouseSchemaRetriever.access$retrieveTableSources(this.this$0, this.$schema$inlined);
                        }
                    });
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveTables(CHouseSchema schema2) {
            void families$iv;
            CHouseIntrospector.this.reportRetrieving("tables and views", "introspection.retrieve.tablesViews");
            ModFamily[] modFamilyArray = new ModFamily[3];
            Intrinsics.checkNotNullExpressionValue(schema2.getTables(), (String)"getTables(...)");
            Intrinsics.checkNotNullExpressionValue(schema2.getViews(), (String)"getViews(...)");
            Intrinsics.checkNotNullExpressionValue(schema2.getMatViews(), (String)"getMatViews(...)");
            CHouseIntrospector cHouseIntrospector = CHouseIntrospector.this;
            boolean inc$iv = true;
            boolean $i$f$modifyFamiliesAndCleanup = false;
            for (void f$iv : families$iv) {
                f$iv.markChildrenAsSyncPending();
            }
            boolean bl = false;
            BaseNativeIntrospector this_$iv = cHouseIntrospector;
            boolean $i$f$continueOnDbError = false;
            try {
                void this_$iv2;
                boolean bl2 = false;
                ModNamingFamily<? extends CHouseMatView> modNamingFamily = schema2.getMatViews();
                Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getMatViews(...)");
                ElementSearcherNN<CHouseMatView, CHouseIntroQueries.TableInfo> matViews = this.matViewSearcher(modNamingFamily);
                ElementChecker elementChecker = ElementCacheOptimizersKt.byName(this.searchInSchema(), retrieveTables.1.1.tableSearcher.1.INSTANCE);
                boolean $i$f$prepare = false;
                void $this$retrieveTables_u24lambda_u242_u24lambda_u241_u24lambda_u240 = this_$iv2;
                boolean bl3 = false;
                ModNamingFamily<? extends CHouseTable> modNamingFamily2 = schema2.getTables();
                Intrinsics.checkNotNullExpressionValue(modNamingFamily2, (String)"getTables(...)");
                ElementSearcherNN<CHouseLikeTable, CHouseIntroQueries.TableInfo> tables2 = $this$retrieveTables_u24lambda_u242_u24lambda_u241_u24lambda_u240.inFamily((Family)modNamingFamily2).orCreate(retrieveTables.1.1.tableSearcher.2.tables.1.INSTANCE);
                ModNamingFamily<? extends CHouseView> modNamingFamily3 = schema2.getViews();
                Intrinsics.checkNotNullExpressionValue(modNamingFamily3, (String)"getViews(...)");
                ElementSearcherNN<CHouseLikeTable, CHouseIntroQueries.TableInfo> views2 = $this$retrieveTables_u24lambda_u242_u24lambda_u241_u24lambda_u240.inFamily((Family)modNamingFamily3).orCreate(retrieveTables.1.1.tableSearcher.2.views.1.INSTANCE);
                ElementSearcherNN<CHouseLikeTable, CHouseIntroQueries.TableInfo> tableSearcher2 = $this$retrieveTables_u24lambda_u242_u24lambda_u241_u24lambda_u240.chooseNN((Function1)new Function1<CHouseIntroQueries.TableInfo, ElementSearcherNN<CHouseLikeTable, CHouseIntroQueries.TableInfo>>(views2, matViews, tables2){
                    final /* synthetic */ ElementSearcherNN<CHouseLikeTable, CHouseIntroQueries.TableInfo> $views;
                    final /* synthetic */ ElementSearcherNN<CHouseMatView, CHouseIntroQueries.TableInfo> $matViews;
                    final /* synthetic */ ElementSearcherNN<CHouseLikeTable, CHouseIntroQueries.TableInfo> $tables;
                    {
                        this.$views = $views;
                        this.$matViews = $matViews;
                        this.$tables = $tables;
                        super(1);
                    }

                    @NotNull
                    public final ElementSearcherNN<CHouseLikeTable, CHouseIntroQueries.TableInfo> invoke(@NotNull CHouseIntroQueries.TableInfo $this$chooseNN) {
                        ElementSearcherNN<CHouseLikeTable, CHouseIntroQueries.TableInfo> elementSearcherNN;
                        Intrinsics.checkNotNullParameter((Object)$this$chooseNN, (String)"$this$chooseNN");
                        String string = $this$chooseNN.engine;
                        if (Intrinsics.areEqual((Object)string, (Object)"View")) {
                            elementSearcherNN = this.$views;
                        } else if (Intrinsics.areEqual((Object)string, (Object)"MaterializedView")) {
                            ElementSearcherNN<CHouseMatView, CHouseIntroQueries.TableInfo> elementSearcherNN2 = this.$matViews;
                            elementSearcherNN = elementSearcherNN2;
                            Intrinsics.checkNotNull(elementSearcherNN2, (String)"null cannot be cast to non-null type com.intellij.database.model.ElementSearcherNN<com.intellij.database.dialects.clickhouse.model.CHouseLikeTable, com.intellij.database.dialects.clickhouse.introspector.CHouseIntroQueries.TableInfo>");
                        } else {
                            elementSearcherNN = this.$tables;
                        }
                        return elementSearcherNN;
                    }
                });
                CHouseIntroQueries.INSTANCE.processTables(this.getTransaction(), schema2, (Function1<? super CHouseIntroQueries.TableInfo, Unit>)((Function1)new Function1<CHouseIntroQueries.TableInfo, Unit>(this, tableSearcher2, matViews){
                    final /* synthetic */ CHouseSchemaRetriever this$0;
                    final /* synthetic */ ElementSearcherNN<CHouseLikeTable, CHouseIntroQueries.TableInfo> $tableSearcher;
                    final /* synthetic */ ElementSearcherNN<CHouseMatView, CHouseIntroQueries.TableInfo> $matViews;
                    {
                        this.this$0 = $receiver;
                        this.$tableSearcher = $tableSearcher;
                        this.$matViews = $matViews;
                        super(1);
                    }

                    public final void invoke(@NotNull CHouseIntroQueries.TableInfo t) {
                        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                        if (!CHouseSchemaRetriever.access$patchMvEngineEntry(this.this$0, t)) {
                            CHouseLikeTable o2 = this.$tableSearcher.find(t);
                            o2.setName(t.name);
                            o2.setUuid(t.uuid);
                            o2.setTemporary(t.is_temporary);
                            o2.setComment(t.comment);
                            if (o2 instanceof CHouseTable) {
                                ((CHouseTable)o2).setEngine(t.engine);
                            }
                        } else {
                            CHouseMatView o3 = this.$matViews.find(t);
                            o3.setEngine(t.engine);
                        }
                    }
                }));
            }
            catch (DBException e$iv) {
                this_$iv.getErrorSink().consume(null, (Object)e$iv);
            }
            for (void f$iv : families$iv) {
                f$iv.removeSyncPendingChildren();
                f$iv.sort();
            }
        }

        private final boolean patchMvEngineEntry(CHouseIntroQueries.TableInfo t) {
            boolean bl;
            if (StringsKt.startsWith$default((String)t.name, (String)".inner_id.", (boolean)false, (int)2, null)) {
                t.comment = t.name;
                String string = t.name.substring(10);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                t.uuid = string;
                t.name = "";
                bl = true;
            } else if (StringsKt.startsWith$default((String)t.name, (String)".inner.", (boolean)false, (int)2, null)) {
                t.comment = t.name;
                String string = t.name.substring(7);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                t.name = string;
                t.uuid = "";
                bl = true;
            } else {
                bl = false;
            }
            return bl;
        }

        private final ElementSearcherNN<CHouseMatView, CHouseIntroQueries.TableInfo> matViewSearcher(ModNamingFamily<? extends CHouseMatView> views2) {
            ElementChecker this_$iv = this.searchInSchema();
            boolean $i$f$prepare = false;
            ElementChecker $this$matViewSearcher_u24lambda_u243 = this_$iv;
            boolean bl = false;
            FamilySearcher<CHouseMatView, CHouseIntroQueries.TableInfo> matViewsByName2 = ElementCacheOptimizersKt.byName($this$matViewSearcher_u24lambda_u243, matViewSearcher.1.matViewsByName.1.INSTANCE).inFamily((Family)views2);
            FamilySearcher<CHouseMatView, CHouseIntroQueries.TableInfo> matViewsByUuid2 = CHouseIntrospectorKt.access$byUuid($this$matViewSearcher_u24lambda_u243, matViewSearcher.1.matViewsByUuid.1.INSTANCE).inFamily((Family)views2);
            ElementSearcher<CHouseMatView, CHouseIntroQueries.TableInfo> matViewsByNameAndUuid = ElementCacheKt.or(matViewsByUuid2, matViewsByName2);
            return ElementCacheKt.orCreateElement($this$matViewSearcher_u24lambda_u243.choose((Function1)new Function1<CHouseIntroQueries.TableInfo, ElementSearcher<CHouseMatView, CHouseIntroQueries.TableInfo>>(matViewsByName2, matViewsByUuid2, matViewsByNameAndUuid){
                final /* synthetic */ FamilySearcher<CHouseMatView, CHouseIntroQueries.TableInfo> $matViewsByName;
                final /* synthetic */ FamilySearcher<CHouseMatView, CHouseIntroQueries.TableInfo> $matViewsByUuid;
                final /* synthetic */ ElementSearcher<CHouseMatView, CHouseIntroQueries.TableInfo> $matViewsByNameAndUuid;
                {
                    this.$matViewsByName = $matViewsByName;
                    this.$matViewsByUuid = $matViewsByUuid;
                    this.$matViewsByNameAndUuid = $matViewsByNameAndUuid;
                    super(1);
                }

                @Nullable
                public final ElementSearcher<CHouseMatView, CHouseIntroQueries.TableInfo> invoke(@NotNull CHouseIntroQueries.TableInfo $this$choose) {
                    Intrinsics.checkNotNullParameter((Object)$this$choose, (String)"$this$choose");
                    return ((CharSequence)$this$choose.uuid).length() == 0 ? (ElementSearcher)this.$matViewsByName : (((CharSequence)$this$choose.name).length() == 0 ? (ElementSearcher)this.$matViewsByUuid : this.$matViewsByNameAndUuid);
                }
            }), (Function1)new Function1<CHouseIntroQueries.TableInfo, CHouseMatView>(matViewsByName2){
                final /* synthetic */ FamilySearcher<CHouseMatView, CHouseIntroQueries.TableInfo> $matViewsByName;
                {
                    this.$matViewsByName = $matViewsByName;
                    super(1);
                }

                @NotNull
                public final CHouseMatView invoke(@NotNull CHouseIntroQueries.TableInfo it2) {
                    Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                    return this.$matViewsByName.create(it2, (Function2<CHouseMatView, CHouseIntroQueries.TableInfo, Unit>)((Function2)matViewSearcher.1.1.INSTANCE));
                }
            });
        }

        private final void retrieveColumns(CHouseSchema schema2) {
            boolean bl;
            boolean bl2;
            BasicModView v2;
            boolean bl3;
            CHouseTable t;
            ObjectKind objectKind = ObjectKind.COLUMN;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"COLUMN");
            CHouseIntrospector.this.reportRetrieving(objectKind);
            Ref.IntRef pos = new Ref.IntRef();
            pos.element = 1;
            Ref.ObjectRef tableName = new Ref.ObjectRef();
            tableName.element = "";
            CHouseIntrospector cHouseIntrospector = CHouseIntrospector.this;
            boolean $i$f$modifyFamiliesAndCleanup = false;
            Function1 it2 = CHouseSchemaRetriever$retrieveColumns$$inlined$modifyFamiliesAndCleanup$1.INSTANCE;
            boolean bl4 = false;
            ModNamingFamily<? extends CHouseTable> modNamingFamily = schema2.getTables();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getTables(...)");
            Iterable $this$forEach$iv = modNamingFamily;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                t = (CHouseTable)element$iv;
                bl3 = false;
                PositioningNamingFamily positioningNamingFamily = t.getColumns();
                Intrinsics.checkNotNullExpressionValue((Object)positioningNamingFamily, (String)"getColumns(...)");
                it2.invoke((Object)positioningNamingFamily);
            }
            ModNamingFamily<? extends CHouseView> modNamingFamily2 = schema2.getViews();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily2, (String)"getViews(...)");
            $this$forEach$iv = modNamingFamily2;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                v2 = (CHouseView)element$iv;
                bl2 = false;
                PositioningNamingFamily positioningNamingFamily = v2.getColumns();
                Intrinsics.checkNotNullExpressionValue((Object)positioningNamingFamily, (String)"getColumns(...)");
                it2.invoke((Object)positioningNamingFamily);
            }
            ModNamingFamily<? extends CHouseMatView> modNamingFamily3 = schema2.getMatViews();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily3, (String)"getMatViews(...)");
            $this$forEach$iv = modNamingFamily3;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                v2 = (CHouseMatView)element$iv;
                bl = false;
                PositioningNamingFamily positioningNamingFamily = v2.getColumns();
                Intrinsics.checkNotNullExpressionValue((Object)positioningNamingFamily, (String)"getColumns(...)");
                it2.invoke((Object)positioningNamingFamily);
            }
            boolean bl5 = false;
            BaseNativeIntrospector this_$iv = cHouseIntrospector;
            boolean $i$f$continueOnDbError = false;
            try {
                boolean bl6 = false;
                CHouseIntroQueries.INSTANCE.processColumns(this.getTransaction(), schema2, (Function1<? super CHouseIntroQueries.ColumnInfo, Unit>)((Function1)new Function1<CHouseIntroQueries.ColumnInfo, Unit>((Ref.ObjectRef<String>)tableName, pos, schema2, cHouseIntrospector, this){
                    final /* synthetic */ Ref.ObjectRef<String> $tableName;
                    final /* synthetic */ Ref.IntRef $pos;
                    final /* synthetic */ CHouseSchema $schema;
                    final /* synthetic */ CHouseIntrospector this$0;
                    final /* synthetic */ CHouseSchemaRetriever this$1;
                    {
                        this.$tableName = $tableName;
                        this.$pos = $pos;
                        this.$schema = $schema;
                        this.this$0 = $receiver;
                        this.this$1 = $receiver2;
                        super(1);
                    }

                    public final void invoke(@NotNull CHouseIntroQueries.ColumnInfo c2) {
                        CHouseLikeTable cHouseLikeTable;
                        Intrinsics.checkNotNullParameter((Object)c2, (String)"c");
                        if (Intrinsics.areEqual((Object)this.$tableName.element, (Object)c2.table)) {
                            ++this.$pos.element;
                            int cfr_ignored_0 = this.$pos.element;
                        } else {
                            this.$tableName.element = c2.table;
                            this.$pos.element = 1;
                        }
                        CHouseTable cHouseTable = (CHouseTable)this.$schema.getTables().get((String)this.$tableName.element);
                        if (cHouseTable != null) {
                            cHouseLikeTable = cHouseTable;
                        } else {
                            CHouseView cHouseView = (CHouseView)this.$schema.getViews().get((String)this.$tableName.element);
                            if (cHouseView != null) {
                                cHouseLikeTable = cHouseView;
                            } else {
                                CHouseMatView cHouseMatView = (CHouseMatView)this.$schema.getMatViews().get((String)this.$tableName.element);
                                if (cHouseMatView != null) {
                                    cHouseLikeTable = cHouseMatView;
                                } else {
                                    return;
                                }
                            }
                        }
                        CHouseLikeTable table = cHouseLikeTable;
                        CHouseLikeColumn column2 = (CHouseLikeColumn)table.getColumns().createOrGet(c2.name);
                        String nullable = "Nullable(";
                        String lowCard = "LowCardinality(";
                        boolean colNullable = StringsKt.startsWith$default((String)c2.type, (String)nullable, (boolean)false, (int)2, null);
                        if (colNullable) {
                            String string = c2.type.substring(nullable.length(), c2.type.length() - 1);
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                            c2.type = string;
                        } else if (StringsKt.startsWith$default((String)c2.type, (String)lowCard, (boolean)false, (int)2, null) && StringsKt.startsWith$default((String)c2.type, (String)nullable, (int)lowCard.length(), (boolean)false, (int)4, null)) {
                            colNullable = true;
                            String string = c2.type.substring(nullable.length() + lowCard.length(), c2.type.length() - 1);
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                            c2.type = lowCard + string;
                        }
                        column2.setPosition((short)this.$pos.element);
                        DasTypeSystemBase dasTypeSystemBase = DasTypeSystems.getTypeSystem(this.this$0.dbms);
                        DataType dataType = DataTypeFactory.of(c2.type);
                        Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"of(...)");
                        column2.setDasType(dasTypeSystemBase.createDasType(dataType));
                        column2.setNotNull(!colNullable);
                        column2.setComment(c2.comment);
                        if (column2 instanceof CHouseTableColumn) {
                            String string = c2.default_expression;
                            ((CHouseTableColumn)column2).setDefaultExpression(string != null ? StringKt.nullize$default((String)string, (boolean)false, (int)1, null) : null);
                            ((CHouseTableColumn)column2).setColumnKind(CHouseSchemaRetriever.access$getColumnKind(this.this$1, c2.default_kind));
                        }
                    }
                }));
            }
            catch (DBException e$iv) {
                this_$iv.getErrorSink().consume(null, (Object)e$iv);
            }
            it = CHouseSchemaRetriever$retrieveColumns$$inlined$modifyFamiliesAndCleanup$2.INSTANCE;
            $i$a$-modifyFamiliesAndCleanup-CHouseIntrospector$CHouseSchemaRetriever$retrieveColumns$1 = false;
            ModNamingFamily<? extends CHouseTable> modNamingFamily4 = schema2.getTables();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily4, (String)"getTables(...)");
            $this$forEach$iv = modNamingFamily4;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                t = (CHouseTable)element$iv;
                bl3 = false;
                PositioningNamingFamily positioningNamingFamily = t.getColumns();
                Intrinsics.checkNotNullExpressionValue((Object)positioningNamingFamily, (String)"getColumns(...)");
                it.invoke((Object)positioningNamingFamily);
            }
            ModNamingFamily<? extends CHouseView> modNamingFamily5 = schema2.getViews();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily5, (String)"getViews(...)");
            $this$forEach$iv = modNamingFamily5;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                v2 = (CHouseView)element$iv;
                bl2 = false;
                PositioningNamingFamily positioningNamingFamily = v2.getColumns();
                Intrinsics.checkNotNullExpressionValue((Object)positioningNamingFamily, (String)"getColumns(...)");
                it.invoke((Object)positioningNamingFamily);
            }
            ModNamingFamily<? extends CHouseMatView> modNamingFamily6 = schema2.getMatViews();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily6, (String)"getMatViews(...)");
            $this$forEach$iv = modNamingFamily6;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                v2 = (CHouseMatView)element$iv;
                bl = false;
                PositioningNamingFamily positioningNamingFamily = v2.getColumns();
                Intrinsics.checkNotNullExpressionValue((Object)positioningNamingFamily, (String)"getColumns(...)");
                it.invoke((Object)positioningNamingFamily);
            }
        }

        private final ColumnKind getColumnKind(String extra) {
            if (extra == null) {
                return ColumnKind.NORMAL;
            }
            if (StringsKt.contains$default((CharSequence)extra, (CharSequence)"ALIAS", (boolean)false, (int)2, null)) {
                return ColumnKind.GENERATED_VIRTUAL;
            }
            if (StringsKt.contains$default((CharSequence)extra, (CharSequence)"MATERIALIZED", (boolean)false, (int)2, null)) {
                return ColumnKind.GENERATED_STORED;
            }
            return ColumnKind.NORMAL;
        }

        private final String retrieveTableSource(CHouseLikeTable table) {
            try {
                return CHouseIntroQueries.INSTANCE.retrieveTableSource(this.getTransaction(), table);
            }
            catch (DBException e2) {
                CHouseIntrospector.this.getErrorSink().consume((Object)e2.getMessage(), (Object)e2);
                return null;
            }
        }

        private final SqlCreateStatement getCreate(String src2) {
            Object object;
            BaseNativeIntrospector this_$iv = CHouseIntrospector.this;
            boolean $i$f$parseStatement = false;
            try {
                IntrospectorSqlHelper this_$iv$iv = BaseNativeIntrospector.access$getSqlHelper(this_$iv);
                boolean $i$f$statements = false;
                object = this_$iv$iv.statements(src2, SqlCreateStatement.class).first();
            }
            catch (ProcessCanceledException pce$iv) {
                throw pce$iv;
            }
            catch (Exception e$iv) {
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    this_$iv.log.error((Throwable)e$iv);
                }
                this_$iv.log.warn("Failed to parse sources", (Throwable)e$iv);
                object = null;
            }
            SqlCreateStatement createStatement = (SqlCreateStatement)object;
            if (createStatement == null) {
                this.log.warn("No create found in\n" + src2);
                return null;
            }
            return createStatement;
        }

        private final void retrieveViewSources(CHouseSchema schema2) {
            CHouseIntrospector.this.reportRetrieving("view sources", "introspection.retrieve.view.sources");
            for (CHouseView cHouseView : schema2.getViews()) {
                Intrinsics.checkNotNull((Object)cHouseView);
                String string = this.retrieveTableSource(cHouseView);
                cHouseView.setSourceText(string != null ? BaseIntrospectionFunctions.toCompositeText(string, CompositeText.Kind.DECOMPILED_TEXT) : null);
            }
        }

        private final void retrieveMatViewSources(CHouseSchema schema2) {
            CHouseIntrospector.this.reportRetrieving("materialized view sources", "introspection.retrieve.matView.sources");
            for (CHouseMatView cHouseMatView : schema2.getMatViews()) {
                SqlCreateStatement stmt2;
                String src2;
                Intrinsics.checkNotNull((Object)cHouseMatView);
                String string = src2 = this.retrieveTableSource(cHouseMatView);
                cHouseMatView.setSourceText(string != null ? BaseIntrospectionFunctions.toCompositeText(string, CompositeText.Kind.DECOMPILED_TEXT) : null);
                if (src2 != null) {
                    String it2;
                    boolean bl = false;
                    v1 = this.getCreate(it2);
                } else {
                    v1 = stmt2 = null;
                }
                if (stmt2 == null) {
                    CHouseIntrospector.this.getErrorSink().consume((Object)("Failed to parse source of " + cHouseMatView.getName()), null);
                    continue;
                }
                CHouseIntrospector.this.getSqlHelper().getBuilder().build(cHouseMatView, (DasObject)stmt2, CHouseIntrospector.this.getSqlHelper().getBuilderContext());
            }
        }

        private final void retrieveTableSources(CHouseSchema schema2) {
            ObjectKind objectKind = ObjectKind.TABLE;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"TABLE");
            CHouseIntrospector.this.reportRetrieving(objectKind);
            for (CHouseTable cHouseTable : schema2.getTables()) {
                String string = cHouseTable.getEngine();
                boolean bl = string != null ? StringsKt.startsWith$default((String)string, (String)"System", (boolean)false, (int)2, null) : false;
                if (bl) {
                    cHouseTable.setEngineParams(null);
                    continue;
                }
                Intrinsics.checkNotNull((Object)cHouseTable);
                String string2 = this.retrieveTableSource(cHouseTable);
                if (string2 == null) continue;
                String it2 = string2;
                boolean bl2 = false;
                SqlCreateStatement sqlCreateStatement = this.getCreate(it2);
                string2 = sqlCreateStatement;
                if (sqlCreateStatement == null) {
                    continue;
                }
                String stmt2 = string2;
                CHouseIntrospector.this.getSqlHelper().getBuilder().build(cHouseTable, (DasObject)((Object)stmt2), CHouseIntrospector.this.getSqlHelper().getBuilderContext());
            }
        }

        public static final /* synthetic */ void access$retrieveTables(CHouseSchemaRetriever $this, CHouseSchema schema2) {
            $this.retrieveTables(schema2);
        }

        public static final /* synthetic */ void access$retrieveColumns(CHouseSchemaRetriever $this, CHouseSchema schema2) {
            $this.retrieveColumns(schema2);
        }

        public static final /* synthetic */ void access$retrieveViewSources(CHouseSchemaRetriever $this, CHouseSchema schema2) {
            $this.retrieveViewSources(schema2);
        }

        public static final /* synthetic */ void access$retrieveMatViewSources(CHouseSchemaRetriever $this, CHouseSchema schema2) {
            $this.retrieveMatViewSources(schema2);
        }

        public static final /* synthetic */ void access$retrieveTableSources(CHouseSchemaRetriever $this, CHouseSchema schema2) {
            $this.retrieveTableSources(schema2);
        }

        public static final /* synthetic */ boolean access$patchMvEngineEntry(CHouseSchemaRetriever $this, CHouseIntroQueries.TableInfo t) {
            return $this.patchMvEngineEntry(t);
        }

        public static final /* synthetic */ ColumnKind access$getColumnKind(CHouseSchemaRetriever $this, String extra) {
            return $this.getColumnKind(extra);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0016\u00a8\u0006\u0017"}, d2={"Lcom/intellij/database/dialects/clickhouse/introspector/CHouseIntrospector$Factory;", "Lcom/intellij/database/introspection/DBIntrospector$Factory;", "()V", "createIntrospector", "Lcom/intellij/database/introspection/DBIntrospector;", "context", "Lcom/intellij/database/introspection/DBIntrospectionContext;", "dbms", "Lcom/intellij/database/Dbms;", "modelFactory", "Lcom/intellij/database/model/ModelFactory;", "getVersion", "", "kind", "Lcom/intellij/database/model/ObjectKind;", "isOutdatedCheckSupported", "", "e", "Lcom/intellij/database/model/basic/BasicElement;", "isSupported", "version", "Lcom/intellij/database/util/Version;", "VERSION", "intellij.database.dialects.clickhouse"})
    public static final class Factory
    implements DBIntrospector.Factory {
        @Override
        public boolean isSupported(@NotNull Version version) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            return true;
        }

        @Override
        @NotNull
        public DBIntrospector createIntrospector(@NotNull DBIntrospectionContext context, @NotNull Dbms dbms, @NotNull ModelFactory modelFactory) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
            Intrinsics.checkNotNullParameter((Object)modelFactory, (String)"modelFactory");
            return new CHouseIntrospector(context, modelFactory);
        }

        @Override
        public int getVersion(@NotNull ObjectKind kind) {
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            return VERSION.INSTANCE.get(kind);
        }

        @Override
        public boolean isOutdatedCheckSupported(@Nullable BasicElement e2) {
            return false;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/database/dialects/clickhouse/introspector/CHouseIntrospector$Factory$VERSION;", "Lcom/intellij/database/model/PerObjectVersion;", "()V", "intellij.database.dialects.clickhouse"})
        public static final class VERSION
        extends PerObjectVersion {
            @NotNull
            public static final VERSION INSTANCE = new VERSION();

            private VERSION() {
            }
        }
    }
}

