/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.cassandra;

import com.intellij.database.Dbms;
import com.intellij.database.data.types.ColumnRef;
import com.intellij.database.data.types.ComparePredicateOperation;
import com.intellij.database.data.types.FormatTestResult;
import com.intellij.database.data.types.FormatTester;
import com.intellij.database.data.types.LikePredicateOperation;
import com.intellij.database.data.types.LogicalType;
import com.intellij.database.data.types.Placeholder;
import com.intellij.database.data.types.PredicateValue;
import com.intellij.database.data.types.PredicatesHelper;
import com.intellij.database.data.types.PredicatesUtilKt;
import com.intellij.database.data.types.StringPredicateValue;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.data.types.domain.LikeOpType;
import com.intellij.database.data.types.domain.OperationKt;
import com.intellij.database.dialects.base.BasePredicatesHelper;
import com.intellij.database.dialects.cassandra.CassPredicatesHelper;
import com.intellij.database.dialects.cassandra.model.CassIndex;
import com.intellij.database.dialects.cassandra.model.CassTable;
import com.intellij.database.dialects.cassandra.model.CassTableColumn;
import com.intellij.database.model.basic.BasicTableOrViewColumn;
import com.intellij.database.model.families.Family;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001(B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J>\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0014J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0014H\u0002J&\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0015\u001a\u00020\b2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0014J\u001e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002JP\u0010\"\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u000b\u001a\u00020#2\u0006\u0010$\u001a\u00020\u000e2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010%\u001a\u00020\u000eH\u0014J\u000e\u0010&\u001a\u0004\u0018\u00010'*\u00020\u001dH\u0002\u00a8\u0006)"}, d2={"Lcom/intellij/database/dialects/cassandra/CassPredicatesHelper;", "Lcom/intellij/database/dialects/base/BasePredicatesHelper;", "dbms", "Lcom/intellij/database/Dbms;", "(Lcom/intellij/database/Dbms;)V", "equalsPredicate", "Lcom/intellij/database/data/types/PredicatesHelper$PredicateProducer;", "column", "Lcom/intellij/database/data/types/ColumnRef;", "value", "Lcom/intellij/database/data/types/PredicateValue;", "op", "Lcom/intellij/database/data/types/ComparePredicateOperation;", "quote", "", "version", "Lcom/intellij/database/util/Version;", "alias", "", "getBestLikeOp", "Lcom/intellij/database/data/types/domain/LikeOpType;", "columnRef", "wantedLikeOp", "getFormatTester", "Lcom/intellij/database/data/types/FormatTester;", "domain", "Lcom/intellij/database/data/types/domain/Domain;", "getIndices", "", "Lcom/intellij/database/dialects/cassandra/model/CassIndex;", "c", "Lcom/intellij/database/dialects/cassandra/model/CassTableColumn;", "table", "Lcom/intellij/database/dialects/cassandra/model/CassTable;", "likePredicate", "Lcom/intellij/database/data/types/LikePredicateOperation;", "canCastToText", "inUpdate", "getMode", "Lcom/intellij/database/dialects/cassandra/CassPredicatesHelper$SASIIndexMode;", "SASIIndexMode", "intellij.database.dialects.cassandra"})
@SourceDebugExtension(value={"SMAP\nCassPredicatesHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CassPredicatesHelper.kt\ncom/intellij/database/dialects/cassandra/CassPredicatesHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,127:1\n766#2:128\n857#2,2:129\n*S KotlinDebug\n*F\n+ 1 CassPredicatesHelper.kt\ncom/intellij/database/dialects/cassandra/CassPredicatesHelper\n*L\n74#1:128\n74#1:129,2\n*E\n"})
public final class CassPredicatesHelper
extends BasePredicatesHelper {
    public CassPredicatesHelper(@NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        super(dbms);
    }

    @Override
    @Nullable
    protected PredicatesHelper.PredicateProducer equalsPredicate(@NotNull ColumnRef column2, @NotNull PredicateValue value2, @NotNull ComparePredicateOperation op, boolean quote, @Nullable Version version, @Nullable String alias) {
        Intrinsics.checkNotNullParameter((Object)column2, (String)"column");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Intrinsics.checkNotNullParameter((Object)op, (String)"op");
        return super.equalsPredicate(column2, value2, op, quote, version, null);
    }

    @Override
    @Nullable
    protected PredicatesHelper.PredicateProducer likePredicate(@NotNull ColumnRef columnRef, @NotNull PredicateValue value2, @Nullable Domain domain, @NotNull LikePredicateOperation op, boolean canCastToText, @Nullable String alias, @Nullable Version version, boolean inUpdate) {
        Intrinsics.checkNotNullParameter((Object)columnRef, (String)"columnRef");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Intrinsics.checkNotNullParameter((Object)op, (String)"op");
        if (!DbImplUtilCore.getDatabaseDialect(this.getDbms()).getLikeSupport(version).isSupported(inUpdate)) {
            return null;
        }
        if (!(value2 instanceof StringPredicateValue) && !(value2 instanceof Placeholder)) {
            return null;
        }
        Domain domain2 = domain;
        if (!(domain2 != null ? domain2.supports(OperationKt.LIKE_OPERATION) : false)) {
            return null;
        }
        LikeOpType likeOp = this.getBestLikeOp(columnRef, op.getLikeType());
        return new PredicatesHelper.PredicateProducer(CollectionsKt.listOf((Object)columnRef), value2, op, (Function1<? super DdlBuilder, Unit>)((Function1)new Function1<DdlBuilder, Unit>(columnRef, likeOp, value2, this){
            final /* synthetic */ ColumnRef $columnRef;
            final /* synthetic */ LikeOpType $likeOp;
            final /* synthetic */ PredicateValue $value;
            final /* synthetic */ CassPredicatesHelper this$0;
            {
                this.$columnRef = $columnRef;
                this.$likeOp = $likeOp;
                this.$value = $value;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull DdlBuilder builder) {
                Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
                PredicatesUtilKt.identifier(builder, null, this.$columnRef).space();
                if (this.$likeOp == LikeOpType.MATCHES) {
                    builder.symbol("=").space();
                } else {
                    builder.keyword("LIKE").space();
                }
                PredicatesUtilKt.value(builder, this.$value, this.$columnRef, this.this$0.getDbms(), this.$likeOp.getDecorator());
            }
        }));
    }

    private final LikeOpType getBestLikeOp(ColumnRef columnRef, LikeOpType wantedLikeOp) {
        BasicTableOrViewColumn dasColumn = PredicatesUtilKt.toBasicColumn(columnRef);
        if (dasColumn == null) {
            return LikeOpType.MATCHES;
        }
        CassTableColumn cassTableColumn = dasColumn instanceof CassTableColumn ? (CassTableColumn)dasColumn : null;
        if (cassTableColumn == null) {
            return LikeOpType.MATCHES;
        }
        CassTableColumn column2 = cassTableColumn;
        CassTable cassTable = column2.getTable();
        if (cassTable == null) {
            return LikeOpType.MATCHES;
        }
        CassTable t = cassTable;
        Collection<CassIndex> indices = this.getIndices(column2, t);
        Object bestOp = LikeOpType.MATCHES;
        for (CassIndex index2 : indices) {
            Object currentBestOp;
            Object object = this.getMode(index2);
            if (object == null || (object = object.getBestOp()) == null || (object = (LikeOpType)((Object)object.get((Object)wantedLikeOp))) == null) {
                object = LikeOpType.MATCHES;
            }
            if ((currentBestOp = object) == wantedLikeOp) {
                return wantedLikeOp;
            }
            if (((Enum)currentBestOp).compareTo((Enum)bestOp) >= 0) continue;
            bestOp = currentBestOp;
        }
        return bestOp;
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<CassIndex> getIndices(CassTableColumn c2, CassTable table) {
        void $this$filterTo$iv$iv;
        Family family = table.getIndices();
        Intrinsics.checkNotNullExpressionValue((Object)family, (String)"getIndices(...)");
        Iterable $this$filter$iv = family;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            CassIndex index2 = (CassIndex)element$iv$iv;
            boolean bl = false;
            if (!(index2.getColumns().size() == 1 && Intrinsics.areEqual((Object)c2.getName(), (Object)index2.getColumns().get(0).getName()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final SASIIndexMode getMode(CassIndex $this$getMode) {
        if (!Intrinsics.areEqual((Object)$this$getMode.getClassName(), (Object)"org.apache.cassandra.index.sasi.SASIIndex")) {
            return null;
        }
        String string = $this$getMode.getOptions();
        if (string == null) {
            return SASIIndexMode.PREFIX;
        }
        String options2 = string;
        return StringUtil.containsIgnoreCase((String)options2, (String)"'mode': 'contains'") ? SASIIndexMode.CONTAINS : (StringUtil.containsIgnoreCase((String)options2, (String)"'mode': 'sparse'") ? SASIIndexMode.SPARSE : SASIIndexMode.PREFIX);
    }

    @Override
    @Nullable
    protected FormatTester getFormatTester(@NotNull ColumnRef columnRef, @Nullable Domain domain, @Nullable Version version) {
        Intrinsics.checkNotNullParameter((Object)columnRef, (String)"columnRef");
        Domain domain2 = domain;
        if (domain2 == null || (domain2 = domain2.getLogicType()) == null) {
            return null;
        }
        Domain type = domain2;
        return type == LogicalType.UUID || type == LogicalType.TEXT_UUID ? new FormatTester(false, false, (Function1<? super String, ? extends FormatTestResult>)((Function1)getFormatTester.1.INSTANCE)) : super.getFormatTester(columnRef, domain, version);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u001b\b\u0002\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/database/dialects/cassandra/CassPredicatesHelper$SASIIndexMode;", "", "bestOp", "", "Lcom/intellij/database/data/types/domain/LikeOpType;", "(Ljava/lang/String;ILjava/util/Map;)V", "getBestOp", "()Ljava/util/Map;", "PREFIX", "CONTAINS", "SPARSE", "intellij.database.dialects.cassandra"})
    private static final class SASIIndexMode
    extends Enum<SASIIndexMode> {
        @NotNull
        private final Map<LikeOpType, LikeOpType> bestOp;
        public static final /* enum */ SASIIndexMode PREFIX;
        public static final /* enum */ SASIIndexMode CONTAINS;
        public static final /* enum */ SASIIndexMode SPARSE;
        private static final /* synthetic */ SASIIndexMode[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private SASIIndexMode(Map<LikeOpType, ? extends LikeOpType> bestOp) {
            this.bestOp = bestOp;
        }

        @NotNull
        public final Map<LikeOpType, LikeOpType> getBestOp() {
            return this.bestOp;
        }

        public static SASIIndexMode[] values() {
            return (SASIIndexMode[])$VALUES.clone();
        }

        public static SASIIndexMode valueOf(String value2) {
            return Enum.valueOf(SASIIndexMode.class, value2);
        }

        @NotNull
        public static EnumEntries<SASIIndexMode> getEntries() {
            return $ENTRIES;
        }

        static {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)((Object)LikeOpType.CONTAINS), (Object)((Object)LikeOpType.STARTS_WITH)), TuplesKt.to((Object)((Object)LikeOpType.STARTS_WITH), (Object)((Object)LikeOpType.STARTS_WITH)), TuplesKt.to((Object)((Object)LikeOpType.ENDS_WITH), (Object)((Object)LikeOpType.MATCHES)), TuplesKt.to((Object)((Object)LikeOpType.MATCHES), (Object)((Object)LikeOpType.MATCHES)), TuplesKt.to((Object)((Object)LikeOpType.CUSTOM_LIKE_PATTERN), (Object)((Object)LikeOpType.MATCHES))};
            PREFIX = new SASIIndexMode(MapsKt.mapOf((Pair[])pairArray));
            pairArray = new Pair[]{TuplesKt.to((Object)((Object)LikeOpType.CONTAINS), (Object)((Object)LikeOpType.CONTAINS)), TuplesKt.to((Object)((Object)LikeOpType.STARTS_WITH), (Object)((Object)LikeOpType.CONTAINS)), TuplesKt.to((Object)((Object)LikeOpType.ENDS_WITH), (Object)((Object)LikeOpType.ENDS_WITH)), TuplesKt.to((Object)((Object)LikeOpType.MATCHES), (Object)((Object)LikeOpType.MATCHES)), TuplesKt.to((Object)((Object)LikeOpType.CUSTOM_LIKE_PATTERN), (Object)((Object)LikeOpType.MATCHES))};
            CONTAINS = new SASIIndexMode(MapsKt.mapOf((Pair[])pairArray));
            pairArray = new Pair[]{TuplesKt.to((Object)((Object)LikeOpType.CONTAINS), (Object)((Object)LikeOpType.MATCHES)), TuplesKt.to((Object)((Object)LikeOpType.STARTS_WITH), (Object)((Object)LikeOpType.MATCHES)), TuplesKt.to((Object)((Object)LikeOpType.ENDS_WITH), (Object)((Object)LikeOpType.MATCHES)), TuplesKt.to((Object)((Object)LikeOpType.MATCHES), (Object)((Object)LikeOpType.MATCHES)), TuplesKt.to((Object)((Object)LikeOpType.CUSTOM_LIKE_PATTERN), (Object)((Object)LikeOpType.MATCHES))};
            SPARSE = new SASIIndexMode(MapsKt.mapOf((Pair[])pairArray));
            $VALUES = sASIIndexModeArray = new SASIIndexMode[]{SASIIndexMode.PREFIX, SASIIndexMode.CONTAINS, SASIIndexMode.SPARSE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

