/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.bigquery;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.dialects.bigquery.BQArrayNode;
import com.intellij.database.dialects.bigquery.BQPrimitiveNode;
import com.intellij.database.dialects.bigquery.BQStructNode;
import com.intellij.database.dialects.bigquery.BQTypeNode;
import com.intellij.database.dialects.bigquery.BigQueryGridColumnsManager;
import com.intellij.database.dialects.bigquery.BigQueryGridColumnsManagerKt;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.impl.PsiBuilderImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.bigquery.BigQueryParser;
import com.intellij.sql.dialects.bigquery.BigQueryParserDefinition;
import com.intellij.sql.dialects.bigquery.BigQueryTypes;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.util.containers.FilteredTraverserBase;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u0004\u001a$\u0010\u0007\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0004\u0012\u00020\n0\t0\b2\u0006\u0010\u000b\u001a\u00020\nH\u0002\u001a\u001e\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u001a$\u0010\u0013\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0004\u0012\u00020\n0\t0\u00142\u0006\u0010\u000b\u001a\u00020\nH\u0002\u001a1\u0010\u0015\u001a\u0004\u0018\u0001H\u0016\"\b\b\u0000\u0010\u0016*\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00160\u00192\b\u0010\u000b\u001a\u0004\u0018\u0001H\u0016H\u0002\u00a2\u0006\u0002\u0010\u001a\u001a\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0004H\u0002\u001a9\u0010\u001e\u001a\u0004\u0018\u00010\n\"\b\b\u0000\u0010\u0016*\u00020\u00172\b\u0010\u000b\u001a\u0004\u0018\u0001H\u00162\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00160\u00192\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0002\u0010\u001f\u001a\u001f\u0010\u001e\u001a\u0004\u0018\u00010\n2\u0006\u0010 \u001a\u00020!2\u000b\u0010\u001d\u001a\u00070\u0004\u00a2\u0006\u0002\b\"H\u0002\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "appendName", "", "qualifiedName", "name", "columnDefinitionsTraverser", "Lcom/intellij/util/containers/JBTreeTraverser;", "Lkotlin/Pair;", "Lcom/intellij/database/dialects/bigquery/BQTypeNode;", "node", "ensureRowExists", "", "newRows", "", "Lcom/intellij/database/datagrid/GridRow;", "row", "", "findColumnDefinitions", "", "findTypeNode", "T", "", "api", "Lcom/intellij/psi/SyntaxTraverser$Api;", "(Lcom/intellij/psi/SyntaxTraverser$Api;Ljava/lang/Object;)Ljava/lang/Object;", "isStructType", "", "typeName", "parseTypeStructure", "(Ljava/lang/Object;Lcom/intellij/psi/SyntaxTraverser$Api;Ljava/lang/String;)Lcom/intellij/database/dialects/bigquery/BQTypeNode;", "project", "Lcom/intellij/openapi/project/Project;", "Lcom/intellij/openapi/util/NlsSafe;", "intellij.database.dialects.bigquery.ex"})
@SourceDebugExtension(value={"SMAP\nBigQueryGridColumnsManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BigQueryGridColumnsManager.kt\ncom/intellij/database/dialects/bigquery/BigQueryGridColumnsManagerKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,226:1\n1603#2,9:227\n1855#2:236\n288#2,2:237\n1856#2:241\n1612#2:242\n1747#2,3:243\n1549#2:246\n1620#2,3:247\n1360#2:250\n1446#2,5:251\n1#3:239\n1#3:240\n*S KotlinDebug\n*F\n+ 1 BigQueryGridColumnsManager.kt\ncom/intellij/database/dialects/bigquery/BigQueryGridColumnsManagerKt\n*L\n106#1:227,9\n106#1:236\n107#1:237,2\n106#1:241\n106#1:242\n122#1:243,3\n223#1:246\n223#1:247,3\n224#1:250\n224#1:251,5\n106#1:240\n*E\n"})
public final class BigQueryGridColumnsManagerKt {
    @NotNull
    private static final Logger LOG;

    private static final BQTypeNode parseTypeStructure(Project project, String typeName) {
        BigQueryParserDefinition parserDefinition = new BigQueryParserDefinition();
        PsiBuilderImpl builder = new PsiBuilderImpl(project, null, (ParserDefinition)parserDefinition, parserDefinition.createLexer(project), null, (CharSequence)typeName, null, null);
        new BigQueryParser().parse((IElementType)SqlCompositeElementTypes.SQL_TYPE_ELEMENT, (PsiBuilder)builder);
        SyntaxTraverser syntaxTraverser = SyntaxTraverser.lightTraverser((PsiBuilder)((PsiBuilder)builder));
        Intrinsics.checkNotNullExpressionValue((Object)syntaxTraverser, (String)"lightTraverser(...)");
        SyntaxTraverser traverser2 = syntaxTraverser;
        Object object = traverser2.getRoot();
        SyntaxTraverser.Api api = traverser2.api;
        Intrinsics.checkNotNullExpressionValue((Object)api, (String)"api");
        return BigQueryGridColumnsManagerKt.parseTypeStructure(object, api, "");
    }

    /*
     * WARNING - void declaration
     */
    private static final <T> BQTypeNode parseTypeStructure(T node2, SyntaxTraverser.Api<T> api, String qualifiedName) {
        BQTypeNode bQTypeNode;
        if (node2 == null) {
            return null;
        }
        IElementType iElementType = api.typeOf(node2);
        if (Intrinsics.areEqual((Object)iElementType, (Object)BigQueryTypes.BQ_STRUCT_TYPE_ELEMENT)) {
            void $this$mapNotNullTo$iv$iv;
            Iterable columDefs2;
            Iterable iterable;
            Object listNode2;
            Object object = listNode2 = api.children(node2).find(arg_0 -> BigQueryGridColumnsManagerKt.parseTypeStructure$lambda$0((Function1)new Function1<T, Boolean>(api){
                final /* synthetic */ SyntaxTraverser.Api<T> $api;
                {
                    this.$api = $api;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(T it2) {
                    return Intrinsics.areEqual((Object)this.$api.typeOf(it2), (Object)SqlCompositeElementTypes.SQL_TYPED_COLUMN_ALIAS_LIST);
                }
            }, arg_0));
            if (object == null) {
                iterable = CollectionsKt.emptyList();
            } else {
                JBIterable jBIterable = api.children(object).filter(arg_0 -> BigQueryGridColumnsManagerKt.parseTypeStructure$lambda$1((Function1)new Function1<T, Boolean>(api){
                    final /* synthetic */ SyntaxTraverser.Api<T> $api;
                    {
                        this.$api = $api;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(T it2) {
                        return Intrinsics.areEqual((Object)this.$api.typeOf(it2), (Object)((Object)SqlCompositeElementTypes.SQL_COLUMN_ALIAS_DEFINITION));
                    }
                }, arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
                iterable = (Iterable)jBIterable;
            }
            Iterable $this$mapNotNull$iv = columDefs2 = iterable;
            boolean $i$f$mapNotNull = false;
            Iterable iterable2 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Pair it$iv$iv;
                String string;
                Object identifierNode;
                Object columnDef;
                block23: {
                    Object v4;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    columnDef = element$iv$iv;
                    boolean bl2 = false;
                    JBIterable jBIterable = api.children(columnDef);
                    Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"children(...)");
                    Iterable $this$firstOrNull$iv = (Iterable)jBIterable;
                    boolean $i$f$firstOrNull = false;
                    Iterator iterator2 = $this$firstOrNull$iv.iterator();
                    while (iterator2.hasNext()) {
                        Object element$iv;
                        Object it2 = element$iv = iterator2.next();
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)api.typeOf(it2), (Object)SqlCompositeElementTypes.SQL_IDENTIFIER)) continue;
                        v4 = element$iv;
                        break block23;
                    }
                    v4 = identifierNode = null;
                }
                if (identifierNode != null) {
                    boolean bl = false;
                    string = ((Object)api.textOf(identifierNode)).toString();
                } else {
                    string = null;
                }
                String name2 = string;
                T typeNode = BigQueryGridColumnsManagerKt.findTypeNode(api, columnDef);
                BQTypeNode type = BigQueryGridColumnsManagerKt.parseTypeStructure(typeNode, api, BigQueryGridColumnsManagerKt.appendName(qualifiedName, name2));
                if ((type == null ? null : new Pair((Object)name2, (Object)type)) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List children2 = (List)destination$iv$iv;
            bQTypeNode = new BQStructNode(qualifiedName, children2);
        } else if ((Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.SQL_TYPE_ELEMENT) ? true : Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.SQL_BUILTIN_TYPE_ELEMENT)) ? true : Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.SQL_ARRAY_TYPE_ELEMENT)) {
            IElementType nestedType;
            Object object = api.children(node2).single();
            if (object != null) {
                Object it3 = object;
                boolean bl = false;
                v8 = api.typeOf(it3);
            } else {
                v8 = nestedType = null;
            }
            if (Intrinsics.areEqual((Object)nestedType, (Object)SqlCompositeElementTypes.SQL_ARRAY_TYPE_ELEMENT) || Intrinsics.areEqual((Object)nestedType, (Object)BigQueryTypes.BQ_STRUCT_TYPE_ELEMENT)) {
                Object first2 = api.children(node2).first();
                bQTypeNode = BigQueryGridColumnsManagerKt.parseTypeStructure(first2, api, qualifiedName);
            } else {
                boolean bl;
                block24: {
                    JBIterable jBIterable = api.children(node2);
                    Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"children(...)");
                    Iterable $this$any$iv = (Iterable)jBIterable;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        Iterator iterator = $this$any$iv.iterator();
                        while (iterator.hasNext()) {
                            Object element$iv;
                            Object it4 = element$iv = iterator.next();
                            boolean bl4 = false;
                            if (!Intrinsics.areEqual((Object)api.typeOf(it4), (Object)SqlCommonKeywords.SQL_ARRAY)) continue;
                            bl = true;
                            break block24;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    BQArrayNode bQArrayNode;
                    T typeNode = BigQueryGridColumnsManagerKt.findTypeNode(api, node2);
                    if (typeNode != null) {
                        BQTypeNode bQTypeNode2 = BigQueryGridColumnsManagerKt.parseTypeStructure(typeNode, api, qualifiedName);
                        if (bQTypeNode2 == null) {
                            bQTypeNode2 = new BQPrimitiveNode("");
                        }
                        bQArrayNode = new BQArrayNode(bQTypeNode2);
                    } else {
                        bQArrayNode = new BQArrayNode(new BQPrimitiveNode(""));
                    }
                    bQTypeNode = bQArrayNode;
                } else {
                    bQTypeNode = new BQPrimitiveNode(((Object)api.textOf(node2)).toString());
                }
            }
        } else {
            bQTypeNode = null;
        }
        return bQTypeNode;
    }

    @NotNull
    public static final String appendName(@NotNull String qualifiedName, @Nullable String name2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)qualifiedName, (String)"qualifiedName");
        if (StringsKt.isBlank((CharSequence)qualifiedName)) {
            object = name2;
            if (object == null) {
                object = "";
            }
        } else {
            CharSequence charSequence = name2;
            object = charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? qualifiedName : qualifiedName + "." + name2;
        }
        return object;
    }

    private static final boolean isStructType(String typeName) {
        return StringUtil.startsWithIgnoreCase((String)typeName, (String)"struct<") || StringUtil.startsWithIgnoreCase((String)typeName, (String)"array");
    }

    private static final <T> T findTypeNode(SyntaxTraverser.Api<T> api, T node2) {
        return (T)(node2 == null ? null : api.children(node2).find(arg_0 -> BigQueryGridColumnsManagerKt.findTypeNode$lambda$7((Function1)new Function1<T, Boolean>(api){
            final /* synthetic */ SyntaxTraverser.Api<T> $api;
            {
                this.$api = $api;
                super(1);
            }

            @NotNull
            public final Boolean invoke(T it2) {
                return Intrinsics.areEqual((Object)this.$api.typeOf(it2), (Object)BigQueryTypes.BQ_STRUCT_TYPE_ELEMENT) || Intrinsics.areEqual((Object)this.$api.typeOf(it2), (Object)SqlCompositeElementTypes.SQL_TYPE_ELEMENT) || Intrinsics.areEqual((Object)this.$api.typeOf(it2), (Object)SqlCompositeElementTypes.SQL_BUILTIN_TYPE_ELEMENT) || Intrinsics.areEqual((Object)this.$api.typeOf(it2), (Object)SqlCompositeElementTypes.SQL_ARRAY_TYPE_ELEMENT);
            }
        }, arg_0)));
    }

    private static final void ensureRowExists(List<GridRow> newRows, int row) {
        if (row < newRows.size()) {
            return;
        }
        int realIdx = GridRow.toRealIdx((GridRow)newRows.get(0));
        int rowSize = newRows.get(0).getSize();
        while (newRows.size() <= row) {
            int n = 0;
            Object[] objectArray = new Object[rowSize];
            while (n < rowSize) {
                int n3 = n++;
                objectArray[n3] = ReservedCellValue.UNSET;
            }
            Object[] d2 = objectArray;
            DataConsumer.Row row2 = DataConsumer.Row.create((int)realIdx, (Object[])d2);
            Intrinsics.checkNotNullExpressionValue((Object)row2, (String)"create(...)");
            newRows.add((GridRow)row2);
        }
    }

    private static final JBTreeTraverser<Pair<String, BQTypeNode>> columnDefinitionsTraverser(BQTypeNode node2) {
        Iterable roots2 = BigQueryGridColumnsManagerKt.findColumnDefinitions(node2);
        FilteredTraverserBase filteredTraverserBase = JBTreeTraverser.from(arg_0 -> BigQueryGridColumnsManagerKt.columnDefinitionsTraverser$lambda$8(columnDefinitionsTraverser.1.INSTANCE, arg_0)).withRoots(CollectionsKt.firstOrNull(roots2) == null ? (Iterable)CollectionsKt.listOf((Object)new Pair(null, (Object)node2)) : roots2);
        Intrinsics.checkNotNullExpressionValue((Object)filteredTraverserBase, (String)"withRoots(...)");
        return (JBTreeTraverser)filteredTraverserBase;
    }

    /*
     * WARNING - void declaration
     */
    private static final Iterable<Pair<String, BQTypeNode>> findColumnDefinitions(BQTypeNode node2) {
        void $this$flatMapTo$iv$iv;
        if (node2 instanceof BQStructNode) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = ((BQStructNode)node2).getChildren();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Pair pair = (Pair)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                String name2 = (String)pair.component1();
                BQTypeNode type = (BQTypeNode)pair.component2();
                collection2.add(new Pair((Object)BigQueryGridColumnsManagerKt.appendName(((BQStructNode)node2).getQualifiedName(), name2), (Object)type));
            }
            return (List)destination$iv$iv;
        }
        Iterable $this$flatMap$iv = node2.children();
        boolean $i$f$flatMap = false;
        Iterable $this$mapTo$iv$iv = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            BQTypeNode it2 = (BQTypeNode)element$iv$iv;
            boolean bl = false;
            Iterable<Pair<String, BQTypeNode>> list$iv$iv = BigQueryGridColumnsManagerKt.findColumnDefinitions(it2);
            CollectionsKt.addAll((Collection)destination$iv$iv, list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final boolean parseTypeStructure$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean parseTypeStructure$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean findTypeNode$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Iterable columnDefinitionsTraverser$lambda$8(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Iterable)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ boolean access$isStructType(String typeName) {
        return BigQueryGridColumnsManagerKt.isStructType(typeName);
    }

    public static final /* synthetic */ BQTypeNode access$parseTypeStructure(Project project, String typeName) {
        return BigQueryGridColumnsManagerKt.parseTypeStructure(project, typeName);
    }

    public static final /* synthetic */ JBTreeTraverser access$columnDefinitionsTraverser(BQTypeNode node2) {
        return BigQueryGridColumnsManagerKt.columnDefinitionsTraverser(node2);
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    public static final /* synthetic */ void access$ensureRowExists(List newRows, int row) {
        BigQueryGridColumnsManagerKt.ensureRowExists(newRows, row);
    }

    public static final /* synthetic */ Iterable access$findColumnDefinitions(BQTypeNode node2) {
        return BigQueryGridColumnsManagerKt.findColumnDefinitions(node2);
    }

    static {
        Logger logger2 = Logger.getInstance(BigQueryGridColumnsManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        LOG = logger2;
    }
}

