/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base.types;

import com.intellij.database.Dbms;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasSynonym;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DasUserDefinedType;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.psi.DbCustomType;
import com.intellij.database.psi.DbElement;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeSystemBase;
import com.intellij.database.types.DasUnresolvedTypeReference;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.dialects.BuiltinFunction;
import com.intellij.sql.dialects.ReservedEntity;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlCreateTypeStatement;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlDmlInstruction;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlExpressionList;
import com.intellij.sql.psi.SqlFromClause;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlParenthesizedExpression;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReference;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlReturningClause;
import com.intellij.sql.psi.SqlSelectClause;
import com.intellij.sql.psi.SqlSelectIntoClause;
import com.intellij.sql.psi.SqlTableExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlTypedDefinition;
import com.intellij.sql.psi.impl.SqlColumnSymbol;
import com.intellij.sql.psi.impl.SqlFileImpl;
import com.intellij.sql.psi.impl.SqlFunctionCallExpressionImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlScopeProcessorBase;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0010H\u0014J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0010H\u0002J&\u0010\u0015\u001a\u00020\u00132\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\"\u0010\u001a\u001a\u00020\u00132\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0014\u001a\u00020\u0010H\u0002J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0010H\u0016J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0014R\u001b\u0010\u0005\u001a\u00020\u00068FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\b\u00a8\u0006$"}, d2={"Lcom/intellij/database/dialects/base/types/DasTypeSystemImpl;", "Lcom/intellij/database/types/DasTypeSystemBase;", "dbms", "Lcom/intellij/database/Dbms;", "(Lcom/intellij/database/Dbms;)V", "sqlDialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "getSqlDialect", "()Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "sqlDialect$delegate", "Lkotlin/Lazy;", "createTableType", "Lcom/intellij/sql/psi/SqlTableType;", "target", "Lcom/intellij/database/model/DasTable;", "resolved", "Lcom/intellij/psi/PsiElement;", "refElement", "getAsteriskType", "Lcom/intellij/database/types/DasType;", "element", "getDasType", "ref", "Lcom/intellij/sql/psi/SqlReference;", "symbol", "Lcom/intellij/database/symbols/DasSymbol;", "getReservedEntityType", "name", "", "kind", "Lcom/intellij/database/model/ObjectKind;", "getUnqualifiedAsteriskType", "supportsAsteriskArgument", "", "definition", "Lcom/intellij/sql/dialects/BuiltinFunction;", "intellij.database.dialects.base"})
public class DasTypeSystemImpl
extends DasTypeSystemBase {
    @NotNull
    private final Lazy sqlDialect$delegate;

    public DasTypeSystemImpl(@NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        super(dbms);
        this.sqlDialect$delegate = LazyKt.lazy((Function0)((Function0)new Function0<SqlLanguageDialectEx>(dbms){
            final /* synthetic */ Dbms $dbms;
            {
                this.$dbms = $dbms;
                super(0);
            }

            @NotNull
            public final SqlLanguageDialectEx invoke() {
                SqlLanguageDialect sqlLanguageDialect = DbSqlUtilCore.getSqlDialect(this.$dbms);
                Intrinsics.checkNotNull((Object)sqlLanguageDialect, (String)"null cannot be cast to non-null type com.intellij.sql.dialects.SqlLanguageDialectEx");
                return (SqlLanguageDialectEx)sqlLanguageDialect;
            }
        }));
    }

    @NotNull
    public final SqlLanguageDialectEx getSqlDialect() {
        Lazy lazy = this.sqlDialect$delegate;
        return (SqlLanguageDialectEx)lazy.getValue();
    }

    @Override
    @NotNull
    public DasType getDasType(@Nullable SqlReference ref2, @Nullable PsiElement resolved, @Nullable DasSymbol symbol) {
        SqlSelectClause clause;
        PsiElement parent2;
        Object kind;
        DasType typeFromDb;
        Object target2;
        DasObject dasObject;
        if (ref2 == null && resolved == null) {
            return DasTypeSystemBase.UNKNOWN;
        }
        SqlReference sqlReference = ref2;
        PsiElement refElement = sqlReference != null ? sqlReference.getElement() : null;
        DasSymbol dasSymbol = symbol;
        DasObject dasObject2 = dasObject = dasSymbol != null ? dasSymbol.getDasObject() : null;
        if (dasObject instanceof ReservedEntity.Typed) {
            DasType dasType = ((ReservedEntity.Typed)dasObject).type;
            if (dasType == null) {
                dasType = DasTypeSystemBase.UNKNOWN;
            }
            return dasType;
        }
        Object object = target2 = dasObject != null && !(dasObject instanceof ReservedEntity) ? dasObject : resolved;
        if (target2 instanceof DasSynonym) {
            target2 = DasUtil.resolveFinalTarget((DasSynonym)target2);
        }
        if (target2 instanceof DbElement && (typeFromDb = DbImplUtilCore.getDatabaseDialect((DbElement)target2).getDasType(refElement, (DbElement)target2)) != null) {
            return typeFromDb;
        }
        Object object2 = ref2;
        if (object2 == null || (object2 = object2.getReferenceElementType()) == null || (object2 = object2.getTargetKind()) == null) {
            object2 = kind = ObjectKind.NONE;
        }
        if (target2 == refElement) {
            PsiElement psiElement = refElement;
            Intrinsics.checkNotNull((Object)psiElement);
            if (SqlImplUtil.isAsteriskRef(psiElement)) {
                return this.getAsteriskType(refElement);
            }
        }
        if (kind == ObjectKind.SEQUENCE || target2 instanceof DasObject && ((DasObject)target2).getKind() == ObjectKind.SEQUENCE) {
            DasTypeSystemBase dasTypeSystemBase = this.getSqlDialect().getTypeSystem();
            PsiElement psiElement = refElement;
            if (psiElement == null) {
                psiElement = resolved;
            }
            Intrinsics.checkNotNull((Object)psiElement);
            return dasTypeSystemBase.createSequenceType(psiElement, resolved);
        }
        if (target2 instanceof DasRoutine && refElement instanceof SqlReferenceExpression) {
            DasType dasType = SqlFunctionCallExpressionImpl.createFunctionReturnType((SqlReferenceExpression)refElement, refElement);
            Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"createFunctionReturnType(...)");
            return dasType;
        }
        if (target2 instanceof DasTable) {
            return (DasType)this.createTableType((DasTable)target2, resolved, refElement);
        }
        if (target2 instanceof SqlCreateTypeStatement) {
            DasType dasType = ((SqlCreateTypeStatement)target2).getSelfDasType();
            Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"getSelfDasType(...)");
            return dasType;
        }
        if (target2 instanceof SqlFileImpl.GroupImpl && ((SqlFileImpl.GroupImpl)target2).getKind() == ObjectKind.OBJECT_TYPE) {
            SqlCreateTypeStatement createType;
            SqlCreateTypeStatement sqlCreateTypeStatement = createType = (SqlCreateTypeStatement)((SqlFileImpl.GroupImpl)target2).delegates().filter(SqlCreateTypeStatement.class).first();
            DasType dasType = sqlCreateTypeStatement != null ? sqlCreateTypeStatement.getSelfDasType() : null;
            if (dasType == null) {
                dasType = DasTypeSystemBase.UNKNOWN;
            }
            return dasType;
        }
        if (target2 instanceof SqlTypedDefinition) {
            DasType dasType;
            DasType dasType2 = SqlImplUtil.getDasType((SqlTypedDefinition)target2, this.getSqlDialect(), refElement);
            Intrinsics.checkNotNullExpressionValue((Object)dasType2, (String)"getDasType(...)");
            DasType type = dasType2;
            if (Intrinsics.areEqual((Object)type, DasTypeSystemBase.UNKNOWN)) {
                String string = ((SqlTypedDefinition)target2).getName();
                Intrinsics.checkNotNull((Object)kind);
                dasType = this.getReservedEntityType(string, (ObjectKind)kind, (PsiElement)target2);
            } else {
                dasType = type;
            }
            return dasType;
        }
        if (target2 instanceof DasObject && ((DasObject)target2).getKind() == ObjectKind.OBJECT_TYPE) {
            DasUserDefinedType customType;
            Object object3 = target2;
            DasUserDefinedType dasUserDefinedType = customType = object3 instanceof DasUserDefinedType ? (DasUserDefinedType)object3 : null;
            if (customType != null && customType.getSuperType() == null && customType.getDasChildren(ObjectKind.OBJECT_ATTRIBUTE).filter(DasTypedObject.class).isEmpty()) {
                DataType dataType = this.getDatabaseDialect().convertUDTToDataType(customType);
                if (dataType != null) {
                    return DasUnresolvedTypeReference.Companion.of(dataType);
                }
                if (resolved != null) {
                    DasType dasType = SqlImplUtil.getDasType(customType, resolved, this.getSqlDialect());
                    Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"getDasType(...)");
                    return dasType;
                }
                return DasTypeSystemBase.UNKNOWN;
            }
            if (resolved != null) {
                SqlTableType sqlTableType = SqlTableTypeBase.createObjectTypeType((DasObject)target2, resolved, refElement);
                Intrinsics.checkNotNullExpressionValue((Object)sqlTableType, (String)"createObjectTypeType(...)");
                return (DasType)sqlTableType;
            }
            return DasTypeSystemBase.UNKNOWN;
        }
        if (target2 instanceof DasSynonym) {
            DasTable info2;
            DasObject synonymTarget = DasUtil.resolveFinalTarget((DasSynonym)target2);
            if (synonymTarget instanceof DasSynonym) {
                DasType dasType;
                SqlReference sqlReference2 = ref2;
                if (sqlReference2 != null) {
                    SqlTableType sqlTableType = SqlTableTypeBase.createUnresolvedTableType((PsiReference)sqlReference2);
                    Intrinsics.checkNotNullExpressionValue((Object)sqlTableType, (String)"createUnresolvedTableType(...)");
                    dasType = (DasType)sqlTableType;
                } else {
                    dasType = DasTypeSystemBase.UNKNOWN;
                }
                return dasType;
            }
            DasTable dasTable = info2 = synonymTarget instanceof DasTable ? (DasTable)synonymTarget : null;
            if (info2 == null || resolved == null) {
                return DasTypeSystemBase.UNKNOWN;
            }
            PsiElement tablePsi = SqlImplUtil.wrapObjectToPsi(info2, resolved.getProject());
            SqlTableType sqlTableType = SqlTableTypeBase.createType(info2, tablePsi, refElement);
            Intrinsics.checkNotNullExpressionValue((Object)sqlTableType, (String)"createType(...)");
            return (DasType)sqlTableType;
        }
        if (target2 instanceof DasColumn) {
            if (resolved != null) {
                DasType dasType = SqlImplUtil.getDasType((DasTypedObject)target2, this.getSqlDialect(), resolved);
                Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"getDasType(...)");
                return dasType;
            }
            return DasTypeSystemBase.UNKNOWN;
        }
        if (target2 == null && DbImplUtilCore.isTypeKind((ObjectKind)kind)) {
            SqlReference sqlReference3 = ref2;
            Intrinsics.checkNotNull((Object)sqlReference3);
            String string = sqlReference3.getReferenceName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getReferenceName(...)");
            String name2 = string;
            if (StringUtil.isEmpty((String)name2)) {
                return DasTypeSystemBase.UNKNOWN;
            }
            DataType dataType = DataTypeFactory.of(name2);
            Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"of(...)");
            DataType dataType2 = dataType;
            return this.getSqlDialect().getTypeSystem().createDasType(dataType2);
        }
        if (target2 == refElement) {
            SqlReference sqlReference4 = ref2;
            Intrinsics.checkNotNull((Object)sqlReference4);
            String string = sqlReference4.getReferenceName();
            Intrinsics.checkNotNull((Object)kind);
            PsiElement psiElement = refElement;
            Intrinsics.checkNotNull((Object)psiElement);
            return this.getReservedEntityType(string, (ObjectKind)kind, psiElement);
        }
        if (target2 instanceof BuiltinFunction && refElement != null && (parent2 = refElement.getParent()) instanceof SqlFunctionCallExpression) {
            DasType dasType = ((SqlFunctionCallExpression)parent2).getDasType();
            Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"getDasType(...)");
            return dasType;
        }
        if (target2 instanceof SqlExpression) {
            DasType dasType = ((SqlExpression)target2).getDasType();
            Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"getDasType(...)");
            return dasType;
        }
        if (target2 instanceof SqlColumnSymbol) {
            DasType dasType = ((SqlColumnSymbol)((Object)target2)).getType();
            Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"getType(...)");
            return dasType;
        }
        if (target2 instanceof SqlDefinition && (parent2 = ((SqlDefinition)target2).getParent()) instanceof SqlSelectIntoClause && (clause = (SqlSelectClause)PsiTreeUtil.getPrevSiblingOfType((PsiElement)parent2, SqlSelectClause.class)) != null) {
            SqlTableType sqlTableType = SqlImplUtil.getSelectType(clause.getExpressions(), target2);
            Intrinsics.checkNotNullExpressionValue((Object)sqlTableType, (String)"getSelectType(...)");
            return (DasType)sqlTableType;
        }
        if (Intrinsics.areEqual((Object)kind, (Object)ObjectKind.TABLE)) {
            SqlReference sqlReference5 = ref2;
            Intrinsics.checkNotNull((Object)sqlReference5);
            SqlTableType sqlTableType = SqlTableTypeBase.createUnresolvedTableType((PsiReference)sqlReference5);
            Intrinsics.checkNotNullExpressionValue((Object)sqlTableType, (String)"createUnresolvedTableType(...)");
            return (DasType)sqlTableType;
        }
        if (target2 instanceof DbCustomType && ((DbCustomType)target2).getDelegate() instanceof DasTypedObject) {
            if (resolved != null) {
                Object object4 = ((DbCustomType)target2).getDelegate();
                Intrinsics.checkNotNull((Object)object4, (String)"null cannot be cast to non-null type com.intellij.database.model.DasTypedObject");
                DasType dasType = SqlImplUtil.getDasType((DasTypedObject)object4, this.getSqlDialect(), resolved);
                Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"getDasType(...)");
                return dasType;
            }
            return DasTypeSystemBase.UNKNOWN;
        }
        if (target2 instanceof DasTypedObject) {
            if (resolved != null) {
                DasType dasType = SqlImplUtil.getDasType((DasTypedObject)target2, this.getSqlDialect(), resolved);
                Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"getDasType(...)");
                return dasType;
            }
            return DasTypeSystemBase.UNKNOWN;
        }
        if (target2 instanceof DasUserDefinedType) {
            if (resolved != null) {
                DasType dasType = SqlImplUtil.getDasType((DasUserDefinedType)target2, resolved, this.getSqlDialect());
                Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"getDasType(...)");
                return dasType;
            }
            return DasTypeSystemBase.UNKNOWN;
        }
        return DasTypeSystemBase.UNKNOWN;
    }

    @NotNull
    protected SqlTableType createTableType(@NotNull DasTable target2, @Nullable PsiElement resolved, @Nullable PsiElement refElement) {
        Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
        SqlTableType sqlTableType = SqlTableTypeBase.createType(target2, resolved, refElement);
        Intrinsics.checkNotNullExpressionValue((Object)sqlTableType, (String)"createType(...)");
        return sqlTableType;
    }

    private final DasType getAsteriskType(PsiElement element2) {
        DasType dasType;
        SqlExpression qualifier;
        PsiElement parent2 = element2.getParent();
        PsiElement grandParent = parent2.getParent();
        SqlExpression sqlExpression = qualifier = element2 instanceof SqlReferenceExpression ? ((SqlReferenceExpression)element2).getQualifierExpression() : null;
        if (qualifier != null) {
            dasType = SqlImplUtil.filterHiddenColumns(qualifier.getDasType());
        } else {
            dasType = this.getUnqualifiedAsteriskType(element2);
            if (dasType == null) {
                SqlTableType sqlTableType = SqlTableTypeBase.EMPTY_TABLE;
                Intrinsics.checkNotNullExpressionValue((Object)sqlTableType, (String)"EMPTY_TABLE");
                return (DasType)sqlTableType;
            }
        }
        DasType dasType2 = dasType;
        Intrinsics.checkNotNull((Object)dasType2);
        DasType asteriskType = dasType2;
        if (Intrinsics.areEqual((Object)this.getDbms(), (Object)Dbms.CLICKHOUSE) || Intrinsics.areEqual((Object)this.getDbms(), (Object)Dbms.VERTICA)) {
            return asteriskType;
        }
        if (parent2 instanceof SqlExpressionList && this.getDbms().isPostgres() && qualifier != null) {
            return asteriskType;
        }
        if (parent2 instanceof SqlReturningClause && (this.getDbms().isPostgres() || this.getDbms().isSqlite() || this.getDbms().isMicrosoft())) {
            return asteriskType;
        }
        if (parent2 instanceof SqlExpressionList && grandParent instanceof SqlFunctionCallExpression) {
            BuiltinFunction builtinFunction = ((SqlFunctionCallExpression)grandParent).getFunctionDefinition();
            if (builtinFunction == null) {
                return DasTypeSystemBase.UNKNOWN;
            }
            BuiltinFunction definition2 = builtinFunction;
            if (qualifier != null && !this.getDatabaseDialect().supportsQualifiedAsteriskInCalls() || !this.supportsAsteriskArgument(definition2)) {
                return DasTypeSystemBase.UNKNOWN;
            }
        } else {
            PsiElement curParent = parent2;
            while (curParent instanceof SqlReferenceExpression) {
                curParent = curParent.getParent();
            }
            if (this.getDbms().isPostgres() || this.getDbms().isHsqldb() || this.getDbms().isH2()) {
                while (curParent instanceof SqlParenthesizedExpression) {
                    curParent = curParent.getParent();
                }
            }
            if (!(curParent instanceof SqlSelectClause || curParent instanceof SqlDmlInstruction || curParent instanceof SqlFromClause && curParent.getParent() instanceof SqlDmlInstruction || this.getDbms().isMysql() && PsiUtilCore.getElementType((PsiElement)curParent) == SqlCompositeElementTypes.SQL_CLAUSE && curParent.getParent() instanceof SqlDmlInstruction)) {
                return DasTypeSystemBase.UNKNOWN;
            }
        }
        return asteriskType;
    }

    @Override
    @Nullable
    public DasType getUnqualifiedAsteriskType(@NotNull PsiElement element2) {
        Object result2;
        Object object;
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        if (element2.getParent() instanceof SqlReturningClause) {
            SqlDmlInstruction instruction2;
            SqlDmlInstruction sqlDmlInstruction = instruction2 = (SqlDmlInstruction)PsiTreeUtil.getParentOfType((PsiElement)element2, SqlDmlInstruction.class);
            Object targetExpression = sqlDmlInstruction != null ? sqlDmlInstruction.getTargetExpression() : null;
            object = targetExpression;
            if (object == null || (object = object.getDasType()) == null) {
                object = (DasType)SqlTableTypeBase.EMPTY_TABLE;
            }
        } else {
            SqlTableExpression tableExpression;
            SqlQueryExpression queryExpression;
            SqlQueryExpression sqlQueryExpression = queryExpression = (SqlQueryExpression)PsiTreeUtil.getParentOfType((PsiElement)element2, SqlQueryExpression.class, (boolean)true);
            SqlTableExpression sqlTableExpression = tableExpression = sqlQueryExpression != null ? sqlQueryExpression.getTableExpression() : null;
            object = (DasType)(sqlTableExpression != null ? sqlTableExpression.getDasType() : null);
        }
        Object object2 = result2 = object;
        return object2 != null ? SqlImplUtil.filterHiddenColumns((DasType)object2) : null;
    }

    protected boolean supportsAsteriskArgument(@NotNull BuiltinFunction definition2) {
        Intrinsics.checkNotNullParameter((Object)definition2, (String)"definition");
        return StringsKt.equals((String)definition2.getName(), (String)"count", (boolean)true);
    }

    private final DasType getReservedEntityType(String name2, ObjectKind kind, PsiElement element2) {
        Ref.ObjectRef targetType = new Ref.ObjectRef();
        SqlLanguageDialectEx sqlLanguageDialectEx = this.getSqlDialect();
        List list = CollectionsKt.emptyList();
        this.getSqlDialect().processReservedEntitiesWithType(name2, element2, true, new SqlScopeProcessorBase(name2, element2, (Ref.ObjectRef<DasType>)targetType, sqlLanguageDialectEx, list){
            final /* synthetic */ Ref.ObjectRef<DasType> $targetType;
            {
                this.$targetType = $targetType;
                super($name, $super_call_param$1, $super_call_param$2, $element);
            }

            public boolean isResultEmpty() {
                return this.$targetType.element == null;
            }

            public boolean executeTarget(@NotNull DasSymbol symbol, @Nullable DasType dasType, @Nullable Boolean forcedCaseSens, @NotNull ResolveState state) {
                Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
                Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                if (dasType != null) {
                    this.$targetType.element = dasType;
                }
                return dasType == null;
            }
        });
        if (targetType.element != null) {
            Object object = targetType.element;
            Intrinsics.checkNotNull((Object)object);
            return (DasType)object;
        }
        if (Intrinsics.areEqual((Object)kind, (Object)ObjectKind.TABLE)) {
            SqlTableType sqlTableType = SqlTableTypeBase.EMPTY_TABLE;
            Intrinsics.checkNotNullExpressionValue((Object)sqlTableType, (String)"EMPTY_TABLE");
            return (DasType)sqlTableType;
        }
        if (StringUtil.isNotEmpty((String)name2) && DbImplUtilCore.isTypeKind(kind)) {
            String string = name2;
            Intrinsics.checkNotNull((Object)string);
            DataType dataType = DataTypeFactory.of(string);
            Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"of(...)");
            return DasUnresolvedTypeReference.Companion.of(dataType);
        }
        return DasTypeSystemBase.UNKNOWN;
    }
}

