/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base.introspector.jdbc.wrappers;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.ClosableIt;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.DatabaseMetaDataWrapper;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.MetaDataUtil;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.openapi.util.text.StringUtil;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.sql.SQLException;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UserDefinedTypeAttributeIt
extends ClosableIt.ResultSetClosableIt<DatabaseMetaDataWrapper.UserDefinedTypeAttribute> {
    private final Dbms myDbms;
    private final DatabaseMetaDataWrapper.Schema mySchema;
    private final IntSet myPositions;
    private String myPrevName;

    public UserDefinedTypeAttributeIt(@Nullable RemoteResultSet rs, @NotNull Dbms dbms, @NotNull DatabaseMetaDataWrapper.Schema schema2) throws SQLException {
        if (dbms == null) {
            UserDefinedTypeAttributeIt.$$$reportNull$$$0(0);
        }
        if (schema2 == null) {
            UserDefinedTypeAttributeIt.$$$reportNull$$$0(1);
        }
        super(rs);
        this.myPositions = new IntOpenHashSet();
        this.myDbms = dbms;
        this.mySchema = schema2;
    }

    @Override
    @NotNull
    protected DatabaseMetaDataWrapper.UserDefinedTypeAttribute createStorage() {
        return new DatabaseMetaDataWrapper.UserDefinedTypeAttribute(new DatabaseMetaDataWrapper.UserDefinedType(this.mySchema));
    }

    @Override
    protected DatabaseMetaDataWrapper.UserDefinedTypeAttribute calcValue() {
        DatabaseMetaDataWrapper.UserDefinedTypeAttribute res2 = (DatabaseMetaDataWrapper.UserDefinedTypeAttribute)this.getStorageToFill();
        try {
            String type = this.myRs.getString("TYPE_NAME", 3);
            String schema2 = StringUtil.notNullize((String)this.myRs.getString("TYPE_SCHEM", 2), (String)this.mySchema.schema);
            if (!Objects.equals(this.mySchema.schema, schema2)) {
                return (DatabaseMetaDataWrapper.UserDefinedTypeAttribute)this.skip();
            }
            if (StringUtil.isEmpty((String)type)) {
                return (DatabaseMetaDataWrapper.UserDefinedTypeAttribute)this.skip();
            }
            if (!Objects.equals(this.myPrevName, type)) {
                this.myPositions.clear();
                this.myPrevName = type;
            }
            res2.userDefinedType.name = type;
            res2.name = this.myRs.getString("ATTR_NAME", 4);
            if (StringUtil.isEmpty((String)res2.name)) {
                return (DatabaseMetaDataWrapper.UserDefinedTypeAttribute)this.skip();
            }
            res2.type = this.myRs.getInt("DATA_TYPE", 5, 0);
            res2.typeName = StringUtil.notNullize((String)this.myRs.getString("ATTR_TYPE_NAME", 6));
            res2.length = this.myRs.getInt("ATTR_SIZE", 7, 0);
            res2.scale = this.myRs.getInt("DECIMAL_DIGITS", 8, 0);
            if (this.myDbms.isSqlite()) {
                res2.length = 0;
                res2.scale = -1;
            }
            res2.nullable = "yes".equalsIgnoreCase(this.myRs.getString("IS_NULLABLE", 17));
            res2.def = this.myRs.getString("ATTR_DEF", 12);
            res2.position = this.myRs.getInt("ORDINAL_POSITION", 16, 0);
            if (res2.position == -1) {
                res2.position = 0;
            }
            while (this.myPositions.contains(res2.position)) {
                ++res2.position;
            }
            this.myPositions.add(res2.position);
            res2.comment = this.myRs.getString("REMARKS", 11);
        }
        catch (SQLException e2) {
            this.onError(res2, e2);
            return (DatabaseMetaDataWrapper.UserDefinedTypeAttribute)this.skip();
        }
        return res2;
    }

    @Override
    public void onError(DatabaseMetaDataWrapper.UserDefinedTypeAttribute cur, SQLException e2) {
        String title = cur == null ? null : MetaDataUtil.qName(StringUtil.notNullize((String)cur.userDefinedType.schema.database), cur.userDefinedType.schema.schema, StringUtil.notNullize((String)cur.userDefinedType.name));
        this.addError(title, e2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "dbms";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "schema";
                break;
            }
        }
        objectArray[1] = "com/intellij/database/dialects/base/introspector/jdbc/wrappers/UserDefinedTypeAttributeIt";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class Grouping
    extends ClosableIt.GroupingItImpl<DatabaseMetaDataWrapper.UserDefinedType, DatabaseMetaDataWrapper.UserDefinedTypeAttribute, DatabaseMetaDataWrapper.UserDefinedTypeAttribute> {
        protected Grouping(@NotNull ClosableIt<DatabaseMetaDataWrapper.UserDefinedTypeAttribute> delegate) {
            if (delegate == null) {
                Grouping.$$$reportNull$$$0(0);
            }
            super(delegate);
        }

        @Override
        @NotNull
        protected ClosableIt.GroupingItImpl.GroupIt<DatabaseMetaDataWrapper.UserDefinedTypeAttribute> createGroupIt(ClosableIt<DatabaseMetaDataWrapper.UserDefinedTypeAttribute> it2) {
            final String tableName = ((DatabaseMetaDataWrapper.UserDefinedTypeAttribute)it2.current()).userDefinedType.name;
            return new ClosableIt.GroupingItImpl.GroupIt<DatabaseMetaDataWrapper.UserDefinedTypeAttribute>(it2){

                @Override
                protected boolean isInGroup(DatabaseMetaDataWrapper.UserDefinedTypeAttribute item) {
                    return Objects.equals(tableName, item.userDefinedType.name);
                }
            };
        }

        @Override
        protected DatabaseMetaDataWrapper.UserDefinedType getItem(ClosableIt<DatabaseMetaDataWrapper.UserDefinedTypeAttribute> it2) {
            return ((DatabaseMetaDataWrapper.UserDefinedTypeAttribute)it2.current()).userDefinedType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/database/dialects/base/introspector/jdbc/wrappers/UserDefinedTypeAttributeIt$Grouping", "<init>"));
        }
    }
}

