/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base.introspector.jdbc.wrappers;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.base.introspector.jdbc.JdbcIntrospectorHelper;
import com.intellij.database.dialects.base.introspector.jdbc.JdbcIntrospectorLegacyModelUtils;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.ClosableIt;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.DatabaseMetaDataWrapper;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.MetaDataUtil;
import com.intellij.database.model.ArgumentDirection;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.database.remote.jdbc.helpers.JdbcHelper;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.sql.SQLException;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RoutineArgumentIt
extends ClosableIt.ResultSetClosableIt<DatabaseMetaDataWrapper.RoutineArgument> {
    private final Dbms myDbms;
    private final JdbcHelper myJdbcHelper;
    private final boolean myCatIsPkg;
    private final DatabaseMetaDataWrapper.Schema mySchema;
    private final Function<DatabaseMetaDataWrapper.Routine, DasRoutine.Kind> myKindProvider;
    private final boolean myProc;
    private final MetaDataUtil.SpecNamer myNamer;
    private final IntSet myPositions;
    private String myLastOrigName;
    private String myLastSpecName;
    private int myNum;
    private DasRoutine.Kind myKind;

    public RoutineArgumentIt(@Nullable RemoteResultSet rs, @NotNull Dbms dbms, @NotNull DatabaseMetaDataWrapper.Schema schema2, boolean catIsPkg, @NotNull Function<DatabaseMetaDataWrapper.Routine, DasRoutine.Kind> kindProvider, boolean proc) throws SQLException {
        if (dbms == null) {
            RoutineArgumentIt.$$$reportNull$$$0(0);
        }
        if (schema2 == null) {
            RoutineArgumentIt.$$$reportNull$$$0(1);
        }
        if (kindProvider == null) {
            RoutineArgumentIt.$$$reportNull$$$0(2);
        }
        super(rs);
        this.myNamer = new MetaDataUtil.SpecNamer();
        this.myPositions = new IntOpenHashSet();
        this.myNum = 0;
        this.myKind = DasRoutine.Kind.NONE;
        this.myDbms = dbms;
        this.myCatIsPkg = catIsPkg;
        this.mySchema = schema2;
        this.myKindProvider = kindProvider;
        this.myProc = proc;
        this.myJdbcHelper = DbImplUtilCore.getJdbcHelper(this.myDbms);
    }

    @Override
    @NotNull
    protected DatabaseMetaDataWrapper.RoutineArgument createStorage() {
        return new DatabaseMetaDataWrapper.RoutineArgument(new DatabaseMetaDataWrapper.Routine(this.mySchema, null, ""));
    }

    @Override
    protected DatabaseMetaDataWrapper.RoutineArgument calcValue() {
        DatabaseMetaDataWrapper.RoutineArgument res2 = (DatabaseMetaDataWrapper.RoutineArgument)this.getStorageToFill();
        try {
            String cat = this.getCatalog();
            res2.routine.pkg = this.myCatIsPkg ? StringUtil.nullize((String)cat) : null;
            String schema2 = this.getSchema();
            if (!StringUtil.equalsIgnoreCase((CharSequence)this.mySchema.schema, (CharSequence)schema2)) {
                return (DatabaseMetaDataWrapper.RoutineArgument)this.skip();
            }
            String origName = this.getRoutineName();
            Pair<String, Short> curName = JdbcIntrospectorLegacyModelUtils.fixProcedureName(this.mySchema.schema, this.myDbms, origName);
            if (curName == null) {
                return (DatabaseMetaDataWrapper.RoutineArgument)this.skip();
            }
            res2.routine.name = (String)curName.first;
            res2.routine.number = (Short)curName.second;
            String curSpec = this.getSpecificRoutineName();
            res2.routine.specificName = this.myNamer.getSpecName(curSpec, res2.routine.name, res2.routine.pkg);
            int pos = this.getPosition();
            if ((pos != -1 && this.myPositions.contains(pos) || !Objects.equals(origName, this.myLastOrigName)) && Objects.equals(this.myLastSpecName, res2.routine.specificName)) {
                this.myNamer.finish(curSpec, res2.routine.name, res2.routine.pkg);
                res2.routine.specificName = this.myNamer.getSpecName(curSpec, res2.routine.name, res2.routine.pkg);
                this.myPositions.clear();
            }
            if (!Objects.equals(this.myLastSpecName, res2.routine.specificName)) {
                this.myNum = 0;
                this.myLastSpecName = res2.routine.specificName;
                this.myLastOrigName = origName;
                this.myKind = (DasRoutine.Kind)((Object)this.myKindProvider.fun((Object)res2.routine));
                this.myPositions.clear();
            }
            res2.routine.kind = this.myKind;
            res2.name = this.getColumnName();
            res2.type = this.getDataType();
            res2.typeName = this.getTypeName();
            res2.typeSuffix = null;
            int precision = this.getPrecision();
            int length = this.getLength();
            res2.scale = this.getScale();
            int charOctetLength = this.getCharOctetLength();
            res2.nullable = this.isNullable();
            res2.def = this.getColumnDef();
            JdbcIntrospectorHelper.JdbcParameterType columnType = this.getColumnType();
            res2.position = pos;
            if (res2.position == -1) {
                res2.position = 0;
            }
            while (this.myPositions.contains(res2.position)) {
                ++res2.position;
            }
            this.myPositions.add(res2.position);
            res2.length = precision != 0 ? precision : (length != 0 ? length : charOctetLength);
            boolean retParam = false;
            if (res2.routine.kind == DasRoutine.Kind.FUNCTION && (pos == 0 || pos == -1 && "returnValue".equals(res2.name) || this.myDbms.isMysql() && this.myNum == 0)) {
                retParam = true;
            } else if (res2.routine.kind != DasRoutine.Kind.FUNCTION && pos == 0 && "RETURN_VALUE".equals(res2.name)) {
                return (DatabaseMetaDataWrapper.RoutineArgument)this.skip();
            }
            res2.direction = retParam ? ArgumentDirection.RETURN : RoutineArgumentIt.asDirection(columnType);
            if (res2.direction == ArgumentDirection.RETURN) {
                res2.name = null;
                res2.position = 0;
                if (res2.routine.kind == DasRoutine.Kind.PROCEDURE) {
                    return (DatabaseMetaDataWrapper.RoutineArgument)this.skip();
                }
            }
            this.myJdbcHelper.adjustType((JdbcHelper.Type)res2);
            ++this.myNum;
        }
        catch (SQLException e2) {
            this.onError(res2, e2);
            return (DatabaseMetaDataWrapper.RoutineArgument)this.skip();
        }
        return res2;
    }

    private JdbcIntrospectorHelper.JdbcParameterType getColumnType() throws SQLException {
        short type = this.myRs.getShort("COLUMN_TYPE", 5);
        return this.myProc ? JdbcIntrospectorHelper.JdbcParameterType.findByID(type) : JdbcIntrospectorHelper.JdbcParameterType.findByFuncID(type);
    }

    private String getColumnDef() throws SQLException {
        return this.myProc ? this.myRs.getString("COLUMN_DEF", 14) : null;
    }

    private boolean isNullable() throws SQLException {
        return this.myRs.getInt("NULLABLE", 12, 0) != 0;
    }

    private int getCharOctetLength() throws SQLException {
        return this.myRs.getInt("CHAR_OCTET_LENGTH", this.myProc ? 17 : 14, 0);
    }

    private int getScale() throws SQLException {
        return this.myRs.getInt("SCALE", 10, 0);
    }

    private int getLength() throws SQLException {
        return this.myRs.getInt("LENGTH", 9, 0);
    }

    private int getPrecision() throws SQLException {
        return this.myRs.getInt("PRECISION", 8, 0);
    }

    private String getTypeName() throws SQLException {
        return this.myRs.getString("TYPE_NAME", 7);
    }

    private int getDataType() throws SQLException {
        return this.myRs.getInt("DATA_TYPE", 6, 0);
    }

    private String getColumnName() throws SQLException {
        return this.myRs.getString("COLUMN_NAME", 4);
    }

    private int getPosition() throws SQLException {
        return this.myRs.getInt("ORDINAL_POSITION", this.myProc ? 18 : 15, -1);
    }

    private String getSpecificRoutineName() throws SQLException {
        return this.myRs.getString("SPECIFIC_NAME", 20);
    }

    private String getRoutineName() throws SQLException {
        return this.myRs.getString(this.myProc ? "PROCEDURE_NAME" : "FUNCTION_NAME", 3);
    }

    @NotNull
    private String getSchema() throws SQLException {
        String string = StringUtil.notNullize((String)this.myRs.getString(this.myProc ? "PROCEDURE_SCHEM" : "FUNCTION_SCHEM", 2), (String)this.mySchema.schema);
        if (string == null) {
            RoutineArgumentIt.$$$reportNull$$$0(3);
        }
        return string;
    }

    private String getCatalog() throws SQLException {
        return this.myRs.getString(this.myProc ? "PROCEDURE_CAT" : "FUNCTION_CAT", 1);
    }

    private static ArgumentDirection asDirection(JdbcIntrospectorHelper.JdbcParameterType type) {
        if (type == JdbcIntrospectorHelper.JdbcParameterType.IN) {
            return ArgumentDirection.IN;
        }
        if (type == JdbcIntrospectorHelper.JdbcParameterType.INOUT) {
            return ArgumentDirection.INOUT;
        }
        if (type == JdbcIntrospectorHelper.JdbcParameterType.OUT) {
            return ArgumentDirection.OUT;
        }
        if (type == JdbcIntrospectorHelper.JdbcParameterType.RESULT) {
            return ArgumentDirection.RESULT;
        }
        if (type == JdbcIntrospectorHelper.JdbcParameterType.RETURN) {
            return ArgumentDirection.RETURN;
        }
        return ArgumentDirection.IN;
    }

    @Override
    public void onError(DatabaseMetaDataWrapper.RoutineArgument cur, SQLException e2) {
        String title = cur == null ? null : MetaDataUtil.qName(cur.routine.schema.database, cur.routine.schema.schema, cur.routine.name);
        this.addError(title, e2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schema";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kindProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/base/introspector/jdbc/wrappers/RoutineArgumentIt";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/base/introspector/jdbc/wrappers/RoutineArgumentIt";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSchema";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    public static class Grouping
    extends ClosableIt.GroupingItImpl<DatabaseMetaDataWrapper.Routine, DatabaseMetaDataWrapper.RoutineArgument, DatabaseMetaDataWrapper.RoutineArgument> {
        protected Grouping(@NotNull ClosableIt<DatabaseMetaDataWrapper.RoutineArgument> delegate) {
            if (delegate == null) {
                Grouping.$$$reportNull$$$0(0);
            }
            super(delegate);
        }

        @Override
        @NotNull
        protected ClosableIt.GroupingItImpl.GroupIt<DatabaseMetaDataWrapper.RoutineArgument> createGroupIt(ClosableIt<DatabaseMetaDataWrapper.RoutineArgument> it2) {
            final String specificName = ((DatabaseMetaDataWrapper.RoutineArgument)it2.current()).routine.specificName;
            return new ClosableIt.GroupingItImpl.GroupIt<DatabaseMetaDataWrapper.RoutineArgument>(it2){

                @Override
                protected boolean isInGroup(DatabaseMetaDataWrapper.RoutineArgument item) {
                    return Objects.equals(specificName, item.routine.specificName);
                }
            };
        }

        @Override
        protected DatabaseMetaDataWrapper.Routine getItem(ClosableIt<DatabaseMetaDataWrapper.RoutineArgument> it2) {
            return ((DatabaseMetaDataWrapper.RoutineArgument)it2.current()).routine;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/database/dialects/base/introspector/jdbc/wrappers/RoutineArgumentIt$Grouping", "<init>"));
        }
    }
}

