/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base.generator.producers;

import com.intellij.database.dialects.base.generator.ScriptingContext;
import com.intellij.database.dialects.base.generator.producers.LikeColumnProducersKt;
import com.intellij.database.model.ElementAlteration;
import com.intellij.database.model.ElementDelta;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicLikeColumn;
import com.intellij.database.model.basic.BasicLikeTable;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.families.PositioningNamingFamily;
import com.intellij.openapi.util.Key;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000P\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\b\u0003\u001a*\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\t\u001a\u00020\u00032\b\u0010\n\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a*\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\n\u001a\u0004\u0018\u00010\u0003H\u0002\u001a9\u0010\u0010\u001a\u00020\u00112\u0014\u0010\u0012\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u000e0\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\u00152\u0006\u0010\u0016\u001a\u00020\u0011H\u0002\u00a2\u0006\u0002\u0010\u0017\u001a\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0019\u001a\u00020\u0005\u001a(\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\t\u001a\u00020\u00032\b\u0010\n\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\"\u0010\u001b\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u0016\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f\u001a\u001c\u0010\u001e\u001a\u00020\u001d2\u0014\u0010\u0012\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u000e0\u001f\u001a\u0017\u0010 \u001a\u00020\u0011*\b\u0012\u0004\u0012\u00020\u00110\u0015H\u0002\u00a2\u0006\u0002\u0010!\"E\u0010\u0000\u001a9\u00120\u0012.\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0004 \u0006*\u0016\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0004\u0018\u00010\u00020\u00020\u0001\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"UNSORTED_COLUMNS", "Lcom/intellij/openapi/util/Key;", "", "Lcom/intellij/database/model/basic/BasicLikeTable;", "", "Lcom/intellij/database/model/basic/BasicLikeColumn;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "computeUnsorted", "srcTable", "tgtTable", "context", "Lcom/intellij/database/dialects/base/generator/ScriptingContext;", "findAlteration", "Lcom/intellij/database/model/ElementAlteration;", "srcCol", "findSortedPrefix", "", "columns", "", "lens", "", "end", "(Ljava/util/List;[Ljava/lang/Integer;I)I", "getPrevColumn", "col", "getUnsortedColumns", "getUnsortedHolder", "hasExistingColumnAfter", "", "nullizeSorted", "", "indexOfMax", "([Ljava/lang/Integer;)I", "intellij.database.dialects.base"})
@SourceDebugExtension(value={"SMAP\nLikeColumnProducers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LikeColumnProducers.kt\ncom/intellij/database/dialects/base/generator/producers/LikeColumnProducersKt\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,292:1\n372#2,7:293\n1002#3,2:300\n1611#3:302\n1855#3:303\n1856#3:305\n1612#3:306\n1864#3,3:308\n1#4:304\n1#4:307\n13374#5,3:311\n*S KotlinDebug\n*F\n+ 1 LikeColumnProducers.kt\ncom/intellij/database/dialects/base/generator/producers/LikeColumnProducersKt\n*L\n222#1:293,7\n238#1:300,2\n240#1:302\n240#1:303\n240#1:305\n240#1:306\n250#1:308,3\n240#1:304\n285#1:311,3\n*E\n"})
public final class LikeColumnProducersKt {
    @NotNull
    private static final Key<Map<BasicLikeTable, Set<BasicLikeColumn>>> UNSORTED_COLUMNS;

    @Nullable
    public static final BasicLikeColumn getPrevColumn(@NotNull BasicLikeColumn col) {
        Intrinsics.checkNotNullParameter((Object)col, (String)"col");
        short pos = col.getPosition();
        if (pos == 1) {
            return null;
        }
        BasicNode basicNode = col.getLikeTable();
        if (basicNode == null || (basicNode = basicNode.getColumns()) == null) {
            return null;
        }
        BasicNode columns2 = basicNode;
        short maxPos = 0;
        BasicLikeColumn maxCol = null;
        Iterator iterator = columns2.iterator();
        while (iterator.hasNext()) {
            BasicLikeColumn cur = (BasicLikeColumn)iterator.next();
            short curPos = cur.getPosition();
            if (curPos >= pos || curPos <= maxPos) continue;
            maxPos = curPos;
            maxCol = cur;
        }
        return maxCol;
    }

    public static final boolean hasExistingColumnAfter(@NotNull BasicLikeColumn col, @NotNull ScriptingContext context) {
        Intrinsics.checkNotNullParameter((Object)col, (String)"col");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context.getByTarget().isEmpty()) {
            return false;
        }
        short pos = col.getPosition();
        BasicNode basicNode = col.getLikeTable();
        if (basicNode == null || (basicNode = basicNode.getColumns()) == null) {
            return false;
        }
        BasicNode columns2 = basicNode;
        Iterator iterator = columns2.iterator();
        while (iterator.hasNext()) {
            BasicLikeColumn cur = (BasicLikeColumn)iterator.next();
            if (cur.getPosition() <= pos) continue;
            ElementDelta<?> elementDelta = context.getByTarget().get(cur);
            if ((elementDelta != null ? elementDelta.getSourceElement() : null) == null) continue;
            return true;
        }
        return false;
    }

    private static final Set<BasicLikeColumn> getUnsortedColumns(BasicLikeTable srcTable, BasicLikeTable tgtTable, ScriptingContext context) {
        Set<BasicLikeColumn> set;
        Map<BasicLikeTable, Set<BasicLikeColumn>> $this$getOrPut$iv = LikeColumnProducersKt.getUnsortedHolder(context);
        boolean $i$f$getOrPut = false;
        Set<BasicLikeColumn> value$iv = $this$getOrPut$iv.get(srcTable);
        if (value$iv == null) {
            boolean bl = false;
            Set<BasicLikeColumn> set2 = LikeColumnProducersKt.computeUnsorted(srcTable, tgtTable, context);
            if (set2 == null) {
                Set set3 = Collections.emptySet();
                set2 = set3;
                Intrinsics.checkNotNullExpressionValue(set3, (String)"emptySet(...)");
            }
            Set<BasicLikeColumn> answer$iv = set2;
            $this$getOrPut$iv.put(srcTable, answer$iv);
            set = answer$iv;
        } else {
            set = value$iv;
        }
        return set;
    }

    private static final Map<BasicLikeTable, Set<BasicLikeColumn>> getUnsortedHolder(ScriptingContext context) {
        Map map2 = context.getSharedData().computeIfAbsent(UNSORTED_COLUMNS, arg_0 -> LikeColumnProducersKt.getUnsortedHolder$lambda$1(getUnsortedHolder.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"computeIfAbsent(...)");
        return map2;
    }

    /*
     * WARNING - void declaration
     */
    private static final Set<BasicLikeColumn> computeUnsorted(BasicLikeTable srcTable, BasicLikeTable tgtTable, ScriptingContext context) {
        void $this$mapNotNullTo$iv;
        List columns2 = new ArrayList();
        for (BasicLikeColumn basicLikeColumn : srcTable.getColumns()) {
            ElementAlteration<BasicLikeColumn> it2;
            Intrinsics.checkNotNull((Object)basicLikeColumn);
            if (LikeColumnProducersKt.findAlteration(basicLikeColumn, context, tgtTable) == null) continue;
            boolean bl = false;
            if (it2.getTargetElement() == basicLikeColumn) continue;
            columns2.add(it2);
        }
        if (columns2.isEmpty()) {
            return null;
        }
        Iterable $this$sortBy$iv = columns2;
        boolean bl = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b2) {
                    ElementAlteration it2 = (ElementAlteration)a;
                    boolean bl = false;
                    ElementAlteration elementAlteration = it2;
                    Intrinsics.checkNotNull((Object)elementAlteration);
                    it2 = (ElementAlteration)b2;
                    Comparable comparable = Short.valueOf(((BasicLikeColumn)elementAlteration.getSourceElement()).getPosition());
                    bl = false;
                    ElementAlteration elementAlteration2 = it2;
                    Intrinsics.checkNotNull((Object)elementAlteration2);
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Short.valueOf(((BasicLikeColumn)elementAlteration2.getSourceElement()).getPosition()));
                }
            });
        }
        if (!LikeColumnProducersKt.nullizeSorted(columns2)) {
            return null;
        }
        $this$sortBy$iv = columns2;
        Collection collection2 = new HashSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv.iterator();
        while (iterator.hasNext()) {
            BasicLikeColumn it$iv;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator.next();
            boolean bl2 = false;
            ElementAlteration it3 = (ElementAlteration)element$iv;
            boolean bl22 = false;
            ElementAlteration elementAlteration = it3;
            if ((elementAlteration != null ? (BasicLikeColumn)elementAlteration.getSourceElement() : null) == null) continue;
            it$iv = it$iv;
            boolean bl3 = false;
            collection2.add(it$iv);
        }
        return (Set)collection2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final ElementAlteration<BasicLikeColumn> findAlteration(BasicLikeColumn srcCol, ScriptingContext context, BasicLikeTable tgtTable) {
        BasicNode basicNode;
        ElementDelta<?> elementDelta = context.getBySource().get(srcCol);
        ElementAlteration elementAlteration = elementDelta instanceof ElementAlteration ? (ElementAlteration)elementDelta : null;
        ElementAlteration elementAlteration2 = elementAlteration;
        if (elementAlteration != null) return elementAlteration2;
        BasicLikeTable basicLikeTable = tgtTable;
        BasicNode basicNode2 = basicLikeTable;
        if (basicLikeTable == null) return null;
        PositioningNamingFamily<? extends BasicLikeColumn> positioningNamingFamily = basicNode2.getColumns();
        basicNode2 = positioningNamingFamily;
        if (positioningNamingFamily == null) return null;
        BasicLikeColumn basicLikeColumn = (BasicLikeColumn)basicNode2.get(srcCol.getName());
        basicNode2 = basicLikeColumn;
        if (basicLikeColumn == null) return null;
        BasicNode it2 = basicNode = basicNode2;
        boolean bl = false;
        if (context.getByTarget().get(it2) != null) return null;
        boolean bl2 = true;
        if (!bl2) return null;
        BasicNode basicNode3 = basicNode;
        basicNode2 = basicNode3;
        if (basicNode3 == null) return null;
        it2 = basicNode2;
        boolean bl3 = false;
        elementAlteration2 = new ElementAlteration<BasicElement>(srcCol, (BasicElement)it2);
        return elementAlteration2;
    }

    public static final boolean nullizeSorted(@NotNull List<ElementAlteration<BasicLikeColumn>> columns2) {
        Intrinsics.checkNotNullParameter(columns2, (String)"columns");
        int n = 0;
        int n3 = columns2.size();
        Integer[] integerArray = new Integer[n3];
        while (n < n3) {
            int n4 = n++;
            integerArray[n4] = 0;
        }
        Integer[] lens = integerArray;
        n3 = 0;
        int n5 = columns2.size();
        Integer[] integerArray2 = new Integer[n5];
        while (n3 < n5) {
            int n6 = n3++;
            integerArray2[n6] = -1;
        }
        Integer[] backRefs = integerArray2;
        Iterable $this$forEachIndexed$iv = columns2;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            int n7;
            if ((n7 = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            ElementAlteration cfr_ignored_0 = (ElementAlteration)item$iv;
            int i2 = n7;
            boolean bl = false;
            int maxi = LikeColumnProducersKt.findSortedPrefix(columns2, lens, i2);
            backRefs[i2] = maxi;
            lens[i2] = maxi == -1 ? 1 : lens[maxi] + 1;
        }
        int idx = LikeColumnProducersKt.indexOfMax(lens);
        if (lens[idx].intValue() == columns2.size()) {
            return false;
        }
        while (idx != -1) {
            columns2.set(idx, null);
            idx = backRefs[idx];
        }
        return true;
    }

    private static final int findSortedPrefix(List<? extends ElementAlteration<? extends BasicLikeColumn>> columns2, Integer[] lens, int end) {
        ElementAlteration<? extends BasicLikeColumn> elementAlteration = columns2.get(end);
        Intrinsics.checkNotNull(elementAlteration);
        short pos = elementAlteration.getTargetElement().getPosition();
        int max = 0;
        int maxi = -1;
        int k = end - 1;
        while (k >= 0) {
            int kk = k--;
            ElementAlteration<? extends BasicLikeColumn> prev = columns2.get(kk);
            int cur = lens[kk] + 1;
            if (cur <= max) continue;
            ElementAlteration<? extends BasicLikeColumn> elementAlteration2 = prev;
            Intrinsics.checkNotNull(elementAlteration2);
            if (pos <= elementAlteration2.getTargetElement().getPosition()) continue;
            max = cur;
            maxi = kk;
            if (max != kk + 1) continue;
            return maxi;
        }
        return maxi;
    }

    /*
     * WARNING - void declaration
     */
    private static final int indexOfMax(Integer[] $this$indexOfMax) {
        int maxi = 0;
        int max = 0;
        max = $this$indexOfMax[0];
        Integer[] $this$forEachIndexed$iv = $this$indexOfMax;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Integer item$iv : $this$forEachIndexed$iv) {
            void v2;
            int n = index$iv++;
            int n3 = ((Number)item$iv).intValue();
            int i2 = n;
            boolean bl = false;
            if (max >= v2) continue;
            max = v2;
            maxi = i2;
        }
        return maxi;
    }

    private static final Map getUnsortedHolder$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Map)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ Set access$getUnsortedColumns(BasicLikeTable srcTable, BasicLikeTable tgtTable, ScriptingContext context) {
        return LikeColumnProducersKt.getUnsortedColumns(srcTable, tgtTable, context);
    }

    static {
        Key key2 = Key.create((String)"UNSORTED_COLUMNS");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"create(...)");
        UNSORTED_COLUMNS = key2;
    }
}

