/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base.generator.dml;

import com.intellij.database.Dbms;
import com.intellij.database.data.types.ColumnRef;
import com.intellij.database.data.types.PredicateOperation;
import com.intellij.database.data.types.PredicateValue;
import com.intellij.database.data.types.PredicatesHelper;
import com.intellij.database.datagrid.RowSortOrder;
import com.intellij.database.script.generator.dml.ColumnsOrderBy;
import com.intellij.database.script.generator.dml.DmlTask;
import com.intellij.database.script.generator.dml.DmlTaskKt;
import com.intellij.database.script.generator.dml.DmlUtilKt;
import com.intellij.database.script.generator.dml.OrderBy;
import com.intellij.database.script.generator.dml.PlainOrderBy;
import com.intellij.database.script.generator.dml.PlainWhereClause;
import com.intellij.database.script.generator.dml.PredicatesWhereClause;
import com.intellij.database.script.generator.dml.ValuesWhereClause;
import com.intellij.database.script.generator.dml.WhereClause;
import com.intellij.database.util.DdlBuilder;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000`\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a4\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0004\u001a\u00020\u00052\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\u0011\u001a\u00020\u0007\u001a^\u0010\n\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00072\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u00072&\u0010\u0018\u001a\"\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0019j\u0004\u0018\u0001`\u001dH\u0002\u001at\u0010\n\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00072\u0012\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00140\u00142\u0006\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00072&\u0010\u0018\u001a\"\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0019j\u0004\u0018\u0001`\u001dH\u0002\u00a8\u0006!"}, d2={"generateOrderBy", "", "orderBy", "Lcom/intellij/database/script/generator/dml/ColumnsOrderBy;", "builder", "Lcom/intellij/database/util/DdlBuilder;", "printOrderByKeyword", "", "Lcom/intellij/database/script/generator/dml/OrderBy;", "Lcom/intellij/database/script/generator/dml/PlainOrderBy;", "generateWhere", "dbms", "Lcom/intellij/database/Dbms;", "whereClause", "Lcom/intellij/database/script/generator/dml/WhereClause;", "task", "Lcom/intellij/database/script/generator/dml/DmlTask;", "printWhereKeyword", "insertNewLines", "predicates", "", "Lcom/intellij/database/data/types/PredicatesHelper$PredicateProducer;", "op", "", "processor", "Lkotlin/Function3;", "Lcom/intellij/database/data/types/ColumnRef;", "Lcom/intellij/database/data/types/PredicateValue;", "Lcom/intellij/database/data/types/PredicateOperation;", "Lcom/intellij/database/script/generator/dml/ColumnValueConsumer;", "opInner", "opOuter", "newLineBeforeOuterOp", "intellij.database.dialects.base"})
@SourceDebugExtension(value={"SMAP\nutil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 util.kt\ncom/intellij/database/dialects/base/generator/dml/UtilKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,73:1\n1855#2,2:74\n*S KotlinDebug\n*F\n+ 1 util.kt\ncom/intellij/database/dialects/base/generator/dml/UtilKt\n*L\n42#1:74,2\n*E\n"})
public final class UtilKt {
    public static final void generateWhere(@NotNull Dbms dbms, @Nullable WhereClause whereClause2, @NotNull DdlBuilder builder, @NotNull DmlTask<?> task, boolean printWhereKeyword) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter(task, (String)"task");
        WhereClause whereClause3 = whereClause2;
        if (whereClause3 instanceof ValuesWhereClause) {
            List<List<PredicatesHelper.PredicateProducer>> predicates = ((ValuesWhereClause)whereClause2).getPredicates(dbms, DmlTaskKt.getTableAlias(task), DmlTaskKt.getVersion(task), DmlTaskKt.inUpdate(task));
            UtilKt.generateWhere(builder, DmlTaskKt.insertNewLines(task), predicates, ((ValuesWhereClause)whereClause2).getOpInner(), ((ValuesWhereClause)whereClause2).getOpOuter(), ((ValuesWhereClause)whereClause2).getNewLineBeforeOuterOp(), printWhereKeyword, ((ValuesWhereClause)whereClause2).getProcessor());
        } else if (whereClause3 instanceof PredicatesWhereClause) {
            UtilKt.generateWhere(builder, DmlTaskKt.insertNewLines(task), ((PredicatesWhereClause)whereClause2).getPredicates(), ((PredicatesWhereClause)whereClause2).getOp(), printWhereKeyword, ((PredicatesWhereClause)whereClause2).getProcessor());
        } else if (whereClause3 instanceof PlainWhereClause) {
            if (StringsKt.isBlank((CharSequence)((PlainWhereClause)whereClause2).getFilter())) {
                return;
            }
            if (printWhereKeyword) {
                builder.keyword("WHERE");
            }
            builder.space().plain(((PlainWhereClause)whereClause2).getFilter());
        }
    }

    private static final void generateWhere(DdlBuilder builder, boolean insertNewLines, List<PredicatesHelper.PredicateProducer> predicates, String op, boolean printWhereKeyword, Function3<? super ColumnRef, ? super PredicateValue, ? super PredicateOperation, Unit> processor2) {
        UtilKt.generateWhere(builder, insertNewLines, CollectionsKt.listOf(predicates), op, "OR", false, printWhereKeyword, processor2);
    }

    private static final void generateWhere(DdlBuilder builder, boolean insertNewLines, List<? extends List<PredicatesHelper.PredicateProducer>> predicates, String opInner, String opOuter, boolean newLineBeforeOuterOp, boolean printWhereKeyword, Function3<? super ColumnRef, ? super PredicateValue, ? super PredicateOperation, Unit> processor2) {
        if (predicates.isEmpty()) {
            return;
        }
        if (printWhereKeyword) {
            builder.keyword("WHERE").space();
        }
        boolean firstOuter = true;
        for (List<PredicatesHelper.PredicateProducer> list : predicates) {
            if (firstOuter) {
                firstOuter = false;
            } else {
                DmlUtilKt.space(builder, insertNewLines || newLineBeforeOuterOp).keyword(opOuter).space();
            }
            boolean firstInner = true;
            for (PredicatesHelper.PredicateProducer predicate : list) {
                if (firstInner) {
                    firstInner = false;
                } else {
                    DmlUtilKt.space(builder, insertNewLines).keyword(opInner).space();
                }
                if (processor2 != null) {
                    Iterable $this$forEach$iv = predicate.getColumnRefs();
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        ColumnRef it2 = (ColumnRef)element$iv;
                        boolean bl = false;
                        processor2.invoke((Object)it2, (Object)predicate.getValue(), (Object)predicate.getOperation());
                    }
                }
                predicate.getProduce().invoke((Object)builder);
            }
        }
    }

    public static final void generateOrderBy(@NotNull OrderBy orderBy, @NotNull DdlBuilder builder, boolean printOrderByKeyword) {
        Intrinsics.checkNotNullParameter((Object)orderBy, (String)"orderBy");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        OrderBy orderBy2 = orderBy;
        if (orderBy2 instanceof ColumnsOrderBy) {
            UtilKt.generateOrderBy((ColumnsOrderBy)orderBy, builder, printOrderByKeyword);
        } else if (orderBy2 instanceof PlainOrderBy) {
            UtilKt.generateOrderBy((PlainOrderBy)orderBy, builder, printOrderByKeyword);
        }
    }

    private static final void generateOrderBy(ColumnsOrderBy orderBy, DdlBuilder builder, boolean printOrderByKeyword) {
        boolean first2 = true;
        for (Pair<String, RowSortOrder.Type> pair : orderBy.getColumns()) {
            String name2 = (String)pair.component1();
            RowSortOrder.Type order2 = (RowSortOrder.Type)pair.component2();
            if (first2) {
                if (printOrderByKeyword) {
                    String[] stringArray = new String[]{"ORDER", "BY"};
                    builder.keywords(stringArray).space();
                }
                first2 = false;
            } else {
                builder.symbol(",").space();
            }
            builder.columnRef(name2);
            if (order2 == RowSortOrder.Type.ASC) continue;
            builder.space().keyword(order2.toString());
        }
    }

    private static final void generateOrderBy(PlainOrderBy orderBy, DdlBuilder builder, boolean printOrderByKeyword) {
        if (StringsKt.isBlank((CharSequence)orderBy.getText())) {
            return;
        }
        if (printOrderByKeyword) {
            String[] stringArray = new String[]{"ORDER", "BY"};
            builder.keywords(stringArray).space();
        }
        builder.plain(orderBy.getText());
    }
}

