/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base.generator.dml;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.base.generator.dml.DmlGenerator;
import com.intellij.database.dialects.base.generator.dml.UtilKt;
import com.intellij.database.script.generator.dml.CountAll;
import com.intellij.database.script.generator.dml.DmlTask;
import com.intellij.database.script.generator.dml.DmlTaskKt;
import com.intellij.database.script.generator.dml.DmlUtilKt;
import com.intellij.database.script.generator.dml.OrderBy;
import com.intellij.database.script.generator.dml.WhereClause;
import com.intellij.database.script.generator.dml.WrapInSelectResult;
import com.intellij.database.script.generator.dml.WrapInSelectTask;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlClause;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlOrderByClause;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlResultSetExpression;
import com.intellij.sql.psi.SqlSelectClause;
import com.intellij.sql.psi.SqlSelectOption;
import com.intellij.sql.psi.SqlTableExpression;
import com.intellij.sql.psi.SqlWithQueryExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J(\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J'\u0010\u0011\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000fH\u0002\u00a2\u0006\u0002\u0010\u0015J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u00132\u0006\u0010\f\u001a\u00020\rH\u0002J\n\u0010\u001b\u001a\u0004\u0018\u00010\u0002H\u0016J \u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020 H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/database/dialects/base/generator/dml/BaseWrapInSelectGenerator;", "Lcom/intellij/database/dialects/base/generator/dml/DmlGenerator;", "Lcom/intellij/database/script/generator/dml/WrapInSelectResult;", "Lcom/intellij/database/script/generator/dml/WrapInSelectTask;", "task", "dbms", "Lcom/intellij/database/Dbms;", "(Lcom/intellij/database/script/generator/dml/WrapInSelectTask;Lcom/intellij/database/Dbms;)V", "appendWrappedQueryTail", "", "head", "Lcom/intellij/database/util/DdlBuilder;", "e", "Lcom/intellij/sql/psi/SqlResultSetExpression;", "query", "", "alias", "buildOptimizedCountQuery", "builder", "Lcom/intellij/sql/psi/SqlQueryExpression;", "queryText", "(Lcom/intellij/database/util/DdlBuilder;Lcom/intellij/sql/psi/SqlQueryExpression;Ljava/lang/String;)Ljava/lang/Integer;", "clauseSupportsOptimizedCount", "", "clause", "Lcom/intellij/sql/psi/SqlClause;", "findQuery", "generate", "removeOrderByClause", "project", "Lcom/intellij/openapi/project/Project;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialect;", "intellij.database.dialects.base"})
@SourceDebugExtension(value={"SMAP\nBaseWrapInSelectGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseWrapInSelectGenerator.kt\ncom/intellij/database/dialects/base/generator/dml/BaseWrapInSelectGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,152:1\n1726#2,3:153\n*S KotlinDebug\n*F\n+ 1 BaseWrapInSelectGenerator.kt\ncom/intellij/database/dialects/base/generator/dml/BaseWrapInSelectGenerator\n*L\n122#1:153,3\n*E\n"})
public class BaseWrapInSelectGenerator
extends DmlGenerator<WrapInSelectResult, WrapInSelectTask> {
    @NotNull
    private final Dbms dbms;

    public BaseWrapInSelectGenerator(@NotNull WrapInSelectTask task, @NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        super((DmlTask)task);
        this.dbms = dbms;
    }

    @Override
    @Nullable
    public WrapInSelectResult generate() {
        Object it2;
        Integer offset;
        SqlQueryExpression queryExpression;
        DdlBuilder builder = ((WrapInSelectTask)this.getTask()).getBuilder();
        String string = StringUtil.trimEnd((String)((WrapInSelectTask)this.getTask()).getQuery(), (String)";");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"trimEnd(...)");
        String queryText2 = string;
        SqlLanguageDialect sqlLanguageDialect = DbSqlUtilCore.getSqlDialect(this.dbms);
        Intrinsics.checkNotNullExpressionValue((Object)sqlLanguageDialect, (String)"getSqlDialect(...)");
        SqlLanguageDialect dialect = sqlLanguageDialect;
        if (((WrapInSelectTask)this.getTask()).getColumns() instanceof CountAll) {
            queryText2 = this.removeOrderByClause(((WrapInSelectTask)this.getTask()).getProject(), queryText2, dialect);
        }
        SqlResultSetExpression sqlResultSetExpression = DbSqlUtilCore.parseSqlQueryResultSetExpression(((WrapInSelectTask)this.getTask()).getProject(), dialect, queryText2, null);
        if (sqlResultSetExpression == null) {
            return null;
        }
        SqlResultSetExpression e2 = sqlResultSetExpression;
        if (Intrinsics.areEqual((Object)((WrapInSelectTask)this.getTask()).getColumns(), (Object)CountAll.INSTANCE) && (queryExpression = this.findQuery(e2)) != null && (offset = this.buildOptimizedCountQuery(builder, queryExpression, queryText2)) != null) {
            String string2 = builder.getStatement();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getStatement(...)");
            return new WrapInSelectResult(string2, offset);
        }
        builder.keyword("SELECT").space();
        DmlUtilKt.dmlGenerator(this.dbms).generate(DmlTaskKt.queryColumns(((WrapInSelectTask)this.getTask()).getColumns()).table(((WrapInSelectTask)this.getTask()).getTable()).alias(DmlTaskKt.getTableAlias(this.getTask())).build(builder));
        builder.space().keyword("FROM").space().symbol("(");
        int currentHeadLength = builder.length();
        String string3 = DmlTaskKt.getTableAlias(this.getTask());
        if (string3 == null) {
            string3 = "t";
        }
        int offset2 = currentHeadLength + this.appendWrappedQueryTail(builder, e2, queryText2, string3);
        WhereClause whereClause2 = ((WrapInSelectTask)this.getTask()).getWhereClause();
        if (whereClause2 != null) {
            it2 = whereClause2;
            boolean bl = false;
            DmlUtilKt.space(builder, DmlTaskKt.insertNewLines(this.getTask()));
            UtilKt.generateWhere(this.dbms, (WhereClause)it2, builder, this.getTask(), true);
        }
        OrderBy orderBy = ((WrapInSelectTask)this.getTask()).getOrderBy();
        if (orderBy != null) {
            it2 = orderBy;
            boolean bl = false;
            DmlUtilKt.space(builder, DmlTaskKt.insertNewLines(this.getTask()));
            UtilKt.generateOrderBy((OrderBy)it2, builder, true);
        }
        String string4 = builder.getStatement();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getStatement(...)");
        return new WrapInSelectResult(string4, offset2);
    }

    private final String removeOrderByClause(Project project, String query, SqlLanguageDialect dialect) {
        SqlResultSetExpression sqlResultSetExpression = DbSqlUtilCore.parseSqlQueryResultSetExpression(project, dialect, query, null);
        if (sqlResultSetExpression == null) {
            return query;
        }
        SqlResultSetExpression e2 = sqlResultSetExpression;
        SqlQueryExpression queryExpression = this.findQuery(e2);
        SqlOrderByClause sqlOrderByClause = (SqlOrderByClause)PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)queryExpression), SqlOrderByClause.class);
        if (sqlOrderByClause == null) {
            return query;
        }
        SqlOrderByClause clause = sqlOrderByClause;
        String string = query.substring(0, clause.getTextRange().getStartOffset());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String string2 = query.substring(clause.getTextRange().getEndOffset());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        String queryText2 = string + string2;
        String string3 = StringUtil.trimEnd((String)queryText2, (String)" ");
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"trimEnd(...)");
        return string3;
    }

    private final SqlQueryExpression findQuery(SqlResultSetExpression e2) {
        SqlExpression sqlExpression;
        SqlResultSetExpression sqlResultSetExpression = e2;
        return sqlResultSetExpression instanceof SqlWithQueryExpression ? ((sqlExpression = ((SqlWithQueryExpression)e2).getExpression()) instanceof SqlQueryExpression ? (SqlQueryExpression)sqlExpression : null) : (sqlResultSetExpression instanceof SqlQueryExpression ? (SqlQueryExpression)e2 : null);
    }

    private final int appendWrappedQueryTail(DdlBuilder head, SqlResultSetExpression e2, String query, String alias) {
        boolean needSelectTargetAliases = head.getDialect().getDbms().isMicrosoft();
        int placeholdersOffset = 0;
        if (needSelectTargetAliases) {
            IntArrayList endOffsets = new IntArrayList();
            for (SqlSelectClause selectClause : SyntaxTraverser.psiTraverser((PsiElement)((PsiElement)e2)).filter(SqlSelectClause.class)) {
                for (SqlExpression expression : selectClause.getExpressions()) {
                    if (expression instanceof SqlAsExpression || expression instanceof SqlReferenceExpression) continue;
                    endOffsets.add(expression.getTextRange().getEndOffset());
                }
            }
            CollectionsKt.sort((List)((List)endOffsets));
            int prevIdx = 0;
            int count = 0;
            int len = endOffsets.size();
            for (int i2 = 0; i2 < len; ++i2) {
                int offset = endOffsets.getInt(i2);
                String string = query.substring(prevIdx, offset);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                head.plain(string);
                String name2 = "_" + ++count;
                placeholdersOffset += name2.length();
                head.space().columnRef(name2);
                prevIdx = offset;
            }
            String string = e2.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            String string2 = string.substring(prevIdx);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            head.plain(string2);
        } else {
            head.plain(query);
        }
        head.symbol(")").space().alias(alias);
        return placeholdersOffset;
    }

    /*
     * WARNING - void declaration
     */
    private final Integer buildOptimizedCountQuery(DdlBuilder builder, SqlQueryExpression query, String queryText2) {
        boolean canOptimize;
        SqlSelectClause selectClause;
        block9: {
            void $this$all$iv;
            SqlSelectClause sqlSelectClause = query.getSelectClause();
            if (sqlSelectClause == null) {
                return null;
            }
            selectClause = sqlSelectClause;
            for (SqlSelectOption option : selectClause.getOptions()) {
                if (!StringUtil.startsWithIgnoreCase((String)option.getOptionName(), (String)"DISTINCT") && option.getClause() == null) continue;
                return null;
            }
            SqlTableExpression sqlTableExpression = query.getTableExpression();
            if (sqlTableExpression == null) {
                return null;
            }
            SqlTableExpression tableExp = sqlTableExpression;
            JBIterable jBIterable = SqlImplUtil.sqlChildren((PsiElement)tableExp).filter(SqlClause.class);
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
            Iterable iterable = (Iterable)jBIterable;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                v3 = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    SqlClause it2 = (SqlClause)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it2);
                    if (this.clauseSupportsOptimizedCount(it2)) continue;
                    v3 = false;
                    break block9;
                }
                v3 = canOptimize = true;
            }
        }
        if (!canOptimize) {
            return null;
        }
        List list = selectClause.getExpressions();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getExpressions(...)");
        List expressions2 = list;
        for (SqlExpression e2 : expressions2) {
            if (((SyntaxTraverser)SyntaxTraverser.psiTraverser().withRoot((Object)e2)).preOrderDfsTraversal().filter(SqlFunctionCallExpression.class).isEmpty()) continue;
            return null;
        }
        SqlExpression firstExpression = (SqlExpression)ContainerUtil.getFirstItem((List)expressions2);
        SqlExpression lastExpression = (SqlExpression)ContainerUtil.getLastItem((List)expressions2);
        if (firstExpression == null || lastExpression == null) {
            return null;
        }
        int expressionsStartOffset = firstExpression.getTextRange().getStartOffset();
        int expressionsEndOffset = lastExpression.getTextRange().getEndOffset();
        DdlBuilder ddlBuilder = builder.clear();
        String string = queryText2.substring(0, expressionsStartOffset);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        DdlBuilder ddlBuilder2 = ddlBuilder.plain(string).keyword("COUNT").symbol("(").symbol("*").symbol(")");
        String string2 = queryText2.substring(expressionsEndOffset);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        ddlBuilder2.plain(string2);
        return builder.length() - queryText2.length();
    }

    protected boolean clauseSupportsOptimizedCount(@NotNull SqlClause clause) {
        Intrinsics.checkNotNullParameter((Object)clause, (String)"clause");
        IElementType type = PsiTreeUtilKt.getElementType((PsiElement)((PsiElement)clause));
        return Intrinsics.areEqual((Object)type, (Object)SqlCompositeElementTypes.SQL_FROM_CLAUSE) || Intrinsics.areEqual((Object)type, (Object)SqlCompositeElementTypes.SQL_WHERE_CLAUSE);
    }
}

